{$I+,S+}
unit t_editor;

interface

uses crt,modem,records,strunit,inout,windows;

function run_editor (m:msgrec; title:boolean):boolean;

implementation

function run_editor (m:msgrec; title:boolean):boolean;
  var done,pause:boolean;
      cols,curline:integer;
      s:string[80];

    procedure init;
    begin
      done:=false;
      s:='';
      cols:=79;
      curline:=1;
      if ansi then clearscreen else nl;
      header (bbsname+' Version '+bbsver+' Message Editor');
      sendwrite (^Y'Title'^X': '^Z);
      sendwritelncolor (m.subject);
      sendwriteln (^Y'Receiver'^X': '^Z+m.receiver);
      sendwriteln (^Y'Lines available'^X': '^Z+strr (maxlines));
      nl;
    end;

    function blank_message:boolean;
    begin
      if m.numlines>0 then blank_message:=false else begin
        sendwriteln (^Y'Message is blank!');
        blank_message:=true;
      end;
    end;

    procedure del_lines (first,last:integer);
      var i,ii:integer;
    begin
      i:=last-first+1;
      dec (m.numlines,i);
      for ii:=first to m.numlines do m.text[ii]:=m.text[ii+i];
    end;

    procedure ins_lines (first,last:integer);
      var i,ii:integer;
    begin
      i:=last-first+1;
      inc (m.numlines,i);
      for ii:=m.numlines downto last+1 do m.text[ii]:=m.text[ii-i];
    end;

    procedure insert_line (s:string);
      var i:integer;
    begin
      if m.numlines=maxlines then exit;
      ins_lines (curline,curline);
      m.text[curline]{^}:=s;
      inc (curline);
    end;

    procedure topofmsg;
    begin
      sendwriteln (^X'['^Y'Top of message'^X']');
    end;

    procedure abort_message;
    begin
      done:=doyesno ('Abort message?');
      if done then run_editor:=false;
    end;

    procedure previous_line;
    begin
      if m.numlines<1 then topofmsg else begin
        sendwriteln (^X'['^Y'Previous line'^X']');
        dec (curline);
        del_lines (curline,curline);
      end;
    end;

    procedure cont_message;
    begin
      sendwriteln (^M^Y'Continue message'^X':');
      curline:=m.numlines+1;
    end;

    function getrange (var lo,hi:integer):boolean;
    begin
      range (m.numlines,lo,hi);
      getrange:=lo<>0;
    end;

    function getlinenum (txt:string; var i:integer):boolean;
      var ii:integer;
    begin
      prompt (^Y'Line # to '+txt+^X': ');
      i:=valu (input);
      ii:=i;
      if (i>=1) and (i<=m.numlines) then getlinenum:=true else begin
        getlinenum:=false;
        sendwriteln (^Y'Invalid line!');
      end;
    end;

    procedure delete_lines;
      var i,ii:integer;
    begin
      if not getrange (i,ii) then exit;
      if (i=1) and (ii=m.numlines) then begin
        if not doyesno ('Delete whole message?') then exit;
      end;
      del_lines (i,ii);
    end;

    procedure fixline;
      var i:integer;
    begin
      if not getlinenum ('fix',i) then exit;
      sendwriteln (^Y'Line currently reads'^X':');
      sendwriteln (m.text[i]{^}+^M);
      inlen:=cols;
      prompt (^Y'Enter new line'^X':'^M);
      if length (input)<>0 then m.text[i]{^}:=input;
      cont_message;
    end;

    procedure insertlines;
      var i:integer;
    begin
      if not getlinenum ('insert before',i) then cont_message;
      curline:=i;
    end;

    procedure list_message;
      var i,ii,iii:integer;
          line_num:boolean;
    begin
      if blank_message then exit;
      range (m.numlines,i,ii);
      if i=0 then exit;
      line_num:=doyesno ('Line numbers?');
      sendwrite (^Y);
      for iii:=i to ii do begin
        if line_num then sendwriteln (^Y+strr (iii)+^X':');
        sendwriteln (^Y+m.text[iii]{^});
        if charready then exit;
      end;
    end;

    procedure centerline;
      var spaces:string[80];
    begin
      fillchar (spaces[1],80,32);
      inlen:=cols;
      prompt (^Y'Enter line to center'^X':'^M);
      while (length (input)>0) and (input[1]=' ') do delete (input,1,1);
      if length (input)=0 then exit;
      spaces[0]:=chr ((cols-length (input)) div 2);
      input:=spaces+input;
      insert_line (input);
    end;

    procedure clearmes;
    begin
      if doyesno ('Are you sure?') then begin
        sendwriteln (^Y'Starting message over.');
        m.numlines:=0;
        curline:=1;
      end;
    end;

    procedure searchandreplace;
      var sfor,repw:string[80];
          l:^string;
          ask:boolean;
          cl,cp,sl,max:integer;

        procedure replace;
          var new,old:string[80];
        begin
          old:=copy (l^,cp,sl);
          new:=repw;
          if length (new)>0 then if old[1] in ['A'..'Z'] then new[1]:=upcase (new[1]);
          delete (l^,cp,sl);
          while length(l^)+length(new)>cols do l^[0]:=pred(l^[0]);
          insert (new,l^,cp);
          cp:=cp+length(new)-1;
        end;

        procedure maybereplace;
          var i:integer;
        begin
          if ask then begin
            sendwriteln (^M^Y+strr (cl)+^X':'^M^Y+l^);
            for i:=1 to cp-1 do sendwrite (' ');
            for i:=1 to sl do sendwrite ('^');
            nl;
            if not doyesno ('Replace?') then exit;
          end;
          replace;
        end;

    begin
      if blank_message then exit;
      prompt (^Y'Search for'^X': ');
      if length (input)=0 then exit;
      sfor:=uppercase (input);
      sl:=length (input);
      prompt (^Y'Replace with'^X': ');
      repw:=input;
      ask:=doyesno ('Ask each time?');
      max:=length (l^)-sl+1;
      for cl:=1 to m.numlines do begin
        l:=addr (m.text[cl]);
        max:=length (l^)-sl+1;
        cp:=0;
        while cp<max do begin
          cp:=cp+1;
          if match (sfor,copy (l^,cp,sl)) then maybereplace;
          max:=length (l^)-sl+1;
        end;
      end;
      sendwriteln (^M'Search and replace complete.');
    end;

    procedure savemes;
    begin
      done:=true;
      if m.numlines=0 then sendwriteln (^Y'Message blank!') else begin
        sendwriteln (^Y'Saving message.');
        run_editor:=true;
      end;
    end;

    procedure retitle;
    begin
      if title then begin
        sendwrite (^Y'Title'^X': '^Z);
        sendwritelncolor (m.subject);
        prompt (^Y'Enter new title'^X': ');
        if length (input)>0 then m.subject:=input;
      end else sendwriteln (^Y'This message can''t have a title.');
    end;

    procedure edithelp;
    begin
     {printfile (configset.textfiledi+'Edithelp.');}
   (*   clearscreen;
      sendwriteln (^Y'A-Abort Message  B-Previous Line   C-Continue Message');
      sendwriteln (^Y'D-Delete Lines   E-Set Edit Mode   F-Fix Line');
      sendwriteln (^Y'I-Insert Lines   L-Show Message    M-Center Line');
      sendwriteln (^Y'N-Clear Message  R-Search/Replace  S-Save Message');
      sendwriteln (^Y'T-Re-enter Title');
      nl;*)
    end;

    function iseditcommand (s:string):boolean;
    begin
      iseditcommand:=(s[1]='/') and (length (s)>0);
    end;

    procedure editcommand (s:string);
      var c:char;
    begin
      while iseditcommand (s) and (length (s)>0) do delete (s,1,1);
      if length (s)=0 then exit;
      c:=upcase (s[1]);
      case c of
        'A':abort_message;
        'B':previous_line;
        'C':cont_message;
        'D':delete_lines;
        'F':fixline;
        'I':insertlines;
        'L':list_message;
        'M':centerline;
        'N':clearmes;
        'R':searchandreplace;
        'S':savemes;
        'T':retitle;
        else edithelp;
      end;
    end;

  procedure editcommands (ss:string);
  begin
    editcommand (ss);
    while not done do begin
      prompt (^Y'Command '^X'['^Z'?'^X'/'^Y'Help'^X']: ');
      if not online then done:=true else editcommand (input);
    end;
  end;

  procedure getline (var ss:string);
    var b:boolean;
        c:char;
        i:integer;
  begin
    ss:='/E';
    if m.numlines=maxlines then begin
      sendwriteln (^Y'Sorry, message is full!');
      exit;
    end;
    if not online then exit;
    if m.numlines=maxlines-2 then sendwriteln ('Two lines left!');
    if curline>m.numlines+1 then curline:=m.numlines+1;
    lastprmpt:=^Y'Continue your message.'^M;
    inlen:=cols;
    recv;
    ss:=input;
  end;

  procedure getlines (var ss:string);
  begin
    repeat
      getline (input);
      if not iseditcommand (input) then begin
        inc (m.numlines);
        m.text[m.numlines]{^}:=input;
      end;
    until not online or iseditcommand (input) or (m.numlines=maxlines);
    if not iseditcommand (input) then input:='/';
    ss:=input;
  end;

begin
  pause:=user.pause;
  user.pause:=false;
  init;
  repeat
    getlines (s);
    editcommands (s);
  until done;
  user.pause:=pause;
  nl;
  statusline (0);
end;

end.