{$I+,S+}
(******************************************************************************
     XTC Fossil Communications Routines - Fossil Revision 5 1988 Specifications
     courtesy of Rick Moore
     3/9/93 by Roland
 ******************************************************************************)
UNIT modem;

INTERFACE

USES dos, crt;

CONST
  usefossil:boolean = FALSE;

var
  fosport:byte;
  regs:registers;

procedure com_set_baud(baud:word; parity:char; bits:byte; stopbits:byte);
procedure com_tx(c:char);
procedure com_tx_string(s:string);
function com_rx:char;
function com_rx_empty:boolean;
function com_tx_ready: boolean;
function com_tx_empty:boolean;
function com_CD:boolean;
procedure com_init(comport:word);
procedure com_deinit;
procedure com_lower_dtr;
procedure com_raise_dtr;
{procedure com_hangup;}
procedure hangup;
procedure com_flush_tx;
procedure com_purge_tx;
procedure com_purge_rx;
procedure com_watchdog(state:boolean);

IMPLEMENTATION

procedure com_set_baud(baud:word; parity:char; bits:byte; stopbits:byte);
begin
  if usefossil then begin
    regs.ah:=$00;               {Set Baud Rate}
    case baud of
      300:regs.al:=64;
      600:regs.al:=96;
      1200:regs.al:=128;
      2400:regs.al:=160;
      4800:regs.al:=192;
      9600:regs.al:=224;
      19200:regs.al:=0;
      38400:regs.al:=32;
    else regs.al:=0;
    end;

    case upcase(parity) of
      'O':inc(regs.al,8);
      'E':inc(regs.al,24);
    end;

    case bits of
      6:inc(regs.al,1);
      7:inc(regs.al,2);
      8:inc(regs.al,3);
    end;

    case stopbits of
      2:inc(regs.al,4);
    end;

    regs.dx:=fosport;
    intr($14,regs);
  end;
end;

procedure com_tx(c:char);
begin
  if usefossil then begin
    asm
      mov ah,1 {regs.ah:=$01;               Transmit character with wait}
      mov al,c {regs.al:=ord(c);}
      xor dh,dh
      mov dl,fosport {regs.dx:=fosport;}
      int $14 {intr($14,regs);}
    end;
  end;
end;


procedure com_tx_string(s:string);
var i:integer;
begin
  for i:=1 to length(s) do com_tx(s[i]);
end;

function com_rx:char;
begin
  if usefossil then begin
    if (com_rx_empty) then com_rx:=#0
    else begin
      asm
        mov ah,2 {regs.ah:=$02;             Receive character with wait}
        xor dh,dh
        mov dl,fosport {regs.dx:=fosport;}
        int $14 {intr($14,regs);}
        mov @Result,al { com_rx:=chr(regs.al);}
      end;
    end;
  end;
end;

function com_rx_empty:boolean;
begin
  if usefossil then begin
    regs.ah:=$0C;               {Non Destructive Read Ahead}
    regs.dx:=fosport;
    intr($14,regs);
    com_rx_empty:=(regs.ax = $FFFF);
  end;
end;

function com_tx_ready: boolean;
begin
  if usefossil then begin
    regs.dx:=fosport;
    regs.ah:=$03;               {Request Status: TSRE - output buffer avail}
    intr($14,regs);
    com_tx_ready:=((regs.ah and 32)=32);
  end;
end;

function com_tx_empty:boolean;
begin
  if usefossil then begin
    regs.dx:=fosport;
    regs.ah:=$03;               {Request Status: TSRE - output buffer empty}
    intr($14,regs);
    com_tx_empty:=((regs.ah and 64)=64);
  end;
end;

function com_CD:boolean;
begin
  if usefossil then begin
    regs.ah:=$03;               {Request Status: DCD - Detect Carrier}
    regs.dx:=fosport;
    intr($14,regs);
    com_CD:=((regs.al and 128) = 128);
  end;
end;

procedure com_init(comport:word);
begin
  if (not usefossil) then begin
    regs.ah:=4;                {Initialize Fossil Driver}
    usefossil:=FALSE;
    fosport:=comport-1;
    regs.dx:=fosport;
    regs.bx:=0;
    intr($14,regs);
    if (regs.ax = $1954) then begin
      usefossil:=TRUE;
      regs.ah:=15;             {Flow Control}
      regs.al:=255;            {All Flow Control On}
      intr($14,regs);
    end else begin
      clrscr; textcolor(14);
      Writeln(^G+'Please load a fossil driver!');
      halt(1);
    end;
  end;
end;

procedure com_deinit;
begin
  if usefossil then begin
    usefossil:=FALSE;
    regs.ah:=5;               {Deinitialize driver}
    regs.dx:=fosport;
    intr($14,regs);
  end;
end;

procedure com_lower_dtr;
begin
  if usefossil then begin
    regs.ah:=6;               {Lower DTR}
    regs.dx:=fosport;
    regs.al:=0;
    intr($14,regs);
  end;
end;

procedure com_raise_dtr;
begin
  if usefossil then begin
    regs.ah:=6;               {Raise DTR}
    regs.dx:=fosport;
    regs.al:=1;
    intr($14,regs);
  end;
end;

procedure hangup;
begin
  if usefossil then begin
    com_lower_dtr;
    delay (700);
    com_raise_dtr;
    if com_CD then com_TX_string ('+++');
  end;
end;

procedure com_flush_tx;
begin
  if usefossil then begin
    regs.ah:=8;               {Flush output buffer}
    regs.dx:=fosport;
    intr($14,regs);
  end;
end;

procedure com_purge_tx;
begin
  if usefossil then begin
    regs.ah:=9;               {Purge output buffer}
    regs.dx:=fosport;
    intr($14,regs);
  end;
end;

procedure com_purge_rx;
begin
  if usefossil then begin
    regs.ah:=10;               {Purge receiving buffer}
    regs.dx:=fosport;
    intr($14,regs);
  end;
end;

procedure com_watchdog(state:boolean);
begin
  If usefossil then begin
    regs.ah:=20;                        {Watchdog Processing}
    regs.al:=0;
    if (state) then regs.al:=1;
    regs.dx:=fosport;
    intr($14,regs);
  end;
end;

end.