{$I+,S+}
unit main;

interface

uses crt,dos,awf,inout,mdm,modem,records,strunit,usermisc,xfer,msgbase,{voting,}
     execswap,winttt5,keyttt5,qwk,inp;

const {colorstr:array [0..7] of string[7]=
        ('Black','Blue','Green','Cyan','Red','Magenta','Brown','White');}
      onoff:array[false..true] of string[3]=('OFF','ON ');

var menufile:text;
    menu:array [1..100] of menurec;
    nummenu:integer;
    characc:array [1..100] of {smstr}string[1];
    msubject:medstr;

{procedure findnummail;}
function passwrd (var user:userrec):boolean;
procedure addlastcaller (s:string);
procedure changeconf (b:boolean; c:char);
procedure changeuser;
procedure chatcall;
procedure statscreen;
procedure userconfig;
procedure mainmenu;
procedure runmenu (menuname:string);
procedure setdefcolors (var userr:userrec);
procedure addtoblacklist (s:string);
function findblacklist (s:string):boolean;
procedure deleteblacklist (s:string);
procedure blacklist;
procedure phonesearch;
procedure togglechat;
procedure interview (usr,intvwnum:integer);
procedure showiv (usr,intvwnum:integer);
procedure promptedit;
procedure ivedit;
procedure openiv;
procedure closeiv;
function numiv:byte;
procedure seekiv (b:byte);
function acc:boolean;
procedure interviews;
procedure addnuv (user:userrec; usernm:integer);
procedure removenuv (var location:integer);
procedure opennuvf;
procedure closenuvf;
procedure newuservoting (login:boolean);
procedure listpending;

implementation

procedure replace (var main:string; old,new:string);
  var p : byte;
begin
  repeat
    p:=pos (old,main);
    if p<>0 then begin
      delete (main,p,length(old));
      insert (new,main,p);
    end;
  until p=0;
end;

procedure filterprompt (var s:string);
begin
  replace (s,'^W',^W);
  replace (s,'^X',^X);
  replace (s,'^Y',^Y);
  replace (s,'^Z',^Z);
  replace (s,'@USERN',user.handle);
  replace (s,'@USER#',strr (usernum));
  replace (s,'@BBS',setup.sysname);
  replace (s,'@SYSOP',sysopname);
  replace (s,'@MS',msubject);
  replace (s,'@NODE#',strr (setup.nodenum));
  replace (s,'@M',^M);
  replace (s,'@T',strr (timeleft));
  replace (s,'@C1',strr (curconf));
  replace (s,'@C2',curconfname);
  {replace (s,'@B1',strr (curmsgarea));
  replace (s,'@B2',curmareaname);}
  {replace (s,'@F1',strr (curarea));
  replace (s,'@F2',curareaname);}
end;

procedure assignprompt;
begin
  assign (promptf,setup.datadir+'PROMPT.DAT');
end;

procedure openprompt;
begin
  assignprompt;
  {$I-}reset (promptf);{$I+}
  if ioresult<>0 then {$I-}rewrite (promptf);{$I+}
end;

procedure closeprompt;
begin
  close (promptf);
end;

function numprompt:byte;
begin
  numprompt:=filesize (promptf);
end;

procedure seekprompt (b:byte);
begin
  seek (promptf,b-1);
end;

procedure listprompt;
  var b:byte;
begin
  openprompt;
  if numprompt>0 then begin
    header ('Prompt Listing');
    for b:=1 to numprompt do begin
      seekprompt (b);
      read (promptf,prmpt);
      sendwriteln (^X'['^Z+strr (b)+^X'] '^Y+prmpt.name);
    end;
    nl;
  end;
  closeprompt;
end;

function getpromptnum:byte;
  var b:byte;
begin
  getpromptnum:=0;
  inlen:=3;
  prompt ('Prompt #'^X': ');
  b:=valu (input);
  if (b>0) and (b<=numprompt) then getpromptnum:=b;
end;

procedure listcommands;
begin
  sendwriteln (^M^Z'^W'^X': '^Y'Color #1  '^Z'^X'^X': '^Y'Color #2  '^Z'^Y'^X': '^Y'Color #3  '
  +^Z'^Z'^X': '^Y'Color #4');
  sendwriteln (^M^Z'^A'^X': '^Y'Color #5  '^Z'^B'^X': '^Y'Color #6  '^Z'^N'^X': '^Y'Color #7  '
  +^Z'^O'^X': '^Y'Color #8');
  sendwriteln (^Z'@USERN'^X': '^Y'User Handle  '^Z'@USER#'^X': '^Y'User Number  '^Z'@BBS'^X': '^Y'BBS Name');
  sendwriteln (^Z'@SYSOP'^X': '^Y'Sysop Name  '^Z'@MS'^X': '^Y'Menu Subject  '^Z'@NODE#'^X': '^Y'Node Number');
  sendwriteln (^Z'@M'^X': '^Y'Enter  '^Z'@T'^X': '^Y'Time Left  '^Z'@C1'^X': '^Y'Conference Name  '^Z'@C2'
  +^X': '^Y'Conference #'^M);
end;

procedure edprompt (b:byte);
  var c:char;
      prmp1,prmp2:longstr;
begin
  openprompt;
  seekprompt (b);
  read (promptf,prmpt);
  closeprompt;
  repeat
    clearscreen;
    header ('Prompt Editing/Adding');
    sendwriteln (^X' ['^Z'A'^X']'^Y' Name'^X': '^Z+prmpt.name);
    sendwriteln (^X' ['^Z'B'^X']'^Y' Prompt Line #1'^X':');
    sendwriteln (^Z+prmpt.prmpt1);
    sendwriteln (^X' ['^Z'C'^X']'^Y' Prompt Line #2'^X':');
    sendwriteln (^Z+prmpt.prmpt2);
    sendwriteln (^X' ['^Z'V'^X']'^Y' View Prompt'^M);
    sendwrite (^Y'Command'^X': '^Y);
    c:=upcase (shinchar);
    case c of
      'A':inputstr ('Name of Prompt',prmpt.name,30);
      'B':begin
            listcommands;
            inputstr ('Prompt Line #1',prmpt.prmpt1,79);
          end;
      'C':begin
            listcommands;
            inputstr ('Prompt Line #2',prmpt.prmpt2,79);
          end;
      'V':begin
            prmp1:=prmpt.prmpt1;
            prmp2:=prmpt.prmpt2;
            filterprompt (prmp1);
            filterprompt (prmp2);
            if length (prmp1)>0 then sendwriteln (prmp1);
            if length (prmp2)>0 then sendwriteln (prmp2);
            nl;
            pause;
          end;
    end;
  until (c='Q') or not online;
  nl;
  openprompt;
  seekprompt (b);
  write (promptf,prmpt);
  closeprompt;
end;

procedure editprompt;
  var b:byte;
begin
  openprompt;
  b:=getpromptnum;
  closeprompt;
  if b>0 then begin
    writesysoplog ('Edited prompt #'+strr (b),user.handle);
    edprompt (b);
  end;
end;

procedure addprompt;
  var b:byte;
begin
  prmpt.name:='New Prompt';
  prmpt.prmpt1:='';
  prmpt.prmpt2:='';
  openprompt;
  b:=numprompt+1;
  seekprompt (b);
  write (promptf,prmpt);
  closeprompt;
  writesysoplog ('Added prompt #'+strr (b),user.handle);
  edprompt (b);
end;

procedure deleteprompt;
  var b,bb:byte;
begin
  openprompt;
  b:=getpromptnum;
  if b>0 then begin
    if doyesno ('Are you sure?') then begin
      sendwriteln (^Y'Deleting prompt.');
      for bb:=b to numprompt-1 do begin
        seekprompt (bb+1);
        read (promptf,prmpt);
        seekprompt (bb);
        write (promptf,prmpt);
      end;
      seekprompt (numprompt);
      truncate (promptf);
      writesysoplog ('Deleted prompt #'+strr (b),user.handle);
    end;
  end;
  closeprompt;
end;

procedure promptedit;
  var c:char;
begin
  clearscreen;
  listprompt;
  repeat
    sendwrite (^Y'Prompts'^X': '^Z'A'^Y'dd  '^Z'D'^Y'elete  '^Z'E'^Y'dit  '^Z'L'^Y'ist  '^Z'Q'^Y'uit'^X': '^Y);
    c:=upcase (shinchar);
    case c of
      'A':addprompt;
      'D':deleteprompt;
      'E':editprompt;
      'L':listprompt;
    end;
  until (c='Q') or not online;
end;

{ Interview until  }

procedure assignintvwf (curintvw:integer);
begin
  assign (intvwf,setup.msgdir+'INTVW'+strr (curintvw)+'.ASW');
end;

procedure openintvwf (curintvw:integer);
begin
  assignintvwf (curintvw);
  {$I-}reset (intvwf);{$I+}
  if ioresult<>0 then {$I-}rewrite (intvwf);{$I+}
end;

procedure closeintvwf;
begin
  close (intvwf);
end;

procedure readiidxf (var b:boolean; var user:integer; i:integer);
  var iidx:intvwidx;
begin
  seek (iidxf,i-1);
  read (iidxf,iidx);
  b:=iidx.active;
  user:=iidx.usernum;
end;

procedure writeiidxf (b:boolean; user,i:integer);
  var iidx:intvwidx;
begin
  seek (iidxf,i-1);
  iidx.active:=b;
  iidx.usernum:=user;
  write (iidxf,iidx);
end;

function numiidxf:integer;
begin
  numiidxf:=filesize (iidxf);
end;

procedure readnextiv (show:boolean);
  label exit;
  var c:char;
begin
  while not eof (intvwf) do begin
    read (intvwf,c);
    case c of
      '':goto exit;
      else if show then sendwrite (c);
    end;
  end;
  exit:
end;

procedure readiv (usernum:integer);
  label exit;
  var b,bb:boolean;
      i,us:integer;
begin
  i:=0;
  while not eof (intvwf) do begin
    inc (i);
    readiidxf (b,us,i);
    bb:=(us=usernum) and b;
    readnextiv (bb);
    if bb then goto exit;
  end;
  exit:
  if not bb then sendwrite (^M^Y'Interview does not exist for this user!'^M^M);
end;

procedure interview (usr,intvwnum:integer);
  var b:boolean;
      c:char;
      i,us,x,y:integer;
      t:text;
begin
  if user.intvw[intvwnum] then begin
    if not doyesno ('Overwrite interview #'+strr (intvwnum)+'?') then exit else begin
      openiidxf (intvwnum);
      i:=0;
      while i<numiidxf do begin
        inc (i);
        readiidxf (b,us,i);
        if us=usr then if b then writeiidxf (false,us,i);
      end;
      closeiidxf;
    end;
  end;
  assign (t,setup.textdir+'INTVW.'+strr (intvwnum));
  {$I-}reset (t);{$I+}
  sendwrite (^M^Y);
  if ioresult<>0 then sendwrite ('File not found.'^M) else begin
    openintvwf (intvwnum);
    {$I-}append (intvwf);{$I+}
    while not eof (t) do begin
      read (t,c);
      if c='*' then begin
        x:=wherex+1;
        y:=wherey;
        recv;
        sendxy (x,y,'');
        write (intvwf,input);
      end else begin
        sendwrite (c);
        write (intvwf,c);
      end;
    end;
    close (t);
    write (intvwf,'');
    closeintvwf;
    openiidxf (intvwnum);
    writeiidxf (true,usr,numiidxf+1);
    closeiidxf;
    user.intvw[intvwnum]:=true;
    writeuser (user,usernum);
  end;
end;

procedure showiv (usr,intvwnum:integer);
  var b:boolean;
      i,us:integer;
begin
  openintvwf (intvwnum);
  openiidxf (intvwnum);
  readiv (usr);
  closeintvwf;
  closeiidxf;
  sendxy (1,24,'');
end;

procedure assigniv;
begin
  assign (intervwf,setup.datadir+'INTERVW.DAT');
end;

procedure openiv;
begin
  assigniv;
  {$I-}reset (intervwf);{$I+}
  if ioresult<>0 then {$I-}rewrite (intervwf);{$I+}
end;

procedure closeiv;
begin
  close (intervwf);
end;

function numiv:byte;
begin
  numiv:=filesize (intervwf);
end;

procedure seekiv (b:byte);
begin
  seek (intervwf,b-1);
end;

procedure listiv;
  var b:byte;
begin
  openiv;
  if numiv>0 then begin
    nl;
    header ('Interviews');
    for b:=1 to numiv do begin
      seekiv (b);
      read (intervwf,intervw);
      sendwrite (^X'['^Z+strr (b)+^X'] '^Y);
      spacewrite (intervw.name,30);
      if intervw.req then sendwrite (^Z'Required  ');
      sendwriteln (^Z+strr (intervw.min)+^Y' to '^Z+strr (intervw.max));
    end;
    nl;
  end;
  closeiv;
end;

function getivnum:byte;
  var b:byte;
begin
  getivnum:=0;
  inlen:=3;
  prompt ('Interview #'^X': ');
  b:=valu (input);
  if (b>0) and (b<=numiv) then getivnum:=b;
end;

procedure ediv (b:byte);
  var c:char;
begin
  openiv;
  seekiv (b);
  read (intervwf,intervw);
  closeiv;
  repeat
    clearscreen;
    header ('Interview Editing/Adding');
    sendwriteln (^X' ['^Z'A'^X']'^Y' Name'^X': '^Z+intervw.name);
    sendwriteln (^X' ['^Z'B'^X']'^Y' Required'^X': '^Z+boostr (intervw.req));
    sendwriteln (^X' ['^Z'C'^X']'^Y' Minimum Level'^X': '^Z+strr (intervw.min));
    sendwriteln (^X' ['^Z'D'^X']'^Y' Maximum Level'^X': '^Z+strr (intervw.max)+^M);
    sendwrite (^Y'Command'^X': '^Y);
    c:=upcase (shinchar);
    case c of
      'A':inputstr ('Name of Interview',intervw.name,30);
      'B':intervw.req:=doyesno ('Interview Required?');
      'C':inputbyte ('Minimum Level',intervw.min,3,0,maxlevel);
      'D':inputbyte ('Maximum Level',intervw.max,3,0,maxlevel);
    end;
  until (c='Q') or not online;
  nl;
  openiv;
  seekiv (b);
  write (intervwf,intervw);
  closeiv;
end;

procedure editiv;
  var b:byte;
begin
  openiv;
  b:=getivnum;
  closeiv;
  if b>0 then begin
    writesysoplog ('Edited interview #'+strr (b),user.handle);
    ediv (b);
  end;
end;

procedure addiv;
  var b:byte;
begin
  intervw.name:='New Interview';
  intervw.req:=false;
  intervw.min:=0;
  intervw.max:=maxlevel;
  openiv;
  b:=numiv+1;
  seekiv (b);
  write (intervwf,intervw);
  closeiv;
  writesysoplog ('Added interview #'+strr (b),user.handle);
  ediv (b);
end;

procedure deleteiv;
  var b,bb,bbb:byte;
      u:userrec;
begin
  openiv;
  b:=getivnum;
  if b>0 then begin
    if doyesno ('Are you sure?') then begin
      sendwriteln (^Y'Deleting interview.');
      assignintvwf (b);
      {$I-}erase (intvwf);{$I+}if ioresult<>0 then ;
      assigniidxf (b);
      {$I-}erase (iidxf);{$I+}if ioresult<>0 then ;
      for bb:=b to numiv-1 do begin
        seekiv (bb+1);
        read (intervwf,intervw);
        seekiv (bb);
        write (intervwf,intervw);
        assignintvwf (bb+1);
        rename (intvwf,setup.msgdir+'INTVW'+strr (bb)+'.ASW');if ioresult<>0 then ;
        assigniidxf (bb+1);
        rename (iidxf,setup.msgdir+'INTVW'+strr (bb)+'.IDX');if ioresult<>0 then ;
      end;
      seekiv (numiv);
      truncate (intervwf);
      sendwriteln (^Y'Setting user flags.');
      {writeuser (user,usernum);}
      useropen (false);
      for bb:=1 to filesize (userf) do begin
        seek (userf,bb-1);
        read (userf,u);
        for bbb:=b to maxinterview-1 do u.intvw[bbb]:=u.intvw[bbb+1];
        u.intvw[maxinterview]:=false;
        seek (userf,bb-1);
        write (userf,u);
      end;
      useropen (true);
      {readuser (user,usernum);}
      writesysoplog ('Deleted interview #'+strr (b),user.handle);
    end;
  end;
  closeiv;
end;

procedure ivedit;
  var c:char;
begin
  clearscreen;
  listiv;
  repeat
    sendwrite (^Y'Interviews'^X': '^Z'A'^Y'dd  '^Z'D'^Y'elete  '^Z'E'^Y'dit  '^Z'L'^Y'ist  '^Z'Q'^Y'uit'^X': '^Y);
    c:=upcase (shinchar);
    case c of
      'A':addiv;
      'D':deleteiv;
      'E':editiv;
      'L':listiv;
    end;
  until (c='Q') or not online;
end;

function acc:boolean;
begin
  acc:=(user.mlevel>=intervw.min) and (user.mlevel<=intervw.max);
end;

procedure interviews;
  label exit;
  var b,numi,numacc:byte;
      done:boolean;

  procedure listiv;
    var b:byte;
  begin
    openiv;
    if numiv>0 then begin
      nl;
      header ('Interviews');
      for b:=1 to numiv do begin
        seekiv (b);
        read (intervwf,intervw);
        if acc then begin
          sendwrite (^X'['^Z+strr (b)+^X'] '^Y);
          spacewrite (intervw.name,30);
          if intervw.req then sendwrite (^Z'Required  ') else sendwrite (^Z'Not Required  ');
          if user.intvw[b] then sendwrite (^Y'Completed  ') else sendwrite (^Y'Not Completed');
          nl;
        end;
      end;
      nl;
    end;
    closeiv;
  end;

begin
  done:=false;
  openiv;
  numacc:=0;
  for b:=1 to numiv do begin
    seekiv (b);
    read (intervwf,intervw);
    if acc then inc (numacc);
  end;
  closeiv;
  if numacc<1 then goto exit;
  repeat
    clearscreen;
    listiv;
    openiv;
    sendwrite (^Y'Required'^X': '^Z);
    for b:=1 to numiv do begin
      seekiv (b);
      read (intervwf,intervw);
      if intervw.req then sendwrite (strr (b)+' ');
    end;
    numi:=numiv;
    closeiv;
    nl;
    prompt ('Interviews '^X'['^Z'1'^X'-'^Z+strr (b)+^X']: ');
    if upcase (input[1])='Q' then begin
      done:=true;
      openiv;
      for b:=1 to numiv do begin
        seekiv (b);
        read (intervwf,intervw);
        if acc then begin
          if intervw.req and not user.intvw[b] then done:=false;
        end;
      end;
      closeiv;
      if not done then sendwrite (^M^Y'You still have required interviews to fill out!'^M^M);
    end;
    if done then goto exit;
    b:=valu (input);
    if (b>0) and (b<=numi) then begin
      openiv;
      seekiv (b);
      read (intervwf,intervw);
      closeiv;
      if acc then interview (usernum,b);
    end;
  until not online;
  exit:
end;

procedure deluser (i:integer);
  var ii:integer;
      u:userrec;
begin
  if i=0 then begin
    inlen:=30;
    prompt ('User name/number to delete'^X': ');
    ii:=finduser (input);
    if ii=0 then sendwrite (^M^Y'No such user!'^M^M);
  end else ii:=i;
  if ii<>0 then begin
    readuser (u,ii);
    sendwriteln (^M^Y'User Handle'^X': '^Z+u.handle);
    sendwriteln (^Y'Real Name'^X': '^Z+u.realname);
    sendwriteln (^Y'Phone Number'^X': '^Z+u.phone+^M);
    if doyesno ('Are you sure?') then begin
      deleteuser (ii);
      sendwrite (^M^Y'User deleted!'^M^M);
      writesysoplog ('Deleted user #'+strr (ii),user.handle);
    end;
  end;
end;

{procedure findnummail;
  var c:char;
      i,ii,iii,you,priv,new:longint;

    function allowed (i:integer):boolean;
    begin
      if i<>0 then allowed:=user.msgconf[i] else allowed:=true;
    end;

    function matchmail (s:string):boolean;
    begin
      matchmail:=match (post.receiver,s);
    end;

begin
  i:=curconf;
  header (sendwritestr (71));
  sendwrite (^Y);
  spacewrite ('#',5);
  spacewrite ('Name',32);
  spacewrite ('You',6);
  spacewrite ('Priv',6);
  spacewrite ('New',6);
  sendwriteln ('Total');
  writeline (79);
  sendwrite (^Z);
  openconf ('M');
  for ii:=0 to numconf do begin
    you:=0;
    priv:=0;
    new:=0;
    if allowed (ii) then begin
      curconf:=ii;
      if curconf<1 then begin
        spacewrite ('M',5);
        spacewrite ('Main',32);
      end else begin
        seek (conff,ii-1);
        read (conff,conf);
        spacewrite (strr (curconf),5);
        spacewrite (conf.name,32);
      end;
      openpost;
      if numpost>0 then begin
        for iii:=1 to numpost do begin
          seekpost (iii);
          read (postf,post);
          if (matchmail (user.handle)) or (matchmail ('Everyone')) then begin
            inc (you);
            if (matchmail (post.receiver)) and post.priv then inc (priv);
            if iii>user.lastread[curconf][curmsgarea] then inc (new);
          end;
        end;
      end;
      spacewrite (strr (you),6);
      spacewrite (strr (priv),6);
      spacewrite (strr (new),6);
      sendwriteln (strr (numpost));
      closepost;
    end;
  end;
  close (conff);
  curconf:=i;
  nl;
end;}

function passwrd (var user:userrec):boolean;
  var x,y,b:byte;
begin
  passwrd:=true;
  b:=stati;
  x:=wherex;
  y:=wherey;
  mkwin (40,4,76,7,15,1,1);
  textcolor (15);
  textbackground (1);
  gotoxy (42,5);
  write ('User: '+user.handle);
  gotoxy (42,6);
  write ('PW: '+user.password);
  hidchar:=true;
  sendxy (x,y,^M);
  prompt ('Password'^X': ');
  stati:=b;
  if not match (user.password,input) then begin
    passwrd:=false;
    sendwrite (^M^Y'Incorrect.'^M^M);
    writesysoplog ('Wrong password: '+input,user.handle);
  end;
  rmwin;
  nl;
end;

procedure bank;
  var i:integer;

   procedure showinfo;
   begin
     clearscreen;
     header (setup.bankname);
     sendwriteln (^Y'Your bank president is '^Z+sysopname);
     sendwriteln (^Y'Current time in bank'^X': '^Z+strr (user.bankt));
     sendwriteln (^Y'Maximum time in bank'^X': '^Z+strr (setup.maxt));
     sendwriteln (^Y'Current points in bank'^X': '^Z+strr (user.bankc));
     sendwriteln (^Y'Maximum points in bank'^X': '^Z+strr (setup.maxc));
     sendwriteln (^Y'Current loan payment (points)'^X': '^Z+strr (user.bankl));
     sendwriteln (^Y'Maximum loan allowed (points)'^X': '^Z+strr (setup.maxl)+^M);
     sendwriteln (^X'['^Z'1'^X'] '^Y'Deposit Time    '^X'['^Z'3'^X'] '^Y'Withdrawal Time');
     sendwriteln (^X'['^Z'2'^X'] '^Y'Deposit Points  '^X'['^Z'4'^X'] '^Y'Withdrawal Points');
     sendwriteln (^X'['^Z'5'^X'] '^Y'Apply for Loan  '^X'['^Z'6'^X'] '^Y'Pay Loan'^M);
   end;

begin
  writesysoplog ('Entered bank',user.handle);
  showinfo;
  repeat
    prompt ('Command'^X': ');
    input:=uppercase (input);
    if not (input='') then case input[1] of
      '?':showinfo;
      '1':begin
            prompt ('Amount of time to deposit'^X': ');
            if valu (input)<1 then else if valu (input)>100 then sendwriteln (^Y'You may only deposit '^Z'100 '
            +^Y'minutes at a time!'
            ) else begin
              i:=valu (input);
              if user.bankt+i>setup.maxt then sendwriteln (^Y'You may only have '^Z+strr (setup.maxt)+^Y' minutes in the bank!'
              ) else if i>timeleft then sendwriteln (^Y'You don''t have enough time left!') else begin
                inc (user.bankt,i);
                settimeleft (timeleft-i);
              end;
            end;
          end;
      '2':begin
            prompt ('Amount of points to deposit'^X': ');
            if valu (input)<1 then else if valu (input)>100 then sendwriteln (^Y'You may only deposit '^Z'100 '
            +^Y'points at a time!'
            ) else begin
              i:=valu (input);
              if user.bankc+i>setup.maxc then sendwriteln (^Y'You may only have '^Z+strr (setup.maxc)+^Y' points in the bank!'
              ) else if i>user.fpoint then sendwriteln (^Y'You don''t have enough file points!') else begin
                inc (user.bankc,i);
                dec (user.fpoint,i);
              end;
            end;
          end;
      '3':begin
            prompt ('Amount of time to withdrawal'^X': ');
            if valu (input)<1 then else begin
              i:=valu (input);
              if user.bankt-i<0 then sendwriteln (^Y'You may only withdrawal what you have!')
              else begin
                dec (user.bankt,i);
                settimeleft (timeleft+i);
              end;
            end;
          end;
      '4':begin
            prompt ('Amount of points to withdrawal'^X': ');
            if valu (input)<1 then else begin
              i:=valu (input);
              if user.bankc-i<0 then sendwriteln (^Y'You may only withdrawal what you have!')
              else begin
                dec (user.bankc,i);
                inc (user.fpoint,i);
              end;
            end;
          end;
      '5':if not setup.allowloan then begin
            sendwrite (^M^Y'Loans are not allowed on this system!'^M^M);
            exit;
          end else begin
            prompt ('# of points to borrow from bank '^X'['^Y'Maximum'^X': '^Z+strr (setup.maxl)+^X']: ');
            if valu (input)<1 then else if valu (input)>setup.maxl then sendwriteln (^Y'You may only loan '^Z+strr (setup.maxl)
            +^Y'!') else begin
              i:=valu (input);
              if user.bankl+i>setup.maxl then sendwriteln (^Y'You may only have up to a '^Z+strr (setup.maxl)+^Y
              +' point loan!') else if not udpercent then sendwriteln (
              ^Y'Upload/Download Percent is unacceptable!  Please'
              +' upload more!') else if not pcpercent then sendwriteln (
              ^Y'Post/Call Percent is unacceptable!  Please post'
              +' more!') else begin
                inc (user.bankl,i);
                inc (user.fpoint,i);
              end;
            end;
          end;
      '6':if not setup.allowloan then begin
            sendwrite (^M^Y'Loans are not allowed on this system!'^M^M);
            exit;
          end else begin
            prompt ('Amount of loan to pay '^X'['^Y'Maximum'^X': '^Z+strr (user.bankl)+^X']: ');
            if valu (input)<1 then else if valu (input)>user.bankl then sendwriteln (^Y'You did not borrow that many points!'
            ) else
            begin
              i:=valu (input);
              dec (user.bankl,i);
              dec (user.fpoint,i);
            end;
          end;
    end;
  until not online or (input[1]='Q');
  writeuser (user,usernum);
  writesysoplog ('Exited bank',user.handle);
end;

procedure seekcnode (b:byte);
begin
  seek (cnodef,b-1);
end;

procedure rewritecnodefile;
  var b,bb:byte;
begin
  {$I-}rewrite (cnodef);{$I+}
  for b:=1 to maxnode do begin
    cnode.useron:='Unknown';
    cnode.chat:='';
    for bb:=1 to maxnode do cnode.showed[bb]:=true;
    seekcnode (b);
    write (cnodef,cnode);
  end;
end;

procedure setfalse;
  var b:byte;
      nd:noderec;
begin
  opennode;
  for b:=1 to maxnode do begin
    seeknode (b);
    read (nodef,nd);
    cnode.showed[b]:=nd.action<>6;
  end;
  closenode;
end;

procedure opencnode;
begin
  assign (cnodef,setup.nodedir+'CHAT.DAT');
  {$I-}reset (cnodef);{$I+}
  if ioresult<>0 then rewritecnodefile;
end;

procedure closecnode;
begin
  close (cnodef);
end;

procedure multinodechat;
  var b:boolean;
      i,ii:integer;
begin
  writesysoplog ('Entered multi-node chat',user.handle);
  b:=false;
  updatenode (setup.nodenum,6,user.handle);
  clearscreen;
  displaynodeinfo;
  sendwrite (^Y'A prompt will appear when you start typing.'^M^M);
  repeat
    opencnode;
    for i:=1 to maxnode do begin
      if i<>setup.nodenum then begin
        seekcnode (i);
        read (cnodef,cnode);
        if not cnode.showed[i] then begin
          sendwriteln (^Y+cnode.useron+^X'> '^Z+cnode.chat);
          cnode.showed[i]:=true;
          seekcnode (i);
          write (cnodef,cnode);
        end;
      end;
    end;
    closecnode;
    if charready then begin
      prompt (user.handle+^X'> ');
      if not (input='') then begin
        if match (input,'/L') then displaynodeinfo else if match (input,'/Q') then begin
          cnode.useron:=user.handle;
          cnode.chat:='Exited '+curdate+' / '+curtime;
          setfalse;
          opencnode;
          seek (cnodef,setup.nodenum-1);
          write (cnodef,cnode);
          b:=true;
        end else if match (input,'/?') then begin
          sendwriteln (^M^Z'/L '^X'- '^Y'List users online');
          sendwriteln (^Z'/Q '^X'- '^Y'Quit multi-node chat'^M);
        end else begin
          cnode.useron:=user.handle;
          cnode.chat:=input;
          setfalse;
          opencnode;
          seek (cnodef,setup.nodenum-1);
          write (cnodef,cnode);
          closecnode;
        end;
      end;
    end;
  until b or not online;
  closecnode;
  updatenode (setup.nodenum,4,user.handle);
  writesysoplog ('Exited multi-node chat',user.handle);
end;

procedure addlastcaller (s:string);
  var i,ii:integer;
begin
  assign (lastf,setup.datadir+'CALLERS.DAT');
  {$I-}reset (lastf);
  if ioresult<>0 then {$I-}rewrite (lastf){$I+};
  i:=filesize (lastf);
  if i>setup.maxlc then i:=setup.maxlc;
  for ii:=i-1 downto 0 do begin
    seek (lastf,ii);
    read (lastf,last);
    seek (lastf,ii+1);
    write (lastf,last);
  end;
  with last do begin
    name:=s;
    if local then speed:='Local' else speed:=strr (connectbaud);
    date:=curdate;
    time:=curtime;
    callnum:=stat.numcallers;
  end;
  seek (lastf,0);
  write (lastf,last);
  close (lastf);
end;

function numbbs:integer;
begin
  numbbs:=filesize (bbsf);
end;

procedure seekbbs (i:integer);
begin
  seek (bbsf,i-1);
end;

procedure assignbbs;
begin
  assign (bbsf,setup.datadir+'BBSLIST.DAT');
end;

procedure rewritebbs;
begin
  {$I-}rewrite (bbsf);{$I+}
  {with bbs do begin
    bbsname:='The CURSE BBS';
    desc:=bbsname+' BBS WHQ / CURSE WHQ';
    author:='Papa Shango';
    software:=bbsname;
    phonenum:='301-762-1958';
    minbaud:=2400;
    maxbaud:=57600;
  end;
  seekbbs (numbbs+1);
  write (bbsf,bbs);}
end;

procedure addbbs;
  label exit;
begin
  assignbbs;
  {$I-}reset (bbsf);{$I+}
  if ioresult<>0 then rewritebbs;
  clearscreen;
  header ('BBS Information');
  inlen:=30;
  prompt ('BBS Name'^X': ');
  bbs.bbsname:=input;
  if length (bbs.bbsname)<1 then goto exit;
  nl;
  inlen:=12;
  prompt ('Phone Number'^X': ');
  bbs.phonenum:=input;
  if length (bbs.phonenum)<1 then goto exit;
  nl;
  inlen:=8;
  prompt ('BBS Software'^X': ');
  bbs.software:=input;
  if length (bbs.software)<1 then goto exit;
  nl;
  inlen:=5;
  prompt ('Minimum Baud Rate'^X': ');
  bbs.minbaud:=valu (input);
  if bbs.minbaud<1 then goto exit;
  nl;
  inlen:=5;
  prompt ('Maximum Baud Rate'^X': ');
  bbs.maxbaud:=valu (input);
  if bbs.maxbaud<1 then goto exit;
  nl;
  inlen:=30;
  prompt ('Description'^X': ');
  bbs.desc:=input;
  if length (bbs.desc)<1 then goto exit;
  bbs.author:=user.handle;
  with bbs do begin
    if (length (phonenum)>0) and (length (bbsname)>0) then begin
      seekbbs (numbbs+1);
      write (bbsf,bbs);
      writesysoplog ('Added BBS #'+strr (numbbs),user.handle);
    end;
  end;
  sendwrite (^M^Y'BBS added to list.'^M^M);
  exit:
  close (bbsf);
end;

procedure listbbs;
  var i:integer;
begin
  assignbbs;
  {$I-}reset (bbsf);{$I+}
  if ioresult<>0 then rewritebbs;
  if numbbs<1 then begin
    sendwrite (^M^Y'No BBSes in list!'^M^M);
    close (bbsf);
    exit;
  end;
  clearscreen;
  sendwrite (^Y);
  spacewrite ('#',5);
  spacewrite ('Phone #',14);
  spacewrite ('BBS Name',32);
  sendwriteln ('Software');
  writeline (79);
  for i:=1 to numbbs do begin
    seekbbs (i);
    read (bbsf,bbs);
    sendwrite (^Z);
    spacewrite (strr (i),5);
    with bbs do begin
      spacewrite (phonenum,14);
      spacewrite (bbsname,32);
      sendwriteln (software);
      sendwriteln (^Y'Description'^X': '^Z+desc+^Y'  Baud'^X': '^Z+strr (minbaud)
      +^X'-'^Z+strr (maxbaud)+^Y);
    end;
  end;
  nl;
  pause;
  close (bbsf);
end;

procedure deletebbs;
  label exit;
  var i,ii:integer;
begin
  assignbbs;
  {$I-}reset (bbsf);{$I+}
  if ioresult<>0 then rewritebbs;
  if numbbs<1 then begin
    sendwrite (^M^Y'No BBSes in list!'^M^M);
    goto exit;
  end;
  prompt ('Enter BBS # to delete'^X': ');
  if length (input)<1 then goto exit;
  i:=valu (input);
  if (i<1) or (i>numbbs) then goto exit;
  seekbbs (i);
  read (bbsf,bbs);
  if not (match (bbs.author,user.handle)) and not cosysop (0) then begin
    sendwriteln (^Y'You did not add this BBS into the list!');
    goto exit;
  end;
  for ii:=i to numbbs-1 do begin
    seek (bbsf,ii);
    read (bbsf,bbs);
    seek (bbsf,ii-1);
    write (bbsf,bbs);
  end;
  seek (bbsf,numbbs-1);
  truncate (bbsf);
  writesysoplog ('Deleted BBS #'+strr (i),user.handle);
  exit:
  close (bbsf);
end;

procedure chatcall;
  label done;
  var b:boolean;
      i:integer;

    procedure dochat;
    begin
      nosound;
      chat;
      b:=true;
    end;

begin
  if not {stat.}sysopavail then begin
    sendwriteln (^M^Y+setup.chatnotava+^M);
    exit;
  end;
  sendwrite (^M^Y'Paging '+sysopname+^X);
  b:=false;
  for i:=1 to 15 do begin
    sendwrite ('.');
    sound (1200);
    delay (125);
   { if keypressed then dochat;}
    if b or charready then goto done;
    sendwrite ('.');
    sound (1400);
    delay (125);
   { if keypressed then dochat;}
    if b or charready then goto done;
    sendwrite ('.');
    sound (1600);
    delay (125);
   { if keypressed then dochat;}
    if b or charready then goto done;
  end;
  writesysoplog ('Paged sysop',user.handle);
  done:
  nosound;
  sendwriteln (^M);
end;

procedure lastcallers;
  var i:integer;
      last:lastcallrec;
      lastf:file of lastcallrec;
begin
 {if listleve>ulvl then begin
    reqlevel (listleve);
    exit;
  end;}
  writesysoplog ('Viewed last callers',user.handle);
  assign (lastf,setup.datadir+'CALLERS.DAT');
  {$I-}reset (lastf);{$I+}
  if ioresult<>0 then begin
    sendwrite (^M^Y'No last callers!'^M^M);
    exit;
  end;
  sendwrite (^Y);
  spacewrite ('#',6);
  spacewrite ('User Handle',32);
  spacewrite ('Speed',7);
  spacewrite ('Date',10);
  sendwriteln ('Time');
  writeline (79);
  for i:=1 to filesize (lastf) do begin
    seek (lastf,i-1);
    read (lastf,last);
    sendwrite (^Z);
    spacewrite (strr (last.callnum),6);
    spacewrite (last.name,32);
    if charready then begin
      close (lastf);
      exit;
    end;
    spacewrite (last.speed,7);
    if charready then begin
      close (lastf);
      exit;
    end;
    spacewrite (last.date,10);
    if charready then begin
      close (lastf);
      exit;
    end;
    sendwriteln (last.time);
    if charready then begin
      close (lastf);
      exit;
    end;
  end;
  close (lastf);
  nl;
  pause;
end;

procedure listusers (b:boolean);
  var list:boolean;
      i,ii,iii:integer;
      s:string[3];
      u:userrec;
begin
  writesysoplog ('Viewed user list',user.handle);
  {if b then parserange (numusers,ii,iii) else begin
    ii:=1;
    iii:=numusers;
  end;
  if ii=0 then exit;}
  {}ii:=1;
  iii:=numusers;{}
  list:=doyesno ('List user(s) notes?');
  clearscreen;
  sendwrite (^Y);
  spacewrite ('#',5);
  spacewrite ('User Handle',32);
  spacewrite ('Level',7);
  spacewrite ('AC',5);
  spacewrite ('Speed',7);
  sendwriteln ('Date');
  writeline (79);
  if charready then exit;
  useropen (false);
  for i:=ii to iii do begin
    seek (userf,i-1);
    read (userf,u);
    if length (u.handle)>0 then begin
      sendwrite (^Z);
      spacewrite (strr (i),5);
      if charready then exit;
      spacewrite (u.handle,32);
      if charready then exit;
      spacewrite (strr (u.mlevel),7);
      if charready then exit;
      s:=copy (u.phone,1,3);
      if s<>copy (setup.sysphone,1,3) then sendwrite (^Y);
      spacewrite (s,5);
      if s<>copy (setup.sysphone,1,3) then sendwrite (^Z);
      if charready then exit;
      sendwrite (^Z);
      if u.baudrate=0 then spacewrite ('Local',7) else spacewrite (strr (u.baudrate),7);
      sendwriteln (u.lastondate);
      if charready then exit;
      if list then begin
        sendwrite (^Y'User Note'^X': '^Z);
        sendwritelncolor (u.note);
      end;
      if charready then exit;
    end;
  end;
  useropen (true);
  nl;
  pause;
end;

{procedure fileconfig;
var i,ii:integer;
    c:char;

  procedure togglef (f:filelisttype; i,iii:integer);
  begin
    if f in user.filelist then begin
      user.filelist:=user.filelist-[f];
      ii:=ii+iii;
    end else begin
      if ii-iii<0 then sendwrite (^G^G) else begin
        user.filelist:=user.filelist+[f];
        ii:=ii-iii;
      end;
    end;
    sendxy (22,i+1,^Z+onoffstr[f in user.filelist]);
    writeuser (user,usernum);
  end;

  procedure writemenu (a,b:integer; c,m:string);
  begin
    sendxy (a,b,^X+'['^Z+c+^X'] '^Y+m);
  end;

  procedure showfscreen;
  begin
    sendwrite (^X);
    ansiwindow (1,1,33,13);
    writemenu (3,2,'1','Filename     '^X': '^Z+onoffstr[fname in user.filelist]+^X' ['^Z'9'^X']');
    writemenu (3,3,'2','Extension    '^X': '^Z+onoffstr[fext in user.filelist]+^X' ['^Z'5'^X']');
    writemenu (3,4,'3','Cost         '^X': '^Z+onoffstr[fcost in user.filelist]+^X' ['^Z'6'^X']');
    writemenu (3,5,'4','File Size    '^X': '^Z+onoffstr[fsize in user.filelist]+^X' ['^Z'6'^X']');
    writemenu (3,6,'5','Description  '^X': '^Z+onoffstr[fdesc in user.filelist]+^X' ['^Z'35'^X']');
    writemenu (3,7,'6','Category     '^X': '^Z+onoffstr[fgroup in user.filelist]+^X' ['^Z'10'^X']');
    writemenu (3,8,'7','Number of D/L'^X': '^Z+onoffstr[fdown in user.filelist]+^X' ['^Z'4'^X']');
    writemenu (3,9,'8','Uploader     '^X': '^Z+onoffstr[fuploader in user.filelist]+^X' ['^Z'13'^X']');
    writemenu (3,10,'9','Date Uploaded'^X': '^Z+onoffstr[fuploaded in user.filelist]+^X' ['^Z'10'^X']');
    sendxy (3,12,^Y'Free'^X': ');
  end;

begin
  ii:=74;
  if fname in user.filelist then ii:=ii-9;
  if fext in user.filelist then ii:=ii-5;
  if fcost in user.filelist then ii:=ii-6;
  if fsize in user.filelist then ii:=ii-6;
  if fdesc in user.filelist then ii:=ii-35;
  if fgroup in user.filelist then ii:=ii-10;
  if fdown in user.filelist then ii:=ii-4;
  if fuploader in user.filelist then ii:=ii-13;
  if fuploaded in user.filelist then ii:=ii-10;
  clearscreen;
  showfscreen;
  repeat
    sendxy (9,12,^Z+strr(ii));
    if ii<10 then sendwrite (' ');
    sendxy (1,15,^Y'File Listing Command'^X':  '^Y);
    sendwrite (#8' '#8);
    c:=upcase (shinchar);
    case c of
      '1':togglef (fname,1,9);
      '2':togglef (fext,2,5);
      '3':togglef (fcost,3,6);
      '4':togglef (fsize,4,6);
      '5':togglef (fdesc,5,35);
      '6':togglef (fgroup,6,10);
      '7':togglef (fdown,7,4);
      '8':togglef (fuploader,8,13);
      '9':togglef (fuploaded,9,10);
    end;
  until (c='Q') or not online;
  sendwrite (^Y);
  clearscreen;
end;}

procedure userconfig;
  var b:boolean;
      c:char;

    function numfree:integer;
      var i:integer;
    begin
      i:=74;
      with user do begin
        if filelist[1] then dec (i,9);
        if filelist[2] then dec (i,5);
        if filelist[3] then dec (i,6);
        if filelist[4] then dec (i,6);
        if filelist[5] then dec (i,35);
        if filelist[6] then dec (i,10);
        if filelist[7] then dec (i,4);
        if filelist[8] then dec (i,13);
        if filelist[9] then dec (i,10);
      end;
      numfree:=i;
    end;

    procedure toggle_filelist (bb,numspace:byte);
    begin
      user.filelist[bb]:=not user.filelist[bb];
      if numfree<0 then user.filelist[bb]:=false;
      sendxy (59,bb+1,^N+onoff[user.filelist[bb]]);
      sendxy (48,11,'');
      spacewrite (strr (numfree),2);
    end;

    procedure draw_filelist_windows (clear:boolean);

      procedure writemenu (a,b:integer; c:char; m:medstr);
      begin
        sendxy (a,b,^A'['^N+c+^A'] '^B+m);
      end;

    begin
      { File Listing Window }
      if clear then clearscreen;
      ansi_window (40,1,79,12);
      with user do begin
        writemenu (42,2,'1','Filename   '^A': '^N+onoff[filelist[1]]);
        writemenu (42,3,'2','Extension  '^A': '^N+onoff[filelist[2]]);
        writemenu (42,4,'3','Cost       '^A': '^N+onoff[filelist[3]]);
        writemenu (42,5,'4','Size       '^A': '^N+onoff[filelist[4]]);
        writemenu (42,6,'5','Description'^A': '^N+onoff[filelist[5]]);
        writemenu (42,7,'6','Group      '^A': '^N+onoff[filelist[6]]);
        writemenu (42,8,'7','Popularity '^A': '^N+onoff[filelist[7]]);
        writemenu (42,9,'8','Uploader   '^A': '^N+onoff[filelist[8]]);
        writemenu (42,10,'9','Uploaded   '^A': '^N+onoff[filelist[9]]);
      end;
      sendxy (42,11,^B'Free'^A': '^N);
      spacewrite (strr (numfree),2);
    end;

    procedure set_color (b:byte; fore:boolean);
      var bb:byte;
    begin
      if fore then bb:=5 else bb:=7;
      sendxy (17,bb,^Y);
      for bb:=0 to 15 do if bb=b then begin
        if fore then sendwrite ('F') else sendwrite ('B');
      end else sendwrite (' ');
    end;

    procedure getcolorvar (attr:byte; var fg,bk:integer);
    begin
      fg:=attr and 15;
      bk:=attr div 16;
    end;

    procedure changecolor (bb:byte);
      label exit;
      var fore,back:integer;
          c:char;
    begin
      getcolorvar (user.color[bb],fore,back);
      set_color (fore,true);
      set_color (back,false);
      repeat
        c:=upcase (inchar);
        case c of
          'D':begin
                dec (fore);
                if fore<0 then fore:=15;
                set_color (fore,true);
              end;
          'U':begin
                inc (fore);
                if fore>15 then fore:=0;
                set_color (fore,true);
              end;
          'L':begin
                dec (back);
                if back<0 then back:=7;
                set_color (back,false);
              end;
          'R':begin
                inc (back);
                if back>7 then back:=0;
                set_color (back,false);
              end;
        end;
      until (c=#27) or (c=#13) or not online;
      if c=#13 then user.color[bb]:=fore+(16*back);
      set_color (16,true);
      set_color (16,false);
      b:=true;
    end;

    procedure draw_color_windows (clear:boolean);
      var b:byte;
    begin
      { Color Window }
      if clear then clearscreen;
      ansi_window (1,1,39,10);
      sendxy (3,2,^A'['^N'A'^A'] '^W'Color #1'^A'  ['^N'D'^A'/'^N'U '^B'for foreground'^A']');
      sendxy (3,3,^A'['^N'B'^A'] '^X'Color #2'^A'  ['^N'L'^A'/'^N'R '^B'for background'^A']');
      sendxy (3,4,^A'['^N'C'^A'] '^Y'Color #3');
      sendxy (3,5,^A'['^N'D'^A'] '^Z'Color #4');
      sendxy (3,6,^A'['^N'E'^A'] Color #5');
      sendxy (3,7,^A'['^N'F'^A'] '^B'Color #6');
      sendxy (3,8,^A'['^N'G'^A'] '^N'Color #7');
      sendxy (3,9,^A'['^N'H'^A'] '^O'Color #8');
      sendxy (17,6,'');
      for b:=0 to 15 do begin
        ansicolor (b);
        sendwrite ('');
      end;
    end;

    function gender (c:char):smstr;
    begin
      if c='M' then gender:='Male  ' else gender:='Female';
    end;

    procedure draw_personal_windows (clear:boolean);
    begin
      { Personal }
      if clear then clearscreen;
      ansi_window (1,11,39,19);
      (*sendxy (3,12,^A'['^N'I'^A'] '^B'Handle'^A': '^N+user.handle); {15}*)
      sendxy (3,12,^A'['^N'I'^A'] '^B'Real Name'^A': '^N+user.realname); {18}
      sendxy (3,13,^A'['^N'J'^A'] '^B'Addr'^A': '^N+user.maddress[1]); {13}
      sendxy (3,14,^A'['^N'K'^A'] '^B'      '^N+user.maddress[2]); {13}
      sendxy (3,15,^A'['^N'L'^A'] '^B'Note'^A': '); {13}
      sendwritecolor (^N+user.note);
      sendxy (3,16,^A'['^N'M'^A'] '^B'Birthdate'^A': '^N+user.bday); {18}
      sendxy (3,17,^A'['^N'N'^A'] '^B'Gender'^A': '^N+gender (user.sex)); {15}
      sendxy (3,18,^A'['^N'O'^A'] '^B'Display Length'^A': '^N+strr (user.displaylen)); {23}
    end;

    procedure showemu;
      var i:integer;
    begin
      case user.emulation of
        0:sendwrite ('None (TTY)');
        1:sendwrite ('IBM ANSI  ');
        2:sendwrite ('Avatar    ');
      end;
    end;

    procedure chooseprompt;
      var bb,bbb:byte;
    begin
      openprompt;
      bbb:=numprompt;
      closeprompt;
      if bbb>0 then begin
        clearscreen;
        listprompt;
        openprompt;
        bb:=getpromptnum;
        closeprompt;
        user.cprompt:=0;
        if bb>0 then begin
          openprompt;
          seekprompt (bb);
          read (promptf,prmpt);
          closeprompt;
          user.cprompt:=1;
          user.curprompt1:=prmpt.prmpt1;
          user.curprompt2:=prmpt.prmpt2;
        end;
        b:=true;
      end;
    end;

    procedure draw_settings_windows (clear:boolean);
    begin
      { Settings }
      if clear then clearscreen;
      ansi_window (40,13,79,19);
      sendxy (42,14,^A'['^N'P'^A'] '^B'Emulation'^A': '^N); {57}
      showemu;
      sendxy (42,15,^A'['^N'R'^A'] '^B'Password'^A': '^N'Classified'); {56}
      sendxy (42,16,^A'['^N'S'^A'] '^B'Pause Prompts'^A': '^N+onoff[user.pause]); {61}
      sendxy (42,17,^A'['^N'T'^A'] '^B'Show Oneliners'^A': '^N+onoff[user.showol]); {62}
      sendxy (42,18,^A'['^N'U'^A'] '^B'Set Prompt Type');
    end;

begin
  writesysoplog ('Entered user config',user.handle);
  b:=true;
  repeat
    if b then begin
      draw_color_windows (true);
      draw_filelist_windows (false);
      draw_personal_windows (false);
      draw_settings_windows (false);
      b:=false;
    end;
    c:=upcase (inchar);
    case c of
      '1':toggle_filelist (1,9);
      '2':toggle_filelist (2,5);
      '3':toggle_filelist (3,6);
      '4':toggle_filelist (4,6);
      '5':toggle_filelist (5,35);
      '6':toggle_filelist (6,10);
      '7':toggle_filelist (7,4);
      '8':toggle_filelist (8,13);
      '9':toggle_filelist (9,10);
      'A':changecolor (1);
      'B':changecolor (2);
      'C':changecolor (3);
      'D':changecolor (4);
      'E':changecolor (5);
      'F':changecolor (6);
      'G':changecolor (7);
      'H':changecolor (8);
      {'I':begin
            sendxy (15,12,'');inlen:=23;clearinp (inlen);recv;
            if length (input)>0 then begin
              if (finduser (input)>0) and not (match (input,user.handle)) then sendxy (1,20,^Y'Already exists!')
              else user.handle:=input;
            end;
            clearinp (23);
            sendxy (15,12,^N+user.handle);
          end;}
      'I':begin
            sendxy (18,12,'');inlen:=20;clearinp (inlen);sendwrite (^Y);recv;
            if length (input)>0 then user.realname:=input;sendxy (18,12,^N+user.realname);
          end;
      'J':begin
            sendxy (13,13,'');inlen:=25;clearinp (inlen);sendwrite (^Y);recv;
            if length (input)>0 then user.maddress[1]:=input;sendxy (13,13,^N+user.maddress[1]);
          end;
      'K':begin
            sendxy (13,14,'');inlen:=25;clearinp (inlen);sendwrite (^Y);recv;
            if length (input)>0 then user.maddress[2]:=input;sendxy (13,14,^N+user.maddress[2]);
          end;
      'L':begin
            sendxy (13,15,'');inlen:=25;clearinp (inlen);sendwrite (^Y);recv;
            if length (input)>0 then user.note:=input;sendxy (13,15,'');
            sendwritecolor (^N+user.note);
          end;
      'M':begin
            sendxy (18,16,'');inlen:=8;clearinp (inlen);sendwrite (^Y);recv;
            if (length (input)=8) and (input[3]='/') and (input[6]='/') then user.bday:=input;
            sendxy (18,16,^N+user.bday);
          end;
      'N':begin
            if user.sex='M' then user.sex:='F' else user.sex:='M';
            sendxy (15,17,^N+gender (user.sex));
          end;
      'O':begin
            sendxy (23,18,'');inlen:=2;clearinp (inlen);sendwrite (^Y);recv;
            if (valu (input)>22) and (valu (input)<51) then user.displaylen:=valu (input);
            sendxy (23,18,^N+strr (user.displaylen));
          end;
      'P':begin
            inc (user.emulation);
            if user.emulation>2 then user.emulation:=1;{0}
            sendxy (57,14,^N);
            showemu;
          end;
      'R':begin
            sendxy (56,15,'');inlen:=20;clearinp (inlen);sendwrite (^Y);recv;
            if length (input)>0 then user.password:=input;{sendxy (47,15,^N+user.password);}
            sendxy (56,15,'');clearinp (20);sendwrite (^N'Classified');
          end;
      'S':begin
            user.pause:=not user.pause;
            sendxy (61,16,^N+onoff[user.pause]);
          end;
      'T':begin
            user.showol:=not user.showol;
            sendxy (62,17,^N+onoff[user.showol]);
          end;
      'U':chooseprompt;
    end;
  until (c='Q') or not online;
  writeuser (user,usernum);
  sendxy (1,20,'');
  writesysoplog ('Exited user config',user.handle);
end;

procedure edituser (i:integer);
  var b:boolean;
      c:char;
      u:userrec;
      s:string[30];

    procedure userconfedit;
      var c:char;
          confer:conference;
          ii,iii:integer;
          t:medstr;

        function numconf:integer;
        begin
          numconf:=filesize (conff);
        end;

    begin
      clearscreen;
      sendwrite (^Z'M'^Y'essage Conferences  '^Z'T'^Y'ransfer Conferences'^X': ');
      c:=upcase (shinchar);
      if c='M' then t:='MSGCONF' else if c='T' then t:='XFERCONF' else exit;
      assign (conff,setup.datadir+t+'.DAT');
      {$I-}reset (conff);{$I+}
      if (ioresult<>0) or (numconf<1) then begin
        sendwrite (^M^Y'No conferences!'^M^M);
        exit;
      end;
      if c='M' then confer:=u.msgconf else if c='T' then confer:=u.xferconf;
      repeat
        ii:=0;
        clearscreen;
        {sendwriteln (^Y'Conference Flags'^M);}
        if c='M' then t:='Message Conferences' else if c='T' then t:='Transfer Conferences';
        header (t);
        for iii:=1 to numconf do begin
          seek (conff,iii-1);
          read (conff,conf);
          sendwriteln (^X' ['^Z+strr (iii)+^X'] '^Y+conf.name+^X': '^Z+boostr (confer[iii]));
        end;
        nl;
        prompt ('Conference # to toggle'^X': ');
        input:=uppercase (input);
        if (valu (input)>0) and (valu (input)<=numconf) then ii:=valu (input);
        if ii<>0 then confer[ii]:=not confer[ii];
      until not online or (s[1]='Q');
      close (conff);
      if c='M' then u.msgconf:=confer else if c='T' then u.xferconf:=confer;
      writeuser (u,i);
    end;

    function inputvar (buf,x,y,where:integer; ss:string):string;
      var i:integer;
    begin
      sendxy (1,18,'');
      inlen:=buf;
      cleareol;
      prompt (ss+^X': ');
      sendxy (x,y,'');
      if where=1 then i:=42-x else if where=2 then i:=79-x;
      spacewrite (^Z+copy (input,1,i),i+1);
      inputvar:=input;
    end;

    procedure liststats;
    begin
      clearscreen;
      {header (sendwritestr (53));}
      sendwriteln (^X'[ '^Z'User Editing Information'^X' ]');
      sendxy (2,3,^X'['^Z'A'^X'] '^Y'User Name'^X': '^Z+u.handle); {17,3}
      sendxy (42,3,^X'['^Z'B'^X'] '^Y'Real Name'^X': '^Z+u.realname); {57,3}
      sendxy (2,4,^X'['^Z'C'^X'] '^Y'Phone #'^X': '^Z+u.phone); {15,4}
 {     sendxy (42,4,^X'['^Z'D'^X'] '^Y'Password'^X': '^Z'Classified');}
      sendxy (42,4,^X'['^Z'D'^X'] '^Y'Main Level'^X': '^Z+strr (u.mlevel)); {58,4}
      sendxy (2,5,^X'['^Z'E'^X'] '^Y'Message Level'^X': '^Z+strr (u.msglevel)); {21,5}
      sendxy (42,5,^X'['^Z'F'^X'] '^Y'# of Posts'^X': '^Z+strr (u.numpost)); {58,5}
      sendxy (2,6,^X'['^Z'G'^X'] '^Y'Transfer Level'^X': '^Z+strr (u.xflevel)); {22,6}
      sendxy (42,6,^X'['^Z'H'^X'] '^Y'Transfer Points'^X': '^Z+strr (u.fpoint)); {63,6}
      sendxy (2,7,^X'['^Z'I'^X'] '^Y'# of U/L''s'^X': '^Z+strr (u.numup)); {18,7}
      sendxy (42,7,^X'['^Z'J'^X'] '^Y'Upload K'^X': '^Z+strr (u.uploadk)); {56,7}
      sendxy (2,8,^X'['^Z'K'^X'] '^Y'# of D/L''s'^X': '^Z+strr (u.numdn)); {18,8}
      sendxy (42,8,^X'['^Z'L'^X'] '^Y'Download K'^X': '^Z+strr (u.downloadk)); {58,8}
      (*sendxy (2,9,^X'['^Z'M'^X'] '^Y'City'^X': '^Z+u.city); {12,9}
      sendxy (42,9,^X'['^Z'N'^X'] '^Y'State '^X'('^Y'2'^X'): '^Z+u.state); {57,9}
      sendxy (2,10,^X'['^Z'O'^X'] '^Y'Zip Code'^X': '^Z+u.zipcode); {16,10}*)
      sendxy (42,10,^X'['^Z'P'^X'] '^Y'Birthdate'^X': '^Z+u.bday); {57,10}
      sendxy (2,11,^X'['^Z'R'^X'] '^Y'Daily Time'^X': '^Z+strr (u.dailytime)); {18,11}
      sendxy (42,11,^X'['^Z'S'^X'] '^Y'Time Left'^X': '^Z+strr (u.time)); {57,11}
      sendxy (2,12,^X'['^Z'T'^X'] '^Y'Note'^X': '^Z+u.note); {12,12}
      sendxy (42,12,^X'['^Z'U'^X'] '^Y'Conferences'); {58,12}
      sendxy (2,13,^X'['^Z'V'^X'] '^Y'Min P/C %'^X': '^Z+strr (u.minpc)); {17,13}
      sendxy (42,13,^X'['^Z'W'^X'] '^Y'Min U/D %'^X': '^Z+strr (u.minud)); {57,13}
      sendxy (2,14,^X'['^Z'X'^X'] '^Y'Download K per day'^X': '^Z+strr (u.dkperday)); {26,14}
      sendxy (42,14,^X'['^Z'Y'^X'] '^Y'K left for today'^X': '^Z+strr (u.kleft)); {64,14}
      sendxy (2,15,^X'['^Z'Z'^X'] '^Y'Password'^X': '^Z+u.password); {16,15}
      sendxy (42,15,^X'['^Z'1'^X'] '^Y'Quick Validate');
      sendxy (2,16,^X'['^Z'2'^X'] '^Y'Delete User');
    end;

begin
  writesysoplog ('Edited user #'+strr (i),user.handle);
  readuser (u,i);
  b:=true;
  repeat
    if b then liststats;
    b:=false;
    sendxy (1,18,^Y'Command'^X':  '^Y);
    sendwrite (#8' '#8);
    cleareol;
    c:=upcase (shinchar);
    case c of
      'A':begin
            s:=inputvar (30,17,3,1,'User Name');
            if finduser (s)<1 then user.handle:=s;
          end;
      'B':u.realname:=inputvar (30,57,3,2,'Real Name');
      'C':u.phone:=inputvar (12,15,4,1,'Phone #');
      'D':u.mlevel:=valu (inputvar (5,58,4,2,'Main Level'));
      'E':u.msglevel:=valu (inputvar (5,21,5,1,'Message Level'));
      'F':u.numpost:=valu (inputvar (5,58,5,2,'# of Posts'));
      'G':u.xflevel:=valu (inputvar (5,22,6,1,'Transfer Level'));
      'H':u.fpoint:=valu (inputvar (5,63,6,2,'Transfer Points'));
      'I':u.numup:=valu (inputvar (5,18,7,1,'# of Uploads'));
      'J':u.uploadk:=valu (inputvar (10,56,7,2,'Upload K'));
      'K':u.numdn:=valu (inputvar (5,18,8,1,'# of Downloads'));
      'L':u.downloadk:=valu (inputvar (10,58,8,2,'Download K'));
      (*'M':u.city:=inputvar (30,12,9,1,'City');
      'N':u.state:=uppercase (inputvar (2,57,9,2,'State Abbreviation'));
      'O':u.zipcode:=inputvar (10,16,10,1,'Zip Code ##### or #####'^X'-'^Y'####');*)
      'P':u.bday:=inputvar (8,57,10,2,'Birthdate ##'^X'/'^Y'##'^X'/'^Y'##');
      'R':u.dailytime:=valu (inputvar (5,18,11,1,'Daily Time'));
      'S':u.time:=valu (inputvar (5,57,11,2,'Time Left'));
      'T':u.note:=inputvar (30,12,12,1,'Note');
      'U':begin
            userconfedit;
            b:=true;
          end;
      'V':u.minpc:=valu (inputvar (3,17,13,1,'Mininum P/C %'));
      'W':u.minud:=valu (inputvar (3,57,13,2,'Mininum U/D %'));
      'X':u.dkperday:=valu (inputvar (9,26,14,1,'Download K per day'));
      'Y':u.kleft:=valu (inputvar (9,64,14,2,'K left for today'));
      'Z':u.password:=inputvar (20,16,15,1,'Password');
      '1':begin
            quickvalidate (u,i,'U');
            b:=true;
          end;
      '2':begin
            sendxy (1,18,'');
            deluser (i);
            readuser (u,i);
            if u.handle='' then c:='Q';
          end;
    end;
  until (c='Q') or not online;
  nl;
  writeuser (u,i);
  {readuser (user,usernum);}
end;

procedure useredit (i:integer);
  var ii,iii:integer;
begin
  iii:=numusers;
  if (i>0) or (i<iii+1) then begin
    repeat
      ii:=0;
      prompt ('User to edit '^X'['^Z'?'^X'/'^Y'List'^X']: ');
      input:=uppercase (input);
      if input='?' then listusers (false);
      if valu (input)>0 then ii:=valu (input);
    until ((ii>0) and (ii<iii+1)) or (input[1]='Q') or not online;
    if (input[1]='Q') or not online then exit;
  end else ii:=i;
  if (ii=1) and (usernum<>1) then sendwrite (^M^Y'You''re NOT the SysOp!'^M^M) else edituser (ii);
end;

procedure statscreen;
  var i,ii:integer;
begin
  if ansi then if exist (setup.textdir+'USERSTAT.ANS') then begin
    printfile (setup.textdir+'USERSTAT.ANS',false);
    nl;
    pause;
  end else begin
    clearscreen;
    if ansi then begin
      i:=stat.posts-user.posts;
      if i<0 then i:=0;
      user.posts:=stat.posts;
      ii:=stat.ups-user.ups;
      if ii<0 then ii:=0;
      user.ups:=stat.ups;
      sendwriteln (^A'[ '^N'User Information'^A' ]');
      ansi_window (1,3,51,12);
      sendxy (3,4,^B'User Name'^A': '^N+user.handle);
      sendxy (3,5,^B'Real Name'^A': '^N+user.realname);
      sendxy (3,6,^B'Phone #'^A': '^N+user.phone);
      sendxy (3,7,^B'Address #1'^A': '^N+user.maddress[1]);
      sendxy (3,8,^B'Address #2'^A': '^N+user.maddress[2]);
      sendxy (3,9,^B'Time Left'^A': '^N+strr (timeleft));
      sendxy (3,10,^B'Last on'^A': '^N+laston);
      sendxy (3,11,^B'Last caller'^A': '^N+getlastcaller);
      ansi_window (52,1,79,12);
      sendxy (54,2,^B'Message Level'^A': '^N+strr (user.msglevel));
      sendxy (54,3,^B'# of Posts'^A': '^N+strr (user.numpost));
      sendxy (54,4,^B'Transfer Level'^A': '^N+strr (user.xflevel));
      sendxy (54,5,^B'Transfer Points'^A': '^N+strr (user.fpoint));
      sendxy (54,6,^B'# of Uploads'^A': '^N+strr (user.numup));
      sendxy (54,7,^B'Upload K'^A': '^N+strr (user.uploadk));
      sendxy (54,8,^B'# of Downloads'^A': '^N+strr (user.numdn));
      sendxy (54,9,^B'Download K'^A': '^N+strr (user.downloadk));
      sendxy (54,10,^B'New Posts'^A': '^N+strr (i));
      sendxy (54,11,^B'New Files'^A': '^N+strr (ii));
      ansi_window (1,13,79,15);
      sendxy (3,14,^B'User Note'^A': ');
      sendwritecolor (^N+user.note);
      sendxy (1,17,'');
      pause;
    end;
  end;
end;

procedure makeuser;
  var i,ii,iii,j:integer;
      u:userrec;
begin
  writeuser (user,usernum);
  fillchar (u,sizeof (u),0);
  inlen:=30;
  prompt ('User Handle'^X': ');
  u.handle:=input;
  if length (u.handle)<1 then exit;
  if finduser (u.handle)>0 then begin
    sendwriteln (^Y'Name already exists!');
    u.handle:='';
    exit;
  end;
  i:=findusernum;
  if i=0 then exit;
  if not online then exit;
  inlen:=20;
  prompt ('Password'^X': ');
  u.password:=input;
  if length (u.password)<1 then exit;
  repeat
    j:=-1;
    inlen:=1;
    prompt ('Emulation'^X': ['^Z'1'^X'] '^Y'ANSI  '^X'['^Z'2'^X'] '^Y'Avatar'^X': ');
    case input[1] of
      {'0'}'1'..'2':j:=valu (input[1]);
    end;
  until (j>{-1}0) and (j<3);
  {if doyesno (sendwritestr (20)) then j:=1 else j:=0;}
  u.emulation:=j;
  setdefcolors (u);
  repeat
    inlen:=12;
    prompt ('Enter your phone number in the form'^X': '^Y'800'^X'-'^Y'555'^X'-'^Y'1212'^X': ');
    u.phone:=input;
  until (length (u.phone)=12) and (u.phone[4]='-') and (u.phone[8]='-') or not online;
  if not online then exit;
  inlen:=3;
  prompt ('Main Level'^X': ');
  u.mlevel:=valu (input);
  inlen:=3;
  prompt ('Message Level'^X': ');
  u.msglevel:=valu (input);
  inlen:=3;
  prompt ('Transfer Level'^X': ');
  u.xflevel:=valu (input);
  inlen:=5;
  prompt ('Transfer Points'^X': ');
  u.fpoint:=valu (input);
  inlen:=5;
  prompt ('Daily Time/Time per day'^X': ');
  u.dailytime:=valu (input);
  u.time:=u.dailytime;
  inlen:=30;
  prompt ('Occupation'^X': ');
  u.occup:=input;
  u.firston:=curdate;
  u.lastondate:=u.firston;
  u.baudrate:=0;
  u.numon:=0;
  u.numpost:=0;
  u.uploadk:=0;
  u.downloadk:=0;
  u.numup:=0;
  u.numdn:=0;
  u.minpc:=0;{setup.minpc}
  u.minud:=0;{setup.minud}
  u.realname:='';
  u.note:=u.occup;
  u.sex:=#0;
  u.bday:=curdate;
  {u.address:='';
  u.city:='';
  u.state:='';
  u.zipcode:='';}
  u.bbsref:='';
  u.posts:=0;
  u.ups:=0;
  u.bankt:=0;
  u.bankc:=0;
  u.bankl:=0;
  {u.fprompt:=true;}
  {u.intemenu:=false;}
  u.displaylen:=24;
  u.curmonth:=0;
  u.nummonth:=0;
  u.paid:=true;
  u.showol:=false;
  u.pause:=false;
  {u.forward:='';}
  u.dkperday:=setup.dkperday;
  u.kleft:=u.dkperday;
  for ii:=1 to maxconf do u.msgconf[ii]:=false;
  for ii:=1 to maxconf do u.xferconf[ii]:=false;
  {for ii:=0 to maxconf do for iii:=1 to 50 do u.lastread [iii,ii]:=0;}
  for ii:=0 to maxconf do for j:=1 to maxmbases do u.lastread[ii][j]:=0;
  {for ii:=1 to maxvotes do u.votes[ii]:=0;}
  with u do for ii:=1 to 9 do filelist[ii]:=ii<=5;
  u.pwlogon:=0;
  u.cprompt:=0;
  u.voteyes:=0;
  u.voteno:=0;
  u.curprompt1:='';
  u.curprompt2:='';
  u.maddress[1]:='';
  u.maddress[2]:='';
  for ii:=1 to maxinterview do u.intvw[ii]:=false;
  writeuser (u,i);
  sendwriteln (^Y'User created!');
  {readuser (user,usernum);}
  writesysoplog ('Made user #'+strr (i),user.handle);
end;

procedure mainmenu;
begin
  writesysoplog ('Entered main menu',user.handle);
  runmenu (setup.menuname);
end;

function olread:string;
  var i,ii:integer;
      s:string[80];
begin
  s:='';
  assign (olf,setup.datadir+'ONELINER.DAT');
  {$I-}reset (olf);{$I+}
  if ioresult<>0 then s:=^Y'Create a oneliner.' else begin
    ii:=filesize (olf);
    randomize;
    i:=random (ii);
    seek (olf,i);
    read (olf,ol);
    s:=^Y+ol.oliner;
    close (olf);
  end;
  olread:=s;
end;

procedure addol;
begin
  nl;
  inlen:=74;
  prompt ('Enter your oneliner.'^M^X': ');
  if length (input)>0 then begin
    ol.from:=user.handle;
    ol.oliner:=input;
    assign (olf,setup.datadir+'ONELINER.DAT');
    {$I-}reset (olf);{$I+}
    if ioresult<>0 then {$I-}rewrite (olf);{$I+}
    seek (olf,filesize (olf));
    write (olf,ol);
    close (olf);
    writesysoplog ('Added oneliner #'+strr (filesize (olf)),user.handle);
  end else sendwriteln (^M^Y'Oneliner not saved!'^M);
  nl;
end;

procedure listol;
  var i,ii,iii:integer;
begin
  assign (olf,setup.datadir+'ONELINER.DAT');
  {$I-}reset (olf);{$I+}
  if ioresult<>0 then sendwriteln (^M^Y'No oneliners!'^M) else begin
    range (filesize (olf),ii,iii);
    clearscreen;
    sendwrite (^Y);
    spacewrite ('#',5);
    sendwriteln ('Oneliner');
    writeline (79);
    for i:=ii to iii do begin
      seek (olf,i-1);
      read (olf,ol);
      sendwrite (^Z);
      spacewrite (strr (i),5);
      sendwritelncolor (ol.oliner);
    end;
    close (olf);
    nl;
    pause;
  end;
end;

procedure runcommand (var temp:menurec);
  const SwapLoc:Array[Boolean] of String[7]=('on disk','in EMS');
  var c,cc:char;
      i:integer;
      t:text;
      s:longstr;
      status:word;
begin
  c:=temp.comm[1];
  cc:=temp.comm[2];
  s:=copy (temp.comm,3,255);
  if not (cc='@') then clearscreen;
  case c of
    '/':case cc of
          'A':sysopupload;
          'C':changefile;
          'D':deletefile;
          'E':editxarea;
          'K':deletearea;
          'L':reset_loc;
          'M':movefile;
          'P':reset_fpoints;
          'S':sortarea;
        end;
    '\':case cc of
          'E':editmsgarea;
          'K':deletemsgarea;
          'P':packcurrentbase (false);
        end;
    'A':case cc of
          'R':readauto;
          'W':writeauto;
        end;
    'B':case cc of
          'A':addbbs;
          'D':deletebbs;
          'L':listbbs;
        end;
    'E':case cc of
          'P':packcurrentbase (true);
          'R':readmail;
          'S':sendmail (true,'','');
        end;
    'F':case cc of
          '@':xferload;
          'A':changearea;
          'D':download;
          {'F':fileconfig;}
          'J':changeconf (true,'T');
          'L':listfiles (true);
          'N':xfer.newscan;
          'S':filesearch;
          'T':typefile;
          'U':upload;
          'V':listarch;
          '+':begin
                inc (curarea);
                openarea;
                if curarea>numarea then curarea:=1;
                {i:=getarea (curarea);}
                closearea;
                {if i<>0 then }xfer.setarea ({i}curarea,true);
              end;
          '-':begin
                dec (curarea);
                openarea;
                if curarea<1 then curarea:=numarea;
                {i:=getarea (curarea);}
                closearea;
                {if i<>0 then }xfer.setarea ({i}curarea,true);
              end;
        end;
    'G':case cc of
          'A':playawf;
        end;
    'M':case cc of
          '@':msgload;
          'A':changemsgarea;
          'D':deletemsg;
          'J':changeconf (true,'M');
          'L':listtitles;
          'N':msgbase.newscan (true);
          'P':postmsg (true);
          'R':readmsg;
          '+':begin
                inc (curmsgarea);
                openmsgarea;
                if curmsgarea>nummsgarea then curmsgarea:=1;
                {i:=getmsgarea (curmsgarea);}
                closemsgarea;
                {if i<>0 then }msgbase.setarea ({i}curarea,true);
              end;
          '-':begin
                dec (curmsgarea);
                openmsgarea;
                if curmsgarea<1 then curmsgarea:=nummsgarea;
                {i:=getmsgarea (curmsgarea);}
                closemsgarea;
                {if i<>0 then }msgbase.setarea ({i}curarea,true);
              end;
        end;
    'N':case cc of
          'L':listpending;
          'V':newuservoting (false);
        end;
    'O':case cc of
          'C':chatcall;
          'D':displaynodeinfo;
          'G':if doyesno ('Are you sure you want to disconnect?') then begin
                hangupmodem;
                writesysoplog ('Logged off',user.handle);
              end;
          'I':interviews;
          'K':userconfig;
          'L':lastcallers;
          'U':listusers (true);
          'V':statscreen;
          '$':bank;
          '^':runmenu (s);
          '/':multinodechat;
          '|':begin
                wwiv_chain;
                dorinfo1;
                def_user;
                {deactivateport;}
                status:=execwithswap (getenv ('COMSPEC'),' /C '+s);
                {activateport;}
              end;
        end;
    'R':case cc of
          'A':addol;
          'L':listol;
        end;
    {'V':case cc of
          'R':showresults (0);
        end;}
    '*':case cc of
          'B':blacklist;
          'C':changeuser;
          'D':deluser (0);
          'I':ivedit;
          'M':makeuser;
          'P':promptedit;
          'T':togglechat;
          'U':useredit (0);
          '#':phonesearch;
        end;
  end;
end;

function domenu (prmpt1,prmpt2:string):string;
  var c:char;
      menu2:array [1..100] of menurec;
      nummenu2,i,ii,j,highi,highj,jj,current:integer;
      sss:string[80];

    {procedure writebox (x,y:integer; s:string; highlight:boolean);
    begin
      if highlight then ansicolor (27) else ansicolor (31);
      sendxy (x,y,' ');
      spacewrite (s,19);
      sendwrite (^Y);
    end;

    procedure createbox (x,y:integer; s:string);
      var i,ii:integer;
    begin
      writebox (x,y,s,false);
      ansicolor (9);
      sendwrite ('');
      sendxy (x+1,y+1,'');
      charwrite ('',20);
      sendwrite (^Y);
    end;

    procedure makehighlight (b:boolean; s:string; make:boolean);
      var k:integer;
    begin
      if i=1 then k:=5 else if i=2 then k:=30 else k:=55;
      if make then createbox (k,j,s) else writebox (k,j,s,b);
    end;}

begin
  {if (ansi or avatar) and user.intemenu then begin
    clearscreen;
    ansicolor (31);
    sendxy (10,1,'');
    write (direct,' '+bbsname+' BBS v'+bbsver+'-Copyright '+copydate+' BaseTwo Software/Keith Brown ');
    ansicolor (9);
    write (direct,'');
    sendxy (11,2,'');
    charwrite ('',60);
    nummenu2:=0;
    i:=0;
    ii:=0;
    j:=4;
    while ii<nummenu do begin
      inc (ii);
      inc (i);
      if i>3 then begin
        i:=1;
        inc (j,2);
      end;
      if length (menu[ii].desc)>0 then begin
        inc (nummenu2);
        menu2[nummenu2]:=menu[ii];
        makehighlight (false,menu[ii].desc,true);
        highj:=j;
        highi:=i;
      end else dec (i);
    end;
    current:=1;
    i:=1;
    j:=4;
    repeat
      makehighlight (true,menu2[current].desc,false);
      c:=upcase (inchar);
      case c of
        'A':begin
              makehighlight (false,menu2[current].desc,false);
              dec (current);
              if current<1 then begin
                current:=nummenu2;
                i:=highi;
                j:=highj;
              end else begin
                dec (i);
                if i<1 then begin
                  i:=3;
                  dec (j,2);
                end;
              end;
            end;
        'Z':begin
              makehighlight (false,menu2[current].desc,false);
              inc (current);
              if current>nummenu2 then begin
                current:=1;
                i:=1;
                j:=4;
              end else begin
                inc (i);
                if i>3 then begin
                  i:=1;
                  inc (j,2);
                end;
              end;
            end;
      end;
    until not online or (c=#13);
    if not online then domenu:='' else domenu:=menu2[current].key;
  end else }begin
    inlen:=30;
    {if user.fprompt then begin
      sss:=olread;
      jj:=(80-length (sss)) div 2;
      sendxy (1,24,'');
      cleareol;
      if user.showol then sendxy (jj,24,^Y);
      sendwritecolor (sss);
      sendxy (1,22,'');
      cleareol;
      if length (prmpt1)>0 then sendxy (1,22,prmpt1);
      if length (prmpt2)>0 then begin
        sendxy (1,23,'');
        cleareol;
        if length (prmpt2)>0 then sendxy (1,23,prmpt2);
      end;
      prompt (' ');
      domenu:=uppercase (input);
    end else begin}
      if user.showol then sendwritelncolor{} (^Y+olread);
      lastprmpt:='';
      if not registered then begin
        sendwrite (^M'This copy is NOT registered!'^M);
        delay (500);
      end;
      if length (prmpt1)>0 then lastprmpt:=lastprmpt+prmpt1;
      if (length (prmpt1)>0) and (length (prmpt2)>0) then lastprmpt:=lastprmpt+^M;
      if length (prmpt2)>0 then lastprmpt:=lastprmpt+prmpt2;
      prompt (lastprmpt+' ');
      domenu:=uppercase (input);
    {end;}
  end;
end;

procedure runmenu (menuname:string);
  label done;
  var b,bb,bbb:boolean;
      i,ii,iii,j,jj:integer;
      temp:menurec;
      prmpt1,prmpt2,p1,p2,s,ss:string;
      dir,fil,ext:string[80];
begin
  fsplit (s,dir,fil,ext);
  b:=false;
  clearscreen;
  s:=setup.menudir+menuname;
  ss:='';
  nummenu:=0;
  assign (menufile,s);
  {$I-}reset (menufile);{$I+}
  if ioresult<>0 then begin
    sendwriteln (^Y+s+' does not exist!');
    exit;
  end;
  for i:=1 to 100 do characc[i]:='';
  readln (menufile,msubject);
  readln (menufile,prmpt1);
  readln (menufile,prmpt2);
  while not (eof (menufile)) do begin
    with temp do begin
      readln (menufile,key);
      readln (menufile,desc);
      readln (menufile,comm);
      readln (menufile,tlevel);
      readln (menufile,level);
    end;
    b:=false;
    ii:=temp.tlevel;
    iii:=temp.level;
    if ii=0 then if user.mlevel>=iii then b:=true;
    if ii=1 then if user.msglevel>=iii then b:=true;
    if ii=2 then if user.xflevel>=iii then b:=true;
    if temp.key='|' then runcommand (temp) else begin
      if b then begin
        inc (nummenu);
        characc[nummenu]:=temp.key;
        menu[nummenu]:=temp;
      end;
    end;
  end;
  close (menufile);
  p1:=prmpt1;
  p2:=prmpt2;
  while online do begin
    if user.cprompt=1 then begin
      prmpt1:=user.curprompt1;
      prmpt2:=user.curprompt2;
    end else begin
      prmpt1:=p1;
      prmpt2:=p2;
    end;
   {if areaop then closearea;
    if xferop then closefile;
    if msgareaop then closemsgarea;
    if postop then closepost;}
    inlen:=30;
    if (timeleft<6) and (timeleft>0) then
      sendwriteln (^Y'Auto-disconnecting in '+strr (timeleft)+' minute(s)!');
    filterprompt (prmpt1);
    filterprompt (prmpt2);
    if (timeleft<1) or (timeevent<=3) then begin
      if (timeleft<1) then sendwriteln (^Y'Auto-disconnecting...  Call back tomorrow!') else
      if (timeevent<=3) then sendwriteln (^Y'Auto-disconnecting...  Call back after the event!');
      hangupmodem;
      goto done;
    end;
    ss:=domenu (prmpt1,prmpt2);
    {if ss='/HEYCHICO' then begin
      bbb:=scrollon;
      set_scroll (true);
      chatcall;
      set_scroll (bbb);
    end;}
    if ss='?' then begin
      if setup.internalmenus then begin
        clearscreen;
        nl;
        bb:=true;
        for i:=1 to nummenu do begin
          b:=false;
          ii:=menu[i].tlevel;
          iii:=menu[i].level;
          if ii=0 then if user.mlevel>=iii then b:=true;
          if ii=1 then if user.msglevel>=iii then b:=true;
          if ii=2 then if user.xflevel>=iii then b:=true;
          if (length (menu[i].desc)>0) and b then begin
            spacewrite (^X'['^Z+menu[i].key+^X'] '^Y+menu[i].desc,39);
            bb:=not bb;
            if bb then nl;
          end;
        end;
        if not bb then nl;
        nl;
      end else begin
        fsplit (menuname,dir,fil,ext);
        printfile (fil,false);
      end;
    end;
    if (ss='/G') or (ss='/O') then hangupmodem else
    for i:=1 to nummenu do if (not (ss='')) and (match (ss[1],menu[i].key)) then begin
      b:=false;
      ii:=menu[i].tlevel;
      iii:=menu[i].level;
      if ii=0 then if user.mlevel>=iii then b:=true;
      if ii=1 then if user.msglevel>=iii then b:=true;
      if ii=2 then if user.xflevel>=iii then b:=true;
      if b then runcommand (menu[i]);
    end;
  end;
  done:
end;

procedure setdefcolors (var userr:userrec);
  var i:integer;
begin
  for i:=1 to 8 do userr.color[i]:=setup.defcolor[i];
end;

procedure changeconf (b:boolean; c:char);
  label aft;
  var confer:conference;
      i,ii:integer;
      ss,sss:string[80];

  procedure createconf;
    var i:integer;
  begin
    i:=numconf+1;
    if doyesno ('Create conference #'+strr (i)+'?') then begin
      prompt ('Conference name'^X': ');
      conf.name:=input;
      conf.qv:=doyesno ('Grant in Quick Validation?');
      seek (conff,i-1);
      write (conff,conf);
      sendwriteln (^Y'Conference #'+strr (i)+' created.');
      writesysoplog ('Added conference #'+strr (i),user.handle);
    end else exit;
  end;

  procedure listconf;
    var i:integer;
        s:longstr;
  begin
    clearscreen;
    if c='M' then s:='Message Conferences' else if c='T' then s:='Transfer Conferences';
    header (s);
    {sendwriteln (^Y'Conferences'^M);}
    sendwriteln (^X' ['^Z'M'^X'] '^Y'Main');
    for i:=1 to numconf do begin
      seek (conff,i-1);
      read (conff,conf);
      if confer[i] then sendwriteln (^X' ['^Z+strr (i)+^X'] '^Y+conf.name);
    end;
  end;

  procedure deleteconf;
    var i,ii:integer;
        temp:confrec;
        u:userrec;
  begin
    repeat
      prompt (^M'Conference # to delete '^X'['^Z'?'^X'/'^Y'List'^X']: ');
      if input[1]='?' then listconf;
    until ((input[1]<>'?') or not online);
    if length (input)<1 then exit;
    i:=valu (input);
    if not (i>0) and (i<=numconf) then begin
      sendwriteln (^Y'Invalid conference!');
      exit;
    end;
    for ii:=i to numconf-1 do begin
      seek (conff,ii);
      read (conff,temp);
      seek (conff,ii-1);
      write (conff,temp);
    end;
    seek (conff,numconf-1);
    truncate (conff);
    {}sendwriteln (^Y'Settings user flags.');
    useropen (false);
    for ii:=1 to filesize (userf) do begin
      seek (userf,ii-1);
      read (userf,u);
      for i:=1 to maxconf-1 do begin
        u.msgconf[i]:=u.msgconf[i+1];
        u.xferconf[i]:=u.xferconf[i+1];
      end;
      u.msgconf[i]:=false;
      u.xferconf[i]:=false;
      seek (userf,ii-1);
      write (userf,u);
    end;
    useropen (true);{}
    writesysoplog ('Delete conference #'+strr (i),user.handle);
  end;

  function allowed (i:integer):boolean;
  begin
    if i<>0 then allowed:=confer[i] else allowed:=true;
  end;

begin
  openconf (c);
  {if b then begin
    ss:=copy (input,2,255);
    if ss[1]='M' then begin
      ii:=0;
      goto aft;
    end else begin
      i:=valu (ss);
      if i<>0 then begin
        ii:=i;
        goto aft;
      end;
    end;
  end;}
  if c='M' then confer:=user.msgconf else if c='T' then confer:=user.xferconf;
  repeat
    if curconf=0 then ss:='M' else ss:=strr (curconf);
    ii:=-1;
    sss:=^M'Conference # '^X'['^Z'?'^X'/'^Y'List  ';
    if cosysop (0) then sss:=sss+^Z+'C'^Y'reate  '^Z'D'^Y'elete  ';
    sss:=sss+^Z+'CR'^X'/'^Y+ss+^X']: ';
    prompt (sss);
    input:=uppercase (input);
    if not (input='') then begin
      if valu (input)>0 then ii:=valu (input);
      if input[1]='?' then listconf;
      if cosysop (0) then begin
        if input[1]='C' then if numconf+1<=maxconf then createconf;
        if input[1]='D' then deleteconf;
      end;
      if input[1]='M' then ii:=0;
    end else ii:=curconf;
  until ((ii>-1) and (ii<=numconf) and (allowed (ii))) or not online;
  if {(s[1]='Q') or }not online then begin
    close (conff);
    exit;
  end;
  aft:
  if ii<>0 then begin
    seek (conff,ii-1);
    read (conff,conf);
  end else conf.name:='Main';
  close (conff);
  sendwriteln (^Y'Switching to '^X'['^Z'#'+strr (ii)+^X' - '^Z+conf.name+^X']'^M);
  curconf:=ii;
  curconfname:=conf.name;
end;

procedure changeuser;
  var un,nlvl,ntime,tmp:integer;
      u:userrec;
begin
  {if tempsysop then begin
    writestr ('Disabling temporary sysop powers...');
    ulvl:=regularlevel;
    tempsysop:=false
  end;}
  prompt ('User to change to'^X': ');
  if length (input)<1 then exit;
  un:=finduser (input);
  if usernum=un then begin
    sendwriteln (^M^Y'You cannot transfer to yourself!'^M^M);
    exit;
  end;
  if un=0 then begin
    sendwriteln (^M^Y'No such user!'^M^M);
    exit;
  end;
  readuser (u,un);
  if not sysop (0) then if not passwrd (u) then begin
    {log}
    exit;
  end;
  closefiles (false);
  ntime:=0;
  if user.lastondate<>curdate then if user.dailytime>0 then user.time:=user.dailytime else
  user.time:=20;
  if user.time<10 then begin
    sendwriteln (^Y'This user has '+strr (user.time)+' minute(s) left!');
    prompt ('New time left'^X': ');
    ntime:=valu (input);
  end;
  usernum:=un;
  writesysoplog ('Changed to user #'+strr (un),user.handle);
  readuser (user,usernum);
  if ntime<>0 then begin
    user.time:=ntime;
    writeuser (user,usernum);
  end;
end;

procedure openbl;
begin
  assign (blf,setup.datadir+'BLACKLST.DAT');
  {$I-}reset (blf);{$I+}
  if ioresult<>0 then {$I-}rewrite (blf);{$I+}
end;

procedure closebl;
begin
  close (blf);
end;

procedure addtoblacklist (s:string);
begin
  openbl;
  seek (blf,filesize (blf));
  bl.name:=s;
  write (blf,bl);
  closebl;
  writesysoplog ('Added name to blacklist',user.handle);
end;

function findblacklist (s:string):boolean;
  label done;
  var b:boolean;
      i:integer;
begin
  openbl;
  for i:=1 to filesize (blf) do begin
    seek (blf,i-1);
    read (blf,bl);
    if match (bl.name,s) then begin
      b:=true;
      goto done;
    end;
  end;
  b:=false;
  closebl;
  done:
  findblacklist:=b;
end;

procedure deleteblacklist (s:string);
  var i,ii:integer;
begin
  openbl;
  for i:=1 to filesize (blf) do begin
    seek (blf,i-1);
    read (blf,bl);
    if match (bl.name,s) then begin
      for ii:=i to filesize (blf)-1 do begin
        seek (blf,ii);
        read (blf,bl);
        seek (blf,ii-1);
        write (blf,bl);
      end;
      seek (blf,filesize (blf)-1);
      truncate (blf);
    end;
  end;
  closebl;
  writesysoplog ('Deleted name from blacklist',user.handle);
end;

procedure listblacklist;
  var i:integer;
begin
  openbl;
  if filesize (blf)<1 then exit;
  clearscreen;
  header ('Blacklist Editor');
  for i:=1 to filesize (blf) do begin
    seek (blf,i-1);
    read (blf,bl);
    sendwriteln (^X'['^Z+strr (i)+^X'] '^Y+bl.name);
  end;
  nl;
  closebl;
end;

procedure blacklist;
  var c:char;
begin
  repeat
    listblacklist;
    prompt ('Blacklist Editor'^X': '^Z'A'^Y'dd  '^Z'D'^Y'elete'^X': ');
    if not (input='') then begin
      c:=upcase (input[1]);
      case c of
        'A':begin
              inlen:=30;
              prompt ('Name to add to blacklist'^X': ');
              if length (input)>0 then addtoblacklist (input);
            end;
        'D':begin
              inlen:=30;
              prompt ('Name to delete from blacklist'^X': ');
              if length (input)>0 then deleteblacklist (input);
            end;
      end;
    end;
  until (c='Q') or not online;
end;

procedure phonesearch;
  var b:boolean;
      i:integer;
      u:userrec;
begin
  b:=false;
  header ('Phone Number Search');
  inlen:=12;
  prompt ('Enter #/# fragment to search for'^X': ');
  for i:=1 to numusers do begin
    readuser (u,i);
    if pos (input,u.phone)>0 then begin
      sendwriteln (^Y+u.handle+^X' - '^Y+u.phone);
      b:=true;
    end;
  end;
  if b then nl;
  writesysoplog ('Searched for '+input,user.handle);
end;

procedure togglechat;
begin
  if scrollon then begin
    set_scroll (false);
    sendwriteln (^Y'Sysop now unavailable.');
  end else begin
    set_scroll (true);
    sendwriteln (^Y'Sysop now available.');
  end;
  writesysoplog ('Toggled chat availability',user.handle);
end;

procedure assignnuv;
begin
  assign (nuvf,setup.datadir+'NUV.DAT');
end;

procedure opennuvf;
begin
  assignnuv;
  {$I-}reset (nuvf);{$I+}
  if ioresult<>0 then {$I-}rewrite (nuvf);{$I+}
end;

procedure closenuvf;
begin
  close (nuvf);
end;

function numnuvf:integer;
begin
  numnuvf:=filesize (nuvf);
end;

procedure seeknuvf (i:integer);
begin
  seek (nuvf,i-1);
end;

procedure addnuv (user:userrec; usernm:integer);
  var i:integer;
begin
  {opennuvf;}
  with nuv do begin
    handle:=user.handle;
    usernum:=usernm;
    for i:=1 to maxnuvotes do begin
      uservote[i]:=0;
      votedyes[i]:=false;
    end;
    for i:=1 to maxnuvcom do begin
      comment[i]:='';
      bycomment[i]:='';
    end;
  end;
  seeknuvf (numnuvf+1);
  write (nuvf,nuv);
  {closenuvf;}
end;

procedure removenuv (var location:integer);
  var i:integer;
      n:nuvrec;
begin
  {opennuvf;}
  for i:=location to numnuvf-1 do begin
    seeknuvf (i+1);
    read (nuvf,n);
    seeknuvf (i);
    write (nuvf,n);
  end;
  seeknuvf (numnuvf);
  truncate (nuvf);
  {closenuvf;}
  dec (location);
end;

function voted_on (i:integer):boolean;
  var b:boolean;
      ii,num:integer;
      n:nuvrec;
begin
  seeknuvf (i);
  read (nuvf,n);
  b:=false;
  for ii:=1 to maxnuvotes do if n.uservote[ii]=usernum then b:=true;
  voted_on:=b;
end;

function num_vote_on:integer;
  var b:boolean;
      i,num:integer;
      n:nuvrec;
begin
  opennuvf;
  num:=0;
  for i:=1 to numnuvf do if not voted_on (i) then inc (num);
  closenuvf;
  num_vote_on:=num;
end;

function vote_loc (user:integer):integer;
  var i:integer;
begin
  for i:=1 to maxnuvotes do if nuv.uservote[i]=user then vote_loc:=i;
end;

function first_blank:integer;
  var i,ii:integer;
begin
  first_blank:=0;
  i:=0;
  while i<maxnuvotes do begin
    inc (i);
    if nuv.uservote[i]=0 then begin
      first_blank:=i;
      exit;
    end;
  end;
end;

procedure remove_vote (i:integer);
  var ii,voteloc:integer;
begin
  voteloc:=vote_loc (i);
  for ii:=voteloc to maxnuvotes-1 do with nuv do begin
    uservote[ii]:=uservote[ii+1];
    votedyes[ii]:=votedyes[ii+1];
  end;
  nuv.uservote[maxnuvotes]:=0;
  nuv.votedyes[maxnuvotes]:=false;
end;

function numcomment:integer;
  var i,num:integer;
begin
  num:=0;
  for i:=1 to maxnuvcom do if length (nuv.comment[i])>0 then inc (num);
  numcomment:=num;
end;

procedure showcomment;
  var i:integer;
begin
  for i:=1 to maxnuvcom do if length (nuv.comment[i])>0 then sendwriteln (^Y+nuv.bycomment[i]+^X': '^Z+nuv.comment[i]);
  nl;
end;

procedure figureyesno (u:nuvrec; var yes,no:byte);
  var i:integer;
begin
  yes:=0;
  no:=0;
  for i:=1 to maxnuvotes do if nuv.uservote[i]<>0 then begin
    if nuv.votedyes[i] then inc (yes) else inc (no);
  end;
end;

procedure listpending;
  var i:integer;
      yes,no:byte;
begin
  opennuvf;
  if numnuvf<1 then begin
    sendwrite (^M^Y'No users in NUV!'^M^M);
    closenuvf;
    exit;
  end;
  for i:=1 to numnuvf do begin
    seeknuvf (i);
    read (nuvf,nuv);
    figureyesno (nuv,yes,no);
    sendwriteln (^Y+nuv.handle+^X': '^Z+strr (yes)+^X'/'^Z+strr (no));
  end;
  nl;
  closenuvf;
end;

function added_comment (s:medstr):boolean;
  var i:integer;
begin
  added_comment:=false;
  for i:=1 to maxnuvcom do if match (nuv.bycomment[i],s) then added_comment:=true;
end;

procedure overrule (var i:integer; cc:char; var u:userrec);
begin
  readuser (u,nuv.usernum);
  removenuv (i);
  if cc='V' then begin
    quickvalidate (u,nuv.usernum,'U');
    sendwriteln (^Y'Auto-validating '^Z+nuv.handle);
  end else if cc='D' then begin
    u.mlevel:=-5;
    writeuser (u,nuv.usernum);
    sendwriteln (^Y'Auto-deleting '^Z+nuv.handle);
  end;
end;

procedure newuservoting (login:boolean);
  label ext;
  var c,cc:char;
      i,ii,numcom:integer;
      skip,b,vote:boolean;
      s,ss:string[50];
      u:userrec;
begin
  if login then i:=num_vote_on else begin
    opennuvf;
    i:=numnuvf;
    closenuvf;
  end;
  if i<1 then begin
    if not login then sendwrite (^M^Y'No users to vote on!'^M^M);
    exit;
  end;
  if user.mlevel<=setup.minnuv then begin
    if not login then sendwrite (^M^Y'You can''t vote!'^M^M);
    exit;
  end;
  skip:=doyesno ('Skip users already voted on?');
  i:=0;
  opennuvf;
  while i<numnuvf do begin
    inc (i);
    b:=voted_on (i);
    if skip and b then else begin
      seeknuvf (i);
      read (nuvf,nuv);
      sendwriteln (^Y'User'^X': '^Z+nuv.handle);
      if b then if not doyesno ('Change your vote?') then goto ext;
      if doyesno ('View NUV interview?') then showiv (nuv.usernum,setup.nuvintvw);
      numcom:=numcomment;
      if numcom>0 then if doyesno ('View comments?') then showcomment;
      s:=^Y'Vote'^X': '^Z'Y'^Y'es  '^Z'N'^Y'o  '^Z'A'^Y'bstain';
      ss:=^X': ';
      if sysop (0) then ss:='  '^Z'R'^Y'emove  '^Z'O'^Y'verrule'+ss;
      inlen:=1;
      prompt (s+ss);
      if input='' then c:='A' else c:=upcase (input[1]);
      case c of
        'Y','N':begin
                  vote:=c='Y';
                  if b then remove_vote (i);
                  ii:=first_blank;
                  nuv.uservote[ii]:=usernum;
                  nuv.votedyes[ii]:=vote;
                  if (numcom<maxnuvcom) and not (added_comment (user.handle)) then if doyesno ('Add a comment?') then begin
                    prompt (^X': ');
                    if not (input='') then begin
                      nuv.bycomment[numcom+1]:=user.handle;
                      nuv.comment[numcom+1]:=input;
                    end;
                  end;
                  seeknuvf (i);
                  write (nuvf,nuv);
                  readuser (u,nuv.usernum);
                  figureyesno (nuv,u.voteyes,u.voteno);
                  writeuser (u,nuv.usernum);
                  if setup.autonuv then begin
                    if u.voteyes>=setup.yesvote then overrule (i,'V',u) else
                    if u.voteno>=setup.novote then overrule (i,'D',u);
                  end;
                end;
        'A':{if b then remove_vote (i)};
        'R':if sysop (0) then removenuv (i);
        'O':if sysop (0) then begin
              prompt (^Z'D'^Y'elete  '^Z'V'^Y'alidate '^X'['^Z'CR'^X'/'^Y'V'^X']: ');
              if input='' then cc:='V' else cc:=upcase (input[1]);
              case cc of
                'V','D':overrule (i,cc,u);
              end;
            end;
      end;
    end;
    ext:
  end;
  closenuvf;
end;

end.