{$I+,S+}
unit lineedit;

interface

uses crt,dos,inout,records,strunit,windows;

function linereedit (var m:msgrec; title:boolean):boolean;

implementation

function linereedit (var m:msgrec; title:boolean):boolean;
var done,editmode,pause:boolean;
    curline,i,ii,cols:integer;
    s:string[80];

  procedure init;
  begin
    cols:=79;
    linereedit:=false;
    done:=false;
    editmode:=false;
    curline:=1;
    clearscreen;
    if m.numlines=0 then begin
      sendwriteln (^X'[ '^Y+bbsname+' '+bbsver+' Message Editor '^X']');
      sendwrite (^Y'Title'^X': '^Z);
      sendwritelncolor (m.subject);
      sendwriteln (^Y'Receiver'^X': '^Z+m.receiver);
      sendwriteln (^M^Y'Lines available'^X': '^Z+strr (maxlines));
    end else begin
      sendwriteln (^M^Y'Re-editing message.');
      sendwriteln (^Y'Current size'^X': '^Z+strr (m.numlines));
      sendwriteln (^Y'Note'^X': '^Y'Inserting before line 1.');
      sendwriteln (^Z'/A '^Y'will abort changes.'^M);
    end;
    sendwriteln (^Y'Enter '^Z'/? '^Y'for help  '^Z'/S '^Y'to save'^M);
  end;

  function msgisblank:boolean;
  begin
    if m.numlines>0 then msgisblank:=false else begin
      sendwriteln (^Y'Message is blank!');
      msgisblank:=true;
    end;
  end;

  function getrange:boolean;
  begin
    range (m.numlines,i,ii);
    getrange:=i<>0;
  end;

  function getlinenum (txt:string):boolean;
  begin
    prompt (^Y'Line # to '+txt+^X': ');
    i:=valu (input);
    ii:=i;
    if (i>=1) and (i<=m.numlines) then getlinenum:=true else begin
      getlinenum:=false;
      sendwriteln (^Y'Invalid line!');
    end;
  end;

  procedure inslines (i,ii:integer);
    var n,cnt:integer;
  begin
    n:=ii-i+1;
    m.numlines:=m.numlines+n;
    for cnt:=m.numlines downto ii+1 do m.text[cnt]:=m.text[cnt-n];
  end;

  procedure dellines (i,ii:integer);
  var n,cnt:integer;
  begin
    n:=ii-i+1;
    m.numlines:=m.numlines-n;
    for cnt:=i to m.numlines do m.text[cnt]:=m.text[cnt+n];
  end;

  procedure insertline (s:string);
  var cnt:integer;
  begin
    if m.numlines=maxlines then exit;
    inslines (curline,curline);
    m.text[curline]{^}:=s;
    curline:=curline+1;
  end;

  function iseditcommand (s:string):boolean;
  begin
    iseditcommand:=(s[1]='/') and (length (s)>0);
  end;

  function userissure:boolean;
  begin
    sendwriteln (^Y'Warning!  Message will be erased!');
    userissure:=doyesno ('Confirm'^X':');
  end;

  procedure topofmsg;
  begin
    sendwriteln (^X'['^Y'Top of message'^X']');
  end;

  procedure abortmes;
  begin
    done:=userissure;
  end;

  procedure backline;
  begin
    if m.numlines<1 then begin
      topofmsg;
      exit;
    end;
    sendwriteln (^X'['^Y'Previous line'^X']');
    curline:=curline-1;
    dellines (curline,curline);
  end;

  procedure continuemes;
  begin
    sendwriteln (^M^Y'Continue your message.');
    curline:=m.numlines+1;
    editmode:=false;
  end;

  procedure deletelines;
  begin
    if not getrange then exit;
    if (i=1) and (ii=m.numlines) then begin
      if not doyesno ('Delete whole message?') then exit;
    end;
    dellines (i,ii);
  end;

  procedure seteditmode;
  begin
    if editmode then sendwriteln (^Y'You are already in edit mode!') else editmode:=true;
  end;

  procedure fixline;
  begin
    if not getlinenum ('fix') then exit;
    sendwriteln (^Y'Line currently reads'^X':');
    sendwriteln (m.text[i]{^}+^M);
   {wordwrap:=false;}
    inlen:=cols;
    prompt (^Y'Enter new line'^X':'^M);
    if length (input)<>0 then m.text[i]{^}:=input;
    continuemes;
  end;

  procedure insertlines;
  begin
    if not getlinenum ('insert before') then continuemes;
    curline:=i;
  end;

  procedure listmes;
    var n,i,ii:integer;
      linenum:boolean;
  begin
    if msgisblank then exit;
    range (m.numlines,i,ii);
    if i=0 then exit;
    linenum:=doyesno ('Line numbers?');
    sendwrite (^Y);
    for n:=i to ii do begin
      if linenum then sendwriteln (^Y+strr (n)+^X':');
      sendwriteln (^Y+m.text[n]{^});
      if charready then exit;
    end
  end;

  procedure centerline;
    var spaces:string[80];
  begin
    fillchar (spaces[1],80,32);
    if editmode then begin
      inlen:=cols;
     {wordwrap:=false;}
      prompt (^Y'Enter line to center'^X':'^M);
    end else delete (input,1,1);
    while (length (input)>0) and (input[1]=' ') do delete (input,1,1);
    if length (input)=0 then exit;
    spaces[0]:=chr((cols-length (input)) div 2);
    input:=spaces+input;
    insertline (input);
  end;

  procedure clearmes;
  begin
    if userissure then begin
      sendwriteln (^Y'Starting message over.');
      m.numlines:=0;
      curline:=1;
    end;
  end;

  procedure searchandreplace;
  var sfor,repw:string[80];
      l:^string;
      ask:boolean;
      cl,cp,sl,max:integer;

    procedure replace;
      var new,old:string[80];
    begin
      old:=copy (l^,cp,sl);
      new:=repw;
      if length(new)>0 then if old[1] in ['A'..'Z'] then new[1]:=upcase (new[1]);
      delete (l^,cp,sl);
      while length(l^)+length(new)>cols do l^[0]:=pred(l^[0]);
      insert (new,l^,cp);
      cp:=cp+length(new)-1;
    end;

    procedure maybereplace;
      var i:integer;
    begin
      if ask then begin
        sendwriteln (^M^Y+strr (cl)+^X':'^M^Y+l^);
        for i:=1 to cp-1 do sendwrite (' ');
        for i:=1 to sl do sendwrite ('^');
        nl;
        if not doyesno ('Replace?') then exit;
      end;
      replace;
    end;

  begin
    if msgisblank then exit;
    prompt (^Y'Search for'^X': ');
    if length (input)=0 then exit;
    sfor:=uppercase (input);
    sl:=length (input);
    prompt (^Y'Replace with'^X': ');
    repw:=input;
    ask:=doyesno ('Ask each time?');
    max:=length (l^)-sl+1;
    for cl:=1 to m.numlines do begin
      l:=addr (m.text[cl]);
      max:=length (l^)-sl+1;
      cp:=0;
      while cp<max do begin
        cp:=cp+1;
        if match(sfor,copy(l^,cp,sl)) then maybereplace;
        max:=length(l^)-sl+1;
      end;
    end;
    sendwriteln (^M'Search and replace complete.');
  end;

  procedure savemes;
  begin
    done:=true;
    if m.numlines=0 then sendwriteln (^Y'Message blank!') else begin
      sendwriteln (^Y'Saving message.');
      linereedit:=true;
    end;
  end;

  procedure retitle;
  begin
    if title then begin
      sendwrite (^Y'Title'^X': '^Z);
      sendwritelncolor (m.subject);
      prompt (^Y'Enter new title'^X': ');
      if length (input)>0 then m.subject:=input;
    end else sendwriteln (^Y'This message can''t have a title.');
  end;

  procedure edithelp;
  begin
   {printfile (configset.textfiledi+'Edithelp.');}
    clearscreen;
    sendwriteln (^Y'A-Abort Message  B-Previous Line   C-Continue Message');
    sendwriteln (^Y'D-Delete Lines   E-Set Edit Mode   F-Fix Line');
    sendwriteln (^Y'I-Insert Lines   L-Show Message    M-Center Line');
    sendwriteln (^Y'N-Clear Message  R-Search/Replace  S-Save Message');
    sendwriteln (^Y'T-Re-enter Title');
    nl;
    editmode:=true;
  end;

  procedure editcommand (s:string);
    var c:char;
  begin
    while iseditcommand (s) and (length (s)>0) do delete (s,1,1);
    if length (s)=0 then begin
      editmode:=true;
      exit;
    end;
    c:=upcase (s[1]);
    case c of
      'A':abortmes;
      'B':backline;
      'C':continuemes;
      'D':deletelines;
      'E':seteditmode;
      'F':fixline;
      'I':insertlines;
      'L':listmes;
      'M':centerline;
      'N':clearmes;
      'R':searchandreplace;
      'S':savemes;
      'T':retitle;
      else edithelp;
    end;
  end;

  procedure editcommands (ss:string);
  begin
    editcommand (ss);
    while editmode and not done do begin
      prompt (^Y'Command '^X'['^Z'?'^X'/'^Y'Help'^X']: ');
      if not online then done:=true else editcommand (input);
    end;
  end;

  procedure getline (var ss:string);
    var b:boolean;
        c:char;
        i:integer;
  begin
    ss:='/E';
    if m.numlines=maxlines then begin
      sendwriteln (^Y'Sorry, message is full!');
      exit;
    end;
    if not online then exit;
    if m.numlines=maxlines-2 then sendwriteln ('Two lines left!');
    if curline>m.numlines+1 then curline:=m.numlines+1;
    lastprmpt:=^Y'Continue your message.'^M;
    inlen:=cols;
    recv;
    ss:=input;
  end;

  procedure getlines (var ss:string);
  begin
    repeat
      getline (input);
      if not iseditcommand (input) then begin
        inc (m.numlines);
        m.text[m.numlines]{^}:=input;
      end;
    until not online or iseditcommand (input) or (m.numlines=maxlines);
    if not iseditcommand (input) then input:='/';
    ss:=input;
  end;

begin
  pause:=user.pause;
  user.pause:=false;
  init;
  repeat
    getlines (s);
    editcommands (s);
  until done;
  user.pause:=pause;
  nl;
  statusline (0);
end;

begin
end.

