{$I+,S+}
unit inout;

interface

uses crt,dos,records,strunit,modem,mdm,windows,apansi,usermisc,
     fastttt5,keyttt5,winttt5,menuttt5,readttt5,execswap;

type logstr=medstr;

procedure printfile (s:string; bb:boolean);
procedure showlastprompt;
procedure shelltodos (b:boolean);
procedure runsetup (b:boolean);
procedure runeditor (s:string; b:boolean);
function ansi:boolean;
function avt:boolean;
procedure writeline (b:byte);
procedure spacewrite (s:string; b:byte);
procedure charwrite (c:char; b:byte);
procedure header (s:string);
procedure send (s:string);
procedure sendwrite (s:string);
procedure sendwriteln (s:string);
procedure sendwritecolor (s:string);
procedure sendwritelncolor (s:string);
procedure prompt (s:string);
procedure nl;
function readchar:char;
function bioskey:char;
function charready:boolean;
function inchar:char;
procedure inchardelay (i:word; cc:char);
function shinchar:char;
procedure clearinp (b:byte);
procedure recv;
function online:boolean;
procedure chat;
procedure cursor (b:boolean);
procedure pause;
procedure ansicolor (attrib:byte);
procedure clearscreen;
procedure cleareol;
function cosysop (i:integer):boolean;
function sysop (i:integer):boolean;
function doyesno (s:string):boolean;
procedure sendxy (x,y:integer; s:string);
procedure ansi_window (x,y,xx,yy:integer);
procedure range (numents:integer; var f,l:integer);
procedure hangupmodem;
procedure seeknode (i:integer);
procedure opennode;
procedure closenode;
procedure updatenode (i,action:integer; handle:longstr);
procedure displaynodeinfo;
{procedure initdirect;}
function findusernum:integer;
{function sendwritestr (i:integer):string;}
procedure dorinfo1;
procedure def_user;
procedure wwiv_chain;
function getlastcaller:string;
procedure directoutchar (c:char);
procedure writesysoplog (s,ss:logstr);
function stripchar (c:char; s:longstr):longstr;
function stripcolor (s:longstr):longstr;

implementation

const SwapLoc:Array[Boolean] of String[7]=('on disk','in EMS');

var Main_Choice,Choice,Error,error1:integer;
    X, Y, ScanTop, ScanBot:byte;
    M1,MM:Menu_record;
    Done,done1:Boolean;

function stripdate:smstr;
  var s:datistr;
begin
  s:=curdate;
  while pos ('/',s)>0 do delete (s,pos ('/',s),1);
  stripdate:=s;
end;

procedure printfile (s:string; bb:boolean);
  label exit;
  var c,cc:char;
      f:text;
      i,ii,j:integer;
      sss:string;
      ss:pathstr;
      dir:dirstr;
      fil:namestr;
      ext:extstr;

begin
  i:=textattr;
  if bb then begin
    fsplit (s,dir,fil,ext);
    if dir='' then dir:=setup.textdir;
    ss:=dir+fil;
    if ansi then ss:=ss+'.ANS';
  end else ss:=s;
  assign (f,ss);
  {$I-}reset (f);{$I+}
  if ioresult<>0 then sendwrite (^M^Y'File not found.'^M) else begin
    while not eof (f) and online do begin
      readln (f,sss);
      j:=0;
      while j<length (sss) do begin
        inc (j);
        c:=sss[j];
        if charready and (readchar=' ') then begin
          close (f);
          goto exit;
        end;
        with user do begin
          case c of
            '@':begin
                  {read (f,cc);}
                  inc (j);
                  cc:=sss[j];
                  case cc of
                    'A':sendwrite (handle);
                    'B':sendwrite (realname);
                    'C':sendwrite (maddress[1]);
                    'D':sendwrite (maddress[2]);
                    'E':sendwrite (occup);
                    'F':sendwrite (bbsref);
                    'G':begin
                          ii:=textattr;
                          sendwritecolor (note);
                          ansicolor (ii);
                        end;
                    {'H':sendwrite (forward);}
                    'I':sendwrite (password);
                    'J':sendwrite (phone);
                    {'K':sendwrite (zipcode);}
                    'L':sendwrite (bday);
                    'M':sendwrite (firston);
                    'N':sendwrite (laston);
                    {'O':sendwrite (state);}
                    'P':sendwrite (sex);
                    'Q':sendwrite (boostr (paid));
                    'R':sendwrite (strr (numup));
                    'S':sendwrite (strr (uploadk)+'k');
                    'T':sendwrite (strr (numdn));
                    'U':sendwrite (strr (downloadk)+'k');
                    'V':sendwrite (strr (numpost));
                    'W':sendwrite (strr (numon));
                    'X':sendwrite (strr (bankt));
                    'Y':sendwrite (strr (bankc));
                    'Z':sendwrite (strr (bankl));
                    'a':sendwrite (strr (dkperday));
                    'b':sendwrite (strr (kleft));
                    'c':sendwrite (strr (baudrate));
                    'd':sendwrite (strr (dailytime));
                    'e':sendwrite (strr (timeleft));
                    'f':sendwrite (strr (fpoint));
                    'g':sendwrite (strr (mlevel));
                    'h':sendwrite (strr (msglevel));
                    'i':sendwrite (strr (xflevel));
                    'j':sendwrite (strr (minpc)+'%');
                    'k':sendwrite (strr (pcp)+'%');
                    'l':sendwrite (strr (minud)+'%');
                    'm':sendwrite (strr (udp)+'%');
                    'n':begin
                          ii:=stat.ups-ups;
                          if ii<0 then ii:=0;
                          ups:=stat.ups;
                          sendwrite (strr (ii));
                        end;
                    'o':begin
                          ii:=stat.posts-posts;
                          if ii<0 then ii:=0;
                          posts:=stat.posts;
                          sendwrite (strr (ii));
                        end;
                    'p':sendwrite (curdate);
                    'q':sendwrite (curtime);
                    'r':sendwrite (boostr (sysopavail));
                    's':sendwrite (strr (age (user)));
                    't':sendwrite (getlastcaller);
                    {'u':begin
                          openmail;
                          sendwrite (strr (nummailu (user.handle,'I')));
                          closemail;
                        end;}
                    else sendwrite (c+cc);
                  end;
                end;
            else sendwrite (c);
          end;
        end;
      end;
      nl;
    end;
  end;
  exit:
  ansicolor (i);
       {color:array [1..4] of byte;
       conf:array [1..maxconf] of boolean;
       lastread:array [1..50,0..maxconf] of integer;
       filelist:set of filelisttype;}
end;

procedure showlastprompt;
begin
  sendwrite (lastprmpt+input);
end;

procedure shelltodos (b:boolean);
  const SwapLoc:Array[Boolean] of String[7]=('on disk','in EMS');
  var status:word;
      i:integer;
begin
  writesysoplog ('Sysop shelled to DOS',user.handle);
  if b then send (^Y+setup.shelltodos);
  i:=timeleft;
  window (1,1,80,25);
  clrscr;
  writeln ('Type "EXIT" to return.');
 {}writeln ('Allocated ',bytesswapped,' bytes ',swaploc[emsallocated]);{}
  {closeport;}
  cursor (true);
  {deactivateport;}
 {}status:=execwithswap (getenv ('COMSPEC'),'');{}
  {exec (getenv ('COMSPEC'),'');}
  {activateport;}
  chdir (copy (setup.bbsdir,1,length (setup.bbsdir)-1));
  if b then begin
    settimeleft (i);
    statusline (0);
  end;
  readsetup;
  clrscr;
end;

procedure runsetup (b:boolean);
  var status:word;
      i:integer;
begin
  writesysoplog ('Sysop ran setup program',user.handle);
  if b then send (^Y+setup.shelltodos);
  i:=timeleft;
  window (1,1,80,25);
  clrscr;
 {writeln ('Type "EXIT" to return.');}
 {}writeln ('Allocated ',bytesswapped,' bytes ',swaploc[emsallocated]);{}
  {closeport;}
  cursor (true);
  {deactivateport;}
 {}status:=execwithswap (getenv ('COMSPEC'),' /C SETUP.EXE');{}
  {exec (getenv ('COMSPEC'),' /C SETUP.EXE');}
  {activateport;}
  chdir (copy (setup.bbsdir,1,length (setup.bbsdir)-1));
  if b then begin
    settimeleft (i);
    statusline (0);
  end;
  readsetup;
  clrscr;
end;

procedure runeditor (s:string; b:boolean);
  var status:word;
      i:integer;
begin
  if b then send (^Y+setup.shelltodos);
  i:=timeleft;
  window (1,1,80,25);
  clrscr;
 {writeln ('Type "EXIT" to return.');}
 {}writeln ('Allocated ',bytesswapped,' bytes ',swaploc[emsallocated]);{}
  {closeport;}
  cursor (true);
  {deactivateport;}
 {}status:=execwithswap (getenv ('COMSPEC'),' /C '+s);{}
  {exec (getenv ('COMSPEC'),' /C '+s);}
  {activateport;}
  chdir (copy (setup.bbsdir,1,length (setup.bbsdir)-1));
  settimeleft (i);
  statusline (0);
  readsetup;
  clrscr;
end;

function ansi;
begin
  ansi:=user.emulation>0;
end;

function avt;
begin
  avt:={user.emulation=2}false{};
end;

procedure writeline (b:byte);
  var bb:byte;
begin
  sendwrite (^X);
  for bb:=1 to b do begin
    if ansi then sendwrite ('') else sendwrite ('-');
  end;
  nl;
end;

procedure spacewrite (s:string; b:byte);
  var bb:byte;
begin
  sendwrite (s);
  for bb:=length (stripcolor (s)) to b-1 do sendwrite (' ');
end;

procedure charwrite (c:char; b:byte);
  var bb:byte;
begin
  for bb:=1 to b do sendwrite (c);
end;

{b-dark blue  B-light blue  g-dark green  G-light green}
{c-dark cyan  C-light cyan  r-dark red    R-light red}
{m-magenta    M-l. magenta  y-brown       Y-yellow}
{w-d. white   W-white  D-grey}

procedure sendit (c:char; b:boolean);
begin
 if b then directoutchar (c) else if (not local) and (not outlock) then com_tx (c);
end;

procedure snd (s:string; b,color:boolean);
  var bb:byte;
      c:char;
begin
  bb:=0;
  while bb<length (s) do begin
    inc (bb);
    case s[bb] of
      '|':if color then begin
            inc (bb);
            case s[bb] of
              'b':ansicolor (1);'B':ansicolor (9);'g':ansicolor (2);'G':ansicolor (10);
              'c':ansicolor (3);'C':ansicolor (11);'r':ansicolor (4);'R':ansicolor (12);
              'm':ansicolor (5);'M':ansicolor (13);'y':ansicolor (6);'Y':ansicolor (14);
              'w':ansicolor (7);'W':ansicolor (15);'D':ansicolor (8);
              else dec (bb);
            end;
          end else sendit (s[bb],b);
      ^M:begin
           writeln;
           if (not local) and (not outlock) then com_tx_string (^M^J);
           if b then begin
             inc (linenum);
             if linenum>=user.displaylen then begin
               linenum:=1;
               if user.pause then pause;
             end;
           end;
         end;
      ^A:ansicolor (user.color[5]);
      ^B:ansicolor (user.color[6]);
      ^N:ansicolor (user.color[7]);
      ^O:ansicolor (user.color[8]);
      ^W:ansicolor (user.color[1]);
      ^X:ansicolor (user.color[2]);
      ^Y:ansicolor (user.color[3]);
      ^Z:ansicolor (user.color[4]);
      else sendit (s[bb],b);
    end;
  end;
end;

procedure send (s:string);
begin
  snd (s,false,false);
end;

procedure sendwrite (s:string);
begin
  snd (s,true,false);
end;

procedure sendwriteln (s:string);
begin
  snd (s+^M,true,false);
end;

procedure sendwritecolor (s:string);
begin
  snd (s,true,true);
end;

procedure sendwritelncolor (s:string);
begin
  snd (s+^M,true,true);
end;

procedure header (s:string);
  var i:integer;
      ss:string[79];
begin
  if not ansi then sendwriteln (^X'-[ '^Y+s+^X' ]-'^M) else begin
    sendwrite (^A+'');
    for i:=1 to length (stripcolor (s))+2 do sendwrite ('');
    sendwriteln ('');
    sendwriteln (' '^N+s+^A' ');
    sendwrite ('');
    for i:=1 to length (stripcolor (s))+2 do sendwrite ('');
    sendwriteln (''+^M);
  end;
end;

procedure prompt (s:string);
begin
  lastprmpt:=^Y+s+^Y;
  sendwrite (lastprmpt);
  recv;
end;

procedure nl;
begin
  sendwrite (^M);
end;

Procedure EditSettings;
begin
  Menu_Set(MM);
  With MM do begin
    Heading1 := bbsname+' '+bbsver;
    Heading2 := 'User Editor';
    Topic[1] := 'User Name';
    Topic[2] := 'Real Name';
    Topic[3] := 'Phone #';
    Topic[4] := 'Main Level';
    Topic[5] := 'Message Level';
    Topic[6] := 'Number of Posts';
    Topic[7] := 'Xfer Level';
    Topic[8] := 'Transfer Points';
    Topic[9] := 'Number of U/L''s';
    Topic[10]:= 'Upload K';
    Topic[11]:= 'Number of D/L''s';
    Topic[12]:= 'Download K';
    Topic[13]:= 'Birthdate';
    Topic[14]:= 'Daily Time';
    Topic[15]:= 'Time Left';
    Topic[16]:= 'Note';
    Topic[17]:= 'Conferences';
    Topic[18]:= 'Min Post/Call %';
    Topic[19]:= 'Min Up/Down %';
    Topic[20]:= 'Password';
    Topic[21]:= 'Quit & Save';
    TotalPicks := 21;
    PicksPerLine := 3;            {one column of choices}
    Addprefix := 2;
    TopleftXY[1] := 0;            {system will center menu}
    TopleftXY[2] := 0;            {Y coordinate}
    Boxtype := 5;                 {fancy box}
    Margins := 5;
    AllowEsc:=true;
  end;
  If BaseOfScreen = $B800 then with RTTT do begin
    FCol := white;
    BCol := blue;
    HiFCol := white;
    HiBCol := black;
    LoFCol := lightgray;
    LoBCol := black;
    PFCol := white;
    PBCol := blue;
    BoxFCol := white;
    BoxBCol := blue;
    Msg_FCol := white;
    Msg_BCol := blue;
  end;
  Choice:=1;
end; {Define_Menu1}

Procedure User_Editor_Menu (b:boolean; var u:userrec; unum:integer);
  var done:boolean;
      xx,yy,numitems:integer;

(*    procedure marklocation (ii:integer);
      var c:char;
          i,inle:integer;
          s:string[80];

        procedure writeit (j:integer; s:string);
          var iii:integer;
        begin
          write (s);
          if ii=i then inle:=j;
          for iii:=length (s) to j-1 do write (' ');
        end;

        function inchar:char;
          var c:char;
        begin
          repeat until keypressed or not online;
        end;

    begin
      done:=false;
      offcursor;
      for i:=1 to numitems do begin
        gotoxy (18,i+5);
        textcolor (15);
        if ii=i then textbackground (7) else textbackground (1);
        case i of
          1:writeit (30,user.handle);
          2:writeit (30,user.realname);
          3:writeit (20,user.password);
          4:writeit (12,user.phone);
          5:writeit (30,user.city);
          6:writeit (2,user.state);
          7:writeit (5,user.zipcode);
          8:writeit (8,user.bday);
          9:writeit (30,user.usernote);
        end;
      end;
      textbackground (7);
      s:='';
      xx:=18;
      yy:=ii+5;
      gotoxy (xx,yy);
      repeat
        oncursor;
        c:=inchar;
        if c=#200 then if ii-1<1 then marklocation (numitems) else marklocation (ii-1);
        if c=#208 then if ii+1>numitems then marklocation (1) else marklocation (ii+1);
        if (c=' ') and (length (s)<1) then c:=#0;
        if c=#27 then done:=true;
        if c=#196 then begin
          done:=true;
        end;
        if not (length (s)=inle) or (c=^H) or (c=#13) then begin
          if (c=^H) and (length (s)>0) then begin
            write (^H' '^H);
            s:=copy (s,1,length (s)-1);
          end;
        end;
        if not (c=^H) then write (c);
        if not (c=^H) and not (c=#13) then s:=s+c;
      until done;
      offcursor;
    end;*)

begin
  writesysoplog ('Sysop used online user editor',user.handle);
  closefiles (false);
  if b then send (^X'['^Y'Please wait'^X']'^Y);
  Activate_Visible_Screen;
  SlideRestoreScreen(2,Down);
  usewind (1);
  Clrscr;
  usewind (2);
  Done1:=False;
  editsettings;
  { fillscreen (1,1,80,25,white,blue,chr (176));
  findcursor (x,y,scantop,scanbot);
  offcursor;
  mkwin (5,5,75,20,15,1,5);
  textcolor (15);
  textbackground (1);
  gotoxy (7,6);
  write ('User Name');
  gotoxy (7,7);
  write ('Real Name');
  gotoxy (7,8);
  write ('Password');
  gotoxy (7,9);
  write ('Phone #');
  gotoxy (7,10);
  write ('City');
  gotoxy (7,11);
  write ('State');
  gotoxy (7,12);
  write ('Zip Code');
  gotoxy (7,13);
  write ('Birthdate');
  gotoxy (7,14);
  write ('User Note');
  gotoxy (7,15);
  write ('Conferences');
  numitems:=10;
  marklocation (1); }
  repeat
    FillScreen(1,1,80,25,white,blue,char(176));
    Findcursor(X,Y,ScanTop,ScanBot);
    OffCursor;
    DisplayMenu(MM,false,Choice,Error1);
    case choice of
      1:read_string (5,10,30,'^User Handle',2,user.handle);
      2:read_string (5,10,30,'^Real Name',5,user.realname);
      3:read_string (5,10,12,'^Phone Number',6,user.phone);
      4:read_int (5,10,3,'^Main Level',6,user.mlevel,-5,maxlevel);
      5:read_int (5,10,3,'^Message Level',6,user.msglevel,-5,maxlevel);
      6:read_int (5,10,5,'^Number of Posts',6,user.numpost,0,32767);
      7:read_int (5,10,3,'^Transfer Level',6,user.xflevel,-5,maxlevel);
      8:read_int (5,10,5,'^Transfer Points',6,user.fpoint,0,32767);
      9:read_int (5,10,5,'^Number of Uploads',6,user.numup,0,32767);
      10:read_longint (5,10,10,'^Upload K',6,user.uploadk,0,2147483647);
      11:read_int (5,10,5,'^Number of Downloads',6,user.numdn,0,32767);
      12:read_longint (5,10,10,'^Download K',6,user.downloadk,0,2147483647);
      13:read_string (5,10,8,'^Birthdate',6,user.bday);
      14:read_int (5,10,5,'^Daily Time',6,user.dailytime,0,32767);
      15:read_int (5,10,5,'^Time Left',6,user.time,0,32767);
      16:read_string (5,10,30,'^User Note',6,user.note);
      17:;
      18:read_int (5,10,5,'^Minimum Post/Call %',6,user.minpc,0,32767);
      19:read_int (5,10,5,'^Minimum Upload/Download %',6,user.minud,0,32767);
      20:read_string (5,10,20,'^Password',6,user.password);
      21:done1:=true;
    end;  {case}
  until Done1;
  textbackground (0);
  OnCursor;
  ClrScr;
  writeuser (u,unum);
  {readuser (user,usernum);}
  Choice:=1;
  if b then begin
    clearscreen;
    showlastprompt;
  end;
end;

Procedure Settings;
begin
  Menu_Set(M1);
  With M1 do begin
    Heading1 := bbsname+' '+bbsver;
    Heading2 := 'Sysop Commands';
    Topic[1] := 'User Editor';
    Topic[2] := 'Edit Other User';
    Topic[3] := 'Shell to DOS';
    Topic[4] := 'Run Setup';
    Topic[5] := 'Text Editor';
    Topic[6] := 'ANSI Editor';
    Topic[7] := 'Quit & Save';
    TotalPicks := 7;
    PicksPerLine := 1;            {one column of choices}
    Addprefix := 2;
    TopleftXY[1] := 0;            {system will center menu}
    TopleftXY[2] := 0;            {Y coordinate}
    Boxtype := 5;                 {fancy box}
    Margins := 5;
    AllowEsc:=true;
  end;
  with RTTT do begin
    FCol := white;
    BCol := cyan;
    HiFCol := white;
    HiBCol := black;
    LoFCol := lightgray;
    LoBCol := black;
    PFCol := white;
    PBCol := cyan;
    BoxFCol := white;
    BoxBCol := cyan;
    Msg_FCol := white;
    Msg_BCol := cyan;
  end;
  Main_Choice:=1;
end; {Define_Menu1}

Procedure Sysop_Command_Menu;
  var s:string[1];
Begin
  send (^X'['^Y'Please wait'^X']'^Y);
  Activate_Visible_Screen;
  SlideRestoreScreen(2,Down);
  usewind (1);
  Clrscr;
  usewind (2);
  Done:=False;
  settings;
  repeat
    FillScreen(1,1,80,25,white,blue,char(176));
    Findcursor(X,Y,ScanTop,ScanBot);
    OffCursor;
    DisplayMenu(M1,false,Main_Choice,Error);
    case main_choice of
      1:user_editor_menu (false,user,usernum);
      2:;
      3:shelltodos (true);
      4:runsetup (true);
      5:begin
          writesysoplog ('Sysop ran text editor',user.handle);
          runeditor (setup.texteditor,true);
        end;
      6:begin
          writesysoplog ('Sysop ran ANSI editor',user.handle);
          runeditor (setup.ansieditor,true);
        end;
      7:done:=true;
    end;  {case}
  until Done;
  OnCursor;
  readsetup;
  {readuser (user,usernum);}
  Main_Choice:=1;
  clearscreen;
  showlastprompt;
End;

procedure help;
begin
  writesysoplog ('Sysop viewed help screen',user.handle);
  send (^X'['^Y'Please wait'^X']');
  Activate_Visible_Screen;
  SlideRestoreScreen(2,Down);
  FillScreen(1,1,80,25,white,blue,char(176));
  OffCursor;
  mkwin (10,9,70,18,15,1,5);
  textcolor (15);
  textbackground (1);
  gotoxy (12,10);
  write ('F1 - Chat Mode');
  gotoxy (44,10);
  write ('F2 - Sysop commands');
  gotoxy (12,11);
  write ('F3 - Hang up modem');
  gotoxy (44,11);
  write ('F4 - Quick Validate');
  gotoxy (12,12);
  write ('F5 - QV and Edit');
  gotoxy (44,12);
  write ('F6 - QV w/ Sysop Access');
  gotoxy (12,13);
  write ('F7 - Toggle Input Lock');
  gotoxy (44,13);
  write ('F8 - Toggle Output Lock');
  gotoxy (12,14);
  write ('F9 - Toggle Sneak Mode');
  gotoxy (12,15);
  write ('Scroll-Lock - Availability');
  gotoxy (44,15);
  write ('ALT-B - Toggle Status Line');
  gotoxy (12,16);
  write ('ALT-D - Shell to DOS');
  gotoxy (44,16);
  write ('ALT-H - This Screen');
  gotoxy (12,17);
  write ('ALT-L - Decrease Time');
  gotoxy (44,17);
  write ('ALT-M - Increase Time');
  repeat until keypressed;
  rmwin;
  textbackground (0);
  OnCursor;
  clearscreen;
  showlastprompt;
end;

function readchar;
  var c,ret:char;
begin
  ret:=#0;
  if keypressed then begin
    c:=getkey{readkey};
    case c of
      ^C:begin
           textbackground (0);
           window (1,1,80,25);
           clrscr;
           textcolor (11);
           writeln ('Break:');
           textcolor (0);
           closefiles (true);
           shutdownexecswap;
           com_lower_dtr;
           com_deinit;
           halt (0);
         end;
      #160:begin
             shelltodos (true);
             clearscreen;
             showlastprompt;
           end;
      #176:begin
             if stati<3 then inc (stati) else stati:=0;
             statusline (stati);
           end;
      #187:chat;
      #188:Sysop_Command_Menu;
      #189:hangupmodem;
      #190:quickvalidate (user,usernum,'U');
      #191:begin
             quickvalidate (user,usernum,'U');
             User_Editor_Menu (true,user,usernum);
           end;
      #192:quickvalidate (user,usernum,'S');
      #193:inlock:=not inlock;
      #194:outlock:=not outlock;
      #195:begin
             if not sneak then begin
               send (^X'['^Y'Please wait'^X']');
               sneak:=true;
               inlock:=true;
               outlock:=true;
             end else begin
               sneak:=false;
               inlock:=false;
               outlock:=false;
             end;
           end;
      {#158:if stat.sysopavail then stat.sysopavail:=false else
           stat.sysopavail:=true;}
      #163:help;
      #166:settimeleft (timeleft-5);
      #178:settimeleft (timeleft+5);
      ^A,^B,^G,^J,^N,^O,^W..^Z:;
      else ret:=c;
    end;
  end else begin
    c:=com_rx;
    ret:=c;
    case c of
      ^A,^B,^G,^J,^N,^O,^W..^Z:ret:=#0;
    end;
    if inlock then ret:=#0;
  end;
  readchar:=ret;
  statusline (0);
end;

function bioskey;
  var r:registers;
begin
  r.ah:=0;
  intr ($16,r);
  if r.al=0 then bioskey:=char(r.ah+128) else bioskey:=char(r.al);
end;

function charready;
  var c:char;
begin
  if inlock then while not com_rx_empty do c:=com_rx;
  if keypressed then charready:=true else if not local then charready:=(not inlock) and (not com_rx_empty) else
  charready:=false;
end;

function inchar;
  var c:char;
      t:integer;
begin
  if setup.timeout<>0 then begin
    t:=timer+setup.timeout;
    if t>=1440 then t:=t-1440;
  end;
  repeat
    if setup.timeout<>0 then if timer=t then hangupmodem;
  until charready or not online;
  if online then inchar:=readchar else inchar:=#0;
  statusline (0);
end;

procedure inchardelay (i:word; cc:char);
  var c:char;
      ii:integer;
begin
  ii:=0;
  c:=#0;
  repeat
    inc (ii);
    delay (1);
    if charready then c:=readchar;
  until (ii=i) or (c=cc);
  statusline (0);
end;

function shinchar:char;
  var c:char;
begin
  c:=inchar;
  if c>#0 then sendwriteln (c);
  shinchar:=c;
end;

procedure clearinp (b:byte);
  var bb:byte;
begin
  spacewrite ('',b);
  for bb:=b downto 1 do sendwrite (#8);
end;

procedure recv;
  var b:boolean;
      c:char;
      i:integer;
begin
  input:='';
  repeat
    b:=false;
    c:=inchar;
    if (c=' ') and (length (input)<1) then c:=#0;
    if (c=#0){ or (c='^')} then b:=true;
    if (c=#27) then begin
      for i:=1 to length (input) do sendwrite (#8' '#8);
      input:='';
      b:=true;
    end;
    if not b then begin
      if not (length (input)=inlen) or (c=#8) or (c=#13) then begin
        if (c=#8) and (length (input)>0) then begin
          sendwrite (#8' '#8);
          input:=copy (input,1,length (input)-1);
        end;
        if not (c=#8) then if (hidchar) and not (c=#13) then begin
          send (setup.hidch);
          write (c);
        end else sendwrite (c);
        if not (c=#8) and not (c=#13) then input:=input+c;
      end;
    end;
  until (c=#13) or not online;
  inlen:=80;
  hidchar:=false;
end;

function online;
  var b:boolean;
begin
  b:=com_CD or local;
  online:=b;
end;

procedure chat;
  label done;
  var c:char;
      cursysopx,cursysopy,curuserx,curusery:integer;
      inchat:boolean;
      s,ss:longstr;
      t:string;

      procedure drawline;
        var i:integer;
            s:string[80];
      begin
        sendxy (1,13,'');
        writeline (79);
        s:=^X'[ '^Z'Horizontal Chat'^X' ]';
        i:=(80-length (s)) div 2;
        sendxy (i,13,s);
      end;

      procedure clearlines (user:boolean);
        var i:integer;
      begin
        drawline;
        if user then begin
          for i:=14 to 24 do begin
            sendxy (1,i,'');
            cleareol;
          end;
          curuserx:=0;
          curusery:=14;
          sendxy (curuserx,curusery,'');
        end else begin
          for i:=1 to 12 do begin
            sendxy (1,i,'');
            cleareol;
          end;
          cursysopx:=0;
          cursysopy:=1;
          sendxy (cursysopx,cursysopy,'');
        end;
      end;

      function checkspace (s:string):integer;
        var i,ii:integer;
      begin
        ii:=0;
        for i:=1 to length (s) do if s[i]=' ' then ii:=i;
        checkspace:=ii;
      end;

      procedure wordwrap (b:boolean);
        var i:integer;
            word:string[80];
      begin
        i:=0;
        word:='';
        if not b then begin
          i:=checkspace (s);
          if i<1 then begin
            s:='';
            cursysopx:=0;
            inc (cursysopy);
            if cursysopy>=13 then clearlines (false) else nl;
          end else begin
            word:=copy (s,i+1,255);
            sendxy (i,cursysopy,'');
            cleareol;
            cursysopx:=0;
            inc (cursysopy);
            if cursysopy>=13 then clearlines (false) else nl;
            sendwrite (^Y+word);
            cursysopx:=length (word);
            sendxy (cursysopx,cursysopy,'');
            s:=word;
          end;
        end else begin
          i:=checkspace (ss);
          if i<1 then begin
            ss:='';
            curuserx:=0;
            inc (curusery);
            if curusery>=24 then clearlines (true) else nl;
          end else begin
            word:=copy (ss,i+1,255);
            sendxy (i,curusery,'');
            cleareol;
            curuserx:=0;
            inc (curusery);
            if curusery>=24 then clearlines (true) else nl;
            sendwrite (^Y+word);
            curuserx:=length (word);
            sendxy (curuserx,curusery,'');
            ss:=word;
          end;
        end;
      end;

begin
  writesysoplog ('Sysop entered chat',user.handle);
  inchat:=true;
  s:=setup.textdir+'CHATOPEN.ANS';
  t:=lastprmpt;
  if (exist (s)) and ansi then begin
    clearscreen;
    printfile (s,true);
    nl;
    pause;
  end else sendwriteln (^M^Y+setup.chatgreet+^M);
  clearscreen;
  drawline;
  cursysopx:=0;
  cursysopy:=1;
  curuserx:=0;
  curusery:=14;
  s:='';
  ss:='';
  repeat
    if charready then if keypressed then begin
      c:=getkey;
      case c of
        #187:inchat:=false;
        #8:if cursysopx>0 then begin
             sendxy (cursysopx,cursysopy,'');
             sendwrite (' '#8);
             dec (cursysopx);
             s:=copy (s,1,length (s)-1);
           end;
        #13:begin
              sendxy (cursysopx,cursysopy,^Y);
              nl;
              inc (cursysopy);
              cursysopx:=0;
              if cursysopy>=13 then clearlines (false);
              s:='';
            end;
        #27:;
        ^A..^Z:;
        else begin
          s:=s+c;
          inc (cursysopx);
          sendxy (cursysopx,cursysopy,^Y+c);
          if cursysopx>78 then wordwrap (false);
        end;
      end;
    end else if not com_rx_empty then begin
      c:=com_rx;
      case c of
        #8:if curuserx>0 then begin
             sendxy (curuserx,curusery,'');
             sendwrite (' '#8);
             dec (curuserx);
             ss:=copy (ss,1,length (ss)-1);
           end;
        #13:begin
              sendxy (curuserx,curusery,^Y);
              nl;
              inc (curusery);
              curuserx:=0;
              if curusery>=24 then clearlines (true);
              ss:='';
            end;
        #27:;
        ^A..^Z:;
        else begin
          ss:=ss+c;
          inc (curuserx);
          sendxy (curuserx,curusery,^Y+c);
          if curuserx>78 then wordwrap (true);
        end;
      end;
    end;
  until not (inchat) or not (online);
  clearscreen;
  s:=setup.textdir+'CHATCLOS.ANS';
  if (exist (s)) and ansi then begin
    printfile (s,true);
    nl;
    pause;
  end else sendwriteln (^M^Y+setup.chatgoodbye+^M);
  lastprmpt:=t;
  showlastprompt;
  writesysoplog ('Sysop exited chat',user.handle);
end;

(*procedure writedirect (s:string);
  var i,ii:integer;
begin
  i:=length (s);
  if i<0 then i:=0;
  write (direct,s);
  {if i>0 then for ii:=1 to i do write (direct,^H);}
  {i:=wherex;
  ii:=wherey;
  write (direct,s);
  sendxy (i+2,ii,'');}
end;*)

procedure cursor (b:boolean);
var r:registers;
begin
  with r do begin
  ah:=$01;
  if not b then begin
  ch:=$20; cl:=$20
  end else begin
  ch:=5; cl:=7
  end
 end;
 intr ($10,r);
end;

procedure pause;
  var c:char;
      i:integer;
      s:string[80];
begin
  input:='';
  lastprmpt:=^Y'Press '^X'['^Y'Enter'^X'] '^Y'to continue'^X': '^Y;
  sendwrite (lastprmpt);
  repeat until (inchar=#13) or not online;
  for i:=1 to 27 do sendwrite (#8' '#8);
end;

procedure ansicolor (attrib:byte);
var tc:byte;
    i:integer;
    m:longstr;
const colorid:array [0..7] of byte=(30,34,32,36,31,35,33,37);
begin
  i:=textattr;
  {if attrib=0 then begin
    textcolor (7);
    textbackground (0)
  end else begin
    textcolor (attrib and $8f);
    textbackground ((attrib shr 4) and 7);
  end;}
  {curcolor:=attrib;}
  textattr:=attrib;
  if not ansi or (attrib=0) or (attrib={curcolor}i) then exit;
  if not local then
    if avt then begin
      i:=colorid[attrib and $0F]+(colorid[(attrib and $70) shr 4] shl 4);
      if (attrib and $80<>0) then i:=i or $80;
      send (^V^A+char (i));
    end else begin
      m:=#27+'[0';
      tc:=attrib and 7;
      if tc<>7 then m:=m+';'+strr(colorid[tc]);
      tc:=(attrib shr 4) and 7;
      if tc<>0 then m:=m+';'+strr(colorid[tc]+10);
      if (attrib and 8)=8 then m:=m+';1';
      if (attrib and 128)=128 then m:=m+';5';
      m:=m+'m';
      send (m);
    end;
end;

procedure clearscreen;
begin
  if local then clrscr else
  if avt or not ansi then sendwrite (^L) else if ansi then sendwrite (#27+'[2J');
  statusline (0);
  linenum:=1;
end;

procedure cleareol;
begin
  if local then clreol else
  if avt then sendwrite (^V^G) else if ansi then sendwrite (#27+'[K');
end;

function cosysop (i:integer):boolean;
  var ii,iii:integer;
begin
  case i of
    0:begin
        ii:=setup.comlevel;
        iii:=user.mlevel;
      end;
    1:begin
        ii:=setup.comsglevel;
        iii:=user.msglevel;
      end;
    2:begin
        ii:=setup.coxflevel;
        iii:=user.xflevel;
      end;
  end;
  cosysop:=iii>=ii;
end;

function sysop (i:integer):boolean;
  var ii,iii:integer;
begin
  case i of
    0:begin
        ii:=setup.sysmlevel;
        iii:=user.mlevel;
      end;
    1:begin
        ii:=setup.sysmsglevel;
        iii:=user.msglevel;
      end;
    2:begin
        ii:=setup.sysxflevel;
        iii:=user.xflevel;
      end;
  end;
  sysop:=iii>=ii;
end;

function doyesno (s:string):boolean;
  var b:boolean;
      c:char;
   i,ii:integer;

    procedure showyesno (i:integer);
    begin
      case i of
        1:begin
            ansicolor (31);
            sendwrite ('YES'^Z'  No');
          end;
        2:begin
            sendwrite (^Z'Yes  ');
            ansicolor (31);
            sendwrite ('NO'^Z);
          end;
      end;
    end;

begin
  if ansi then begin
    sendwrite (^Y+s+' ');
    b:=false;
    i:=2;
    showyesno (i);
    repeat
      c:=upcase (inchar);
      case c of
        'A',#203,'4',' ':begin
                   dec (i);
                   if i<1 then i:=2;
                 end;
        'Z',#205,'6',' ':begin
                   inc (i);
                   if i>2 then i:=1;
                 end;
        '1','2':i:=valu (c);
        'Y':begin
              i:=1;
              b:=true;
              doyesno:=true;
            end;
        'N':begin
              i:=2;
              b:=true;
              doyesno:=false;
            end;
        #13:begin
              case i of
                1:doyesno:=true;
                2:doyesno:=false;
              end;
              b:=true;
            end;
      end;
      for ii:=1 to 7 do sendwrite (#8+' '+#8);
      showyesno (i);
    until b or not online;
    nl;
  end else begin
    prompt (s+' ');
    if uppercase (input[1])='Y' then doyesno:=true else doyesno:=false;
  end;
end;

procedure sendxy (x,y:integer; s:string);
begin
  if local then gotoxy (x,y) else if ansi then sendwrite (#27+'['+strr (y)+';'+strr (x)+'H'){ else if avatar then}
  {write (direct,^V^H};
  sendwrite (s);
end;

procedure ansi_window (x,y,xx,yy:integer);
  var i:integer;
begin
  sendxy (x,y,^A'');
  for i:=(x+2) to xx do sendwrite ('');
  sendwriteln ('');
  for i:=(y+1) to ((yy)-1) do begin
    sendxy (x,i,'');
    sendxy (xx{+1},i,'');
  end;
  sendxy (x,yy,'');
  for i:=(x+2) to xx do sendwrite ('');
  sendwriteln ('');
end;

procedure range (numents:integer; var f,l:integer);
  var rf,rl:string[80];
      i,ii,iii:integer;
begin
  f:=0;
  l:=0;
  if numents<1 then exit;
  repeat
    prompt ('Range '^X'['^Z'1'^X'-'^Z+strr (numents)+'  CR'^X'/'^Y'All  '^Z'?'^X'/'^Y'Help'^X']: ');
    if (length (input)>0) and (upcase (input[1])='Q') then exit;
  until (input<>'?') or not online;
  if not online then exit;
  if length (input)=0 then begin
    f:=1;
    l:=numents;
  end else begin
    i:=pos('-',input);
    ii:=valu (copy (input,1,i-1));
    iii:=valu (copy (input,i+1,255));
    if i=0 then begin
      f:=iii;
      l:=iii;
    end else if i=1 then begin
      f:=1;
      l:=iii;
    end else if i=length (input) then begin
      f:=ii;
      l:=numents;
    end else begin
      f:=ii;
      l:=iii;
    end
  end;
  if (f<1) or (l>numents) or (f>l) then begin
    f:=0;
    l:=0;
    sendwrite (^M^Y'Invalid range!'^M^M);
  end;
end;

procedure hangupmodem;
begin
  closefiles (true);
  hangupmdm;
end;

function numnode:integer;
begin
  numnode:=filesize (nodef);
end;

procedure seeknode (i:integer);
begin
  seek (nodef,i-1);
end;

procedure rewritenodefile;
  var b:byte;
begin
  {$I-}rewrite (nodef);{$I+}
  for b:=1 to maxnode do begin
    node.useron:='Unknown';
    node.action:=0;
    seeknode (b);
    write (nodef,node);
  end;
end;

procedure opennode;
begin
  assign (nodef,setup.nodedir+'NODELIST.DAT');
  {$I-}reset (nodef);{$I+}
  if ioresult<>0 then rewritenodefile;
end;

procedure closenode;
begin
  close (nodef);
end;

procedure updatenode (i,action:integer; handle:longstr);
begin
  if setup.nodenum>0 then begin
    opennode;
    seeknode (i);
    node.useron:=handle;
    node.action:=action;
    write (nodef,node);
    closenode;
  end;
end;

procedure displaynodeinfo;
var i:integer;
begin
  writesysoplog ('Node info displayed',user.handle);
  clearscreen;
  header ('Multi-Node BBS Information');
  sendwriteln (^Y'#    User Handle                     Action');
  writeline (79);
  assign (nodef,setup.nodedir+'NODELIST.DAT');
  {$I-}reset (nodef);{$I+}
  if ioresult<>0 then {$I-}rewrite (nodef);{$I+}
  for i:=1 to numnode do begin
    seeknode (i);
    read (nodef,node);
    if (length (node.useron)>0) and (node.action<>0) then begin
      sendwrite (^Z);
      spacewrite (strr (i),5);
      spacewrite (node.useron,32);
      sendwriteln (nodeaction[node.action]);
    end;
  end;
  close (nodef);
  nl;
end;

procedure directoutchar (c:char);

  procedure sendansi;
    var r:registers;
  begin
    {r.dl:=ord (c);
    r.ah:=2;
    intr ($21,r);}
    writecharansi (c);
  end;

begin
  if inuse<>2 then usewind (2);
  sendansi;
  if wherey>lasty then gotoxy (wherex,lasty);
  if (not local) and (not outlock) then com_tx (c);
end;

(*function opendevice (var t:textrec):integer;
begin
  {$ifdef testingdevices}  devicedone (t,'opened');  {$endif}
  t.handle:=1;
  t.mode:=fminout;
  t.bufend:=0;
  t.bufpos:=0;
  opendevice:=0
end;

function closedevice (var t:textrec):integer;
begin
  {$ifdef testingdevices}  devicedone (t,'closed');  {$endif}
  t.handle:=0;
  t.mode:=fmclosed;
  t.bufend:=0;
  t.bufpos:=0;
  closedevice:=0
end;

function directoutchars (var t:textrec):integer;
var cnt:integer;
begin
  for cnt:=t.bufend to t.bufpos-1 do
    directoutchar (t.bufptr^[cnt]);
  t.bufend:=0;
  t.bufpos:=0;
  directoutchars:=0
end;

procedure assignname (var t:text; s:string);
begin
  with textrec(t) do begin
    move (s[1],name,length(s));
    name[length(s)]:=#0
  end
end;

procedure initdirect;
begin
  move (output,direct,sizeof(text));
  with textrec(direct) do begin
    openfunc:=@opendevice;
    closefunc:=@closedevice;
    flushfunc:=@directoutchars;
    inoutfunc:=@directoutchars;
    bufptr:=@buffer
  end;
  assignname (direct,'DIRECT');
end;*)

function findusernum;
  var i,ii:integer;
         u:userrec;
begin
  ii:=0;
  for i:=numusers downto 1 do begin
    readuser (u,i);
    if length (u.handle)<1 then ii:=i;
  end;
  if ii=0 then ii:=numusers+1;
  if ii>maxusers then begin
    sendwrite (^M^Y'This software has reached the maximum amount of users.'^M^M);
    sendwrite (^Y'If this is not registered yet, please inform the SysOp to register.'^M^M);
    nl;
    ii:=0;
  end;
  findusernum:=ii;
end;

{function sendwritestr (i:integer):string;
  var ii:integer;
      t,ss:longstr;
begin
  sendwritestr:='';
  if i>numstrings then exit;
  t:=strngs[i];
  ss:='';
  for ii:=1 to length (t) do begin
    case t[ii] of
      '^':case upcase (t[ii+1]) of
            'M':ss:=ss+^M;
            'W':ss:=ss+^W;
            'X':ss:=ss+^X;
            'Y':ss:=ss+^Y;
            'Z':ss:=ss+^Z;
          end;
      else if not ((pos (t[ii],'MWXYZ')>0) and (t[ii-1]='^')) then ss:=ss+t[ii];
    end;
  end;
  sendwritestr:=ss;
end;}

procedure dorinfo1;
  var u:userrec;
      deffile:text;
begin
   assign (deffile,'dorinfo1.def'); {info file}
   {$I-}rewrite(deffile);{$I+}
   writeln(deffile,setup.sysname);        {BBS name}
   writeln(deffile,sysopname);             {sysop first name}
   writeln(deffile,' ');                          {sysop last name}
   if local
   then
     writeln(deffile,'LOCAL')
   else
     writeln(deffile,'COM',setup.com);                      {COMM port}
   writeln(deffile,baudrate,' BAUD,N,8,1');      {baudrate^BAUD,N,n,x}
   writeln(deffile,'0');                         {network type }
   writeln(deffile,user.handle);                        {user first name}
   writeln(deffile,' ');                         {user last name}
   writeln(deffile,user.maddress[2]);                         {user city,state}
   if (ansi) then         {0 no graphics }
    writeln(deffile,'2') else writeln(deffile,'0'); {1-ascii  2-ansi}
   writeln(deffile,user.mlevel);                        {user level}
   writeln(deffile,timeleft);                    {time remaining}
   (*writeln(deffile,'0');                         {EOF must have}*)
   close(deffile);
end;

procedure def_user;
var     deffile:text;
        temptime : integer;
Begin
   assign (deffile,'USERINFO.TXT'); {info file}
   {$I-}rewrite(deffile);{$I+}
   writeln(deffile,user.handle);                        {user first name}
   writeln(deffile,baudrate);
{if parity then
   writeln(deffile,'7')
          else}
   writeln(deffile,'8');
if timeleft > 60 then temptime := 60 else temptime := timeleft;
   writeln(deffile,temptime*60);                 {time remaining}
   writeln(deffile,'0');                         {EOF must have}
   close(deffile);
end;

procedure wwiv_chain;
  var t:text;
begin
  assign (t,setup.bbsdir+'CHAIN.TXT');
  {$I-}rewrite (t);{$I+}
  writeln (t,usernum);
  writeln (t,user.handle);
  writeln (t,user.realname);
  writeln (t,'');
  writeln (t,age (user));
  writeln (t,user.sex);
  writeln (t,user.fpoint,'.00');
  writeln (t,laston);
  writeln (t,80);
  writeln (t,user.displaylen);
  writeln (t,user.mlevel);
  if cosysop (0) then writeln (t,'1') else writeln (t,'0');
  if sysop (0) then writeln (t,'1') else writeln (t,'0');
  if ansi then writeln (t,'1') else writeln (t,'0');
  if not com_tx_empty then writeln (t,'1') else writeln (t,'0');
  writeln (t,timeleft*60,'.00');
  writeln (t,setup.textdir);
  writeln (t,setup.datadir);
  writeln (t,setup.logdir+stripdate+'.ND'+strr (setup.nodenum));
  if local then writeln (t,'0') else writeln (t,baudrate);
  writeln (t,setup.com);
  writeln (t,setup.sysname);
  writeln (t,sysopname);
  writeln (t,0);
  writeln (t,0);
  writeln (t,user.uploadk);
  writeln (t,user.numup);
  writeln (t,user.downloadk);
  writeln (t,user.numdn);
  writeln (t,'8N1');
  close (t);
end;

function getlastcaller:string;
  var b:boolean;
begin
  b:=false;
  getlastcaller:='';
  assign (lastf,setup.datadir+'CALLERS.DAT');
  {$I-}reset (lastf);{$I+}
  if (ioresult=0) then begin
    b:=true;
    if filesize (lastf)>0 then begin
      seek (lastf,0);
      read (lastf,last);
      getlastcaller:=last.name;
    end;
  end;
  if b then close (lastf);
end;

{function nummailu (s:string; c:char):integer;
  var i,ii:integer;
begin
  ii:=0;
  for i:=1 to filesize (mailf) do begin
    seek (mailf,i-1);
    read (mailf,mail);
    if c='I' then if match (mail.sentto,s) then inc (ii) else
    if c='O' then if match (mail.poster,s) then inc (ii);
  end;
  nummailu:=ii;
end;

procedure openmail;
begin
  assign (mailf,setup.msgdir+'MAIL.DAT');
  reset (mailf);
  if ioresult<>0 then rewrite (mailf);
end;

procedure closemail;
begin
  close (mailf);
end;}

procedure openlog;
begin
  assign (logf,setup.logdir+stripdate+'.ND'+strr (setup.nodenum));
  {$I-}reset (logf);{$I+}
  if ioresult<>0 then {$I-}rewrite (logf);{$I+}
end;

procedure closelog;
begin
  close (logf);
end;

procedure writesysoplog (s,ss:logstr);
  var sss:string[80];
begin
  openlog;
  sss:=curtime+' ';
  if length (ss)>0 then sss:=sss+ss+': ';
  sss:=sss+s;
  {$I-}append (logf);{$I+}
  writeln (logf,sss);
  closelog;
end;

function stripchar (c:char; s:longstr):longstr;
  var ss:longstr;
begin
  ss:=s;
  while pos (c,ss)>0 do delete (ss,pos (c,ss),1);
  stripchar:=ss;
end;

function stripcolor (s:longstr):longstr;
  var ss:longstr;
begin
  ss:=s;
  ss:=stripchar (^W,ss);
  ss:=stripchar (^X,ss);
  ss:=stripchar (^Y,ss);
  ss:=stripchar (^Z,ss);
  ss:=stripchar (^A,ss);
  ss:=stripchar (^B,ss);
  ss:=stripchar (^N,ss);
  ss:=stripchar (^O,ss);
  stripcolor:=ss;
end;

begin
end.