{$I+,S+}
unit awf;

interface

uses crt,dos,inout,records,strunit;

const awfname='Associated Wrestling Federation';
      shortawf='AWF';
      version='1.00';
      awfauthor='Keith Brown';
      awfcopydate='1992';
      awfdate='09/10/92';
      maxwrestler=100;

var moves:array [1..53] of integer;

{0 = None}
{1 = Spinning Back Breaker}
{2 = Back Breaker}
{3 = Brain Buster}
{4 = Figure Four Leg Lock}
{5 = Boston Crab}
{6 = Sharpshooter/Scorpion}
{7 = Power Bomb}
{8 = Tombstone Pile Driver}
{9 = Side Suplex}
{10 = Perfect Plex}
{11 = Tomahawk Chop}
{12 = Back Body Slam}
{13 = Sleeper}
{14 = Rude Awakening}
{15 = Russian Leg Sweep}
{16 = Swinging Neckbreaker}
{17 = Drop Kick}
{18 = Sunset Flip}
{19 = Power Slam}
{20 = Body Slam}
{21 = Suplex}
{22 = Flying Forearm}
{23 = Mexican Jumping Bean}
{24 = Pile Driver}
{25 = DDT}
{26 = Elbow Drop}
{27 = Leg Drop}
{28 = Turnbuckle Elbow Drop}
{29 = Turnbuckle Drop Kick}
{30 = Hiptoss}
{31 = Clothesline}
{32 = Turnbuckle Double Axe Handle}
{33 = Egg Drop}
{34 = Full Nelson}
{35 = Bear Hug}
{36 = Head Butt}
{37 = Shoulder Breaker}
{38 = Jaw Breaker}
{39 = Splash}
{40 = Compactor (Crush)}
{41 = Earthquake}
{42 = Belly-Back Suplex}
{43 = Belly-Belly Suplex}
{44 = Superplex}
{45 = Bulldog}
{46 = Spinebuster/Sidewalk Slam}
{47 = Million Dollar Dream/Cobra Clutch}
{48 = Grapevine/Abdominal Stretch}
{49 = Arm bar}
{50 = Scissors}
{51 = Arm drag takeover}
{52 = Waistlock}
{53 = Chinlock}
{54 = Wristlock}

type wrestlerrec=record
       usernum,win,loss,passes,tpasses,passperday:integer;
       name:string[30];
       strength,speed,agility,skill,courage,perception:byte;
       bestmove:array [1..5] of byte;
       champion:array [1..2] of boolean;
       laston:string[8];
     end;

     rankrec=record
       wrestler:string[30];
       usernum:integer;
     end;

var wrestler:wrestlerrec;
    wfile:file of wrestlerrec;
    rank:rankrec;
    rfile:file of rankrec;

procedure playawf;

implementation

function numwrestlers:integer;
begin
  numwrestlers:=filesize (wfile);
end;

procedure readw (var w:wrestlerrec; i:integer);
begin
  if i<1 then exit;
  seek (wfile,i-1);
  read (wfile,w);
end;

procedure writew (var w:wrestlerrec; i:integer);
begin
  if i<1 then exit;
  seek (wfile,i-1);
  write (wfile,w);
end;

procedure readr (var r:rankrec; i:integer);
begin
  if i<1 then exit;
  seek (rfile,i-1);
  read (rfile,r);
end;

procedure writer (var r:rankrec; i:integer);
begin
  if i<1 then exit;
  seek (rfile,i-1);
  write (rfile,r);
end;

function findusernum (b:boolean):integer;
  var i,ii:integer;
      wres:wrestlerrec;
      r:rankrec;
begin
  if b then for i:=1 to numwrestlers do begin
    readw (wres,i);
    if wres.usernum=i then ii:=i;
  end else for i:=1 to numwrestlers do begin
    readr (r,i);
    if r.usernum=i then ii:=i;
  end;
  findusernum:=ii;
end;

procedure playawf;

  procedure loadparams;
  begin
    assign (wfile,setup.datadir+'WRESTLER.DAT');
    {$I-}reset (wfile);{$I+}
    if ioresult<>0 then begin
      {$I-}rewrite (wfile);{$I-}
      sendwriteln (^Y'Rewriting wrestler file!');
    end;
    assign (rfile,setup.datadir+'RANK.DAT');
    {$I-}reset (rfile);{$I+}
    if ioresult<>0 then begin
      {$I-}rewrite (rfile);{$I+}
      sendwriteln (^Y'Rewriting rank file!');
    end;
  end;

  function randint (min,max:integer):integer;
    const minint=-32767;
    var randrange:word;
  begin
    if min<minint then min:=minint;
    randrange:=max-min+1;
    randint:=random (randrange)+min;
  end;

  procedure seekw (i:integer);
  begin
    seek (wfile,i-1);
  end;

  procedure newwrestler;
    var b:boolean;
        i,ii,j:integer;
  begin
    sendwriteln (^M^Y'Welcome to the '^Z+awfname+^Y', a fast paced wrestling');
    sendwriteln (^Y'online game.'^M);
    fillchar (wrestler,sizeof (wrestler),#0);
    inlen:=30;
    i:=numwrestlers+1;
    with wrestler do begin
      prompt (^Y'Enter a wrestling name (maximum: 30 characters)'^X': ');
      name:=input;
      usernum:=records.usernum;
      win:=0;
      loss:=0;
      passperday:=10;
      passes:=passperday;
      tpasses:=0;
      champion[1]:=false;
      champion[2]:=false;
      if i=1 then champion[1]:=true;
      if i=2 then champion[2]:=true;
      laston:=curdate;
      for j:=1 to 5 do bestmove[j]:=0;
    end;
    ii:=1;
    b:=false;
    while not b do begin
      with wrestler do begin
        strength:=randint (2,10);
        speed:=randint (2,10);
        agility:=randint (2,10);
        skill:=randint (2,10);
        courage:=randint (2,10);
        perception:=randint (2,10);
        sendwriteln (^Y'Statistics of wrestler (Roll #'^Z+strr (ii)+^Y'  '^Z'1-10'^Y'):'^M);
        sendwriteln (^Y'Strength'^X': '^Z+strr (strength));
        sendwriteln (^Y'Speed'^X': '^Z+strr (speed));
        sendwriteln (^Y'Agility'^X': '^Z+strr (agility));
        sendwriteln (^Y'Skill'^X': '^Z+strr (skill));
        sendwriteln (^Y'Courage'^X': '^Z+strr (courage));
        sendwriteln (^Y'Perception'^X': '^Z+strr (perception)+^M);
      end;
      rank.wrestler:=wrestler.name;
      rank.usernum:=i;
      if ii+1>3 then begin
        sendwriteln (^Y'This was your last reset.');
        b:=true;
      end else b:=not doyesno (^Y'Reset statistics?');
      if not b then inc (ii);
    end;
    writew (wrestler,i);
    writer (rank,i);
  end;

  procedure showranks;
    var i:integer;
        r:rankrec;
        wres:wrestlerrec;
  begin
    clearscreen;
    sendwriteln (^Y'#    Name                            Win  Loss  Status');
    writeline (79);
    for i:=1 to numwrestlers do begin
      readw (wres,i);
      readr (r,i);
      sendwrite (^Z);
      spacewrite (strr (i),5);
      spacewrite (r.wrestler,32);
      spacewrite (strr (wres.win),5);
      spacewrite (strr (wres.loss),6);
      if wres.champion[1] then sendwriteln ('World Champion') else
      if wres.champion[2] then sendwriteln ('US Champion') else
      sendwriteln ('#'+strr (i-1)+' Contender');
    end;
    nl;
    pause;
  end;

  procedure training;
    var b:boolean;
        c:char;
  begin
    b:=false;
    repeat
      inlen:=1;
      prompt (^Y'AWF Training Menu '^X'['^Z'?'^X'/'^Y'Help'^X']: ');
      c:=upcase (input[1]);
      if not (input='') then case c of
        '?':begin
              nl;
              spacewrite (^X'['^Z'Q'^X'] '^Y'Quit',39);
              sendwriteln (^X'['^Z'P'^X'] '^Y'Practice (3)');
              nl;
              nl;
            end;
        'Q':b:=true;
        'P':{practice};
      end;
    until b or not online;
  end;

  procedure menu;
    var b:boolean;
        c:char;
  begin
    b:=false;
    repeat
      inlen:=1;
      prompt (^Y'AWF Main Menu '^X'['^Z'?'^X'/'^Y'Help'^X']: ');
      c:=upcase (input[1]);
      if not (input='') then case c of
        '?':begin
              nl;
              spacewrite (^X'['^Z'Q'^X'] '^Y'Quit',39);
              sendwriteln (^X'['^Z'R'^X'] '^Y'Rank Wrestlers');
              spacewrite (^X'['^Z'T'^X'] '^Y'Training Menu',39);
              nl;
              nl;
            end;
        'Q':b:=true;
        'R':showranks;
        'T':training;
      end;
    until b or not online;
  end;

begin
  loadparams;
  if numwrestlers<usernum then newwrestler else begin
    readw (wrestler,findusernum (true));
    readr (rank,findusernum (false));
  end;
  if wrestler.laston<>curdate then wrestler.passes:=wrestler.passperday;
  menu;
  writew (wrestler,findusernum (true));
  writer (rank,findusernum (false));
  close (wfile);
  close (rfile);
end;

begin
end.