Unit Modem;

Interface

Uses Fossil, Records;

Procedure SetParam (ComPort:Integer; BaudRate:LongInt; Parity:Boolean);
Procedure ClosePort;
Function NumChars:Integer;
Procedure SetDTR (DTR:Boolean);
Procedure Sendstring (s:string);
Procedure Activateport;
Procedure Deactivateport;

 {* Variables will give the Address of the REAL Procedure }
 {* Having these to call it is SLOWER! }

Var SendChar   : Procedure (K:Char);
    GetChar    : Function:Char;
    Carrier    : Function:Boolean;
    Hangup     : Procedure;

Implementation

Procedure SetParam (ComPort:Integer; BaudRate:LongInt; Parity:Boolean);
Var K:Char;
Begin
  Case Parity of
   TRUE :K:='E';
   FALSE:K:='N';
  End;
  Set_FOSSIL (ComPort,BaudRate,8,K,1);
End;

Procedure ClosePort;
Begin
  Close_FOSSIL (setup.com);
End;

Function NumChars:Integer;
Begin
  NumChars:=Ord(FOSSIL_Chars);
End;

Procedure SetDTR (DTR:Boolean);
begin
  FOSSIL_Dtr (setup.com,dtr);
end;

Procedure Sendstring (s:string);
  var i:integer;
begin
  for i:=1 to length (s) do sendchar (s[i]);
end;

Procedure Activateport;
begin
end;

Procedure Deactivateport;
begin
end;

Begin
  SendChar:=FOSSIL.SendChar;
  GetChar:=FOSSIL.GetChar;
  Carrier:=FOSSIL.FOSSIL_Carrier;
  Hangup:=FOSSIL.Hangup;
End.