{ Copyright (c)1989 Ross Neilson Wentworth, All Rights Reserved }
{$A+,B-,E+,F-,I+,L+,N+,O-,R-,S-,V-}
Unit Windows;

Interface

Type
  BorderType = (None,Single,Double,DoubleTop,DoubleSide,Solid);
  TitleType = (LeftJustify,Centered,RightJustify);
  ScreenType = Array[0..3999] of Byte;
  ScreenPtr  = ^ScreenRecord;
  ScreenRecord = Record
                   Screen    : ^ScreenType;  { points to saved screen tile  }
                   uX,uY,lX,lY : Byte;       { holds new window coordinates }
                   UpperCors : Word;         { holds old window coordinates }
                   LowerCors : Word;         { holds window coordinates     }
                   OldAttr   : Word;         { holds character attribute    }
                   XY        : Word;         { holds the cursor position    }
                   Cursor    : Word;         { holds the cursor shape       }
                   Previous  : ScreenPtr;    { pointer to underlying window }
                   NoBorder  : Boolean;
                 End;
  BorderPart = (Top,Side,UpperLeft,UpperRight,LowerLeft,LowerRight,
                TopConnect,BottomConnect,LeftConnect,RightConnect,Cross);

Const
  On = True;
  Off = False;
  Borders : Array[Single..Solid,Top..Cross] of Char =
                     (('','','','','','','','','','',''), {single}
                      ('','','','','','','','','','',''), {double}
                      ('','','','','','','','','','',''), {combo }
                      ('','','','','','','','','','',''), {combo }
                      ('','','','','','','','','','',''));{solid }
   { window type 0 has no border, type 5 uses the space character }

Var
  UnderScreen    : ScreenPtr;  { points to the saved screen       }
  UseMono        : Boolean;    { true if use B/W attribute only   }
  StandardCursor : Word;

Procedure Initialize;

Procedure DrawBox(X1,Y1,X2,Y2 : Integer;
                  Forground,Background : Byte;
                  Border : BorderType; Title: string);

Procedure Title(Line : String;TitleFormat : TitleType;Border : BorderType);

Procedure Footer(Line : String;TitleFormat : TitleType;Border : BorderType);

{ Turns the cursor on or off. }

Procedure DuplicateChar(Character : Char;Count : Integer);

Procedure DrawVerticalLine(X,Y,Length : Word;Border : BorderType);

Procedure DrawHorizontalLine(X,Y,Length : Word;Border :BorderType);

Procedure SaveScreen(X1,Y1,X2,Y2 : Integer);

Procedure MoveWindow(X1,Y1 : Integer);

Procedure MakeWindow(X1,Y1,X2,Y2 : Integer;
                     Forground,BackGround : Byte;
                     Border : BorderType; Title: string);

Procedure RemoveWindow;

Function VideoMode : Byte;

  InLine($B4/$0F/          { mov   ah,0Fh   }
         $CD/$10);         { int   10h      }

Procedure GotoXYAbs(XY : Word);

  InLine($5A/              { pop   dx       }
         $B4/$02/          { mov   ah,2     }
         $30/$FF/          { xor   bh,bh    }
         $CD/$10);         { int   10h      }

Function WhereXYAbs : Word;

  InLine($B4/$03/          { mov  ah,3      }
         $30/$FF/          { xor  bh,bh     }
         $CD/$10/          { int  10h       }
         $89/$D0);         { mov  ax,dx     }

Procedure SetCursor(Cursor : Word);

  InLine($59/              { pop  cx        }
         $B4/$01/          { mov  ah,1      }
         $CD/$10);         { int  10h       }

Function CursorShape : Word;

  InLine($B4/$03/          { mov  ah,3      }
         $30/$FF/          { xor  bh,bh     }
         $CD/$10/          { int  10h       }
         $89/$C8);         { mov  ax,cx     }

Procedure PutChar(Ch : Char);

{ Uses the BIOS to place a character at the cursor position. }
{ The cursor is not moved.                                   }

  InLine($58/          { pop     ax     }
         $B4/$0A/      { mov     ah,0Ah }
         $30/$FF/      { xor     bh,bh  }
         $B9/$01/$00/  { mov     cx,1   }
         $CD/$10);     { int     10h    }

Procedure CursorOff;

Implementation

Uses Dos, Crt, WChar;

Var
  MonoScreen  : ScreenType Absolute $B000:0000; { monochome screen            }
  ColorScreen : ScreenType Absolute $B800:0000; { CGA screen                  }
  CurrentScreen  : ScreenPtr;                   { place to save screen info   }
  ScreenSaved  : Boolean;                       { Are any windows on the heap?}
  TrueScreen   : ^ScreenType;


Procedure ScreenToBuffer(Var Source,Target : ScreenType;
                         X1,Y1,X2,Y2: Integer);

Var
  Loop   : Word;
  Width  : Integer;
  Offset : Integer;
  TIndex : Integer;
  SIndex : Integer;

Begin
  Offset := Pred(X1) Shl 1;
  Width := (X2 - Pred(X1)) Shl 1;
  For Loop := Y1 to Y2 Do
  Begin
    SIndex := Pred(Loop) * 160 + Offset;
    TIndex := (Loop-Y1) * Width;
    If CheckSnow Then Repeat Until Port[$3DA] AND 1 = 1;
    Move(Source[SIndex],Target[TIndex],Width);
  End;
End;

Procedure BufferToScreen(Var Source,Target : ScreenType;
                         X1,Y1,X2,Y2: Integer);

Var
  Loop   : Word;
  Width  : Integer;
  Offset : Integer;
  SIndex : Integer;
  TIndex : Integer;

Begin
  Offset := Pred(X1) Shl 1;
  Width := (X2 - Pred(X1)) Shl 1;
  For Loop := Y1 to Y2 Do
  Begin
    TIndex := Pred(Loop) * 160 + Offset;
    SIndex := (Loop-Y1) * Width;
    If CheckSnow Then Repeat Until Port[$3DA] AND 9 = 9;
    Move(Source[SIndex],Target[TIndex],Width);
  End;
End;

Procedure SaveScreen(X1,Y1,X2,Y2 : Integer);

{ saves the screen memory, window coordinates, }
{ cursor position, and character attribute.    }

Var
  ScreenSize : Integer;
  Width     : Integer;
  Height    : Integer;
  NewScreen      : ScreenPtr;

Begin
  Width := Succ(X2) - X1;
  Height := Succ(Y2) - Y1;
  ScreenSize := (Width * Height) Shl 1;
  GetMem(NewScreen,SizeOf(ScreenRecord));
  With NewScreen^ Do
  Begin
    uX := X1;
    uY := Y1;
    lX := X2;
    lY := Y2;
    GetMem(Screen,ScreenSize);
    If ScreenSaved
      Then Previous := CurrentScreen
    Else Previous := Nil;
    ScreenSaved := True;
    If VideoMode = 7
      Then TrueScreen := @MonoScreen
    Else TrueScreen := @ColorScreen;
    ScreenToBuffer(TrueScreen^,Screen^,X1,Y1,X2,Y2);
    UpperCors := WindMin;           { save the window coordinates }
    LowerCors := WindMax;
    OldAttr := TextAttr;            { save the character attribute }
    XY := WhereXYAbs;               { save the cursor position     }
    Cursor := CursorShape;
  End;
  CurrentScreen := NewScreen;
  UnderScreen := CurrentScreen;
End;

Procedure MoveWindow(X1,Y1 : Integer);

Var
  Width      : Integer;
  Height     : Integer;
  ScreenSize : Integer;
  X,Y        : Integer;
  Temp       : ^ScreenType;

Begin
  If Not ScreenSaved Then Exit;
  X := WhereX;      { get the windowed cursor position }
  Y := WhereY;
  With CurrentScreen^ Do
  Begin
    Width := Succ(lX) - uX;
    Height := Succ(lY) - uY;
    ScreenSize := (Width * Height) Shl 1;
    GetMem(Temp,ScreenSize);
    If VideoMode = 7
      Then TrueScreen := @MonoScreen
    Else TrueScreen := @ColorScreen;
    ScreenToBuffer(TrueScreen^,Temp^,uX,uY,lX,lY);
    BufferToScreen(Screen^,TrueScreen^,uX,uY,lX,lY);
    ScreenToBuffer(TrueScreen^,Screen^,X1,Y1,Pred(X1+Width),Pred(Y1+Height));
    BufferToScreen(Temp^,TrueScreen^,X1,Y1,Pred(X1+Width),Pred(Y1+Height));
    uX := X1;
    uY := Y1;
    lX := Pred(X1+Width);
    lY := Pred(Y1+Height);
    FreeMem(Temp,ScreenSize);
    If NoBorder
      Then Window(uX,uY,lX,lY)
    Else Window(Succ(uX),Succ(uY),Pred(lX),Pred(lY));
    GotoXY(X,Y);
  End;
End;

Procedure DropWindow;

Var
  OldScreen : ScreenPtr;

Begin
  With CurrentScreen^ Do
  Begin
    If Previous = Nil Then ScreenSaved := False;
    OldScreen := CurrentScreen;    { release heap memory             }
    CurrentScreen := Previous;
    UnderScreen := CurrentScreen;
    FreeMem(OldScreen,SizeOf(ScreenRecord));
  End;
End;

Procedure RemoveWindow;

{ Restores screen memory, window coordinates, }
{ cursor position, and character attribute.   }

Var
  Height : Integer;
  Width  : Integer;
  ScreenSize : Integer;


Begin
  If Not ScreenSaved Then Exit;
  With CurrentScreen^ Do
  Begin
    If VideoMode = 7
      Then TrueScreen := @MonoScreen
    Else TrueScreen := @ColorScreen;
    BufferToScreen(Screen^,TrueScreen^,1,1,80,25); {ux, uy, lx, ly}
    Width := Succ(80) - 1; {lx -ux}
    Height := Succ(25) - 1; {ly-uy}
    ScreenSize := (Width * Height) Shl 1;
    FreeMem(Screen,ScreenSize);
    WindMin := UpperCors;          { restore the window coordinates  }
    WindMax := LowerCors;
    TextAttr := OldAttr;           { restore the character attribute }
    GotoXYAbs(XY);                 { restore the cursor position     }
    SetCursor(Cursor);
    DropWindow;
  End;
End;

Procedure DuplicateChar(Character : Char;Count : Integer);

{ Uses the BIOS to write multiple copies of a character to the screen }

Begin
  InLine($8A/$46/<Character/     { mov   al,byte ptr char[bp] }
         $8B/$4E/<Count/         { mov   cx,count[bp]         }
         $B4/$09/                { mov   ah,09h               }
         $8A/$1E/>TextAttr/      { mov   bl,[TextAttr]        }
         $32/$FF/                { xor   bh,bh                }
         $CD/$10);               { int   10h                  }
End;

Procedure HeaderFooter(Line : String;
                       Row : Integer;
                       TitleFormat : TitleType;
                       Border : BorderType);

Var
  WMin,WMax : Word;
  oX,oY,X   : Integer;
  Center    : Integer;
  Len       : Integer;

Begin
  WMin := WindMin;
  WMax := WindMax;
  oX := WhereX;
  oY := WhereY;
  WindMin := WMin - $0101;
  WindMax := WMax + $0101;
  Len := Length(Line) Shr 1;
  Case TitleFormat Of
    LeftJustify  : X := 3;
    Centered     : X := ((Succ(Lo(WindMax)) - Lo(WindMin)) Shr 1) - Len;
    RightJustify : X := Lo(WindMax) - Lo(Windmin) - Length(Line) - 2;
  End;
  GotoXY(X,Row);
  Write(Borders[Border,RightConnect],Line,Borders[Border,LeftConnect]);
  WindMin := WMin;
  WindMax := WMax;
  GotoXY(oX,oY);
End;


Procedure Title(Line : String;
                TitleFormat : TitleType;
                Border : BorderType);

Begin
  HeaderFooter(Line,1,TitleFormat,Border);
End;

Procedure Footer(Line : String;
                 TitleFormat : TitleType;
                 Border : BorderType);

Begin
  HeaderFooter(Line,Hi(WindMax)-Hi(WindMin)+3,TitleFormat,Border);
End;


Procedure DrawVerticalLine(X,Y,Length : Word;Border : BorderType);

{ draws a vertical line with the proper connection }
{ type for interfacing with a surrounding window.  }

Var
  Loop : Word;
  WMax : Word;
  WMin : Word;
  xX,xY  : Integer;

Begin
  WMax := WindMax;
  WMin := WindMin;
  xX := WhereX;
  xY := WhereY;
  Window(1,1,80,25);
  GotoXY(X,Y);
  Write(Borders[Border,TopConnect]);
  GotoXY(X,Y+Pred(Length));
  Write(Borders[Border,BottomConnect]);
  WindMax := WMax;
  WindMin := WMin;
  GotoXY(xX,xY);
End;

Procedure DrawHorizontalLine(X,Y,Length : Word;Border :BorderType);

{ draws a horizontal line with the proper connection }
{ type for interfacing with a surrounding window.    }

Var
  Loop : Word;
  WMax : Word;
  WMin : Word;
  xX,xY  : Integer;

Begin
  WMax := WindMax;
  WMin := WindMin;
  xX := WhereX;
  xY := WhereY;
  Window(1,1,80,25);
  GotoXY(X,Y);
  Write(Borders[Border,LeftConnect]);
  GotoXY(X+Pred(Length),Y);
  Write(Borders[Border,RightConnect]);
  WindMax := WMax;
  WindMin := WMin;
  GotoXY(xX,xY);
End;

Procedure DrawBox(X1,Y1,X2,Y2 : Integer;
                  Forground,Background : Byte;
                  Border : BorderType; title: string);

{ Draws a double box around the window and reduces the window size. }
{ Inputs are the same as for MakeWindow.                            }

Var
  Loop : Integer;
  len: byte;
  x: byte;

Begin
  If UseMono Then
  Begin                                 { Make sure the attributes can be }
    Forground := 7;                     { seen on a monochrome screen.    }
    Background := 0;
  End;
  TextAttr := Forground+Background*16;
  Window(1,1,80,25);
  If Border = None
    Then Window(X1,Y1,X2,Y2)
  Else Begin
    GotoXY(X1,Y1);
    Write(Borders[Border,UpperLeft]);                  { upper left  }
    GotoXY(X2,Y1);
    Write(Borders[Border,UpperRight]);                 { upper right }
    GotoXY(X1,Y2);
    Write(Borders[Border,LowerLeft]);                  { lower left  }
    Len := (succ(x2)-x1 - Length(title)) div 2;
    GotoXY(len+x1, y1);
    Write(title);
    Window(Succ(X1),Succ(Y1),Pred(X2),Pred(Y2)); { reduce the window size }
  End;
  ClrScr;
End;

function Shadow(attr: byte): byte;
	var
  	f, b: byte;
  begin
  	f := attr mod 16;
    b := attr div 16;
    if f = 0 then f := 8
    else if f in [1..8] then f := 8
    else f := f - 8;
    if b = 0 then b := 0
    else if b in [1..8] then b := 0
    else b := b - 8;
    Shadow := f+b*16;
  end;

Procedure MakeWindow(X1,Y1,X2,Y2 : Integer;
                     Forground,BackGround : Byte;
                     Border : BorderType; title: string);

{ Saves the screen and draws a box. }

{ Inputs are:  The four window coordinates,        }
{              the forground color,                }
{              the background color, and           }
{              the border type (see DrawBox)       }

var
	c: byte;
Begin
  SaveScreen(1,1,80,25);
  UnderScreen^.NoBorder := (Border = None);
  Window(1, 1, 80, 25);
  if border <> none then
  begin
    if y2 < 25 then
  	for c := x1+2 to x2 do
		begin
			GotoXY(c, y2+1);
      TextAttr := Shadow((UnderScreen^.Screen^[(((y2+1-1)*80)+(c-1))*2+1]));
      WriteCh(Chr(UnderScreen^.Screen^[(((y2+1-1)*80)+(c-1))*2]));
    end;
    if (x2 < 80) and (y2 < 25) then
    begin
	    GotoXY(x2+1, y2+1);
      TextAttr := Shadow((UnderScreen^.Screen^[(((y2+1-1)*80)+(x2+1-1))*2+1]));
  	  WriteCh(Chr(UnderScreen^.Screen^[(((y2+1-1)*80)+(x2+1-1))*2]));
    end;
    if (x2+1 < 80) and (y2 < 25) then
    begin
    	GotoXY(x2+2, y2+1);
      TextAttr := Shadow((UnderScreen^.Screen^[(((y2+1-1)*80)+(x2+2-1))*2+1]));
      WriteCh(Chr(UnderScreen^.Screen^[(((y2+1-1)*80)+(x2+2-1))*2]));
    end;
    if x2 < 80 then
		for c := y1+1 to y2 do
    begin
    	GotoXY(x2+1, c);
      TextAttr := Shadow((UnderScreen^.Screen^[(((c-1)*80)+(x2+1-1))*2+1]));
      WriteCh(Chr(UnderScreen^.Screen^[(((c-1)*80)+(x2+1-1))*2]));
    end;
    if x2+1 < 80 then
		for c := y1+1 to y2 do
    begin
    	GotoXY(x2+2, c);
      TextAttr := Shadow((UnderScreen^.Screen^[(((c-1)*80)+(x2+2-1))*2+1]));
      WriteCh(Chr(UnderScreen^.Screen^[(((c-1)*80)+(x2+2-1))*2]));
    end;
  end;
  DrawBox(X1,Y1,X2,Y2,Forground,Background,Border, title);
End;

Function EGA : Boolean;

Begin
  If (MemW[$C000:$001E] = $4249) And (Mem[$C000:$0020] = $4D)
    Then EGA := TRUE
  Else EGA := FALSE;
End;

Procedure CursorOff;
Var
   regs : Registers;
Begin
  Regs.AH:=$01;
  Regs.CH:=$20;
  Intr($10,regs);
end;


Procedure Initialize;

Begin
  UseMono := FALSE;
  ScreenSaved := FALSE;
  UnderScreen := Nil;           { no screens saved }
  DirectVideo := TRUE;
  CheckSnow := TRUE;
  If (VideoMode = 7) Or EGA Then CheckSnow := FALSE;
  If VideoMode = 7 Then
  Begin
    UseMono := True;
    StandardCursor := $0B0C;
  End;
End;

Begin
  Initialize;
End.

