(***************************************************************************
Original Unit by Brandon Sneed (Nivenh)

Matrix Selection and Conditioning
Accessed at the System Config Menu.

If by some chance this source code is ever release (not likely), this will
be pretty nifty.. ahah.

Nivenh [07-09-94]

  matrixrec=
  record
    mwhich:=integer;                   { Which Matrix DOS, Pulldown, MNU }
    mtansi:=string[30];                   { Filename for Matrix Display }
    mx:integer;                       { top left x point }
    my:integer;                       { top left y point }
    pullcmd:array[1..6] of string[32];{ Pulldown Command's }
    hifclr:integer;                   { Pulldown Hi-lite forground }
    hibclr:integer;                   { Pulldown Hi-lite backgroudn }
    lwfclr:integer;                   {  "       low foreground }
    lwbclr:integer;                   {  "       low background }
  end;

***************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O-,R-,S+,V-}
unit sysop2m;

interface

uses dos,crt,common;

procedure configmatrix;

implementation

procedure configmatrix;
var c:char;
    i:integer;
    done:boolean;
    s:string[32];
    r:string[30];
begin
cls;
done:=false;
if (not exist(systat.gfilepath+'MATRIX.DAT')) then begin
assign(mtr,systat.gfilepath+'MATRIX.DAT');
rewrite(mtr);
reset(mtr);
end else begin
assign(mtr,systat.gfilepath+'MATRIX.DAT');
reset(mtr);
end;
repeat
with mtrx do begin
header('Matrix Configuration');
top;
middle('A','Which Matrix (Pulldown/MNU)     :'+cstr(mwhich));
if (mwhich=2) then begin
middle('B','Pulldown Top Left X,Y Points    :'+cstr(mx)+','+cstr(my));
middle('C','Highlighted Foreground          :'+cstr(hifclr));
middle('D','Highlighted Background          :'+cstr(hibclr));
middle('E','Un-Highlight Foreground         :'+cstr(lwfclr));
middle('F','Un-Highlight Background         :'+cstr(lwbclr));
middle('G','Pulldown Option #1              :'+pullcmd[1]);
middle('H','Pulldown Option #2              :'+pullcmd[2]);
middle('I','Pulldown Option #3              :'+pullcmd[3]);
middle('J','Pulldown Option #4              :'+pullcmd[4]);
middle('K','Pulldown Option #5              :'+pullcmd[5]);
middle('L','Pulldown Option #6              :'+pullcmd[6]);
middle('M','Ansi to Display before bars     :'+mtansi);
end;
onek(c,'ABCDEFGHIJKLMQ');
case c of
'A':begin nl; nl; sprint(#3#0+'Which Matrix, (1) Pulldown (2) MATRIX.MNU');
          prt(': '); inu(i);
          if (i=1) then mwhich:=1 else mwhich:=2;
     end;
'B':begin nl; nl; prt(#3#0+'Top-Left X point: '); inu(i); mx:=i;
                  prt(#3#0+'Top-Left Y point: '); inu(i); my:=i;
     end;
'C':begin nl; nl; sprint(#3#0+'Highlighted Option Foreground color');
          prt(': '); inu(i);
          hifclr:=i;
     end;
'D':begin nl; nl; sprint(#3#0+'Highlighted Option Background color');
          prt(': '); inu(i);
          hibclr:=i;
     end;
'E':begin nl; nl; sprint(#3#0+'Un-highlighted Option Foreground color');
          prt(': '); inu(i);
          lwfclr:=i;
     end;
'F':begin nl; nl; sprint(#3#0+'Un-highlighted Option Background color');
          prt(': '); inu(i);
          lwbclr:=i;
     end;
'G':begin nl; nl; sprint(#3#0+'Pulldown option #1 (ie. Logon )');
          prt(': '); input(s,32);
          pullcmd[1]:=s;
    end;
'H':begin nl; nl; sprint(#3#0+'Pulldown option #2 (ie. Apply )');
          prt(': '); input(s,32);
          pullcmd[2]:=s;
    end;
'I':begin nl; nl; sprint(#3#0+'Pulldown option #3 (ie. Check )');
          prt(': '); input(s,32);
          pullcmd[3]:=s;
    end;
'J':begin nl; nl; sprint(#3#0+'Pulldown option #4 (ie. Chat )');
          prt(': '); input(s,32);
          pullcmd[4]:=s;
    end;
'K':begin nl; nl; sprint(#3#0+'Pulldown option #5 (ie. Logoff )');
          prt(': '); input(s,32);
          pullcmd[5]:=s;
    end;
'L':begin nl; nl; sprint(#3#0+'Pulldown option #6 (ie. Logon )');
          prt(': '); input(s,32);
          pullcmd[6]:=s;
    end;
'M':begin nl; nl; sprint(#3#0+'ANSI file displayed before Lighbars appear');
          prt(': '); input(r,30);
          mtansi:=s;
    end;
'Q':done:=true;
 end;
end;
until (done) or (hangup);
close(mtr);
end;

end.











