(*Modem Configuration*)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S-,V-}
unit sysop2a;

interface

uses
  crt, dos, overlay,
  cuser, common1, common2, common3,
  common;

procedure pomodem;

implementation

const
  aresure='Are you sure this is what you want? ';

procedure noch;
begin
  print('No change.');
end;

(*procedure InputLine(int:boolean;X,Y,Len,retcode:integer;S,inf:string;var v);
Begin
  gotoxy(1,24);
  writeln(inf);
  ReadLine(X,Y,Len,7,1,s,Retcode);
  if (not int) then
    v:=s else
      v:=value(s);
end;*)

procedure modemirq;
var i:integer;
    changed:boolean;
    vs:astr;
begin
  print('Current modem IRQ is: '+cstr(modemr.irqnum));
  nl;
  print('DOS Default IRQ''s are Ports 1,3=irq 4 / 2,4,5,6,7,8=irq 3');
  prompt('Enter NEW modem IRQ number or 0 for default: ');
  mpl(2);
  inputwn(vs,2,changed);
  if (changed) then begin
    modemr.irqnum:=value(vs);
  end else
    noch;
end;

procedure buffsize;
var i:integer;
    changed:boolean;
    vs:astr;
begin
  print('Current Buffer Size is: '+cstr(modemr.inoutbuff));
  nl;
  print('Normal Size is 16 / Max Size is 65');
  prompt('Enter NEW buffer size: ');
  mpl(5);
  inputwn(vs,5,changed);
  if (changed) then begin
    modemr.inoutbuff:=value(vs);
  end else
    noch;
end;


function wantit:boolean;
begin
  nl; wantit:=pynq(aresure,true);
end;

function showmodemstring(s:astr):astr;
var o:astr;
    i:integer;
begin
  o:='';
  for i:=1 to length(s) do
    case s[i] of
      ^@..^L,^N..^[:
         o:=o+'^'+chr(ord(s[i])+64);
      ^M:o:=o+'|';
    else
         o:=o+s[i];
    end;
  showmodemstring:=o;
end;

function usefoss:astr;
var s4:string[10];
begin
  with systat do begin
    if (fossil) then s4:='FOSSIL v5' else s4:='Internal';
  end;
  usefoss:=s4;
end;

function hardhand:astr;
var s4:string[3];
begin
  with modemr do begin
    if (hardware) then s4:='ON ' else s4:='OFF';
  end;
  hardhand:=s4;
end;

procedure newmodemstring(var vs:astr; what:astr; len:integer);
var i:integer;
    changed:boolean;
begin
  print('Current modem '+what+' string: "'+showmodemstring(vs)+'"');
  nl;
  print('Use: "^" preceding control codes (^@..^[)');
  print('     "~" for a half-second delay');
  nl;
  print('Enter NEW modem '+what+' string:');
  prt(':');
  if (len>78) then mpl(78) else mpl(len);
  inputwn(vs,len,changed);
  if (changed) then begin
    for i:=1 to length(vs) do
      case vs[i] of
        '|':vs[i]:=^M;
        '^':if ((i<>length(vs)) and (vs[i+1] in ['@'..'['])) then begin
              vs[i]:=chr(ord(vs[i+1])-64);
              delete(vs,i+1,1);
            end;
      end;
  end else
    noch;
end;

procedure pomodem;
var modemrf:file of modemrec;
    ss2,ss,s:string[80];
    i,c1,c2,cc:integer;
    c,ccc:char;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with modemr do begin
      cls;
      header('Modem configuration');
      top;
      middle('A','Maximum baud rate    ['+cstr(waitbaud)+']');
      middle('B','COM port number      ['+cstr(comport)+']');
      middle('C','IRQ Number           ['+cstr(irqnum)+']');
      middle('D','In/Out Buffer Size   ['+cstr(inoutbuff)+']');
      middle('E','Modem Init String    ['+showmodemstring(init)+']');
      middle('F','Modem answer string  ['+showmodemstring(answer)+']');
      middle('G','Modem hangup string  ['+showmodemstring(hangup)+']');
      middle('H','Modem offhook string ['+showmodemstring(offhook)+']');
      middle('I','No-call init time    ['+cstr(nocallinittime)+']');
      middle('J','Locked baud rate     ['+cstrl(arq9600rate)+' Baud]');
      middle('K','Hardware Handshaking ['+hardhand+']');
      middle('L','Comm Driver Type     ['+usefoss+']');
      bottom;
      command('QABCDEFGHIJKL');
      onek(c,'QABCDEFGHIJKL'^M); nl;
      case c of
        'A':if (incom) then begin
              sprint(#3#7+'This can only be changed locally!!|NL');
              pausescr;
            end else begin
              print('This should be your Modem''s MAXIMUM Speed.');
              nl;
              print('The current rate is: '+cstrl(waitbaud)+' baud.');
              nl;
              print('A:300 B:1200 C:2400 D:4800 E:9600 F:19200 G:38400 H:57600 I:115200');
              prt('Modem speed? (A-I) : '); onek(ccc,'QABCDEFGHI'^M);
              if (ccc in ['A'..'I']) then
                case ccc of
                  'A':waitbaud:=300;
                  'B':waitbaud:=1200;
                  'C':waitbaud:=2400;
                  'D':waitbaud:=4800;
                  'E':waitbaud:=9600;
                  'F':waitbaud:=19200;
                  'G':waitbaud:=38400;
                  'H':waitbaud:=57600;
                  'I':waitbaud:=115200;
                end;
            end;
        'B':if (incom) then begin
              sprint(#3#7+'This can only be changed locally!!|NL');
              pausescr;
            end else begin
              prt('Com port (1-8) (0 - Local)? '); inu(cc);
              if (cc in [0..8]) then
                if (wantit) then begin
                  remove_port;
                  comport:=cc;
                  iport;
                end
                else noch;
            end;
        'C':modemirq;
        'D':buffsize;
        'E':newmodemstring(init,'init',80);
        'F':newmodemstring(answer,'answer',40);
        'G':newmodemstring(hangup,'hangup',40);
        'H':newmodemstring(offhook,'offhook',40);
        'I':begin
              prt('No call modem re-initialization: '); inu(c1);
              if (not badini) then nocallinittime:=c1;
            end;
        'J':begin
              print('Locked Port Speed.');
              nl;
              print('The current rate is: '+cstrl(arq9600rate)+' baud.');
              nl;
              prt('(A):9600 (B):19200 (C):38400 (D):57600 (E):115200 or (Q)uit : ');
              onek(ccc,'QABCDE'^M);
              if (ccc in ['A'..'E']) then
                case ccc of
                  'A':arq9600rate:=9600;
                  'B':arq9600rate:=19200;
                  'C':arq9600rate:=38400;
                  'D':arq9600rate:=57600;
                  'E':arq9600rate:=11520;
                end;
            end;
        'K':modemr.hardware:=not modemr.hardware;
        'L':systat.fossil:=not systat.fossil;
        'Q':done:=TRUE;
      end;
    end;
  until ((done) or (hangup));
  assign(modemrf,systat.gfilepath+'modem.'+cstr(thisnode));
  reset(modemrf); seek(modemrf,0); write(modemrf,modemr); close(modemrf);
end;

end.
