{$M 6500,0,0}       { Declared here suffices for all Units as well! }
program init;

uses
  crt, dos,
  myio, timejunk, execswap,
  menuttt5,fastttt5,winttt5,pullttt5;

{$I records.pas}

var
  systatf:file of systatrec;
  systat:systatrec;
  modemf:file of modemrec;
  modemr:modemrec;
  fstringf:file of fstringrec;
  fstring:fstringrec;
  uf:file of userrec;
  u:userrec;
  sf:file of smalrec;
  sr:smalrec;
  bf:file of boardrec;
  br:boardrec;
  uff:file of ulrec;
  ufr:ulrec;
  xp:file of protrec;
  xpr:protrec;
  zf:file of zlogrec;
  zfr:zlogrec;
  brdf:file;
  mixf:file;
  tref:file;
  lcallf:file of lcallers;
  lcall:lcallers;
  verbf:file of verbrec;
  vr:verbrec;
  vdata:file of vdatar;
  vd:vdatar;
  ulff:file of ulfrec;
  ulffr:ulfrec;
  evf:file of eventrec;
  evr:eventrec;
  fidorf:file of fidorec;
  fidor:fidorec;
  curdir:string;
  path:array[1..8] of string;
  found:boolean;
  dirinfo:searchrec;
  i,j,k:integer;
  c:char;

procedure tc(i:integer);
begin textcolor(i);
end;

procedure tb(i:integer);
begin textbackground(i);
end;

function syn(b:boolean):astr;
begin
  if (b) then syn:='Yes' else syn:='No ';
end;

function yn:boolean;
var c:char;
    b:boolean;
begin
  repeat c:=upcase(readkey) until c in ['Y','N',^M];
  case c of 'Y':b:=TRUE; else b:=FALSE; end;
  write(syn(b));
  yn:=b;
end;

function pynq(s:string):boolean;
begin
  textcolor(4); write(s);
  textcolor(11); pynq:=yn;
end;

procedure prt(s:string);
begin
  textcolor(8); write(s);
end;

procedure star(s:string);
begin
  tb(0);
  clrscr;
  textcolor(8); write(' ');
  textcolor(15); cwrite(s); writeln;
end;

function freek(d:integer):longint;
var lng:longint;
begin
  lng:=diskfree(d);
  freek:=lng div 1024;
end;

function exdrv(s:astr):byte;
begin
  s:=fexpand(s);
  exdrv:=ord(s[1])-64;
end;

function leapyear(yr:integer):boolean;
begin
  leapyear:=(yr mod 4=0) and ((yr mod 100<>0) or (yr mod 400=0));
end;

function value(s:astr):longint;
var i,j:integer;
begin
  val(s,i,j);
  if (j<>0) then begin
    s:=copy(s,1,j-1);
    val(s,i,j)
  end;
  value:=i;
  if (s='') then value:=0;
end;

function days(mo,yr:integer):integer;
var d:integer;
begin
  d:=value(copy('312831303130313130313031',1+(mo-1)*2,2));
  if ((mo=2) and (leapyear(yr))) then inc(d);
  days:=d;
end;

function daycount(mo,yr:integer):integer;
var m,t:integer;
begin
  t:=0;
  for m:=1 to (mo-1) do t:=t+days(m,yr);
  daycount:=t;
end;

function daynum(dt:astr):integer;
var d,m,y,t,c:integer;
begin
  t:=0;
  m:=value(copy(dt,1,2));
  d:=value(copy(dt,4,2));
  y:=value(copy(dt,7,2))+1900;
  for c:=1985 to y-1 do
    if (leapyear(c)) then inc(t,366) else inc(t,365);
  t:=t+daycount(m,y)+(d-1);
  daynum:=t;
  if y<1985 then daynum:=0;
end;

function tch(s:astr):astr;
begin
  if (length(s)>2) then s:=copy(s,length(s)-1,2) else
    if (length(s)=1) then s:='0'+s;
  tch:=s;
end;

function time:astr;
var h,m,s:string[3];
    hh,mm,ss,ss100:word;
begin
  gettime(hh,mm,ss,ss100);
  str(hh,h); str(mm,m); str(ss,s);
  time:=tch(h)+':'+tch(m)+':'+tch(s);
end;

function date:astr;
var r:registers;
    y,m,d:string[3];
    yy,mm,dd,dow:word;
begin
  getdate(yy,mm,dd,dow);
  str(yy-1900,y); str(mm,m); str(dd,d);
  date:=tch(m)+'/'+tch(d)+'/'+tch(y);
end;


procedure ffile(fn:string);
begin
  findfirst(fn,anyfile,dirinfo);
  found:=(doserror=0);
end;

procedure nfile;
begin
  findnext(dirinfo);
  found:=(doserror=0);
end;

function make_path(s:string):boolean;
begin
  while (copy(s,length(s),1)='\') do s:=copy(s,1,length(s)-1);
  make_path:=TRUE;
  {$I-} mkdir(fexpand(s)); {$I+}
  if (ioresult<>0) then begin
    writeln;
    star('Error creating directory "'+fexpand(s)+'"'^G^G);
    make_path:=FALSE;
  end;
end;

procedure make_paths;
var s:string;
begin
  for i:=1 to 8 do begin
    while copy(path[i],length(path[i]),1)='\' do
      path[i]:=copy(path[i],1,length(path[i])-1);
    case i of 1:s:='DATA'; 2:s:='MSGS'; 3:s:='MENUS'; 4:s:='TEXT';
              5:s:='ANSI'; 6:s:='TRAP'; 7:s:='TEMP'; 8:s:='SWAP'; end;
    star(s+' path ("'+fexpand(path[i])+'")');
    if (not make_path(path[i])) then halt(1);
    path[i]:=path[i]+'\';
  end;
  if (not make_path(path[7]+'1\')) then halt(1);
  if (not make_path(path[7]+'2\')) then halt(1);
  if (not make_path(path[7]+'3\')) then halt(1);
end;

procedure make_status_dat;
begin
  with systat do begin
    gfilepath:=path[1];
    msgpath:=path[2];
    menupath:=path[3];
    tfilepath:=path[4];
    afilepath:=path[5];
    trappath:=path[6];
    temppath:=path[7];
    swappath:=path[8];
    bbsname:='UnReg''d Sysop';
    bbsphone:='214-555-5555';
    sysopname:='Sysop';
    maxusers:=9999;
    lowtime:=0; hitime:=0;
    dllowtime:=0; dlhitime:=0;
    shuttlelog:=false;
    nuvyes:=7;
    nuvno:=5;
    regnum:=' ';
    pcbfile:=true;
    lock300:=FALSE;
    sysoppw:='SYSOP';
    newuserpw:='';
    shuttlepw:='IMPULSE';
    b300lowtime:=0; b300hitime:=0;
    b300dllowtime:=0; b300dlhitime:=0;
    closedsystem:=FALSE;
    swapshell:=true;
    eventwarningtime:=60;
    tfiledate:=date;

    sop:='s255';
    csop:='s250';
    msop:='s199';
    fsop:='s230';
    spw:='s250';
    seepw:='s255';
    normpubpost:='s11';
    normprivpost:='s11';
    anonpubread:='s100';
    anonprivread:='s100';
    anonpubpost:='s100';
    anonprivpost:='s100';
    seeunval:='s50';
    dlunval:='s230';
    nodlratio:='s255';
    nopostratio:='s200';
    nofilepts:='s255';
    ulvalreq:='s21';

    maxprivpost:=20;
    maxfback:=5;
    maxpubpost:=20;
    maxchat:=3;
    maxwaiting:=15;
    csmaxwaiting:=50;
    maxlines:=255;
    csmaxlines:=255;
    maxlogontries:=4;
    bsdelay:=20;
    sysopcolor:=4;
    usercolor:=3;
    minspaceforpost:=10;
    minspaceforupload:=100;
    backsysoplogs:=7;
    wfcblanktime:=0;
    linelen:=80;
    pagelen:=25;

    specialfx:=TRUE;
    fossil:=true;
    allowalias:=TRUE;
    phonepw:=false;
    localsec:=FALSE;
    localscreensec:=FALSE;
    globaltrap:=FALSE;
    autochatopen:=false;
    autominlogon:=TRUE;
    bullinlogon:=false;
    lcallinlogon:=false;
    yourinfoinlogon:=TRUE;
    multitask:=FALSE;
    offhooklocallogon:=TRUE;
    forcevoting:=FALSE;
    compressbases:=FALSE;
    searchdup:=FALSE;
    slogtype:=0;
    stripclog:=FALSE;
    newapp:=1;
    guestuser:=-1;
    timeoutbell:=2;
    timeout:=5;
    usewfclogo:=TRUE;
    useems:=FALSE;
    usebios:=TRUE;
    cgasnow:=FALSE;

    filearccomment[1]:='';
    filearccomment[2]:='';
    filearccomment[3]:='';
    ulcheckit:=true;
    uldlratio:=TRUE;
    fileptratio:=FALSE;
    fileptcomp:=3;
    fileptcompbasesize:=10;
    ulrefund:=100;
    tosysopdir:=0;
    validateallfiles:=FALSE;
    remdevice:='COM1';
    maxintemp:=500;
    minresume:=100;
    maxdbatch:=20;
    maxubatch:=20;

    newsl:=20;
    newdsl:=20;
    newar:=[];
    newac:=[rpostan,rvoting];
    newfp:=0;
    autosl:=50;
    autodsl:=50;
    autoar:=[];
    autoac:=[];

    allstartmenu:='MAIN';
    bulletprefix:='BULLET';

    for i:=0 to 255 do begin
      case i of 0..9:k:=1; 10..19:k:=10; 20..29:k:=20; 30..39:k:=40;
                40..49:k:=50; 50..59:k:=80; 60..69:k:=90; 70..79:k:=100;
                80..89:k:=110; 90..99:k:=120; 100..199:k:=130;
                200..239:k:=150; 240..249:k:=200; 250:k:=250;
                251..255:k:=6000; end; timeallow[i]:=k;
      case i of 200..255:k:=3200; 100..199:k:=15; 50..99:k:=10;
                30..49:k:=5; 20..29:k:=3; else k:=1; end; callallow[i]:=k;
      case i of 60..255:k:=5; 20..59:k:=3; else k:=2; end; dlratio[i]:=k;
      case i of 60..255:k:=10; 20..59:k:=5; else k:=2; end; dlkratio[i]:=k;
      postratio[i]:=100;
    end;

    lastdate:=date;
    curwindow:=1;
    istopwindow:=FALSE;
    callernum:=0;
    numusers:=1;

    with todayzlog do begin
      for i:=0 to 4 do userbaud[i]:=0;
      active:=0; calls:=0; newusers:=0; pubpost:=0;
      privpost:=0; fback:=0; criterr:=0;
      uploads:=0; downloads:=0;
      uk:=0; dk:=0;
    end;

    postcredits:=0;
    rebootforevent:=FALSE;
    watchdogdoor:=FALSE;
    pcbfile:=false;
    windowon:=false;
  end;
  assign(systatf,'status.dat');
  rewrite(systatf); write(systatf,systat); close(systatf);
end;

procedure make_fidonet_dat;
begin
  with fidor do begin
    zone:=0;
    net:=0;
    node:=0;
    point:=0;
    origin:=copy(systat.bbsname+' ('+systat.bbsphone+')',1,50);
    text_color:=1;
    quote_color:=3;
    tear_color:=9;
    origin_color:=5;
    skludge:=TRUE;
    sseenby:=TRUE;
    sorigin:=FALSE;
    scenter:=TRUE;
    sbox:=TRUE;
    mcenter:=TRUE;
    addtear:=TRUE;
  end;
  assign(fidorf,systat.gfilepath+'fidonet.dat');
  rewrite(fidorf); write(fidorf,fidor); close(fidorf);
end;

procedure make_modem_dat;
var i,j:integer;
begin
  with modemr do begin
    waitbaud:=38400;
    comport:=1;
    init:='ATZ|~~~ATS95=1|';
    answer:='ATA|';
    hangup:='~~~+++~~~ATH0|';
    offhook:='ATH1M0|';
    nocallinittime:=30;
    arq9600rate:=38400;
    noforcerate:=FALSE;
  end;
  assign(modemf,systat.gfilepath+'modem.1');
  rewrite(modemf); write(modemf,modemr); close(modemf);
end;

procedure make_user_lst;
const dcols:clrs=((15,7,7,15,15,15,112,7,15,7),(15,7,1,11,9,8,25,3,7,8));
begin
  with u do begin
    name:='SYSOP';
    realname:='Mr. Sysop';
    pw:='SYSOP';
    ph:='214-000-0000';
    bday:='00/00/00';
    firston:=date;
    laston:=date;
    street:='';
    citystate:='';
    zipcode:='';
    prompt:=0;
    fflag:=[fname,fsize,fpts,fdesc,extdesc];
    note:='Change these stats to yours.';
    lockedout:=FALSE;
    deleted:=FALSE;
    lockedfile:='';
    ac:=[onekey,pause,novice,ansi,color,
         smw,
         fnodlratio,fnopostratio,fnofilepts,fnodeletion];
    ar:=[]; for c:='A' to 'Z' do ar:=ar+[c];
    for i:=1 to 20 do vote[i]:=0;
    sex:='M';
    ttimeon:=0;
    uk:=0;
    dk:=0;
    uploads:=0;
    downloads:=0;
    loggedon:=0;
    tltoday:=600;
    msgpost:=0;
    emailsent:=0;
    feedback:=0;
    forusr:=0;
    filepoints:=0;
    waiting:=0;
    linelen:=80;
    pagelen:=20;
    ontoday:=0;
    illegal:=0;
    sl:=255;
    dsl:=255;
    cols:=dcols;
    lastmsg:=1;
    lastfil:=0;
    credit:=0;
    timebank:=0;
    for i:=1 to 5 do boardsysop[i]:=255;
    trapactivity:=FALSE;
    trapseperate:=FALSE;
    timebankadd:=0;
    mpointer:=-1;
    chatauto:=FALSE;
    chatseperate:=FALSE;
    userstartmenu:='';
    slogseperate:=FALSE;


    msgorder:=0;    { use Chrono message ordering }
    avadjust:=1;    { no AVATAR color adjustment }


    for i:=1 to 54 do res[i]:=0;
  end;
  assign(uf,systat.gfilepath+'user.lst');
  rewrite(uf);
  seek(uf,0); write(uf,u);
  seek(uf,1); write(uf,u);
  close(uf);
end;

procedure make_names_lst;
begin
  with sr do begin
    name:='SYSOP';
    number:=1;
  end;
  assign(sf,systat.gfilepath+'names.lst');
  rewrite(sf);
  seek(sf,0); write(sf,sr);
  seek(sf,1); write(sf,sr);
  close(sf);
end;

procedure make_boards_dat;
begin
  with br do begin
   name:='General';
   filename:='GENERAL';
   lastmsgid:=0;
   mbtype:=0;
   msgpath:='';
   acs:='s30';
   postacs:='s30';
   maxmsgs:=100;
   anonymous:=atno;
   password:='';
   zone:=0;
   net:=0;
   node:=0;
   point:=0;
   if (fidor.origin<>'') then origin:=fidor.origin;
{   else origin:=copy(stripcolor(systat.bbsname),1,50);}
   text_color:=fidor.text_color;
   quote_color:=fidor.quote_color;
   tear_color:=fidor.tear_color;
   origin_color:=fidor.origin_color;
   mbstat:=[];
   if (fidor.skludge) then mbstat:=mbstat+[mbskludge];
   if (fidor.sseenby) then mbstat:=mbstat+[mbsseenby];
   if (fidor.sorigin) then mbstat:=mbstat+[mbsorigin];
   if (fidor.scenter) then mbstat:=mbstat+[mbscenter];
   if (fidor.sbox) then mbstat:=mbstat+[mbsbox];
   if (fidor.mcenter) then mbstat:=mbstat+[mbmcenter];
   if (fidor.addtear) then mbstat:=mbstat+[mbaddtear];
   for j:=1 to 3 do res[j]:=0;
  end;
  assign(bf,systat.gfilepath+'boards.dat');
  rewrite(bf); write(bf,br); close(bf);
end;

procedure make_uploads_dat;
begin
  assign(uff,systat.gfilepath+'uploads.dat');
  rewrite(uff);
  with ufr do begin
    name:='Uploads';
    filename:='UPLOADS';
    dlpath:='.\DLS\UPLOADS\';
    ulpath:=dlpath;
    maxfiles:=2000;
    password:='';
    arctype:=1;
    cmttype:=1;
    fbdepth:=0;
    fbstat:=[];
    acs:='s255d255';
    ulacs:='';
    nameacs:='s255';
    permindx:=0;
    for i:=1 to 6 do res[i]:=0;
  end;
  write(uff,ufr);
  with ufr do begin
    name:='Miscellaneous';
    filename:='MISC';
    dlpath:='.\DLS\MISC\';
    ulpath:=dlpath;
    maxfiles:=2000;
    password:='';
    arctype:=1;
    cmttype:=1;
    fbdepth:=0;
    fbstat:=[];
    acs:='d30';
    ulacs:='';
    nameacs:='';
    permindx:=1;
    for i:=1 to 6 do res[i]:=0;
  end;
  write(uff,ufr); close(uff);
end;

procedure make_zlog_dat;
var i:integer;
begin
  with zfr do begin
    date:='08/18/89';
    for i:=0 to 4 do userbaud[i]:=0;
    active:=0; calls:=0; newusers:=0; pubpost:=0; privpost:=0;
    fback:=0; criterr:=0;
    uploads:=0; downloads:=0;
    uk:=0; dk:=0;
  end;
  assign(zf,systat.gfilepath+'zlog.dat');
  rewrite(zf); write(zf,zfr);
  zfr.date:=''; write(zf,zfr);
  close(zf);
end;

procedure blockwritestr(var f:file; s:string);
begin
  blockwrite(f,s[0],1);
  blockwrite(f,s[1],ord(s[0]));
end;

procedure make_email_brd;
var t:text;
    fb:file;
    mheader:mheaderrec;
    mixr:msgindexrec;
    s:string;
    dt:ldatetimerec;
    pdt:packdatetime;
    lng,lsize:longint;
    i:integer;
    bb:byte;
    year,month,day,dow,hour,min,sec,sec100:word;
begin

  assign(brdf,systat.msgpath+'email.brd');
  rewrite(brdf,1);
  lng:=$FC020010; blockwrite(brdf,lng,4);
  lng:=$DCBA0123; blockwrite(brdf,lng,4);
  blockwrite(brdf,lsize,4);

  with mixr do begin
    messagenum:=1;
    hdrptr:=filesize(brdf);
    msgindexstat:=[miexist];
    msgid:=4242;

    getdate(year,month,day,dow);
    dt.year:=year; dt.month:=month; dt.day:=day;
    gettime(hour,min,sec,sec100);
    dt.hour:=hour; dt.min:=min; dt.sec:=sec; dt.sec100:=sec100;
    dt2pdt(dt,pdt);
    for i:=1 to 6 do msgdate[i]:=pdt[i];
    msgdowk:=0;

    isreplyto:=65535;
    numreplys:=0;
  end;

  assign(mixf,systat.msgpath+'email.mix');
  rewrite(mixf,sizeof(mixr)); blockwrite(mixf,mixr,1); close(mixf);
  with mheader do begin
    signature:=$ABCD0123;
    msgptr:=4;
    title:='Greetings..';
    with fromi do begin
      anon:=0;
      usernum:=1;
      as:='Nivenh';
      real:='Nivenh';
      alias:='Nivenh';
    end;
    with toi do begin
      anon:=0;
      usernum:=1;
      as:='Sysop #1';
      real:='Sysop';
      alias:='Sysop';
    end;
    origindate :='';
  end;
  close(brdf);
end;

procedure make_events_dat;
begin
  assign(evf,systat.gfilepath+'events.dat'); rewrite(evf);
  with evr do begin
    active:=TRUE;                     (* event is active *)
    description:='Pack message bases';
    etype:='P';                       (* PACK BASES event type *)
    execdata:='';                     (* no exec data needed *)
    busytime:=0;                      (* no offhook before event *)
    exectime:=240;                    (* 240 mins past midnite -- i.e. 4:00a *)
    busyduring:=TRUE;                 (* take phone offhook during *)
    duration:=1;                      (* 1 minute long *)
    execdays:=127;                    (* every day of the week *)
    monthly:=FALSE;                   (* weekly, not monthly *)
  end;
  write(evf,evr);
  with evr do begin
    active:=FALSE;                    (* event is NOT active *)
    description:='Nightly events';
    etype:='D';                       (* DOS SHELL event type *)
    execdata:='night.bat';            (* call NIGHT.BAT *)
    busytime:=1;                      (* take phone offhook 1 min before *)
    exectime:=241;                    (* 241 mins past midnite -- i.e. 4:01a *)
    busyduring:=TRUE;                 (* take phone offhook during *)
    duration:=1;                      (* 1 minute long *)
    execdays:=127;                    (* every day of the week *)
    monthly:=FALSE;                   (* weekly, not monthly *)
  end;
  write(evf,evr); close(evf);
end;

procedure make_laston_dat;
begin
  with lcall do begin
    callernum:=0;
    name:='Nivenh';
    number:=0;
    citystate:='Somewhere in Texas';
  end;
  assign(lcallf,systat.gfilepath+'laston.dat');
  rewrite(lcallf); write(lcallf,lcall);
  lcall.callernum:=-1;
  for i:=1 to 9 do write(lcallf,lcall);
  close(lcallf);
end;

procedure make_verbose_dat;
begin
  with vr do
    for i:=1 to 4 do descr[i]:='';
  assign(verbf,systat.gfilepath+'verbose.dat');
  rewrite(verbf); write(verbf,vr); close(verbf);
end;

procedure make_voting_dat;
begin
  with vd do begin
    question:='No Question';
    numa:=0;
    for i:=0 to 9 do
      with answ[i] do begin
        if (i<>0) then ans:='Selection '+chr(i+48) else ans:='No Comment';
        numres:=0;
      end;
  end;
  assign(vdata,systat.gfilepath+'voting.dat');
  rewrite(vdata);
  for i:=0 to 19 do write(vdata,vd);
  close(vdata);
end;

procedure enditall;
begin
tb(0);
clrscr; tc(15); tb(0);
writeln('Impulse v4 Installation');
writeln; tc(3);
writeln('Copyitfromsids by Nivenh'); tc(8);
writeln('Install Done');
writeln;
writeln('Don''t forget to wipe!');
halt(1);
end;

procedure upgrade;
var rs:string[60];
begin
tc(15); tb(0);
gotoxy(1,25);
prt('Impulse Path (ie. C:\IMP): '); readln(rs); tb(0); clrscr;
tc(8); write(' '); tc(15); writeln('Upgrading to v4');
swapvectors;
exec(getenv('COMSPEC'),'/C pkunzip -d imp-bbs.dat *.exe *.ovr *.doc *.nfo '+rs);
swapvectors;
clrscr; writeln('Read NEW.NFO for Information on Version Improvements & Fixes');
writeln; writeln('[Space]');
repeat until keypressed;
end;

procedure dostuff1(s:string);
begin
  writeln;
  writeln('Unarchiving Impulse Files to ',s);
  swapvectors;
  exec(getenv('COMSPEC'),'/C pkunzip -d imp-bbs.dat '+s);
  swapvectors;
end;

{$I INST.PAS}
{$I REG1.PAS}
procedure showregnfo;
  type ScreenType = array [0..3999] of Byte;
   var Screen : ScreenType absolute $B800:0000;
   begin
    clrscr;
    Move(reg,Screen,4000);
    gotoxy(35,15);
    write('[Space]');
   repeat until keypressed;
   end;

procedure showinstallscr;
   type ScreenType = array [0..3999] of Byte;
   var Screen : ScreenType absolute $B800:0000;
   begin
    clrscr;
    Move(install,Screen,4000);
   end;

procedure makedafiles;
var rs:string;
begin
  infield_out_fgrd:=11;
  infield_out_bkgd:=0;
  infield_inp_fgrd:=15;
  infield_inp_bkgd:=1;

  tc(15); tb(0);
  gotoxy(1,25);
  write('Directory (ie. C:\IMP): ');
  readln(rs); tb(0); clrscr;
  {$I-} mkdir(rs); {$I+}

  getdir(0,curdir);
  path[1]:=rs+'\DATA\';
  path[2]:=rs+'\MSGS\';
  path[3]:=rs+'\MENUS\';
  path[4]:=rs+'\TEXT\';
  path[5]:=rs+'\ANSI\';
  path[6]:=rs+'\TRAP\';
  path[7]:=rs+'\TEMP\';
  path[8]:=rs+'\SWAP\';
  tc(8); tb(7);
  {dostuff2;}
  make_paths;
  dostuff1(rs);
end;

procedure wfcmenu2;
var
   Main_Choice,Choice,Error : integer;
   ScanTop, ScanBot : byte;
   M1, MM : Menu_record;
   Ch : char;

Procedure Which_Comm;
begin
    Menu_Set(M1);
    With M1 do
    begin
        topic[1] :='     Full Install of v4        ';
        topic[2] :='  Upgrade from v3.5 or v4b     ';
        topic[3] :='    View Registration Nfo      ';
        topic[4] :='         Quit to OS            ';
        TotalPicks := 4;
        PicksPerLine := 1;            {one column of choices}
        Addprefix := 0;               {add function key prefixes}
        TopleftXY[1] := 20;            {system will center menu}
        TopleftXY[2] := 9;            {Y coordinate}
        Boxtype := 0;                 {fancy box}
        If ColorScreen then
        begin
            Colors[1] := white;           {hi forground}
            Colors[2] := magenta;            {hi background}
            Colors[3] := lightgray;             {lo foreground}
            Colors[4] := blue;       {lo background}
            Colors[5] := white;            {box color}
        end;
        AllowEsc := false;            {inactivate the escape key}
        Margins := 5;
end;  {with M1 do}
end; {Define_Menu1}

Var X,Y:Byte;
    inp:integer;
    Done:Boolean;
Begin
    Activate_Visible_Screen;
    SlideRestoreSCreen(2,Down);
    Findcursor(X,Y,ScanTop,ScanBot);
    OffCursor;
    Main_Choice := 1;
    Done:=False;
    repeat
     showinstallscr;
     GrowFBox(18,8,63,14,9,1,1);
     Which_Comm;
     DisplayMenu(M1,false,Main_Choice,Error);
     Case Main_Choice of
         1:makedafiles;
         2:upgrade;
         3:showregnfo;
         4:enditall;
       end;
    until done;
OnCursor; write(^M);
End;

begin
wfcmenu2;
end.