(*
  ONETIME.PAS - The Illusion Utilities; one time caller deletor
*)

{$A+,B-,D-,E-,F+,I+,L-,N-,O-,R-,S-,V-}

unit onetime;

INTERFACE

USES crt, dos, myio, windows;

procedure onetime1;

IMPLEMENTATION

uses iucommon;

procedure onetime1;
var userf:file of userrec;
    user:userrec;
    i,j:integer;

function leapyear(yr:integer):boolean;
begin
  leapyear:=(yr mod 4=0) and ((yr mod 100<>0) or (yr mod 400=0));
end;

function days(mo,yr:integer):integer;
var d:integer;
begin
  d:=value(copy('312831303130313130313031',1+(mo-1)*2,2));
  if ((mo=2) and (leapyear(yr))) then inc(d);
  days:=d;
end;

function daycount(mo,yr:integer):integer;
var m,t:integer;
begin
  t:=0;
  for m:=1 to (mo-1) do t:=t+days(m,yr);
  daycount:=t;
end;

function daynum(dt:string):integer;
var d,m,y,t,c:integer;
begin
  t:=0;
  m:=value(copy(dt,1,2));
  d:=value(copy(dt,4,2));
  y:=value(copy(dt,7,2))+1900;
  for c:=1985 to y-1 do
    if (leapyear(c)) then inc(t,366) else inc(t,365);
  t:=t+daycount(m,y)+(d-1);
  daynum:=t;
  if y<1985 then daynum:=0;
end;

begin
  setwindow(2,1,10,80,14,8,0,1); tc(7);

  assign(userf,systat.datapath+'USERS.DAT');
  {$I-} reset(userf); {$I+}
  if ioresult<>0 then begin
    writeln('ONETIME: Error opening USERS.DAT'); pausecount(5);
    removewindow(2); exit;
  end;

  j:=0;
  for i:=2 to ((filesize(userf)-1)) do begin
    seek(userf,i); read(userf,user);
    gotoxy(1,wherey);
    cwrite('ONETIME: Reading User ['#3#3+cstr(i)+#3#7']');

    if ((user.firston=user.laston) and
        (daynum(date)>daynum(user.firston)+7) and
        (not user.deleted))
    then begin
      user.deleted:=TRUE;
      inc(j);
      seek(userf,i); write(userf,user);
    end;
  end;

  close(userf); writeln;
  cwrite('ONETIME: * '#3#3+cstr(j)+#3#7' user(s) deleted.'); writeln;
  pausecount(4); removewindow(2);
end;


END.