(****************************************************************************)
(*                                                                          *)
(* I_ECHO - The Illusion Echomail Interface                                 *)
(*          by Kyle Oppenheim                                               *)
(*                                                                          *)
(****************************************************************************)

Program I_Echo;

{$A+,B+,D-,L-,F+,I+,N-,E-,S+,V-}
{$M 32768,0,1024}

Uses Crt, Dos;
{$I \prg\iutils\i_194.inc}

const
    _brd_opened:boolean=FALSE;  { has brdf been opened yet? }
    oldnummsgs:integer=0;       { old number of messages }
    gotlastmheader:boolean=FALSE;
    rundos:boolean=TRUE;        { Run the pre/post-proc? }
    forcescan:boolean=FALSE;    { Force running post-proc? }
    keeplog:boolean=TRUE;       { Write to the sysop.log? }
    wroteloghead:boolean=FALSE; { did we already write the header? }
    ignorehiwater:boolean=FALSE;{ Ignore the high water marks? }
    deltwit:boolean=FALSE;      { Delete twits? }
    optionerror:boolean=FALSE;  { Wrong parameters? }

    _Private  = $0001;
    _Crash    = $0002;
    _Recvd    = $0004;
    _Sent     = $0008;
    _File     = $0010;
    _Forward  = $0020;     { Also know as In-Transit }
    _Orphan   = $0040;
    _KillSent = $0080;
    _Local    = $0100;
    _Hold     = $0200;
    _Freq     = $0800;

    Status    : Array[1..12] Of String[3] = ('Jan','Feb','Mar','Apr','May',
                'Jun','Jul','Aug','Sep','Oct','Nov','Dec');

Type
    FileShareType = (DenyCompatibility,DenyAll,DenyWrite,DenyRead,DenyNone);
    FileAccessType = (ReadOnly,WriteOnly,ReadWrite);

    NetMsg = Record        { NetMessage Record Structure }
      From,
      Too        : String[35];
      Subject    : String[71];
      Date       : String[19];
      TimesRead,
      DestNode,
      OrigNode,
      Cost,
      OrigNet,
      DestNet,
      ReplyTo,
      Attr,
      NextReply  : Word;
      AreaName   : String[20];
    End;

    HiWaterRec = Record
      Note : String[50];
      Hi: Integer;
    End;

    twitrec=record
       name:string[20];
       Base:string[5];
       field:byte;
       partcomp:boolean;
    end;

    iechodatrec=record
       entries:byte;
       twits:array[1..50] of twitrec;
    end;

    packdatetime=array[1..6] of byte;
    packdatetimepp=^packdatetime;
    packdate=array[1..3] of byte;
    packtime=array[1..3] of byte;
    ldatetimerec=
    record
      year,month,day,hour,min,sec,sec100:word;
    end;

Var
   Exitsave       :Pointer;
   Systat         :Systatrec;
   fidor          :fidorec;
   bf             :file of boardrec;
   mixf           :file;
   brdf           :file;
   memboard       :boardrec;
   numboards,board:integer;
   mintabloaded   :word;
   mintaboffset   :longint;
   mintab         :array[0..99] of msgindexrec;
   himsg          :longint;
   himintab       :longint;
   net            :netmsg;
   Mixr           :msgindexrec;
   Mhead          :mheaderrec;
   hiwaterf       :file of hiwaterrec;
   hiwaterr       :hiwaterrec;
   iechodatf      :file of iechodatrec;
   twitr          :iechodatrec;

(****************************************************************************)
(****************************************************************************)
(* I_Echo Misc. Procedures (readsystat, dotitle, ferror, etc.)              *)

Procedure SetFileAccess(Accessmode:FileAccessType; ShareMode:FileShareType);
begin
  FileMode:=ord(AccessMode);
  if lo(DosVersion)>=3 then FileMode:=FileMode or (ord(ShareMode) shl 4);
end;

Function Int_to_Str(Number:longint):string;
var Temp : string;
begin
    Str(Number,temp);
    Int_to_Str := temp;
end;

Function  Str_to_Int(Str:string):integer;
var temp,code : integer;
begin
    If length(Str) = 0 then
       Str_to_Int := 0
    else
    begin
       val(Str,temp,code);
       if code = 0 then
          Str_to_Int := temp
       else
          Str_to_Int := 0;
    end;
end;

procedure tc(i:byte);
begin
  textcolor(i);
end;

procedure ferror(s:string);
begin
  writeln; tc(3);
  writeln('   *** '+s+' was not able to be opened.');
  writeln('   I_Echo halting with errolevel 1'); halt(1);
end;

procedure readsystat;
var systatf:file of systatrec;
    s:astr;
begin
  s:=getenv('IBBS');
  if s='' then s:='ILLUSION.CFG' else s:=s+'\ILLUSION.CFG';
  assign(systatf,s);
  SetFileAccess(ReadOnly,DenyNone);
  {$I-} reset(systatf); {$I+}
  if (ioresult<>0) then ferror('ILLUSION.CFG') else
  begin
    read(systatf,systat);
    close(systatf);
  end;
end;

procedure readfidor;
var fidof:file of fidorec;
begin
  assign(fidof,systat.datapath+'NETWORK.DAT');
  SetFileAccess(ReadOnly,DenyNone);
  {$I-} reset(fidof); {$I+}
  if ioresult<>0 then ferror('NETWORK.DAT') else
  begin
    read(fidof,fidor);
    close(fidof);
  end;
end;

procedure openboardsdat;
begin
  assign(bf,systat.datapath+'MBOARDS.DAT');
  SetFileAccess(ReadWrite,DenyNone);
  {$I-} reset(bf); {$I+}
  if (ioresult<>0) then ferror('MBOARDS.DAT');
end;

procedure dotitle;
begin
  textbackground(0); tc(11); writeln;
  write('I_ECHO'); tc(3); writeln(' - Illusion Echomail Interface  Version '+ver);
  writeln('Written by Kyle Oppenheim for use with the Illusion BBS System');
  writeln('Additional programming by Martin Pollard, Eric Oman, & Kelly Drown');
  writeln;
end;

function sqoutsp(s:string):string;
begin
  while (pos(' ',s)>0) do delete(s,pos(' ',s),1);
  sqoutsp:=s;
end;

function exist(fn:string):boolean;
var srec:searchrec;
begin
  findfirst(sqoutsp(fn),anyfile,srec);
  exist:=(doserror=0);
end;

function ridspace(nn:string):string;
begin
  while ((copy(nn,1,1)=' ') or (copy(nn,1,1)=#0))
    do nn:=copy(nn,2,length(nn)-1);
  while ((copy(nn,length(nn),1)=' ') or (copy(nn,length(nn),1)=#0))
    do nn:=copy(nn,1,length(nn)-1);
  while (pos('  ',nn)<>0) do delete(nn,pos('  ',nn),1);
  ridspace:=nn;
end;

Function Upper(Str:string):string;
var
  I : integer;
begin
    For I := 1 to length(Str) do
        Str[I] := Upcase(Str[I]);
    Upper := Str;
end;  {Func Upper}

function isc(var c:char):boolean;
begin
  if (pos(c,#0#1#2#3#4#5#6#7#8#9'1234567890kbgcrmywKBGCRMYW')<>0)
    then isc:=TRUE else isc:=FALSE;
end;

function stripcolor(o:string):string;
var s:string;
    i:integer;
    lc:boolean;
begin
  s:=''; lc:=FALSE;
  for i:=1 to length(o) do
    if (lc) then lc:=FALSE
      else if ((o[i]='|') and (isc(o[i+1]))) then lc:=TRUE else s:=s+o[i];
  stripcolor:=s;
end;

(****************************************************************************)
(****************************************************************************)
(* Illusion Message Board Procedures (Loadboard, Initbrd, findhimsg, etc.)  *)

procedure loadboard(i:integer);
var bfo:boolean;
begin
  bfo:=(filerec(bf).mode<>fmclosed);
  if (not bfo) then begin
    SetFileAccess(ReadWrite,DenyNone);
    reset(bf);
  end;
  if ((i-1<0) or (i-1>filesize(bf)-1)) then i:=1;
  seek(bf,i-1); read(bf,memboard);
  if (not bfo) then close(bf);
end;

procedure closebrd;
begin
  if (_brd_opened) then begin
    if (filerec(brdf).mode<>fmclosed) then close(brdf);
    if (filerec(mixf).mode<>fmclosed) then close(mixf);
  end;
  filerec(brdf).mode:=fmclosed;
  filerec(mixf).mode:=fmclosed;
end;

procedure findhimsg;
var mixr:msgindexrec;
    lng:longint;
    numread:word;
begin
  himintab:=(filesize(mixf)-1) div 100;
  himsg:=himintab*100-1;
  seek(mixf,himsg+1);
  repeat
    lng:=himsg;
    blockread(mixf,mixr,1,numread);
    if ((numread=1) and (mixr.hdrptr<>-1)) then inc(himsg);
  until (lng=himsg);
end;

procedure loadmintab(x:word);
var lng:longint;
    numread:word;
    i,j:integer;
begin
  lng:=x*100;   (* stupid TP typecasting... *)
  while ((lng>=filesize(mixf)) and (x>0)) do begin
    dec(x);
    lng:=x*100;
  end;

  mintaboffset:=x*100;
  seek(mixf,mintaboffset);
  blockread(mixf,mintab,100,numread);
  if (numread<>100) then begin
    for i:=numread to 99 do begin
      mintab[i].messagenum:=0;
      mintab[i].hdrptr:=-1;
      mintab[i].msgid:=memboard.lastmsgid;
      mintab[i].isreplytoid:=0;
      for j:=1 to 6 do mintab[i].msgdate[i]:=0;
      mintab[i].msgdowk:=0;
      mintab[i].msgindexstat:=[];
      mintab[i].isreplyto:=65535;
      mintab[i].numreplys:=0;
    end;
    seek(mixf,mintaboffset);
    blockwrite(mixf,mintab,100);  { fill remainder with garbage .. }
  end;
  mintabloaded:=x;
end;

function allcaps(s:string):string;
var i:integer;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  allcaps:=s;
end;

function caps(s:string):string;
var i:integer;
begin
  for i:=1 to length(s) do
    if (s[i] in ['A'..'Z']) then s[i]:=chr(ord(s[i])+32);
  for i:=1 to length(s) do
    if (not (s[i] in ['A'..'Z','a'..'z',#39])) then
      if (s[i+1] in ['a'..'z']) then s[i+1]:=upcase(s[i+1]);
  s[1]:=upcase(s[1]);
  caps:=s;
end;

procedure initbrd(x:integer);    { x=-1 = e-mail }
var mixr:msgindexrec;
    fn:string;
    lng:longint;
    numread:word;
    i,j,ioerror:integer;
    xx,y,z:byte;
begin
  closebrd;
  if (x=-1) then fn:='EMAIL' else begin
    loadboard(x);
    fn:=memboard.filename;
  end;
  fn:=upper(fn);
  assign(mixf,systat.msgpath+fn+'.MIX');
  SetFileAccess(ReadWrite,DenyAll);
  {$I-} reset(mixf,sizeof(mixr)); {$I+}
  ioerror:=ioresult;
  case ioerror of
    0: ;
    5:begin
        xx:=wherex; y:=wherey; z:=textattr;
        writeln;
        i:=1;
        while (i<10) and (ioerror=5) do begin
          gotoxy(1,wherey);
          tc(14); write('File sharing error.  Retrying: '+int_to_str(i));
          SetFileAccess(ReadWrite,DenyALL);
          {$I-} reset(mixf,sizeof(mixr)); {$I+}
          ioerror:=ioresult;
          delay(250);
          inc(i);
        end;
        gotoxy(1,wherey); clreol;
        if ioerror=5 then begin
          tc(12); write('Unable to open board index, aborting...');
          ferror(allcaps(fn)+'.MIX');
        end;
        gotoxy(xx,y); textattr:=z;
      end;
    else
      begin
        rewrite(mixf,sizeof(mixr));
        for i:=0 to 99 do begin
          mintab[i].messagenum:=0;
          mintab[i].hdrptr:=-1;
          mintab[i].msgid:=memboard.lastmsgid;
          mintab[i].isreplytoid:=0;
          for j:=1 to 6 do mintab[i].msgdate[i]:=0;
          mintab[i].msgdowk:=0;
          mintab[i].msgindexstat:=[];
          mintab[i].isreplyto:=65535;
          mintab[i].numreplys:=0;
        end;
        blockwrite(mixf,mintab[0],100);
      end;
  end;

  assign(brdf,systat.msgpath+fn+'.BRD');
  SetFileAccess(ReadWrite,DenyALL);
  {$I-} reset(brdf,1); {$I+}
  ioerror:=ioresult;
  case ioerror of
    0: ;
    5:begin
        xx:=wherex; y:=wherey; z:=textattr;
        writeln;
        i:=1;
        while (i<10) and (ioerror=5) do begin
          gotoxy(1,wherey);
          tc(14); write('File sharing error.  Retrying: '+int_to_str(i));
          SetFileAccess(ReadWrite,DenyALL);
          {$I-} reset(brdf,1); {$I+}
          ioerror:=ioresult;
          delay(250);
          inc(i);
        end;
        gotoxy(1,wherey); clreol;
        if ioerror=5 then begin
          tc(12); write('Unable to open board file, aborting...');
          ferror(allcaps(fn)+'.BRD');
        end;
        gotoxy(xx,y); textattr:=z;
      end
    else begin
      rewrite(brdf,1); close(brdf);
      SetFileAccess(ReadWrite,DenyALL);
      reset(brdf,1);
    end;
  end;

  findhimsg;
  loadmintab(himintab);
  _brd_opened:=TRUE;
  gotlastmheader:=FALSE;
end;

function getmixnum(x:word):word;
begin
  getmixnum:=x mod 100;
end;

function getmintab(x:word):word;
begin
  getmintab:=x div 100;
end;

procedure savemix(mixr:msgindexrec; x:word);
begin
  loadmintab(getmintab(x));
  seek(mixf,mintaboffset+getmixnum(x));
  blockwrite(mixf,mixr,1);
  loadmintab(getmintab(x));
end;

procedure ensureloaded(x:word);
var i:word;
begin
  i:=getmintab(x);
  if (i<>mintabloaded) then loadmintab(i);
end;

procedure newmix(mixr:msgindexrec);
var lng:longint;
    i,j:integer;
begin
  if ((getmixnum(himsg+1)=0) and (himsg>-1)) then begin
    for i:=0 to 99 do begin
      mintab[i].messagenum:=0;
      mintab[i].hdrptr:=-1;
      mintab[i].msgid:=memboard.lastmsgid;
      mintab[i].isreplytoid:=0;
      for j:=1 to 6 do mintab[i].msgdate[i]:=0;
      mintab[i].msgdowk:=0;
      mintab[i].msgindexstat:=[];
      mintab[i].isreplyto:=65535;
      mintab[i].numreplys:=0;
    end;
    inc(himintab);
    seek(mixf,himintab*100); blockwrite(mixf,mintab[0],100);
  end;
  inc(himsg); savemix(mixr,himsg);
end;

procedure blockwritestr2(var f:file; s:string);
var bb:byte;
begin
  bb:=$FF;
  blockwrite(f,bb,1);
  blockwrite(f,s[0],1);
  blockwrite(f,s[1],ord(s[0]));
end;

procedure blockreadstr2(var f:file; var s:string);
begin
  blockread(f,s[0],1);    { filler-chr }
  if (ord(s[0])<>$FF) then exit;
  blockread(f,s[0],1);
  blockread(f,s[1],ord(s[0]));
end;

procedure loadmhead1(var brdf:file; x:word; var mhead:mheaderrec);
begin
  blockread(brdf,mhead,sizeof(mheaderrec));
end;

{ caller must postition to correct place in brdf .... }
procedure savemhead1(var brdf:file; mhead:mheaderrec);
begin
  blockwrite(brdf,mhead,sizeof(mheaderrec));
end;

procedure savemhead(mhead:mheaderrec);
begin
  savemhead1(brdf,mhead);
end;

procedure loadmhead(x:word; var mhead:mheaderrec);
begin
  ensureloaded(x);
  seek(brdf,mintab[getmixnum(x)].hdrptr);
  loadmhead1(brdf,x,mhead);
end;

procedure getdayofweek(var dow:byte);
var y,m,d,dd:word;
begin
  getdate(y,m,d,dd);
  dow:=dd;
end;

procedure dt2pt(dt:ldatetimerec; var pt:packtime);
begin
  with dt do begin
    pt[1]:=((hour and 31) shl 3)+((min and 56) shr 3);
    pt[2]:=((min and 7) shl 5)+((sec and 62) shr 1);
    pt[3]:=((sec and 1) shl 7)+(sec100 and 127);
  end;
end;

procedure dt2pd(dt:ldatetimerec; var pd:packdate);
begin
  with dt do begin
    pd[1]:=(((year-1800) and 32641) shr 7);
    pd[2]:=(((year-1800) and 127) shl 1)+((month and 8) shr 3);
    pd[3]:=((month and 7) shl 5)+(day and 31);
  end;
end;

procedure dt2pdt(dt:ldatetimerec; var pdt:packdatetime);
var pd:packdate;
    pt:packtime;
begin
  dt2pd(dt,pd); dt2pt(dt,pt);
  pdt[1]:=pd[1]; pdt[2]:=pd[2]; pdt[3]:=pd[3];
  pdt[4]:=pt[1]; pdt[5]:=pt[2]; pdt[6]:=pt[3];
end;

procedure getdatetime(var dt:ldatetimerec);
var dow:word;
begin
  getdate(dt.year,dt.month,dt.day,dow);
  gettime(dt.hour,dt.min,dt.sec,dt.sec100);
end;

procedure getpackdatetime(pdtpp:packdatetimepp);
var dt:ldatetimerec;
begin
  getdatetime(dt);
  dt2pdt(dt,pdtpp^);
end;

(****************************************************************************)
(****************************************************************************)
(* FidoNet Unit Misc. Procedures (Padleft, padright, last, etc.)            *)

Function PadLeft(Str:string;Size:byte;Pad:char):string;
var temp : string;
begin
    Fillchar(Temp[1],Size,Pad);
    Temp[0] := chr(Size);
    If Length(Str) <= Size then
       Move(Str[1],Temp[1],length(Str))
    else
       Move(Str[1],Temp[1],size);
    PadLeft := Temp;
end;

Function PadRight(Str:string;Size:byte;Pad:char):string;
var
  temp : string;
  L : integer;
begin
    Fillchar(Temp[1],Size,Pad);
    Temp[0] := chr(Size);
    L := length(Str);
    If L <= Size then
       Move(Str[1],Temp[succ(Size - L)],L)
    else
       Move(Str[1],Temp[1],size);
    PadRight := Temp;
end;

Function Last(N:byte;Str:string):string;
var Temp : string;
begin
    If N > length(Str) then
       Temp := Str
    else
       Temp := copy(Str,succ(length(Str) - N),N);
    Last := Temp;
end;  {Func Last}

Function First(N:byte;Str:string):string;
var Temp : string;
begin
    If N > length(Str) then
       Temp := Str
    else
       Temp := copy(Str,1,N);
    First := Temp;
end;  {Func First}

(****************************************************************************)
(****************************************************************************)
(* Fidonet unit procedures (msgdatestamp, netmessage, etc.)                 *)

Function MsgDateStamp : String;  { Creates Fido standard- 01 Jan 89 21:05:18 }
Var h,m,s,hs          : Word;    { Standard message header time/date stamp   }
    y,mo,d,dow        : Word;
    Tmp,
    o1,o2,o3          : String;

Begin
  o1 := '';
  o2 := '';
  o3 := '';
  tmp := '';
  GetDate(y,mo,d,dow);
  GetTime(h,m,s,hs);
  o1 := PadRight(Int_To_Str(d),2,'0');
  o2 := Status[mo];
  o3 := Last(2,Int_To_Str(y));
  Tmp := Concat( o1,' ',o2,' ',o3,'  ');
  o1 := PadRight(Int_To_Str(h),2,'0');
  o2 := PadRight(Int_To_Str(m),2,'0');
  o3 := PadRight(Int_To_Str(s),2,'0');
  Tmp := Tmp + Concat(o1,':',o2,':',o3);
  MsgDateStamp := Tmp;
End;

Function NetMessage : String;   { Returns a NetMessage header string }
Var Hdr : String;
Begin
  Hdr := '';
  Hdr := PadLeft(Net.From,36,#0);
  Hdr := Hdr + PadLeft(Net.Too,36,#0)
             + PadLeft(Net.Subject,72,#0)
             + PadRight(Net.Date,19,' ')+#0
             + Chr(Lo(Net.TimesRead))+Chr(Hi(Net.TimesRead))
             + Chr(Lo(Net.DestNode))+Chr(Hi(Net.DestNode))
             + Chr(Lo(Net.OrigNode))+Chr(Hi(Net.OrigNode))
             + Chr(Lo(Net.Cost))+Chr(Hi(Net.Cost))
             + Chr(Lo(Net.OrigNet))+Chr(Hi(Net.OrigNet))
             + Chr(Lo(Net.DestNet))+Chr(Hi(Net.DestNet))
             + #0#0#0#0#0#0#0#0
             + Chr(Lo(Net.ReplyTo))+Chr(Hi(Net.ReplyTo))
             + Chr(Lo(Net.Attr))+Chr(Hi(Net.Attr))
             + Chr(Lo(Net.NextReply))+Chr(Hi(Net.NextReply))
             + Upper(Net.AreaName);
  Hdr[0]:=Chr(190);
  NetMessage := Hdr;
End;

Function MsgToNum( Fnm : String ) : Integer; { Used Internally by LastMsgNum }
Var p : Byte;
Begin
  p        := Pos('.',Fnm);
  Fnm      := First(p-1,Fnm);
  MsgToNum := Str_To_Int(Fnm);
End;

Function LastMsgNum( _NetPath : String ) : Integer;
         { Returns the highest numbered xxx.MSG in NetPath directory }
Var
    _Path   : String;
    Temp1,
    Temp2   : String;
    Len     : Byte;
    DxirInf  : SearchRec;
    Num,
    Num1    : Integer;
Begin
  Num   := 0;
  Num1  := 0;
  Temp1 := '';
  Temp2 := '';
  _Path := '';
  _Path := _NetPath + '\*.MSG';

  FindFirst( _Path, Archive, DxirInf );
  While DosError = 0 DO
  Begin
    Temp1 := DxirInf.Name;
    Num1 := MsgToNum(Temp1);
    IF Num1 > Num Then Num := Num1;
    FindNext(DxirInf);
  End;

  IF Num = 0 Then Num := 1;
  LastMsgNum := Num;
End;

(****************************************************************************)
(****************************************************************************)
(* More I_Echo functions (dat, writelog, readtwits, etc.)                   *)

function dat:string;
const mon:array [1..12] of string[3] =
          ('Jan','Feb','Mar','Apr','May','Jun',
           'Jul','Aug','Sep','Oct','Nov','Dec');
var x,y:string; i:integer;
    year,month,day,dayofweek:word;
begin
  getdate(year,month,day,dayofweek);
  dat:=copy('SunMonTueWedThuFriSat',dayofweek*3+1,3)+' '+
       int_to_str(day)+' '+mon[month]+' '+copy(int_to_str(year),3,2)+', I_ECHO';
end;

function tch(s:string):string;
begin
  if (length(s)>2) then s:=copy(s,length(s)-1,2) else
    if (length(s)=1) then s:='0'+s;
  tch:=s;
end;

function time:string;
var h,m,s:string[3];
    hh,mm,ss,ss100:word;
begin
  gettime(hh,mm,ss,ss100);
  str(hh,h); str(mm,m); str(ss,s);
  time:=tch(h)+':'+tch(m)+':'+tch(s);
end;

procedure writelog(sign:char; s:string);
Var logf:text;
Begin
  if ((keeplog) and (fidor.logname<>'')) then begin
    assign(logf,fidor.logname);
    {$I-} append(logf); {$I+}
    if ioresult<>0 then begin
      rewrite(logf);
      append(logf);
    end;
    if (not wroteloghead) then begin
      Writeln(logf,'');
      Writeln(logf,'----------  '+dat);
    end;
    wroteloghead:=TRUE;
    Writeln(logf,sign+' '+time+'  '+s);
    close(logf);
  end;
End;

procedure readtwits;
begin
assign(iechodatf,getenv('IBBS')+'\IE_TWIT.DAT');
SetFileAccess(ReadOnly,DenyNone);
{$I-} reset(iechodatf); {$I+}
if ioresult=0 then begin
  read(iechodatf,twitr);
  close(iechodatf);
end else begin
  tc(3);
  writeln('   *** Unable to open '+upper(getenv('IBBS'))+'\IE_TWIT.DAT');
  writelog('?','Unable to open '+upper(getenv('IBBS'))+'\IE_TWIT.DAT');
  deltwit:=FALSE;
end;
end;

function stripthings(nn:string):string;
var p:integer;
    q:char;
    ls:string;

   function centre(s:string):string;
   var i,j:integer;
   begin
     i:=length(s); j:=1;
     while (j<=length(s)) do begin
       if (s[j]='|') and (isc(s[j+1])) then begin
         dec(i,2);
         inc(j);
       end;
       inc(j);
     end;
     if i<79 then
       s:=copy('                                               ',1,
         (79-i) div 2)+s;
     centre:=s;
   end;

begin
  if (mbnocolor in memboard.mbstat) then nn:=stripcolor(nn);
  if (mbstrip in memboard.mbstat) then begin
     if (copy(nn,1,3)='`#[') then nn:=centre(copy(nn,4,length(nn))) else
     if (nn[1]=#2) then nn:=centre(copy(nn,2,length(nn)));
  end;
  ls:='';
  for p:=1 to length(nn) do begin
    q:=nn[p];
    if (mbfilter in memboard.mbstat) then
      if (q in [#2..#9,#11..#12,#14..#31,#127..#255]) then q:='*';
    if not(q in [#0..#1,#10,#13,#141]) then
     ls:=ls+q;
  end;
  stripthings:=ls;
end;

(****************************************************************************)
(****************************************************************************)
(* Scan Procedure : Scans each board for message and converts to *.MSG      *)

Procedure scan;
Var i,howmany,totload,lastone,x:integer;
    Msgfil:text;
    attrib:word;
    Header,msg_name,s:string;

Begin
Board:=-1; howmany:=0;
tc(3); writeln('   Scanning for outbound messages . . .');

Repeat {Set up to loop each base}
  { Search for Echomail board, and load it in }
  Repeat
    inc(board); loadboard(board);
  until ((memboard.mbtype=1) or (eof(bf)));

  if memboard.mbtype=1 then begin

  gotoxy(1,wherey); tc(11);
  write('   '+stripcolor(memboard.name)+' #'+int_to_str(board));
  clreol;


  tc(3); Write('- Message: '); x:=wherex; tc(14); write('(None)');
  Initbrd(board);

  if not(ignorehiwater) then begin
    assign(hiwaterf,memboard.msgpath+'Hi-WATER.MRK');
    SetFileAccess(ReadOnly,DenyWrite);
    {$I-} reset(hiwaterf); {$I+}
    if (ioresult=0) then begin
      seek(hiwaterf,0); read(hiwaterf,hiwaterr);
      close(hiwaterf);
    end else hiwaterr.hi:=1;
  end else hiwaterr.hi:=1;

  i:=0; {Msg counter} lastone:=lastmsgnum(memboard.msgpath); { Last message }
  if lastone<hiwaterr.hi then lastone:=hiwaterr.hi;

  While (i<=himsg) do begin { Loop through each msg }
    ensureloaded(i); { Make sure 'I' is in the mintab }
    mixr:=mintab[getmixnum(i)]; { Load up the mix }

    if ({(not (miscanned in mixr.msgindexstat)) and}
        (not (mideleted in mixr.msgindexstat)) and
        (not (miunvalidated in mixr.msgindexstat))) then begin

     gotoxy(x,wherey); write(int_to_str(lastone)); clreol;
     { Mark the msg as scanned/outbound }
     include(mixr.msgindexstat,miscanned);
     savemix(mixr,i);
     Loadmhead(i,mhead); {Load in the mheader);
       Header:='';  {Set the echomail header to null}
       Msg_Name:=''; {No name for *.MSG file!}
       Attrib:=_Local; {Local so it's picked up by gecho}

       With Net do begin
          if (mbrealname in memboard.mbstat) then begin
            From      := caps(mhead.fromi.real);
            if (mhead.toi.real='') then Too:='All' else
            Too       := caps(mhead.toi.real);
          end else begin
            From      := caps(mhead.fromi.alias);
            if (mhead.toi.alias='') then Too:='All' else
            Too       := caps(mhead.toi.alias);
          end;
          Subject   := mhead.title;
          Date      := MsgDateStamp;
          TimesRead := 0;
          DestNode  := 0;
          if memboard.zone<>0 then begin
            OrigNode  := memboard.Node;
            Cost      := 0;
            OrigNet   := memboard.Net;
          end else begin
            OrigNode  := fidor.node;
            Cost      := 0;
            OrigNet   := fidor.net;
          end;
          DestNet   := 0;
          ReplyTo   := 0;
          Attr      := attrib;
          NextReply := 0;
       End;
       Net.AreaName:=#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0;
       Header := NetMessage;

       Inc(lastone); { Start another *.MSG }
       Msg_name:=memboard.msgpath+'\'+int_to_str(lastone)+'.MSG';
       Assign(msgfil,msg_name);
       rewrite(msgfil);
       Writeln(msgfil,header);
       writeln(msgfil,#1+'PID: I_ECHO '+ver);

       seek(brdf,mhead.msgptr); {Find the msg}
       totload:=0;
       repeat
         blockreadstr2(brdf,s);
         inc(totload,length(s)+2);
         if (totload<mhead.msglength) then writeln(msgfil,stripthings(s));
       until (totload>=mhead.msglength);
       write(msgfil,stripcolor(s)+#32#0);
       flush(msgfil); close(msgfil);
       inc(howmany);

    end; {End if}
    inc(i); {Next msg}
  end; {While loop}

  if not(ignorehiwater) then begin
    with hiwaterr do begin
      note:='I_Echo '+ver+' : Scan Mark, Ignore.  ';
      hi:=lastmsgnum(memboard.msgpath);
    end; {with}
    rewrite(hiwaterf); seek(hiwaterf,0); write(hiwaterf,hiwaterr);
    close(hiwaterf);
  end; {if not(ignorehiwater)}

  end; {if}
until(eof(bf)); {Until the last base is processed}

gotoxy(1,wherey);
tc(3); write('   Outbound - ['); tc(14); write(howmany); tc(3);
write('] : Echo '); clreol; writeln;
writelog('#','Outbound - ['+int_to_str(howmany)+'] : Echo ');
if ( ((howmany>0) or (forcescan)) and (rundos)) then exec(getenv('COMSPEC'),'/c'+fidor.echoscan);
end;

(****************************************************************************)
(****************************************************************************)
(* Toss Procedure : Scans each dir and tosses *.msg into boards             *)
Procedure toss;
Label Skip;
var i,totload,howmany,tfound,ps,cv,x:integer;
    ii,j,k:word;
    Msg_name,s,ss,wrap:string;
    Msgfil:text;
    Done:Boolean;
    lng:longint;

function istwit:boolean;
Var cnt:byte; ck:string; b:boolean;
begin
  b:=FALSE;
  for cnt:=1 to twitr.entries do begin
    if (upper(twitr.twits[cnt].base)='*ALL*') or
       (Str_to_int(twitr.twits[cnt].base)=board) then
    with twitr.twits[cnt],mhead do begin
      ck:=upper(name);
      case field of
        1:if (partcomp) then b:=(pos(ck,upper(fromi.as))<>0) else
          b:=(ck=upper(fromi.as));
        2:if (partcomp) then b:=(pos(ck,upper(toi.as  ))<>0) else
          b:=(ck=upper(toi.as  ));
        3:if (partcomp) then b:=((pos(ck,upper(fromi.as))<>0) or
                                     (pos(ck,upper(toi.as  ))<>0)) else
          b:=((ck=upper(fromi.as)) or (ck=upper(toi.as)));
      end; {case};
    end; {with}
    if b then begin
      istwit:=TRUE;
      exit;
    end;
  end; {for}
  istwit:=FALSE;
end;


Begin
Board:=-1; howmany:=0; tfound:=0;
if (rundos) then Exec(getenv('COMSPEC'),'/c'+fidor.echotoss);
tc(3); writeln('   Scanning for inbound messages . . .');
if deltwit then writeln('   *** Using Twit Filter');

Repeat { Loop through all the boards }
  repeat
    inc(board); loadboard(board);
  until memboard.mbtype=1;

  if memboard.mbtype=1 then begin

  gotoxy(1,wherey); tc(11);
  write('   '+stripcolor(memboard.name)+' #'+int_to_str(board));
  clreol;

  tc(3); write(' - Message: '); x:=wherex; tc(14); write('(None)');
  initbrd(board);

  if not(ignorehiwater) then begin
    assign(hiwaterf,memboard.msgpath+'HI-WATER.MRK');
    SetFileAccess(ReadOnly,DenyWrite);
    {$I-} reset(hiwaterf); {$I+}
    if (ioresult=0) then begin
      seek(hiwaterf,0); read(hiwaterf,hiwaterr);
      close(hiwaterf);
    end else hiwaterr.hi:=1;
  end else hiwaterr.hi:=1;

  if hiwaterr.hi<1 then hiwaterr.hi:=1;
  Done:=FALSE;
  While (not done) do begin { Keep going until no more msgs }
    repeat
      done:=FALSE;
      inc(hiwaterr.hi); { Next *.msg }
      msg_name:=int_to_str(hiwaterr.hi)+'.MSG';
      assign(msgfil,memboard.msgpath+msg_name);
      {$I-} reset(msgfil); {$I+}
      if ioresult<>0 then done:=TRUE;
    until (not done) or (hiwaterr.hi>lastmsgnum(memboard.msgpath));

    If (not done) then begin
      gotoxy(x,wherey); write(int_to_str(hiwaterr.hi)); clreol;
      inc(howmany);

      s:=''; ps:=0;                (* Read the header into S *)
      repeat
        repeat
          inc(ps); read(msgfil,s[ps]);
        until ((s[ps]=^M) or (ps=190));
        if s[ps]=^M then begin
          readln(msgfil); dec(ps);
        end;
      until (ps=190);
      s[0]:=chr(165);

      with mhead do begin
        signature:=$FFFFFFFF;
        title:=ridspace(copy(s,73,72));
        datetime:=copy(s,145,20);
        with fromi do begin
          anon:=0;
          usernum:=0;
          ss:=upper(ridspace(copy(s,1,36)));
          as:=ss;
          real:=ss;
          alias:=ss;
        end;
        with toi do begin
          anon:=0;
          usernum:=0;
          ss:=upper(ridspace(copy(s,37,36)));
          as:=ss;
          real:=ss;
          alias:=ss;
        end;
        fusernote:='None (Echomail)';
      end;

      if (deltwit) and (not(mbnotwit in memboard.mbstat)) then
      if istwit then begin
        dec(howmany);
        inc(tfound);
        goto skip;        (* Skip rest of processing *)
      end;

      newmix(mixr);
      if (himsg<>65535) then begin
        j:=0;
        for ii:=0 to himsg do begin
          ensureloaded(ii);
          k:=mintab[getmixnum(ii)].messagenum;
          if (k>j) then j:=k;
        end;
        mixr.messagenum:=j+1;
      end;
      with mixr do begin
        hdrptr:=filesize(brdf);
        isreplytoid:=0;
        isreplyto:=65535;
        numreplys:=0;
        getpackdatetime(@msgdate);
        getdayofweek(msgdowk);
        msgid:=memboard.lastmsgid;
        inc(memboard.lastmsgid);
        exclude(msgindexstat,mideleted);
        exclude(msgindexstat,miunvalidated);
        exclude(msgindexstat,mipermanent);
        include(msgindexstat,miscanned);
      end;
      SetFileAccess(ReadWrite,DenyNone);
      reset(bf);
      ii:=board;
      if ((ii-1<0) or (ii-1>filesize(bf)-1)) then ii:=1;
      seek(bf,ii-1);
      write(bf,memboard);
      findhimsg; ensureloaded(himsg);
      savemix(mixr,himsg);

      mhead.msglength:=0;
      lng:=filesize(brdf);
      seek(brdf,lng);
      mhead.msgptr:=lng+sizeof(mheaderrec);
      savemhead(mhead);

      wrap:='';
      while (not eof(msgfil)) do begin
        if wrap<>'' then s:=wrap else s:='';
        ps:=length(s);
        wrap:='';
        repeat
          inc(ps);
          read(msgfil,s[ps]);
        until ((s[ps]=^M) or (ps=79) or (eof(msgfil)));
        s[0]:=chr(ps);
        if s[ps]<>^M then begin
          cv:=ps;
          while (cv>0) and (s[cv]<>' ') do dec(cv);
          if (cv>(ps div 2)) and (cv<>ps) then begin
            wrap:=copy(s,cv+1,ps-cv);
            s[0]:=chr(cv-1);
          end;
        end;
        if (pos(#1,s)>5) or (pos(#1,s)=0) then begin
          s:=stripthings(s);
          blockwritestr2(brdf,s);
          inc(mhead.msglength,length(s)+2);
        end; {if}
      end; {while}

      seek(brdf,lng); savemhead(mhead);
Skip:
      close(msgfil);

    end; { (if) finished with this *.msg }
  end; { (while) finished with this base }

  closebrd;
  if not(ignorehiwater) then begin
    hiwaterr.note:='I_Echo '+ver+' : Scan Mark, Ignore.  ';
    dec(hiwaterr.hi);
    rewrite(hiwaterf); seek(hiwaterf,0); write(hiwaterf,hiwaterr);
    close(hiwaterf);
  end; {if not(ignorehiwater)}

  end; {if}
until eof(bf);
gotoxy(1,wherey);
tc(3); write('   Inbound - ['); tc(14); write(howmany); tc(3);
write('] : Echo'); clreol; writeln;
if tfound>0 then writeln('   *** '+int_to_str(tfound)+' "twit" messages not tossed');
if deltwit then writelog('#','Inbound - ['+int_to_str(howmany)+'] : Echo'+
                          '  "Twit" Msgs - ['+int_to_str(tfound)+']')
else writelog('#','Inbound - ['+int_to_str(howmany)+'] : Echo');
end;

(****************************************************************************)
(****************************************************************************)
(* Reset_hiwater procedure : reset hiwater marks in all dirs                *)
procedure reset_hiwater;
begin
  board:=-1;
  tc(3); writeln('   Resetting HiWater marks . . .');
  repeat
    repeat
      inc(board); loadboard(board);
    until ((memboard.mbtype=1) or (eof(bf)));

    if memboard.mbtype=1 then begin
    gotoxy(1,wherey); tc(11);
    write('   '+stripcolor(memboard.name)+' #'+int_to_str(board));
    clreol;

    assign(hiwaterf,memboard.msgpath+'HI-WATER.MRK');
    rewrite(hiwaterf);
    with hiwaterr do begin
      note:='I_Echo '+ver+' : Scan Mark, Ignore.  ';
      hi:=lastmsgnum(memboard.msgpath);
    end;
    seek(hiwaterf,0); write(hiwaterf,hiwaterr); close(hiwaterf);
    end; {if}
  until(eof(bf));
  gotoxy(1,wherey); clreol;
end;

(****************************************************************************)
(****************************************************************************)
(* Purge Procedure : purges all messages except 1.msg and resets hiwaters   *)
procedure purge;
var m:text; s:string; ps:integer;

procedure purgedir(s:astr);              {* erase all non-dir files in dir *}
  function exdrv(s:string):byte;
  begin
    s:=fexpand(s);
    exdrv:=ord(s[1])-64;
  end;

var odir,odir2:astr;
    dirinfo:searchrec;
    f:file;
    att:word;
begin
  s:=fexpand(s);
  while copy(s,length(s),1)='\' do s:=copy(s,1,length(s)-1);
  getdir(0,odir); getdir(exdrv(s),odir2);
  chdir(s);
  findfirst('*.MSG',AnyFile-Directory,dirinfo);
  while (doserror=0) do begin
    if (upper(dirinfo.name)<>'1.MSG') then begin
    assign(f,fexpand(dirinfo.name));
    setfattr(f,$00);           {* remove possible read-only, etc, attributes *}
    {$I-} erase(f); {$I+}      {* erase the $*@( file !!     *}
    end;
    findnext(dirinfo);         {* move on to the next one... *}
  end;
  chdir(odir2); chdir(odir);
end;

begin
board:=-1;
tc(3); writeln('   Purging old messages & resetting 1.MSG . . .');
repeat

repeat
  inc(board); loadboard(board);
until ((memboard.mbtype=1) or (eof(bf)));

if memboard.mbtype=1 then begin
gotoxy(1,wherey); tc(11);
write('   '+stripcolor(memboard.name)+' #'+int_to_str(board));
clreol;
purgedir(memboard.msgpath);
assign(m,memboard.msgpath+'1.MSG');
    {$I-} reset(m); {$I+}
    if ioresult=0 then begin
    s:='';                       (* Read the header into S *)
    for ps:=1 to 190 do begin    (*                        *)
      read(m,s[ps]);             (*                        *)
    end;                         (*                        *)
    s[0]:=chr(190);              (*                        *)
    close(m);
    s[184]:=chr(lo(1));
    s[185]:=chr(hi(1));
    rewrite(m);
    writeln(m,s);
    close(m);
    end;
end; {if}
until(eof(bf));
gotoxy(1,wherey); clreol;
reset_hiwater;
end;

(***************************************************************************)
(***************************************************************************)
(* Run post-processing command                                             *)
procedure alldone;
begin
  if ((rundos) and (fidor.postproccmd<>'')) then begin
    tc(3); writeln('   Running post-processing command. . .');
    Exec(getenv('COMSPEC'),'/c'+fidor.postproccmd);
    writelog('#','Ran "'+fidor.postproccmd+'"');
  end;
end;

(***************************************************************************)
(***************************************************************************)

procedure getparams;
var ss:string; a:integer;
begin

a:=0;
while (a<paramcount) do begin
  inc(a);
  ss:=upper(paramstr(a));
  if (ss[1]='-') or (ss[1]='/') then
    case ss[2] of
      'B':directvideo:=FALSE;
      'S':rundos:=FALSE;
      'F':Forcescan:=TRUE;
      'L':keeplog:=FALSE;
      'X':ignorehiwater:=TRUE;
      'D':begin
            deltwit:=TRUE;
            readtwits;
          end;
    else optionerror:=TRUE;
    end; {case}
end; {while}

ss:=upper(paramstr(1));

if paramstr(2)='?' then begin
  if ss='SCAN'  then begin
    tc(11); Writeln('   SCAN function');   tc(3);
    writeln;
    writeln('   Scans  the Illusion  message files  (BRD & MIX)  for');
    writeln('   "unsent"  messages,  and creates *.MSG files  in the');
    writeln('   message directories (to be further processed by your');
    writeln('   post-processor.  I_ECHO will then automatically  run');
    writeln('   your post-processor.');
  end

  else if ss='TOSS'  then begin
    tc(11); Writeln('   TOSS function');   tc(3);
    writeln;
    writeln('   Takes messages  stored in the message  directories  and');
    writeln('   adds them to Illusion''s message base files (BRD & MIX).');
    writeln('   This is done after I_ECHO runs your pre-processor which');
    writeln('   unpacks  the  messages  from  their  compressed   form.');
    writeln('   Certain control codes will be stripped,  and high ascii');
    writeln('   will be stripped only  if the base if flagged to do so.');
  end

  else if ss='PURGE' then begin
    tc(11); Writeln('   PURGE function');  tc(3);
    writeln;
    writeln('   Removes  all *.MSG files from the message  directories');
    writeln('   and  resets  the high-water  marks.   Make  sure  your');
    writeln('   messages have already been scanned by your processors!');
  end

  else if ss='ALL'   then begin
    tc(11); Writeln('   ALL command');     tc(3);
    writeln;
    writeln('   Performs the TOSS, SCAN, and PURGE functions in one');
    writeln('   shot.  Make sure the network configuration is setup');
    writeln('   with  the  commands  for your  pre/post-processors!');
    writeln('   If a post-processing command is defined, it will be');
    writeln('   run last.');
  end

  else if ss='RESET' then begin
    tc(11); Writeln('   RESET function');  tc(3);
    writeln;
    writeln('   Resets the high-water marks of  each  base  to the');
    writeln('   highest message found  in the message directories.');
    writeln('   This is automatically done  by TOSS, SCAN, & PURGE');
    writeln('   and is not normally needed.  Use with care (you may');
    writeln('   lose messages!).');
  end

  else if ss='OPTIONS' then begin
    tc(11); Writeln('   OPTIONS function'); tc(3);
    Writeln;
    writeln('   Use OPTIONS alone without a "?" to get a list of');
    writeln('   options.');
  end else exit;

  writeln;
  writeln('   Refer to the documentation for more help.');
  tc(7);
  exit;
end;


if ss='SCAN'  then scan  else
if ss='TOSS'  then toss  else
if ss='PURGE' then purge else
if ss='ALL'   then begin
        toss;
        scan;
        purge;
        alldone;
end else
if ss='RESET' then reset_hiwater else
if ss='OPTIONS' then begin
 tc(11); writeln('   I_ECHO Options');
       writeln;
 tc(11); write('   -B'); tc(3); writeln(' : Use BIOS for video output instead of direct video writes');
 tc(11); write('   -S'); tc(3); writeln(' : Don''t run pre/post-processor');
 tc(11); write('   -F'); tc(3); writeln(' : Run post-processor even if no mail is found.');
                           writeln('        Does not override "-S"');
 tc(11); write('   -L'); tc(3); writeln(' : Don''t keep log file');
 tc(11); write('   -X'); tc(3); writeln(' : Ignore hi-water marks');
 tc(11); write('   -D'); tc(3); writeln(' : Delete "Twits"');
       writeln;
       writeln('   All options must have either a "-" or "/" preceding them.');
       writeln('   Options must always come after functions (SCAN, TOSS, etc.)');
       writeln;
       writeln('   Refer to the documentation for more help.');
end else
if ss='FUNCTIONS' then begin
  tc(11); writeln('   I_ECHO Functions'); writeln;
  write('   TOSS   '); tc(3);
  writeln(' : Toss inbound messages into message bases.  '); tc(11);
  write('   SCAN   '); tc(3);
  writeln(' : Scan bases for outbound messages.          '); tc(11);
  write('   PURGE  '); tc(3);
  writeln(' : Remove all messages in holding directories.'); tc(11);
  write('   RESET  '); tc(3);
  writeln(' : Reset Hi-water marks to highest message.   '); tc(11);
  write('   ALL    '); tc(3);
  writeln(' : Combines TOSS, SCAN, PURGE, and RESET Functions.  '); tc(11);
  Write('   OPTIONS'); tc(3);
  writeln(' : List I_ECHO Options');
  writeln;
  Writeln('   Use a "?" as a second parameter for more help');
  Writeln('   Example: I_ECHO TOSS ? ');
end else

if ss='' then begin
  tc(3);
  write('   Syntax:'); tc(11); writeln(' I_ECHO [function] <?> <options>');
  writeln;
  tc(3);
  write('   For more help on functions, type  '); tc(11); writeln('I_ECHO FUNCTIONS');
  tc(3);
  write('   For more help on options, type    '); tc(11); writeln('I_ECHO OPTIONS');
  tc(3);
  writeln;
  writeln('   Refer to the documentation for more help.');
  tc(7);
end else optionerror:=TRUE;
end;

Procedure errorhandle;
begin
  exitproc:=exitsave;
  if (erroraddr<>nil) then begin
    writeln;
    tc(14); Writeln('   A critical run-time error has occured.  (#'+int_to_str(exitcode)+')');
    tc(3);  Writeln('   I_Echo halted with errorlevel 1.');
    halt(1);
  end;
end;

BEGIN
  exitsave:=exitproc;
  exitproc:=@errorhandle;

  dotitle;
  FillChar(Net,SizeOf(Net),#0);
  readsystat; openboardsdat; readfidor;

  getparams;

  writeln; tc(3);
  if optionerror then writeln('   *** Incorrect parameters specified.');
  writeln('   I_Echo exiting with errorlevel 0');
  halt(0);
END.
