(*****************************************************************************)
(* Illusion BBS - Overlay initialization routines                            *)
(*****************************************************************************)

{$A+,B-,E-,F+,I+,N-,O-,R-,S-,V-}

{$IFDEF DBUG}
  {$D+,L+}
{$ELSE}
  {$D-,L-}
{$ENDIF}

unit ovrstart;

interface

uses
  crt, dos
  {$IFNDEF OS2} ,overlay {$ENDIF} ;

implementation

uses common;

Const OvrMaxSize = 16384;

var systatf:file of systatrec;

{$L OVERXMS.OBJ}
procedure ovrinitxms; external;

begin
  getdir(0,start_dir);
  assign(systatf,start_dir+'\ILLUSION.CFG');
  SetFileAccess(ReadOnly,DenyNone);
  {$I-} reset(systatf); {$I+}
  if (ioresult<>0) then
  begin
    writeln;
    writeln('Unable to open the ILLUSION.CFG data file. This file is');
    writeln('REQUIRED to even load Illusion.');
    writeln('Check the following:');
    writeln;
    writeln(' You "initialized" Illusion with the INIT program before');
    writeln('  running it.');
    writeln(' ILLUSION.CFG is not missing or corrupt. (If it is, recreate');
    writeln('  it with the INIT program.)');
    writeln;
    if (exiterrors<>-1) then halt(exiterrors) else halt(254);
  end else
  begin
    {$I-} read(systatf,systat); {$I+}
    close(systatf);
  end;

{$IFNDEF OS2}
  ovrinit('ILLUSION.OVR');
  if (ovrresult<>ovrok) then
  begin
    writeln;
    writeln('Critical error: Overlay manager error.');
    writeln('Check the following:');
    writeln;
    writeln(' ILLUSION.OVR is in the current directory.');
    writeln(' The overlay has not been damaged by an external source.');
    writeln;
    if (exiterrors<>-1) then halt(exiterrors) else halt(254);
  end;
  if (systat.putovr=1) then begin
    ovrinitems;
    if (ovrresult=ovrok) then whereisoverlay:=1;
  end;
  if (systat.putovr=2) then begin
    ovrinitxms;
    if (ovrresult=ovrok) then whereisoverlay:=2;
  end;
  ovrsetbuf(ovrgetbuf+ovrmaxsize);
  if ovrresult<>ovrok then ovrsetbuf(ovrgetbuf+(ovrmaxsize div 2));
{$ENDIF}
end.
