(*****************************************************************************)
(* Illusion BBS - File routines  [10/15] (file manager and validate files)   *)
(*****************************************************************************)

{$A+,B-,E-,F+,I+,N-,O+,R-,S-,V-}

{$IFDEF DBUG}
  {$D+,L+}
{$ELSE}
  {$D-,L-}
{$ENDIF}

unit file10;

interface

uses
  crt,dos,
  myio,
  file0, file1, file2, file9, file4, common, sysop4;

procedure editfiles(curfile:longint);
procedure validatefiles;

implementation

uses
  miscx;

procedure creditfile(var u:userrec; un:integer; var f:ulfrec; credit:boolean);
var rfpts:real;
    gotpts:longint;
begin
  if (not systat.fileptratio) then
    gotpts:=0
  else begin
    rfpts:=(f.blocks/8)/systat.fileptcompbasesize;
    gotpts:=round(rfpts*systat.fileptcomp);
    if (gotpts<1) then gotpts:=1;
  end;
  if (credit) then
    sprompt('|YAwarding upload credits: ')
  else
    sprompt('|YTaking away upload credits: ');
  prompt('1 file, '+cstrl(f.blocks div 8)+'k');
  if (credit) then begin
    inc(u.uploads);
    inc(u.uk,f.blocks div 8);
  end else begin
    dec(u.uploads);
    dec(u.uk,f.blocks div 8);
  end;
  if (systat.fileptratio) then begin
    prompt(', '+cstrl(gotpts)+' file points');
    if (credit) then
      inc(u.filepoints,gotpts)
    else
      dec(u.filepoints,gotpts);
  end;
  print('.');
  saveurec(u,un);
  if (un=usernum) then showudstats;
end;

procedure editfiles(curfile:longint);  {-1 if none}
var u:userrec;        f:ulfrec;           v:verbrec;
    c:char;           li:longint;         ff:file;
    r:real;           dt:datetimerec;     convtime:real;
    s,fl,s1,s2:astr;
    x,oldfileboard,dbn,pl:integer;
    ok,convt,done,espace,nospace:boolean;
    t:text;
begin
  fiscan(pl);
  if (filesize(ulff)=0) then
  begin
    print('No files exist.');
    close(ulff);
    exit;
  end;
  if (curfile=-1) then curfile:=0;
  cls;
  c:=#0;
  assign(verbf,systat.datapath+'VERBOSE.DAT');
  repeat
    seek(ulff,curfile);
    read(ulff,f);
    if (f.vpointer<>-1) then
    begin
      setfileaccess(readwrite,denynone);
      reset(verbf);
      seek(verbf,f.vpointer);
      read(verbf,v);
      x:=1;
      while (x<=9) and (v.descr[x]<>'') do inc(x);
      if (x<10) then for li:=x to 9 do v.descr[li]:='';
      seek(verbf,f.vpointer);
      write(verbf,v);
      close(verbf);
    end else
      fillchar(v,sizeof(v),#0);
    with f do
    begin
      if (c in [#0,^M,'[',']','D','M','E']) then
      begin
        ansig(1,1);
        sprint('|WFile Manager ['+cstr(curfile)+'/'+cstr(filesize(ulff)-1)+']|LC');
        nl;
        sprint('|K[|C1|K] |cFilename          |w'+mlnnomci(filename,18)+' '+mlnnomci(description,38)+'|LC');
        li:=blocks; li:=li*128;
        sprint('|K[|C2|K] |cFilesize          |w'+mn(li,18)+' '+mlnnomci(v.descr[1],38)+'|LC');
        r:=rte*blocks; r2dt(r,dt);
        sprint('|K[|C3|K] |cUploader          |w'+mlnnomci(caps(stowner),18)+' '+mlnnomci(v.descr[2],38)+'|LC');
        sprint('|K[|C4|K] |cUploader user #   |w'+mn(owner,18)+' '+mlnnomci(v.descr[3],38)+'|LC');
        sprint('|K[|C5|K] |cDate uploaded     |w'+mln(date,18)+' '+mlnnomci(v.descr[4],38)+'|LC');
        sprint('|K[|C6|K] |cTimes downloaded  |w'+mn(nacc,18)+' '+mlnnomci(v.descr[5],38)+'|LC');
        sprint('|K[|C7|K] |cFile points       |w'+mn(filepoints,18)+' '+mlnnomci(v.descr[6],38)+'|LC');
        sprint('|K[|C8|K] |cValidated file    |w'+mln(syn(not (notval in filestat)),18)+' '+
                                                  mlnnomci(v.descr[7],38)+'|LC');
        sprint('|K[|C9|K] |cResume flag       |w'+mln(syn(resumelater in filestat),18)+' '+
                                                  mlnnomci(v.descr[8],38)+'|LC');
        sprint('|K[|C0|K] |cOffline file      |w'+mln(syn(isrequest in filestat),18)+' '+
                                                  mlnnomci(v.descr[9],38)+'|LC');
        nl;
        sprint('|K[|CD|K] |cDelete file|LC');
        sprint('|K[|CE|K] |cEdit description');
        sprint('|K[|CI|K] |cImport file description and update comment');
        sprint('|K[|CM|K] |cMove file');
        sprint('|K[|CW|K] |cWithdraw credit');
        nl;
        sprompt('|wCommand |K[|C[|K/|C]|K/|CQ|c:uit|K] |W');
      end;
      ansig(21,20);
      sprompt(#32+^H+'|W');
      onek(c,'Q1234567890IDEMW[]'^M);
      case c of
        '1':begin
              s:=filename;
              inputxy(23,3,s,-12);
              if (s<>'') and (align(s)<>filename) then
              begin
                if ((exist(memuboard.dlpath+s)) and (exist(memuboard.dlpath+sqoutsp(filename)))) then
                  sprompt('|I3603|wFilename already used. Press a key..|PK|I3603|LC')
                else
                begin
                  assign(ff,memuboard.dlpath+filename);
                  {$I-} rename(ff,memuboard.dlpath+s); {$I+}
                  x:=ioresult;
                  filename:=align(s);
                end;
              end;
              sprompt('|w|I2303'+mlnnomci(filename,18));
            end;
        '2':begin
              li:=blocks; li:=li*128;
              li:=inputnumxy(23,4,li,9,0,999999999);
              blocks:=li div 128;
            end;
        '3':begin
              stowner:=caps(stowner);
              inputxy(23,5,stowner,18);
              stowner:=allcaps(stowner);
              sprompt('|w|I2305'+mlnnomci(caps(stowner),18));
            end;
        '4':inputnumxy(23,6,owner,5,0,32767);
        '5':begin
              s:=date;
              inputxy(23,7,s,8);
              if (s<>'') and (s[3]='/') and (s[6]='/') then
              begin
                date:=s;
                daten:=daynum(s);
              end;
              sprompt('|I2307'+mln(date,18));
            end;
        '6':nacc:=inputnumxy(23,8,nacc,5,0,32767);
        '7':filepoints:=inputnumxy(23,9,filepoints,5,0,32767);
        '8':begin
              ok:=not (notval in filestat);
              if (notval in filestat) then exclude(filestat,notval)
                                      else include(filestat,notval);
              switchyn(23,10,ok);
            end;
        '9':begin
              ok:=resumelater in filestat;
              if (resumelater in filestat) then exclude(filestat,resumelater)
                                           else include(filestat,resumelater);
              switchyn(23,11,ok);
            end;
        '0':begin
              ok:=isrequest in filestat;
              if (isrequest in filestat) then exclude(filestat,isrequest)
                                         else include(filestat,isrequest);
              switchyn(23,12,ok);
            end;
        'I':begin
              cls;
              convt:=TRUE; ok:=TRUE;
              s:=sqoutsp(f.filename);
              arcstuff(ok,convt,f.blocks,convtime,FALSE,memuboard.dlpath,s,f,v);
              writefv(curfile,f,v);
              pausescr;
              cls;
              c:=#0;
            end;
        'W':if (owner>0) then
            begin
              loadurec(u,owner);
              creditfile(u,owner,f,FALSE);
            end;
        'D':begin
              deleteff(curfile,pl,TRUE);
              s:='Removed "'+sqoutsp(f.filename)+'" from Dir#'+cstr(fileboard);
              if (exist(memuboard.dlpath+f.filename)) then
              if pynq('|I2314Erase file too') then
              begin
                assign(ff,memuboard.dlpath+f.filename);
                {$I-} erase(ff); {$I+}
                if (ioresult=0) then
                  s:=s+' [FILE DELETED]'
                else
                  s:='Tried deleting "'+sqoutsp(f.filename)+'" from Dir#'+cstr(fileboard);
              end;
              sysoplog(s);
              if (curfile>pl) then dec(curfile);
            end;
        'M':begin
              done:=FALSE;
              cls;
              fbaselist;
              nl;
              repeat
                sprompt('|wMove file |K[|C#|c=destination|K/|CQ|c:uit|K] |W');
                input(s,3);
                dbn:=ccuboards[0][value(s)];
                if (s='Q') or ((dbn=0) and (s<>'0')) then
                  done:=TRUE
                else
                if (dbn<0) or (dbn>maxulb) then
                  sprint('|RInvalid file base number.')
                else
                begin
                  oldfileboard:=fileboard;
                  changefileboard(dbn);
                  if (fileboard=oldfileboard) then
                    sprint('|RCan''t move to the same directory!')
                  else
                  begin
                    fileboard:=oldfileboard;
                    done:=TRUE;
                    nl;
                    loaduboard(fileboard);
                    fl:=memuboard.dlpath+f.filename;
                    s1:=fexpand(bslash(FALSE,memuboard.dlpath));
                    loaduboard(dbn);
                    sprint('Moving file to '+memuboard.name+' ...');
                    s2:=fexpand(bslash(FALSE,memuboard.dlpath));
                    ok:=TRUE;
                    sprint('Orig-path: "'+s1+'" ('+cstrl(freek(exdrv(s1)))+'k free)');
                    sprint('Dest-path: "'+s2+'" ('+cstrl(freek(exdrv(s2)))+'k free)');
                    if (s1=s2) then
                    begin
                      sprint('|RUnable to move. Directory paths are the same.');
                      espace:=TRUE;
                      ok:=TRUE;
                    end else
                      if (exist(fl)) then
                      begin
                        espace:=TRUE;
                        assign(ff,fl);
                        {$I-}
                        SetFileAccess(ReadOnly,DenyNone);
                        reset(ff,1);
                        close(ff);
                        {$I+}
                        sprompt('Progress: ');
                        movefile(ok,nospace,TRUE,fl,memuboard.dlpath+f.filename);
                        if (ok) then nl;
                        if (not ok) then begin
                          sprompt('|RMove failed');
                          if (not nospace) then nl else
                            sprompt(' - Insuffient space on drive '+chr(x+64)+':');
                          sprint('!');
                        end;
                      end else
                        sprint('File does not actually exist.');
                    if ((espace) and (ok)) or (not exist(fl)) then
                    begin
                      sprompt('|CMoving file record ...');
                      deleteff(curfile,pl,FALSE);
                      oldfileboard:=fileboard;
                      fileboard:=dbn;
                      close(ulff);
                      fiscan(pl);
                      if (baddlpath) then exit;
                      v.descr[1]:=#1#1#0#1#1;
                      newff(f,v);
                      close(ulff);
                      fileboard:=oldfileboard;
                      fiscan(pl);
                      if (baddlpath) then exit;
                      sysoplog('Moved "'+sqoutsp(f.filename)+'" from Dir#'+
                               cstr(fileboard)+' to Dir#'+cstr(dbn));
                    end;
                  end;
                end;
              until ((done) or (hangup));
              if (curfile>pl) then dec(curfile);
              sprompt('|LF|PA|SC');
            end;
        '[':if (curfile<=0) then curfile:=pl else dec(curfile);
        ']':if (curfile>=pl) then curfile:=0 else inc(curfile);
        'E':begin
              assign(verbf,systat.datapath+'VERBOSE.DAT');
              assign(t,'I_EDDESC.'+cstr(nodenum));
              rewrite(t);
              writeln(t,description);
              if (vpointer<>-1) then
              begin
                setfileaccess(readwrite,denynone);
                reset(verbf);
                seek(verbf,vpointer);
                read(verbf,v);
                close(verbf);
                for x:=1 to 9 do
                  if (v.descr[x]<>'') then writeln(t,v.descr[x]) else x:=9;
              end;
              close(t);
              cls;
              tedit('I_EDDESC.'+cstr(nodenum));
              setfileaccess(readwrite,denynone);
              reset(t);
              if (not eof(t)) then
              begin
                readln(t,s);
                if (s='') then s:=' ';
                if (length(s)>50) then s:=copy(s,1,50);
                description:=s;
              end;
              if (not eof(t)) then
              begin
                fillchar(v,sizeof(v),#0);
                x:=1;
                while (x<=9) and (not eof(t)) do
                begin
                  readln(t,s);
                  if (s='') then s:=' ';
                  if (length(s)>50) then s:=copy(s,1,50);
                  v.descr[x]:=s;
                  inc(x);
                end;
                if (vpointer=-1) then vpointer:=nfvpointer;
                setfileaccess(readwrite,denynone);
                reset(verbf);
                seek(verbf,f.vpointer);
                write(verbf,v);
                close(verbf);
              end else
                if (vpointer<>-1) then
                begin
                  v.descr[1]:='';
                  setfileaccess(readwrite,denynone);
                  reset(verbf);
                  seek(verbf,f.vpointer);
                  write(verbf,v);
                  close(verbf);
                  vpointer:=-1;
                end;
              close(t);
              erase(t);
            end;
      end;
    end;
    if not (c in ['[',']','D','M']) then
    begin
      seek(ulff,curfile);
      write(ulff,f);
    end;
    if (filesize(ulff)=0) then c:='Q';
  until (c='Q') or (hangup);
  close(ulff);
end;

procedure validatefiles;
var i:integer;
    c:char;
    abort,next,isglobal,ispoints,isprompt:boolean;
    oldconf:char;

  procedure valfiles(b:integer; var abort,next:boolean);
  var u:userrec;
      f:ulfrec;
      s:astr;
      lng:longint;
      oldboard,pl,rn:integer;
      shownalready:boolean;
  begin
    oldboard:=fileboard;
    if (fileboard<>b) then changefileboard(b);
    if (fileboard=b) then begin
      recno('*.*',pl,rn);
      shownalready:=FALSE; abort:=FALSE; next:=FALSE;
      while (rn<>-1) and (not abort) and (not hangup) do begin
        seek(ulff,rn); read(ulff,f);
        if (notval in f.filestat) and
           (not (resumelater in f.filestat)) then begin
          if (not shownalready) then begin
            nl;
            sprint('Validating '+memuboard.name+'|w #'+
                   cstr(fileboard));
            nl;
            shownalready:=TRUE;
          end;

          lng:=f.blocks; lng:=lng*128;
          sprint('Filename   : |C'+'"'+f.filename+'"');
          sprint('Description: |C'+f.description);
          sprint('Size/points: |C'+cstrl(lng)+' bytes / '+
                 cstr(f.filepoints)+' pts');
          sprint('UL''d by    : |C'+caps(f.stowner)+' #'+cstr(f.owner));
          nl;
          loadurec(u,f.owner);
          if (isprompt) then begin
            if (ispoints) then begin
              prt('Points for file (<CR>=Skip,Q=Quit) : '); input(s,5);
              if (s='Q') then abort:=TRUE;
              if ((s<>'') and (s<>'Q')) then begin
                f.filepoints:=value(s);
                exclude(f.filestat,notval);
                seek(ulff,rn); write(ulff,f);
                if (not aacs1(u,f.owner,systat.ulvalreq)) then
                  creditfile(u,f.owner,f,TRUE);
                prt('Points for |Y'+caps(f.stowner)+' #'+
                    cstr(f.owner)+'|B (-999..999) : ');
                input(s,5);
                if (s<>'') then
                  if (f.owner=usernum) then
                    inc(thisuser.filepoints,value(s))
                  else begin
                    inc(u.filepoints,value(s));
                    saveurec(u,f.owner);
                  end;
              end;
              nl;
            end else begin
              repeat
                prt('Validate (Y/N,V=View,Q=Quit) ? '); onek(c,'QNVY');
                case c of
                  'Q':abort:=TRUE;
                  'V':begin
                        abort:=FALSE; next:=FALSE;
                        lfi(sqoutsp(memuboard.dlpath+f.filename),abort,next);
                        abort:=FALSE; next:=FALSE;
                      end;
                  'Y':begin
                        exclude(f.filestat,notval);
                        seek(ulff,rn); write(ulff,f);
                        if (not aacs1(u,f.owner,systat.ulvalreq)) then
                          creditfile(u,f.owner,f,TRUE);
                      end;
                end;
              until ((c<>'V') or (hangup));
              nl;
            end;
          end else begin
            exclude(f.filestat,notval);
            seek(ulff,rn); write(ulff,f);
            if (not aacs1(u,f.owner,systat.ulvalreq)) then
              creditfile(u,f.owner,f,TRUE);
          end;
        end;

        nrecno('*.*',pl,rn);
        wkey(abort,next);
      end;
      close(ulff);
    end;
    fileboard:=oldboard;
  end;

begin
  nl;
  print('Validate files -');
  nl;
  prt('Prompt for validation (Y)es, (N)o, (P)oints validation ? ');
  onek(c,'QNPY');
  if (c='Q') then exit;

  ispoints:=(c='P');
  isprompt:=(c<>'N');
  oldconf:=thisuser.conference;
  isglobal:=pynq('Search all directories');
  if isglobal then if pynq('Ignore conferences') then thisuser.conference:='@';
  nl;

  abort:=FALSE; next:=FALSE;
  if (isglobal) then begin
    i:=0;
    while (i<=maxulb) and (not abort) and (not hangup) do begin
      if (fbaseac(i)) then valfiles(i,abort,next);
      inc(i);
      wkey(abort,next);
      if (next) then abort:=FALSE;
    end;
  end else
    valfiles(fileboard,abort,next);
  thisuser.conference:=oldconf;
end;

end.
