(*****************************************************************************)
(* Illusion BBS - Archive routines [1/1]                                     *)
(*****************************************************************************)

{$A+,B-,D-,E+,F+,I+,L-,N-,O+,R-,S-,V-}
unit archive1;

interface

uses
  crt, dos,
  myio, execbat, common;

procedure purgedir(s:astr);                {* erase all non-dir files in dir *}
function arcmci(src,fn,ifn,cmt:astr):astr;
procedure arcdecomp(var ok:boolean; atype:integer; fn,fspec,s:astr);
procedure arccomp(var ok:boolean; atype:integer; fn,fspec,s:astr);
procedure arccomment(var ok:boolean; atype,cnum:integer; fn,s:astr);
procedure arcintegritytest(var ok:boolean; atype:integer; fn,s:astr);
procedure conva(var ok:boolean; otype,ntype:integer; tdir,ofn,nfn:astr);
function arctype(s:astr):integer;
procedure listarctypes;
procedure invarc;

implementation

uses file0, file1, file2, file4, file7, file9, file11;

const
  maxdoschrline=127;

procedure purgedir(s:astr);                {* erase all non-dir files in dir *}
var odir,odir2:astr;
    dirinfo:searchrec;
    f:file;
    att:word;
begin
  s:=fexpand(s);
  while copy(s,length(s),1)='\' do s:=copy(s,1,length(s)-1);
  getdir(0,odir); getdir(exdrv(s),odir2);
  chdir(s);
  findfirst('*.*',AnyFile-Directory-VolumeID,dirinfo);
  while (doserror=0) do begin
    assign(f,fexpand(dirinfo.name));
    setfattr(f,$00);           {* remove possible read-only, etc, attributes *}
    {$I-} erase(f); {$I+}      {* erase the $*@( file !!     *}
    findnext(dirinfo);         {* move on to the next one... *}
  end;
  chdir(odir2); chdir(odir);
end;

function arcmci(src,fn,ifn,cmt:astr):astr;
begin
  src:=substall(src,'@F',fn);
  src:=substall(src,'@I',ifn);
  src:=substall(src,'@C',cmt);
  arcmci:=src;
end;

{* ok: result
 * atype: archive method
 * fn   : archive filename
 *}

procedure arcdecomp(var ok:boolean; atype:integer; fn,fspec,s:astr);
begin
  purgedir(modemr.temppath+'ARCHIVE\');
  shel(s);
  execbatch(ok,TRUE,'i_arc'+cstr(nodenum)+'.bat','',modemr.temppath+'ARCHIVE\',
            arcmci(systat.arcpath+systat.filearcinfo[atype].unarcline,fn,fspec,''),
            systat.filearcinfo[atype].succlevel);
  shel2;
  if (not ok) then sysoplog('Archive "'+fn+'": Errors during de-compression');
end;

procedure arccomp(var ok:boolean; atype:integer; fn,fspec,s:astr);
begin
  shel(s);
  execbatch(ok,TRUE,'i_arc'+cstr(nodenum)+'.bat','',modemr.temppath+'ARCHIVE\',
            arcmci(systat.arcpath+systat.filearcinfo[atype].arcline,fn,fspec,''),
            systat.filearcinfo[atype].succlevel);
  shel2;
  if (not ok) then sysoplog('Archive "'+fn+'": Errors during compression');
  purgedir(modemr.temppath+'ARCHIVE\');
end;

procedure arccomment(var ok:boolean; atype,cnum:integer; fn,s:astr);
begin
  if (cnum<>0) and (systat.filearccomment[cnum]<>'') then
  begin
    shel(s);
    execbatch(ok,FALSE,'i_arc'+cstr(nodenum)+'.bat','',modemr.temppath+'ARCHIVE\',
              arcmci(systat.arcpath+systat.filearcinfo[atype].cmtline,fn,'',systat.filearccomment[cnum]),
              systat.filearcinfo[atype].succlevel);
    shel2;
  end;
end;

procedure arcintegritytest(var ok:boolean; atype:integer; fn,s:astr);
begin
  if (systat.filearcinfo[atype].testline<>'') then
  begin
    shel(s);
    execbatch(ok,TRUE,'i_arc'+cstr(nodenum)+'.bat','',modemr.temppath+'ARCHIVE\',
              arcmci(systat.arcpath+systat.filearcinfo[atype].testline,fn,'',''),
              systat.filearcinfo[atype].succlevel);
    shel2;
  end;
end;

procedure conva(var ok:boolean; otype,ntype:integer; tdir,ofn,nfn:astr);
var f:file;
    nofn,ps,ns,es:astr;
    eq:boolean;
begin
  star('Converting archive - stage one.');
  eq:=(otype=ntype);
  if (eq) then begin
    fsplit(ofn,ps,ns,es);
    nofn:=ps+ns+'.#$%';
  end;
  arcdecomp(ok,otype,ofn,'*.*','Converting archive - stage one...');
  if (not ok) then star('Errors in decompression!')
  else begin
    star('Converting archive - stage two.');
    if (eq) then begin assign(f,ofn); rename(f,nofn); end;
    arccomp(ok,ntype,nfn,'*.*','Converting archive - stage two...');
    if (not ok) then begin
      star('Errors in compression!');
      if (eq) then begin assign(f,nofn); rename(f,ofn); end;
    end;
    if (not exist(sqoutsp(nfn))) then ok:=FALSE;
  end;
end;

function arctype(s:astr):integer;
var atype:integer;
begin
  s:=align(stripname(s)); s:=copy(s,length(s)-2,3);
  atype:=1;
  while (systat.filearcinfo[atype].ext<>'') and
        (systat.filearcinfo[atype].ext<>s) and
        (atype<maxarcs+1) do
    inc(atype);
  if (atype=maxarcs+1) or (systat.filearcinfo[atype].ext='') or
     (not systat.filearcinfo[atype].active) then atype:=0;
  arctype:=atype;
end;

procedure listarctypes;
var i,j:integer;
begin
  i:=1; j:=0;
  while (systat.filearcinfo[i].ext<>'') and (i<maxarcs) do begin
    if (systat.filearcinfo[i].active) then begin
      inc(j);
      if (j=1) then prompt('Available archive formats: ') else prompt(',');
      prompt(systat.filearcinfo[i].ext);
    end;
    inc(i);
  end;
  if (j=0) then prompt('No archive formats available.');
  nl;
end;

procedure invarc;
begin
  print('Unsupported archive format.');
  nl;
  listarctypes;
  nl;
end;

end.
