(****************************************************************************)
(*>                                                                        <*)
(*>     Illusion Bulletin Board System                                     <*)
(*>     Copyright 1992-95 by Kyle Oppenheim and Billy Ma                   <*)
(*>     All rights reserved                                                <*)
(*>                                                                        <*)
(*>     Record structures for data files                                   <*)
(*>                                                                        <*)
(****************************************************************************)

CONST

  Ver:String[15]='1.93';          { Version string                       }
  VerType:Byte=0;                 { Version type -- 0:Unregistered       }
                                  {                 1:Standard           }
                                  {                 2:Special            }
                                  {                 3:Beta               }
                                  {                 4:Alpha              }

  MaxBoards=254;      { 1 - x }   { Maximum msg boards                   }
  MaxuBoards=140;     { 0 - x }   { Maximum file boards                  }
  MaxProtocols=120;   { 0 - x }   { Maximum protocols                    }
  MaxEvents=10;       { 0 - x }   { Maximum events                       }
  MaxArcs=8;          { 1 - x }   { Maximum archive configs allowed      }
  MaxuBatchFiles=20;              { Maximum batch files in UL queue      }
  MaxBatchFiles=20;               { Maximum batch files in DL queue      }
  NumVoteQs=20;                   { Maximum voting questions             }
  NumVoteAs=50;                   { Maximum answers per voting question  }
  MaxMenuCmds=50;                 { Maximum number of commands per menu  }

TYPE

  aStr    =String[160];
  ACString=String[20];            { Access Condition String              }
  AcRq    ='@'..'Z';              { AR flags                             }

  cPackDateTime=Array[1..6] of Byte; { Packed date/time                  }
  DateTimeRec=                    { Internal date/time storage           }
  Record
    Day,Hour,Min,Sec:LongInt;
  End;

  MzScanR = Set of 1..MaxBoards;                  { used in misc records }
  FzScanR = Set of 0..MaxuBoards;                 {            |         }
  mHiReadR= Array[1..MaxBoards] of cPackDateTime; {            |         }
  DlnScan = Set of 0..96;                         {            V         }

(*****************************************************************************)
{ User Listings }

  SmalRec=                        { USERS.IDX : Sorted names listing     }
  Record
    Name:String[36];              { User name                            }
    Number:Integer;               { User number                          }
  End;

  uFlags =                        { User AC Flags - stored in UserRec    }
   (rLogon,                       { L - Restricted to one call a day     }
    rChat,                        { C - Can't page the sysop             }
    rValidate,                    { V - Posts marked unvalidated         }
    rFastLogon,                   { F - Force fast logon                 }
    rAMsg,                        { A - Can't change the AutoMessage     }
    rPostAn,                      { * - Can't post anonymously           }
    rPost,                        { P - Can't post at all                }
    rEmail,                       { E - Can't send any e-mail            }
    rVoting,                      { K - Can't vote                       }
    rMsg,                         { M - Force e-mail deletion            }
    Rip,                          { User has RIP                         }
    OneKey,                       { Hotkey input mode                    }
    Avatar,                       { User has AVATAR                      }
    Pause,                        { Pause is active                      }
    Novice,                       { Expert mode is off (novice on)       }
    Ansi,                         { User has ANSI                        }
    Color,                        { User has color                       }
    Alert,                        { Alert sysop when user logs on        }
    Smw,                          { Short-message waiting for user       }
    NoMail,                       { User mail-box is closed              }
    fNoDlRatio,                   { 1 - No UL/DL ratio                   }
    fNoPostRatio,                 { 2 - No post/call ratio               }
    fNoFilePts,                   { 3 - No file points checking          }
    fNoDeletion);                 { 4 - Protection from deletion         }

  UserRec=                        { USERS.DAT : User account records      }
  Record
    Name:String[36];              { User name                            }
    RealName:String[36];          { Real name                            }
    Pw:String[20];                { User password                        }
    Ph:String[12];                { User phone number                    }
    Bday:String[8];               { User birthdate                       }
    FirstOn:String[8];            { FirstOn date                         }
    LastOn:String[8];             { LastOn date                          }
    Street:String[30];            { Mailing address                      }
    CityState:String[30];         { City, state                          }
    ZipCode:String[10];           { Zipcode                              }
    Computer:String[30];          { Type of computer                     }
    Occupation:String[40];        { Occupation                           }
    WhereBbs:String[40];          { BBS reference                        }
    Note:String[39];              { Sysop note                           }
    UserNote:String[25];          { User note                            }
    res1:Array[1..164] of Byte;   { ** RESERVED ** }

    LockedOut,                    { Locked out?                          }
    Deleted:Boolean;              { Deleted?                             }
    LockedFile:String[8];         { Lockout file to display              }

    AC:Set of uFlags;             { User flags                           }
    AR:Set of AcRq;               { AR flags                             }

    Vote:Array[1..20] of Byte;    { Voting data                          }
    Sex:Char;                     { User sex                             }

    TTimeOn,                      { Total minutes spent online           }
    Uk,Dk:LongInt;                { UL/DL kbytes                         }
    Uploads,Downloads,            { Number of uploads/downloads          }
    LoggedOn,                     { Number of times logged on            }
    TlToday,                      { Minutes left today                   }
    MsgPost,                      { Number of public posts               }
    EmailSent,                    { Number of email sent                 }
    FeedBack,                     { Number of feedback sent              }
    ForUsr:Word;                  { Forward mail to user #               }
    FilePoints:LongInt;           { File points                          }
    res2:Array[1..18] of Byte;    { ** RESERVED ** }

    Waiting,                      { Mail waiting                         }
    LineLen,                      { Line length (# cols)                 }
    PageLen,                      { Page length (# rows)                 }
    OnToday,                      { Number of times on today             }
    Illegal,                      { Number of illegal logon attempts     }
    sl,dsl,                       { SL / DSL                             }
    LastMsg,LastFil:Byte;         { Last message/file areas              }
    res3:Array[1..10] of Byte;    { ** RESERVED ** }

    Credit,                       { Credits                              }
    TimeBankAdd,                  { Time added to timebank today         }
    TimeBank:Integer;             { Number of minutes in time bank       }
    res4:Array[1..10] of Byte;    { ** RESERVED ** }

    SLogSeperate,                 { Seperate sysop log?                  }
    ChatAuto,                     { Auto chat trapping?                  }
    ChatSeperate,                 { Trap to separate chat file?          }
    TrapActivity,                 { Trap user's activity?                }
    TrapSeperate:Boolean;         { Trap to separate trap file?          }
    res5:Array[1..5] of Byte;     { ** RESERVED ** }

    mPointer:LongInt;             { Pointer to entry in MACROS.DAT       }

    UserStartMenu:String[8];      { Menu to start user out on            }
    ClsMsg,                       { 1:Clear screen before message        }
                                  { 2:Do not clear screen before message }
    mConf,fConf:Byte;             { Current message/file conference      }
    fListC:Array[1..10,1..2] of Byte; { Configurable file listings       }
                                  { 1..10:File listing elements          }
                                  { 1..2: 1: 0:off 1:on                  }
                                  {       2: color                       }
    QwkArc:String[3];             { QWK archive type                     }
    QwkFiles:Boolean;             { Show new files in QWK packet?        }
    EdType:Byte;                  { 0:Select at time                     }
                                  { 1:Line editor                        }
                                  { 2:Full screen editor                 }
    res6:Array[1..99] of Byte;    { ** RESERVED ** }
  End;

(*****************************************************************************)
{ Message area structures }

  ZScanRec=                       { NEWSCAN.DAT : Newscan records        }
  Record                            { ** b0..b3 }
    mHiRead:mHiReadR;             { Newscan high message pointers        }
    mZScan:mZScanR;               { Newscan message bases                }
    fZScan:fZScanR;               { Newscan file bases                   }
  End;

  AnonTyp =                       { Anonymous types - stored in BoardRec }
   (atNo,                         { No anonymous posts allowed           }
    atYes,                        { Anonymous posts are allowed          }
    atForced,                     { All posts are forced anonymous       }
    atDearAbby,                   { "Dear Abby" message base             }
    atAnyName);                   { Users can post as any name they want }

  MsgIndexStatR=                  { Message flags - stored in MsgIndexRec }
   (miDeleted,                    { Does message actually exist?         }
    miEncrypted,                  { Is it encrypted?                     }
    miUnvalidated,                { Is message unvalidated?              }
    miPermanent,                  { Is the message permanent?            }
    miAllowMci,                   { Did owner have access to MCI?        }
    miThreads,                    { Is message referenced? (threaded)    }
    miMassMail,                   { Is it private, mass mail?            }
    miScanned);                   { Is message scanned for echomail?     }

  MsgIndexRec=                    { *.MIX : Message index records        }
  Record
    MessageNum:Word;              { Message number, tonum in EMAIL.MIX   }
    HdrPtr:LongInt;               { Pointer to message header            }
    MsgId:LongInt;                { Message ID (sequential)              }
    IsReplyToId:LongInt;          { ID of replied message                }
    MsgDate:cpackdatetime;        { Message date/time (packed)           }
    MsgDOWk:Byte;                 { Message day-of-week (0=Sun ...)      }
    MsgIndexStat:Set of MsgIndexStatR; { Status flags                    }
    IsReplyTo:Word;               { Reply this message is to (-1=None)   }
    NumReplys:Integer;            { Number of replies to this message    }
  End;

  FromToInfo=                     { From/to information for mHeaderRec   }
  Record
    Anon:Byte;                    { Anonymous type                       }
    UserNum:Word;                 { User number                          }
    As:String[42];                { Given name for this case             }
    Real:String[36];              { User real name                       }
    Alias:String[36];             { User alias                           }
  End;

  mheaderrec=                     { *.BRD : Message header Records       }
  Record
    Signature:LongInt;            { Header signature - $FFFFFFFF         }
    MsgPtr:LongInt;               { Pointer to message text              }
    MsgLength:LongInt;            { Length of message text               }
    FromI:FromToInfo;             { From information                     }
    ToI:FromToInfo;               { To information                       }
    fUserNote:String[25];         { User note of sender                  }
    Title:String[60];             { Title of message                     }
    DateTime:String[19];          { Echo original message date           }
  End;

(*****************************************************************************)
{ Logs }

  ZLogRec=                        { HISTORY.DAT : System log             }
  Record
    Date:String[8];               { Entry date                           }
    UserBaud:Array[0..4] of Integer; { Callers' baud rates               }
                                  { 0=300,1200;  1=2400;                 }
                                  { 2=4800,7200  3=9600;                 }
                                  { 4=12000,14400,16800,19200,38400      }
    Active,                       { Number of minutes active             }
    Calls,                        { Number of calls                      }
    NewUsers,                     { Number of new users                  }
    PubPost,                      { Number of public posts               }
    PrivPost,                     { Number of private posts              }
    FBack,                        { Number of feedback sent              }
    CritErr,                      { Number of runtime errors occured     }
    Uploads,                      { Number of files uploaded             }
    Downloads:Integer;            { Number of files downloaded           }
    Uk,                           { Number of kbytes uploaded            }
    Dk:LongInt;                   { Number of kbytes downloaded          }
  End;

(****************************************************************************)
{ Multinode files }

  HaTypes=
    (HaCtsRts,
     HaXonXoff,
     HaRes1,
     HaRes2);

  ModemRec=                      { NODE.### : Modem/node info            }
  Record
    DoorPath:String[79];         { DOORFILE path (for this node)         }
    TempPath:String[79];         { TEMP path (for this node)             }
    res1:Array[1..160] of Byte;  { ** RESERVED ** }

    LastDate:String[8];          { Last system date (for this node)      }
    LowSpeed:Word;               { Speed for low speed lockout           }
    LowPw:String[20];            { Low speed override password           }
    res2:Array[1..40] of Byte;   { ** RESERVED ** }

    ComPort:Byte;                { COM port                              }
    WaitBaud:Word;               { Maximum speed                         }
    PortLock:Boolean;            { Port locked?                          }
    LockSpeed:Word;              { Speed port is locked at               }
    Handshake:HaTypes;           { Handshaking                           }
    res3:Array[1..20] of Byte;   { ** RESERVED ** }

    EscCode:String[20];          { "+++"                                 }
    init:Array[1..2] of          { Initialization strings                }
         String[80];             {       "           "                   }
    NoCallInitTime:Integer;      { ReInit modem after x mins of inactivity }
    Answer:String[40];           { Answer string                         }
    AnswerDelay:Byte;            { Delay in 1/10 seconds for answer      }
    Hangup:String[40];           { Hangup string                         }
    Offhook:String[40];          { Phone off-hook string                 }
    res4:Array[1..160] of Byte;  { ** RESERVED ** }

    CodeError,                   { Result code for ERROR                 }
    CodeNoCarrier,               { Result code for NO CARRIER            }
    CodeOk,                      { Result code for OK                    }
    CodeRing:String[25];         { Result code for RING                  }
    res5:Array[1..78] of Byte;   { ** RESERVED ** }

    ResultCode:Array[0..14] of   { Result codes                          }
               String[25];       {  0:300    1:1200    2:2400    3:4800  }
                                 {  4:7200   5:9600    6:12000   7:14400 }
                                 {  8:16800  9:19200  10:21600  11:24000 }
                                 { 12:26400 13:28800  14:38400           }
    res6:Array[1..90] of Byte;   { ** RESERVED ** }
  End;

  NodeRec=                       { NODES.DAT : Node listings             }
  Record
    UserName:String[36];         { Name of user on node                  }
    uNum:Integer;                { User number of user on node           }
    WhereUser:String[20];        { Where on the system is the user?      }
    Available:Boolean;           { Available for chat?                   }
    res1:Array[1..21] of Byte;   { ** RESERVED ** }
    Active:Boolean;              { Is this node active/running?          }
  End;

(*****************************************************************************)
{ Strings }

  fStringRec=                    { STRINGS.DAT : String configuration    }
  Record
    Ansidetect:String[80];       { ANSI detected                         }
    Note:Array[1..2] of String[80]; { Logon notes                        }
    LPrompt,                     { Logon prompt                          }
    MatrixPw,                    { Matrix password prompt                }
    UserPw,                      { User password prompt                  }
    UserPhone,                   { Phone number prompt                   }
    SysopPw:String[80];          { Sysop password prompt                 }
    EchoC:Char;                  { Echo char for passwords               }
    NameNotFound,                { Name isn't found in the user list     }
    LockPwPrompt,                { Lowspeed lockout password prompt      }

    SysopIn,                     { Sysop is available for chat           }
    SysopOut,                    { Sysop is not available for chat       }
    Wait,                        { Sysop is working                      }
    ShellDos1,                   { Sysop shelling to DOS                 }
    ShellDos2,                   { Sysop returing from shell             }
    Pause,                       { Pause prompt                          }
    Welcome,                     { Welcome to the BBS                    }
    MmChat,                      { Enhanced chat song prompt             }
    ThanxVote,                   { Thanks for voting                     }
    SendMail,                    { Send email prompt                     }
    SendSMsg,                    { Send short msg prompt                 }

    EnterMsg1,                   { Line editor header line 1             }
    EnterMsg2,                   { Line editor header line 2             }
    NewScanStart,                { Beginning message newscan             }
    NewScanEnd,                  { Message newscan complete              }
    NewScan1,                    { Newscan begin                         }
    NewScan2,                    { Newscan end                           }
    ScanMessage,                 { Message scanning/read prompt          }
    MsgScan,                     { Scan prompt                           }
    AutoMsgt:String[80];         { Auto-message not available            }
    iChar:Char;                  { Input string char                     }
    MailRead,                    { Mail read prompt                      }
    MsgDeleted,                  { Message deleted                       }
    MsgUnvalidated,              { Message unvalidated                   }

    ListLine,                    { List files                            }
    NewLine,                     { Search for new files                  }
    SearchLine,                  { Search all dirs for file mask         }
    FindLine1,                   { Search for descriptions               }
    FindLine2,                   { Search prompt                         }
    DownloadLine,                { Download                              }
    UploadLine,                  { Upload                                }
    ViewLine,                    { View interior files                   }
    NoFilePts,                   { Insufficient file points              }
    UnBalance,                   { UL/DL ratio is unbalanced             }
    NqInfo,                      { CR for next, Q to quit                }
    NoFFound,                    { No files found                        }

    PnInfo,                      { P to Pause, N for next dir            }
    GfnLine1,                    { Enter=All files                       }
    GfnLine2,                    { Filemask prompt                       }
    BatchAdd,                    { File added to batch queue             }
    ProtLine,                    { Protocol prompt                       }
    bProtLine,                   { Batch protocol prompt                 }
    ChatCall1,                   { Paging sysop, please wait...          }
    ChatCall2,                   { >><*><<                               }
    Engage,                      { Chat engaged                          }
    EndChat,                     { Chat disengaged                       }
    QuoteLine1,                  { Quoting line 1                        }
    QuoteLine2,                  { Quoting line 2                        }
    Batchndl,                    { Not enough fps to download everything }

    GenChatLine:String[80];      { Generic chat reasons notice           }
    GenChat:Array[1..9] of String[80]; { Generic chat reasons            }
    WhyChat,                     { Chat reason prompt                    }
    GenChatPrompt,               { Generic chat reasons prompt           }
    ChatOverride,                { Chat override prompt                  }

    BankTitle,                   { Title of bank                         }
    BankDeposit,                 { Deposit option in bank                }
    unused1,                     { ** UNUSED ** }
    BankQuit,                    { Quit option in bank                   }
    BankWithdraw,                { Withdraw option in bank               }
    BankCannotWithdraw,          { Cannot withdraw from bank             }
    BankCannotAddToday,          { Cannot add minutes today              }
    BankCannotAdd,               { Cannot add more to account            }
    BankPrompt,                  { Time bank prompt                      }
    BankAddPrompt,               { Add minutes prompt                    }
    BankWithdrawPrompt,          { Withdraw minutes prompt               }

    VoteChoice,                  { Choice of vote prompt                 }
    QuestionChoice,              { Choice of question to vote on prompt  }
    MandatoryVoting,             { Voting is mandatory                   }

    ScanningUsers,               { Scanning for users to vote on         }
    Voted1,                      { Already Voted, line 1                 }
    Voted2,                      { Already Voted, line 2                 }
    NuvPrompt:String[80];        { Nuv prompt                            }

    SpinChar:Array[1..4] of Char; { Spinning cursor characters           }

    MacroPrompt,                 { Macro modification prompt             }
    SkipUsers,                   { Skip users already voted on?          }
    Unknown,                     { Msg is anonymous, space not displayed }

    ColorYes,                    { When yes is active (color)            }
    ColorNo,                     { When no is active (color)             }
    TtyYes,                      { When yes is active (tty)              }
    TtyNo,                       { When no is active (tty)               }
    ColorYesDone,                { When yes is chosen (color)            }
    ColorNoDone,                 { When no is chosen (color)             }
    TtyYesDone,                  { When yes is chosen (tty)              }
    TtyNoDone,                   { When no is chosen (tty)               }

    AvatarDetect,                { AVATAR detected                       }

    cAddress,                    { Address prompt                        }
    cBday,                       { Birthdate prompt                      }
    cCity,                       { City prompt                           }
    cState,                      { State/province prompt                 }
    cCountry,                    { Country prompt                        }
    cTooLong,                    { City&country too long                 }
    cComputer,                   { Computer type prompt                  }
    cOccupation,                 { Occupation prompt                     }
    cHandle,                     { Handle prompt                         }
    cNoHandle,                   { No handles allowed                    }
    cChecking,                   { Checking for dupes                    }
    cDupFound,                   { Dupe found                            }
    cNoneFound,                  { No dupes found                        }
    cPhone,                      { Phone prompt                          }
    cPassword,                   { Password prompt                       }
    cRealName,                   { Real name prompt                      }
    cNotCorrect,                 { Real name not entered correctly       }
    cGender,                     { Gender prompt                         }
    cReference,                  { Reference prompt                      }
    cZipCode,                    { Zip code prompt                       }
    cUserNote,                   { User note prompt                      }

    QuoteTitle,                  { Quoting title                         }
    NotReply,                    { Not replying to a message             }
    FNewScan,                    { file zscan prompt                     }
    qFromPrompt,                 { From line prompt                      }
    qToPrompt,                   { To line prompt                        }
    ChMsgBase,                   { Change message base prompt            }

    MsgDefaults,                 { Enter for defaults                    }
    InvalidUser,                 { Invalid user number                   }
    NoDiskSpace,                 { Not enough disk space                 }
    UploadPrepared,              { Uploaded prepared message             }
    AbbyName,                    { Abby's name                           }
    ProblemName,                 { Problemed person's name               }
    MailBoxFull,                 { User's mailbox is full                }
    MailBoxClosed,               { User's mailbox is closed              }
    MailYourself,                { Can't send mail to yourself           }
    CannotSendMail,              { Can't send mail                       }
    TooMuchMail,                 { Too much mail sent today              }
    TooMuchFb,                   { Too much feedback sent today          }
    UserDeleted,                 { User has been deleted                 }

    QuoteComplete,               { Quoting is complete                   }
    EditCommand,                 { Editor command prompt                 }
    NewUserPw,                   { New user password prompt              }
    NewModPrompt,                { New user modification menu prompt     }
    SavingAccount,               { Saving user account                   }
    SavingAcDone,                { " done!                               }
    NuvNoUsers,                  { No users found to vote on             }
    NuvEnterComment,             { Enter a comment prompt                }
    NuvRecorded,                 { NUV vote recorded                     }

    PageLen,                     { Length of page prompt                 }
    LineLen,                     { Width of page prompt                  }

    AskLotto,                    { Want to play lotto?                   }
    AskBet,                      { Play for time or credits              }
    NoTime,                      { Not enough time to play               }
    NoCredit,                    { Not enough credits to play            }
    SubTime,                     { Subtracted 15 minutes                 }
    SubCredits,                  { Subtracted 50 credits                 }
    AskNumbers,                  { Pick 5 Numbers                        }
    NumDrawn,                    { Numbers drawn                         }
    NoWin,                       { You didn't win                        }
    WinTime,                     { You won |XA mins                      }
    WinCredits,                  { You won |XA credits                   }

    DeductFp,                    { Deducting file points                 }
    ThanxUl,                     { Thanks for the upload                 }
    CreditVal,                   { Will get credit when file validated   }
    PointsVal,                   { Will get fps when file validated      }
    FileOffline,                 { File is offline                       }
    CantResume,                  { Can't do anything with resume files   }
    CantVal,                     { Can't do anything with unvalidated    }
    CantTime,                    { Not enough time to download           }
    CantOffline,                 { File is offline                       }
    DlNotGood,                   { Download was unsuccessful             }
    ForSysop,                    { Use \ to sent to sysop directory      }
    EnterDesc,                   { Enter description now                 }
    LookFDupe,                   { Looking for duplicates                }
    NoFDupes,                    { No dupes found                        }
    IllegalFn,                   { Illegal filename                      }

    NuvValidate,                 { Validating user                       }
    NuvDelete,                   { Deleting user                         }
    NuvRecDel,                   { Deleting record                       }
    NuvAskCom,                   { Want to enter a comment?              }
    NuvDispCom,                  { Displaying comments                   }
    PcrHelp,                     { Want help on PCRs?                    }

    BchEmpty,                    { Batch queue empty                     }
    BchDl,                       { Batch download                        }
    BchNoTime,                   { Not enough time                       }
    BchNoFp,                     { Not enough file points                }
    BchRemove,                   { Must remove some files                }
    BchHangup,                   { Hangup after transfer?                }
    ChFileBase,                  { Change file area prompt               }
    BchTl,                       { Not enough time left                  }
    BchFull,                     { Batch queue full                      }

    qNone,                       { No new msgs found                     }
    qNew,                        { |XA new msgs found                    }
    qComp,                       { Compressing                           }
    qError,                      { Errors in compression                 }
    qPacket,                     { Packet size is |XA                    }
    qUpdate,                     { Updating pointers                     }

    rAdd,                        { Add base to zscan                     }
    rDrop,                       { Drop base from zscan                  }
    rFileOn,                     { New files included                    }
    rFileOff:String[80];         { New files not included                }
    rInv:Array[1..2] of String[80]; { Invalid config command             }
    rToss,                       { Tossing msgs                          }
    rError,                      { Error opening .MSG                    }
    rErrorH,                     { Header doesn't match                  }
    rExist,                      { Message base doesn't exist            }
    rEof,                        { Unexpected EOF                        }
    rDecomp,                     { Decompressing packet                  }
    rHangup,                     { Hangup after transfer?                }

    AlreadyHere,                 { That user is already on here          }
    AreNew,                      { Are you a new user                    }
    IsValidated,                 { You have been validated               }
    MPwIs,                       { Matrix password is |XA                }
    LogonNow,                    { Logon now?                            }
    NotValidated,                { Haven't been validated yet            }
    NuvVoting,                   { Nuv is still voting                   }
    CannotNew,                   { Cannot logon as new from here         }
    NoLongerWorks,               { No longer works, notifying sysop      }
    AlreadyOn,                   { Already logged on another node        }
    OnlyOnce,                    { Can only logon once a day             }
    TooManyCal,                  { Can only logon |XA times a day        }
    NotLeftA,                    { Can only logon |XA minutes a day      }
    TimeInBank,                  { Still have time in bank               }
    WithdrawFromBank,            { Withdraw time from bank?              }
    HangingUp,                   { Hanging up                            }

    RdMail,                      { Read your mail now prompt             }
    NoRecord,                    { That account is not on record         }
    IllegalLogon,                { Illegal logon                         }
    RipDetect,                   { RIP detected                          }
    PwConfirm,                   { Your password: |XA                    }
    FastLogon:String[80];        { Fast logon prompt                     }

    res2:Array[1..1550] of Byte; { ** RESERVED ** }
  End;

(*****************************************************************************)
{ Color config }

  ColorRec=                      { COLOR.DAT : Color schemes             }
  Record
    Name:String[40];             { Color scheme name                     }
    Cl:Array[0..1294] of Byte;   { Colors (base 16)                      }
  End;

(*****************************************************************************)
{ Main config }

  SecRange=Array[0..255] of Integer; { Security tables                   }

  FileArcInfoRec=                 { Archives - stored in SystatRec       }
  Record
    Active:Boolean;               { Active?                              }
    Ext:String[3];                { 3 character file extension           }
    ListLine,                     { /x for internal;
                                     x: 1:ZIP  2:ARJ                     }
    ArcLine,                      { Compression commandline              }
    UnarcLine,                    { Decompression commandline            }
    TestLine,                     { Integrity test commandline (null if none) }
    CmtLine:String[25];           { Add comment commandline (null if none) }
    SuccLevel:Integer;            { Success errorlevel (-1=ignore results) }
  End;

  ConfRec=                        { Conferences - stored in SystatRec    }
  Record
    Name:String[40];              { Conference name                      }
    Acs:ACString;                 { Conference ACS requirement           }
  End;

  LogonRec=                       { Logon config. - stored in SystatRec  }
  Record
    Place:Byte;                   { Placement                            }
    Active,                       { Active?                              }
    InFast,                       { In fast logon?                       }
    PauseBefore,                  { Pause before?                        }
    ClsBefore:Boolean;            { CLS before?                          }
    LfAfter:Byte;                 { Linefeeds after (0-10)               }
  End;
  LogOptions=Array[1..20] of LogonRec;

  SystatRec=                      { ILLUSION.CFG : Main configuration    }
  Record
    DataPath,                     { DATA path                            }
    TextPath,                     { TEXT path (text files path)          }
    MenuPath,                     { MENUS path                           }
    MsgPath:String[79];           { MSG path (priv/pub mail path)        }
    res0:Array[1..80] of Byte;    { ** RESERVED ** }
    TrapPath,                     { TRAP path                            }
    MultPath:String[79];          { MULT path                            }
    res1:Array[1..80] of Byte;    { ** RESERVED ** }

    BbsName:String[80];           { BBS name                             }
    BbsPhone:String[12];          { BBS phone number                     }
    SysopName:String[30];         { Sysop's full name or alias           }
    MaxUsers,                     { Max number of users system can have  }
    NumUsers,                     { Number of users                      }
    LowTime,                      { Sysop chat begin.. (in minutes)      }
    HiTime,                       { ..and end                            }
    DlLowTime,                    { Normal downloading hours begin..     }
    DlHiTime:Integer;             { ..and end                            }
    ShuttleLog:Boolean;           { Matrix logon active?                 }
    SysopPw,                      { Sysop password                       }
    NewUserPw,                    { Newuser password (null if none)      }
    ShuttlePw:String[20];         { Matrix password (if matrix active)   }
    ClosedSystem:Boolean;         { Don't allow new users?               }
    SwapShell:Boolean;            { Swap shell function enabled?         }
    SwapShellType:Byte;           {   0:disk  1:EMS  2:XMS  3:all        }
    EventWarningTime:Integer;     { Time before event warning            }
    LastMsgId:LongInt;            { Last-used message ID (sequential)    }
    CallerNum:LongInt;            { Total number of callers              }
    res2:Array[1..200] of Byte;   { ** RESERVED ** }

    Sop,                          { Sysop                                }
    CSop,                         { CoSysop                              }
    MSop,                         { Message sysop                        }
    FSop,                         { File sysop                           }
    SPw,                          { Sysop PW at logon                    }
    SeePw,                        { See passwords remotely               }
    NormPubPost,                  { Make normal public posts             }
    NormPrivPost,                 { Send normal email                    }
    AnonPubRead,                  { See who posted public anonymously    }
    AnonPrivRead,                 { See who sent anonymous email         }
    AnonPubPost,                  { Make anonymous posts                 }
    AnonPrivPost,                 { Send anonymous email                 }
    SeeUnval,                     { See unvalidated files                }
    DlUnval,                      { Download unvalidated files           }
    NoDlRatio,                    { No UL/DL ratio                       }
    NoPostRatio,                  { No post/call ratio                   }
    NoFilePts,                    { No file points checking              }
    UlValReq,                     { Uploads require validation by sysop  }
    FastLogonAcs,                 { Can fast logon                       }
    EmergChat:ACString;           { Override sysop status for chat       }
    res3:Array[1..105] of Byte;   { ** RESERVED ** }

    QwkDir:String[79];            { Local QWK directory                  }
    QwkWelcome,                   { Filename of QWK welcome message      }
    QwkNews,                      { Filename of QWK news message         }
    QwkGoodbye:String[8];         { Filename of QWK goodbye message      }
    QwkComp:String[3];            { Default archive extension            }
    Conf:Array[1..2,1..6] of ConfRec; { Conferences                      }

    MaxPrivPost,                  { Maximum email can send per call      }
    MaxFBack,                     { Maximum feedback per call            }
    MaxPubPost,                   { Maximum posts per call               }
    MaxChat,                      { Maximum chat-pages per call          }
    MaxWaiting,                   { Maximum mail in mailbox              }
    CsMaxWaiting,                 { Maximum mail in mailbox for CoSysop+ }
    DescImport,                   { Import description in file           }
                                  {   0:never  1:optional  2:mandatory   }
    unused1,                      { ** UNUSED ** }
    MaxLogonTries,                { Tries allowed to logon               }
    BsDelay,                      { Backspacing delay                    }
    SysopColor,                   { Sysop color in chat mode             }
    UserColor:Byte;               { User color in chat mode              }
    MinSpaceForPost,              { Minimum K drive space left to post   }
    MinSpaceForUpload:Integer;    { Minimum K drive space left to upload }
    BackSysopLogs,                { Days to keep sysop logs              }
    WfcBlankTime:Byte;            { Minutes after which to blank WFCmenu }
    LineLen,                      { Default video line length            }
    PageLen:Byte;                 { Default video page length            }
    NuvYes,                       { Yes votes needed to be validated     }
    NuvNo:Byte;                   { No votes needed to be deleted        }
    res4:Array[1..25] of Byte;    { ** RESERVED **                       }

    SpecialFx:Word;               { System special effects (bitmapped)   }
    LogonConfig:LogOptions;       { Logon config                         }
    SysBatExec,                   { Execute system batch files?          }
    AllowAlias,                   { Allow aliases? (handles)             }
    PhonePw,                      { Use phone number password in logon?  }
    LocalSec,                     { Is local security on?                }
    LocalScreenSec,               { Is local screen-security on?         }
    GlobalTrap,                   { Trap all users' activity?            }
    AutoChatOpen,                 { Does chat buffer auto-open?          }
    SplitChat,                    { Use split-screen chat?               }
    OffHookLocalLogon,            { Take phone offhook for local logons? }
    ForceVoting,                  { Is mandatory logon voting active?    }
    CompressBases,                { Compress file/message base numbers?  }
    SearchDup,                    { Search for duplicate filenames for UL? }
    StripCLog,                    { Strip colors from sysop log output?  }
    Nuv:Boolean;                  { New user voting active?              }
    PutOvr:Byte;                  { Where to load overlay 0:disk 1:EMS 2:XMS }
    UseBios,                      { Use ROM BIOS for local video output  }
    CgaSnow:Boolean;              { Suppress snow on CGA systems         }
    res5:Array[1..20] of Byte;    { ** RESERVED ** }

    NewApp,                       { User to send new user application to }
    TimeOutBell,                  { Minutes before timeout bell          }
    TimeOut:Integer;              { Minutes before timeout (logoff)      }

    FileArcInfo:Array[1..MaxArcs] of FileArcInfoRec; { archive specs     }
    FileArcComment:Array[1..3] of String[80]; { BBS comments             }

    UlDlRatio,                    { Are UL/DL ratios active?             }
    FilePtRatio,                  { Is auto file-pt compensation active? }
    FilePtCommission:Boolean;     { File points commission active?       }
    FilePtComRatio,               { File point commission ration 1/x     }
    FilePtComp,                   { File point compensation ratio x/1    }
    FilePtCompBaseSize,           { File point "base compensation size"  }
    PostCredits:Integer;          { File point compensation for posts    }
    UlRefund,                     { Percent time refund for ULs          }
    ToSysopDir:Byte;              { "To sysop" file base                 }
    ValidateAllFiles:Boolean;     { Validate ALL FILES automatically?    }
    RemDevice:String[10];         { Remote output device (GATEx,COMx,etc) }
    MaxInTemp,                    { Max K allowed in TEMPx\TEMPBASE      }
    MinResume:Integer;            { Min K to allow resume-later          }
    MaxDBatch,                    { Max files in DL batch queue          }
    MaxUBatch,                    { Max files in UL batch queue          }
    UnlistFp:Byte;                { File pts required for unlisted d/l   }
    ArcPath:String[79];           { Path to archive utils                }
    ProtPath:String[79];          { Path to protocol driVers             }
    res6:Array[1..83] of Byte;    { ** RESERVED ** }

    AllStartMenu:String[8];       { Logon menu to start ALL users on     }

    TimeAllow,                    { Time allowance                       }
    CallAllow,                    { Call allowance                       }
    Dlratio,                      { # ULs/# DLs ratios                   }
    DlKRatio,                     { DLk/ULk ratios                       }
    PostRatio:SecRange;           { Post/call ratios                     }
    res7:Array[1..512] of Byte;   { ** RESERVED ** }

    LastDate:String[8];           { Last system date                     }
    CurWindow:Byte;               { Type of sysop window currently in use }
    WindowOn,                     { Is the sysop windows on?             }
    IsTopWindow:Boolean;          { Is sysop window on top of screen?    }
    TodayZLog:ZLogRec;            { Today's zlog record                  }
    res8:Array[1..250] of Byte;   { ** RESERVED ** }
  End;

(*****************************************************************************)
{ Miscellaneous }

  MacroRec=                       { MACROS.DAT : Macro Records           }
  Record
    Macro:Array[1..4] of String[240];
  End;

  Smr=                            { SHORTMSG.DAT : One-line messages     }
  Record
    Msg:Astr;                     { Message                              }
    Destin:Integer;               { Destination, -1 to delete            }
  End;

  VDataR=                         { VOTING.DAT : Voting records          }
  Record
    Question:String[75];          { Voting question                      }
    VoteAcs:ACString;             { ACS required to vote                 }
    NumVoted:Word;                { Number of users who have answered    }
    AddedBy:String[35];           { Who added this question              }
    NumChoices:Byte;              { Number of choices                    }
    AddAcs:ACString;              { ACS required to add a choice         }
    Choices:Array[0..NumVoteas] of { Choices available                   }
    Record
      Ans:Array[1..2] of String[65];  { Answer description               }
      NumVoted:Integer;           { Number of votes for this answer      }
    End;
  End;

  LCallers=                       { LASTON.DAT : Today's callers         }
  Record
    CallerNum:Integer;            { System caller number                 }
    Name:String[36];              { User name of caller                  }
    Number:Integer;               { User number of caller                }
    CityState:String[30];         { City/state of caller                 }
    Node:String[3];               { Node of caller                       }
    Baud:String[5];               { Baud of caller                       }
    NewUser:Boolean;              { Is new user?                         }
    Time:String[8];               { Time of call                         }
    res1:Array[1..41] of Byte;    { ** RESERVED ** }
  End;

  EventRec=                       { EVENTS.DAT : Event Records           }
  Record
    Active:Boolean;               { Whether active                       }
    Description:String[30];       { Event description (for logs)         }
    EType:Char;                   { A:CS, C:hat, D:os call, E:xternal    }
    ExecData:String[20];          { Errorlevel if "E", commandline if "D" }
    BusyTime:Integer;             { Off-hook time before; 0 if none      }
    ExecTime:Integer;             { Time of execution                    }
    BusyDuring:Boolean;           { Busy phone during event?             }
    Duration:Integer;             { Length of time event takes           }
    ExecDays:Byte;                { Bitwise execution days or day of month }
    Monthly:Boolean;              { Monthly event?                       }
  End;

  NuvRec=                         { NUV.DAT : New user voting            }
  Record
    NewUserNum:Integer;           { Usernum of newuser being voted on    }
    Votes:Array[1..20] of Record  { Votes (up to 20 users)               }
      Name:String[36];            { User name who voted                  }
      Number:Integer;             { User number of above                 }
      Vote:Byte;                  { Vote - 1=yes, 2=no, 3=abstain        }
      Comment:String[65];         { Comment on user                      }
    End;
  End;

  BbsListRec=                     { BBSLIST.DAT : BBS list               }
  Record
    Ph:String[12];                { Phone number                         }
    Name:String[30];              { BBS name                             }
    Bps:String[5];                { Maximum bps rate                     }
    Mb:String[5];                 { Megabytes online                     }
    Software:String[10];          { BBS software                         }
    Nup:String[15];               { New user password                    }
    Info:String[30];              { Extended info                        }
    BbsDate:String[8];            { Date added/modified last             }
    res1:Array[1..50] of Byte;    { ** RESERVED ** }
  End;

  RumorRec=String[65];            { RUMOR.DAT : Rumors                   }

  WlRec=String[79];               { WANTLIST.DAT : Wantlist              }

(*****************************************************************************)
{ Message boards }

  MbFlags=                        { Msg area flags - stored in BoardRec  }
   (MbVisible,                    { Visible to users without access?     }
    MbRealName,                   { Real names are forced?               }
    MbFilter,                     { Filter ANSI and 8-bit ASCII?         }
    MbStrip,                      { Strip box/centering codes?           }
    MbAddTear,                    { Add tear/origin lines?               }
    MbNoColor,                    { Strip color codes?                   }
    MbNoTwit);                    { Immune to I_ECHO twit?               }

  BoardRec=                       { MBOARDS.DAT : Message base records   }
  Record
    Name:String[40];              { Message base description             }
    Filename:String[8];           { BRD/MIX data filename                }
    LastMsgId:LongInt;            { Last message ID Number               }
    MsgPath:String[40];           { Messages pathname                    }
    Acs,                          { Access requirement                   }
    PostAcs,                      { Post access requirement              }
    SubOpAcs,                     { SubOp access requirement             }
    MciAcs:ACString;              { MCI usage requirement                }
    MaxMsgs:Word;                 { Maximum message count                }
    Anonymous:anontyp;            { Anonymous type                       }
    QwkName:String[12];           { Short name for QWK                   }
    res0:Array[1..8] of Byte;     { ** RESERVED **                       }
    MbStat:Set of MbFlags;        { Message base status                  }
    PermIndx:Byte;                { Permanent index # (used for QWK)     }
    MbType:Integer;               { Base type (0=Local,1=Echo)           }
    Origin:String[50];            { Origin line                          }
    Text_Color,                   { Color of standard text               }
    Quote_Color,                  { Color of quoted text                 }
    Tear_Color,                   { Color of tear line                   }
    Origin_Color:Char;            { Color of origin line                 }
    Zone,                         { Alternate address                    }
    Net,                          { (zone:net/node.point)                }
    Node,                         {      |                               }
    Point:Integer;                {      V                               }
    res1:Array[1..500] of Byte;   { ** RESERVED ** }
  End;

(*****************************************************************************)
{ File boards }

  FbFlags=                        { File area flags - stored in UlRec    }
   (FbNoRatio,                    { No ratio?                            }
    FbUnhidden,                   { Visible to users without access?     }
    FbDirDlPath,                  { If *.DIR file stored in DlPath       }
    Unused,                       { ** UNUSED ** }
    FbUseGifSpecs,                { Insert GIFspecs?                     }
    FbNetlink);                   { Networked?                           }

  UlRec=                          { FBOARDS.DAT : File base records      }
  Record
    Name:String[40];              { Area description                     }
    Filename:String[12];          { Filename + ".DIR"                    }
    DlPath,                       { Download path                        }
    UlPath:String[40];            { Upload path                          }
    MaxFiles:Integer;             { Maximum number of files allowed      }
    res0:Array[1..21] of Byte;    { ** RESERVED ** }
    ArcType,                      { Wanted archive type (1..Max,0=inactive) }
    CmtType:Byte;                 { Wanted comment type (1..3,0=inactive) }
    res1:Array[1..2] of Byte;     { ** RESERVED ** }
    FbStat:Set of FbFlags;        { File base status                     }
    Acs,                          { Access requirements                  }
    UlAcs,                        { Upload requirements                  }
    NameAcs:ACString;             { See-names requirements               }
    PermIndx:LongInt;             { Permanent index #                    }
    res2:Array[1..6] of Byte;     { ** RESERVED ** }
  End;

(*****************************************************************************)
{ File bases }

  FilStat=                        { File flags - stored in UlFRec        }
   (NotVal,                       { If file is NOT validated             }
    IsRequest,                    { If file is REQUEST                   }
    ResumeLater);                 { If file is RESUME-LATER              }

  UlFRec=                         { *.DIR : File Records                 }
  Record
    Filename:String[12];          { Filename                             }
    Description:String[60];       { File description                     }
    FilePoints:Integer;           { File points                          }
    NAcc:Integer;                 { Number of downloads                  }
    Ft:Byte;                      { File type (useless?)                 }
    Blocks:Integer;               { Number of 128 byte blocks            }
    Owner:Integer;                { Uploader of file                     }
    StOwner:String[36];           { Uploader's name                      }
    Date:String[8];               { Date uploaded                        }
    DateN:Integer;                { Numeric date uploaded                }
    VPointer:LongInt;             { Pointer to verbose descr (-1 if none) }
    FileStat:Set of FilStat;      { File status                          }
    res:Array[1..10] of Byte;     { ** RESERVED ** }
  End;

  VerbRec=                        { VERBOSE.DAT : Verbose descriptions   }
  Record
    Descr:Array[1..9] of String[50];
  End;

(*****************************************************************************)
{ Menus }

  mnuflags=                       { Menu flags - stored in MenuRec       }
   (ClrScrBefore,                 { C: Clear screen before menu display  }
    DontCenter,                   { D: Don't center the menu titles      }
    NoMenuPrompt,                 { N: No menu prompt whatsoever?        }
    ForcePause,                   { P: Force a pause before menu display? }
    ClrScrAfter);                 { R: Clear screen after get command    }

  MenuRec=                        { *.MNU : Menu records                 }
  Record                            { mainly used internally }
    MenuName:Array[1..3] of String[100]; { Menu name                     }
    Directive,                    { Help file displayed                  }
    Tutorial,                     { Tutorial help file                   }
    mPromptF:String[12];          { Prompt text file                     }
    MenuPrompt:String[120];       { Menu prompt                          }
    PromptXY:Array[1..2] of Byte; { Prompt X,Y positions (0 if unused)   }
    Acs:ACString;                 { Access requirements                  }
    Password:String[15];          { Password required                    }
    Fallback:String[8];           { Fallback menu                        }
    ForceHelpLevel:Byte;          { Forced help level for menu           }
    GenCols:Byte;                 { Generic menus: # of columns          }
    GCol:Array[1..3] of Char;     { Generic menus: colors                }
    MenuFlags:Set of MnuFlags;    { Menu status variables                }
  End;

  CmdFlags=                       { Command flags - stored in CommandRec }
   (Hidden,                       { H: Is command ALWAYS hidden?         }
    Unhidden);                    { U: Is command ALWAYS visible?        }

  CommandRec=                     { *.MNU : Command Records              }
  Record                            { mainly used internally }
    LDesc:String[70];             { Long command description             }
    SDesc:String[35];             { Short command description            }
    CKeys:String[14];             { Command execution keys               }
    Acs:ACString;                 { Access requirements                  }
    CmdKeys:String[2];            { Command keys                         }
    MString:String[50];           { Command data                         }
    CommandFlags:Set of CmdFlags; { Command status variables             }
  End;

(*****************************************************************************)
{ Protocols }

  XbFlags=                        { Protocol flags - stored in ProtRec   }
   (XbActive,                     { Protocol active?                     }
    XbIsBatch,                    { Batch protocol?                      }
    XbIsResume,                   { Resume protocol?                     }
    XbXferOkCode);                { Read error codes?                    }

  ProtRec=                        { PROTOCOL.DAT - Protocols             }
  Record
    XbStat:Set of XbFlags;        { Protocol flags                       }
    CKeys:String[14];             { Command keys                         }
    Descr:String[40];             { Description                          }
    Acs:ACString;                 { Access string                        }
    TempLog,                      { Temporary log file                   }
    UloadLog,DloadLog:String[25]; { Permanent log files                  }
    UlCmd,DlCmd:String[78];       { Upload/download commandlines         }
    UlCode,DlCode:Array [1..6] of String[6]; { UL/DL codes               }
    Envcmd:String[60];            { Environment setup command            }
    DlFList:String[25];           { Batch download file list             }
    MaxChrs:Integer;              { Maximum characters on commandline    }
    LogPf,LogPs:Integer;          { position in log file for data        }
    PermIndx:LongInt;             { Permanent index number               }
    res:Array[1..11] of Byte;     { ** RESERVED ** }
  End;

(*****************************************************************************)
{ Networks }

  FidoRec=                        { NETWORK.DAT : Network information    }
  Record
    Zone,                         { Default network zone number          }
    Net,                          { Default network net number           }
    Node,                         { Default network node number          }
    Point:Integer;                { Default netowrk point number         }
    Origin:String[50];            { Default origin line                  }
    MailPath,                     { Base mail path                       }
    EchoToss,                     { Echomail toss command                }
    EchoScan:String[40];          { Echomail scan command                }
    Text_Color:Char;              { Color of standard text               }
    Quote_Color:Char;             { Color of quoted text                 }
    Tear_Color:Char;              { Color of tear line                   }
    Origin_Color:Char;            { Color of origin line                 }
    Strip:Boolean;                { Strip centering codes?               }
    AddTear:Boolean;              { Add tear/origin lines?               }
    LogName:String[40];           { Log filename                         }
    PostProcCmd:String[40];       { Command to run when finished         }
    res:Array[1..1896] of Byte;   { ** RESERVED ** }
  End;

(*****************************************************************************)
{ Teleconference }

  NameStr=String[36];

  EachNodeRec=                    { TELECONF.USR : Users in teleconference }
  Record
    Name,                         { Name of user                         }
    Channel:NameStr;              { Channel name                         }
    CbChannel:Word;               { Current C.B. channel                 }
    Invisible,                    { Invisible?                           }
    ShowAll:Boolean;              { ???                                  }
  End;

  EachLine=                       { TELEDATA.### : Messages to node      }
  Record
    Data:String[160];             { Message                              }
    DataFor:                      { Message destination                  }
      (Channel,                   { Message for main channel             }
       CbChannel,                 { Message for C.B. channel             }
       Sent);                     { A message sent message               }
  End;

  ActionRec=                      { ACTION.DAT : Teleconference actions  }
  Record
    Act:String[25];               { Action name, ie: "spit"              }
    ObjectMsg,                    { Message sent to object of action     }
    GlobalMsg,                    { Message sent to everyone else        }
    YourMsg,                      { Message sent to sender of action     }
    NoObject:String[80];          { Message sent to everyone if no obj.  }
  End;

(*****************************************************************************)
{ Validation }

  ValRec=                         { AUTOVAL.DAT : Autovalidation profiles  }
  Record                            { 1 - 26 }
    Name:String[30];              { Validation profile name                }
    Sl,                           { Security level                         }
    Dsl:Byte;                     { Download security level                }
    Ar:Set of acrq;               { AR flags                               }
    Ac:Set of uflags;             { AC flags                               }
    Fp:Integer;                   { File points                            }
    Credit:LongInt;               { Credit                                 }
    uNote:String[20];             { User note                              }
    AcType,                       { AC flags are hard/soft                 }
    ArType:Boolean;               { AR flags are hard/soft                 }
  End;

(*******************************[ END OF FILE ]*******************************)
