(* Version 1 Developmental Kit
Ŀ
                                                                             
 Description: Sample Procedures/Functions to read HYPE.IDF and other miscell-
              aneous things.                                                 
       Notes: Modifications WILL be required.  Expect to change things.      
              This code is a bit choppy.  Feel free to modify and distribute 
              your changes.                                                  

*)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
Unit HypeDev;

Interface

{$I HYPEREC.PAS}

Var
  Local,                      { Is Program running in LOCAL mode? }
  OutCom:boolean;             { Is the comport open and sending? }
  Driver:integer;             { FOSSIL=0, INTERNAL:=1, LOCAL:=2 }

{IDF Variables}
  ComDriver:string[8];        { driver in use.  FOSSIL or INTERNAL }
  ComPort:byte;               { comport number (0=Local)}
  IrqNumb:byte;               { irq number 0-7 (255 for none) }
  InOutBuffer:word;           { modem in/out buffer size }
  BPSrate:longint;            { baud rate}
  Version:string[3];          { hype version number }
  BBSName:astr;               { bbs name }
  SYSName:astr;               { sysop name }
  UserName:astr;              { User's handle }
  RealName:astr;              { user's real name }
  UserPW:astr;                { user's password }
  SecurityLVL:integer;        { user's sl level }
  DownloadLVL:integer;        { user's dsl level }
  FilePts:integer;            { user's file points }
  EmulationTyp:string[4];     { ANSI, or AVT }
  Uploads:integer;            { user's # of uploads }
  Downloads:integer;          { user's # of downloads }
  Upl_K:integer;              { # of KB uploaded }
  Dnl_K:integer;              { # of KB downloaded }
  CurrTime:string[5];         { current time }
  TimeLeft:integer;           { # of minutes user has left online }


Procedure Initialize; {Initialized com ports and other vars}
Procedure HDF_Read(Fn:String); {FN = Path/Filename}
Function String2Num(s:string):longint; {Converts string expression to # value}
Function Num2String(i:longint):string; {Converts longint to string expression}
Procedure ColorCodes(s:string); {Parses PIPE (|01, |B7) codes}

Implementation

Uses Crt, Dos, HypeCom;

{This should be one of the first things called after HDF_read.}

Procedure Initialize;
var anyerrors:word;
begin
  outcom:=false;
  local:=false;
  if (comport=0) then
  begin
    outcom:=false;
    local:=true;
    writeln('Initializing Local Mode.');
  end else
  begin
    driver:=0;
    local:=false;
    if (comdriver='LOCAL') then local:=true;
    if (com_installed) then com_deinstall;
    if (comdriver='FOSSIL') then driver:=0 else
      driver:=1;
    if (driver=0) then com_install(comport,anyerrors,true) else
      if (driver=1) then com_install(comport,anyerrors,false);
    if (not local) then begin
      com_set_parity(com_none,1);
      com_set_speed(bpsrate);
    end;
  end; {else}
end; {initialize}

Procedure HDF_Read(Fn:String);
Var HDF:text;
    s:string;
begin
  assign(hdf,fn);
  {$I-} reset(hdf); {$I+}
  if (ioresult<>0) then
  begin
    colorcodes('|07"'+fn+'" not found.|NLAborting...');
    exit;
  end else
  begin
    readln(hdf,s);
    comdriver:=copy(s,15,length(s));
    readln(hdf,s);
    comport:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    irqnumb:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    inoutbuffer:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    bpsrate:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    version:=copy(s,15,length(s));
    readln(hdf,s);
    bbsname:=copy(s,15,length(s));
    readln(hdf,s);
    sysname:=copy(s,15,length(s));
    readln(hdf,s);
    username:=copy(s,15,length(s));
    readln(hdf,s);
    realname:=copy(s,15,length(s));
    readln(hdf,s);
    userpw:=copy(s,15,length(s));
    readln(hdf,s);
    securitylvl:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    downloadlvl:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    filepts:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    emulationtyp:=copy(s,15,length(s));
    readln(hdf,s);
    uploads:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    downloads:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    upl_k:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    dnl_k:=string2num(copy(s,15,length(s)));
    readln(hdf,s);
    currtime:=copy(s,15,length(s));
    readln(hdf,s);
    timeleft:=string2num(copy(s,15,length(s)));
    close(hdf);
    writeln(fn+' Imported and Evaluated.');
  end;
end;

Function String2Num(s:string):longint;
var i:longint;
    j:integer;
begin
  Val(s,i,j);
  if (j<>0) then begin
    s:=copy(s,1,j-1);
    Val(s,i,j)
  end;
  String2Num:=i;
  if (s='') then String2Num:=0;
end;

Function Num2String(i:longint):string;
var c:string[16];
begin
  Str(i,c);
  Num2String:=c;
end;

{This Procedure will HAVE to be changed to suit your ansi emulator, and to
 send to the comport}

procedure ColorCodes(s:string);
var x:integer;
    a,first,second:string;
begin
  x:=1;
  while x <= length(s) do begin
  case s[x] of
    '|':begin
    x:=x + 1;
    first:=copy(s,x,1);
    second:=copy(s,x+1,1);
    a:=(upcase(first[1]))+(upcase(second[1]));
    if x <= length(s) then begin
    If
    a='U0' then cl(0) else if
    a='U1' then cl(1) else if
    a='U2' then cl(2) else if
    a='U3' then cl(3) else if
    a='U4' then cl(4) else if
    a='U5' then cl(5) else if
    a='U6' then cl(6) else if
    a='U7' then cl(7) else if
    a='U8' then cl(8) else if
    a='U9' then cl(9) else if
    a='B0' then textbackground(0) else if
    a='B1' then textbackground(1) else if
    a='B2' then textbackground(2) else if
    a='B3' then textbackground(3) else if
    a='B4' then textbackground(4) else if
    a='B5' then textbackground(5) else if
    a='B6' then textbackground(6) else if
    a='B7' then textbackground(7) else if
    a='00' then textcolor(0) else if
    a='01' then textcolor(1) else If
    a='02' then textcolor(2) else if
    a='03' then textcolor(3) else if
    a='04' then textcolor(4) else if
    a='05' then textcolor(5) else if
    a='06' then textcolor(6) else if
    a='07' then textcolor(7) else if
    a='08' then textcolor(8) else if
    a='09' then textcolor(9) else if
    a='10' then textcolor(10) else if
    a='11' then textcolor(11) else if
    a='12' then textcolor(12) else if
    a='13' then textcolor(13) else if
    a='14' then textcolor(14) else if
    a='15' then textcolor(15) else if
    a='16' then textbackground(0) else if
    a='17' then textbackground(1) else if
    a='18' then textbackground(2) else if
    a='19' then textbackground(3) else if
    a='20' then textbackground(4) else if
    a='21' then textbackground(5) else if
    a='22' then textbackground(6) else if
    a='23' then textbackground(7) else if
    a='NL' then begin
                  writeln;
                  if (outcom) then begin com_tx(^M); com_tx(^J); end;
                end;
    end; {x <= length(s)}
    x:=x + 2;
    end else begin
    if (outcom) then com_tx(s[x]);
    write(s[x]); {WriteAnsi should be replaced by your ansi driver calls}
    x:=x + 1;
    end; {'|'}
  end; {case}
  end; {while x <= length(s) do begin}
end;

End. {End of HYPEDEV.PAS}
