

(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2D .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "D" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2d;

interface

uses
  crt, dos, overlay,
  common;

procedure pogenvar;

implementation

procedure pogenvar;
var c:char;
    i:integer;
    bbb:byte;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint('^2[ ^9System Variables ^2]');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr(#3#5'['+#3#3+'A'+#3#5+']. Max private sent per call: '+mn(maxprivpost,3)+
        '  ['+#3#3+'B'+#3#5+']. Max feedback sent per call: '+mn(maxfback,3),abort,next);
      printacr(#3#5'['+#3#3+'C'+#3#5+']. Max public posts per call: '+mn(maxpubpost,3)+
        '  ['+#3#3+'D'+#3#5+']. Max chat attempts per call: '+mn(maxchat,3),abort,next);
      printacr(#3#5'['+#3#3+'E'+#3#5+']. Normal max mail waiting  : '+mn(maxwaiting,3)+
        '  ['+#3#3+'F'+#3#5+']. CoSysOp max mail waiting  : '+mn(csmaxwaiting,3),abort,next);
      printacr(#3#5'['+#3#3+'G'+#3#5+']. Normal max lines/message : '+mn(maxlines,3)+
        '  ['+#3#3+'H'+#3#5+']. CoSysOp max lines/message : '+mn(csmaxlines,3),abort,next);
      printacr(#3#5'['+#3#3+'I'+#3#5+']. Number of logon attempts : '+mn(maxlogontries,3)+
        '  ['+#3#3+'J'+#3#5+']. Backspace delay           : '+mn(bsdelay,3),abort,next);
      printacr(#3#5'['+#3#3+'K'+#3#5+']. SysOp chat color         : '+mn(sysopcolor,3)+
        '  ['+#3#3+'L'+#3#5+']. User chat color           : '+mn(usercolor,3),abort,next);
      printacr(#3#5'['+#3#3+'M'+#3#5+']. Min. space for posts     : '+mn(minspaceforpost,4)+
        ' ['+#3#3+'N'+#3#5+']. Min. space for uploads    : '+mn(minspaceforupload,4),abort,next);
      printacr(#3#5'['+#3#3+'O'+#3#5+']. Back SysOp Log keep days : '+mn(backsysoplogs,3)+
        '  ['+#3#3+'P'+#3#5+']. Minutes till screen saver : '+mn(wfcblanktime,4),abort,next);
      printacr(#3#5'['+#3#3+'R'+#3#5+']. Default video line length: '+mn(linelen,3)+
        '  ['+#3#3+'S'+#3#5+']. Default video page length : '+mn(pagelen,3),abort,next);
      nl;
      prt('Enter selection (A-S) [Q]uit : ');
      onek(c,'QABCDEFGHIJKLMNOPRS'^M); nl;

      case c of
        'Q':done:=TRUE;
        'A'..'P','R'..'S':
          begin
            prt('Range ');
            case c of
              'G','H':prt('(1-160)');
              'K','L':prt('(0-9)');
              'M','N':prt('(0-32767)');
              'O':prt('(1-99)');
              'R':prt('(32-132)');
              'S':prt('(4-50)');
            else
                  prt('(0-255)');
            end;
            nl; prt('New value: ');
            case c of
              'M','N':inu(i);
            else
                 ini(bbb);
            end;
            if (not badini) then
              case c of
                'A':maxprivpost:=bbb;
                'B':maxfback:=bbb;
                'C':maxpubpost:=bbb;
                'D':maxchat:=bbb;
                'E':maxwaiting:=bbb;
                'F':csmaxwaiting:=bbb;
                'G':if (bbb in [1..255]) then maxlines:=bbb;
                'H':if (bbb in [1..255]) then csmaxlines:=bbb;
                'I':maxlogontries:=bbb;
                'J':bsdelay:=bbb;
                'K':if (bbb in [0..9]) then sysopcolor:=bbb;
                'L':if (bbb in [0..9]) then usercolor:=bbb;
                'M':if (i>0) then minspaceforpost:=i;
                'N':if (i>0) then minspaceforupload:=i;
                'O':if (bbb in [1..99]) then backsysoplogs:=bbb;
                'P':if (bbb in [0..255]) then wfcblanktime:=bbb;
                'R':if (bbb in [32..132]) then linelen:=bbb;
                'S':if (bbb in [4..50]) then pagelen:=bbb;
              end;
          end;
      end;
    end;
  until (done) or (hangup);
end;

end.
