(*****************************************************************************)
(*>                                                                         <*)
(*>  MISC2   .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  Various miscellaneous functions used by the BBS.                       <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit misc2;

interface

uses
  crt, dos, overlay,
  common,
  file2;

procedure pstat;
procedure bulletins(par:astr);
procedure abbs;
procedure ansig(x,y:integer);
procedure yourinfo;
procedure tfiles;
procedure ulist;
procedure seementalnote;
procedure addmentalnote;
procedure userconfig;
procedure seeyesvotes;
procedure seenovotes;

implementation

procedure pstat;
var c:char;
begin
  outkey(^L);
  with systat do begin
    print('New User Pass   : '+newuserpw);
    prompt('Board is        : '); if (closedsystem) then print('Closed') else print('Open');
    print('Number Users    : '+cstr(numusers));
    print('Number calls    : '+cstr(callernum));
    print('Date & Time     : '+dat);
    print('Active today    : '+cstr(systat.todayzlog.active));
    print('Calls today     : '+cstr(systat.todayzlog.calls));
    print('Messages today  : '+cstr(systat.todayzlog.pubpost));
    print('Email sent today: '+cstr(systat.todayzlog.privpost));
    print('Feed back today : '+cstr(systat.todayzlog.fback));
    print('Uploads today   : '+cstr(systat.todayzlog.uploads));
    prompt('Sysop           : '+aonoff(sysop,fstring.sysopin,fstring.sysopout));
    print('Disk free space : '+cstrl(freek(0))+'k');
    prompt('Sysop hours     : ');
    if (lowtime=hitime) then print('None')
    else
      print(tch(cstr(lowtime div 60))+':'+tch(cstr(lowtime mod 60))+' to '+
                tch(cstr(hitime div 60))+':'+tch(cstr(hitime mod 60)));

  end;
  if (not useron) then begin
    nl; nl; print('Hit any key');
    getkey(c);
  end;
end;

procedure bulletins(par:astr);
var filv:text;
    main,subs,s:astr;
    i:integer;
begin
  nl;
  if (par='') then
    if (systat.bulletprefix='') then
      par:='bulletin;bullet'
    else
      par:='bulletin;'+systat.bulletprefix;
  if (pos(';',par)<>0) then begin
    main:=copy(par,1,pos(';',par)-1);
    subs:=copy(par,pos(';',par)+1,length(par)-pos(';',par));
  end else begin
    main:=par;
    subs:=par;
  end;
  printf(main);
  if (not nofile) then
    repeat
      i:=8-length(subs); if (i<1) then i:=1;
      prt(fstring.bulletinline);
      input(s,i); s:=sqoutsp(s);
      if (not hangup) then begin
        if (s='') then s:='Q';
        if (s='?') then printf(main);
        if ((s<>'Q') and (s<>'?') and (s<>'')) then printf(subs+s);
      end;
    until ((s='Q') or (hangup));
end;

procedure abbs;
var filvar:text;
    s,i1,i2:astr;
    c:char;
    tf:text;
    there,abort,next:boolean;
begin
  abort:=FALSE; next:=FALSE;
  if (not (ramsg in thisuser.ac)) then begin
    nl;
    begin
      repeat
        redrawforansi;
        cls;
        nl;
        sprint('^3Enter the BBS phone number.');
        sprint('^4Ie. (^0###^4-^0###^4-^0####^4)');
        prt(': '); mpl(12); input(i1,12);
      until (length(i1)=12) or (i1='') or hangup;
      assign(tf,systat.afilepath+'bbslist.msg');
      {$I-} reset(tf); {$I+}
      nofile:=(ioresult<>0);
      there:=FALSE;
      if (not nofile) then begin
        while not eof(tf) do begin
          readln(tf,s);
          if (copy(s,1,12)=i1) then there:=TRUE;
        end;
        close(tf);
      end;
      if (there) then begin
        nl;
        if (i1<>'') then sprint(#3#7+'It''s already in there mon!');
        i1:='';
      end;
      s:=i1;
      if (s<>'') then begin
        nl;
        sprint('^3Enter the name of the BBS.');
        sprint('^4Ie. (^0'+systat.bbsname+'^4)');
        prt(': '); mpl(41); inputl(i1,41);
        s:=mln(s+'  '+#3#0+i1,56);
        nl;
        sprint('^3Enter the maximum modem speed of the BBS.');
        sprint('^4Ie. (^01200, 2400, 9600, 14.4, Etc.,^4)');
        prt(': '); mpl(4); input(i2,4);
        if (i2='') then s:=s+'        '
        else
          s:=s+#3#4+'  ['+#3#3+i2+#3#4+']';
        if (i1<>'') then begin
          nl;
          sprint('^3Enter the program that the BBS is using.');
          sprint('^4Ie. (^0Genesis, Vision-X, Etc.,^4)');
          prt(': ');
          mpl(8);
          input(i1,8);
          if (i1<>'') then
            if copy(i1,1,3)<>'GENESIS' then s:=s+#3#4+' ['+#3#5+i1+#3#4+']'
                                       else s:=s+#3#4+' ['+#3#3+i1+#3#4+']';
          nl;
          printacr(s,abort,next);
          nl;
          if pynq('Is this correct (No)? ') then begin
            assign(filvar,systat.afilepath+'bbslist.msg');
            {$I-} append(filvar); {$I+}
            if (ioresult<>0) then begin
              assign(filvar,systat.afilepath+'bbslist.msg');
              rewrite(filvar);
            end;
            writeln(filvar,s);
            close(filvar);
            sysoplog('Added to BBS list: ');
            sl1(s);
          end;
        end;
      end;
    end;
  end
  else sprint(#3#7+'You are restricted from adding to the BBS list.');
end;

procedure ansig(x,y:integer);
begin
  if (spd<>'KB') then pr1(#27+'['+cstr(y)+';'+cstr(x)+'H');
  if (wantout) then gotoxy(x,y);
  pap:=0;
end;

procedure yourinfo;
var ddt,dt:datetimerec;
    i:integer;

  function istr(i:integer):astr;
  var s:astr;
  begin
    with thisuser do

      case i of
        1:s:=caps(name);
        2:s:=ph;
        3:s:=cstr(sl)+' SL';
        4:s:=cstr(dsl)+' DSL';
        5:s:=cstr(1+loggedon)+' calls';
        6:s:=cstr(ontoday)+' calls';
        7:s:=cstr(msgpost)+' posts';
        8:s:=cstr(emailsent+feedback)+' letters';
        9:begin
            s:=cstr(waiting)+' letter';
            if (waiting>1) then s:=s+'s';
          end;
       10:begin
            getdatetime(dt);
            timediff(ddt,timeon,dt);
            s:=ctim(dt2r(ddt));
          end;
       11:begin
            getdatetime(dt);
            timediff(ddt,timeon,dt);
            s:=cstrl(trunc(ttimeon+dt2r(ddt)))+' min.';
          end;
       12:s:=laston;
      end;
    istr:=s;
  end;

 begin
  redrawforansi;
  cls;
  with thisuser do begin
      nl;
      sprint('^4      [ ^3User Information ^4]       ');
      nl;
      sprint('^5Alias/Name                ^4 ^3'+name);
      sprint('^5Real Name                 ^4 ^3'+realname);
      sprint('^5Public Note               ^4 ^3'+note);
      sprint('^5Phone Number              ^4 ^3'+ph);
      sprint('^5Security Level            ^4 ^3'+cstr(sl)+' SL');
      sprint('^5Download Security Level   ^4 ^3'+cstr(dsl)+' DSL');
      sprint('^5File Points               ^4 ^3'+cstr(filepoints));
      sprint('^5Number of Times On        ^4 ^3'+cstr(1+thisuser.loggedon));
      sprint('^5On Today                  ^4 ^3'+cstr(thisuser.ontoday));
      sprint('^5Public Posts              ^4 ^3'+cstr(thisuser.msgpost));
      sprint('^5E-mail Sent               ^4 ^3'+cstr(thisuser.emailsent+thisuser.feedback));
      sprint('^5Mail Waiting              ^4 ^3'+istr(9));
      sprint('^5Time on Today             ^4 ^3'+istr(10));
      sprint('^5Total Time Ever           ^4 ^3'+istr(11));
      sprint('^5Last Called               ^4 ^3'+istr(12));
      nl;
     end;
end;

procedure tfiles;
var gfil:file of tfilerec;
    b:tfilerec;
    gftit:array[1..150] of record
      tit:string[40];
      arn:integer;
      gfile:boolean;
      acs:acstring;
      gdaten:integer;
    end;
    titl,s:astr;
    t,c,lgftn,lgftnt,numgft:integer;
    abort,next,deep,xexit:boolean;

  procedure gettit(n:integer);
  var b:tfilerec;
      r:integer;
  begin
    redrawforansi;
    cls;
    nl;
    numgft:=0;
    if n>0 then begin
      seek(gfil,n); read(gfil,b); titl:=b.title;
    end else titl:=#3#4+'͵ '+#3#3+'Text File Conference Selection';
    r:=n+1;
    if r<=t then begin
      seek(gfil,r); read(gfil,b);
      while (r<=t) and (b.filen[1]<>#1) do begin
        if (aacs(b.acs)) then begin
          inc(numgft);
          with gftit[numgft] do begin
            tit:=b.title;
            arn:=r;
            gfile:=TRUE;
            gdaten:=b.gdaten;
          end;
        end;
        inc(r);
        if (r<=t) then begin seek(gfil,r); read(gfil,b); end;
      end;
    end;
    if n=0 then
      while (r<=t) do begin
        seek(gfil,r); read(gfil,b);
        if ((b.filen[1]=#1) and (aacs(b.acs))) then begin
          inc(numgft);
          with gftit[numgft] do begin
            tit:=b.title;
            arn:=r;
            gfile:=FALSE;
            gdaten:=b.gdaten;
          end;
        end;
        inc(r);
      end;
  end;

  procedure lgft;
  var abort,next:boolean; c:integer;
  begin
    nl; sprint(#3#3+titl); nl;
    if numgft=0 then print('No Tfiles.') else begin
      abort:=FALSE; next:=FALSE; c:=1;
      while (c<=numgft) and (not abort) do begin
        s:=#3#5+cstr(c)+#3#6+' : '+#3#5+gftit[c].tit;
        if (gftit[c].gdaten>=daynum(thisuser.laston)) then s:=#3#8+''+s
          else s:=' '+s;
        printacr(s,abort,next);
        inc(c);
      end;
    end;
  end;

  procedure scaninput(var s:string; allowed:string);
  var os:string;
      i:integer;
      c:char;
      gotcmd:boolean;
  begin
    gotcmd:=FALSE; s:='';
    repeat
      getkey(c); c:=upcase(c);
      os:=s;
      if ((pos(c,allowed)<>0) and (s='')) then begin gotcmd:=TRUE; s:=c; end
      else
      if (pos(c,'0123456789')<>0) then begin
        if (length(s)<5) then s:=s+c;
      end
      else
      if ((s<>'') and (c=^H)) then s:=copy(s,1,length(s)-1)
      else
      if (c=^X) then begin
        for i:=1 to length(s) do prompt(^H' '^H);
        s:=''; os:='';
      end
      else
      if (c=#13) then gotcmd:=TRUE;

      if (length(s)<length(os)) then prompt(^H' '^H);
      if (length(s)>length(os)) then prompt(copy(s,length(s),1));
    until ((gotcmd) or (hangup));
    nl;
  end;

  procedure extracttfile;
  var dirinfo:searchrec;
      s,s2:string;
      lng,numfiles,tsiz:longint;
      i:integer;
      found,nospace,ok:boolean;
  begin
    nl;
    sprint(#3#0+'Extract text file to temporary directory.');
    nl;
    sprompt(#3#5+'Already in TEMP: ');
    numfiles:=0; tsiz:=0;
    findfirst(systat.temppath+'3\*.*',anyfile-dos.directory,dirinfo);
    found:=(doserror=0);
    while (found) do begin
      inc(tsiz,dirinfo.size);
      inc(numfiles);
      findnext(dirinfo);
      found:=(doserror=0);
    end;
    if (numfiles=0) then sprint(#3#7+'Nothing!')
      else sprint(#3#6+cstrl(numfiles)+' files totalling '+cstrl(tsiz)+' bytes.');

    if (not fso) then begin
      print('The limit is '+cstrl(systat.maxintemp)+'k bytes.');
      lng:=systat.maxintemp; lng:=lng*1024;
      if (tsiz>lng) then begin
        nl;
        sprint(#3#0+'You have exceeded this limit.');
        nl;
        sprint(#3#0+'Please remove some files from the TEMP directory using');
        sprint(#3#0+'the user-archive command to free up some space.');
        exit;
      end;
    end;

    nl;
    prt('Text file number to copy?: ');
    scaninput(s,'');
    if ((hangup) or (s='')) then exit;
    i:=value(s);
    if ((i>=1) and (i<=numgft)) then
      if (gftit[i].gfile) then begin
        seek(gfil,gftit[i].arn); read(gfil,b);
        s:=systat.tfilepath+b.filen;
        s2:=systat.temppath+'3\'+b.filen;
        sprompt(#3#5+'Progress: ');
        copyfile(ok,nospace,TRUE,s,s2);
        if (ok) then
          sprint(#3#5+' - Copy successful.')
        else
          if (nospace) then
            sprint(#3#7+'Copy unsuccessful - insufficient space!')
          else
            sprint(#3#7+'Copy unsuccessful!');
        sysoplog('User copied t-file "'+b.filen+'" into TEMP directory.');
      end;
  end;

begin
  nl;
  assign(gfil,systat.gfilepath+'gfiles.dat');
  {$I-} reset(gfil); {$I+}
  if ioresult<>0 then begin
    rewrite(gfil);
    b.gdaten:=0;
    write(gfil,b);
  end;
  seek(gfil,0); read(gfil,b); t:=b.gdaten;
  abort:=FALSE; next:=FALSE;
  if (t=0) then sprint(#3#7+'No Text files available today!')
  else begin
    gettit(0); xexit:=FALSE;
    lgft; lgftn:=0; deep:=FALSE; lgftnt:=0;
    repeat
      nl;
      if (next) then begin
        next:=FALSE; s:='';
        sprint(#3#5+'=[ Skipped to next ]=');
        nl;
      end else begin
sprompt('^4[^5'+cstr(lgftn)+'^4] ^5Text files : ^4[^51-'+cstr(numgft)+', ^6?^5=Options, ^6Q^5=Quit, ^6CR^5=Next^4] ^3: ');
        cl(5); scaninput(s,'Q?');
        nl;
      end;
      if (s='') then
        if (lgftn=numgft) then s:='Q' else s:=cstr(lgftn+1);
      if (s='?') then lgft;
      if (s='Q') then
        if (deep) then begin
          deep:=FALSE;
          gettit(0);
          lgft;
          lgftn:=lgftnt;
        end else
          xexit:=TRUE;
      { if (s='X') then extracttfile; }

      c:=value(s);
      if ((c>0) and (c<=numgft)) then begin
        if (gftit[c].gfile) then begin
          seek(gfil,gftit[c].arn);
          read(gfil,b);
          if (pos('.',b.filen)<>0) then
            pfl(systat.tfilepath+b.filen,abort,next,TRUE)
          else printf(systat.tfilepath+b.filen);
          lgftn:=c;
        end else begin
          gettit(gftit[c].arn);
          lgftn:=c;
          if (numgft>0) then begin
            lgft;
            lgftnt:=c; lgftn:=0;
            deep:=TRUE;
          end else begin
            gettit(0);
            nl;
            sprint(#3#7+'No Text files there!');
            nl;
          end;
        end;
      end;
    until ((xexit) or (hangup));
  end;
  close(gfil);
end;

procedure ulist;
const sepr2=#3#4+':'+#3#3;
var u:userrec;
    sr:smalrec;
    s:astr;
    i,j:integer;
    abort,next,sfo:boolean;
begin
  CLS;
  sfo:=(filerec(sf).mode<>fmclosed);
  if (not sfo) then reset(sf);
  nl;
  loadboard(board);
  sprint(#3#9+'Users with access to "'+#3#5+memboard.name+#3#9+'"');
  nl;
  sprint(#3#0+'User Name                 '+sepr2+
         'Computer Type                '+sepr2+'Sex'+sepr2+'Last on');
  sprint(#3#4+':::');
  reset(uf);

  i:=0; j:=0;
  abort:=FALSE;
  while (not abort) and (i<filesize(sf)-1) do begin
    inc(i);
    seek(sf,i); read(sf,sr); seek(uf,sr.number); read(uf,u);
    if (aacs1(u,sr.number,memboard.acs)) then begin
      printacr(#3#3+mln(caps(sr.name)+' #'+cstr(sr.number),26)+' '+
               mln(u.computer,30)+#3#3+' '+u.sex+'  '+u.laston,abort,next);
      inc(j);
    end;
  end;
  if (not abort) then begin
    nl;
    s:=' User';
    if (j<>1) then s:=s+'s';
    s:=s+'.';
    sprint(#3#4+':::');
    printacr(#3#7+' '+#3#5+cstr(j)+s,abort,next);
  end;
  close(uf);
  if (not sfo) then close(sf);
end;

procedure seementalnote;
begin
cls;
nl;
sprint(#27+'[0;1m');
sprint(#27+'[0;30;47m Mental Note Of The Day ');
sprint(#27+'[1;40m');
printf('mental.msg');
  nl;
end;

procedure addmentalnote;
var
s:string;
hi:text;
g:string[80];
i:integer;
begin
with fstring do
              begin
              nl;
              if pynq('Do you want to write a new Mental Note (No)? ') then
              begin
              Cls;
              nl;
              sprint(Fstring.Addmental);
              prt(#3#2': '#3#3);
              inputwc(s,59);
              if (s='') then
              begin
              nl;
              sprint(#3#7+'Mental Note not saved!');
              nl;
            end else
            begin
            sprompt(#3#7+'Saving, please wait ...');
            g:=#3#5+'"'+s+#3#5+'"';
            assign(hi,systat.afilepath+'mental.msg');
            {$I-} append(hi); {$I+}
            if (ioresult<>0) then begin
              assign(hi,systat.afilepath+'mental.msg');
              rewrite(hi);
            end;
      rewrite(hi);
      writeln(hi,G);
      close(hi);
      sprint(#3#7+' Done.');
        sysoplog(#3#6+'Added New Mental Note. > "'+#3#7+s+#3#6+'"');
            nl;
           end;
     end;
  end;
end;

procedure seeyesvotes;
begin
nl;
if pynq('View users that voted Yes for you (No)? ') then
             begin
                 redrawforansi;
                 cls;
                 sprint(#3#4+' '+#3#0+'Users that voted '+#3#1+'Yes '+#3#0+'for : '+#3#3+caps(thisuser.name));
                 nl;
                 sprint(#3#4+'('+#3#9+'1'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.votera));
                 sprint(#3#4+'('+#3#9+'2'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.voterb));
                 sprint(#3#4+'('+#3#9+'3'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.voterc));
                 sprint(#3#4+'('+#3#9+'4'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.voterd));
                 sprint(#3#4+'('+#3#9+'5'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.votere));
                 nl;
end;
end;

procedure seenovotes;
begin
nl;
if pynq('View users that voted No for you (No)? ') then
             begin
                 redrawforansi;
                 cls;
                 sprint(#3#4+' '+#3#0+'Users that voted '+#3#1+'No '+#3#0+'for : '+#3#3+caps(thisuser.name));
                 nl;
                 sprint(#3#4+'('+#3#9+'1'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.voterf));
                 sprint(#3#4+'('+#3#9+'2'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.voterg));
                 sprint(#3#4+'('+#3#9+'3'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.voterh));
                 sprint(#3#4+'('+#3#9+'4'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.voteri));
                 sprint(#3#4+'('+#3#9+'5'+#3#4+')'+#3#9+'. '+#3#3+caps(thisuser.voterj));
                 nl;
end;
end;

procedure userconfig;
var
c:char;
s:astr;
BB:byte;
Done:Boolean;
begin
With Thisuser Do
Begin
Thisuser.ac:=Thisuser.ac-[pause];
repeat
redrawforansi;
CLS;
ansig(1,1);
sprint(#3#4+'[^0Genesis User Config^4]Ŀ');
ansig(1,2);
sprint(#3#4+' '+#3#3+'[1].'+#3#5+'Real Name  '+#3#2+': ');
ansig(1,3);
sprint(#3#4+' '+#3#3+'[2].'+#3#5+'Alias      '+#3#2+': ');
ansig(1,4);
sprint(#3#4+' '+#3#3+'[3].'+#3#5+'Phone #    '+#3#2+': ');
ansig(1,5);
sprint(#3#4+' '+#3#3+'[4].'+#3#5+'Address    '+#3#2+': ');
ansig(1,6);
sprint(#3#4+' '+#3#3+'[5].'+#3#5+'Password   '+#3#2+': ');
ansig(1,7);
sprint(#3#4+' '+#3#3+'[6].'+#3#5+'City,State '+#3#2+': ');
ansig(1,8);
sprint(#3#4+' '+#3#3+'[7].'+#3#5+'Birthdate  '+#3#2+': ');
ansig(1,9);
sprint(#3#4+' '+#3#3+'[8].'+#3#5+'Occuptaion '+#3#2+': ');
ansig(1,10);
sprint(#3#4+' '+#3#3+'[9].'+#3#5+'Reference  '+#3#2+': ');
ansig(1,11);
sprint(#3#4+' '+#3#3+'[A].'+#3#5+'Public Note'+#3#2+': ');
ansig(1,12);
sprint(#3#4+' '+#3#3+'[B].'+#3#5+'Screen Size'+#3#2+': ');
ansig(1,13);
sprint(#3#4+' '+#3#3+'[C].'+#3#5+'Computer   '+#3#2+': ');
ansig(1,14);
sprint(#3#4+'');
ansig(1,15);
sprint('^5Note   : ^4[^0ONLINE^4]');
ansig(52,2);
 sprint(#3#4+'');
ansig(52,3);
 sprint(#3#4+'');
 ansig(52,4);
 sprint(#3#4+'');
 ansig(52,5);
 sprint(#3#4+'');
 ansig(52,6);
 sprint(#3#4+'');
 ansig(52,7);
 sprint(#3#4+'');
 ansig(52,8);
 sprint(#3#4+'');
 ansig(52,9);
 sprint(#3#4+'');
 ansig(52,10);
 sprint(#3#4+'');
 ansig(52,11);
 sprint(#3#4+'');
 ansig(52,12);
 sprint(#3#4+'');
 ansig(52,13);
 sprint(#3#4+'');

cl(6);
ansig(19,2);
sprompt(Thisuser.Realname);
ansig(19,3);
sprompt(Thisuser.Name);
ansig(19,4);
sprompt(Thisuser.Ph);
ansig(19,5);
sprompt(Thisuser.Street);
ansig(19,6);
sprompt(Thisuser.Pw);
ansig(19,7);
sprompt(Thisuser.CityState);
ansig(19,8);
sprompt(Thisuser.Bday);
ansig(19,9);
sprompt(Thisuser.Occupation);
ansig(19,10);
sprompt(Thisuser.WhereBBS);
ansig(19,11);
sprompt(Thisuser.note);
ansig(19,12);
cl(6);
sprompt(cstr(Thisuser.linelen)+'x'+cstr(Thisuser.pagelen));
ansig(19,13);
cl(6);
sprompt(Thisuser.computer);
ansig(1,16);
sprint('^4[^01-9^4] ^3 ^4[^0A-C^4] ^3 ^4[^0Q^4]^0uit');
prt('^5Status : ^2['+#3#6);
      onek(c,'QABC123456789');
      case c of

      'Q': begin
           Done:=True;
           end;

      '1':begin
          ansig(4,2);
          sprint('^71');
          ansig(19,2);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.Realname:=s;
          ansig(4,2);
          sprint('^31');
          end;
          end;
      '2':begin
          ansig(4,3);
          sprint('^72');
          ansig(19,3);
          input(s,30);
          if (s<>'') then begin
          Thisuser.Name:=s;
          ansig(4,3);
          sprint('^32');
          end;
          end;
      '3':begin
          ansig(4,4);
          sprint('^73');
          ansig(19,4);
          input(s,12);
          if (s<>'') then begin
          Thisuser.Ph:=s;
          ansig(4,4);
          sprint('^33');

          end;
          end;
      '4':begin
          ansig(4,5);
          sprint('^74');
          ansig(19,5);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.street:=s;
          ansig(4,5);
          sprint('^34');

          end;
          end;

      '5':begin
          ansig(4,6);
          sprint('^75');
           ansig(19,6);
          input(s,30);
          if (s<>'') then begin
          Thisuser.Pw:=s;
          ansig(4,6);
          sprint('^35');

          end;
          end;
      '6':begin
          ansig(4,7);
          sprint('^76');
          ansig(19,7);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.CityState:=s;
          ansig(4,7);
          sprint('^36');

          end;
          end;
      '7':begin
          ansig(4,8);
          sprint('^77');
          ansig(19,8);
          input(s,8);
          if (s<>'') then begin
          Thisuser.Bday:=s;
          ansig(4,8);
          sprint('^37');

          end;
          end;
      '8':begin
          ansig(4,9);
          sprint('^78');
          ansig(19,9);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.Occupation:=s;
          ansig(4,9);
          sprint('^38');

          end;
          end;
      '9':begin
          ansig(4,10);
          sprint('^79');
          ansig(19,10);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.WhereBBS:=s;
          ansig(4,10);
          sprint('^39');
          end;
          end;
     'A':begin
          ansig(4,11);
          sprint('^7A');
          ansig(19,11);
          inputWc(s,60);
          if (s<>'') then begin
          Thisuser.Note:=s;
          ansig(4,11);
          sprint('^3A');
          end;
        end;
     'B':begin
          ansig(4,12);
          sprint('^7B');
          ansig(19,12);
      prt('Wide Is Screen (32-132) ['+
      cstr(thisuser.linelen)+'] ');
    ini(bb); if (not badini) then Thisuser.linelen:=bb;
    ansig(19,12);
    prt('Lines Per Page (4-50) ['+cstr(thisuser.pagelen)+'] ');
    ini(bb); if (not badini) then Thisuser.pagelen:=bb;
    if (Thisuser.pagelen>50) then Thisuser.pagelen:=50;
    if (Thisuser.pagelen<4) then Thisuser.pagelen:=4;
    if (Thisuser.linelen>132) then Thisuser.linelen:=132;
          ansig(4,12);
          sprint('^3B');
          end;
'C':begin
          ansig(4,13);
          sprint('^7C');
          ansig(19,13);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.Computer:=s;
          ansig(4,13);
          sprint('^3C');
          end;
end;
end;
until (Hangup) or (c='Q');
Thisuser.ac:=Thisuser.ac+[pause];
cls;
end;
end;
end.
