{--------------------------------------------------------------------------}
{                         TechnoJock's Turbo Toolkit                       }
{                                                                          }
{                              Version   5.01                              }
{                                                                          }
{                                                                          }
{              Copyright 1986, 1989 TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                     {--------------------------------}
                     {       Unit:  MenuTTT5          }
                     {--------------------------------}


{History:     2/13/89       Mod 5.00a changed Y2 calculation in proc
                            Determine_Y_Dimensions
}

{$S-,R-,V-,D-}

Unit MenuTTT5;

INTERFACE

Uses CRT, FastTTT5, DOS, WinTTT5, KeyTTT5, StrnTTT5;

const
   Max_Choices = 30;
   MenuStrLength = 40;     {make longer if necessary}
type
{$IFDEF VER50}
   Menu_Hook = Procedure(var Ch:char; Choice:integer; var Ecode:integer);
{$ENDIF}
   Menu_record = record
                  Heading1     : string[MenuStrLength];   { '' for no heading}
                  Heading2     : string[MenuStrLength];
                  Topic        : array[1..Max_Choices] of string[MenuStrLength];
                  TotalPicks   : integer;
                  PicksPerLine : byte;
                  AddPrefix    : byte;                    {0 no, 1 No.'s, 2 Lets}
                  TopLeftXY    : array[1..2] of byte;     {X,Y}
                  Boxtype      : byte;                    {0,1,2,3, >3}
                  Colors       : array[1..5] of byte;     {HF,HB,LF,LB,Box}
                  Margins      : byte;
                  AllowEsc     : boolean;                 {true if Esc will exit}
                  {$IFDEF VER50}
                  Hook         : Menu_hook;
                  {$ENDIF}
                end;
{$IFNDEF VER50}
Var
  M_UserHook : Pointer;
{$ENDIF}
Procedure No_Hook(var Ch:char; Choice:integer; var Ecode : integer);
Procedure Menu_Set(var M : Menu_record);
Procedure DisplayMenu(MenuDef: Menu_record;
                      Window:Boolean;
                      var Choice,Errorcode : integer);

IMPLEMENTATION

{$IFNDEF VER50}
   Procedure Call_Hook(var Ch:char; Choice:integer; var Ecode:integer);
          Inline($FF/$1E/M_UserHook);
{$ENDIF}

{$F+}
 Procedure No_Hook(var Ch:char; Choice:integer; var Ecode : integer);
 {}
 begin
 end; {of proc No_Hook}
{$F-}

 Procedure Menu_Set(var M : Menu_record);
 {}
 begin
     with M do
     begin
         Heading1     := '';
         Heading2     := '';
         Topic[1]     := '';
         TotalPicks   := 0;
         PicksPerLine := 1;
         AddPrefix    := 1;
         TopLeftXY[1] := 0;
         TopLeftXY[2] := 0;
         Boxtype      := 5;
         If BaseOfScreen = $B800 then
         begin
             Colors[1]    := white;
             Colors[2]    := red;
             Colors[3]    := lightgray;
             Colors[4]    := blue;;
             Colors[5]    := lightred;
         end
         else
         begin
             Colors[1]    := white;
             Colors[2]    := black;
             Colors[3]    := lightgray;
             Colors[4]    := black;
             Colors[5]    := white;
         end;
         Margins      := 5;
         AllowEsc     := true;
         {$IFDEF VER50}
                 Hook         := NO_Hook;
         {$ELSE}
                 M_UserHook := Nil;
         {$ENDIF}
     end;
 end; {of proc Menu_Set}

 Procedure MenuError(Code:byte);    {fatal error -- msg and halt}
 var Message:string;
 begin
     {Clrscr;}
     Case Code of
     1 : Message := 'Fatal Error 1: Too Many Picks to display. Change PicksPerLine';
     else Message := 'Aborting';
     end; {case}
     WriteAT(1,12,black,lightgray,Message);
     Repeat Until keypressed;
     Halt;
 end;    {proc MenuError}

Procedure DisplayMenu(MenuDef: Menu_record;
                      Window:Boolean;
                      var Choice,Errorcode : integer);
Const
Alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
Numbers  = '123456789';
var
I,J,X2,Y2,heading_Lines : integer;
TextWidth : byte;


    Function Int_to_Str(Number:Integer):string;
    var Temp : string;
    begin
       Str(Number,temp);
       Int_to_Str := temp;
    end;

    Function  Str_to_Int(Str:string):integer;
    var temp,code : integer;
    begin
        If length(Str) = 0 then
           Str_to_Int := 0
        else
        begin
            val(Str,temp,code);
            if code = 0 then
               Str_to_Int := temp
            else
               Str_to_Int := 0;
        end;
    end;

   Procedure GetDimensions;
   var Fullwidth,MaxWidth: integer;

     Procedure Validate_Prefix;                          { 0   no prefix  }
     begin                                               { 1   numbers prefix}
         with MenuDef do                                 { 2   letters prefix}
         begin                                           { 3   function key prefix}
             If PicksPerLine < 1 then PicksPerLine := 1; { 4   capital letter selection}
             If (TotalPicks = 10) and (AddPrefix = 1) then
                AddPrefix := 3;
             If (TotalPicks > 10) and (AddPrefix in [1,3]) then
                AddPrefix := 2;
             If (Addprefix > 4) or (TotalPicks > 26) or (Addprefix < 0) then
                Addprefix := 0;
             end; {do}
     end; {Validate_Prefix}

   Procedure Add_Prefix;
   var I : integer;
   begin
       With MenuDef do
       begin
           Case AddPrefix of
           1 : for I := 1 to TotalPicks do
                   Topic[I] := int_to_str(I) + ' ' + Topic[I];
           2 : for I := 1 to TotalPicks do
                   Topic[I] := Copy(Alphabet,I,1) + ' ' + Topic[I];
           3 : If TotalPicks < 10 then
                  for I := 1 to TotalPicks do
                      Topic[I] := 'F'+Int_to_Str(I) + ' ' + Topic[I]
               else
               begin                           {add extra space for F10 }
                   for I := 1 to 9 do
                       Topic[I] := 'F'+Int_to_Str(I) + '  ' + Topic[I];
                   Topic[10] := 'F10 '+ Topic[10];
               end;
           end; {case}
       end;  {do}
   end;  {proc Add_Prefix}

     Procedure Find_Longest_Topic;
     var
       I,J: integer;
     begin
         with MenuDef do
         begin
             Textwidth := 0;
             For I := 1 to TotalPicks do
                 If length(Topic[I]) > TextWidth then
                    Textwidth := length(Topic[I]);         {find the longest text}
         end;  {with}
     end;   {Proc Find_Widest_Line}

   Procedure Adjust_Text_Width(Len:integer);
   var I,J : integer;
   begin
       With MenuDef do
       begin
           For I := 1 to TotalPicks do
               If length(Topic[I]) > Len then         {reduce it}
                  Delete(Topic[I],succ(Len),length(Topic[I]) - Len)
               else                                  {expand it}
                  For J := length(Topic[I]) + 1 to Textwidth do
                      Topic[I] :=  Topic[I] + ' ';
       end; {do}
   end;

   Procedure Determine_MaxWidth;
   {findout the max internal menu space - MaxWidth}
   begin
       with MenuDef do
       begin
           If margins < 0 then Margins := 0;
           If not (BoxType in [0..9]) then
              BoxType := 0;
           MaxWidth := 80 - 2*Margins - 1; {-1 for arrow symbol to left of pick}
           Case BoxType of
           1..4 : MaxWidth := MaxWidth - 2;     {box sides}
           5    : MaxWidth := pred(MaxWidth);    {box shadow}
           6..9 : MaxWidth := MaxWidth - 3;     {box sides and shadow}
           end;
       end; {with}
   end;

   Procedure Validate_PicksPerLine;
   begin
       With MenuDef do
       begin
           If succ(TextWidth)*PicksPerLine <= MaxWidth then
              exit;  {no adjustment necessary, everything fits}
           If (TextWidth-2)*PicksPerLine <= Maxwidth  then
               TextWidth := pred(MaxWidth div PicksperLine)
           else
           begin
               While succ(TextWidth)*PicksPerLine > MaxWidth do
                     PicksPerLine := pred(PicksPerLine);
               If PicksPerLine = 0 then
               begin
                   TextWidth := pred(MaxWidth);
                   PicksPerLine := 1;
               end;
           end;
       end; {with}
   end;  {Proc Validate_PicksPerLine}

   Procedure Determine_X_Dimensions;
   {Checks to see if the menu will fit, if it won't it changes something!}
   begin
       With MenuDef do
       begin
           Fullwidth := succ(Textwidth)*PicksPerLine + 2*Margins;
           Case BoxType of
           1..4 : FullWidth := FullWidth + 2;     {box sides}
           5    : FullWidth := succ(FullWidth);   {box shadow}
           6..9 : FullWidth := FullWidth + 3;     {box sides and shadow}
           end; {Case}
           If TopleftXY[1] < 1 then
              TopleftXY[1] := (80 - Fullwidth)  div 2;
           If TopLeftXY[1] + Fullwidth < 80 then
              X2 := TopleftXY[1] + Fullwidth
           else
           begin
               X2 := 80;
               TopLeftXY[1] := 80 - Fullwidth + 1;
           end;
       end; {with}
   end; {Proc Determine_X_Dimensions}

   Procedure Determine_Y_Dimensions;
   var
      BoxLines,
      TopicLines,
      FullDepth  : integer;
   begin
       With MenuDef do
       begin
           TopicLines := TotalPicks div PicksPerLine;  {no of full rows of picks}
           If TotalPicks mod PicksPerLine > 0 then     {+1 if partial row of picks}
              TopicLines := succ(TopicLines);
           Case BoxType of
           0    : Boxlines := 0;
           1..5 : BoxLines :=  2;     {box sides}
           6..9: BoxLines :=  3;     {box sides and shadow}
           end;
           Heading_Lines := 0;
           If length(Heading1) > 0 then
              Heading_Lines := succ(Heading_Lines);
           If length(Heading2) > 0 then
              Heading_Lines := succ(Heading_Lines);
           If Heading_Lines > 0 then                   {add a line for a gap}
              Heading_Lines := succ(Heading_Lines);    {gap above topics}
           If BoxType = 5 then
              Heading_Lines := succ(Heading_Lines);
           Fulldepth := BoxLines+TopicLines+Heading_Lines;
           If Heading_Lines > 0 then
             Fulldepth := succ(Fulldepth);  {+1 gap below topics if headings}
           If FullDepth > DisplayLines then   {if it doesn't fit, drop off topics}
           begin
               If Heading_Lines > 0 then
                  TotalPicks :=  (DisplayLines - BoxLines -Heading_Lines-1)*PicksPerLine
               else
                  TotalPicks :=  (DisplayLines - BoxLines - Heading_Lines)*PicksPerLine;
               FullDepth := 25;
           end;
           If TopLeftXY[2] <= 0 then
              TopLeftXY[2] := (DisplayLines - Fulldepth) div 2 +1;
           If TopLeftXY[2] + Fulldepth - 1 <= DisplayLines then
           begin
               If BoxType > 4 then   {shadow}
                  Y2 := TopleftXY[2] + (Fulldepth) - 2     {Mod 5.00a}
               else
                  Y2 := TopleftXY[2] + pred(Fulldepth);    {Mod 5.00a}
           end
           else
           begin
               If BoxType > 4 then   {shadow}
                  Y2 := pred(DisplayLines)
               else
                  Y2 := DisplayLines;
               TopLeftXY[2] := DisplayLines - Fulldepth {+ 1};   {WZ}
           end;
   end;   {do}
   end; {Proc Determine_Y_Dimensions}

   begin                              {Get_Dimensions}
       Validate_Prefix;
       Add_Prefix;
       Find_Longest_Topic;
       Determine_MaxWidth;
       Validate_PicksPerLine;
       Adjust_Text_Width(TextWidth);
       Determine_X_Dimensions;
       Determine_Y_Dimensions;
   end;   {proc GetDimensions}

   Procedure Write_Text(Item:integer;Highlight:boolean);
   Var X,Y,A:integer;
   begin
       With MenuDEf do
       begin
           A := Item mod PicksPerLine;
           Y := Item div PicksPerLine +TopleftXY[2] + ord(A <> 0);
           Y := Y + Heading_lines - ord(Boxtype = 0);
           If A = 0 then A := PicksPerLine;      {A is now the no of picks from left}
           X := (A - 1)*(TextWidth + 1)+Margins+
                TopleftXY[1]+1 + ord(BoxType > 0);          {title width + 1 for a space}
           If Highlight then
           begin
               WriteAt(X,Y,colors[1],colors[2],Topic[item]);
               WriteAT(pred(X),Y,colors[5],colors[2],chr(16));  {write arrow head}
           end
           else
           begin
               WriteAT(X,Y,colors[3],colors[4],Topic[item]);
               WriteAT(pred(X),Y,colors[3],colors[4],' ');       {remove arrow head}
               If AddPrefix = 4 then                             {highlight the capital letter}
                  WriteAT(Pred(X)+First_Capital_Pos(Topic[Item]),Y,
                          colors[1],colors[4],
                          First_Capital(Topic[Item]));
           end;
       end;  {do}
   end;  {Proc Write_Text}

   Procedure CreateMenu;
   var I : integer;
   begin
   with MenuDef do
   begin
    If Window then
           MkWin(TopleftXY[1],TopLeftXY[2],X2,Y2,colors[3],colors[4],boxtype)
    else
    begin
        ClearText(TopleftXY[1],TopLeftXY[2],X2,Y2,colors[3],colors[4]);
        If (BoxType in [5..9]) and (TopleftXY[1] > 1) then      {draw a shadow}
        begin
            For I := TopleftXY[2]+1 to Y2+1 do
                WriteAt(pred(TopLeftXY[1]),I,colors[3],black,' ');
            WriteAtTPU9     P L0CC*  h    P                                      ~                   %p                                Y{       E         7                                     YCOMMON3  J 9  YSYSTEM  s     YCRT  }   YDOS  K{   YMYIO  %  YTMPCOM    SINU        
            SINI        
            SINPUTWN1        
              0   SINPUTWN         
            0   S	INPUTWNWC (       
            0   S	INPUTMAIN 0       
              SINPUTWC 8       
              SINPUT @       
              SINPUTL H       
            S	INPUTCAPS P       
              SMMKEY X       
            YCOMMON  &%  YCOMMON1  9  YCOMMON2  y  &                                          0      8      @      H      P      X      ( $   A (   A (    X   5     6          1     1     0     1     |  COMMON  COMMON3  SYSTEM  Y+COMMON3.PAS             U        ~W P  ~W    ~&~ u  ] U        ~W P  ~W    ~&~ u  ]  Set to NULL string? U    ~
W W P    ~W W P     Wv W   W  W    u"W  W        t~&   t W~W P     W~W    t~&]  U     ~Wv
~W  W    ~W  ]
 cU     ~Wv
~W  W    ~W  ]
      U$     $~6U~6~6~6}&P  W    tIP     P    P    >   t  W  W1P            >   ~     ~6 ~6H~6}&P  W    t ~6  ~6~6}&=t ~6FF ~6H;F|_F~6}&=uHF@~6}&0PP~W  W P         t@
 X  FFF듊FP    ] UCLDP                                                                                      U
    
~W W P    W W     W P      W W    	 t@  W W    	 t@  W W    	 t@  W W    	 t@  W W    	 t@  ~W W P        >   tǆ W     tP     u ~kP  W    tXH~&P  W    t P  W    t
0  P  W    t
0-  P    P  W    tQ;F
E~&  P    >   t  WP1P             <uU   <ulF
H; |@"tUW    P  W    t90-0 P    ~&0-0 Ћ@~&<utU   u@Ѐ
 u@

  u?H~&~&=  u@"t W~W P    ~W     u    ]
 cU     ~Wv~W  W      ] uU     ~Wv~W  W      ]  U     ~Wv~W  W      ] pU     ~Wv~W  W      ] ` !                                                                !                                                           ;\\/U(    (~& >   u W  W P P      W    t W  W P  0HP      W P      W  W     tiWW  W PHP        ~W P    W  W@P  0+P      W P        PW  W P        u~W< P  Ɔ W    P    P  W     t@
  tˀt1P    >   t  WP1P              /tWP    ~W P    W    P    P  W     t@
  tˀ
tE<u
-P    >   t  WP1P                  P  W    t*W  W    WP            P  W    tO    u         P    ~W< P        IP  W    u8W~W    WP        ~W P        r;u8~W< P  WP    ~W    ~W P    3P  W     t@Р  
  "u WP    ~W P    W    P  W    tHWP        W~W    WP        ~W P    
u    P  W    t4WP      W    WP            8
u    *t#WP    ~W P        P  W     u@
  uh  W~W    	uW~W P P      W    uPW  W P        u W~W P~&0HP     W P    W W P P      W    u)W W P P    ~W P    'W W P P    ~W P    W W~&0@P~&0Њ 0+P     W P     W~W  W~W    @P  W~W    ~&0+P     W P    W~W P  W~W    HP    ~W P      W W    	t  W W    ƃ 
ӍW  W     W    W    ]       0     
  	 @     0  &   
 8 0     
  	 @     0  &   
 8 0   0`   6 0`   J 	 0   _ 	P   h 0   m 	P  z 0X     0   0`    0    0   	P    0X   " 	    - 0  	 	P     0X   # 	    . 0  + 	P(   ^ 0   c  0  m  0  u  0  }   <     	P(    0   0   0     a   a   a 	P(    0      a   8[0   d0   i  : 0H  0   0`     0    0`    	P0    0    	P0   0    	P0  0   	P0  0   *	P0  :0   E  aU0`   k 0H  p   v 0  0  	P0 
 0   	P0 
 0   	P0 * 0   	P0 & 0   0  &	P0 J 40   9  a^ 0  f  < l  r0  0  0  	 `    0  	P0 j 0    0P  	 `      <0`   t 0`  ~ 0  0  	 	P8    0X   # 	 0   ) 0  	 	P@    0X   # 	 0   ) 0   	PH    0X   " 	 0   ( 0  	 	PP    0X   # 	 0   ) 0     W   W 0p    	PX    0      W   W0p   	  W0`   	PX     W!0   &  WB0p   Q 0   V0`   d  Wo  Wz0p     W0`    0    80   0   	 @    0  0  	PX  0        0    <   0  ,0  10  6  a<0   T0`   b 0  m0  w	PX  0       0    <   0  0  0    a 0  	PX " 0   	PX B 0X   	0   0x    0`  #	PX D -0   2  9  f @  O  f T   Y 0P  a	 @   p  w  f ~   	PX d 0   0X   0   0x   0`    0  	 @   0   0x   0`   	PX  0     +)  +-0   D0`   R 0  ]	PX  g0   l0   ~ 0  0X   0   0x   0`    0  	PX " 0   0   	PX B 0x   0   0x    0`   0  0   .0`   < 0  A	PX " K0   P   [	PX  e0   o0p   	PX  0     80   0   0p   0`   0p   	PX  	0   0p   )0`   70p   R0`   `0p   0`   	PX  0   	PX  0   0p   0`   	PX   0   
0p   0`   	PX  $0   /	PX  80   C	PX B W0X   \0x   g 0@  r               D@#  +memboard.name+#3#5+' #'+cstr(ccboards[1][board]);
	end;
    'Z':s:=chatr;
  else
	s:='@'+c;
  end;
  smci:=s;
end;

function substone(src,old,new:string):string;
var p:integer;
begin
  if (old<>'') then begin
    p:=pos(old,allcaps(src));
    if (p>0) then begin
      insert(new,src,p+length(old));
      delete(src,p,length(old));
    end;
  end;
  substone:=src;
end;

procedure sprompt(s:string);
var ss,sss:string;
    i,p1,p2,x,z:integer;
    c,mc:char;
    xx,b:boolean;
begin
  checkhangup;
  if (hangup) then exit;
  ss:=s; sss:='';
  b:=FALSE;
  if (pos('@',ss)<>0) then begin
    for c:='A' to 'Z' do
      while (pos('@'+c,allcaps(ss))<>0) do begin
	ss:=substone(ss,'@'+c,smci(c));
	b:=TRUE;
      end;
    while ((pos('@',ss)<>0) and (b)) do begin
      for c:='A' to 'Z' do
	while (pos('@'+c,allcaps(ss))<>0) do ss:=substone(ss,'@'+c,smci(c));
      for i:=1 to length(ss)-1 do
	if ((ss[i]='@') and (not (ss[i+1] in ['A'..'Z']))) then
					ss[i]:=#28;
			if (ss[lenTPU9     P wwooooH  X5    P                                      ~       5    %                    #        7   l     \              E                         YCOMMON2  y d  YSYSTEM  s     YCRT  }   YDOS  K{   YMYIO  %  YTMPCOM  ?  SSHOWUDSTATS        
           SSKEY1        
        L   S
SAVESYSTAT        
           SREMOVE_PORT         
           SOPENPORT (       
           L       SIPORT 0       
           SGAMEPORT 8       
           SSENDCOM1 @       
        L   SRECOM1 H       
   0  L   S
TERM_READY P       
        0   SGETWINDYSIZE X       
          SINUSERWINDOW `       
           SCOMMANDLINE h       
            SSCLEARWINDOW p       
           S
SCHANGEWINDOW x       
        0     STOPSCR        
         STLEFT        
           SREADINMACROS        
           SCHANGEUSERDATAWINDOW        
         [SSAVEUF        
         YCOMMON  Q%  YCOMMON1  d?  YCOMMON3  J  Q         !                (       0       8       @      H       P       X       `       h       p O                              4                                 x        	                                                A   (  
`  | h    H       )     Q P    h       I     -     <    V H   x      Y   (      B        P  K 0   M`   h                f      SYSTEM  CRT  COMMON2  COMMON  COMMON1  MYIO  TMPCOM  COMMON3  ${COMMON2.PAS        
LCVBA*PEKM1234U市    ~WWP    Ɔ P^WW P        tF  F
    W~W  W@P P    1P            	uF
    W/P1P            ƆP^WW P        tF  F
    W~W  W- P P    1P            