@echo off
REM     Be sure to remove ALL these REM statements since they
REM     slow down batch files!

REM     Additional information that can be placed in an UPCHECK.BAT
REM     file to extract a DESC.SDI or FILE_ID.DIZ from an archive
REM     so that GAP will automatically use the description file as
REM     the file description for the current upload that it is
REM     processing.

REM     *************************************************************
REM     *                          NOTE                             *
REM     *                                                           *
REM     *  The extracting of a DESC.SDI or FILE_ID.DIZ file should  *
REM     *  be performed AFTER you have done all your other UPCHECK  *
REM     *  routines such as testing the archive, scanning for       *
REM     *  viruses, etc. You do NOT want to extract a description   *
REM     *  file first, then go and test the archive only to find    *
REM     *  out it is defective or has a virus.                      *
REM     *                                                           *
REM     *  Add these description file routines in the appropriate   *
REM     *  place in your UPCHECK file where you have determined     *
REM     *  that the archive is suitable for posting on your board.  *
REM     *                                                           *
REM     *  If you do not normally use an UPCHECK to check for       *
REM     *  viruses or file integrity, then you can simply use this  *
REM     *  file as is (naming it UPCHECK.BAT), to extract the       *
REM     *  description file (if present) from a ZIP.                *
REM     *************************************************************

REM     GAP passes the following parameters to the UPCHECK.BAT file:

REM             Full path and name of file	(%1)
REM             Upload Directory path		(%2)
REM             Filename			(%3)
REM             Filename without the extension	(%4)
REM             Extension without the filename	(%5)
REM                     "NONE" if no extension
REM             Local/Remote code               (%6)
REM                     0 = Remote Caller
REM                     1 = Local Sysop 
REM                     2 = Local Caller
 
REM     Determine type of Archive we are dealing with
REM     This example tests for ZIP files ONLY!

	if "%5"=="ZIP" goto DES_ZIP
	goto DONE_DES

:DES_ZIP

REM     Process ZIP files

REM     First try to unzip a DESC.SDI file into the upload (work) directory

        pkunzip -o %1 %2\ DESC.SDI >NUL

REM     If DESC.SDI is not in the ZIP, try to unzip FILE_ID.DIZ

        if errorlevel 1 goto DES_ZIP1
        goto DONE_DES

:DES_ZIP1

REM     If we come here, then DESC.SDI was not contained in the
REM     ZIP, so we willl now check for FILE_ID.DIZ

        pkunzip -o %1 %2\ FILE_ID.DIZ >NUL

REM     We are done extracting either DESC.SDI or FILE_ID.DIZ (we
REM     only want one of the files not both). We really don't even
REM     care if the file was extracted or not since GAP will handle
REM     all the details for us. 
REM     If we DID extract one of the two files, we made sure to
REM     simply leave it in the work directory. GAP will detect that
REM     it is there and delete it after it is finished with it.

:DONE_DES
