/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
                           + Project Frontier +

 PowerPPL Compiler

 MISC SHARED ARRAYS DEFINITIONS 

*/

#define MAXPROCS 442
#define MAXFUNCS 423

typedef struct {
    char *name;
	int minArg;
    int maxArg;
    int argType;
    int reserved;
	}statement;

typedef struct {
	char	*name;
	short	argMini;
	short	argMaxi;
	int		nUsed;
	}function;

statement far stat[MAXPROCS] = {
   "",              0,   0,  0,      0, // 0
   "End",           0,   0,  0x734,  0, // 1
   "Cls",           0,   0,  0x734,  0, // 2
   "ClrEol",        0,   0,  0x734,  0, // 3
   "More",          0,   0,  0x734,  0, // 4
   "Wait",          0,   0,  0x734,  0, // 5
   "Color",        1,   1,  0x734,  0, // 6
   "Goto",         1,   1,  0x956,  0, // 7
   "Let",          2,   2,  0x8B7,  0, // 8
   "Print",        1,   99, 0x734,  0, // 9
   "PrintLn",      0,   99, 0x734,  0, // 10
   "If",           1,   1,  0x14CC, 0, // 11
   "ConfFlag",     2,   2,  0x734,  0, // 12
   "ConfUnflag",   2,   2,  0x734,  0, // 13
   "DispFile",     2,   2,  0x734,  0, //
   "Input",        2,   2,  0x7B5,  0, //
   "FCreate",      4,   4,  0x734,  0, //
   "FOpen",        4,   4,  0x734,  0, //
   "FAppend",      4,   4,  0x734,  0, //
   "FClose",       1,   1,  0x734,  0, //
   "FGet",         2,   2,  0x7B5,  0, //
   "FPut",         2,   99, 0x734,  0, //
   "FPutLn",       1,   99, 0x734,  0, //
   "ResetDisp",     0,   0,  0x734,  0, //
   "StartDisp",    1,   1,  0x734,  0, //
   "FPutPad",      3,   3,  0x734,  0, //
   "Hangup",        0,   0,  0x734,  0, //
   "GetUser",       0,   0,  0x734,  0, //
   "PutUser",       0,   0,  0x734,  0, //
   "DefColor",      0,   0,  0x734,  0, //
   "Delete",       1,   1,  0x734,  0, //
   "DelUser",       0,   0,  0x734,  0, //
   "AdjTime",      1,   1,  0x734,  0, //
   "Log",          2,   2,  0x734,  0, //
   "InputStr",     6,   6,  0x7B5,  0, //
   "InputYN",      3,   3,  0x7B5,  0, //
   "InputMoney",   3,   3,  0x7B5,  0, //
   "InputInt",     3,   3,  0x7B5,  0, //
   "InputCC",      3,   3,  0x7B5,  0, //
   "InputDate",    3,   3,  0x7B5,  0, //
   "InputTime",    3,   3,  0x7B5,  0, //
   "Gosub",        1,   1,  0x956,  0,  // 0x29
   "Return",        0,   0,  0x734,  0,  // 0x2A
   "PromptStr",    5,   5,  0x7B5,  0,  // 0x2B
   "DtrOn",         0,   0,  0x734,  0,  // 0x2C
   "DtrOff",        0,   0,  0x734,  0,  // 0x2D
   "CdChkOn",       0,   0,  0x734,  0,  // 0x2E
   "CdChkOff",      0,   0,  0x734,  0,  // 0x2F
   "Delay",        1,   1,  0x734,  0,  // 0x30
   "SendModem",    1,   1,  0x734,  0,  // 0x31
   "Inc",          1,   1,  0x75F,  0,  // 0x32
   "Dec",          1,   1,  0x75F,  0,  // 0x33
   "Newline",       0,   0,  0x734,  0,  // 0x34
   "Newlines",     1,   1,  0x734,  0,  // 0x35
   "Tokenize",     1,   1,  0x734,  0,  // 0x36
   "GetToken",     1,   1,  0x75F,  0,  // 0x37
   "Shell",        4,   4,  0x7B5,  0,  // 0x38
   "DispText",     2,   2,  0x734,  0,  // 0x39
   "Stop",          0,   0,  0x734,  0,  // 0x3A
   "InputText",    4,   4,  0x7B5,  0,  // 0x3B
   "Beep",          0,   0,  0x734,  0,  // 0x3C
   "Push",         1,   99, 0x734,  0,  // 0x3D
   "Pop",          1,   99, 0x75F,  0,  // 0x3E
   "KbdStuff",     1,   1,  0x734,  0,  // 0x3F
   "Call",         1,   1,  0x734,  0,  // 0x40
   "Join",         1,   1,  0x734,  0,  // 0x41
   "Quest",        1,   1,  0x734,  0,  // 0x42
   "Blt",          1,   1,  0x734,  0,  // 0x43
   "Dir",          1,   1,  0x734,  0,  // 0x44
   "KbdFile",      1,   1,  0x734,  0,  // 0x45
   "Bye",           0,   0,  0x734,  0,  // 0x46
   "Goodbye",       0,   0,  0x734,  0,  // 0x47
   "Broadcast",    3,   3,  0x734,  0,  // 0x48
   "WaitFor",      3,   3,  0x7B5,  0,  // 0x49
   "KbdChkOn",      0,   0,  0x734,  0,  // 0x4A
   "KbdChkOff",     0,   0,  0x734,  0,  // 0x4B
   "OpText",       1,   1,  0x734,  0,  // 0x4C
   "DispStr",      1,   1,  0x734,  0,  // 0x4D
   "RdUNet",       1,   1,  0x734,  0,  // 0x4E
   "WrUNet",       6,   6,  0x734,  0,  // 0x4F
   "DoIntr",       10,  10, 0x734,  0,  // 0x50
   "VarSeg",       2,   2,  0x78C,  0,  // 0x51
   "VarOff",       2,   2,  0x78C,  0,  // 0x52
   "Poke",         2,   2,  0x734,  0,  // 0x53
   "PokeW",        2,   2,  0x734,  0,  // 0x54
   "VarAddr",      2,   2,  0x75B,  0,  // 0x55
   "AnsiPos",      2,   2,  0x734,  0,  // 0x56
   "Backup",       1,   1,  0x734,  0,  // 0x57
   "Forward",      1,   1,  0x734,  0,  // 0x58
   "FreshLine",     0,   0,  0x734,  0,  // 0x59
   "WrUSys",        0,   0,  0x734,  0,  // 0x5A
   "RrUSys",        0,   0,  0x734,  0,  // 0x5B
   "NewPwd",       2,   2,  0x7B5,  0,  // 0x5C
   "OpenCap",      2,   2,  0x7B5,  0,  // 0x5D
   "CloseCap",     0,   0,  0x734,  0,  // 0x5E
   "Message",      9,   9,  0x734,  0,  // 0x5F
   "SaveScrn",      0,   0,  0x734,  0,  // 0x60
   "RestScrn",      0,   0,  0x734,  0,  // 0x61
   "Sound",        1,   1,  0x734,  0,  // 0x62
   "Chat",          0,   0,  0x734,  0,  // 0x63
   "SPrint",       1,   99, 0x734,  0,  // 0x64
   "SPrintLn",     0,   99, 0x734,  0,  // 0x65
   "MPrint",       1,   99, 0x734,  0,  // 0x66
   "MPrintLn",     0,   99, 0x734,  0,  // 0x67
   "Rename",       2,   2,  0x734,  0,  // 0x68
   "Frewind",      1,   1,  0x734,  0,  // 0x69
   "PokeDw",       2,   2,  0x734,  0,  // 0x6A
   "DbgLevel",     1,   1,  0x734,  0,  // 0x6B
   "ShowOn",        0,   0,  0x734,  0,  // 0x6C
   "ShowOff",       0,   0,  0x734,  0,  // 0x6D
   "PageOn",        0,   0,  0x734,  0,  // 0x6E
   "PageOff",       0,   0,  0x734,  0,  // 0x6F
   "FSeek",        3,   3,  0x734,  0,  // 0x70
   "FFlush",       1,   1,  0x734,  0,  // 0x71
   "FRead",        3,   3,  0x7B5,  0,  // 0x72
   "FWrite",       3,   3,  0x734,  0,  // 0x73
   "FDefIn",       1,   1,  0x734,  0,  // 0x74
   "FDefOut",      1,   1,  0x734,  0,  // 0x75
   "FDGet",        1,   1,  0x75F,  0,  // 0x76 8A ?
   "FDPut",        1,   99, 0x734,  0,  // 0x77
   "FDPutLn",      0,   99, 0x734,  0,  // 0x78
   "FDPutPad",     2,   2,  0x734,  0,  // 0x79
   "FDRead",       2,   2,  0x75F,  0,  // 0x7A
   "FDWrite",      2,   2,  0x734,  0,  // 0x7B
   "AdjBytes",     1,   1,  0x734,  0,  // 0x7C
   "KbdString",    1,   1,  0x734,  0,  // 0x7D
   "Alias",        1,   1,  0x734,  0,  // 0x7E
   "Redim",        1,   4,  0x836,  0,  // 0x7F
   "Append",       2,   2,  0x734,  0,  // 0x80
   "Copy",         2,   2,  0x734,  0,  // 0x81
   "KbdFlush",      0,   0,  0x734,  0,  // 0x82
   "MdmFlush",      0,   0,  0x734,  0,  // 0x83
   "KeyFlush",      0,   0,  0x734,  0,  // 0x84
   "LastIn",       1,   1,  0x734,  0,  // 0x85
   "Flag",         1,   1,  0x734,  0,  // 0x86
   "Download",     1,   1,  0x734,  0,  // 0x87
   "WrUSysDoor",   1,   1,  0x734,  0,  // 0x88
   "GetAltUser",   1,   1,  0x734,  0,  // 0x89
   "AdjDBytes",    1,   1,  0x734,  0,  // 0x8A
   "AdjTBytes",    1,   1,  0x734,  0,  // 0x8B
   "AdjTFiles",    1,   1,  0x734,  0,  // 0x8C
   "Lang",         1,   1,  0x734,  0,  // 0x8D
   "Sort",         2,   2,  0x88C,  0,  // 0x8E
   "MouseReg",     10,  10, 0x734,  0,  // 0x8F
   "ScrFile",      2,   2,  0x75B,  0,  // 0x90
   "SearchInit",   2,   2,  0x734,  0,  // 0x91
   "SearchFind",   2,   2,  0x7B5,  0,  // 0x92
   "SearchStop",    0,   0,  0x734,  0,  // 0x93
   "PrFound",      1,   99, 0x734,  0,  // 0x94
   "PrFoundLn",    0,   99, 0x734,  0,  // 0x95
   "TpaGet",       2,   2,  0x7B5,  0,  // 0x96
   "TpaPut",       2,   2,  0x734,  0,  // 0x97
   "TpaCGet",      3,   3,  0x7B5,  0,  // 0x98
   "TpaCPut",      3,   3,  0x734,  0,  // 0x99
   "TpaRead",      2,   2,  0x7B5,  0,  // 0x9A
   "TpaWrite",     2,   2,  0x734,  0,  // 0x9B
   "TpaCRead",     3,   3,  0x7B5,  0,  // 0x9C
   "TpaCWrite",    3,   3,  0x734,  0,  // 0x9D
   "BitSet",       2,   2,  0x75F,  0,  // 0x9E
   "BitClear",     2,   2,  0x75F,  0,  // 0x9F
   "Brag",          0,   0,  0x734,  0,  // 0xA0
   "FReAltUser",    0,   0,  0x734,  0,  // 0xA1
   "SetLmr",       2,   2,  0x734,  0,  // 0xA2
   "SetEnv",       1,   1,  0x734,  0,  // 0xA3
   "FCloseAll",     0,   0,  0x734,  0,  // 0xA4
   "Declare",      2,   2,  0x1CF2, 0,  // 0xA5
   "Function",     1,   1,  0x1F5B, 0,  // 0xA6
   "Procedure",    1,   1,  0x1F5B, 0,  // 0xA7
   "" ,             0,   0,  0,      0,  // 0xA8
   "EndProc",       0,   0,  0,      0,  // 0xA9
   "Begin",         0,   0,  0x276D, 0,  // 0xAA
   "EndFunc",       0,   0,  0,      0,  // 0xAB
   "Static",        0,   0,  0x1C24, 0,  // 0xAC
   "StackAbort",   1,   1,  0x734,  0,  // 0xAD
   "DCreate",      4,   4,  0x2585, 0,  // 0xAE
   "DOpen",        3,   3,  0x734,  0,  // 0xAF
   "DClose",       1,   1,  0x734,  0,  // 0xB0
   "DSetAlias",    2,   2,  0x734,  0,  // 0xB1
   "DPack",        1,   1,  0x734,  0,  // 0xB2
   "DCloseAll",     0,   0,  0x734,  0,  // 0xB3
   "DLock",        1,   1,  0x734,  0,  // 0xB4
   "DLockR",       2,   2,  0x734,  0,  // 0xB5
   "DLockG",       3,   3,  0x2585, 0,  // 0xB6
   "DUnlock",      1,   1,  0x734,  0,  // 0xB7
   "DnCreate",     3,   3,  0x2585, 0,  // 0xB8
   "DnOpen",       2,   2,  0x734,  0,  // 0xB9
   "DnClose",      2,   2,  0x734,  0,  // 0xBA
   "DnCloseAll",   1,   1,  0x734,  0,  // 0xBB
   "DNew",         1,   1,  0x734,  0,  // 0xBC
   "DAdd",         1,   1,  0x734,  0,  // 0xBD
   "DAppend",      1,   1,  0x734,  0,  // 0xBE
   "DTop",         1,   1,  0x734,  0,  // 0xBF
   "DGo",          2,   2,  0x734,  0,  // 0xC0
   "DBottom",      1,   1,  0x734,  0,  // 0xC1
   "DSkip",        2,   2,  0x734,  0,  // 0xC2
   "DBlank",       1,   1,  0x734,  0,  // 0xC3
   "DDelete",      1,   1,  0x734,  0,  // 0xC4
   "DRecall",      1,   1,  0x734,  0,  // 0xC5
   "DTag",         2,   2,  0x734,  0,  // 0xC6
   "DSeek",        2,   2,  0x734,  0,  // 0xC7
   "DFBlank",      2,   2,  0x734,  0,  // 0xC8
   "DGet",         3,   3,  0x7E5,  0,  // 0xC9   ?2585
   "DPut",         3,   3,  0x734,  0,  // 0xCA
   "DFCopy",       4,   4,  0x734,  0,  // 0xCB
   "Eval",         1,   1,  0x734,  0,  // 0xCC
   "Account",      2,   2,  0x734,  0,  // 0xCD
   "RecordUsage",  5,   5,  0x734,  0,  // 0xCE
   "MsgToFile",    3,   3,  0x734,  0,  // 0xCF
   "QwkLimits",    2,   2,  0x734,  0,  // 0xD0
   "Command",      2,   2,  0x734,  0,  // 0xD1
   "UseLMRs",      1,   1,  0x734,  0,  // 0xD2
   "ConfInfo",     3,   3,  0x734,  0,  // 0xD3
   "AdjTUBytes",   1,   1,  0x734,  0,  // 0xD4
   "GrafMode",     1,   1,  0x734,  0,  // 0xD5
   "AddUser",      2,   2,  0x734,  0,  // 0xD6
   "KillMsg",      2,   2,  0x734,  0,  // 0xD7
   "ChDir",        1,   1,  0x734,  0,  // 0xD8
   "MkDir",        1,   1,  0x734,  0,  // 0xD9
   "RmDir",        1,   1,  0x734,  0,  // 0xDA
   "FDOWrAka",     2,   2,  0x734,  0,  // 0xDB
   "FDOAddAKA",    3,   3,  0x734,  0,  // 0xDC
   "FDOWrOrg",     2,   2,  0x734,  0,  // 0xDD
   "FDOAddOrg",    3,   3,  0x734,  0,  // 0xDE
   "FDOQMod",      4,   4,  0x734,  0,  // 0xDF
   "FDOqAdd",      3,   3,  0x734,  0,  // 0xE0
   "FDOqDel",      1,   1,  0x734,  0,  // 0xE1
   "SoundDelay",   2,   2,  0x734,  0,  // 0xE2
   // -- Shifting
   "",             0,   0,  0x734,  0, // 227
   "",             0,   0,  0x734,  0, // 228
   "",             0,   0,  0x734,  0, // 229
   "",             0,   0,  0x734,  0, // 230
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 240
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 250
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 260
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 270
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 280
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 290
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 300
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 310
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 320
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 330
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 340
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 350
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 360
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 370
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 380
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0, // 390
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "",             0,   0,  0x734,  0,
   "Abort",        1,   1,  0x734,  0, // 400
   "",             0,   0,  0x734,  0, // 401
   "Leave",        1,   1,  0x734,  0, // 402
   "DPrint",       1,   99, 0x734,  0, // 403
   "DPrintLn",     0,   99, 0x734,  0, // 404
   "DCls",         0,   0,  0x734,  0, // 405
   "DAnsiPos",     2,   2,  0x734,  0,  // 406
   "DSaveScrn",    0,   0,  0x734,  0,  // 407
   "DRestScrn",    0,   0,  0x734,  0,  // 408
   "AdvMessage",   2,   2,  0x734,  0,  // 409
   "SetRead",      4,   4,  0x734,  0,  // 410
   "KillTime",     0,   0,  0x734,  0,  // 411
   "GetSystemUser",1,   1,  0x734,  0,  // 412
   "ScreenCleared",1,   1,  0x734,  0,  // 413
   "UnKillMsg"    ,2,   2,  0x734,  0,  // 414
   "EndWithValue", 1,   1,  0x734,  0, // 415
   "SetCarrier",   1,   1,  0x734,  0, // 416
   "SetLocal",     0,   0,  0x734,  0, // 417
   "SetComHand",   1,   1,  0x734,  0, // 418
   "SetErrorCorrect",   1,   1,  0x734,  0, // 419
   "PutProfile",   4,   4,  0x734, 0, // 420
   "SuspendCom",   0,   0,	0x734, 0, // 421
   "RestoreCom",   0,   0,	0x734, 0, // 422
   "CTokenize",    2,   2,  0x734,  0,  // 423
   "RegisterCmd",  3,   3,  0x734,  0,  // 424
   "InvalidCmds",  0,   0,  0x734,  0,  // 425
   "LoadConf",     1,   1,  0x734,  0,  // 426
   "Macros",       1,   1,  0x734,  0, // 427
   "SAnsiPos",     2,   2,  0x734,  0, // 428
   "PageText",     1,   1,  0x734,  0, // 429
   "BigShell",     4,   4,  0x7B5,  0, // 430
   "RdPcbSys",     0,   0,  0x734,  0, // 431
   "SetCom",       3,   3,  0x734,  0, // 432
   "SearchFileFind", 2, 2,  0x7B5,  0, // 433
   "ResetLog",     0,   0,  0x734,  0, // 434
   "GetCom",       3,   3,  0x756,  0, // 435
   "SCls", 		   0,	0,	0x734,	0, // 436
   "WrFrtSys",     0,   0,  0x734,  0, // 437
   "RdFrtSys",     0,   0,  0x734,  0, // 438
   "AdjTUFiles",   1,   1,  0x734,  0, // 439
   "SetTTime",     1,   1,  0x734,  0, // 440
   "SetLang",      2,   2,  0x734,  0, // 441
};

function far func[MAXFUNCS] = {
   "",              2,        0,     0,  /* 0x0000*/
   ")",             2,        0,	 0,  /* 0xFFFF*/
   "+",             1,        0,	 0,  /* 0xFFFE*/
   "-",             1,        0,	 0,  /* 0xFFFD*/
   "^",             2,        0,	 0,  /* 0xFFFC*/
   "*",             2,        0,	 0,  /* 0xFFFB*/
   "/",             2,        0,	 0,  /* 0xFFFA*/
   "%",             2,        0,	 0,  /* 0xFFF9*/
   "+",             2,        0,	 0,  /* 0xFFF8*/
   "-",             2,        0,	 0,  /* 0xFFF7*/
   "==",            2,        0,	 0,  /* 0xFFF6*/
   "<>",            2,        0,	 0,  /* 0xFFF5*/
   "<",             2,        0,	 0,  /* 0xFFF4*/
   "<=",            2,        0,	 0,  /* 0xFFF3*/
   ">",             2,        0,	 0,  /* 0xFFF2*/
   ">=",            2,        0,	 0,  /* 0xFFF1*/
   "!",             1,        0,	 0,  /* 0xFFF0*/
   "&&",            2,        0,	 0,  /* 0xFFEF*/
   "||",            2,        0,	 0,  /* 0xFFEE*/
   "(",             2,        0,	 0,  /* 0xFFED*/
   "Len",          1,        0,	 0,  /* 0xFFEC*/
   "Lower",        1,        0,	 0,  /* 0xFFEB*/
   "Upper",        1,        0,     0,  /* 0xFFEA*/
   "Mid",          3,        0,     0,  /* 0xFFE9*/
   "Left",         2,        0,     0,  /* 0xFFE8*/
   "Right",        2,        0,     0,  /* 0xFFE7*/
   "Space",        1,        0,     0,  /* 0xFFE6*/
   "Ferr",         1,        0,     0,  /* 0xFFE5*/
   "Chr",          1,        0,     0,  /* 0xFFE4*/
   "Asc",          1,        0,     0,  /* 0xFFE3*/
   "InStr",        2,        0,     0,  /* 0xFFE2*/
   "Abort",        0,        0,     0,  /* 0xFFE1*/
   "LTrim",        2,        0,     0,  /* 0xFFE0*/
   "RTrim",        2,        0,     0,  /* 0xFFDF*/
   "Trim",         2,        0,     0,  /* 0xFFDE*/
   "Random",       1,        0,     0,  /* 0xFFDD*/
   "Date",         0,        0,     0,  /* 0xFFDC*/
   "Time",         0,        0,     0,  /* 0xFFDB*/
   "U_Name",       0,        0,     0,  /* 0xFFDA*/
   "U_LDate",      0,        0,     0,  /* 0xFFD9*/
   "U_LTime",      0,        0,     0,  /* 0xFFD8*/
   "U_LDir",       0,        0,     0,  /* 0xFFD7*/
   "U_Logons",     0,        0,     0,  /* 0xFFD6*/
   "U_Ful",        0,        0,     0,  /* 0xFFD5*/
   "U_Fdl",        0,        0,     0,  /* 0xFFD4*/
   "U_BdlDay",     0,        0,     0,  /* 0xFFD3*/
   "U_TimeOn",     0,        0,     0,  /* 0xFFD2*/
   "U_Bdl",        0,        0,     0,  /* 0xFFD1*/
   "U_Bul",        0,        0,     0,  /* 0xFFD0*/
   "Year",         1,        0,     0,  /* 0xFFCF*/
   "Month",        1,        0,     0,  /* 0xFFCE*/
   "Day",          1,        0,     0,  /* 0xFFCD*/
   "Dow",          1,        0,     0,  /* 0xFFCC*/
   "Hour",         1,        0,     0,  /* 0xFFCB*/
   "Min",          1,        0,     0,  /* 0xFFCA*/
   "Sec",          1,        0,     0,  /* 0xFFC9*/
   "TimeAp",       1,        0,     0,  /* 0xFFC8*/
   "Ver",          0,        0,     0,  /* 0xFFC7*/
   "NoChar",       0,        0,     0,  /* 0xFFC6*/
   "YesChar",      0,        0,     0,  /* 0xFFC5*/
   "StripAtx",     1,        0,     0,  /* 0xFFC4*/
   "Replace",      3,        0,     0,  /* 0xFFC3*/
   "Strip",        2,        0,     0,  /* 0xFFC2*/
   "Inkey",        0,        0,     0,  /* 0xFFC1*/
   "String",       1,        0,     0,  /* 0xFFC0*/
   "Mask_Pwd",     0,        0,     0,  /* 0xFFBF*/
   "Mask_Alpha",   0,        0,     0,  /* 0xFFBE*/
   "Mask_Num",     0,        0,     0,  /* 0xFFBD*/
   "Mask_AlNum",   0,        0,     0,  /* 0xFFBC*/
   "Mask_File",    0,        0,     0,  /* 0xFFBB*/
   "Mask_Path",    0,        0,     0,  /* 0xFFBA*/
   "Mask_Ascii",   0,        0,     0,  /* 0xFFB9*/
   "CurConf",      0,        0,     0,  /* 0xFFB8*/
   "PCBDat",       0,        0,     0,  /* 0xFFB7*/
   "PPEPath",      0,        0,     0,  /* 0xFFB6*/
   "ValDate",      1,        0,     0,  /* 0xFFB5*/
   "ValTime",      1,        0,     0,  /* 0xFFB4*/
   "U_MsgRd",      0,        0,     0,  /* 0xFFB3*/
   "U_MsgWr",      0,        0,     0,  /* 0xFFB2*/
   "PcbNode",      0,        0,     0,  /* 0xFFB1*/
   "ReadLine",     2,        0,     0,  /* 0xFFB0*/
   "SysopSec",     0,        0,     0,  /* 0xFFAF*/
   "OnLocal",      0,        0,     0,  /* 0xFFAE*/
   "UN_Stat",      0,        0,     0,  /* 0xFFAD*/
   "UN_Name",      0,        0,     0,  /* 0xFFAC*/
   "UN_City",      0,        0,     0,  /* 0xFFAB*/
   "UN_Oper",      0,        0,     0,  /* 0xFFAA*/
   "CurSec",       0,        0,     0,  /* 0xFFA9*/
   "GetToken",     0,        0,     0,  /* 0xFFA8*/
   "MinLeft",      0,        0,     0,  /* 0xFFA7*/
   "MinOn",        0,        0,     0,  /* 0xFFA6*/
   "GetEnv",       1,        0,     0,  /* 0xFFA5*/
   "CallId",       0,        0,     0,  /* 0xFFA4*/
   "RegAL",        0,        0,     0,  /* 0xFFA3*/
   "RegAH",        0,        0,     0,  /* 0xFFA2*/
   "RegBL",        0,        0,     0,  /* 0xFFA1*/
   "RegBH",        0,        0,     0,  /* 0xFFA0*/
   "RegCL",        0,        0,     0,  /* 0xFF9F*/
   "RegCH",        0,        0,     0,  /* 0xFF9E*/
   "RegDL",        0,        0,     0,  /* 0xFF9D*/
   "RegDH",        0,        0,     0,  /* 0xFF9C*/
   "RegAX",        0,        0,     0,  /* 0xFF9B*/
   "RegBX",        0,        0,     0,  /* 0xFF9A*/
   "RegCX",        0,        0,     0,  /* 0xFF99*/
   "RegDX",        0,        0,     0,  /* 0xFF98*/
   "RegSI",        0,        0,     0,  /* 0xFF97*/
   "RegDI",        0,        0,     0,  /* 0xFF96*/
   "RegF",         0,        0,     0,  /* 0xFF95*/
   "RegCF",        0,        0,     0,  /* 0xFF94*/
   "RegDS",        0,        0,     0,  /* 0xFF93*/
   "RegES",        0,        0,     0,  /* 0xFF92*/
   "B2W",          2,        0,     0,  /* 0xFF91*/
   "Peek",         1,        0,     0,  /* 0xFF90*/
   "PeekW",        1,        0,     0,  /* 0xFF8F*/
   "MkAddr",       2,        0,     0,  /* 0xFF8E*/
   "Exist",        1,        0,     0,  /* 0xFF8D*/
   "I2S",          2,        0,     0,  /* 0xFF8C*/
   "S2I",          2,        0,     0,  /* 0xFF8B*/
   "Carrier",      0,        0,     0,  /* 0xFF8A*/
   "TokenStr",     0,        0,     0,  /* 0xFF89*/
   "CDOn",         0,        0,     0,  /* 0xFF88*/
   "LangExt",      0,        0,     0,  /* 0xFF87*/
   "AnsiOn",       0,        0,     0,  /* 0xFF86*/
   "ValCC",        1,        0,     0,  /* 0xFF85*/
   "FmtCC",        1,        0,     0,  /* 0xFF84*/
   "CCType",       1,        0,     0,  /* 0xFF83*/
   "GetX",         0,        0,     0,  /* 0xFF82*/
   "GetY",         0,        0,     0,  /* 0xFF81*/
   "And",          2,        0,     0,  /* 0xFF80*/
   "Or",           2,        0,     0,  /* 0xFF7F*/
   "XOr",          2,        0,     0,  /* 0xFF7E*/
   "Not",          1,        0,     0,  /* 0xFF7D*/
   "U_PwdHist",    1,        0,     0,  /* 0xFF7C*/
   "U_PwdLc",      0,        0,     0,  /* 0xFF7B*/
   "U_PwdTc",      0,        0,     0,  /* 0xFF7A*/
   "U_Stat",       1,        0,     0,  /* 0xFF79*/
   "DefColor",     0,        0,     0,  /* 0xFF78*/
   "Abs",          1,        0,     0,  /* 0xFF77*/
   "GrafMode",     0,        0,     0,  /* 0xFF76*/
   "Psa",          1,        0,     0,  /* 0xFF75*/
   "FileInf",      2,        0,     0,  /* 0xFF74*/
   "PPEName",      0,        0,     0,  /* 0xFF73*/
   "MkDate",       3,        0,     0,  /* 0xFF72*/
   "CurColor",     0,        0,     0,  /* 0xFF71*/
   "KInkey",       0,        0,     0,  /* 0xFF70*/
   "MInkey",       0,        0,     0,  /* 0xFF6F*/
   "MaxNode",      0,        0,     0,  /* 0xFF6E*/
   "SlPath",       0,        0,     0,  /* 0xFF6D*/
   "HelpPath",     0,        0,     0,  /* 0xFF6C*/
   "TempPath",     0,        0,     0,  /* 0xFF6B*/
   "Modem",        0,        0,     0,  /* 0xFF6A*/
   "LoggedOn",     0,        0,     0,  /* 0xFF69*/
   "CallNum",      0,        0,     0,  /* 0xFF68*/
   "MGetByte",     0,        0,     0,  /* 0xFF67*/
   "TokCount",     0,        0,     0,  /* 0xFF66*/
   "U_RecNum",     1,        0,     0,  /* 0xFF65*/
   "U_InConf",     2,        0,     0,  /* 0xFF64*/
   "PeekDW",       1,        0,     0,  /* 0xFF63*/
   "DbgLevel",     0,        0,     0,  /* 0xFF62*/
   "ScrText",      4,        0,     0,  /* 0xFF61*/
   "ShowStat",     0,        0,     0,  /* 0xFF60*/
   "PageStat",     0,        0,     0,  /* 0xFF5F*/
   "ReplaceStr",   3,        0,     0,  /* 0xFF5E*/
   "StripStr",     2,        0,     0,  /* 0xFF5D*/
   "ToBigStr",     1,        0,     0,  /* 0xFF5C*/
   "ToBoolean",    1,        0,     0,  /* 0xFF5B*/
   "ToByte",       1,        0,     0,  /* 0xFF5A*/
   "ToDate",       1,        0,     0,  /* 0xFF59*/
   "ToDouble",     1,        0,     0,  /* 0xFF58*/
   "ToEDate",      1,        0,     0,  /* 0xFF57*/
   "ToInteger",    1,        0,     0,  /* 0xFF56*/
   "ToMoney",      1,        0,     0,  /* 0xFF55*/
   "ToReal",       1,        0,     0,  /* 0xFF54*/
   "ToShort",      1,        0,     0,  /* 0xFF53*/
   "ToInt",        1,        0,     0,  /* 0xFF52*/
   "ToTime",       1,        0,     0,  /* 0xFF51*/
   "ToDWord",      1,        0,     0,  /* 0xFF50*/
   "ToWord",       1,        0,     0,  /* 0xFF4F*/
   "Mixed",        1,        0,     0,  /* 0xFF4E*/
   "Alias",        0,        0,     0,  /* 0xFF4D*/
   "ConfReg",      1,        0,     0,  /* 0xFF4C*/
   "ConfExp",      1,        0,     0,  /* 0xFF4B*/
   "ConfSel",      1,        0,     0,  /* 0xFF4A*/
   "ConfSys",      1,        0,     0,  /* 0xFF49*/
   "ConfMW",       1,        0,     0,  /* 0xFF48*/
   "LPrinted",     0,        0,     0,  /* 0xFF47*/
   "IsNonStop",    0,        0,     0,  /* 0xFF46*/
   "ErrCorrect",   0,        0,     0,  /* 0xFF45*/
   "ConfAlias",    0,        0,     0,  /* 0xFF44*/
   "UserAlias",    0,        0,     0,  /* 0xFF43*/
   "CurUser",      0,        0,     0,  /* 0xFF42*/
   "U_Lmr",        1,        0,     0,  /* 0xFF41*/
   "ChatStat",     0,        0,     0,  /* 0xFF40*/
   "DefAns",       0,        0,     0,  /* 0xFF3F*/
   "LastAns",      0,        0,     0,  /* 0xFF3E*/
   "MegaNum",      1,        0,     0,  /* 0xFF3D*/
   "EvtTimeAdj",   0,        0,     0,  /* 0xFF3C*/
   "IsBitSet",     2,        0,     0,  /* 0xFF3B*/
   "FmtReal",      3,        0,     0,  /* 0xFF3A*/
   "FlagCnt",      0,        0,     0,  /* 0xFF39*/
   "KbdBufSize",   0,        0,     0,  /* 0xFF38*/
   "PPLBufSize",   0,        0,     0,  /* 0xFF37*/
   "KbdFilUsed",   0,        0,     0,  /* 0xFF36*/
   "LoMsgNum",     0,        0,     0,  /* 0xFF35*/
   "HiMsgNum",     0,        0,     0,  /* 0xFF34*/
   "DriveSpace",   1,        0,     0,  /* 0xFF33*/
   "OutBytes",     0,        0,     0,  /* 0xFF32*/
   "HiConfNum",    0,        0,     0,  /* 0xFF31*/
   "InBytes",      0,        0,     0,  /* 0xFF30*/
   "Crc32",        2,        0,     0,  /* 0xFF2F*/
   "PCBMac",       1,        0,     0,  /* 0xFF2E*/
   "ActMsgNum",    0,        0,     0,  /* 0xFF2D*/
   "StackLeft",    0,        0,     0,  /* 0xFF2C*/
   "StackErr",     0,        0,     0,  /* 0xFF2B*/
   "DGetAlias",    1,        0,     0,  /* 0xFF2A*/
   "DBof",         1,        0,     0,  /* 0xFF29*/
   "DChanged",     1,        0,     0,  /* 0xFF28*/
   "DDecimals",    2,        0,     0,  /* 0xFF27*/
   "DDeleted",     1,        0,     0,  /* 0xFF26*/
   "DEof",         1,        0,     0,  /* 0xFF25*/
   "DErr",         1,        0,     0,  /* 0xFF24*/
   "DFields",      1,        0,     0,  /* 0xFF23*/
   "DLength",      2,        0,     0,  /* 0xFF22*/
   "DName",        2,        0,     0,  /* 0xFF21*/
   "DRecCount",    1,        0,     0,  /* 0xFF20*/
   "DRecNo",       1,        0,     0,  /* 0xFF1F*/
   "DType",        2,        0,     0,  /* 0xFF1E*/
   "FNext",        0,        0,     0,  /* 0xFF1D*/
   "DNext",        0,        0,     0,  /* 0xFF1C*/
   "ToDDate",      1,        0,     0,  /* 0xFF1B*/
   "DCloseAll",    0,        0,     0,  /* 0xFF1A*/
   "DOpen",        3,        0,     0,  /* 0xFF19*/
   "DClose",       1,        0,     0,  /* 0xFF18*/
   "DSetAlias",    2,        0,     0,  /* 0xFF17*/
   "DPack",        1,        0,     0,  /* 0xFF16*/
   "DLockF",       1,        0,     0,  /* 0xFF15*/
   "DLock",        1,        0,     0,  /* 0xFF14*/
   "DLockR",       2,        0,     0,  /* 0xFF13*/
   "DUnlock",      1,        0,     0,  /* 0xFF12*/
   "DNOpen",       2,        0,     0,  /* 0xFF11*/
   "DNClose",      2,        0,     0,  /* 0xFF10*/
   "DNCloseAll",   1,        0,     0,  /* 0xFF0F*/
   "DNew",         1,        0,     0,  /* 0xFF0E*/
   "DAdd",         1,        0,     0,  /* 0xFF0D*/
   "DAppend",      1,        0,     0,  /* 0xFF0C*/
   "DTop",         1,        0,     0,  /* 0xFF0B*/
   "DGo",          2,        0,     0,  /* 0xFF0A*/
   "DBottom",      1,        0,     0,  /* 0xFF09*/
   "DSkip",        2,        0,     0,  /* 0xFF08*/
   "DBlank",       1,        0,     0,  /* 0xFF07*/
   "DDelete",      1,        0,     0,  /* 0xFF06*/
   "DRecall",      1,        0,     0,  /* 0xFF05*/
   "DTag",         2,        0,     0,  /* 0xFF04*/
   "DSeek",        2,        0,     0,  /* 0xFF03*/
   "DFBlank",      2,        0,     0,  /* 0xFF02*/
   "DGet",         2,        0,     0,  /* 0xFF01*/
   "DPut",         3,        0,     0,  /* 0xFF00*/
   "DFCopy",       4,        0,     0,  /* 0xFEFF*/
   "DSelect",      1,        0,     0,  /* 0xFEFE*/
   "DChkStat",     1,        0,     0,  /* 0xFEFD*/
   "PCBAccount",   1,        0,     0,  /* 0xFEFC*/
   "PCBAccStat",   1,        0,     0,  /* 0xFEFB*/
   "DErrMsg",      1,        0,     0,  /* 0xFEFA*/
   "Account",      1,        0,     0,  /* 0xFEF9*/
   "ScanMsgHdr",   4,        0,     0,  /* 0xFEF8*/
   "CheckRip",     0,        0,     0,  /* 0xFEF7*/
   "RipVer",       0,        0,     0,  /* 0xFEF6*/
   "QwkLimits",    1,        0,     0,  /* 0xFEF5*/
   "FindFirst",    1,        0,     0,  /* 0xFEF4*/
   "FindNext",     0,        0,     0,  /* 0xFEF3*/
   // -------- 3.20 \/
   "UseLMRs",      0,   	  0,  	 0,  /* 0xFEF2*/
   "ConfInfo",     2,   	  0,  	 0,  /* 0xFEF1*/
   "TInkey",       1,   	  0,  	 0,  /* 0xFEF0*/
   "Cwd",          0,   	  0,  	 0,  /* 0xFEEF*/
   "InStrR",       2,   	  0,  	 0,  /* 0xFEEE*/
   "FDORdAka",     1,   	  0,  	 0,  /* 0xFEED*/
   "FDORdOrg",     1, 	  	  0,  	 0,  /* 0xFEEC*/
   "FDORdArea",    1,   	  0,  	 0,  /* 0xFEEB*/
   "FDOQrd",       6,   	  0,  	 0,  /* 0xFEEA*/
   "GetDrive",     0,   	  0,  	 0,  /* 0xFEE9*/
   "SetDrive",     1,   	  0,  	 0,  /* 0xFEE8*/
   "Bs2I",         1,   	  0,  	 0,  /* 0xFEE7*/
   "Bd2I",         1,   	  0,  	 0,  /* 0xFEE6*/
   "I2Bs",         1,   	  0,  	 0,  /* 0xFEE5*/
   "I2Bd",         1,   	  0,  	 0,  /* 0xFEE4*/
   "FTell",        1,   	  0,  	 0,  /* 0xFEE3*/
   "Os",           0,   	  0,  	 0,  /* 0xFEE2*/
   "",             0,   	  0,  	 0, // 287
   "",             0,   	  0,  	 0, // 288
   "",             0,   	  0,  	 0, // 289
   "",             0,   	  0,  	 0, // 290
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 300
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 310
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 320
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 330
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 340
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 350
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 360
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 370
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 380
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0, // 390
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "",             0,   	  0,  	 0,
   "DScrText",     4,         0,     0, // 400
   "DGetX",        0,         0,     0, // 401
   "DGetY",        0,         0,     0, // 402
   "DualScr",      0,         0,     0, // 403
   "ConfName",     1,         1,     0, // 404
   "SystemPath",   0,         0,     0, // 405
   "Beta",         0,         0,     0, // 406
   "ScreenCleared",0,         0,     0, // 407
   "Call",         1,         0,     0, // 408
   "LastExitValue",0,         0,     0, // 409
   "Free",         0,         0,     0, // 410
   "ComInit",      0,         0,     0, // 411
   "GetComStat",   0,         0,     0, // 412
   "GetUartType",  0,         0,     0, // 413
   "GetProfile",   3,         0,     0, // 414
   "FrtIni",       0,         0,     0, // 415
   "FileMatch",    2,         2,     0, // 416
   "GetNextMsg",   11,       11,     0, // 417
   "HiMsgNumC",    1,         1,     0, // 418
   "LoMsgNumC",    1,         1,     0, // 419
   "RootPath",     0,         0,     0, // 420
   "ToSDate",      1,         1,     0, // 421
   "LangFile",     0,		  0,     0, // 422
};

char far *Type[34] = {
	  "Boolean",//            =    0x00;
	  "DWord",//              =    0x01;
	  "Date",//               =    0x02;
	  "EDate",//              =    0x03;
	  "Long",//               =    0x04;
	  "Money",//              =    0x05;
	  "Real",//               =    0x06;
	  "String",//             =    0x07;
	  "Time",//               =    0x08;
	  "Byte",//               =    0x09;
	  "Word",//               =    0x0A;
	  "SByte",//              =    0x0B;
	  "Int",//                =    0x0C;
	  "BigStr",//             =    0x0D;
	  "Double",//             =    0x0E;
	  "Function",//           =    0x0F;
	  "Procedure",//          =    0x10;
      "DDate",//              =    0x11;
      "",                        //0x12
      "",                        //0x13
      "",                        //0x14
      "",                        //0x15
      "",                        //0x16
      "",                        //0x17
      "",                        //0x18
      "",                        //0x19
      "",                        //0x1A
      "",                        //0x1B
      "",                        //0x1C
      "",                        //0x1D
      "",                        //0x1E
      "",                        //0x1F
      "",                        //0x20
      "SDate",                   //0x21
	  };

char far *reserved[164] = {
    "Var",
    "UNSIGNED",
    "UDWORD",
    "INTEGER",
    "SDWORD",
    "FLOAT",
    "UBYTE",
    "UWORD",
    "SHORT",
    "SWORD",
    "DREAL",
    "DDATE",
    "SDATE",
	"Declare",
	"Then",
	"Do",
	"Break",
	"Quit",
	"Continue",
	"Loop",
	"Select",
	"Case",
	"Default",
	"EndSelect",
	"EndWhile",
	"For",
	"Step",
	"While",
	"Next",
	"EndFor",
	"Else",
	"ElseIf",
	"Endif",
	"To",
	"Func",
	"Proc",
	"Go",
	"AUTO",
	"BELL",
	"CRC_FILE",
	"CRC_STR",
	"CUR_USER",
	"DEFS",
	"ECHODOTS",
	"ERASELINE",
	"FALSE",
	"FCL",
	"FIELDLEN",
	"FNS",
	"F_EXP",
	"F_MW",
	"F_REG",
	"F_SEL",
	"F_SYS",
	"GRAPH",
	"GUIDE",
	"HIGHASCII",
	"LANG",
	"LFAFTER",
	"LFBEFORE",
	"LOGIT",
	"LOGITLEFT",
	"NC",
	"NEWLINE",
	"NOCLEAR",
	"NO_USER",
	"O_RD",
	"O_RW",
	"O_WR",
	"SECUR",
	"STACKED",
	"S_DB",
	"S_DN",
	"S_DR",
	"S_DW",
	"TRUE",
	"UPCASE",
	"WORDWRAP",
	"YESNO",
	"NO_USER",
	"CUR_USER",
	"SEEK_SET",
	"SEEK_CUR",
	"SEEK_END",
	"NEWBALANCE",
	"CHRG_CALL",
	"CHRG_TIME",
	"CHRG_PEAKTIME",
	"CHRG_CHAT",
	"CHRG_MSGREAD",
	"CHRG_MSGCAP",
	"CHRG_MSGWRITE",
	"CHRG_MSGECHOED",
	"CHRG_MSGPRIVATE",
	"CHRG_DOWNFILE",
	"CHRG_DOWNBYTES",
	"PAY_UPFILE",
	"PAY_UPBYTES",
	"WARN_LEVEL",
	"ACC_STAT",
	"ACC_TIME",
	"ACC_MSGR",
	"ACC_MSGW",
	"START_BAL",
	"START_SESSION",
	"DEB_CALL",
	"DEB_TIME",
	"DEB_MSGREAD",
	"DEB_MSGCAP",
	"DEB_MSGWRITE",
	"DEB_MSGECHOED",
	"DEB_MSGPRIVATE",
	"DEB_DOWNFILE",
	"DEB_DOWNBYTES",
	"DEB_CHAT",
	"DEB_TPU",
	"DEB_SPECIAL",
	"CRED_UPFILE",
	"CRED_UPBYTES",
	"CRED_SPECIAL",
	"SEC_DROP",
	"HDR_ACTIVE",
	"HDR_BLOCKS",
	"HDR_DATE",
	"HDR_ECHO",
	"HDR_FROM",
	"HDR_MSGNUM",
	"HDR_MSGREF",
	"HDR_PWD",
	"HDR_REPLY",
	"HDR_RPLYDATE",
	"HDR_RPLYTIME",
	"HDR_STATUS",
	"HDR_SUBJ",
	"HDR_TIME",
	"HDR_TO",
	"MAXMSGS",
	"CMAXMSGS",
	"ATTACH_LIM_U",
	"ATTACH_LIM_P",
	"U_Expert",
    "U_FSE",
    "U_FSEP",
    "U_Cls",
    "U_ExpDate",
    "U_Sec",
    "U_PageLen",
    "U_ExpSec",
    "U_City",
    "U_BDPhone",
    "U_HVPhone",
    "U_Trans",
    "U_Cmnt1",
    "U_Cmnt2",
    "U_Pwd",
    "U_Scroll",
    "U_LongHDR",
    "U_Def79",
    "U_Alias",
    "U_Ver",
    "U_Addr",
    "U_Notes",
    "U_PwdExp",
    "U_Account",
    };
