/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1994-1998 Francis Gastellu
                      aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#if !defined( __Color_H )
#define __Color_H

const int cmColorTableCmdBase = 1547;
const int cmColorFocused      =   0;


class TCTable : public TView
{

public:

	TCTable( TRect& r );
	TCTable( StreamableInit ) : TView(streamableInit) { };
	virtual void draw();
	void effPointer();
	void affPointer();
	virtual void handleEvent( TEvent& event );

private:

	virtual const char *streamableName() const
		{ return name; }

protected:

	virtual void write( opstream& );
	virtual void *read( ipstream& );

public:

	static const char * const name;
	static TStreamable *build();

};


inline ipstream& operator >> ( ipstream& is, TCTable& cl )
	{ return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TCTable*& cl )
	{ return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TCTable& cl )
	{ return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TCTable* cl )
	{ return os << (TStreamable *) cl; }


class TCReport : public TView
{

public:

	TCReport( TRect& r );
	TCReport( StreamableInit ) : TView(streamableInit) { };
	virtual void draw();
	virtual void handleEvent( TEvent& event );

private:


	virtual const char *streamableName() const
	{ return name; }

protected:

	virtual void write( opstream& );
	virtual void *read( ipstream& );

public:

	static const char * const name;
	static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TCReport& cl )
	{ return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TCReport*& cl )
	{ return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TCReport& cl )
	{ return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TCReport* cl )
	{ return os << (TStreamable *) cl; }


class TColorChart : public TWindow
{

public:

	TColorChart();
	TColorChart( StreamableInit ) : TWindow(streamableInit),
					TWindowInit(&initFrame) { };

private:

	virtual const char *streamableName() const
	{ return name; }

protected:

	virtual void write( opstream& );
	virtual void *read( ipstream& );

public:

	static const char * const name;
	static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TColorChart& cl )
	{ return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TColorChart*& cl )
	{ return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TColorChart& cl )
	{ return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TColorChart* cl )
	{ return os << (TStreamable *) cl; }


#endif      // __Color_H
