/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
                           + Project Frontier +

 PPL Runtime

 PPL EXECUTABLE FUNCTIONS & STATEMENTS TABLES 

*/

#ifndef __EXEC_H
#define __EXEC_H

#define MAXPROCS 442
#define MAXFUNCS 423

void (*execProc[MAXPROCS])(void) = {
    ppl_S_void,
	ppl_S_END,
	ppl_S_CLS,
	ppl_S_CLREOL,
	ppl_S_MORE,
	ppl_S_WAIT,
	ppl_S_COLOR,
	ppl_S_GOTO,
	ppl_S_LET,
	ppl_S_PRINT,
	ppl_S_PRINTLN,
	ppl_S_IF,
	ppl_S_CONFFLAG,
	ppl_S_CONFUNFLAG,
	ppl_S_DISPFILE,
	ppl_S_INPUT,
	ppl_S_FCREATE,
	ppl_S_FOPEN,
	ppl_S_FAPPEND,
	ppl_S_FCLOSE,
	ppl_S_FGET,
	ppl_S_FPUT,
	ppl_S_FPUTLN,
	ppl_S_RESETDISP,
	ppl_S_STARTDISP,
	ppl_S_FPUTPAD,
	ppl_S_HANGUP,
	ppl_S_GETUSER,
	ppl_S_PUTUSER,
	ppl_S_DEFCOLOR,
	ppl_S_DELETE,
	ppl_S_DELUSER,
	ppl_S_ADJTIME,
	ppl_S_LOG,
	ppl_S_INPUTSTR,
	ppl_S_INPUTYN,
	ppl_S_INPUTMONEY,
	ppl_S_INPUTINT,
	ppl_S_INPUTCC,
	ppl_S_INPUTDATE,
	ppl_S_INPUTTIME,
	ppl_S_PROMPTSTR,
    ppl_S_GOSUB,
    ppl_S_RETURN,
	ppl_S_DTRON,
	ppl_S_DTROFF,
	ppl_S_CDCHKON,
	ppl_S_CDCHKOFF,
	ppl_S_DELAY,
	ppl_S_SENDMODEM,
	ppl_S_INC,
	ppl_S_DEC,
	ppl_S_NEWLINE,
	ppl_S_NEWLINES,
	ppl_S_TOKENIZE,
	ppl_S_GETTOKEN,
	ppl_S_SHELL,
	ppl_S_DISPTEXT,
	ppl_S_STOP,
	ppl_S_INPUTTEXT,
	ppl_S_BEEP,
	ppl_S_PUSH,
	ppl_S_POP,
	ppl_S_KBDSTUFF,
	ppl_S_CALL,
	ppl_S_JOIN,
	ppl_S_QUEST,
	ppl_S_BLT,
	ppl_S_DIR,
	ppl_S_KBDFILE,
	ppl_S_BYE,
	ppl_S_GOODBYE,
	ppl_S_BROADCAST,
	ppl_S_WAITFOR,
	ppl_S_KBDCHKON,
	ppl_S_KBDCHKOFF,
	ppl_S_OPTEXT,
	ppl_S_DISPSTR,
	ppl_S_RDUNET,
	ppl_S_WRUNET,
	ppl_S_DOINTR,
	ppl_S_VARSEG,
	ppl_S_VAROFF,
	ppl_S_POKE,
	ppl_S_POKEW,
	ppl_S_VARADDR,
	ppl_S_ANSIPOS,
	ppl_S_BACKUP,
	ppl_S_FORWARD,
	ppl_S_FRESHLINE,
	ppl_S_WRUSYS,
	ppl_S_RDUSYS,
	ppl_S_NEWPWD,
	ppl_S_OPENCAP,
	ppl_S_CLOSECAP,
	ppl_S_MESSAGE,
	ppl_S_SAVESCRN,
	ppl_S_RESTSCRN,
	ppl_S_SOUND,
	ppl_S_CHAT,
	ppl_S_SPRINT,
	ppl_S_SPRINTLN,
	ppl_S_MPRINT,
	ppl_S_MPRINTLN,
	ppl_S_RENAME,
	ppl_S_FREWIND,
	ppl_S_POKEDW,
	ppl_S_DBGLEVEL,
	ppl_S_SHOWON,
	ppl_S_SHOWOFF,
	ppl_S_PAGEON,
	ppl_S_PAGEOFF,
	ppl_S_FSEEK,
	ppl_S_FFLUSH,
	ppl_S_FREAD,
	ppl_S_FWRITE,
	ppl_S_FDEFIN,
	ppl_S_FDEFOUT,
	ppl_S_FDGET,
	ppl_S_FDPUT,
	ppl_S_FDPUTLN,
	ppl_S_FDPUTPAD,
	ppl_S_FDREAD,
	ppl_S_FDWRITE,
	ppl_S_ADJBYTES,
	ppl_S_KBDSTRING,
	ppl_S_ALIAS,
	ppl_S_REDIM,
	ppl_S_APPEND,
	ppl_S_COPY,
	ppl_S_KBDFLUSH,
	ppl_S_MDMFLUSH,
	ppl_S_KEYFLUSH,
	ppl_S_LASTIN,
	ppl_S_FLAG,
	ppl_S_DOWNLOAD,
	ppl_S_WRUSYSDOOR,
	ppl_S_GETALTUSER,
	ppl_S_ADJDBYTES,
	ppl_S_ADJTBYTES,
	ppl_S_ADJTFILES,
	ppl_S_LANG,
	ppl_S_SORT,
	ppl_S_MOUSEREG,
	ppl_S_SCRFILE,
	ppl_S_SEARCHINIT,
	ppl_S_SEARCHFIND,
	ppl_S_SEARCHSTOP,
	ppl_S_PRFOUND,
	ppl_S_PRFOUNDLN,
	ppl_S_TPAGET,
	ppl_S_TPAPUT,
	ppl_S_TPACGET,
	ppl_S_TPACPUT,
	ppl_S_TPAREAD,
	ppl_S_TPAWRITE,
	ppl_S_TPACREAD,
	ppl_S_TPACWRITE,
	ppl_S_BITSET,
	ppl_S_BITCLEAR,
	ppl_S_BRAG,
	ppl_S_FREALTUSER,
	ppl_S_SETLMR,
	ppl_S_SETENV,
	ppl_S_FCLOSEALL,
    ppl_S_DECLARE,
    ppl_S_FUNCTION,
    ppl_S_PROCEDURE,
    ppl_S_void,
    ppl_S_ENDPROC,
    ppl_S_BEGIN,
    ppl_S_ENDFUNC,
    ppl_S_STATIC,
	ppl_S_STACKABORT,
	ppl_S_DCREATE,
	ppl_S_DOPEN,
	ppl_S_DCLOSE,
	ppl_S_DSETALIAS,
	ppl_S_DPACK,
	ppl_S_DCLOSEALL,
	ppl_S_DLOCK,
	ppl_S_DLOCKR,
	ppl_S_DLOCKG,
	ppl_S_DUNLOCK,
	ppl_S_DNCREATE,
	ppl_S_DNOPEN,
	ppl_S_DNCLOSE,
	ppl_S_DNCLOSEALL,
	ppl_S_DNEW,
	ppl_S_DADD,
	ppl_S_DAPPEND,
	ppl_S_DTOP,
	ppl_S_DGO,
	ppl_S_DBOTTOM,
	ppl_S_DSKIP,
	ppl_S_DBLANK,
	ppl_S_DDELETE,
	ppl_S_DRECALL,
	ppl_S_DTAG,
	ppl_S_DSEEK,
	ppl_S_DFBLANK,
	ppl_S_DGET,
	ppl_S_DPUT,
	ppl_S_DFCOPY,
	ppl_S_EVAL,
	ppl_S_ACCOUNT,
	ppl_S_RECORDUSAGE,
	ppl_S_MSGTOFILE,
	ppl_S_QWKLIMITS,
	ppl_S_COMMAND,
    ppl_S_USELMRS,
    ppl_S_CONFINFO,
    ppl_S_ADJTUBYTES,
    ppl_S_GRAFMODE,
    ppl_S_ADDUSER,
    ppl_S_KILLMSG,
    ppl_S_CHDIR,
    ppl_S_MKDIR,
    ppl_S_RMDIR,
    ppl_S_FDOWRAKA,
    ppl_S_FDOADDAKA,
    ppl_S_FDOWRORG,
    ppl_S_FDOADDORG,
    ppl_S_FDOQMOD,
    ppl_S_FDOQADD,
    ppl_S_FDOQDEL,
    ppl_S_SOUNDDELAY,
    ppl_S_void, // 227
    ppl_S_void, // 228
    ppl_S_void, // 229
    ppl_S_void, // 230
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 240
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 250
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 260
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 270
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 280
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 290
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 300
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 310
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 320
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 330
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 340
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 350
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 360
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 370
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 380
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void, // 390
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_void,
    ppl_S_ABORT, // 400
    ppl_S_WRPCBSYS, // 401
    ppl_S_LEAVE, // 402
    ppl_S_DPRINT, // 403
    ppl_S_DPRINTLN, // 404
    ppl_S_DCLS, // 405
    ppl_S_DANSIPOS, // 406
    ppl_S_DSAVESCRN, // 407
    ppl_S_DRESTSCRN, // 408
	ppl_S_ADVMESSAGE, // 409
	ppl_S_SETREAD, // 410
    ppl_S_KILLTIME, // 411
    ppl_S_GETSYSTEMUSER, // 412
    ppl_S_SCREENCLEARED, // 413
    ppl_S_UNKILLMSG, // 414
    ppl_S_ENDWITHVALUE, // 415
    ppl_S_SETCARRIER, // 416
    ppl_S_SETLOCAL, // 417
    ppl_S_SETCOMHAND, // 418
    ppl_S_SETERRORCORRECT, // 419
    ppl_S_PUTPROFILE, // 420
    ppl_S_SUSPENDCOM, // 421
    ppl_S_RESTORECOM, // 422
    ppl_S_CTOKENIZE, // 423
    ppl_S_REGISTERCMD, // 424
    ppl_S_INVALIDCMDS, // 425
    ppl_S_LOADCONF, // 426
    ppl_S_MACROS, // 427
    ppl_S_SANSIPOS, // 428
    ppl_S_PAGETEXT, // 429
    ppl_S_BIGSHELL, // 430
    ppl_S_RDPCBSYS, // 431
    ppl_S_SETCOM,   // 432
    ppl_S_SEARCHFILEFIND, // 433
    ppl_S_RESETLOG, // 434
    ppl_S_GETCOM, // 435
	ppl_S_SCLS,   // 436
	ppl_S_WRFRTSYS,   // 437
	ppl_S_RDFRTSYS,   // 438
    ppl_S_ADJTUFILES, // 439
    ppl_S_SETTTIME,   // 440
    ppl_S_SETLANG,    // 441
	};

pplvar *(*execFunc[MAXFUNCS])(pplvar **) = {
    ppl_F_void,
    ppl_F_void,
	ppl_F_ADD,
	ppl_F_SUB,
	ppl_F_POW,
	ppl_F_MUL,
	ppl_F_DIV,
	ppl_F_MOD,
	ppl_F_UPOSITIVE,
	ppl_F_UNEGATIVE,
	ppl_F_CMP_EQU,
	ppl_F_CMP_NEQ,
	ppl_F_CMP_BEL,
	ppl_F_CMP_BOE,
	ppl_F_CMP_ABO,
	ppl_F_CMP_AOE,
	ppl_F_UNOT,
	ppl_F_BOOL_AND,
	ppl_F_BOOL_OR,
	ppl_F_LEN,
	ppl_F_LOWER,
	ppl_F_UPPER,
	ppl_F_MID,
	ppl_F_LEFT,
	ppl_F_RIGHT,
	ppl_F_SPACE,
	ppl_F_FERR,
	ppl_F_CHR,
	ppl_F_ASC,
	ppl_F_INSTR,
	ppl_F_ABORT,
	ppl_F_LTRIM,
	ppl_F_RTRIM,
	ppl_F_TRIM,
	ppl_F_RANDOM,
	ppl_F_DATE,
	ppl_F_TIME,
	ppl_F_U_NAME,
	ppl_F_U_LDATE,
	ppl_F_U_LTIME,
	ppl_F_U_LDIR,
	ppl_F_U_LOGONS,
	ppl_F_U_FUL,
	ppl_F_U_FDL,
	ppl_F_U_BDLDAY,
	ppl_F_U_TIMEON,
	ppl_F_U_BDL,
	ppl_F_U_BUL,
	ppl_F_YEAR,
	ppl_F_MONTH,
	ppl_F_DAY,
	ppl_F_DOW,
	ppl_F_HOUR,
	ppl_F_MIN,
	ppl_F_SEC,
	ppl_F_TIMEAP,
	ppl_F_VER,
	ppl_F_NOCHAR,
	ppl_F_YESCHAR,
	ppl_F_STRIPATX,
	ppl_F_REPLACE,
	ppl_F_STRIP,
	ppl_F_INKEY,
	ppl_F_STRING,
	ppl_F_MASK_PWD,
	ppl_F_MASK_ALPHA,
	ppl_F_MASK_NUM,
	ppl_F_MASK_ALNUM,
	ppl_F_MASK_FILE,
	ppl_F_MASK_PATH,
	ppl_F_MASK_ASCII,
	ppl_F_CURCONF,
	ppl_F_PCBDAT,
	ppl_F_PPEPATH,
	ppl_F_VALDATE,
	ppl_F_VALTIME,
	ppl_F_U_MSGRD,
	ppl_F_U_MSGWR,
	ppl_F_PCBNODE,
	ppl_F_READLINE,
	ppl_F_SYSOPSEC,
	ppl_F_ONLOCAL,
	ppl_F_UN_STAT,
	ppl_F_UN_NAME,
	ppl_F_UN_CITY,
	ppl_F_UN_OPER,
	ppl_F_CURSEC,
	ppl_F_GETTOKEN,
	ppl_F_MINLEFT,
	ppl_F_MINON,
	ppl_F_GETENV,
	ppl_F_CALLID,
	ppl_F_REGAL,
	ppl_F_REGAH,
	ppl_F_REGBL,
	ppl_F_REGBH,
	ppl_F_REGCL,
	ppl_F_REGCH,
	ppl_F_REGDL,
	ppl_F_REGDH,
	ppl_F_REGAX,
	ppl_F_REGBX,
	ppl_F_REGCX,
	ppl_F_REGDX,
	ppl_F_REGSI,
	ppl_F_REGDI,
	ppl_F_REGF,
	ppl_F_REGCF,
	ppl_F_REGDS,
	ppl_F_REGES,
	ppl_F_B2W,
	ppl_F_PEEK,
	ppl_F_PEEKW,
	ppl_F_MKADDR,
	ppl_F_EXIST,
	ppl_F_I2S,
	ppl_F_S2I,
	ppl_F_CARRIER,
	ppl_F_TOKENSTR,
	ppl_F_CDON,
	ppl_F_LANGEXT,
	ppl_F_ANSION,
	ppl_F_VALCC,
	ppl_F_FMTCC,
	ppl_F_CCTYPE,
	ppl_F_GETX,
	ppl_F_GETY,
	ppl_F_AND,
	ppl_F_OR,
	ppl_F_XOR,
	ppl_F_NOT,
	ppl_F_U_PWDHIST,
	ppl_F_U_PWDLC,
	ppl_F_U_PWDTC,
	ppl_F_U_STAT,
	ppl_F_DEFCOLOR,
	ppl_F_ABS,
	ppl_F_GRAFMODE,
	ppl_F_PSA,
	ppl_F_FILEINF,
	ppl_F_PPENAME,
	ppl_F_MKDATE,
	ppl_F_CURCOLOR,
	ppl_F_KINKEY,
	ppl_F_MINKEY,
	ppl_F_MAXNODE,
	ppl_F_SLPATH,
	ppl_F_HELPPATH,
	ppl_F_TEMPPATH,
	ppl_F_MODEM,
	ppl_F_LOGGEDON,
	ppl_F_CALLNUM,
	ppl_F_MGETBYTE,
	ppl_F_TOKCOUNT,
	ppl_F_U_RECNUM,
	ppl_F_U_INCONF,
	ppl_F_PEEKDW,
	ppl_F_DBGLEVEL,
	ppl_F_SCRTEXT,
	ppl_F_SHOWSTAT,
	ppl_F_PAGESTAT,
	ppl_F_REPLACESTR,
	ppl_F_STRIPSTR,
	ppl_F_TOBIGSTR,
	ppl_F_TOBOOLEAN,
	ppl_F_TOBYTE,
	ppl_F_TODATE,
	ppl_F_TODOUBLE,
	ppl_F_TOEDATE,
	ppl_F_TOINTEGER,
	ppl_F_TOMONEY,
	ppl_F_TOREAL,
	ppl_F_TOSHORT,
	ppl_F_TOINT,
	ppl_F_TOTIME,
	ppl_F_TODWORD,
	ppl_F_TOWORD,
	ppl_F_MIXED,
	ppl_F_ALIAS,
	ppl_F_CONFREG,
	ppl_F_CONFEXP,
	ppl_F_CONFSEL,
	ppl_F_CONFSYS,
	ppl_F_CONFMW,
	ppl_F_LPRINTED,
	ppl_F_ISNONSTOP,
	ppl_F_ERRCORRECT,
	ppl_F_CONFALIAS,
	ppl_F_USERALIAS,
	ppl_F_CURUSER,
	ppl_F_U_LMR,
	ppl_F_CHATSTAT,
	ppl_F_DEFANS,
	ppl_F_LASTANS,
	ppl_F_MEGANUM,
	ppl_F_EVTTIMEADJ,
	ppl_F_ISBITSET,
	ppl_F_FMTREAL,
	ppl_F_FLAGCNT,
	ppl_F_KBDBUFSIZE,
	ppl_F_PPLBUFSIZE,
	ppl_F_KBDFILUSED,
	ppl_F_LOMSGNUM,
	ppl_F_HIMSGNUM,
	ppl_F_DRIVESPACE,
	ppl_F_OUTBYTES,
	ppl_F_HICONFNUM,
	ppl_F_INBYTES,
	ppl_F_CRC32,
	ppl_F_PCBMAC,
	ppl_F_ACTMSGNUM,
	ppl_F_STACKLEFT,
	ppl_F_STACKERR,
	ppl_F_DGETALIAS,
	ppl_F_DBOF,
	ppl_F_DCHANGED,
	ppl_F_DDECIMALS,
	ppl_F_DDELETED,
	ppl_F_DEOF,
	ppl_F_DERR,
	ppl_F_DFIELDS,
	ppl_F_DLENGTH,
	ppl_F_DNAME,
	ppl_F_DRECCOUNT,
	ppl_F_DRECNO,
	ppl_F_DTYPE,
	ppl_F_FNEXT,
	ppl_F_DNEXT,
	ppl_F_TODDATE,
	ppl_F_DCLOSEALL,
	ppl_F_DOPEN,
	ppl_F_DCLOSE,
	ppl_F_DSETALIAS,
	ppl_F_DPACK,
	ppl_F_DLOCKF,
	ppl_F_DLOCK,
	ppl_F_DLOCKR,
	ppl_F_DUNLOCK,
	ppl_F_DNOPEN,
	ppl_F_DNCLOSE,
	ppl_F_DNCLOSEALL,
	ppl_F_DNEW,
	ppl_F_DADD,
	ppl_F_DAPPEND,
	ppl_F_DTOP,
	ppl_F_DGO,
	ppl_F_DBOTTOM,
	ppl_F_DSKIP,
	ppl_F_DBLANK,
	ppl_F_DDELETE,
	ppl_F_DRECALL,
	ppl_F_DTAG,
	ppl_F_DSEEK,
	ppl_F_DFBLANK,
	ppl_F_DGET,
	ppl_F_DPUT,
	ppl_F_DFCOPY,
	ppl_F_DSELECT,
	ppl_F_DCHKSTAT,
	ppl_F_PCBACCOUNT,
	ppl_F_PCBACCSTAT,
	ppl_F_DERRMSG,
	ppl_F_ACCOUNT,
	ppl_F_SCANMSGHDR,
	ppl_F_CHECKRIP,
	ppl_F_RIPVER,
	ppl_F_QWKLIMITS,
	ppl_F_FINDFIRST,
	ppl_F_FINDNEXT,
	ppl_F_USELMRS,
	ppl_F_CONFINFO,
	ppl_F_TINKEY,
	ppl_F_CWD,
	ppl_F_INSTRR,
	ppl_F_FDORDAKA,
	ppl_F_FDORDORG,
	ppl_F_FDORDAREA,
	ppl_F_FDOQRD,
	ppl_F_GETDRIVE,
	ppl_F_SETDRIVE,
	ppl_F_BS2I,
	ppl_F_BD2I,
	ppl_F_I2BS,
	ppl_F_I2BD,
	ppl_F_FTELL,
	ppl_F_OS,
    ppl_F_void, // 287
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 290
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 300
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 310
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 320
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 330
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 340
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 350
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 360
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 370
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 380
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void, // 390
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_void,
    ppl_F_DSCRTEXT, // 400
    ppl_F_DGETX, // 401
    ppl_F_DGETY, // 402
    ppl_F_DUALSCR, // 403
	ppl_F_CONFNAME, // 404
    ppl_F_SYSTEMPATH, // 405
    ppl_F_BETA, // 406
    ppl_F_SCREENCLEARED, // 407
    ppl_F_CALL, // 408
    ppl_F_LASTEXITVALUE, // 409
    ppl_F_FREE, // 410
    ppl_F_COMINIT, // 411
    ppl_F_GETCOMSTAT, // 412
    ppl_F_GETUARTTYPE, // 413
    ppl_F_GETPROFILE, // 414
	ppl_F_FRTDAT, // 415
	ppl_F_FILEMATCH, // 416
	ppl_F_GETNEXTMSG, // 417
 	ppl_F_HIMSGNUMC, // 418
	ppl_F_LOMSGNUMC, // 419
    ppl_F_ROOTPATH, // 420
	ppl_F_TOSDATE, // 421
	ppl_F_LANGFILE, // 422
	};

#endif