/*% cc -O -K -dos % -o crc.exe
*/

/*
 *  Crc - 32 BIT ANSI X3.66 CRC checksum files
 */
#include <stdio.h>
#include <share.h>
#include "..\com\sharing.h"

#define OK 0
#define ERROR (-1)
#define LINT_ARGS

/* Need an unsigned type capable of holding 32 bits; */
typedef unsigned long int UNS_32_BITS;

/*
 * Copyright (C) 1986 Gary S. Brown.  You may use this program, or
 * code or tables extracted from it, as desired without restriction.
 */
/* First, the polynomial itself and its table of feedback terms.  The  */
/* polynomial is                                                       */
/* X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X^1+X^0 */
/* Note that we take it "backwards" and put the highest-order term in  */
/* the lowest-order bit.  The X^32 term is "implied"; the LSB is the   */
/* X^31 term, etc.  The X^0 term (usually shown as "+1") results in    */
/* the MSB being 1.                                                    */

/* Note that the usual hardware shift register implementation, which   */
/* is what we're using (we're merely optimizing it by doing eight-bit  */
/* chunks at a time) shifts bits into the lowest-order term.  In our   */
/* implementation, that means shifting towards the right.  Why do we   */
/* do it this way?  Because the calculated CRC must be transmitted in  */
/* order from highest-order term to lowest-order term.  UARTs transmit */
/* characters in order from LSB to MSB.  By storing the CRC this way,  */
/* we hand it to the UART in the order low-byte to high-byte; the UART */
/* sends each low-bit to hight-bit; and the result is transmission bit */
/* by bit from highest- to lowest-order term without requiring any bit */
/* shuffling on our part.  Reception works similarly.                  */

/* The feedback terms table consists of 256, 32-bit entries.  Notes:   */
/*                                                                     */
/*  1. The table can be generated at runtime if desired; code to do so */
/*     is shown later.  It might not be obvious, but the feedback      */
/*     terms simply represent the results of eight shift/xor opera-    */
/*     tions for all combinations of data and CRC register values.     */
/*                                                                     */
/*  2. The CRC accumulation logic is the same for all CRC polynomials, */
/*     be they sixteen or thirty-two bits wide.  You simply choose the */
/*     appropriate table.  Alternatively, because the table can be     */
/*     generated at runtime, you can start by generating the table for */
/*     the polynomial in question and use exactly the same "updcrc",   */
/*     if your application needn't simultaneously handle two CRC       */
/*     polynomials.  (Note, however, that XMODEM is strange.)          */
/*                                                                     */
/*  3. For 16-bit CRCs, the table entries need be only 16 bits wide;   */
/*     of course, 32-bit entries work OK if the high 16 bits are zero. */
/*                                                                     */
/*  4. The values must be right-shifted by eight bits by the "updcrc"  */
/*     logic; the shift must be unsigned (bring in zeroes).  On some   */
/*     hardware you could probably optimize the shift in assembler by  */
/*     using byte-swap instructions.                                   */

static UNS_32_BITS far crc_32_tab[] = { /* CRC polynomial 0xedb88320 */
/*0x00000000L, 0x77073096L, 0xee0e612cL, 0x990951baL, 0x076dc419L, 0x706af48fL, 0xe963a535L, 0x9e6495a3L,
0x0edb8832L, 0x79dcb8a4L, 0xe0d5e91eL, 0x97d2d988L, 0x09b64c2bL, 0x7eb17cbdL, 0xe7b82d07L, 0x90bf1d91L,
0x1db71064L, 0x6ab020f2L, 0xf3b97148L, 0x84be41deL, 0x1adad47dL, 0x6ddde4ebL, 0xf4d4b551L, 0x83d385c7L,
0x136c9856L, 0x646ba8c0L, 0xfd62f97aL, 0x8a65c9ecL, 0x14015c4fL, 0x63066cd9L, 0xfa0f3d63L, 0x8d080df5L,
0x3b6e20c8L, 0x4c69105eL, 0xd56041e4L, 0xa2677172L, 0x3c03e4d1L, 0x4b04d447L, 0xd20d85fdL, 0xa50ab56bL,
0x35b5a8faL, 0x42b2986cL, 0xdbbbc9d6L, 0xacbcf940L, 0x32d86ce3L, 0x45df5c75L, 0xdcd60dcfL, 0xabd13d59L,
0x26d930acL, 0x51de003aL, 0xc8d75180L, 0xbfd06116L, 0x21b4f4b5L, 0x56b3c423L, 0xcfba9599L, 0xb8bda50fL,
0x2802b89eL, 0x5f058808L, 0xc60cd9b2L, 0xb10be924L, 0x2f6f7c87L, 0x58684c11L, 0xc1611dabL, 0xb6662d3dL,
0x76dc4190L, 0x01db7106L, 0x98d220bcL, 0xefd5102aL, 0x71b18589L, 0x06b6b51fL, 0x9fbfe4a5L, 0xe8b8d433L,
0x7807c9a2L, 0x0f00f934L, 0x9609a88eL, 0xe10e9818L, 0x7f6a0dbbL, 0x086d3d2dL, 0x91646c97L, 0xe6635c01L,
0x6b6b51f4L, 0x1c6c6162L, 0x856530d8L, 0xf262004eL, 0x6c0695edL, 0x1b01a57bL, 0x8208f4c1L, 0xf50fc457L,
0x65b0d9c6L, 0x12b7e950L, 0x8bbeb8eaL, 0xfcb9887cL, 0x62dd1ddfL, 0x15da2d49L, 0x8cd37cf3L, 0xfbd44c65L,
0x4db26158L, 0x3ab551ceL, 0xa3bc0074L, 0xd4bb30e2L, 0x4adfa541L, 0x3dd895d7L, 0xa4d1c46dL, 0xd3d6f4fbL,
0x4369e96aL, 0x346ed9fcL, 0xad678846L, 0xda60b8d0L, 0x44042d73L, 0x33031de5L, 0xaa0a4c5fL, 0xdd0d7cc9L,
0x5005713cL, 0x270241aaL, 0xbe0b1010L, 0xc90c2086L, 0x5768b525L, 0x206f85b3L, 0xb966d409L, 0xce61e49fL,
0x5edef90eL, 0x29d9c998L, 0xb0d09822L, 0xc7d7a8b4L, 0x59b33d17L, 0x2eb40d81L, 0xb7bd5c3bL, 0xc0ba6cadL,
0xedb88320L, 0x9abfb3b6L, 0x03b6e20cL, 0x74b1d29aL, 0xead54739L, 0x9dd277afL, 0x04db2615L, 0x73dc1683L,
0xe3630b12L, 0x94643b84L, 0x0d6d6a3eL, 0x7a6a5aa8L, 0xe40ecf0bL, 0x9309ff9dL, 0x0a00ae27L, 0x7d079eb1L,
0xf00f9344L, 0x8708a3d2L, 0x1e01f268L, 0x6906c2feL, 0xf762575dL, 0x806567cbL, 0x196c3671L, 0x6e6b06e7L,
0xfed41b76L, 0x89d32be0L, 0x10da7a5aL, 0x67dd4accL, 0xf9b9df6fL, 0x8ebeeff9L, 0x17b7be43L, 0x60b08ed5L,
0xd6d6a3e8L, 0xa1d1937eL, 0x38d8c2c4L, 0x4fdff252L, 0xd1bb67f1L, 0xa6bc5767L, 0x3fb506ddL, 0x48b2364bL,
0xd80d2bdaL, 0xaf0a1b4cL, 0x36034af6L, 0x41047a60L, 0xdf60efc3L, 0xa867df55L, 0x316e8eefL, 0x4669be79L,
0xcb61b38cL, 0xbc66831aL, 0x256fd2a0L, 0x5268e236L, 0xcc0c7795L, 0xbb0b4703L, 0x220216b9L, 0x5505262fL,
0xc5ba3bbeL, 0xb2bd0b28L, 0x2bb45a92L, 0x5cb36a04L, 0xc2d7ffa7L, 0xb5d0cf31L, 0x2cd99e8bL, 0x5bdeae1dL,
0x9b64c2b0L, 0xec63f226L, 0x756aa39cL, 0x026d930aL, 0x9c0906a9L, 0xeb0e363fL, 0x72076785L, 0x05005713L,
0x95bf4a82L, 0xe2b87a14L, 0x7bb12baeL, 0x0cb61b38L, 0x92d28e9bL, 0xe5d5be0dL, 0x7cdcefb7L, 0x0bdbdf21L,
0x86d3d2d4L, 0xf1d4e242L, 0x68ddb3f8L, 0x1fda836eL, 0x81be16cdL, 0xf6b9265bL, 0x6fb077e1L, 0x18b74777L,
0x88085ae6L, 0xff0f6a70L, 0x66063bcaL, 0x11010b5cL, 0x8f659effL, 0xf862ae69L, 0x616bffd3L, 0x166ccf45L,
0xa00ae278L, 0xd70dd2eeL, 0x4e048354L, 0x3903b3c2L, 0xa7672661L, 0xd06016f7L, 0x4969474dL, 0x3e6e77dbL,
0xaed16a4aL, 0xd9d65adcL, 0x40df0b66L, 0x37d83bf0L, 0xa9bcae53L, 0xdebb9ec5L, 0x47b2cf7fL, 0x30b5ffe9L,
0xbdbdf21cL, 0xcabac28aL, 0x53b39330L, 0x24b4a3a6L, 0xbad03605L, 0xcdd70693L, 0x54de5729L, 0x23d967bfL,
0xb3667a2eL, 0xc4614ab8L, 0x5d681b02L, 0x2a6f2b94L, 0xb40bbe37L, 0xc30c8ea1L, 0x5a05df1bL, 0x2d02ef8dL*/
0xD202Ef8dL, 0xA505DF1BL, 0x3C0C8EA1L, 0x4B0BBE37L, 0xD56F2B94L, 0xA2681B02L, 0x3B614AB8L, 0x4C667A2EL,
0xDCD967BFL, 0xABDE5729L, 0x32D70693L, 0x45D03605L, 0xDBB4A3A6L, 0xACB39330L, 0x35BAC28AL, 0x42BDF21CL, 
0xCFB5FFE9L, 0xB8B2CF7FL, 0x21BB9EC5L, 0x56BCAE53L, 0xC8D83BF0L, 0xBFDF0B66L, 0x26D65ADCL, 0x51D16A4AL, 
0xC16E77DBL, 0xB669474DL, 0x2F6016F7L, 0x58672661L, 0xC603B3C2L, 0xB1048354L, 0x280DD2EEL, 0x5F0AE278L, 
0xE96CCF45L, 0x9E6BFFD3L, 0x0762AE69L, 0x70659EFFL, 0xEE010B5CL, 0x99063BCAL, 0x000F6A70L, 0x77085AE6L, 
0xE7B74777L, 0x90B077E1L, 0x09B9265BL, 0x7EBE16CDL, 0xE0DA836EL, 0x97DDB3F8L, 0x0ED4E242L, 0x79D3D2D4L, 
0xF4DBDF21L, 0x83DCEFB7L, 0x1AD5BE0DL, 0x6DD28E9BL, 0xF3B61B38L, 0x84B12BAEL, 0x1DB87A14L, 0x6ABF4A82L, 
0xFA005713L, 0x8D076785L, 0x140E363FL, 0x630906A9L, 0xFD6D930AL, 0x8A6AA39CL, 0x1363F226L, 0x6464C2B0L, 
0xA4DEAE1DL, 0xD3D99E8BL, 0x4AD0CF31L, 0x3DD7FFA7L, 0xA3B36A04L, 0xD4B45A92L, 0x4DBD0B28L, 0x3ABA3BBEL, 
0xAA05262FL, 0xDD0216B9L, 0x440B4703L, 0x330C7795L, 0xAD68E236L, 0xDA6FD2A0L, 0x4366831AL, 0x3461B38CL, 
0xB969BE79L, 0xCE6E8EEFL, 0x5767DF55L, 0x2060EFC3L, 0xBE047A60L, 0xC9034AF6L, 0x500A1B4CL, 0x270D2BDAL, 
0xB7B2364BL, 0xC0B506DDL, 0x59BC5767L, 0x2EBB67F1L, 0xB0DFF252L, 0xC7D8C2C4L, 0x5ED1937EL, 0x29D6A3E8L,
0x9FB08ED5L, 0xE8B7BE43L, 0x71BEEFF9L, 0x06B9DF6FL, 0x98DD4ACCL, 0xEFDA7A5AL, 0x76D32BE0L, 0x01D41B76L, 
0x916B06E7L, 0xE66C3671L, 0x7F6567CBL, 0x0862575DL, 0x9606C2FEL, 0xE101F268L, 0x7808A3D2L, 0x0F0F9344L,
0x82079EB1L, 0xF500AE27L, 0x6C09FF9DL, 0x1B0ECF0BL, 0x856A5AA8L, 0xF26D6A3EL, 0x6B643B84L, 0x1C630B12L, 
0x8CDC1683L, 0xFBDB2615L, 0x62D277AFL, 0x15D54739L, 0x8BB1D29AL, 0xFCB6E20CL, 0x65BFB3B6L, 0x12B88320L, 
0x3FBA6CADL, 0x48BD5C3BL, 0xD1B40D81L, 0xA6B33D17L, 0x38D7A8B4L, 0x4FD09822L, 0xD6D9C998L, 0xA1DEF90EL, 
0x3161E49FL, 0x4666D409L, 0xDF6F85B3L, 0xA868B525L, 0x360C2086L, 0x410B1010L, 0xD80241AAL, 0xAF05713CL, 
0x220D7CC9L, 0x550A4C5FL, 0xCC031DE5L, 0xBB042D73L, 0x2560B8D0L, 0x52678846L, 0xCB6ED9FCL, 0xBC69E96AL, 
0x2CD6F4FBL, 0x5BD1C46DL, 0xC2D895D7L, 0xB5DFA541L, 0x2BBB30E2L, 0x5CBC0074L, 0xC5B551CEL, 0xB2B26158L, 
0x04D44C65L, 0x73D37CF3L, 0xEADA2D49L, 0x9DDD1DDFL, 0x03B9887CL, 0x74BEB8EAL, 0xEDB7E950L, 0x9AB0D9C6L,
0x0A0FC457L, 0x7D08F4C1L, 0xE401A57BL, 0x930695EDL, 0x0D62004EL, 0x7A6530D8L, 0xE36C6162L, 0x946B51F4L,
0x19635C01L, 0x6E646C97L, 0xF76D3D2DL, 0x806A0DBBL, 0x1E0E9818L, 0x6909A88EL, 0xF000F934L, 0x8707C9A2L,
0x17B8D433L, 0x60BFE4A5L, 0xF9B6B51FL, 0x8EB18589L, 0x10D5102AL, 0x67D220BCL, 0xFEDB7106L, 0x89DC4190L,
0x49662D3DL, 0x3E611DABL, 0xA7684C11L, 0xD06F7C87L, 0x4E0BE924L, 0x390CD9B2L, 0xA0058808L, 0xD702B89EL,
0x47BDA50FL, 0x30BA9599L, 0xA9B3C423L, 0xDEB4F4B5L, 0x40D06116L, 0x37D75180L, 0xAEDE003AL, 0xD9D930ACL,
0x54D13D59L, 0x23D60DCFL, 0xBADF5C75L, 0xCDD86CE3L, 0x53BCF940L, 0x24BBC9D6L, 0xBDB2986CL, 0xCAB5A8FAL,
0x5A0AB56BL, 0x2D0D85FDL, 0xB404D447L, 0xC303E4D1L, 0x5D677172L, 0x2A6041E4L, 0xB369105EL, 0xC46E20C8L,
0x72080DF5L, 0x050F3D63L, 0x9C066CD9L, 0xEB015C4FL, 0x7565C9ECL, 0x0262F97AL, 0x9B6BA8C0L, 0xEC6C9856L,
0x7CD385C7L, 0x0BD4B551L, 0x92DDE4EBL, 0xE5DAD47DL, 0x7BBE41DEL, 0x0CB97148L, 0x95B020F2L, 0xE2B71064L,
0x6FBF1D91L, 0x18B82D07L, 0x81B17CBDL, 0xF6B64C2BL, 0x68D2D988L, 0x1FD5E91EL, 0x86DCB8A4L, 0xF1DB8832L,
0x616495A3L, 0x1663A535L, 0x8F6AF48FL, 0xF86DC419L, 0x660951BAL, 0x110E612CL, 0x88073096L, 0xFF000000L 
};

#define UPDC32(octet, crc) (crc_32_tab[((crc) ^ (octet)) & 0xff] ^ ((crc) >> 8))

unsigned long int crc32file(char *name)
{
	register FILE *fin;
	register unsigned long oldcrc32;
	register unsigned long crc32;
	register unsigned long oldcrc;
	register c;
	register long l;


//	oldcrc32 = 0xFFFFFFFFL;
	oldcrc32 = 0;
	if ((fin=fopen_share(name, "rb", SH_DENYNONE))==NULL)
		return 0;
	while (1) {
		c=getc(fin);
		if (feof(fin)) break;
		oldcrc32 = UPDC32(c, oldcrc32);
	}

	if (ferror(fin)){
		fclose(fin);
		return 0;
	}
	else {
		crc32 = oldcrc32;  oldcrc = oldcrc32 = ~oldcrc32;

		fclose(fin);

		return crc32;
	}
#pragma warn -aus
}
#pragma warn .aus

unsigned long int crc32str(char *name)
{
	register unsigned long oldcrc32;
	register unsigned long crc32;
//	register unsigned long oldcrc;
    register long l;
	register c;
    register int a=0;


//	oldcrc32 = 0xFFFFFFFFL;
	oldcrc32 = 0;
	while (name[a] != 0) {
		c=name[a];
		oldcrc32 = UPDC32(c, oldcrc32);
        a++;
	}

	crc32 = oldcrc32;  /*oldcrc = */oldcrc32 = ~oldcrc32;

	return crc32;
#pragma warn -aus
}
#pragma warn .aus


/* End of crc.c */
