/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

Startup code

*/


#include <signal.h>
#include <string.h>
#include <alloc.h>
#include <mem.h>
#include <share.h>
#include "..\lang\fortify.h"
#include "..\lang\ppl.h"
#include "..\com\system.h"
#include "..\com\pcbdat.h"
#include "..\com\keywatch.h"
#include "..\com\api.h"
#include "..\com\async.h"
#include "..\com\vio.h"
#include "..\dual\dual.h"
#include "..\com\detect.h"
#include "..\com\profile.h"
#include "..\com\sharing.h"


int frontierStartup(int argc, char **argv)
{
FILE *in;
int a;
int nodeAssigned=0;

argc=argc;
/*argv=argv;

strcpy(tmpStr, "X:\\");
tmpStr[0] = 'A' + getdisk();
getcurdir(0, &tmpStr[3]);
if (tmpStr[strlen(tmpStr)-1] != '\\') strcat(tmpStr, "\\");

fnsplit(tmpStr, tmpDrive, tmpDir, NULL, NULL);
*/

fnsplit(argv[0], tmpDrive, tmpDir, NULL, NULL);

fnmerge(iniFile, tmpDrive, tmpDir, "FRONTIER", ".INI");
fnmerge(systemPath, tmpDrive, tmpDir, NULL, NULL);

floatNodes=1;
for (a=1;a<1000;a++)
	{
    sprintf(tmpStr, "NODE.%d", a);
    if (!access(tmpStr,0))
    	{
        node = a;
        sprintf(tmpStr, "Node%d", node);
        if (getProfileInt(tmpStr, "NoFloat", 0, iniFile) == 1)
        	{
	        floatNodes=0;
            nodeAssigned=1;
            }
        break;
        }
    }

if (!nodeAssigned)
	{
    for (a=1;a<1000;a++)
	    {
        sprintf(tmpStr, "FNODE.%d", a);
        if (!access(tmpStr,0))
    	    {
            unlink(tmpStr);
            node = a;
            nodeAssigned=1;
            break;
            }
        }
	}

DetectOS();
installAPIHandler();
atexit(unInstallAPIHandler);

#ifndef DEBUG
keyboardisr();            /* install interrupt handler */
atexit(remkeyboardisr);   /* atexit remove interrupt handler */
#endif

/**systemPath = getdisk() + 'A';
strcpy(systemPath+1, ":\\");
getcurdir(0, systemPath + 3);*/

readPcbDat();

VIOopen();
VIOgotoxy(0, 0);
VIOclear(0, 0, 79, 24);
updateStatusBar();

/*if (debug_present())
   	{
	if (VIOsegment() == 0xB000)
        vid = (char *)0xB8000000;
	debugScreen = 1;
    debug_cls();
	debug_puts("Secondary video adapter detected and used!\n");
    }*/

ppeReturnValue.value = calloc(256,1);
*(char*)(ppeReturnValue.value) = 255;

fnsplit(netFilesPath, tmpDrive, tmpDir, NULL, NULL);
if (floatNodes==1 && !nodeAssigned)
	{
    if (node == 0) node=1;
    while (1)
	    {
        sprintf(tmpStr, "Node%d", node);
        if (!getProfileInt(tmpStr, "NoFloat", 0, iniFile))
        	{
	        sprintf(tmpExt, ".%03d", node);
	        fnmerge(tmpStr, tmpDrive, tmpDir, "NODE", tmpExt);
            if (access(tmpStr,0))
    	        {
    	        strcpy(nodeFilename, tmpStr);
                nodeAssigned=1;
                break;
                }
            }
        if (++node > 999)
	        {
			fppe_runtimeError("No free node.");
            frontierCloseup();
    	    }
        }
    }
else
    {
    sprintf(tmpExt, ".%03d", node);
	fnmerge(nodeFilename, tmpDrive, tmpDir, "NODE", tmpExt);
    }

createNodeFile();

getProfileString(pathsSection, "CallersLog", "CALLERS", tmpStr, 2000, iniFile);
fnsplit(tmpStr, tmpDrive, tmpDir, tmpFile, tmpExt);
sprintf(tmpExt, ".%d", node);
fnmerge(tmpStr, tmpDrive, tmpDir, tmpFile, tmpExt);
callersLogFile=malloc(strlen(tmpStr)+1);
strcpy(callersLogFile, tmpStr);

logFile = fopen_share(callersLogFile, "a+t", SH_DENYWR);

lastKey = *(long*)0x0040006CL;

return 1;
}

