/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// PowerPPL Compiler - Debug Symbols Stripper

#include <stdio.h>
#include <process.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>

main (int argc, char **argv)
{
char drive[MAXDRIVE];
char dir[MAXDIR];
char file[MAXFILE];
char ext[MAXEXT];
char fullppe[MAXPATH];
char fullout[MAXPATH];
char sign[6];
long normalSize=0;
char *buffer;

FILE *ppe;
FILE *out;

printf("PowerPPL Debugger Symbol Table Sripper v1.0 - (c) 1997 The Aegis Corporation\n");
if (argc < 2)
	{
	printf("PPSTRIP <filename[.PPE]>\n");
	exit(-1);
    }

fnsplit(argv[1], drive, dir, file, ext);
if (ext[0] == 0)
	strcpy(ext, ".ppe");
fnmerge(fullppe, drive, dir, file, ext);
tmpnam(fullout);

if ((ppe = fopen(fullppe,"rb")) == NULL)
	{printf("Could not open %s\n", fullppe);
    exit(-1);}

if ((out = fopen(fullout,"wb")) == NULL)
	{printf("Could not create temporary file %s\n", fullppe);
    exit(-1);}

fseek(ppe, -12, SEEK_END);
fread(sign, 6, 1, ppe);
if (!strncmp(sign, "PPSYM1", 6))
    {
    fseek(ppe, 2, SEEK_CUR);
	fread(&normalSize, 4, 1, ppe);
    }
else
	{printf("%s does not contains symbol table\n", fullppe);
    exit(0);}

fseek(ppe, 0, SEEK_SET);
buffer = (char *)malloc(normalSize);
fread(buffer, normalSize, 1, ppe);
fwrite(buffer, normalSize, 1, out);
fclose(ppe);
fclose(out);
unlink(fullppe);
rename(fullout, fullppe);
}
