/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/*
                           + Project Frontier +

 PPL Runtime

 PPL STATEMENTS 

*/

#define YYSTYPE pplvar*

#include <alloc.h>
#include <ctype.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <fcntl.h>
#include <share.h>
#include <sys/stat.h>
#include <string.h>
#include <io.h>
#include <dir.h>
#include <time.h>
#include <sys\types.h>
#include <process.h>
#include <errno.h>
#include "..\lang\ppl_type.h"
#include "..\lang\ppl_tab.h"
#include "..\lang\ppl.h"
#include "..\lang\funcs.h"
#include "..\lang\procs.h"
#include "..\com\rs232.h"
#include "..\com\async2.h"
#include "..\com\system.h"
#include "..\com\closeup.h"
#include "..\lang\fortify.h"
#include "..\dual\dual.h"
#include "..\com\msgs.h"
#include "..\com\tpa.h"
#include "..\ppc\profile\profile.h"
#include "..\com\keywatch.h"
#include "..\com\sharing.h"
#include "..\lang\boymoor.h"
#include "..\lang\usersys.h"
#include "..\lang\pcbsys.h"
#include "..\lang\frtsys.h"
#include "..\com\pcbdat.h"

int far RdUNetNode=0;

typedef struct {
	char *p;
    int l;
    } prFoundType;

/*

  -  

*/

/*

 END SCRIPT 

*/

void ppl_S_END(void)
{
endPPE=1;
}

/*

 CLS - CLEAR SCREEN 

*/

void ppl_S_CLS(void)
{
cls();
}

/*

 CLREOL - CLEAR END OF LINE 

*/

void ppl_S_CLREOL(void)
{
clrEol();
}

void ppl_S_MORE(void)
{
more();
}

/*

 WAIT - WAIT FOR ENTER KEY 

*/

void ppl_S_WAIT(void)
{
wait();
}

/*

 COLOR - SET CURRENT WRITING COLOR 

*/

void ppl_S_COLOR(void)
{
color((signed long)fppe_getValue(argument[0]));
}

/*

 GOTO - INCONDITIONAL JUMP 

*/

void ppl_S_GOTO(void)
{
// mohahaha :)
}

/*

 LET - ASSIGNEMENT 

*/

void ppl_S_LET(void)
{
fppe_assignVar(argument[0], argument[1]);
}

/*

 PRINT - WRITE TO SCREEN 

*/

void ppl_S_PRINT(void)
{
char d;

for (d=0;d<narg;d++)
    output(fppe_Cstr(fppe_toStringVar(argument[d])->value), MASK_SYSOP|MASK_USER);
}

/*

 PRINTLN - PRINT WITH A NEW LINE 

*/

void ppl_S_PRINTLN(void)
{
ppl_S_PRINT();
output("\n",MASK_SYSOP|MASK_USER);
}

/*

 IF - BOOLEAN TEST 

*/

void ppl_S_IF(void)
{
IFresult = (fppe_getValue(argument[0]) != 0);
}

/*

  -  

*/

void ppl_S_CONFFLAG(void)
{
unsigned char cur;
int c=fppe_getValue(argument[0]);
cur = confFlags(c) | (unsigned char)fppe_getValue(argument[1]);
setConfFlags(c, cur, currentUserNum);
}

/*

  -  

*/

void ppl_S_CONFUNFLAG(void)
{
unsigned char cur;
int c=fppe_getValue(argument[0]);
cur = confFlags(c) ^ (unsigned char)fppe_getValue(argument[1]);
setConfFlags(c, cur, currentUserNum);
}

/*

 DISPFILE - DISPLAY A FILE 

*/

void ppl_S_DISPFILE(void)
{
getExistingDisplayFile(tmpStr, fppe_Cstr(fppe_toStringVar(argument[0])->value), fppe_getValue(argument[1]));
dispfile(tmpStr);
}

/*

  -  

*/

void ppl_S_INPUT(void)
{
ppl_input(argument[0], argument[1], 14, 60, mask_ascii(), INPUT_FIELDLEN | INPUT_GUIDE);
}

/*

 FCREATE 

*/

void ppl_S_FCREATE(void)
{
int omode, smode, f;

smode = fppe_getValue(argument[3]);

switch (smode)
	{
    case 0: // S_DN
    	smode = SH_DENYNONE;
        break;
    case 1: // S_DR
    	smode = SH_DENYRD;
        break;
    case 2: // S_DW
    	smode = SH_DENYWR;
        break;
    case 3: // S_DB
    	smode = SH_DENYRW;
        break;
    }

f = fppe_getValue(argument[0]);
strcpy(tmpFile, fppe_Cstr(fppe_toStringVar(argument[1])->value));

if ((fileHandle[f+1] = fopen_share(tmpFile, "wb", smode)) == NULL)
	ferr[f+1]=1;
else
	ferr[f+1]=0;
}

/*

 FOPEN - OPEN A FILE 

*/

void ppl_S_FOPEN(void)
{
int omode, smode, f;
char o[5]="";

omode = fppe_getValue(argument[2]);
smode = fppe_getValue(argument[3]);

switch (omode)
	{
    case 0: // O_RD
    	strcpy(o, "rb");
        break;
    case 1: // O_WR
    	strcpy(o, "wb");
        break;
    case 2: // O_RW
    	strcpy(o, "r+b");
        break;
    }

switch (smode)
	{
    case 0: // S_DN
    	smode = SH_DENYNONE;
        break;
    case 1: // S_DR
    	smode = SH_DENYRD;
        break;
    case 2: // S_DW
    	smode = SH_DENYWR;
        break;
    case 3: // S_DB
    	smode = SH_DENYRW;
        break;
    }

f = fppe_getValue(argument[0]);
strcpy(tmpFile, fppe_Cstr(fppe_toStringVar(argument[1])->value));

if ((fileHandle[f+1] = fopen_share(tmpFile, o, smode)) == NULL)
	ferr[f+1]=1;
else
	ferr[f+1]=0;
}

/*

  -  

*/

void ppl_S_FAPPEND(void)
{
int omode, smode, f;

smode = fppe_getValue(argument[3]);

switch (smode)
	{
    case 0: // S_DN
    	smode = SH_DENYNONE;
        break;
    case 1: // S_DR
    	smode = SH_DENYRD;
        break;
    case 2: // S_DW
    	smode = SH_DENYWR;
        break;
    case 3: // S_DB
    	smode = SH_DENYRW;
        break;
    }

f = fppe_getValue(argument[0]);
strcpy(tmpFile, fppe_Cstr(fppe_toStringVar(argument[1])->value));

if ((fileHandle[f+1] = fopen_share(tmpFile, "a+b", smode)) == NULL)
	ferr[f+1]=1;
else
	ferr[f+1]=0;
}

/*

 FCLOSE - CLOSE A FILE 

*/

void ppl_S_FCLOSE(void)
{
int f;
f = fppe_getValue(argument[0]);
if (fileHandle[f+1]!=NULL)
	{
	fclose(fileHandle[f+1]);
	fileHandle[f+1]=NULL;
    }
ferr[f+1]=0;
if (f == -1)
	*readlineLastFile=0;
}

/*

 FGET - GET A LINE FROM A FILE 

*/

void ppl_S_FGET(void)
{
int f,b;
char c;
int geteol=0;

tmpStr[0]=0;
f = fppe_getValue(argument[0]);
if (fileHandle[f+1] == NULL)
	return;
fgets(tmpStr, 2048, fileHandle[f+1]);
if (tmpStr[strlen(tmpStr)-1] != '\n')
    geteol=1;

b = strlen(tmpStr);
if (tmpStr[b-1] == '\n' && b > 0)
   	tmpStr[b-1] = 0;
if (tmpStr[b-2] == '\r' && b > 1)
   	tmpStr[b-2] = 0;

fppe_assignStrVarToAny(argument[1], tmpStr);

if (geteol)
    {
    while (tmpStr[strlen(tmpStr)-1] != '\n' && !feof(fileHandle[f+1]))
		fgets(tmpStr, 2048, fileHandle[f+1]);
	}

if (feof(fileHandle[f+1]))
	ferr[f+1] = 1;
}

/*

 FPUT - PUT A LINE TO A FILE 

*/

void ppl_S_FPUT(void)
{
int a;
int f;
char *str;

f = fppe_getValue(argument[0]);
if (fileHandle[f+1] == NULL)
	return;

for (a=1;a<narg;a++)
	{
	str = fppe_Cstr(fppe_toStringVar(argument[a])->value);
    fwrite(str, strlen(str), 1, fileHandle[f+1]);
    }
}

/*

 FPUTLN - PUT A LINE TO A FILE AND APPEND A CR 

*/

void ppl_S_FPUTLN(void)
{
int f;
f = fppe_getValue(argument[0]);

ppl_S_FPUT();
fwrite("\r\n", 2, 1, fileHandle[f+1]);
}

/*

  -  

*/

void ppl_S_RESETDISP(void)
{
abortScroll=0;
}

/*

 STARTDISP - SET LINE COUNTING MODE 

*/

void ppl_S_STARTDISP(void)
{
int a = fppe_getValue(argument[0]);

switch (a)
	{
    case 0:
        CFcount = 0;
        break;
    case 1:
    	linesCounting = 0;
    	break;
    case 2:
    	linesCounting = 1;
    }
}

/*

  -  

*/

void ppl_S_FPUTPAD(void)
{
int a,b;
int f = fppe_getValue(argument[0]);
char *str = fppe_Cstr(fppe_toStringVar(argument[1])->value);
int len = fppe_getValue(argument[2]);
if (fileHandle[f+1]!=NULL)
	{
    a = len - strlen(str);
    if (a > 0)
    	for (b=0;b<a;b++)
        	fputc(' ', fileHandle[f+1]);
    else if (a < 0)
    	str[len] = 0;
    fwrite(str, strlen(str), 1, fileHandle[f+1]);
    }
}

/*

  -  

*/

void ppl_S_HANGUP(void)
{
hangup();
}

/*

  -  

*/

void ppl_S_GETUSER(void)
{
fppe_reloadUserVars();
}

/*

  -  

*/

void ppl_S_PUTUSER(void)
{
fppe_rewriteUserVars();
putUser(&ppe_user);
fppe_reloadUserVars();
}

/*

  -  

*/

void ppl_S_DEFCOLOR(void)
{
notImplemented("defcolor");
}

/*

 DELETE - DELETE A FILE 

*/

void ppl_S_DELETE(void)
{
FILE *t;

strcpy(tmpFile, fppe_Cstr(fppe_toStringVar(argument[0])->value));
if ((t = fopen_share(tmpFile, "wb", SH_DENYRW)) != NULL)
	{
    fclose(t);
	unlink(tmpFile);
	}
else
	{
	sprintf(tmpStr,"Cannot delete file (%s : %s)", tmpFile, (errno == 15) ? "Not found" : "Access denied");
	fppe_runtimeError(tmpStr);
	}

}

/*

  -  

*/

void ppl_S_DELUSER(void)
{
ppe_user.DeletedFlag = 'Y';
}

/*

  -  

*/

void ppl_S_ADJTIME(void)
{
userTimeLeft += fppe_getValue(argument[0]);
}

/*

  -  

*/

void ppl_S_LOG(void)
{
char *ptr = fppe_Cstr(fppe_toStringVar(argument[0])->value);
int Rjust = fppe_getValue(argument[1]);

if (Rjust)
	fprintf(logFile, "%-.79s\n", ptr);
else
	fprintf(logFile, "      %-.79s\n", ptr);
fflush(logFile);
}

/*

  -  

*/

void ppl_S_INPUTSTR(void)
{
ppl_input(argument[0], argument[1], fppe_getValue(argument[2]), fppe_getValue(argument[3]), argument[4], fppe_getValue(argument[5]));
}

/*

  -  

*/

void ppl_S_INPUTYN(void)
{
ppl_input(argument[0], argument[1], fppe_getValue(argument[2]), 1, &emptyVar, INPUT_FIELDLEN | INPUT_GUIDE | INPUT_YESNO);
}

/*

  -  

*/

void ppl_S_INPUTMONEY(void)
{
ppl_input(argument[0], argument[1], fppe_getValue(argument[2]), 13, mask_money(), INPUT_FIELDLEN | INPUT_GUIDE | INPUT_UPCASE);
}

/*

  -  

*/

void ppl_S_INPUTINT(void)
{
ppl_input(argument[0], argument[1], fppe_getValue(argument[2]), 11, mask_num(), INPUT_FIELDLEN | INPUT_GUIDE);
}

/*

  -  

*/

void ppl_S_INPUTCC(void)
{
ppl_input(argument[0], argument[1], fppe_getValue(argument[2]), 16, mask_num(), INPUT_FIELDLEN | INPUT_GUIDE);
}

/*

  -  

*/

void ppl_S_INPUTDATE(void)
{
ppl_input(argument[0], argument[1], fppe_getValue(argument[2]), 8, mask_date(), INPUT_FIELDLEN | INPUT_GUIDE);
}

/*

  -  

*/

void ppl_S_INPUTTIME(void)
{
ppl_input(argument[0], argument[1], fppe_getValue(argument[2]), 8, mask_time(), INPUT_FIELDLEN | INPUT_GUIDE);
}

/*

  -  

*/

void ppl_S_PROMPTSTR(void)
{
notImplemented("prompstr");
}

/*

 GOSUB - EXECUTE A SUBROUTINE 

*/

void ppl_S_GOSUB(void)
{
// mohahaha :)
}

/*

 RETURN - RETURN FROM A SUBROUTINE 

*/

void ppl_S_RETURN(void)
{
// mohahaha :)
}

/*

 DTRON - SET DATA TERMINAL READY 

*/

void ppl_S_DTRON(void)
{
if (initCode > 0)
	rs_modctrl(RS_WRTMCR,RS_MCRDTR,RS_LINON);
}

/*

 DTROFF - CLEAR DATA TERMINAL READY (HANGUP MODEM) 

*/

void ppl_S_DTROFF(void)
{
if (initCode > 0)
	rs_modctrl(RS_WRTMCR,RS_MCRDTR,RS_LINOFF);
}

/*

  -  

*/

void ppl_S_CDCHKON(void)
{
CDchecking=1;
}

/*

  -  

*/

void ppl_S_CDCHKOFF(void)
{
CDchecking=0;
}

/*

 DELAY - PAUSE THE PROGRAM FOR n TICKS 

*/

void ppl_S_DELAY(void)
{
delay(fppe_getValue(argument[0]));
updateStatusBar();
}

/*

  -  

*/

void ppl_S_SENDMODEM(void)
{
notImplemented("sendmodem");
}

/*

 INC - INCREMENT VAR 

*/

void ppl_S_INC(void)
{
fppe_setValue(argument[0], fppe_getValue(argument[0])+1);
}

/*

 DEC - DECREMENT VAR 

*/

void ppl_S_DEC(void)
{
fppe_setValue(argument[0], fppe_getValue(argument[0])-1);
}

/*

 NEWLINE - PRINT A NEW LINE 

*/

void ppl_S_NEWLINE(void)
{
output("\n",MASK_SYSOP|MASK_USER);
}

/*

 NEWLINES - PRINT N NEW LINES 

*/

void ppl_S_NEWLINES(void)
{
int a,b;

b = fppe_getValue(argument[0]);
for (a=0;a<b;a++)
	output("\n",MASK_SYSOP|MASK_USER);
}

/*

  -  

*/

void ppl_S_TOKENIZE(void)
{
tokenize(fppe_Cstr(fppe_toStringVar(argument[0])->value), tokenStr);
}

/*

  -  

*/

void ppl_S_GETTOKEN(void)
{
tmpStr[0]=0;
getToken(tmpStr, tokenStr);
fppe_assignStrVarToAny(argument[0], tmpStr);
}

/*

  -  

*/

void ppl_S_SHELL(void)
{
doShell(0);
}

/*

  -  

*/

void ppl_S_DISPTEXT(void)
{
notImplemented("disptext");
}

/*

  -  

*/

void ppl_S_STOP(void)
{
notImplemented("stop");
}

/*

  -  

*/

void ppl_S_INPUTTEXT(void)
{
ppl_input(argument[0], argument[1], fppe_getValue(argument[2]), fppe_getValue(argument[3]), mask_ascii(), INPUT_FIELDLEN | INPUT_GUIDE);
}

/*

 BEEP - PLAYS A BEEP ON THE SPEAKER 

*/

/*

  -  

*/

void ppl_S_BEEP(void)
{
sound(5000);
delay(4);
nosound();
}

/*

  -  

*/

void ppl_S_PUSH(void)
{
notImplemented("push");
}

/*

  -  

*/

void ppl_S_POP(void)
{
notImplemented("pop");
}

/*

 KBDSTUFF - STUFF A STRING IN THE KEYBOARD 

*/

void ppl_S_KBDSTUFF(void)
{
strncat(kbdString, fppe_Cstr(fppe_toStringVar(argument[0])->value), 256-strlen(kbdString));
}

/*

 CALL - RUN A PPE 

*/

void ppl_S_CALL(void)
{
char *p, *q;
int pos;

p = fppe_Cstr(fppe_toStringVar(argument[0])->value); // Command line

q = strchr(p, ' '); // Are there arguments ?
if (q != NULL)
	{
    pos = q - p;
    p[pos] = 0; // separate ppe & args
    strcpy(tmpStr, q+1);
    tokenize(tmpStr, tokenStr); // tokenize args
    }
fppe_runPPE(fppe_Cstr(fppe_toStringVar(argument[0])->value)); // run ppe
}

/*

  -  

*/

void ppl_S_JOIN(void)
{
join(fppe_getValue(argument[0]));
}

/*

  -  

*/

void ppl_S_QUEST(void)
{
notImplemented("quest");
}

/*

  -  

*/

void ppl_S_BLT(void)
{
notImplemented("blt");
}

/*

  -  

*/

void ppl_S_DIR(void)
{
notImplemented("dir");
}

/*

  -  

*/

void ppl_S_KBDFILE(void)
{
notImplemented("kbdfile");
}

/*

  -  

*/

void ppl_S_BYE(void)
{
bye();
}

/*

  -  

*/

void ppl_S_GOODBYE(void)
{
goodbye();
}

/*

  -  

*/

void ppl_S_BROADCAST(void)
{
notImplemented("broadcast");
}

/*

  -  

*/

void ppl_S_WAITFOR(void)
{
notImplemented("waitfor");
}

/*

  -  

*/

void ppl_S_KBDCHKON(void)
{
notImplemented("kbdchkon");
}

/*

  -  

*/

void ppl_S_KBDCHKOFF(void)
{
notImplemented("kbdchkoff");
}

/*

  -  

*/

void ppl_S_OPTEXT(void)
{
notImplemented("optext");
}

/*

  -  

*/

void ppl_S_DISPSTR(void)
{
execStrings = 1;
output(fppe_Cstr(fppe_toStringVar(argument[0])->value), MASK_SYSOP|MASK_USER);
execStrings = 0;
}

/*

  -  

*/

void ppl_S_RDUNET(void)
{
RdUNetNode = fppe_getValue(argument[0]);
}

/*

  -  

*/

void ppl_S_WRUNET(void)
{
nodeWriteData((int)fppe_getValue(argument[0]), // node
			  fppe_Cstr(fppe_toStringVar(argument[1])->value), // nodestat
			  fppe_Cstr(fppe_toStringVar(argument[2])->value), // username
			  fppe_Cstr(fppe_toStringVar(argument[3])->value), // nodecity
			  fppe_Cstr(fppe_toStringVar(argument[4])->value), // operation
			  fppe_Cstr(fppe_toStringVar(argument[5])->value)); // message
}

/*

  -  

*/

void ppl_S_DOINTR(void)
{
int i;
i = fppe_getValue(argument[0]);
ppeREGS.r_ax = fppe_getValue(argument[1]);
ppeREGS.r_bx = fppe_getValue(argument[2]);
ppeREGS.r_cx = fppe_getValue(argument[3]);
ppeREGS.r_dx = fppe_getValue(argument[4]);
ppeREGS.r_si = fppe_getValue(argument[5]);
ppeREGS.r_di = fppe_getValue(argument[6]);
ppeREGS.r_flags = fppe_getValue(argument[7]);
ppeREGS.r_ds = fppe_getValue(argument[8]);
ppeREGS.r_es = fppe_getValue(argument[9]);

intr(i, &ppeREGS);
}

/*

 VARSEG - SET VAR2 TO SEGMENT OF VAR1 

*/

void ppl_S_VARSEG(void) // a modifier (strings = pointeur, autre = dereferencement)
{
fppe_setValue(argument[1], FP_SEG(argument[0]->value));
}

/*

 VAROFF - SET VAR2 TO OFFSET OF VAR1 

*/

void ppl_S_VAROFF(void)
{
fppe_setValue(argument[1], FP_OFF(argument[0]->value));
}

/*

  -  

*/

void ppl_S_POKE(void)
{
long value;
unsigned int s, o;
unsigned char v;

value = fppe_getValue(argument[0]);
s = (value & 0xFFFF0000L) >> 16;
o = (value & 0xFFFF);
v = (unsigned char)fppe_getValue(argument[1]);
pokeb(s, o, v);
}

/*

  -  

*/

void ppl_S_POKEW(void)
{
long value;
unsigned int s, o;

value = fppe_getValue(argument[0]);
s = (value & 0xFFFF0000L) >> 16;
o = (value & 0xFFFF);
poke(s, o, (int)fppe_getValue(argument[1]));
}

/*

  -  

*/

void ppl_S_VARADDR(void)
{
fppe_setValue(argument[1], FP_SEG(argument[0]->value)*0x10000+FP_OFF(argument[0]->value));
}

/*

 ANSIPOS - SET CURSOR POSITION 

*/

void ppl_S_ANSIPOS(void)
{
int l, c;

c = fppe_getValue(argument[0]);
l = fppe_getValue(argument[1]);
if (c<0) c=1;
if (c>80) c=80;
if (l<0) l=1;
if (l>25) l=25;
ansiPos(c, l);
}

/*

 BACKUP - MOVE THE CURSOR n COLUMNS LEFT 

*/

void ppl_S_BACKUP(void)
{
backup(fppe_getValue(argument[0]));
}

/*

 FORWARD - MOVE THE CURSOR n COLUMNS RIGHT 

*/

void ppl_S_FORWARD(void)
{
forward(fppe_getValue(argument[0]));
}

/*

  -  

*/

void ppl_S_FRESHLINE(void)
{
if (VIOwherex() > 0) print("\n");
}

/*

  -  

*/

void ppl_S_WRUSYS(void)
{
userSys_make(NULL);
}

/*

  -  

*/

void ppl_S_RDUSYS(void)
{
userSys_read();
}

/*

  -  

*/

void ppl_S_NEWPWD(void)
{
notImplemented("newpwd");
}

/*

  -  

*/

void ppl_S_OPENCAP(void)
{
notImplemented("opencap");
}

/*

  -  

*/

void ppl_S_CLOSECAP(void)
{
notImplemented("closecap");
}

/*

  -  

*/

void ppl_S_MESSAGE(void)
{
// MESSAGE conf:integer, to:string, from:string, subject:string, sec:string, msgdate:date, retreceipt:boolean, echo:boolean, file:string
char filename[10];
FILE *msgtxt;
unsigned int l;
char *buffer;
int reqrr=0;
int echo=0;
int pvt=0;
time_t t;
struct time t2;
struct date dt;
struct time tm;
char s;
char *to;
int nr;
//int conf;

//conf =
if (toupper(*fppe_Cstr(fppe_toStringVar(argument[4])->value)) == 'R') pvt = 1;
if (fppe_getValue(argument[6]) != 0) reqrr=1;
if (fppe_getValue(argument[7]) != 0) echo=1;

if ((msgtxt = fopen_share(fppe_Cstr(fppe_toStringVar(argument[8])->value), "rt", SH_DENYWR)) == NULL)
    return;

fseek(msgtxt, 0, SEEK_END);
l = ftell(msgtxt);
fseek(msgtxt, 0, SEEK_SET);
if (l > 32767U) l = 32767;
buffer = (char *)calloc(l, 1);
fread(buffer, l, 1, msgtxt);
fclose(msgtxt);

t = time(NULL);
UnixToDos(t, &dt, &tm);
gettime(&t2);

strcpy(filename, "TXXXXXX");
mktemp(filename);

msgtxt = fopen_share(filename, "w+b", SH_DENYRW);
fprintf(msgtxt, "            Date: %02d-%02d-%02d\n", dt.da_mon, dt.da_day, dt.da_year <= 1999 ? dt.da_year - 1900 : dt.da_year - 2000);
fprintf(msgtxt, "            Time: %02d:%02d\n", t2.ti_hour, t2.ti_min);
fprintf(msgtxt, "              To: %-25s\n", fppe_Cstr(fppe_toStringVar(argument[1])->value));
fprintf(msgtxt, "            From: %-25s\n", fppe_Cstr(fppe_toStringVar(argument[2])->value));
fprintf(msgtxt, "         Subject: %-25s\n", fppe_Cstr(fppe_toStringVar(argument[3])->value));
fprintf(msgtxt, "            Echo: %c\n", echo == 1 ? 'E' : ' ');
if (!pvt)
    s = ' ';
else
	{
    if (!strnicmp(fppe_Cstr(fppe_toStringVar(argument[1])->value), "SYSOP", 5))
    	s = '~';
    else
	    s = '*';
    }
fprintf(msgtxt, "          Status: %c\n", s);
if (reqrr)
	{
	fprintf(msgtxt, "Extended headers: 1\n");
	fprintf(msgtxt, "REQRR  : Caller has requested a Return Receipt                      N\n");
    }
fprintf(msgtxt, "Message Body:\n");
fwrite(buffer, l, 1, msgtxt);
fclose(msgtxt);
free(buffer);
insertMessage((int)fppe_getValue(argument[0]), filename);
unlink(filename);

to = fppe_Cstr(fppe_toStringVar(argument[1])->value);

if ((nr = userRecNr(to)) != 0)
	setConfFlags((int)fppe_getValue(argument[0]), confFlags(nr) | 0x10, nr);
}

/*

 SAVESCRN - SAVE THE SCREEN 

*/

void ppl_S_SAVESCRN(void)
{
savescrn();
}

/*

 RESTSCRN - RESTORE THE SCREEN 

*/

void ppl_S_RESTSCRN(void)
{
restscrn();
}

/*

 SOUND - PLAY A SOUND ON THE SPEAKER 

*/

void ppl_S_SOUND(void)
{
unsigned a;
a = fppe_getValue(argument[0]);
if (a != 0)
	sound(a);
else
	nosound();
}

/*

  -  

*/

void ppl_S_CHAT(void)
{
chat();
}

/*

 SPRINT - PRINT VARS ON THE SYSOP DISPLAY 

*/

void ppl_S_SPRINT(void)
{
char d;

for (d=0;d<narg;d++)
    output(fppe_Cstr(fppe_toStringVar(argument[d])->value), MASK_SYSOP);
}

/*

 SPRINTLN - PRINT VARS ON THE SYSOP DISPLAY AND APPEND A CR 

*/

void ppl_S_SPRINTLN(void)
{
ppl_S_SPRINT();
output("\n",MASK_SYSOP);
}

/*

 MPRINT - PRINT VARS ON THE USER DISPLAY 

*/

void ppl_S_MPRINT(void)
{
char d;

for (d=0;d<narg;d++)
    output(fppe_Cstr(fppe_toStringVar(argument[d])->value), MASK_USER);
}

/*

 MPRINTLN - PRINT VARS ON THE USER DISPLAY AND APPEND A CR 

*/

void ppl_S_MPRINTLN(void)
{
ppl_S_MPRINT();
output("\n",MASK_USER);
}

/*

  -  

*/

void ppl_S_RENAME(void)
{
char *n1 = fppe_Cstr(fppe_toStringVar(argument[0])->value);
char *n2 = fppe_Cstr(fppe_toStringVar(argument[1])->value);
rename(n1, n2);
}

/*

  -  

*/

void ppl_S_FREWIND(void)
{
int f = fppe_getValue(argument[0]);
if (fileHandle[f+1]!=NULL)
    rewind(fileHandle[f+1]);
}

/*

  -  

*/

void ppl_S_POKEDW(void)
{
long value;
unsigned int s, o;
signed long l = fppe_getValue(argument[1]);

value = fppe_getValue(argument[0]);
s = (value & 0xFFFF0000L) >> 16;
o = (value & 0xFFFF);
poke(s, o, (l & 0xFFFF0000) >> 16);
poke(s, o+2, l & 0xFFFF);
}

/*

  -  

*/

void ppl_S_DBGLEVEL(void)
{
notImplemented("dbglevel");
}

/*

  -  

*/

void ppl_S_SHOWON(void)
{
globalNoDisplay = 0;
}

/*

  -  

*/

void ppl_S_SHOWOFF(void)
{
globalNoDisplay = 1;
}

/*

  -  

*/

void ppl_S_PAGEON(void)
{
pageFlag=1;
updateStatusBar();
}

/*

  -  

*/

void ppl_S_PAGEOFF(void)
{
pageFlag=0;
updateStatusBar();
}

/*

  -  

*/

void ppl_S_FSEEK(void)
{
int f = fppe_getValue(argument[0]);
long offset = fppe_getValue(argument[1]);
int whence = fppe_getValue(argument[2]);
if (fileHandle[f+1]!=NULL)
    fseek(fileHandle[f+1], offset, whence);
}

/*

  -  

*/

void ppl_S_FFLUSH(void)
{
int f = fppe_getValue(argument[0]);
if (fileHandle[f+1]!=NULL)
	fflush(fileHandle[f+1]);
}

/*

  -  

*/

void ppl_S_FREAD(void) // a modifier (cas string/autres) --! -> 1 modif faite... reste 'autres'?
{
int f = fppe_getValue(argument[0]);
char *ptr;
int len = fppe_getValue(argument[2]);

if (fppe_isStr(argument[1]))
	{
    if (len>2048) len=2048;
	if (fileHandle[f+1]!=NULL)
		{
        *tmpStr=0;
		fread(&tmpStr, len, 1, fileHandle[f+1]);
        tmpStr[len]=0;
		ferr[f+1] = feof(fileHandle[f+1]);
        fppe_strcpy(argument[1], tmpStr);
	    }
    }
else
	{
	ptr = argument[1]->value;
    if (len>8) len=8;
	if (fileHandle[f+1]!=NULL)
		{
		fread(ptr, len, 1, fileHandle[f+1]);
		ferr[f+1] = feof(fileHandle[f+1]);
	    }
    }
}

/*

  -  

*/

void ppl_S_FWRITE(void)
{
int f = fppe_getValue(argument[0]);
char *ptr = argument[1]->value;
int len = fppe_getValue(argument[2]);
if (fppe_isStr(argument[1])) ptr++;
if (fileHandle[f+1]!=NULL)
	if (fwrite(ptr, len, 1, fileHandle[f+1]) != 1)
		ferr[f+1] = 1;
}

/*

  -  

*/

void ppl_S_FDEFIN(void)
{
int d = fppe_getValue(argument[0]);
if (d+1 >= 1 && d+2 <= 7)
	defaultIn = d;
}

/*

  -  

*/

void ppl_S_FDEFOUT(void)
{
int d = fppe_getValue(argument[0]);
if (d+1 >= 1 && d+2 <= 7)
	defaultOut = d;
}

/*

  -  

*/

void ppl_S_FDGET(void)
{
int f,b;
char c;
int geteol=0;

f = defaultIn;
if (fileHandle[f+1] == NULL)
	return;
tmpStr[0]=0;
fgets(tmpStr, 2048, fileHandle[f+1]);
if (tmpStr[strlen(tmpStr)-1] != '\n')
    geteol=1;

b = strlen(tmpStr);
if (tmpStr[b-1] == '\n' && b > 0)
   	tmpStr[b-1] = 0;
if (tmpStr[b-2] == '\r' && b > 1)
   	tmpStr[b-2] = 0;

fppe_assignStrVarToAny(argument[0], tmpStr);

if (geteol)
    {
    while (tmpStr[strlen(tmpStr)-1] != '\n' && !feof(fileHandle[f+1]))
		fgets(tmpStr, 2048, fileHandle[f+1]);
	}

if (feof(fileHandle[f+1]))
	ferr[f+1] = 1;
}

/*

  -  

*/

void ppl_S_FDPUT(void)
{
int a;
int f;
char *str;

f = defaultOut;
if (fileHandle[f+1] == NULL)
	return;

for (a=0;a<narg;a++)
	{
	str = fppe_Cstr(fppe_toStringVar(argument[a])->value);
    fwrite(str, strlen(str), 1, fileHandle[f+1]);
    }
}

/*

  -  

*/

void ppl_S_FDPUTLN(void)
{
int f;
f = defaultOut;

ppl_S_FDPUT();
fwrite("\r\n", 2, 1, fileHandle[f+1]);
}

/*

  -  

*/

void ppl_S_FDPUTPAD(void)
{
int a,b;
int f = defaultOut;
char *str = fppe_Cstr(fppe_toStringVar(argument[0])->value);
int len = fppe_getValue(argument[1]);
if (fileHandle[f+1]!=NULL)
	{
    a = len - strlen(str);
    if (a > 0)
    	for (b=0;b<a;b++)
        	fputc(' ', fileHandle[f+1]);
    else if (a < 0)
    	str[len] = 0;
    fwrite(str, strlen(str), 1, fileHandle[f+1]);
    }
}

/*

  -  

*/

void ppl_S_FDREAD(void) // a modifier --!
{
int f = defaultIn;
char *ptr ;
int len = fppe_getValue(argument[1]);

if (fppe_isStr(argument[0]))
	{
    if (len>2048) len=2048;
	if (fileHandle[f+1]!=NULL)
		{
        *tmpStr=0;
		fread(&tmpStr, len, 1, fileHandle[f+1]);
		ferr[f+1] = feof(fileHandle[f+1]);
        fppe_strcpy(argument[0], tmpStr);
	    }
    }
else
	{
	ptr = argument[0]->value;
    if (len>8) len=8;
	if (fileHandle[f+1]!=NULL)
		{
		fread(ptr, len, 1, fileHandle[f+1]);
		ferr[f+1] = feof(fileHandle[f+1]);
	    }
    }
}

/*

  -  

*/

void ppl_S_FDWRITE(void)
{
int f = defaultOut;
char *ptr = argument[0]->value;
int len = fppe_getValue(argument[1]);
if (fileHandle[f+1]!=NULL)
	if (fwrite(ptr, len, 1, fileHandle[f+1]) != 1)
		ferr[f+1] = 1;
}

/*

  -  

*/

void ppl_S_ADJBYTES(void)
{
bdreal value;
double n;

n = fppe_getValue(argument[0]);

Double2BdReal(ppe_user.BytesDownloadedToday, BdReal2Double(ppe_user.BytesDownloadedToday) + n);
Double2BdReal(ppe_user.BytesDownloaded, BdReal2Double(ppe_user.BytesDownloaded) + n);
}

/*

  -  

*/

void ppl_S_KBDSTRING(void)
{
notImplemented("kbdstring");
}

/*

  -  

*/

void ppl_S_ALIAS(void)
{
notImplemented("alias");
}

/*

  -  

*/

void ppl_S_REDIM(void)
{
switch (narg)
	{
    case 2:
		fppe_redimTable(argument[0], (int)fppe_getValue(argument[1]), 0, 0);
        break;
    case 3:
		fppe_redimTable(argument[0], (int)fppe_getValue(argument[1]), (int)fppe_getValue(argument[2]), 0);
        break;
    case 4:
		fppe_redimTable(argument[0], (int)fppe_getValue(argument[1]), (int)fppe_getValue(argument[2]), (int)fppe_getValue(argument[3]));
        break;
    }
}

/*

  -  

*/

void ppl_S_APPEND(void)
{
FILE *in;
FILE *out;
char c;
char *i, *o;

i = fppe_Cstr(fppe_toStringVar(argument[0])->value);
o = fppe_Cstr(fppe_toStringVar(argument[1])->value);
in = fopen_share(i, "rb", SH_DENYWR);
out = fopen_share(o, "a+b", SH_DENYRW);

if (in != NULL && out != NULL)
    while (1)
	    {
        c = fgetc(in);
        if (feof(in)) break;
        fputc(c, out);
        }
else
	{
    sprintf(tmpStr, "Cannot append file (%s->>%s)", i, o);
	fppe_runtimeError(tmpStr);
    }

if (in != NULL) fclose(in);
if (out != NULL) fclose(out);
}

/*

  -  

*/

void ppl_S_COPY(void)
{
FILE *in;
FILE *out;
char c;
char *i, *o;

i = fppe_Cstr(fppe_toStringVar(argument[0])->value);
o = fppe_Cstr(fppe_toStringVar(argument[1])->value);
in = fopen_share(i, "rb", SH_DENYWR);
out = fopen_share(o, "wb", SH_DENYRW);

if (in != NULL && out != NULL)
    while (1)
	    {
        c = fgetc(in);
        if (feof(in)) break;
        fputc(c, out);
        }
else
	{
    sprintf(tmpStr, "Cannot copy files (%s->%s)", i, o);
	fppe_runtimeError(tmpStr);
    }

if (in != NULL) fclose(in);
if (out != NULL) fclose(out);
}

/*

  -  

*/

void ppl_S_KBDFLUSH(void)
{
kbdFlush();
}

/*

 MDMFLUSH - CLEAR THE MODEM IN AND OUT BUFFERS 

*/

void ppl_S_MDMFLUSH(void)
{
if (initCode <= 0)
	return;
rs_clrout();
rs_clrin();
}

/*

  -  

*/

void ppl_S_KEYFLUSH(void)
{
notImplemented("keyflush");
}

/*

  -  

*/

void ppl_S_LASTIN(void)
{
notImplemented("lastin");
}

/*

  -  

*/

void ppl_S_FLAG(void)
{
sprintf(tmpStr, "FLAG.PPE %s", fppe_Cstr(fppe_toStringVar(argument[0])->value));
runSystemPPE(tmpStr);
}

/*

  -  

*/

void ppl_S_DOWNLOAD(void)
{
notImplemented("download");
}

/*

  -  

*/

void ppl_S_WRUSYSDOOR(void)
{
userSys_make(fppe_Cstr(fppe_toStringVar(argument[0])->value));
}

/*

  -  

*/

void ppl_S_GETALTUSER(void)
{
long a = fppe_getValue(argument[0]);
if (a <= 0)
	getUser(userLoggedNum, &ppe_user);
else
	getUser(a, &ppe_user);
fppe_reloadUserVars();
}

/*

  -  

*/

void ppl_S_ADJDBYTES(void)
{
bdreal value;
double n;

n = fppe_getValue(argument[0]);

Double2BdReal(ppe_user.BytesDownloadedToday, BdReal2Double(ppe_user.BytesDownloadedToday) + n);
}

/*

  -  

*/

void ppl_S_ADJTBYTES(void)
{
bdreal value;
double n;

n = fppe_getValue(argument[0]);

Double2BdReal(ppe_user.BytesDownloaded, BdReal2Double(ppe_user.BytesDownloaded) + n);
}

/*

  -  

*/

void ppl_S_ADJTFILES(void)
{
ppe_user.FilesDownloaded = ppe_user.FilesDownloaded + fppe_getValue(argument[0]);
}

/*

  -  

*/

void ppl_S_LANG(void)
{
//sprintf(tmpStr2, "LANG.PPE %d", fppe_getValue(argument[0]));
//runSystemPPE(tmpStr2);
}

/*

  -  

*/

void ppl_S_SORT(void)
{
notImplemented("sort");
}

/*

  -  

*/

void ppl_S_MOUSEREG(void)
{
notImplemented("mousereg");
}

/*

  -  

*/

void ppl_S_SCRFILE(void)
{
notImplemented("scrfile");
}

/*

  -  

*/

void ppl_S_SEARCHINIT(void)
{
boyerMoore_init(fppe_Cstr(fppe_toStringVar(argument[0])->value), fppe_getValue(argument[1]));
}

/*

  -  

*/

void ppl_S_SEARCHFIND(void)
{
fppe_setValue(argument[1], boyerMoore_search(fppe_Cstr(fppe_toStringVar(argument[0])->value)));
}

int prFound_sort_function( const void *a, const void *b)
{
   if (((prFoundType *)a)->p < ((prFoundType *)b)->p) return -1;
   if (((prFoundType *)a)->p > ((prFoundType *)b)->p) return 1;
   return 0;
}

/*

  -  

*/

void ppl_S_SEARCHSTOP(void)
{
boyerMoore_reset();
}

/*

  -  

*/

void ppl_S_PRFOUND(void)
{
prFoundType r[50];
char *s, *so;
char *lastp;
char *t;
int d;
int w;
int i=0;
int a,b;
int c;

for (d=0;d<narg;d++)
	{
	memset(r, 0, 50*sizeof(prFoundType));
    i = 0;
	so = fppe_Cstr(fppe_toStringVar(argument[d])->value);

    for (w=0;*bmW[w];w++)
        {
		s = so;
	    while (s && i < 50)
    		{
            t = bmCase ? strstr(s, bmW[w]) : stristr(s, bmW[w]);
            if (t)
            	{
	        	r[i].p = t;
    	        r[i].l = strlen(bmW[w]);
        	    s = r[i].p+r[i++].l;
            	}
            else
            	s = t;
	        }
        }

    qsort(&r[0], i, sizeof(prFoundType), prFound_sort_function);

    for (a=1;r[a].p;a++)
    	{
        if (r[a].p == r[a-1].p)
        	{
            for (b=a;b<49;b++)
            	r[b] = r[b+1];
            r[49].p = NULL;
			r[49].l = 0;
            }
        }

    lastp = so;
    for (a=0;r[a].p;a++)
    	{
        strncpy(tmpStr, lastp, r[a].p - lastp);
        tmpStr[r[a].p - lastp] = 0;
	    output(tmpStr, MASK_SYSOP|MASK_USER);
        strncpy(tmpStr, r[a].p, r[a].l);
        tmpStr[r[a].l] = 0;
        c = curColor;
        color(0x70);
	    output(tmpStr, MASK_SYSOP|MASK_USER);
        color(c);
        lastp = r[a].p + r[a].l;
        }
    strncpy(tmpStr, lastp, so + strlen(so) - lastp);
    tmpStr[so + strlen(so) - lastp] = 0;
	output(tmpStr, MASK_SYSOP|MASK_USER);
    }

}

/*

  -  

*/

void ppl_S_PRFOUNDLN(void)
{
ppl_S_PRFOUND();
output("\n",MASK_SYSOP|MASK_USER);
}

/*

  -  

*/

void ppl_S_TPAGET(void)
{
TPArec *tpa;
char *buf;

tpa = openTPA(fppe_Cstr(fppe_toStringVar(argument[0])->value));
if (tpa==NULL)
	return;

buf = (char *)malloc(2048);
memset(buf, 0, 2048);
getTPA(tpa, buf, tpa->staticSize, curConf, 0, currentUserNum);
fppe_assignStrVarToAny(argument[1], buf);
free(buf);
closeTPA(tpa);
}

/*

  -  

*/

void ppl_S_TPAPUT(void)
{
TPArec *tpa;
char *buf;

tpa = openTPA(fppe_Cstr(fppe_toStringVar(argument[0])->value));
if (tpa==NULL)
	return;

buf = (char *)malloc(2048);
memset(buf, 0, 2048);
strcpy(buf, fppe_Cstr(fppe_toStringVar(argument[1])->value));

putTPA(tpa, buf, tpa->staticSize, curConf, 0, currentUserNum);

free(buf);
closeTPA(tpa);
}

/*

  -  

*/

void ppl_S_TPACGET(void)
{
TPArec *tpa;
char *buf;

tpa = openTPA(fppe_Cstr(fppe_toStringVar(argument[0])->value));
if (tpa==NULL)
	return;

buf = (char *)malloc(2048);
memset(buf, 0, 2048);
getTPA(tpa, buf, tpa->dynamicSize, fppe_getValue(argument[2]), 1, currentUserNum);
fppe_assignStrVarToAny(argument[1], buf);
free(buf);
closeTPA(tpa);
}

/*

  -  

*/

void ppl_S_TPACPUT(void)
{
TPArec *tpa;
char *buf;

tpa = openTPA(fppe_Cstr(fppe_toStringVar(argument[0])->value));
if (tpa==NULL)
	return;

buf = (char *)malloc(2048);
memset(buf, 0, 2048);
strcpy(buf, fppe_Cstr(fppe_toStringVar(argument[1])->value));

putTPA(tpa, buf, tpa->dynamicSize, fppe_getValue(argument[2]), 1, currentUserNum);

free(buf);
closeTPA(tpa);
}

/*

  -  

*/

void ppl_S_TPAREAD(void)
{
TPArec *tpa;
char *buf;
int size;

tpa = openTPA(fppe_Cstr(fppe_toStringVar(argument[0])->value));
if (tpa==NULL)
	return;

if (fppe_isStr(argument[1]))
	{
	buf = fppe_Cstr(argument[1]->value);
    size = strlen(buf);
    }
else
	{
	buf = argument[1]->value;
    size = fppe_sizeofType(argument[1]->type);
    }
getTPA(tpa, buf, size, curConf, 0, currentUserNum);
closeTPA(tpa);
}

/*

  -  

*/

void ppl_S_TPAWRITE(void)
{
TPArec *tpa;
char *buf;
int size;

tpa = openTPA(fppe_Cstr(fppe_toStringVar(argument[0])->value));
if (tpa==NULL)
	return;

if (fppe_isStr(argument[1]))
	{
	buf = fppe_Cstr(argument[1]->value);
    size = strlen(buf);
    }
else
	{
	buf = argument[1]->value;
    size = fppe_sizeofType(argument[1]->type);
    }
putTPA(tpa, buf, size, curConf, 0, currentUserNum);
closeTPA(tpa);
}

/*

  -  

*/

void ppl_S_TPACREAD(void)
{
TPArec *tpa;
char *buf;
int size;

tpa = openTPA(fppe_Cstr(fppe_toStringVar(argument[0])->value));
if (tpa==NULL)
	return;

if (fppe_isStr(argument[1]))
	{
	buf = fppe_Cstr(argument[1]->value);
    size = strlen(buf);
    }
else
	{
	buf = argument[1]->value;
    size = fppe_sizeofType(argument[1]->type);
    }
getTPA(tpa, buf, size, fppe_getValue(argument[2]), 1, currentUserNum);
closeTPA(tpa);
}

/*

  -  

*/

void ppl_S_TPACWRITE(void)
{
TPArec *tpa;
char *buf;
int size;

tpa = openTPA(fppe_Cstr(fppe_toStringVar(argument[0])->value));
if (tpa==NULL)
	return;

if (fppe_isStr(argument[1]))
	{
	buf = fppe_Cstr(argument[1]->value);
    size = strlen(buf);
    }
else
	{
	buf = argument[1]->value;
    size = fppe_sizeofType(argument[1]->type);
    }
putTPA(tpa, buf, size, fppe_getValue(argument[2]), 1, currentUserNum);
closeTPA(tpa);
}

/*

  -  

*/

void ppl_S_BITSET(void) // a modifier
{
char *dataValue = argument[0]->value;
int bytes = fppe_sizeofType(argument[0]->type);
int bitn = fppe_getValue(argument[1]);
int byten = (int)(bitn / 8);

if (byten + 1 > bytes || byten < 0)
	return;

dataValue[byten] |= 1 << (bitn - byten*8);
}

/*

  -  

*/

void ppl_S_BITCLEAR(void)
{
char *dataValue = argument[0]->value;
int bytes = fppe_sizeofType(argument[0]->type);
int bitn = fppe_getValue(argument[1]);
int byten = (int)(bitn / 8);

if (byten + 1 > bytes || byten < 0)
	return;

dataValue[byten] &= ~(1 << (bitn - byten*8));
}

/*

 BRAG - PRINT CREDITS 

*/

void ppl_S_BRAG(void)
{
output("         Project Frontier 1.0         \n", MASK_BOTH);
output(" --- \n", MASK_BOTH);
output("                                      \n", MASK_BOTH);
output("      Programming:  Lone Runner       \n", MASK_BOTH);
output("                    Number Six        \n", MASK_BOTH);
output("                    Gandalf           \n", MASK_BOTH);
output("           Design:  Mr. Splif         \n", MASK_BOTH);
}

/*

  -  

*/

void ppl_S_FREALTUSER(void)
{
getUser(userLoggedNum, &ppe_user);
fppe_reloadUserVars();
}

/*

  -  

*/

void ppl_S_SETLMR(void)
{
setLmr(fppe_getValue(argument[0]), fppe_getValue(argument[1]), currentUserNum);
}

/*

  -  

*/

void ppl_S_SETENV(void)
{
char *ptr;

ptr = strdup(fppe_Cstr(fppe_toStringVar(argument[0])->value));
putenv(ptr);
}

/*

  -  

*/

void ppl_S_FCLOSEALL(void)
{
int f;
for (f=-1;f<7;f++)
	if (fileHandle[f+1]!=NULL)
		{
		fclose(fileHandle[f+1]);
		fileHandle[f+1]=NULL;
	    }
	ferr[f+1]=0;
}

/*

 DECLARE - DECLARE A PROCEDURE (NOT A TOKEN) 

*/

void ppl_S_DECLARE(void)
{
}

/*

 FUNCTION - EXECUTE A USER DEFINED FUNCTION 

*/

void ppl_S_FUNCTION(void)
{
}

/*

 PROCEDURE - EXECUTE A USER DEFINED PROCEDURE 

*/

void ppl_S_PROCEDURE(void)
{
}

/*

 ENDPROC - RETURN FROM A USER DEFINED PROCEDURE 

*/

void ppl_S_ENDPROC(void)
{
}

/*

 BEGIN - MARK BEGIN OF CODE (NOT A TOKEN) 

*/

void ppl_S_BEGIN(void)
{
}

/*

 ENDFUNC - RETURN FROM A USER DEFINED FUNCTION 

*/

void ppl_S_ENDFUNC(void)
{
}

/*

  -  

*/

void ppl_S_STATIC(void)
{
//notImplemented("static");
}

/*

  -  

*/

void ppl_S_STACKABORT(void)
{
notImplemented("stackabort");
}

/*

  -  

*/

void ppl_S_DCREATE(void)
{
fppe_runtimeError("dBase functions not supported");
//notImplemented("dcreate");
}

void ppl_S_DOPEN(void)
{
fppe_runtimeError("dBase functions not supported");
//notImplemented("dopen");
}

void ppl_S_DCLOSE(void)
{
//notImplemented("dclose");
}

void ppl_S_DSETALIAS(void)
{
//notImplemented("dsetalias");
}

void ppl_S_DPACK(void)
{
//notImplemented("dpack");
}

void ppl_S_DCLOSEALL(void)
{
//notImplemented("dcloseall");
}

void ppl_S_DLOCK(void)
{
//notImplemented("dlock");
}

void ppl_S_DLOCKR(void)
{
//notImplemented("dlockr");
}

void ppl_S_DLOCKG(void)
{
//notImplemented("dlockg");
}

void ppl_S_DUNLOCK(void)
{
//notImplemented("dunlock");
}

void ppl_S_DNCREATE(void)
{
//notImplemented("dncreate");
}

void ppl_S_DNOPEN(void)
{
fppe_runtimeError("dBase functions not supported");
//notImplemented("dnopen");
}

void ppl_S_DNCLOSE(void)
{
//notImplemented("dnclose");
}

void ppl_S_DNCLOSEALL(void)
{
//notImplemented("dncloseall");
}

void ppl_S_DNEW(void)
{
//notImplemented("dnew");
}

void ppl_S_DADD(void)
{
//notImplemented("dadd");
}

void ppl_S_DAPPEND(void)
{
//notImplemented("dappend");
}

void ppl_S_DTOP(void)
{
//notImplemented("dtop");
}

void ppl_S_DGO(void)
{
//notImplemented("dgo");
}

void ppl_S_DBOTTOM(void)
{
//notImplemented("dbottom");
}

void ppl_S_DSKIP(void)
{
//notImplemented("dskip");
}

void ppl_S_DBLANK(void)
{
//notImplemented("dblank");
}

void ppl_S_DDELETE(void)
{
//notImplemented("ddelete");
}

void ppl_S_DRECALL(void)
{
//notImplemented("drecall");
}

void ppl_S_DTAG(void)
{
//notImplemented("dtag");
}

void ppl_S_DSEEK(void)
{
//notImplemented("dseek");
}

void ppl_S_DFBLANK(void)
{
//notImplemented("dfblank");
}

void ppl_S_DGET(void)
{
//notImplemented("dget");
}

void ppl_S_DPUT(void)
{
//notImplemented("dput");
}

void ppl_S_DFCOPY(void)
{
//notImplemented("dfcopy");
}

/*

 EVAL - RUN A FUNCTION WITH ASSIGNING RETURN VALUE 

*/

void ppl_S_EVAL(void)
{
//mohahaha :)
}

/*

  -  

*/

void ppl_S_ACCOUNT(void)
{
notImplemented("account");
}

/*

  -  

*/

void ppl_S_RECORDUSAGE(void)
{
notImplemented("recordusage");
}

/*

  -  

*/

void ppl_S_MSGTOFILE(void)
{
//  MSGTOFILE conf,msg_no,filename
retrieveMessage((int)fppe_getValue(argument[0]), (long) fppe_getValue(argument[1]), fppe_Cstr(fppe_toStringVar(argument[2])->value));
}

/*

  -  

*/

void ppl_S_QWKLIMITS(void)
{
notImplemented("qwklimits");
}

/*

 COMMAND 

*/

void ppl_S_COMMAND(void)
{
execCommand(fppe_Cstr(fppe_toStringVar(argument[1])->value));
}

/*

  -  

*/

void ppl_S_USELMRS(void)
{
// ignore
}

/*

  -  

*/

void ppl_S_CONFINFO(void)
{
notImplemented("confinfo");
}

/*

  -  

*/

void ppl_S_ADJTUBYTES(void)
{
bdreal value;
double n;

n = fppe_getValue(argument[0]);

Double2BdReal(ppe_user.BytesUploaded, BdReal2Double(ppe_user.BytesUploaded) + n);
}

/*

  -  

*/

void ppl_S_GRAFMODE(void)
{
grafMode = *fppe_Cstr(fppe_toStringVar(argument[0])->value);
}

/*

  -  

*/

void ppl_S_ADDUSER(void)
{
addUser(fppe_Cstr(fppe_toStringVar(argument[0])->value));

if (fppe_getValue(argument[1]) != 0)
	{
	getUser(userRecNr(fppe_Cstr(fppe_toStringVar(argument[0])->value)), &ppe_user);
	fppe_reloadUserVars();
    }
else
	ppl_S_FREALTUSER();
}

/*

  -  

*/

void ppl_S_KILLMSG(void)
{
setKillMsgStatus(fppe_getValue(argument[0]), fppe_getValue(argument[1]), 1);
}

/*

  -  

*/

void ppl_S_CHDIR(void)
{
chdir(fppe_Cstr(fppe_toStringVar(argument[0])->value));
}

/*

  -  

*/

void ppl_S_MKDIR(void)
{
mkdir(fppe_Cstr(fppe_toStringVar(argument[0])->value));
}

/*

  -  

*/

void ppl_S_RMDIR(void)
{
rmdir(fppe_Cstr(fppe_toStringVar(argument[0])->value));
}

/*

  -  

*/

void ppl_S_FDOWRAKA(void)
{
//notImplemented("fdowraka");
}

void ppl_S_FDOADDAKA(void)
{
//notImplemented("fdoaddaka");
}

void ppl_S_FDOWRORG(void)
{
//notImplemented("fdoworg");
}

void ppl_S_FDOADDORG(void)
{
//notImplemented("fdoaddorg");
}

void ppl_S_FDOQMOD(void)
{
//notImplemented("fdoqmod");
}

void ppl_S_FDOQADD(void)
{
//notImplemented("fdoqadd");
}

void ppl_S_FDOQDEL(void)
{
//notImplemented("fdoqdel");
}

/*

  -  

*/

void ppl_S_SOUNDDELAY(void)
{
sound((unsigned)fppe_getValue(argument[0]));
delay((unsigned)fppe_getValue(argument[1]));
nosound();
}

/*

  -  

*/

void ppl_S_ABORT(void)
{
if (fppe_getValue(argument[0]) != 0)
	abortScroll=1;
else
	abortScroll=0;
}

/*

  -  

*/

void ppl_S_LEAVE(void)
{
if (!fppe_getValue(argument[0]))
	skipCloseUp=1;
else
	skipCloseUp=0;
doCloseUp=1;
endPPE=1;
}

/*

  -  

*/

void ppl_S_DPRINT(void)
{
char d;

if (!debugScreen)
	return;

for (d=0;d<narg;d++)
    debug_puts(fppe_Cstr(fppe_toStringVar(argument[d])->value));
}

/*

  -  

*/

void ppl_S_DPRINTLN(void)
{
if (!debugScreen)
	return;
ppl_S_DPRINT();
debug_puts("\n");
}

/*

  -  

*/

void ppl_S_DCLS(void)
{
if (!debugScreen)
	return;
debug_cls();
}

/*

  -  

*/

void ppl_S_DANSIPOS(void)
{
if (!debugScreen)
	return;
debug_x = fppe_getValue(argument[0]);
debug_y = fppe_getValue(argument[1]);
debug_gotoxy(debug_x, debug_y);
}

/*

  -  

*/

void ppl_S_DSAVESCRN(void)
{
if (!debugScreen)
	return;
}

/*

  -  

*/

void ppl_S_DRESTSCRN(void)
{
if (!debugScreen)
	return;
}

/*

  -  

*/

void ppl_S_ADVMESSAGE(void)
{
// ADVMESSAGE conf:integer, file:string
insertMessage((int)fppe_getValue(argument[0]), fppe_Cstr(fppe_toStringVar(argument[1])->value));
}

/*

  -  

*/

void ppl_S_SETREAD(void)
{
int flag;
flag = fppe_getValue(argument[2]);

if (flag)
	setRead((int)fppe_getValue(argument[0]), (long)fppe_getValue(argument[1]), (long)fppe_getValue(argument[3]));
else
	setUnread((int)fppe_getValue(argument[0]), (long)fppe_getValue(argument[1]));
}

/*

  -  

*/

void ppl_S_KILLTIME(void)
{
KillTime();
}

/*

  -  

*/

void ppl_S_GETSYSTEMUSER(void)
{
struct  time t;
struct date d;

long a = fppe_getValue(argument[0]);
if (a <= 0)
    a = 1;
getUser(a, &user);
fppe_reloadUserVars();
gettime(&t);
userTimeLog = t.ti_hour*60+t.ti_min;
getdate(&d);
sprintf(tmpStr, "%02d%02d%02d", d.da_year <= 1999 ? d.da_year - 1900 : d.da_year - 2000, d.da_mon, d.da_day);
userDateLog = sysCharDateToPPLDate(tmpStr);
userTimeLeft = 5;
userMinsAllowed = 60;
userMinsOn=0;
}

/*

  -  

*/

void ppl_S_SCREENCLEARED(void)
{
if (fppe_getValue(argument[0]) != 0)
	screenCleared=1;
else
	screenCleared=0;
}

/*

  -  

*/

void ppl_S_UNKILLMSG(void)
{
setKillMsgStatus(fppe_getValue(argument[0]), fppe_getValue(argument[1]), 0);
}

/*

  -  

*/

void ppl_S_ENDWITHVALUE(void)
{
fppe_assignVar(&ppeReturnValue, argument[0]);
endPPE=1;
}

/*

  -  

*/

void ppl_S_SETCARRIER(void)
{
carrierSpeed = fppe_getValue(argument[0]);
}

/*

  -  

*/

void ppl_S_SETLOCAL(void)
{
if (initCode > 0)
	AsyncClose();
}

/*

  -  

*/

void ppl_S_SETCOMHAND(void)
{
long v;

v = (long)fppe_getValue(argument[0]) & 0x3;
rs_modctrl(RS_WRTMCR,RS_MCRDTR, v & 1 ? 1 : 0);
rs_modctrl(RS_WRTMCR,RS_MCRRTS, v & 2 ? 1 : 0);
}

/*

  -  

*/

void ppl_S_SETERRORCORRECT(void)
{
errorcorrect=fppe_getValue(argument[0]);
}

/*

  -  

*/

void ppl_S_PUTPROFILE(void)
{
char *s = fppe_Cstr(fppe_toStringVar(argument[0])->value);
char *e = fppe_Cstr(fppe_toStringVar(argument[1])->value);
char *f = fppe_Cstr(fppe_toStringVar(argument[2])->value);
char *v = fppe_Cstr(fppe_toStringVar(argument[3])->value);

writeProfileString( s, e, v, f );
}

/*

  -  

*/

void ppl_S_SUSPENDCOM(void)
{
suspendCom();
}

/*

  -  

*/

void ppl_S_RESTORECOM(void)
{
restoreCom();
}

/*

  -  

*/

void ppl_S_CTOKENIZE(void)
{
Ctokenize(fppe_Cstr(fppe_toStringVar(argument[0])->value), *fppe_Cstr(fppe_toStringVar(argument[1])->value), tokenStr);
}

/*

  -  

*/

void ppl_S_REGISTERCMD(void)
{
registerCommand(fppe_Cstr(fppe_toStringVar(argument[0])->value), fppe_Cstr(fppe_toStringVar(argument[1])->value), fppe_getValue(argument[2]));
}

/*

  -  

*/

void ppl_S_INVALIDCMDS(void)
{
invalidCommands();
}

/*

  -  

*/

void ppl_S_LOADCONF(void)
{
loadConf(fppe_getValue(argument[0]));
}

/*

  -  

*/

void ppl_S_MACROS(void)
{
macrosInterpretation=fppe_getValue(argument[0]);
}

/*

  -  

*/

void ppl_S_SANSIPOS(void)
{
int l, c;

c = fppe_getValue(argument[0]);
l = fppe_getValue(argument[1]);
if (c<0) c=1;
if (c>80) c=80;
if (l<0) l=1;
if (l>25) l=25;
VIOgotoxy(c-1,l-1);
}

/*

  -  

*/

void ppl_S_PAGETEXT(void)
{
strncpy(pageText, fppe_Cstr(fppe_toStringVar(argument[0])->value), 50);
pageText[50]=0;
updateStatusBar();
}

/*

  -  

*/

void ppl_S_WRPCBSYS(void)
{
pcbSys_make();
}

/*

  -  

*/

void ppl_S_RDPCBSYS(void)
{
pcbSys_read();
}

/*

  -  

*/

void ppl_S_SETCOM(void)
{
strnzcpy(comPort, fppe_Cstr(fppe_toStringVar(argument[0])->value), 14);
strupr(comPort);

comBase = fppe_getValue(argument[1]);
comIrq = fppe_getValue(argument[2]);
}

/*

  -  

*/

void ppl_S_SEARCHFILEFIND(void)
{
char *ptr;
FILE *f;
long size;

f = fopen_share(fppe_Cstr(fppe_toStringVar(argument[0])->value), "rt", SH_DENYNONE);
if (!f)
	{
	fppe_setValue(argument[1], 0);
	return;
    }

fseek(f, 0, SEEK_END);
size = ftell(f);
if (size > 32767) size = 32767;
fseek(f, 0, SEEK_SET);
ptr = malloc(size+1);
fread(ptr, size, 1, f);
fclose(f);

fppe_setValue(argument[1], boyerMoore_search(ptr));
free(ptr);
}

/*

  -  

*/

void ppl_S_RESETLOG(void)
{
fclose(logFile);
unlink(callersLogFile);
logFile = fopen_share(callersLogFile, "a+t", SH_DENYWR);
}

/*

  -  

*/

void ppl_S_GETCOM(void)
{
fppe_assignStrVarToAny(argument[0], comPort);
fppe_setValue(argument[1], comBase);
fppe_setValue(argument[2], comIrq);
}

int charok(char *valid, unsigned char c, long flags)
{
return (strchr(valid, c) ||
       (flags & INPUT_STACKED && (c == ' ' || c == ';')) ||
       (flags & INPUT_HIGHASCII && c > 127) ||
       (flags & INPUT_YESNO && (toupper(c) == yes || toupper(c) == no)));
}

/*

  -  

*/

void ppl_S_BIGSHELL(void)
{
doShell(1);
}

/*

  -  

*/

void ppl_S_SCLS(void)
{
localCls();
}
/*

  -  

*/


void ppl_S_WRFRTSYS(void)
{
FRTsys_make();
}

/*

  -  

*/

void ppl_S_RDFRTSYS(void)
{
FRTsys_read();
}

/*

  -  

*/

void ppl_S_ADJTUFILES(void)
{
ppe_user.FilesUploaded = ppe_user.FilesUploaded + fppe_getValue(argument[0]);
}

/*

  -  

*/

void ppl_S_SETTTIME(void)
{
userMinsAllowed = fppe_getValue(argument[0]);
userTimeLeft = userMinsAllowed - user.TimeOn;
}

/*

  -  

*/

void ppl_S_SETLANG(void)
{
strnzcpy(langExt, fppe_Cstr(fppe_toStringVar(argument[0])->value), 4);
langNum = fppe_getValue(argument[1]);
}

/*

  -  

*/

void ppl_S_void(void)
{
}

/*

  -  

*/

char *inputmagic(char *str, long flags)
{
int a;
if (flags & INPUT_ECHODOTS)
	{
	a = strlen(str);
	memset(tmpStr, '.', a);
	tmpStr[a]=0;
	return tmpStr;
    }
else
	return str;
}

/*

  -  

*/

void ppl_input(pplvar *prompt, pplvar *result, int col, int len, pplvar *valid, long flags)
{
char *pr = fppe_Cstr(fppe_toStringVar(prompt)->value);
char *val = fppe_Cstr(fppe_toStringVar(valid)->value);
char *r = fppe_Cstr(fppe_toStringVar(result)->value);
unsigned char key[12];
char res[85]="";
clock_t out;
int spos=0;
char k[2]="X";
int overwrite=0;
int slen=0;
int trail;
int first=1;
int a,b,c,d;

//        GUIDE = 4h
//(displays parenthesis above current line if FIELDLEN used and ANSI not enabled)

if (flags & INPUT_LFBEFORE)
	print("\n");

out = clock() + 182;

if (strcmp(pr, "_"))
	{
	color(col);
	print(pr);
	print("? ");
    }
if (flags & INPUT_FIELDLEN || flags & INPUT_GUIDE) // fieldlen
	{
	if (strcmp(pr, "_"))
    	print("(");
	color(col);
    memset(tmpStr, ' ', len);
    tmpStr[len]=0;
    print(tmpStr);
	if (strcmp(pr, "_"))
    	{
		color(col);
	    print(")");
	    backup(len+1);
        }
    else
    	backup(len);
    }

if (*r != 0)
	{
    strcpy(tmpStr, r);
    if (strlen(tmpStr) > len) tmpStr[len]=0;
	strcpy(res, tmpStr);
    slen = strlen(tmpStr);
    print(inputmagic(res, flags));
    backup(slen);
    }
else
	if (flags & INPUT_WORDWRAP && wrap[0] != 0)
		{
		color(col);
    	if (strlen(wrap) > len) wrap[len]=0;
		strcpy(res, wrap);
	    slen = strlen(wrap);
        spos = strlen(wrap);
	    print(inputmagic(res, flags));
        wrap[0]=0;
        first = 0;
	    }

color(col);
wrap[0]=0;

while (1)
	{
    checkHotkeys();
    if (flags & INPUT_AUTO)
    	if (clock() >= out) break;
    *key=0;
	getKey(key, MASK_BOTH);
    if (*key != 0)
    	{
		out = clock() + 182;

        if (key[1] == 0)
        	{
            if (flags & INPUT_UPCASE) *key = toupper(*key);
            switch (*key)
            	{
                case 13:
                	enter:
                	if (flags & INPUT_ERASELINE)
                    	{
						backup(80);
                        clreol();
                        }
                	if (flags & INPUT_NEWLINE)
                        print("\n");
                	if (flags & INPUT_LFAFTER)
                        print("\n");
                	goto strok;
                case 8:
                	first=0;
	                if (spos > 0)
    	            	{
                        spos--;
                        backup(1);
	                    trail = slen-spos;
						memmove(&res[spos], &res[spos+1], trail);
   	    	            print(inputmagic(&res[spos], flags));
            	        print(" ");
       	        	    backup(trail);
	                	slen--;
        		        }
                    break;
                default:
	                k[0]=*key;
		            if (charok(val, *key, flags))
        		        {
                        if (first && !(flags & INPUT_NOCLEAR))
                        	{
                            backup(spos);
                            for (a=0;a<slen;a++)
                            	print(" ");
                            backup(slen);
							res[0]=0;
                            spos=0;
                            slen=0;
                            }
	                	first=0;
    	            	if (res[spos] == 0) // ajout ?
							{
                            if (slen < len)
                            	{
	                            res[spos+1] = 0;
			    	            res[spos++] = *key;
				                print(flags & 1 ? "." : k);
           		                slen++;
                                }
                            else
                                if (flags & INPUT_WORDWRAP)
                                	{ // wordwrap
                                    c = slen;
                                    d = spos;
                                    if (strchr(res, ' ') == NULL)
                                    	{
                                        strcpy(wrap, k);
                                    	goto enter;
                                        }
                                    a = (char *)strrchr(res, ' ') - (char *)&res;
                                    strcpy(wrap, &res[a+1]);
                                    res[a]=0;
                                    for (b=a-1;b>=0;b--)
                                        if (res[b] == ' ')
											res[b] = 0;
                                        else
                                        	break;
                                    slen = b;
                                    backup(d-b-1);
                                    for (a=0;a<c-b-1;a++)
                                    	print(" ");
                                    strcat(wrap,k);
                                    goto enter;
                                    }
							}
                        else
                        	{ // milieu de string
                            if (!overwrite)
                            	{
	 	                        if (slen < len)
                            		{
	                                trail = slen-spos;
    	                            if (slen+1 > len) trail--;
									memmove(&res[spos+1], &res[spos], trail);
					                print(flags & 1 ? "." : k);
                	                print(inputmagic(&res[spos+1], flags));
                    	            backup(trail);
                        	        if (slen+1 <= len) slen++;
				    	            res[spos++] = *key;
                                    }
                                }
                            else
                            	{
    			                print(flags & 1 ? "." : k);
			    	            res[spos++] = *key;
                                }
                            }
        		        }
                }
            }
        else
        	{
            if (!strcmp(key, "LEFT"))
            	{
	            first=0;
                if (spos>0)
                	{
	                spos--;
    	            backup(1);
        	        }
                }
            if (!strcmp(key, "RIGHT"))
            	{
	            first=0;
                if (spos<len && res[spos] != 0)
                	{
	                spos++;
    	            forward(1);
        	        }
                }
            if (!strcmp(key, "HOME"))
            	{
	            first=0;
   	            backup(spos);
                spos=0;
                }
            if (!strcmp(key, "END"))
            	{
	            first=0;
   	            forward(slen-spos);
                spos=slen;
                }
            if (!strcmp(key, "DEL"))
            	{
	            first=0;
                if (res[spos] != 0)
                	{
                    trail = slen-spos;
					memmove(&res[spos], &res[spos+1], trail);
   	                print(inputmagic(&res[spos], flags));
                    print(" ");
       	            backup(trail);
	                slen--;
        	        }
                }
            }
        }
	}

strok:

if (flags & INPUT_YESNO) strupr(res);
fppe_assignStrVarToAny(result, res);
}

/*

  -  

*/

void doShell(int big)
{
int via;
int s;
int pi;
int i;
char *command;
char *t;
char *p[25];
char *prog;
char *screen;
int sx, sy;
int save;

save = getdisk();
tmpStr2[0] = '\\';
getcurdir(0,&tmpStr2[1]);

/*fnsplit(iniFile, tmpDrive, tmpDir, tmpFile, tmpExt);
fnmerge(tmpStr, tmpDrive, tmpDir, NULL, NULL);
if (tmpStr[strlen(tmpStr)-1] == '\\' && strlen(tmpStr) > 3) tmpStr[strlen(tmpStr)-1] = 0;
setdisk(*tmpStr-'A');
chdir(tmpStr);*/

via = fppe_getValue(argument[0]);

if (via)
	{
	sprintf(tmpStr, "/C %s %s", fppe_Cstr(fppe_toStringVar(argument[2])->value), fppe_Cstr(fppe_toStringVar(argument[3])->value));
    command = (char *)&tmpStr;
	}
else
	command = fppe_Cstr(fppe_toStringVar(argument[3])->value);

    s = strlen(command);
    pi = 0;

    for (i = 1; i < 25; i++)
	{
	p[i] = &command[0]+pi;
	t = strnchr(command+pi,' ',s);
	if (t == NULL) break;
#pragma warn -sig
	pi = (t-command)+1;
#pragma warn .sig
	if (pi>s) break;
	command[pi-1] = 0;
	}
    for (i = i+1; i < 25; i++)
	p[i] = NULL;

if (via)
    prog = getenv( "COMSPEC");
else
    prog = fppe_Cstr(fppe_toStringVar(argument[2])->value);

p[0] = prog;

screen = malloc(4000);
gettext(1, 1, 80, 25, screen);
sx = VIOwherex();
sy = VIOwherey();
clrscr();
*(unsigned int *)0x0040001AL = *(unsigned int *)0x0040001CL; // Flush keyboard

#ifndef DEBUG
remkeyboardisr();
#endif

if (big)
	{
	suspendCom();
	i = spawnvpo("", prog, p);
    restoreCom();
    }
else
	{
	i = spawnvp(P_WAIT, prog, p);
    }

if (i == -1)
	{
    switch (errno)
    	{
		case E2BIG:
			fppe_runtimeError("Shell: Arg list too long");
            break;
		case EINVAL:
			fppe_runtimeError("Shell: Invalid argument");
            break;
		case ENOENT:
			fppe_runtimeError("Shell: Path or file name not found");
            break;
		case ENOEXEC:
			fppe_runtimeError("Shell: Exec format error");
            break;
		case ENOMEM:
			fppe_runtimeError("Shell: Not enough core");
            break;
        }
    }

#ifndef DEBUG
keyboardisr();
#endif

k = 0; kf = 0; lastKey = *(long*)0x0040006CL;
setdisk(save);
chdir(tmpStr2);
puttext(1, 1, 80, 25, screen);
VIOgotoxy(sx, sy);
free(screen);

fppe_setValue(argument[1], i);
}
