/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/*

Dual monitor functions

*/


#include <alloc.h>
#include <mem.h>
#include <string.h>
#include <dos.h>

#include "..\dual\dual.h"

char *vid = (char *)0xB0000000;
int debug_x=0, debug_y=0;

void debug_gotoxy(char x, char y)
{
debug_x = x;
debug_y = y;
debug_movecursor(x, y);
}

void debug_cls(void)
{
int a;
for (a=0;a<4000;a+=2)
	{
	vid[a] = 32;
    vid[a+1] = 7;
    }
debug_gotoxy(0,0);
}

void debug_puts(char *str)
{
char *s = str;
while (*s)
	{
    if (*s == 10)
    	goto nxtLine;
    if (*s == 13)
    	{
    	debug_x = 0;
        return;
        }
    vid[debug_y*160+debug_x*2] = *s;
    vid[debug_y*160+debug_x*2-1] = 7;
    debug_x++;
    if (debug_x == 80)
    	{
        nxtLine:
        if (debug_y+1 == 25)
            debug_scroll();
        else
			debug_y++;
        debug_x = 0;
        }
    s++;
	}
debug_movecursor(debug_x, debug_y);
}

void debug_scroll(void)
{
int a;
memmove(&vid[0], &vid[160],24*160);
for (a=0;a<160;a+=2)
	{
	vid[24*160+a] = 32;
    vid[24*160+a+1] = 7;
    }
}

void debug_movecursor(char x, char y)
{
int a = y*80 + x;
char h,l;
h = (a & 0xFF00) >> 8;
l = a & 0xFF;

outp(0x3b4, 14);
outp(0x3b5, h);
outp(0x3b4, 15);
outp(0x3b5, l);
}


// Not reliable!
int debug_present(void)
{
struct REGPACK reg;

reg.r_ax = 0x1200;
reg.r_bx = 0x0010;
intr(0x10, &reg);

switch (reg.r_cx & 0xFF)
	{
    case 1:
    case 2:
    case 3:
    case 5:
    case 7:
    case 8:
    case 9:
    	return -1;
    default:
    	return 0;
    }
}

