/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef __NET_H
#define __NET_H

#include <stdio.h>

typedef struct {
	char attention;
    char nodeStatus;
    char mailWaiting;
    int  pager;
    char channel;
    char userName[26];
    char userCity[26];
    char userOperation[50];
    char message[80];
    long lastPing;
    char outToDos;
	} netStruct;

#ifdef __cplusplus
extern "C" {
#endif

	void createNodeFile(void);
	void deleteNodeFile(void);
    void updateNodeFile(void);

	void getNetData(int node, netStruct *s);
	void nodeGetUserName(int node, char *buffer);
	void nodeGetUserCity(int node, char *buffer);
	void nodeGetUserOperation(int node, char *buffer);
	char nodeGetStatus(int node);
	void nodeWriteData(int n, char *nodeStatus, char *userName, char *userCity, char *userOp, char *message);

#ifdef __cplusplus
}
#endif

extern netStruct nodeData;
extern FILE* nodeFile;

#endif
