(* Note: This Code has the added External Protocols by Mr. Transistor & by  *)
(* Spring King.  The original code is written by Ken Duda.  The new code is *)
(* written by Spring King & Mr. Transistor.  There is 1 new feature in this *)
(* version:  in an external protocal transfer, a time credit of 1/2 of the  *)
(* time of the upload is given the user.  Ymodem & Xmodem use a different   *)
(* formula, which can be modified in the file 'protocol.pas'.               *)
(* This code is written to include the megalink and protocol too, but       *)
(* but the menu selections 'M' is disabled because of a problem setting     *)
(* the modem back up after using MegaLink.  If you are going to use Sealink *)
(* you must have your modem setup as COM1 or else Sealink will NOT work.    *)
(* Thanks to Omen Technologies (DSZ) and to whoever wrote Wxmodem, Sealink, *)
(* and Megalink.                                                            *)
(* Special thanks to Spring King, Mr. Transistor, and Ken Duda, the author  *)
(* of Forum PC.                                                             *)
(* call the Isengard BBS (312) 985-9699                                     *)

procedure batchdownload (typeoftransfer:char);

  function timeval (blocks:integer):real;
  var min,sec:integer;
      rsec:real;
  begin
  rsec:=1.38 * blocks * (1200/baudrate);
  timeval:=rsec/60.0;
  end;

  function checkfile(pointsleft:integer;num:integer):boolean;
  var ud:udrec;
  fname:lstr;
  f:file;
  begin
    writeln;
    if num=0 then
     begin
       checkfile:=false;
       exit;
     end;
    seekudfile (num);
    read (udfile,ud);
    if (not sponsoron) and (ud.points>pointsleft) then begin
      writeln ('Sorry, that file requires ',ud.points,' points.');
      checkfile:=false;
      exit
    end;
    if (ud.newfile) and (not sponsoron) then begin
      writeln ('Sorry, that is a new file and must be validated.');
      checkfile:=false;
      exit
    end;
    if (ud.specialfile) and (not sponsoron) then begin
      writeln ('Sorry, downloading that file requires special permission.');
      checkfile:=false;
      exit
    end;
    fname:=getfname(ud.path,ud.filename);
    assign (f,fname);
    reset (f);
    close (f);
    iocode:=ioresult;
    if iocode<>0 then
      begin
        fileerror ('BATCH DOWNLOAD',fname);
        checkfile:=false;
        exit
      end;
    checkfile:=true;
  end;

  procedure getfileinfo (var num:integer;var totalminsleft,realtime:real;
    var mins,fsize,actualsize:integer;var sender:mstr;
    var whensent,ratedwhen:longint;var nameoffile:sstr;var filepath:string;
    var filepoints:integer;var filedescrip:lstr;var timesdownloaded:integer;
    var isitnew,isitspecial:boolean);

  var ud:udrec;
  f:file;
  fname:lstr;
  totaltime:sstr;
  secs:integer;

  begin
    seekudfile (num);
    read (udfile,ud);
    fname:=getfname (ud.path,ud.filename);
    assign (f,fname);
    reset (f);
    fsize:=filesize(f);
    actualsize:=fsize;
    close (f);
    totaltime:=minstr(fsize);
    mins:=valu(copy(totaltime,1,pos(':',totaltime)-1));
    secs:=valu(copy(totaltime,pos(':',totaltime)+1,2));
    if secs<>0 then realtime:=mins+(secs/60)
    else realtime:=mins;
    if mins=0 then mins:=1;
    if ((mins>totalminsleft) and (not sponsoron)) then begin
      writestr ('Sorry, you don''t have enough time left!');
      mins:=-5;
      exit
    end;
    if (mins-5>timetillevent) then begin
      writestr ('Sorry, the timed event is coming up too soon!');
      mins:=-5;
      exit
    end;
    writeln (^B^M'Filename:       '^S,ud.filename);
    writeln ('Uploaded by:    '^S,ud.sentby);
    write ('Downloaded:     '^S,ud.downloaded,' time');
    if ud.downloaded=1 then writeln else writeln ('s');
    fsize:=(fsize+7) div 8;
    if fsize = 0 then fsize := 1;
    writeln ('Blocks to send: '^S,fsize);
    writeln ('Transfer time:  '^S,totaltime);
    writeln;
    sender:=ud.sentby;
    whensent:=ud.when;
    ratedwhen:=ud.whenrated;
    nameoffile:=ud.filename;
    filepath:=ud.path;
    filepoints:=ud.points;
    filedescrip:=ud.descrip;
    timesdownloaded:=ud.downloaded;
    isitnew:=ud.newfile;
    isitspecial:=ud.specialfile;
  end;

  procedure check1(var abort:boolean);
        begin
          writestr ('Abort this batch transfer? *');
          if yes then abort:=true
          else abort:=false;
        end;

  procedure check2(var abort,readytostart:boolean);
        begin

            abort:=false;
            readytostart:=false;
            writestr('Ready to start batch transfer? *');
            input:=copy(input,1,1);
            if input='Y' then readytostart:=true
            else if input='y' then readytostart:=true;
            if readytostart then exit
            else
            writeln;
            check1 (abort);
         end;


  type textarray = array[1..9] of string;
     numberarray = array[1..9] of integer;
     realarray = array[1..9] of real;
     sentbyarray = array[1..9] of mstr;
     whenarray = array[1..9] of longint;
     filenamearray = array[1..9] of sstr;
     patharray = array[1..9] of string[50];
     descriparray = array[1..9] of lstr;
     booleanarray = array[1..9] of boolean;

  var   totalblocks,b,pointsleft,points,num,mins,fsize,totalbytes,actualsize,
          filecounter,loopcounter,starttime,endtime,transfertime,estimatedtime:integer;
  var   mins2,minsleft,timetotal:real;
      name,fname:string;
      f:file of byte;
      dirsave,command_line,switches,blocks,minutes:lstr;
      baudst,commst:mstr;
      singlecharacter,batchxfer:char;
      autohang,abort,readytostart:boolean;
      fnames:textarray;
      textname:textarray;
      fsizes,NUMB,filepoints,timesdownloaded,areanumber:numberarray;
      ftime:realarray;
      sender:sentbyarray;
      whensent,ratedwhen:whenarray;
      nameoffile:filenamearray;
      filepath:patharray;
      filedescrip:descriparray;
      isitnew,isitspecial:booleanarray;
      batchfile:text;
  begin
    case typeoftransfer of
      'B':batchxfer:='Y';
      'Z':batchxfer:='Z';
      else exit;
      end;
    writeln;
    writeln (batchxfer,'Modem Batch Download Selected');
    getdir (0, dirsave);   (* drive: 0 = cur. 1 = A: etc. - save cur. dir. *)
    str (baudrate:3, baudst);  (* cnvt baud and comm port to strings *)
    str (usecom:1, commst);
    filecounter:=1;
    pointsleft:=urec.udpoints;
    minsleft:=timeleft;
    totalbytes:=0;
    readytostart:=false;
    repeat
      tab ('Points available: '^S+strr(pointsleft),24);
      writeln (^R'Time available: '^S+strr(round(minsleft)));
      estimatedtime:=timeleft-round(minsleft);
      if estimatedtime<1 then estimatedtime:=0;
      tab ('Total D/L Time: '^S+strr(estimatedtime),24);
      writeln (^R'Batch file #: '^S,filecounter);
      writeln;
      num:=getfilenumbatch('Batch Download');
      input:='';
      if num=0 then if filecounter = 1 then
       begin
         check1(abort);
         if abort then exit;
       end;

      if num=0 then if filecounter >1 then if filecounter <10 then
        begin
         check2(abort,readytostart);
         if abort then exit;
         if readytostart then writeln(^M^J'Starting Batch Download.')
        end;

      if not checkfile (pointsleft,num) then if filecounter =1 then exit;

      if checkfile (pointsleft,num) then
       begin
        if tempsysop then
         begin
           ulvl:=regularlevel;
           tempsysop:=false;
           writeurec;
           bottomline
         end;
        getfileinfo(num,minsleft,mins2,mins,fsize,actualsize,sender[filecounter],
        whensent[filecounter],ratedwhen[filecounter],nameoffile[filecounter],
        filepath[filecounter],filepoints[filecounter],filedescrip[filecounter],
        timesdownloaded[filecounter],isitnew[filecounter],
        isitspecial[filecounter]);
        areanumber[filecounter]:=curarea;
        if (mins=-5) and (filecounter =1) then exit
        else if mins=-5 then readytostart:=true;
        if mins<>-5 then begin
          if (filepoints[filecounter]>0) and (not sponsoron) then
              pointsleft:=pointsleft-filepoints[filecounter];
          fnames[filecounter]:=getfname(filepath[filecounter],nameoffile[filecounter]);
          textname[filecounter]:=nameoffile[filecounter];
          fsizes[filecounter]:=fsize;
          totalbytes:=totalbytes+actualsize;
          ftime[filecounter]:=mins2;
          numb[filecounter]:=num;
          minsleft:=minsleft-mins2;
          filecounter:=filecounter+1;
          if filecounter=10 then readytostart:=true
        end;
      end;
  until readytostart;

  if readytostart then begin
    assign (batchfile,'batch.xfr');
    rewrite (batchfile);
    loopcounter:=1;
    timetotal:=0;
    totalblocks:=0;
    repeat
      if fsizes[loopcounter]>1 then blocks:=' 1 K Blocks'
      else blocks:='Block';
      if ftime[loopcounter]>1.0 then minutes:=' minutes'
      else minutes:='minute';
      totalblocks:=totalblocks+fsizes[loopcounter];
      timetotal:=timetotal+ftime[loopcounter];
      writeln (batchfile,fnames[loopcounter]);
      loopcounter:=loopcounter+1;
    until loopcounter=filecounter;
  textclose (batchfile);
  loopcounter:=1;
  if ansigraphics in urec.config then begin
    writestr ('Ŀ');
    writestr ('                  Batch Download Statistics                  ');
    writestr ('Ĵ');
    writestr (''^S' #  Filename        Kbytes    Time to d/l (minutes)'^R'          ');
    writestr ('Ĵ');


    end
  else begin
    writestr ('+-------------------------------------------------------------+');
    writestr ('!                 Batch Download Statistics                   !');
    writestr ('+-------------------------------------------------------------+');
    writestr ('! #  Filename         Kbytes     Time to d/l (minutes)        !');
    writestr ('+-------------------------------------------------------------+');
end;
  repeat
    if ansigraphics in urec.config then begin
       write (^R' '^S);
       tab (strr(loopcounter),3);
       tab (nameoffile[loopcounter],17);
       tab (strr(round(fsizes[loopcounter])),11);
       tab (minstr(round(fsizes[loopcounter]*8)),29);
       writeln (^R'');
       end
     else begin
       write ('! ');
       tab (strr(loopcounter),3);
       tab (nameoffile[loopcounter],18);
       tab (strr(round(fsizes[loopcounter])),12);
       tab (minstr(round(fsizes[loopcounter]*8)),27);
       writeln ('!');
       end;
     loopcounter:=loopcounter+1;
  until loopcounter=filecounter;
  if ansigraphics in urec.config then begin
        writestr('Ĵ');
        write (^R'');
        tab (^P+'Total Files:',14);
        tab (^S+strr(filecounter-1),4);
        tab (^P+'Total 1k blocks:',18);
        tab (^S+strr(totalblocks),6);
        tab (^P+'Apprx. d/l time:',18);
        tab (^S+minstr(totalbytes-round((totalbytes * 0.1))),7);
        writeln (^R'');
        writestr('');
        end
  else begin
        writestr('+-------------------------------------------------------------+');
        write ('!');
        tab ('Total Files:',13);
        tab (strr(filecounter-1),3);
        tab ('Total 1k blocks:',17);
        tab (strr(totalblocks),5);
        tab ('Apprx. d/l time:',17);
        tab (minstr(totalbytes-round((totalbytes * 0.1))),6);
        writeln ('!');
        writestr('+-------------------------------------------------------------+');
      end;
  writeln;
    writestr('Automatically DISCONNECT after the download? (y/N) *');
    if yes then autohang:=true
    else autohang:=false;
    writeln;
    writeln (batchxfer,'Modem Batch Download. [Ctrl-X][Ctrl-X][Enter] a few times to abort');
{  switches:=' port '+commst+' speed '+baudst+' s'; }
    switches:=' port '+commst+' speed '+baudst+' handshake both s';
  if batchxfer='Y' then
    switches:=switches+'b -k @'+dirsave+'\batch.xfr';
  if batchxfer='Z' then
    switches:=switches+'z @'+dirsave+'\batch.xfr';
  command_line:='DSZ.COM';
  starttime:=timer;
  runext(b,command_line,switches);
  endtime:=timer;
  if endtime<starttime then endtime:=endtime+1440;
  transfertime:=endtime-starttime;
  if b=1 then b:=2;
    beepbeep(b);
    loopcounter:=1;
    repeat
      if transfertime-round(ftime[loopcounter])>0 then
      begin
        transfertime:=transfertime-round(ftime[loopcounter]);
        writelog (15,5,textname[loopcounter]);
        setareareset (areanumber[loopcounter]);
        seekudfile(numb[loopcounter]);
        fname:=getfname(filepath[loopcounter],nameoffile[loopcounter]);
        assign (f,fname);
        reset (f);
        ud.sentby:=sender[loopcounter];
        ud.when:=whensent[loopcounter];
        ud.whenrated:=ratedwhen[loopcounter];
        ud.filename:=nameoffile[loopcounter];
        ud.path:=filepath[loopcounter];
        ud.points:=filepoints[loopcounter];
        ud.filesize:=filesize (f);
        ud.descrip:=filedescrip[loopcounter];
        ud.downloaded:=timesdownloaded[loopcounter]+1;
        ud.newfile:=isitnew[loopcounter];
        ud.specialfile:=isitspecial[loopcounter];
        urec.downloads:=urec.downloads+1;
        if (ud.points>0) and (not sponsoron) then
         urec.udpoints:=urec.udpoints-ud.points;
        write (udfile,ud);
        writeurec;
        close (f);
        loopcounter:=loopcounter+1;
       end
      else loopcounter:=filecounter;
      until loopcounter=filecounter;
      writeln (^B'You now have ',numthings (urec.udpoints,'point','points'),' left in your account.');
      chdir (dirsave);
      if autohang then disconnect;
  end;
end;


(* Note: The following builds a command line to invoke the various external *)
(* protocols directly.  This should allow ERRORLEVEL to be returned cor-    *)
(* rectly and allow externals to be used on a Multi-Tasking system.         *)
(* DSZ returns ERRORLEVEL correctly but WXmodem does not.  - Mr. Transistor *)
(* & Spring King.                                                           *)

  function doext (mode,proto:char;uddir,fn:lstr;baud,comm:integer):integer;
  var cmdline,switches,dirsave,cddir:lstr;
      baudst,commst:mstr;
      retcd:integer;
  begin
    getdir (0, dirsave);   (* drive: 0 = cur. 1 = A: etc. - save cur. dir. *)
    if uddir[length(uddir)]='\'
     then
      cddir:=copy(uddir,1,length(uddir)-1)
     else
      cddir:=uddir;
    chdir (cddir);         (* cd to rcv/snd dir *)
    str (baud:3, baudst);  (* cnvt baud and comm port to strings *)
    str (comm:1, commst);
    if mode='R' then begin        (* receive stuff *)
      case proto of
        'W':cmdline:=dirsave+'\WXMODEM.COM';
        'M':cmdline:=dirsave+'\MEGALINK.COM';
        'S':cmdline:=dirsave+'\CLINK.EXE';
        'Z':cmdline:=dirsave+'\DSZ.EXE';
        'J':cmdline:=dirsave+'\JModem.COM';
      end
    end;
    if mode='R' then begin        (* receive stuff *)
      case proto of
        'W':switches:=' -b '+baudst+' -l com'+commst+' -p W -r -f '+fn+' -c';
        'M':switches:=' PORT '+commst+' SPEED '+baudst+' RM';
        'S':switches:=' R';
        'Z':switches:=' port '+commst+' speed '+baudst+' rz '+cddir+'\'+fn;
        'J':switches:=' R'+commst+' '+fn;
      end;
    end;
    if mode='S' then begin        (* xmit stuff *)
      case proto of
        'W':cmdline:=dirsave+'\WXMODEM.COM';
        'M':cmdline:=dirsave+'\MEGALINK.COM';
        'S':cmdline:=dirsave+'\CLINK.EXE';
        'J':cmdline:=dirsave+'\JModem.Com';
      end
    end;
    if mode='S' then begin        (* xmit stuff *)
      case proto of
        'W':switches:=' -s -b '+baudst+' -l com'+commst+' -p y -f '+fn;
        'M':switches:=' PORT '+commst+' SPEED '+baudst+' SM '+fn;
        'S':switches:=' T '+fn;
        'J':switches:=' R'+commst+' '+fn;
      end
    end;
    runext (retcd, cmdline,switches);  (* actually do external call... *)
    chdir (dirsave);             (* back from whence we came... *)
    setparam(usecom,baudrate,parity);
    doext:=retcd;
  end;




procedure download (autoselect:integer);
  var totaltime:sstr;
      num,fsize,mins:integer;
      ud:udrec;
      fname:lstr;
      autohang,ymodem:boolean;
      i,b:integer;
      f:file;
      extrnproto:char;
  begin
    if not allowxfer then exit;
    if nofiles then exit;
    ymodem:=false;
    extrnproto:='N';
    i:=menu('Protocol','PROTO','XYZBWSMQJ');
    if hungupon then exit;
    case i of
      1:ymodem:=false;
      2:ymodem:=true;
      3:extrnproto:='Z';
      4:extrnproto:='B';
      5:extrnproto:='W';
      6:extrnproto:='S';
      7:extrnproto:='M';
      8:exit;
      9:extrnproto:='J';
    end;
    if (extrnproto ='B') or (extrnproto='Z') then
      begin
       batchdownload (extrnproto);
       exit;
      end;
    if autoselect=0
      then num:=getfilenum('download')
      else num:=autoselect;
    if num=0 then exit;
    writeln;
    seekudfile (num);
    read (udfile,ud);
    if (not sponsoron) and (ud.points>urec.udpoints) then begin
      writeln ('Sorry, that file requires ',ud.points,' points.');
      exit
    end;
    if (ud.newfile) and (not sponsoron) then begin
      writeln ('Sorry, that is a new file and must be validated.');
      exit
    end;
    if (ud.specialfile) and (not sponsoron) then begin
      writeln ('Sorry, downloading that file requires special permission.');
      exit
    end;
    if tempsysop then begin
      ulvl:=regularlevel;
      tempsysop:=false;
      writeurec;
      bottomline
    end;

(*    if extrnproto='W' then

{If you want to re-enable WXmodem, then just remove the lines from the next}
{   begin through to the next end, and the above if statement.}

    begin
         writestr ('I am sorry, but WXmodem bombs when a filetransfer is aborted.');
         writestr ('If the author fixes this error, then WXmodem will be re-enabled.');
         writeln ('Transfer Aborted! '^G);
         exit;
    end;   *)
    fname:=getfname(ud.path,ud.filename);
    assign (f,fname);
    reset (f);
    iocode:=ioresult;
    if iocode<>0 then
      begin
        fileerror ('DOWNLOAD',fname);
        exit
      end;
    fsize:=filesize(f);
    close (f);
    totaltime:=minstr(fsize);
    mins:=valu(copy(totaltime,1,pos(':',totaltime)-1));
    if ((mins>timeleft) and (not sponsoron)) then begin
      writestr ('Sorry, you don''t have enough time left!');
      exit
    end;
    if (mins-5>timetillevent) then begin
      writestr ('Sorry, the timed event is coming up too soon!');
      exit
    end;
    writeln (^B^M'Filename:       '^S,ud.filename);
    writeln ('Uploaded by:    '^S,ud.sentby);
    write ('Downloaded:     '^S,ud.downloaded,' time');
    if ud.downloaded=1 then writeln else writeln ('s');
    if ymodem then fsize:=(fsize+7) div 8;
    if fsize = 0 then fsize:= 1;
    writeln ('Blocks to send: '^S,fsize);
    writeln ('Transfer time:  '^S,totaltime);
    writeln (^M'CRC use will be automatically selected');
    writeln;
    writestr('Automatically DISCONNECT after the download? (Y/N) *');
    if upcase(input[1]) ='Y' then autohang:=true
    else autohang:=false;
    case extrnproto of
         'S':tab ('Sealink',7);
         'W':tab ('WXmodem',7);
         'M':tab ('Megalink',8);
         'J':tab ('JModem',6);
    end;
    if ymodem then write ('Ymodem') else if extrnproto='N' then
       write ('Xmodem-CRC');
    writeln (' transmit ready.  [Ctrl-X][Ctrl-X][Enter] a few times to abort');
    if extrnproto='N' then begin
      b:=protocolxfer (true,false,ymodem,fname);
      beepbeep (b)
    end;
    if extrnproto<>'N' then begin
      b:=doext('S',extrnproto,ud.path,ud.filename,baudrate,usecom);
      if b<>0 then b:=2;
      modeminlock:=false;
      beepbeep (b)
    end;
    if (b=0) then begin
      writelog (15,1,fname);
      ud.downloaded:=ud.downloaded+1;
      urec.downloads:=urec.downloads+1;
      seekudfile (num);
      write (udfile,ud);
      if (ud.points>0) and (not sponsoron) then begin
        urec.udpoints:=urec.udpoints-ud.points;
        writeln (^B'You now have ',
                 numthings (urec.udpoints,'point','points'),'.')
      end;
      writeurec
    end;
   if autohang then disconnect;
  end;

  procedure typefile;
  var num:integer;
      ud:udrec;
      fname:lstr;
      f:text;
      k:char;
  begin
    if nofiles then exit;
    num:=getfilenum('type');
    if num=0 then exit;
    writeln;
    seekudfile (num);
    read (udfile,ud);
    if (not sponsoron) and (ud.points>urec.udpoints) then begin
      writeln ('Sorry, that file requires ',ud.points,' points.');
      exit
    end;
    if (ud.newfile) and (not sponsoron) then begin
      writeln ('Sorry, that is a new file and must be validated.');
      exit
    end;
    if (ud.specialfile) and (not sponsoron) then begin
      writeln ('Sorry, downloading that file requires special permission.');
      exit
    end;
    if tempsysop then begin
      ulvl:=regularlevel;
      tempsysop:=false;
      writeurec;
      bottomline
    end;
    fname:=getfname(ud.path,ud.filename);
    assign (f,fname);
    reset (f);
    iocode:=ioresult;
    if iocode<>0 then
      begin
        fileerror ('TYPEFILE',fname);
        exit
      end;
    writeln (^B^M'Filename:       '^S,ud.filename);
    writeln ('Uploaded by:    '^S,ud.sentby);
    if (ud.points>0) and (not sponsoron) then begin
      write (^B^M'NOTE: When the transfer begins, you ',
               ^M'      will be charged ',ud.points,' point');
      if ud.points<>1 then write ('s');
      writeln ('!')
    end;
    writeln (^B^M'Press any key to begin the transfer,',
               ^M'or [Ctrl-X] to abort...'^M);
    k:=waitforchar;
    if (k=^X) or (upcase(k)='X') then begin
      textclose (f);
      writeln (^B^M'Aborted!');
      exit
    end;
    while not (eof(f) or break) do begin
      read (f,k);
      if k=^M then writeln else if k<>^J then write (k)
    end;
    textclose (f);
    if (ud.points>0) and (not sponsoron) then begin
      urec.udpoints:=urec.udpoints-ud.points;
      writeln (^B'You now have ',
               numthings (urec.udpoints,'point','points'),'.')
    end;
    writeurec
  end;

  procedure upload;
  var ud:udrec;
      ok,crcmode,ymodem:boolean;
      i,b,starttime,endtime,transfertimecredit:integer;
      dirsave,cddir,fn:lstr;
      time:string;
      extrnproto:char;
      f:file;
  begin
    if not allowxfer then exit;
    if timetillevent<30 then begin
      writestr (
   'Sorry, uploads are not allowed within one half hour of the timed event!');
      exit
    end;
    ok:=false;
    write ('Free disk space: ');
    writefreespace (area.xmodemdir);
    writeln;
    repeat
      writestr ('Target filename:');
      if length(input)=0 then exit;
      if not validfname(input) then begin
        writeln ('Invalid filename!');
        exit
      end;
      ud.filename:=input;
      ud.path:=area.xmodemdir;
      fn:=getfname(ud.path,ud.filename);
      if hungupon then exit;
      if exist(fn)
        then writeln ('Sorry!  File exists!')
        else ok:=true
    until ok;
    crcmode:=false;
    ymodem:=false;
    extrnproto:='N';
    i:=menu('Protocol','PROTO','XYZWSMQJ');
    if hungupon then exit;
    case i of
      1:ymodem:=false;
      2:ymodem:=true;
      3:extrnproto:='Z';
      4:extrnproto:='W';
      5:extrnproto:='S';
      6:extrnproto:='M';
      7:exit;
      8:extrnproto := 'J';
    end;

{ If you want to re-enable WXmodem, then just remove the lines from the next
  if statement through to the next end.}
{    if extrnproto='W' then
    begin
         writestr ('I am sorry, but WXmodem bombs when a filetransfer is aborted.');
         writestr ('If the author fixes this error, then WXmodem will be re-enabled.');
         writeln ('Transfer Aborted! '^G);
         exit;
    end;   }

    if extrnproto='N' then if ymodem then crcmode:=true
     else begin
      writestr ('CRC Mode? *');
      crcmode:=yes
     end;
    case extrnproto of
         'S':tab ('Sea Link',8);
         'Z':tab ('Zmodem',6);
         'W':tab ('WXmodem',7);
         'M':tab ('Megalink',8);
         'B':tab ('Ymodem Batch',12);
         'J':tab ('Jmodem',6);
    end;
    if ymodem then write ('Ymodem') else if extrnproto='N' then
       write ('Xmodem');
    if crcmode then write ('-CRC');
    writeln (' receive ready.  [Ctrl-X][Ctrl-X][Enter] a few times to abort');
    if tempsysop then begin
      ulvl:=regularlevel;
      tempsysop:=false;
      writeurec;
      bottomline
    end;
    starttime:=timer;
    if extrnproto='N' then begin
      b:=protocolxfer (false,crcmode,ymodem,fn);
      beepbeep (b)
    end
    else begin
      b:=doext('R',extrnproto,ud.path,ud.filename,baudrate,usecom);
      endtime:=timer;
      modeminlock:=false;
      modemoutlock:=false;
      if b<>0 then b:=2;
      beepbeep (b)
    end;
    if b>=1 then
       begin
            if exist (fn) then
            begin
               assign(f, fn);
               erase (f);
            end;
       exit;
       end;
    if b=0 then begin
      buflen:=50;
      writestr ('If your upload failed & Forum thinks otherwise, then please');
      writestr ('enter ''BAD TRANSFER'' at the Description prompt.  Thanks.');
      writeln;
      writestr ('                       0        1         2         3         4         5');
      writestr ('50 Characters Maximum! 1---!----0----!----0----!----0----!----0----!----0');
      writestr ('Description of upload: &');
      if input='BAD TRANSFER' then
         begin
              if exist(fn) then
                begin
                   assign(f, fn);
                   erase (f);
                end;
              exit;
         end;
      writelog (15,2,fn);
      ud.descrip:=input;
      ud.sentby:=unam;
      ud.when:=now;
      ud.whenrated:=now;
      ud.points:=0;
      ud.downloaded:=0;
      ud.newfile:=true;
      ud.specialfile:=false;
      ud.downloaded:=0;
      writeln ('Thanks for uploading!');
      if extrnproto<>'N' then
      begin
           if endtime<starttime then endtime:=endtime+1440;
           transfertimecredit:=(endtime-starttime)div 2;
           settimeleft(timeleft+transfertimecredit);
           writeln;
           str(transfertimecredit, time);
           writeln('Upload time credit: ',time,' minutes.');
      end;
      str(timeleft, time);
      writeln;
      writeln('You now have ',time,' minutes left!');
      getfsize (ud);
      addfile (ud);
      urec.uploads:=urec.uploads+1;
      newuploads:=newuploads+1
    end;
  end;


