
UNIT TopPost;
INTERFACE
USES GenTypes,
     Gensubs,
     Subs1,
     Subs2;

VAR Post_array : Top_poster_type;

Procedure Show_top_posters;
Procedure Add_name(User : Mstr; Posts : WORD);
Procedure Delete_One_post(User : MStr; Posts : WORD);
Procedure Save_top_posters;

IMPLEMENTATION

{=============================================================================}

Function Name_there(User_nam : Mstr) : INTEGER;
VAR c1 : BYTE;
    Found : BOOLEAN;
Begin
  Found := FALSE;
  For c1 := 1 to MaxTopPosters Do
    Begin
      If Post_Array[c1].User_name = User_nam THEN
       Begin
        Name_there := c1;
        Found := TRUE;
       End;
    End;
  If Not Found THEN Name_there := -1;
End;

{=============================================================================}

Procedure Add_name(User : Mstr; Posts : WORD);
VAR L_pos : INTEGER;
    c1    : BYTE;
    Temp  : Top_poster_rec;

{-----------------------------------------------------------------------------}

Procedure Insert_name(Ins_num : BYTE; User_n : Mstr; Posts : WORD);
VAR c1 : BYTE;
Begin
  If (Ins_num > MaxTopPosters) OR (Ins_num < 0) THEN Exit;
  For c1 := MaxTopPosters DOWNTO Ins_num+1 DO
      Post_array[c1] := Post_array[c1-1];
  Post_array[Ins_num].User_name := User_n;
  Post_array[Ins_num].Num_posts := Posts;
End;

{-----------------------------------------------------------------------------}

Begin
  L_pos := Name_there(User);
  If L_pos = -1 THEN
    Begin    {  Not currently in list }
      For c1 := 0 TO MaxTopPosters DO
        Begin
          If Post_array[c1+1].Num_Posts < Posts THEN
            Begin
              Insert_Name(c1+1,User,Posts);
              Exit;
            End;
        End;
    End
  ELSE       {  Currently in List     }
    Begin
      Inc(Post_array[L_pos].Num_posts);
      If L_Pos = 1 THEN Exit;
      If Post_array[L_pos-1].Num_Posts < Posts THEN
        Begin
          Temp := Post_array[L_pos-1];
          Post_array[L_pos-1] := Post_array[L_pos];
          Post_array[L_pos] := Temp;
        End;
    End;
End;

{=============================================================================}

Procedure Delete_One_post(User : MStr; Posts : WORD);
VAR L_pos : INTEGER;
    Temp  : Top_poster_rec;
Begin
  L_pos := Name_there(User);
  If L_pos <> -1 THEN
    Begin
      Dec(Post_array[L_pos].Num_posts);
      If L_Pos = 10 THEN Exit;
      If Post_array[L_pos+1].Num_Posts > Posts THEN
        Begin
          Temp := Post_array[L_pos+1];
          Post_array[L_pos+1] := Post_array[L_pos];
          Post_array[L_pos] := Temp;
        End;
    End;
End;

{=============================================================================}

Procedure Save_top_posters;
Begin
  Assign(Top_post_file,BoardDir+'Forum.T10');
  Rewrite(Top_post_file);
  Write(Top_post_file,Post_Array);
  Close(Top_post_file);
End;

{=============================================================================}

Procedure Show_top_posters;
VAR IO_c       : INTEGER;
    c2         : INTEGER;
    Post_user  : UserRec;

{-----------------------------------------------------------------------------}

Begin
  If Not Exist(BoardDir+'Forum.T10') THEN
    Begin    { Create new poster file }

      Writeln('Top poster file does not exist.  Creating new file.');
      Write('Wait ');
      For c2 := 1 TO NumUsers DO
        Begin
          If c2 MOD 6 = 0 THEN Write('.');
          Seek(Ufile,c2);
          Read(Ufile,Post_user);
          Add_name(Post_user.Handle,Post_user.Nbu);
        End;
      Writeln;
      Save_top_posters;
    End;
  Assign(Top_post_file,BoardDir+'Forum.T10');
  {$I-}
    Reset(Top_post_file);
  {$I+}
  IO_c := IOResult;
  If IO_c <> 0 THEN
    Begin
      Writeln('Critical error #',IO_c);
      Exit;
    End;
  Read(Top_post_file,Post_Array);
  Writeln;
  WriteHdr(LongName+' Top Posters');
  For c2 := 1 TO MaxTopPosters DO
   Begin
    Tab('',2);
    Tab(Strr(c2)+'. ',4);
    Tab(Post_array[c2].User_name,25);
    Writeln('[',Post_array[c2].Num_posts,' posts]');
   End;
  Close(Top_post_file);
End;

{=============================================================================}

Begin
End.