{$X+}
(*
                Illusion Loader routines for ILLUSION.
                Written by   : Cameron Booth.
                Modified     : 17/10/95

*)


Unit LdrUnit;

Interface

Uses Crt;

Const
  UpArrow       = #72;
  DownArrow     = #80;
  RightArrow    = #77;
  LeftArrow     = #75;
  ReturnKey     = #13;
  SpaceKey      = #32;
  ESCKey        = #27;
  
Procedure Cursor_Off;
Procedure Cursor_On;
Function Exist (FileString : String) : Boolean;
Function AllTrim (Str : String) : String;
Procedure Loader (FileName : String);


Implementation

Const
  MaxLngth   = 820;
  LineLength = 75;
Var
  TextBody : Array [1..MaxLngth] Of String [LineLength];
  
Procedure Cursor_Off;
Begin
  Asm
    Mov   AH, 1
    Mov   CH, 32
    Mov   CL, 0
    Int   $10
  End
End;

Procedure Cursor_On;
Begin
  Asm
    Mov   AH, 1
    Mov   CH, 6
    Mov   CL, 7
    Int   $10
  End
End;

Function Exist (FileString : String) : Boolean;
Var
  ExistHandle : File;
  Index       : Integer;
Begin
  {$I-}
  Assign (ExistHandle, FileString);
  Reset (ExistHandle);
  Index := IOResult;
  Exist := Index = 0;
  Close (ExistHandle);
  Index := IOResult
  {$I+}
End;

Function LTrim (s: String; c: Char ): String; Assembler;
Asm
  PUSH   DS
  LDS    SI, s
  XOr    AX, AX
  LODSB
  XCHG   AX, CX
  LES    DI, @Result
  Inc    DI
  JCXZ   @@2
  
  MOV    BL, c
  CLD
  @@1:  LODSB
  CMP    AL, BL
  LOOPE  @@1
  Dec    SI
  Inc    CX
  REP    MOVSB
  
  @@2:  XCHG   AX, DI
  MOV    DI, Word Ptr @Result
  SUB    AX, DI
  Dec    AX
  STOSB
  POP    DS
End;

Function RTrim (S : String; C : Char) : String;
Begin
  While (Length (S) > 0) And (S [Length (S) ] = C) Do Dec (S [0] );
Begin
  RTrim := S;
End;
End;

Function AllTrim (Str : String) : String;
Begin
  If Length (Str) > 0 Then
  Begin
    AllTrim := LTrim (RTrim (Str, ' '), ' ')
  End
  Else
  Begin
    AllTrim := Str;
  End;
End;

Function Left (S : String; N : Byte) : String; Assembler;
Asm
  PUSH    DS
  LES     DI, @Result
  LDS     SI, s
  MOV     AL, n
  CLD
  XOr     CX, CX
  MOV     CL, Byte Ptr [SI]
  Inc     SI
  CMP     CX, 0
  JZ      @@2
  CMP     AL, 0
  JLE     @@1
  MOV    Byte Ptr ES: [DI], AL
  Inc    DI
  MOV    CL, AL
  REP    MOVSB
  JMP    @@3
  @@1:  MOV     CL, 0
  @@2:  MOV     ES: [DI], CL
  @@3:  POP     DS
End;

Function RealToInt (RealNum : Real) : LongInt;
Var
  S : String;
  L : LongInt;
  I : Integer;
Begin
  Str (RealNum: 17: 2, S);
  S := Left (S, Length (S) - 3);
  Val (S, L, I);
  RealToInt := L;
End;

Procedure DrawConfigFrame;
Begin
  {DisplayAnsi('TXTVIEW.ANS');}
End;

Procedure DisplayStat (Current, Max, X, Y : Integer);
Var
  Index, Loop : Integer;
  RIndex      : Real;
Begin
  GotoXY (X, Y);
  RIndex := (Current / Max);
  RIndex := 50 * RIndex;
  Index := RealToInt (RIndex);
  TextBackground (Black);
  TextColor (LightBlue);
  For Loop := 1 To Index Do
  Begin
    Write ('');
  End;
  TextColor (White);
  For Loop := Loop + 1 To 50 Do
  Begin
    Write (' ');
  End;
End;

Procedure ProcessFile (FileName : String);
Const
  LinesPerWin = 17;
  X           = 3;
  Y           = 5;
Var
  TextHandle        : Text;
  ReadMax , Index1,
  Index2, VarY,
  SpareY, Loop,
  ScrollUp, Start,
  Max, ScrollDown   : Integer;
  SpareStr          : String;
  Done              : Boolean;
  TempChar          : Char;
Begin
  TextBackground (Black);
  TextColor (LightBlue);
  GotoXY (19, 10);
  Write ('ķ');
  GotoXY (19, 11);
  Write ('                                        ');
  GotoXY (19, 12);
  Write ('Ľ');
  TextColor (White);
  GotoXY (27, 11);
  Write ('Processing Text file now ...');
  Max := MaxLngth;
  Loop := 0;
  SpareStr := AllTrim (FileName);
  Assign (TextHandle, SpareStr);
  Reset (TextHandle);
  Repeat
    Inc (Loop);
    ReadLn (TextHandle, TextBody [Loop] );
    Start := Length (TextBody [Loop] ) + 1;
    For VarY := Start To LineLength Do
    Begin
      Insert (' ', TextBody [Loop], VarY);
    End;
  Until (EoF (TextHandle) ) Or (Loop = Max);
  Close (TextHandle);
  Max := Loop;
  Done := False;
  ScrollUp := 0;
  TextBackground (Black);
  TextColor (White);
  GotoXY (X, Y + 1);
  Write (TextBody [1] );
  If Max > LinesPerWin Then
  Begin
    ScrollDown := Max - LinesPerWin;
    Start := LinesPerWin;
    For Loop := 2 To LinesPerWin Do
    Begin
      GotoXY (X, Y + Loop);
      Write (TextBody [Loop] );
    End;
  End
  Else
  Begin
    ScrollDown := 0;
    Start := Max;
    For Loop := 2 To Max Do
    Begin
      GotoXY (X, Y + Loop);
      Write (TextBody [Loop] );
    End;
  End;
  Repeat
    DisplayStat (Start, Max, 15, 23);
    TempChar := ReadKey;
    TextBackground (Black);
    If TempChar = UpArrow Then
    Begin
      If (Start <> (ScrollUp + 1) )  And (Start <> 1) Then
      Begin
        GotoXY (X, Y + (Start - ScrollUp) );
        Write (TextBody [Start] );
        Dec (Start);
      End
      Else If Start <> 1 Then
      Begin
        Dec (Start);
        Dec (ScrollUp);
        Inc (ScrollDown);
        TextBackground (Black);
        For Loop := 1 To LinesPerWin Do
        Begin
          GotoXY (X, Y + Loop);
          Write (TextBody [Loop + ScrollUp] );
        End;
      End;
    End
    Else If TempChar = DownArrow Then
    Begin
      If (Start <> (Max - ScrollDown) ) And (Start <> Max) Then
      Begin
        GotoXY (X, Y + (Start - ScrollUp) );
        Write (TextBody [Start] );
        Inc (Start);
      End
      Else If Start <> Max Then
      Begin
        Inc (Start);
        Inc (ScrollUp);
        Dec (ScrollDown);
        For Loop := 1 To LinesPerWin Do
        Begin
          GotoXY (X, Y + Loop);
          Write (TextBody [ScrollUp + Loop] );
        End;
        Inc (Loop);
      End;
    End
      Else If TempChar = ReturnKey Then
      Begin
        Done := True;
      End
        Else If TempChar = ESCKey Then
        Begin
          Done := True;
        End;
  Until Done = True;
  TextBackground (Black);
End;

Procedure Loader (FileName : String);
Begin
  Cursor_Off;
  ClrScr;
  TextBackground (Black);
  TextColor (White);
  DrawConfigFrame;
  ProcessFile (FileName);
  ClrScr;
End;
End.