Unit GlobFEL;

Interface

{$I FLSTRUCT.PAS}  (*  This file stores all the structures for Felony *)

Var
  CFG  : FelCFG;
  USERS  : UsersFile;
  W1   : Word;
  StringRec : FelSTRING;
  StringDat : File Of FelSTRING;
  USR : FelUSER;
  MTX : FelMTX;

Function Exist (FileString : String) : Boolean;
Procedure Cursor_Off;
Procedure Cursor_On;
Function  RdStr (Size : Byte) : String;
Procedure FelonyCredits;
Function FileExists ( FileName : String) : Boolean;
Function SmartCase (S : String) : String;
Function LowChar (CH : Char) : Char;
Function StLowCase (S : String) : String;
Procedure InitCFG;
Procedure ReadCFG;
Procedure WriteCFG;
Procedure CheckFiles30;
Procedure Wait (D: Word);
Procedure CLS;
Procedure FelColours (ColStr : String);
Function LTrim (s: String; c: Char ): String;
Function RTrim (S : String; C : Char) : String;
Function AllTrim (Str : String) : String;
Procedure DisplayAnsi (FileName : String);
Function StrToInt (cNum : String) : LongInt;
Function IntToStr (Input : LongInt) : String;
Procedure GETSTRING (Var L1 : String; LEN : Byte; Charput : Char; CA : Byte; DC : Char; Opt : Byte; Keep : Boolean);
Function Attr (f, s: Byte): Byte;
Function UpCaseStr (Stri : String) : String;
Function DnCaseStr (Stri : String) : String;
Function I2S (L : LongInt) : String;
Procedure LogMsg (Msg : String);
Procedure WriteHDR (q:anystr);
Procedure PageSysOp;

Implementation

Uses Crt, DOS, Ansidrv, FELAnsi, FelANS, FelFX, FelFOSS;

Procedure WriteHDR (q:anystr);
var cnt:integer;
begin
writeln;
writeln;
PipeParser('|f0|70|f0|70|80|70|80    ',True);writeln;
PipeParser('   |90'+q+'',True);writeln;
PipeParser('|f0|70|f0|70|80|70|80    ',True);writeln;
writeln;
writeln;
TextColor(white);
end;

Procedure PageSysOp;
begin
  nosound;
  sound (200);
  delay (10);
  writechar(#7);
  nosound
end;

Procedure LogMsg (Msg : String);
Var
  LogFile         : Text;
  S               : String;
  Hour, Min, Sec, W1 : Word;
Begin
  Assign (LogFile, Cfg. MainDir + 'LOGFILE.TXT');
  {$I-}
  SetFAttr (LogFile, 0);
  Append (LogFile);
  If IOResult <> 0 Then Rewrite (LogFile);
  {$I+}
  If IOResult = 0 Then
  Begin
    GetTime (Hour, Min, Sec, w1);
    If Hour < 10 Then Write (LogFile, '0');
    Write (LogFile, Hour, ':');
    If Min < 10 Then Write (LogFile, '0');
    Write (LogFile, Min, ':');
    If Sec < 10 Then Write (LogFile, '0');
    If Length (Msg) > 67 Then Msg [0] := #64;
    WriteLn (LogFile, Sec, '  ', msg);
    Close (LogFile);
  End;
End;

Function I2S (L : LongInt) : String;
Var S : String;
Begin
  Str (L, S);
  I2S := S;
End;

Function UpCaseStr (Stri : String) : String;
Var Nane : Byte;
Begin
  For Nane := 1 To Length (Stri) Do
    If (Stri [Nane] >= 'a') And (Stri [Nane] <= 'z') Then
      Stri [Nane] := Chr ( Ord (Stri [Nane] ) - 32 )
    Else
      Stri [Nane] := Chr ( Ord (Stri [Nane] ) );
  UpCaseStr := Stri;
End;

Function DnCaseStr (Stri : String) : String;
Var Nane : Byte;
Begin
  For Nane := 1 To Length (Stri) Do
    If (Stri [Nane] >= 'A') And (Stri [Nane] <= 'Z') Then
      Stri [Nane] := Chr ( Ord (Stri [Nane] ) + 32 )
    Else
      Stri [Nane] := Chr ( Ord (Stri [Nane] ) );
  DnCaseStr := Stri;
End;

Function Exist (FileString : String) : Boolean;
Var
  ExistHandle : File;
  Index       : Integer;
Begin
  {$I-}
  Assign (ExistHandle, FileString);
  Reset (ExistHandle);
  Index := IOResult;
  Exist := Index = 0;
  Close (ExistHandle);
  Index := IOResult
  {$I+}
End;

Procedure Cursor_Off;
Begin
  Asm
    Mov   AH, 1
    Mov   CH, 32
    Mov   CL, 0
    Int   $10
  End
End;

Procedure Cursor_On;
Begin
  Asm
    Mov   AH, 1
    Mov   CH, 6
    Mov   CL, 7
    Int   $10
  End
End;

Function Attr (f, s: Byte): Byte;
Begin
  Attr := f Or (s ShL 4);
End;

Procedure GETSTRING (Var L1 : String; LEN : Byte; Charput : Char; CA : Byte; DC : Char; Opt : Byte; Keep : Boolean);

Var EC, TC : Byte; XX, YY, ZZ, XXX  :  Byte; B1, B2 : Char;
  X, Y, Z : LongInt;
  
Procedure BEEP;
  Begin
    Sound (200); Delay (100); Sound (300); Delay (50); NoSound;
  End;

  Label OVERT;

  Procedure DOIT;
  Label OVERT2;
  Begin
    If XX >= LEN Then Goto OVERT2;
    If DC <> ' ' Then Write (DC) Else
      Write (B1);
    Inc (XX); L1 [XX] := B1; L1 [0] := Chr (XX);
    OVERT2:
  End;

Begin
  {$i-}
  Yy := WhereY;
  XXX := 0;
  Zz := TextAttr;
  Write (l1); Xx := WhereX;
  TextAttr := Ca;
  For X := Length (l1) To Len Do Write (CharPut);
  TextAttr := Zz;
  GotoXY (Xx, Yy);
  XX := Length (l1);
  Repeat
    B1 := ReadKey;
    Case B1 Of
      {      Chr (13)   :  WriteLn;}
      Chr (8)    :
                  Begin
                    If XX <= 0 Then Goto OVERT;
                    GotoXY (WhereX - 1, WhereY);
                    Zz := TextAttr;
                    TextAttr := Ca;
                    Write (CharPut);
                    TextAttr := Zz;
                    GotoXY (WhereX - 1, WhereY); L1 [XX] := ' ';
                    Dec (XX); L1 [0] := Chr (Ord (L1 [0] ) - 1); OVERT:
                  End;
    End;
    If Opt = 1 Then If (B1 = ' ') And (XX <> 0) Then DOIT;
    If Opt = 1 Then If B1 >= '"' Then DOIT;
    If Opt = 2 Then If (B1 >= '1') And (B1 <= '9') And (L1 [1] <> '0') Then DOIT;
    If Opt = 2 Then If (B1 = '0') And (L1 [1] <> '0') Then DOIT;
    If Opt = 3 Then If (B1 = ' ') And (XX <> 0) Then DOIT;
    If Opt = 3 Then If B1 = 'y' Then DOIT;
    If Opt = 3 Then If B1 = 'Y' Then DOIT;
    If Opt = 3 Then If B1 = 'n' Then DOIT;
    If Opt = 3 Then If B1 = 'N' Then DOIT;
  Until (B1 = Chr (13) );
End;

Function RdStr;
Var
  Loop1, Loop2,
  X, Y          : Integer;
  MainString    : String;
  Input, Prev   : Char;
Begin
  X := Length (MainString);
  Delete (MainString, 1, X);
  Cursor_On;
  For Loop1 := 1 To Size Do
  Begin
    X := WhereX;
    Y := WhereY;
    Input := ReadKey;
    If ( (Input = BackSpace) And (Loop1 <> 1) ) Then
    Begin
      GotoXY (X - 1, Y);
      Write (' ');
      GotoXY (X - 1, Y);
      Delete (MainString, Loop1, 1);
      Dec (Loop1, 2);
    End
    Else If ( (Input = BackSpace) And (Loop1 = 1) ) Then
    Begin
      Delete (MainString, Loop1, 1);
      Dec (Loop1);
    End
      Else If (Input = ReturnKey) Or (Input = ESCKey) Then
      Begin
        Break;
      End
        Else If (Input In [UpArrow, DownArrow, RightArrow, LeftArrow] ) And
                (Prev = #0)
        Then
        Begin
          Dec (Loop1);
        End
          Else
          Begin
            Insert (Input, MainString, Loop1);
            Write (MainString [Loop1] );
          End;
    Prev := Input
  End;
  Cursor_Off;
  If Loop1 <> Size Then
  Begin
    For Loop2 := Loop1 To Size Do
    Begin
      Insert (' ', MainString, Loop2);
    End;
  End;
  RdStr := MainString;
End;

Function FileExists;
Var F: File;
Begin
  {$I-}
  Assign (F, FileName);
  FileMode := 0;
  Reset (F);
  Close (F);
  {$I+}
  FileExists := (IOResult = 0) And (FileName <> '');
End;

Procedure InitCFG;
Var
  F: Text;
  tmp: String;
  S: Array [0..10] Of String;
  i: Byte;
Begin
  Assign (F, 'CONFIG.BBS');
  If FileExists ('Config.bbs') = False  Then Begin
    Rewrite (F);
    WriteLn (F, '');
    WriteLn (F, ' ' + SoftName+ ' Configuration File ');
    WriteLn (F, '');
    WriteLn (F, 'SysOp Name');
    WriteLn (F, 'Your Board Name');
    WriteLn (F, 'open');
    WriteLn (F, 'none');
    WriteLn (F, 'none');
    WriteLn (F, 'no');
    WriteLn (F, 'C:\fELONY\');
    WriteLn (F, 'C:\fELONY\TEXTFILE');
    WriteLn (F, 'C:\fELONY\DATA');
    WriteLn (F, 'C:\fELONY\MENUS');
    WriteLn (F, 'C:\fELONY\TEMP');
    WriteLn (F, 'Reserved');
    WriteLn (F, 'Reserved');
    WriteLn (F, 'Reserved');
    WriteLn (F, 'Reserved');
    WriteLn (F, 'Reserved');
    Close (F);
  End;
End;

Procedure ReadCFG;
Var
  F: Text;                    { bah  you know what this is }
  tmp: String;                 { temperary shit string }
  S: Array [0..26] Of String;  { can change as demands }
  i: Byte;
Begin
  Assign (F, 'CONFIG.BBS');
  If FileExists ('Config.bbs') = False  Then Begin
    Rewrite (F);
    WriteLn (F, '');
    WriteLn (F, ' ' + SoftName+ ' Configuration File ');
    WriteLn (F, '');
    WriteLn (F, 'SysOp Name');
    WriteLn (F, 'Your Board Name');
    WriteLn (F, 'open');
    WriteLn (F, 'none');
    WriteLn (F, 'none');
    WriteLn (F, 'no');
    WriteLn (F, 'C:\fELONY\');
    WriteLn (F, 'C:\fELONY\TEXTFILE');
    WriteLn (F, 'C:\fELONY\DATA');
    WriteLn (F, 'C:\fELONY\MENUS');
    WriteLn (F, 'C:\fELONY\TEMP');
    WriteLn (F, '1');
    WriteLn (F, 'ATS0=1|~~~');
    WriteLn (F, 'ATH0|~~~');
    WriteLn (F, 'AT|~~~');
    WriteLn (F, 'ATA|~~~');
    WriteLn (F, 'DungeOn Master');
    WriteLn (F, 'Secret');
    WriteLn (F, '800-555-1212');
    WriteLn (F, '800-555-1212');
    WriteLn (F, 'SysOp');
    Close (F);
  End;
  Reset (F);
  ReadLn (F, tmp);
  ReadLn (F, tmp);
  ReadLn (F, tmp);
  I := 0;
  While Not EoF (F) Do Begin
    ReadLn (F, S [I] );
    Inc (i);
  End;
  CFG. SysopName := S [0];
  CFG. BoardNAme := S [1];
  CFG. BoardType := S [2];
  CFG. NewPass := S [3];
  CFG. SysPass := S [4];
  CFG. MultiNode := S [5];
  CFG. MainDir := S [6];
  CFG. TextfileDi := s [7];
  CFG. DataDir := s [8];
  CFG. MenuDir := s [9];
  CFG. TempDir := s [10];
  Val (s [11], CFG. ComPort, W1);
  CFG. Init := s [12];
  CFG. OnHook := s [13];
  CFG. OffHook := s [14];
  CFG. Answer := s [15];
  USR. Handle := s [16];
  USR. Passwd := s [17];
  USR. Vphone := s [18];
  USR. Dphone := s [19];
  USR. Note := s [20];
  MTX. MTX1    := s [21];
  MTX. MTX2    := s [22];
  MTX. MTX3    := s [22];
  MTX. MTX4    := s [23];
  MTX. MTX5    := s [24];
  MTX. MTX6    := s [25];
  MTX. MTX7    := s [26];
  Close (F);
End;

Procedure WriteCFG;
Var
  F : Text;
Begin
  Assign (F, 'CONFIG.BBS');
  Rewrite (F);
  WriteLn (F, '');
  WriteLn (F, ' ' + SoftName+ ' Configuration File ');
  WriteLn (F, '');
  WriteLn (F, CFG. SysopName);
  WriteLn (F, CFG. BoardName);
  WriteLn (F, CFG. Boardtype);
  WriteLn (F, CFG. NewPass);
  WriteLn (F, CFG. SysPass);
  WriteLn (F, CFG. MultiNode);
  WriteLn (F, CFG. MainDIR);
  WriteLn (F, CFG. TextFileDI);
  WriteLn (F, CFG. DataDIR);
  WriteLn (F, CFG. MenuDIR);
  WriteLn (F, CFG. TempDir);
  WriteLn (F, CFG. ComPort);
  WriteLn (F, CFG. Init);
  WriteLn (F, CFG. OnHook);
  WriteLn (F, CFG. OffHook);
  WriteLn (F, CFG. Answer);
  WriteLn (F, USR. Handle);
  WriteLn (F, USR. Passwd);
  WriteLn (F, USR. VPhone);
  WriteLn (F, USR. DPhone);
  WriteLn (F, USR. Note);
  Writeln (F, MTX. MTX1);
  Writeln (F, MTX. MTX2);
  Writeln (F, MTX. MTX3);
  Writeln (F, MTX. MTX4);
  Writeln (F, MTX. MTX5);
  Writeln (F, MTX. MTX6);
  Writeln (F, MTX. MTX7);
  Close (F);
End;

{Procedure WriteCFG;
Var
  CFGHandle : File of FelCFG;
begin
    Assign(CFGHandle,'CONFIG.BBS');
    ReWrite(CFGHandle);
    Write(CFGHandle,CFG);
    Close(CFGHandle);
end;}

Procedure FelonyCredits;
Begin
  ClrScr;
  cursor_on;


End;

Procedure CheckFiles30;
Begin
  If (GetEnv ('FILES') <> '30') Then
  Begin
    ClrScr;
    GotoXY (1, 25);
    WriteLn ('You Need "FILES=30" In Your Config.sys File');
    WriteLn ('Error Code 4... Halting');
    Halt (4);
  End;
End;

Procedure Wait;
Var
  I : Word;
Begin
  For I := 1 To D Do
  Begin
    Delay (1);
    If KeyPressed Then I := D;
  End;
End;

Procedure CLS;
Var
  I: Byte;
Begin
  For I := 1 To 26 Do
  Begin
    WriteLn;
    Delay (20);
  End;
End;

Procedure FelColours (ColStr : String);
Var
  Lngth, Loop : Byte;
Begin
  ColStr := AllTrim (ColStr);
  Lngth := Length (ColStr);
  TextBackground (Black);
  TextColor (DarkGray);
  Write (ColStr [1] );
  TextColor (LightGray);
  Write (ColStr [2] + ColStr [3] );
  TextColor (White);
  For Loop := 4 To Lngth - 3 Do
  Begin
    Write (ColStr [Loop] );
  End;
  TextColor (LightGray);
  Write (ColStr [Lngth - 2] + ColStr [Lngth - 1] );
  TextColor (DarkGray);
  Write (ColStr [Lngth] );
  TextColor (White);
End;

Function LTrim (s: String; c: Char ): String; Assembler;
Asm
  PUSH   DS
  LDS    SI, s
  XOr    AX, AX
  LODSB
  XCHG   AX, CX
  LES    DI, @Result
  Inc    DI
  JCXZ   @@2
  
  MOV    BL, c
  CLD
  @@1:  LODSB
  CMP    AL, BL
  LOOPE  @@1
  Dec    SI
  Inc    CX
  REP    MOVSB

  @@2:  XCHG   AX, DI
  MOV    DI, Word Ptr @Result
  SUB    AX, DI
  Dec    AX
  STOSB
  POP    DS
End;

Function RTrim (S : String; C : Char) : String;
Begin
  While (Length (S) > 0) And (S [Length (S) ] = C) Do Dec (S [0] );
Begin
  RTrim := S;
End;
End;

Function AllTrim (Str : String) : String;
Begin
  If Length (Str) > 0 Then
  Begin
    AllTrim := LTrim (RTrim (Str, ' '), ' ')
  End
  Else
  Begin
    AllTrim := Str;
  End;
End;

Procedure DisplayAnsi (FileName : String);
Var
  AnsiChar : Char;
  FileEnt  : Text;
Begin
  If Exist (FileName) Then
  Begin
    Assign (FileEnt, FileName);
    Reset (FileEnt);
    While Not EoF (FileEnt) Do
    Begin
      Read (FileEnt, AnsiChar);
      WritePort (AnsiChar);
      {	    WriteStringAnsiNOCR(AnsiChar);}
    End;
    Close (FileEnt);
  End;
End;

Function StrToInt (cNum : String) : LongInt;
Var
  C : Integer;
  I : LongInt;
Begin
  Val (cNum, I, C);
  StrToInt := I;
End;

Function LowChar (CH : Char) : Char;
Begin
  If Ord (CH) In [65..90] Then CH := Chr (Ord (CH) + 32);
  LowChar := CH;
End;

Function StLowCase (S : String) : String;
Var
  i    : Integer;
Begin
  For i := 1 To Length (S) Do S [i] := LowChar (S [i] );
  StLowCase := S;
End;

Function SmartCase (S : String) : String;
Var
  i    : Integer;
Begin
  s := StLowCase (s);
  For i := 1 To Length (S) Do
  Begin
    If i = 1 Then S [1] := UpCase (S [1] )
    Else If S [i - 1] = ' ' Then S [i] := UpCase (S [i] )
    Else If (Ord (S [i - 1] ) In [32..64] ) And (S [i - 1] <> '''') Then
      S [i] := UpCase (S [i] );
  End;
  SmartCase := S;
End;

Function IntToStr (Input : LongInt) : String;
Var
  StrOut : String;
Begin
  Str (Input, StrOut);
  IntToStr := StrOut;
End;

Begin
End.
