{ In Procdures FADEIN & FADEOUT, the (X) is the delay between
  screen darkenings. }

 Unit FelFX;
 Interface

   Uses Crt;
   Const
     PelAddrRgR  = $3C7;
     PelAddrRgW  = $3C8; {.$3C8}
     PelDataReg  = $3C9;
     
   Type
     RGB = Record
             R,
             G,
             B : Byte;
           End;
     Color = Array [0..63] Of RGB;
     
   Var
     Col : Color;
     Count, Count2 : Byte;
     Pal1, Pal2 : Array [0..255, 0..2] Of Byte;
   Procedure GrabColors;
   Procedure ResetColors;
   Procedure GetCol (C : Byte; Var R, G, B : Byte);
   Procedure SetCol (C, R, G, B : Byte);
   Procedure SetInten (B : Byte);
   Procedure inittextmode;
   Procedure SetCharWidth (w: Word);
   Procedure GetPal ( Color : Byte ; Var Red, Green, Blue : Byte );
   Procedure SetPal (Color, Red, Green, Blue : Byte);
{   procedure Fadeout;}
{   Procedure Fadein;}
   Procedure FadeIn (X: Integer);
   Procedure FadeOut (X: Integer);
   Procedure Pal (ColorNo : Byte; R, G, B : Byte);
   Procedure retrace;
 Implementation

Procedure GrabColors;
Begin
  For Count := 0 To 255 Do
  Begin
    PORT [$03C7] := Count;
    Pal1 [Count, 0] := PORT [$03C9];
    Pal1 [Count, 1] := PORT [$03C9];
    Pal1 [Count, 2] := PORT [$03C9];
  End;
  Pal2 := Pal1;
End;

Procedure GetCol (C : Byte; Var R, G, B : Byte);
Begin
  Port [PelAddrRgR] := C;
  R := Port [PelDataReg];
  G := Port [PelDataReg];
  B := Port [PelDataReg];
End;

Procedure ResetColors;
Begin
  For Count := 0 To 255 Do
  Begin
    PORT [$03C8] := Count;
    PORT [$03C9] := Pal1 [Count, 0];
    PORT [$03C9] := Pal1 [Count, 1];
    PORT [$03C9] :=
    Pal1 [Count, 2];
  End;
End;

Procedure SetCol (C, R, G, B : Byte);
Begin
  Port [PelAddrRgW] := C;
  Port [PelDataReg] := R;
  Port [PelDataReg] := G;
  Port [PelDataReg] := B;
End;

Procedure SetInten (b : Byte);
 Var
   X : Integer;
   FR, FG, FB : Byte;
 Begin
   For X := 0 To 63 Do
   Begin
     FR := Col [X].R * B Div 63;
     FG := Col [X].G * B Div 63;
     FB := Col [X].B * B Div 63;
     SetCol (X, FR, FG, FB);
   End;
 End;

Procedure FadeIn (X: Integer);
 Var
   Y: Integer;           (* Y is the LCV *)
 Begin
   For Y := 0 To 63 Do
   Begin
     SetInten (Y);
     Delay (X);
   End;
 End;

Procedure GetPal ( Color : Byte ; Var Red, Green, Blue : Byte );
Begin
  Port [$3c7] := Color;    { This procedure readds the values of}
  Red   := Port [$3c9];    { Red, Green & Blue for a certain color}
  Green := Port [$3c9];    { from the [$3c9] port.}
  Blue  := Port [$3c9];
End;

Procedure retrace; Assembler;
Asm
  Mov  DX, 3DAh;
  @WAIT1: In   AL, DX;
  Test AL, 8;
  Jz   @WAIT1
  @RETR2: In   AL, DX;
  Test AL, 8;
  Jnz  @RETR2;
End;

Procedure SetPal (Color, Red, Green, Blue : Byte);
Begin
  Port [$3C8] := Color;    { sets the Red,Green & Blue }
  Port [$3C9] := Red;      { values of the color you specify }
  Port [$3C9] := Green;
  Port [$3C9] := Blue;
End;
{procedure Fadeout;
var Tmp : Array [1..3] of byte;    { This is temporary storage for the
x,y:longint;
begin                              { values of a color.
  for x:=1 to 64 do begin
    retrace;
    for y:=0 to 255 do begin              { Fading out basicly means
      Getpal (y,Tmp[1],Tmp[2],Tmp[3]);    { decreasing the R,G & B values
      If Tmp[1] > 0 then dec (Tmp[1]);    { of all the colors steadily
      If Tmp[2] > 0 then dec (Tmp[2]);    { until they are all zero.
      If Tmp[3] > 0 then dec (Tmp[3]);
      SetPal (y,Tmp[1],Tmp[2],Tmp[3]);
    end;
  end;
end;}
{procedure Fadein;                  { Pretty much the same as fadeout,    }
{var Tmp : Array [1..3] of byte;    { but here we increase the RGB values }
{x,y:longint;}
{Palette:Array[0..255,1..3] of byte;}
{begin                              { until they are what we want them to
  for x:=1 to 64 do begin          { be. they will be set to what is in
    retrace;                       { pal1, which is complicated, but you
    For y:=0 to 255 do begin       { aren't dumb!
      Getpal (y,Tmp[1],Tmp[2],Tmp[3]);
      If Tmp[1] < Palette[y,1] then inc (Tmp[1]);
      If Tmp[2] < Palette[y,2] then inc (Tmp[2]);
      If Tmp[3] < Palette[y,3] then inc (Tmp[3]);
      SetPal (y,Tmp[1],Tmp[2],Tmp[3]);
 {   end;}
{  end;}
{end;}

Procedure Pal (ColorNo : Byte; R, G, B : Byte); Assembler;
{This sets the Red, Green and Blue values of a certain color}
Asm mov  DX, 03C8h
  mov  AL, ColorNo
  out  DX, AL
  Inc  DX
  mov  AL, r
  out  DX, AL
  mov  AL, g
  out  DX, AL
  mov  AL, b
  out  DX, AL
End;


Procedure FadeOut (X: Integer);
 Var
   Y: Integer;    (* Y is the LCV *)
 Begin
   For Y := 0 To 63 Do
     GetCol (Y, Col [Y].R, Col [Y].G, Col [Y].B);
   For Y := 63 Downto 0 Do
   Begin
     SetInten (Y);
     Delay (X);
   End;
 End;

Const Size = 20; { number of text-lines}
Var pal3: Array [0..10 * Size-1] Of Byte;
  
Procedure inittextmode;
Assembler;
Asm
  mov AX, 03h
  Int 10h
End;
Const HorizParms: Array [0..1, 0..6] Of Word =
  ( ($6A00, $5901, $5A02, $8D03, $6004, $8505, $2D13),
  ($5F00, $4F01, $5002, $8203, $5504, $8105, $2813) );
Procedure SetCharWidth (w: Word); Assembler; Asm
  mov AX, $40; mov ES, AX;
  mov DX, ES: [$63];  {locate CRTC}
  mov AL, $11; out DX, AL; Inc DX; In AL, DX; Dec DX;
  mov AH, AL; mov AL, $11; push AX; And AH, $7F; out DX, AX; {no write protect}
  mov BX, w; sub BL, 8; neg BX; And BX, 14; lea SI, horizParms [BX];
  mov CX, 7
  @L: lodsw; out DX, AX; loop @L;
  pop AX; out DX, AX; {restore write protect}
  mov DX, $3C4;   {sequencer}
  cli
  mov AX, $100; out DX, AX;
  mov BX, 1; cmp Byte Ptr w, 8; je @S; mov BX, $800; @S:
  mov AH, BL; mov AL, 1; out DX, AX;
  mov AX, $300; out DX, AX;
  sti
  XOr DX, DX; mov AX, 720; Div w; mov ES: [$4A], AX;  {set bios cols}
End;

Var i: Word;
  
  { increase first value in the pal-array (the one representing red), and scroll
  that in the array }
  {procedure incbars;
  var x:word;
  begin
  if pal3[0]<63 then inc(pal3[0]);
  for x:=3*size-3 downto 0 do pal3[x+1]:=pal3[x];
  {    if pal[0]<50 then inc(pal[10]);
  for i:=3*size-3 downto 0 do pal[i+1]:=pal[i];}
  {end;}
  
  {procedure copperbars;
  var cc,l,j:word;
  begin
  asm cli end;
  while (port[$3da] and 8)<>0 do; { vertical retrace }
  { while (port[$3da] and 8)=0 do;
  cc:=0;
  for l:=0 to size-1 do begin
  port[$3c8]:=1; { set pal-idx number (1=blue) }
  {  port[$3c9]:=pal3[cc]; { set first two pal-value's (red and green }
  { port[$3c9]:=pal3[cc+1]; { intensities }
  { for j:=0 to 15 do begin { 16 vertical retraces = one text line }
  {    while (port[$3da] and 1)<>0 do;
  while (port[$3da] and 1)=0 do;
  end;
  port[$3c9]:=pal3[cc+2]; { set last pal-value (blue), and thus activate
  new palette }
  {    inc(cc,3);
  end;
  asm sti end;
  end;}
  
  {var x:byte;
  
  begin
  textmode(co80); { 25 lines mode }
  { fillchar(pal3,sizeof(pal3),5); { clear palette array }
  {copperbars; { default = black -> otherwise flash of blue will appear }
  {textcolor(1); { set text to blue (now black, 'cos pal changed) }
  {writeln;
  {  writeln('Is this what you mean?'); writeln;
  for i:=1 to 15 do writeln('Test line ',i);}
  {  repeat
  incbars;
  copperbars;
  until keypressed; { do stuff until keypressed... }
  {  textmode(lastmode); { back to last mode }
  End.