{$X+,O+,F+}
(*		Fossil Routines for fELONY.
                Modified by : Cameron Booth.
                Modified    : 12/08/95

*)

Unit FELFoss;

Interface

Uses DOS;

Const
  Com0 = 0;  {Sets it to local mode}
  Com1 = 1;
  Com2 = 2;
  Com3 = 3;
  Com4 = 4;
  Local : Boolean = False;
  Colors: Boolean = True;
  link  : boolean = true;

Procedure DoHalt;
Procedure WriteLF;
Procedure SetPort (Port : Byte);
Procedure SetBaudRate (A : LongInt);
Procedure TransmitChar (A : Char);
Function TxCharNoWait (A : Char) : Boolean;
Function ReceiveChar : Char;
Function SerialStatus : Word;
Function KeyPressedPort : Boolean;
Function OutBufferFull : Boolean;
Function OutBufferEmpty : Boolean;
Function OpenFossil : Boolean;
Procedure CloseFossil;
Procedure SetDTR (A : Boolean);
Procedure FlushOutput;
Procedure PurgeOutput;
Procedure PurgeInput;
Function CarrierDetect : Boolean;
Function SerialInput : Boolean;
Procedure WriteChar (C : Char);
Procedure FlowControl (A : Byte);
Procedure WritePort (S : String);
Procedure WriteLnPort (S : String);
Function ReadKeyPort : Char;
Procedure ReadPort (Var C : Char);
Procedure FReadLn (Var S : String);
Procedure HangUp;
Procedure SetCursor (X, Y : Byte);
Procedure GetCursor (Var X, Y : Byte);
Procedure FWrite (S : String);
Procedure FWriteLn (S : String);
Procedure FWriteCom (S : String);
Procedure FWriteLnCom (S : String);
Procedure TextAtt (Color, Back : Byte);
Procedure FClrScr;
Procedure FGotoXY (X, Y: Integer);
Procedure CR;
Function YesNo: Boolean;

Var
  Reg : Registers;
  
Implementation

Uses Crt, AnsiDrv, GlobFEL;

Var
  Status     : Word;
  Bt         : Byte;
  ComPortNum : Integer;
  
Procedure DoHalt;
Begin
  (* You can recalc the users time, and write it to the user file. And
  add anything here that needs cleaning up when the user logs off.
  *)
  CloseFossil;
  Halt (1);
End;

Procedure CR;
Begin
  WritePort (#13#10);
End;

Procedure FGotoXY (X, Y: Integer);

Begin
  GotoXY (X, Y);
  If Not Local Then
  Begin
    FWriteCOM (#27 + '[' + I2S (Y) + ';' + I2S (X) + 'f');
  End;
End;

Procedure FClrScr;
Begin
  ClrScr;
  If Not Local Then
  Begin
    FWriteCOM (#27 + '[2J');
    FGotoXY (1, 1);
  End;
End;

Procedure TextAtt (Color, Back : Byte);
Var ES    : String [10];
  ES2   : String [10];
Begin
  Case Color Of
    0      : ES := '0;30';
    1      : ES := '0;34';
    2      : ES := '0;32';
    3      : ES := '0;36';
    4      : ES := '0;31';
    5      : ES := '0;35';
    6      : ES := '0;33';
    7      : ES := '0;37';
    8      : ES := '1;30';
    9      : ES := '1;34';
    10     : ES := '1;32';
    11     : ES := '1;36';
    12     : ES := '1;31';
    13     : ES := '1;35';
    14     : ES := '1;33';
    15     : ES := '1;37';
  End;
  Case Back Of
    0      : ES2 := '40m';
    1      : ES2 := '44m';
    2      : ES2 := '42m';
    3      : ES2 := '46m';
    4      : ES2 := '41m';
    5      : ES2 := '45m';
    6      : ES2 := '43m';
    7      : ES2 := '47m';
  End;
  If Colors Then
  Begin
    FWriteCom ('[' + ES + ';' + ES2);
    TextColor (Color); TextBackground (Back);
  End;
End;

Procedure SetPort (Port : Byte);
Begin
  ComPortNum := Port - 1;
End;

Function BitOn (Position, TestByte : Byte) : Boolean;
Begin
  Bt := $01;
  Bt := Bt ShL Position;
  BitOn := (Bt And TestByte) > 0;
End;

Procedure SetBaudRate (A : LongInt);
Begin
  If ComPortNum < 0 Then Exit;
  With Reg Do
  Begin
    AH := 0;
    DX := ComPortNum;
    AL := $63;
    If A = 38400 Then
    Begin
      AL := $23;
    End
    Else
    Begin
      Case A Of
        300   : AL := $43;
        600   : AL := $63;
        1200  : AL := $83;
        2400  : AL := $A3;
        4800  : AL := $C3;
        9600  : AL := $E3;
        19200 : AL := $03;
      End;
    End;
    Intr ($14, Reg);
  End;
End;

Procedure TransmitChar (A : Char);
Begin
  If ComPortNum < 0 Then Exit;
  Reg. AH := 1;
  Reg. DX := ComPortNum;
  Reg. AL := Ord (A);
  Intr ($14, Reg);
End;

Procedure FWrite (S : String);
Var X : Byte;
Begin
  {    if (not Local) And (not CarrierDetect) then DoHalt;}
  For X := 1 To Length (S) Do
  Begin
    If Not Local Then transmitchar (S [X] );
    Write (S [X] );
  End;
End;

Procedure FWriteCom (S : String);
Var X : Byte;
Begin
  If (Not Local) And (Not CarrierDetect) Then DoHalt;
  If Not Local Then
    For X := 1 To Length (S) Do
      TransmitChar (S [X] );
End;

Procedure FWriteLnCom (S : String);
Var X : Byte;
Begin
  If Not Local Then FWriteCom (S);
  If Not Local Then TransmitChar (#13);
  If Not Local Then TransmitChar (#10);
End;

Procedure FWriteLn (S : String);
Var X : Byte;
Begin
  FWrite (S);
  WriteLn;
  transmitchar (#13);
  transmitchar (#10);
End;

Procedure WriteLF;
Begin
  WriteLn;
  TransmitChar (#13);
  TransmitChar (#10);
End;

Function TxCharNoWait (A : Char) : Boolean;
Begin
  If ComPortNum < 0 Then Exit;
  Reg. AH := $0B;
  Reg. DX := ComPortNum;
  Intr ($14, Reg);
  TxCharNoWait := (Reg. AX = 1);
End;

Function ReceiveChar : Char;
Var
  CH : Char;
Begin
  CH := #0;
  If ComPortNum < 0 Then CH := ReadKey Else
  Begin
    Reg. AH := 2;
    Reg. DX := ComPortNum;
    Intr ($14, Reg);
    CH := Chr (Reg. AL);
  End;
  ReceiveChar := CH;
End;

Function SerialStatus : Word;
Begin
  Reg. AH := 3;
  Reg. DX := ComPortNum;
  Intr ($14, Reg);
  SerialStatus := Reg. AX;
End;

Function KeyPressedPort : Boolean;
Var
  Status   : Word;
  NextByte : Byte;
Begin
  If ComPortNum < 0 Then KeyPressedPort := KeyPressed Else
  Begin
    Status := SerialStatus;
    NextByte := Hi (Status);
    KeyPressedPort := BitOn (0, NextByte);
  End;
End;

Function OutBufferFull : Boolean;
Begin
  If ComPortNum < 0 Then OutBufferFull := False Else
  Begin
    Status := SerialStatus;
    Bt := Hi (Status);
    OutBufferFull := (BitOn (5, Bt) = False);
  End;
End;

Function OutBufferEmpty : Boolean;
Begin
  If ComPortNum < 0 Then OutBufferEmpty := True Else
  Begin
    Status := SerialStatus;
    Bt := Hi (Status);
    OutBufferEmpty := BitOn (6, bt);
  End;
End;

Function OpenFossil : Boolean;
Begin
  If ComPortNum < 0 Then OpenFossil := True Else
  Begin
    Reg. AH := 4;
    Reg. DX := ComPortNum;
    Intr ($14, Reg);
    OpenFossil := Reg. AX = $1954;
  End;
End;

Procedure CloseFossil;
Begin
  If ComPortNum < 0 Then Exit;
  Reg. AH := 5;
  Reg. DX := ComPortNum;
  Intr ($14, Reg);
End;

Procedure SetDTR;
Begin
  If ComPortNum < 0 Then Exit;
  Reg. AH := 6;
  Reg. DX := ComPortNum;
  Reg. AL := Byte (A);
  Intr ($14, Reg);
End;

Procedure FlushOutput;
Begin
  If ComPortNum < 0 Then Exit;
  Reg. AH := 8;
  Reg. DX := ComPortNum;
  Intr ($14, Reg);
End;

Procedure PurgeOutput;
Begin
  If ComPortNum < 0 Then Exit;
  Reg. AH := 9;
  Reg. DX := ComPortNum;
  Intr ($14, Reg);
End;

Procedure PurgeInput;
Begin
  If ComPortNum < 0 Then Exit;
  Reg. AH := $0A;
  Reg. DX := ComPortNum;
  Intr ($14, Reg);
End;

Function CarrierDetect : Boolean;
Begin
  If ComPortNum < 0 Then CarrierDetect := True Else
  Begin
    Reg. AH := 3;
    Reg. DX := ComPortNum;
    Intr ($14, Reg);
    CarrierDetect := (Reg. AL And $80) > 0;
  End;
  If Local Then CarrierDetect := True;
  If link  then carrierdetect := True;
End;

Function SerialInput;
Begin
  If ComPortNum < 0 Then SerialInput := True Else
  Begin
    Reg. AH := 3;
    Reg. DX := ComPortNum;
    Intr ($14, Reg);
    SerialInput := (Reg. AH And 1) > 0;
  End;
End;

Procedure WriteChar (C : Char);
Begin
  If ComPortNum < 0 Then WriteCharAnsi (C) Else
  Begin
    Reg. AH := $13;
    Reg. AL := Ord (c);
    Intr ($14, Reg);
  End;
End;

Procedure FlowControl;
Begin
  If ComPortNum < 0 Then Exit;
  Reg. AH := $0F;
  Reg. DX := ComPortNum;
  Reg. AL := A;
  Intr ($14, Reg);
End;

Procedure WritePort (S : String);
Var
  Index : Integer;
Begin
  If Not CarrierDetect Then DoHalt;
  For Index := 1 To Length (S) Do
  Begin
    If (ComPortNum >= 0) Then TransmitChar (S [Index] );
    WriteCharAnsi (S [Index] );
  End;
End;

Procedure WriteLnPort (S : String);
Begin
  Insert (#10#13, S, Length (S) + 1);
  WritePort (S);
End;

Function ReadKeyPort : Char;
Var
  CH : Char;
Begin
  Repeat
    If Not CarrierDetect Then DoHalt;
    If local Then CH := ReadKey
    Else If KeyPressedPort Then CH := ReceiveChar
    Else If KeyPressed Then CH := ReadKey
    Else CH := #0;
  Until (CH > #0) Or (CarrierDetect = False);
  ReadKeyPort := CH;
End;

Procedure ReadPort (Var C : Char);
Type
  C_Type = Char;
Var
  CPtr  : ^C_Type;
  CH    : Char;
  Count : LongInt;
  Ext   : Boolean;
Begin
  CPtr := @C;
  Count := 0;
  Repeat
    If Not CarrierDetect Then DoHalt;
    If ComPortNum < 0 Then CH := ReadKey
    Else If KeyPressedPort Then CH := ReceiveChar
    Else If KeyPressed Then CH := ReadKey Else
      CH := #0;
    If CH = #0 Then Inc (Count) Else
    Begin
      If (ComPortNum >= 0) Then TransmitChar (CH);
      WriteCharAnsi (CH);
    End;
  Until (CH > #0) Or (Not CarrierDetect);
  CPtr^ := CH;
End;

Procedure FReadLn (Var S : String);
Type
  LineString = String;
Var
  SPtr : ^linestring;
  St   : String;
  CH   : Char;
Begin
  SPtr := @S;
  St := '';
  Repeat
    CH := ReadKeyPort;
    If Not CarrierDetect Then DoHalt;
    If CH In [#32..#255] Then
    Begin
      St := St + CH;
      WritePort (CH);
    End
    Else If (CH = #8) And (St > '') Then
    Begin
      Delete (st, Length (St), 1);
      Writeport (#8 + #32 + #8);
    End;
  Until CH In [#13, #0];
  WriteLnPort ('');
  SPtr^ := St;
End;

Procedure HangUp;
Var
  TimeUsed : LongInt;
Begin
  (* Do whatever you did in  DoHalt here, as well. *)
  If ComPortNum < 0 Then Exit;
  Repeat
    SetDTR (False);
    Delay (1700);
    SetDTR (True);
  Until Not CarrierDetect;
End;

Procedure SetCursor (X, Y : Byte);
Var
  X1, Y1 : String;
Begin
  If CarrierDetect Then
  Begin
    Str (X, X1);
    Str (Y, Y1);
    WritePort (#27 + '[' + Y1 + ';' + X1 + 'H');
  End;
End;

Procedure GetCursor (Var X, Y : Byte);
Var
  X1, Y1 : Byte;
Begin
  If CarrierDetect Then
    Asm
      mov AH, 12h
      Int 14h
      mov X1, DL
      mov Y1, DH
    End;
  X := X1 + 1;
  Y := Y1 + 1;
End;

Function YesNo: Boolean;
Var CH: Char;
Begin
  Repeat;
    If KeyPressedPort Then
    Begin
      CH := ReadKeyPort;
      CH := UpCase (CH);
    End;
  Until CH In ['Y', 'N'];
  If CH = 'Y' Then YesNo := True; If CH = 'N' Then YesNo := False;
End;

End.
