(*                      Eternity Bulletin Board System
**         Copyright 1994-1996 by Isaac Oates.  All rights reserved.
**
**                      Data Types and Files Structures
*)

const
  version='2.20';

  maxmbases=65000;      { 0 - x }
  maxfbases=65000;      { 1 - x }
  maxprotocols=255;     { 1 - x }
  maxevents=32;         { 1 - x }
  maxarcs=8;            { 1 - x }
  maxvotequestions=20;  { 1 - x }
  maxvoteanswers=25;    { 1 - x }
  maxmenucmds=100;      { 1 - x }
  maxmenusets=255;      { 1 - x }
  maxstatsets=255;      { 1 - x }
  maxfilesperbase=2000; { 1 - x }
  maxmsglines=400;      { 1 - x }
  
  maxrepeatsize=4096;   { maximum size of MID files (repeat ansi) }
  maxcompsize=512;      { max number of bases for compression tables }
  daynumstart=1980;     { starting date of numerical dates: Jan 01 1980 }

  months:array[1..12] of string[3]=('Jan','Feb','Mar','Apr','May','Jun',
                                    'Jul','Aug','Sep','Oct','Nov','Dec');
  dowks:array[0..6] of string[3]=('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
type
  acstring    =string[20];            { access condition string }
  arflags     ='A'..'Z';              { AR flags }
  clrs        =array[0..9,false..true] of byte; { definable colors }
  packdatetime=array[1..6] of byte;   { packed date/time }
  secrangebyte=array[0..255] of byte; { security range of bytes }
  secrangeword=array[0..255] of word; { security range of words }
  fidoaddress =record zone,net,node,point:word; end; { fido-style address }
 
{----------------------------------------------------------------------------}  
  
  acflags =                           { restrictions and privileges }
  (
    rlogon,                           { L - can only logon ONCE per day }
    rchat,                            { C - can't page SysOp }
    runval,                           { U - posts marked unvalidated }
    rpanon,                           { A - can't post anonymous }
    rvote,                            { V - can't vote }
    rmsgdel,                          { M - forced mail deletion }
    rppriv,                           { R - can't post private }
    rppub,                            { P - can't post public }
    rpnet,                            { N - can't post netmail }
    rpecho,                           { E - can't post echomail }
    pnopostratio,                     { 1 - no post/call ratio }
    pnodlratio,                       { 2 - no UL/DL ratio }
    pnopointcheck,                    { 3 - no file point check }
    pnodeletion,                      { 4 - protection from deletion }
    pemergencypage                    { 5 - can page outside of hours }
  );

  userrec=                            { USER.LST - user account records }
  record
    name:string[35];                  { user name }
    fill1:byte;                       { -- RESERVED -- }
    realname:string[35];              { real name }
    fill2:byte;                       { -- RESERVED -- }
    street:string[30];                { street address }
    city:string[30];                  { city/state }
    zipcode:string[10];               { zip code }
    ph:array[1..3] of string[15];     { phone numbers }
    bday:string[8];                   { date of birth }
    sex:char;                         { sex - (M)ale or (F)emale }

    pw:string[20];                    { password }
    firston:string[8];                { date of first logon }
    laston:string[8];                 { date of last logon }

    userdefstr:array[1..3] of string[30]; { sysop defined strings }
    sysopnote:string[40];             { sysop's note on user }
    note:string[30];                  { public user note }

    lockfile:string[8];               { lockout file to print }
    cols:clrs;                        { user-defined colors }
    linelen:byte;                     { line length (# of cols) }
    pagelen:byte;                     { page length (# of rows) }
    mpointer:longint;                 { pointer to entry in MACRO.LST }
    startmenu:string[8];              { menu to start user out on }
    alert:boolean;                    { make noise when user logs on }
    smw:boolean;                      { short messages waiting }
    fill3:array[1..2] of byte;        { -- RESERVED -- }

    { system access information / logging options }

    sl:byte;                          { security level }
    dsl:byte;                         { download security level }
    ac:set of acflags;                { user restrictions/privileges }
    ar:set of arflags;                { AR flags }
    lockedout:boolean;                { whether user is locked out }
    deleted:boolean;                  { whether user is deleted }

    trapactivity:boolean;             { trap user activity }
    trapseparate:boolean;             { trap user activity to separate file }
    chatauto:boolean;                 { trap chat automatically }
    chatseparate:boolean;             { trap chat to separate file }
    slogseparate:boolean;             { output sysop log to separate file }

    cprofile:string[8];               { current profile }
    eprofile:string[8];               { profile to expire to }
    expdate:string[8];                { expiration date, 00/00/00 for none }
    
    { user preferences }

    emulation:byte;                   { emulation: 0=TTY 1=ANSI 2=AVATAR }
    color:boolean;                    { user has color monitor }
    pause:boolean;                    { user wants screen pauses }
    onekey:boolean;                   { onekey input mode }
    msgcls:boolean;                   { clear screen before showing msgs }
    fse:boolean;                      { use full screen editor }
    lightbars:boolean;                { enable lightbars }
    novice:boolean;                   { whether to show menus }
    
    { message system information }

    lastmbase:word;                   { last message base user was in }
    pubpost:word;                     { number of public posts }
    privpost:word;                    { number of private posts }
    netpost:word;                     { number of netmail posts }
    credit:longint;                   { netmail credit in cents }

    { file system information }

    lastfbase:word;                   { last file base user was in }
    uploads:integer;                  { number of files uploaded }
    downloads:integer;                { number of files downloaded }
    uk:longint;                       { number of kilobytes uploaded }
    dk:longint;                       { number of kilobytes downloaded }
    filepoints:longint;               { number of file points }

    { system usage information }
  
    ttime:longint;                    { total time spent online }
    tcalls:word;                      { total number of calls }
    tltoday:integer;                  { time left today }
    ontoday:byte;                     { number of calls today }
    illegal:byte;                     { number of illegal logon attempts }

    { miscellaneous information }

    votedata:array[1..maxvotequestions] of byte; { voting information }
    timebank:word;                    { number of minutes in time bank }
    timebankadd:word;                 { minutes added to time bank today }
    
    lastfilescan:string[8];           { last file scan }
    dltoday:word;                     { # files downloaded today }
    dlktoday:longint;                 { # k downloaded today }

    menuset:word;                     { last menu set }
    statset:word;                     { last stat set }

    reserved:array[1..81] of byte;    { -- RESERVED -- }
  end;

  namerec=                            { NAMES.LST - sorted user index }
  record
    name:string[36];                  { user name }
    number:word;                      { user number }
  end;
  
  macrorec=                           { MACRO.LST - user macro records }
  record
    macro:array[1..4] of string[255]; { user macros }
  end;

{----------------------------------------------------------------------------}

  mbaseflags=                         { message base flags }
  (
    mbrealname,                         { use real names }
    mbfilter,                           { filter ansi/8-bit ascii }
    mbnetquote,                         { use network quote strings }
    mbaddtear,                          { add tear/origin lines }
    mbinternet,                         { internet handling }
    mbsendusernote,                     { send @USERNOTE: kludge }
    mboutbound                          { outbound mail waiting }
  );
  
  mbaserec=                           { MBASES.DAT - message base data }
  record
    name:string[40];                  { description }
    filename:string[8];               { filename }
    acs:acstring;                     { ACS to see base }
    postacs:acstring;                 { ACS to post message }
    sysopacs:acstring;                { ACS to perform maintainance }
    password:string[20];              { password to enter area }
    path:string[60];                  { path for *.MSG files }
    mbtype:byte;                      { message base type }
    posttype:byte;                    { post type }
    origin:string[60];                { origin line }
    permindx:longint;                 { permanent index # }
    aka:byte;                         { fidonet address }
    maxmsgs:word;                     { max number of messages }
    flags:set of mbaseflags;          { message base flags }
    anon:byte;                        { anon: 0=no, 1=yes, 2=forced, 3=any }
    hwm:word;                         { hi-water mark for echomail }
    res:array[1..8] of byte;          { -- RESERVED -- }
  end;

  fidoattrib=                         { *.MBI - fidonet msg attributes }
  (
    private,                          { private }
    crash,                            { crash mail }
    received,                         { received }
    sent,                             { sent }
    fattach,                          { file attach }
    intransit,                        { in transit }
    orphan,                           { orphan }
    kill,                             { kill after sent }
    local,                            { originated locally }
    hold,                             { hold for pickup }
    unused,                           { ** UNUSED ** }
    freq,                             { file request }
    rreq,                             { receipt request }
    receipt,                          { receipt message }
    areq,                             { audit request }
    fureq                             { file update request }
  );

  fidoxattrib=                        { *.MBI - extended fidonet attribs }
  (
    direct,                           { direct to recipient }
    immediate,                        { immediate delivery }
    delsent                           { delete msg after being sent }
  );
  
  msgindexstat=                       { *.MBI - status flags }
  (
    mdeleted,                         { message is deleted }
    munvalidated,                     { message is unvalidated }
    mpermanent                        { message is permanent }
  );

  msgindexrec=                        { *.MBI - message index }
  record
    msgptr:longint;                   { pointer to message header }
    msgdate:packdatetime;             { message date/time }
    destuser:word;                    { dest user # if private + local base }
    attr:set of fidoattrib;           { FidoNet message attributes }
    xattr:set of fidoxattrib;         { extended FidoNet message attributes }
    flags:set of msgindexstat;        { status flags }
  end;

  fromtoinfo=                         { *.MB - message from/to info }
  record
    anon:byte;                        { anon: 0=no, 1/2=yes, 3=any name }
    usernum:word;                     { user number (0=none) }
    address:fidoaddress;              { fidonet address }
    name:string[35];                  { name if anon=3, otherwise null }
    real:string[35];                  { user's real name (all caps) }
    alias:string[35];                 { user's alias (all caps) }
    note:string[30];                  { user's public note (''=none) }
  end;
  
  mheaderrec=                         { *.MB - message header information }
  record
    txtptr:longint;                   { pointer to message text }
    txtlen:word;                      { length of message text }
    cost:word;                        { cost to send message (netmail) }
    sender:fromtoinfo;                { sender information }
    receiver:fromtoinfo;              { receiver information }
    title:string[71];                 { title of message }
    datetime:string[19];              { original msg date (Net/Echo) }
    msgdowk:byte;                     { message day of week (0=Sun..6=Sat) }
  end;
  
  mscanrec=                           { *.MBP - message newscan pointers }
  record
    scan:boolean;                     { whether to scan this message base }
    himsg:packdatetime;               { date of most recent message read }
  end;
  
{----------------------------------------------------------------------------}  

  fbaseflags=                         { file base flags }
  (
    fbnoratio,                        { no ratio/file point checking }
    fbcdrom,                          { files are on CD-ROM drive }
    fbusegifspecs,                    { use GIF specs }
    fbnosort                          { do not sort this entry }
  );
  
  fbaserec=                           { FBASES.DAT - file base data }
  record
    name:string[40];                  { description }
    filename:string[12];              { filename }
    path:string[60];                  { path in which files are stored }
    acs:acstring;                     { ACS for this area }
    ulacs:acstring;                   { ACS to upload to this area }
    dlacs:acstring;                   { ACS to download in this area }
    listacs:acstring;                 { ACS to list in this area }
    password:string[20];              { password to access this area }
    maxfiles:word;                    { maximum number of files in this dir }
    arctype:string[3];                { main archive type (''=UNUSED) }
    comtype:byte;                     { comment file to use 0=UNUSED }
    flags:set of fbaseflags;          { file base flags }
    res:array[1..10] of byte;         { -- RESERVED -- }
  end;
  
  fbflags=                            { file directory information }
  (
    funvalidated,                     { file is unvalidated }
    foffline,                         { file is offline }
    fpermanent,                       { file is permanent }
    fwithdrawn                        { credit has been withdrawn }
  );

  fbrec=                              { *.FB - file directory information }
  record
    filename:string[12];              { filename }
    description:string[45];           { description of file }
    date:string[8];                   { file date }
    daten:word;                       { numeric date (days since 01/01/90) }
    filepoints:word;                  { file points }
    size:word;                        { size of file in kilobytes }
    downloaded:word;                  { number of times downloaded }
    lastdownloaded:word;              { last date downloaded }
    ownernum:word;                    { owner's user # }
    ownername:string[36];             { owner's user name }
    epointer:longint;                 { extended description pointer }
    elength:word;                     { extended description length, 0=none }
    flags:set of fbflags;             { status flags }
    res:array[1..4] of byte;          { -- RESERVED -- }
  end;
  
  extendedrec=                        { *.FBE - extended file descriptions }
  record
    desc:string[45];                  { one line of extended description }
  end;
  
  fscanrec=                           { *.FBS - file base scan options }
  record
    scan:boolean;                     { whether to scan this directory }
  end;

  findexrec=                          { *.FBI - sorted file index }
  record
    filename:string[12];              { filename of file }
  end;
  
  protflags=
  (
    pactive,                          { whether protocol is active }
    pbatch,                           { whether protocol is batch }
    pbidir                            { whether protocol is bidirectional }
  );

  protrec=
  record
    flags:set of protflags;           { protocol flags }
    keys:string[14];                  { command keys }
    desc:string[40];                  { description }
    acs:acstring;                     { access string }
    templog:string[25];               { temp. log file }
    ulog:string[25];                  { permanent upload log }
    dlog:string[25];                  { permanent download log }
    ulcmd:string[78];                 { UL commandline }
    dlcmd:string[78];                 { DL commandline }
    ulcode:array[1..5] of string[5];  { code(s) for successful UL }
    dlcode:array[1..5] of string[5];  { code(s) for successful DL }
    envcmd:string[60];                { environment setup command }
    dlflist:string[25];               { download file list }
    logpf:byte;                       { position in log for filename }
    logps:byte;                       { position in log for status info }
    res:array[1..10] of byte;         { -- RESERVED -- }
  end;

{----------------------------------------------------------------------------}

  multiflags=
  (
    mavail,                           { whether user is current available }
    mhangup,                          { whether to hang up on node }
    mquit,                            { whether to have node quit }
    minivisible,                      { whether node is invisible }
    mpage                             { whether user has page waiting }
  );

  multirec=                           { WHO'S_ON.DAT - multinode stat file }
  record
    usernum:word;                     { user's number }
    username:string[35];              { user's name }
    location:string[30];              { user's location }
    usernote:string[30];              { user's public note }
    activity:byte;                    { user's current activity }
    description:string[30];           { user's activity description }
    flags:set of multiflags;          { node flags }
  end;

  pagerec=                            { PAGE.DAT - multinode paging file }
  record
    sender:word;                      { sending node }
    receiver:word;                    { receiving node }
    msgtext:string[251];              { text of page }
  end;

{----------------------------------------------------------------------------}

  menuflags=                          { menu status flags }
  (
    clrscrbefore,                     { C: clear screen before menu display }
    forcepause,                       { P: force a pause before menu? }
    dontcenter,                       { D: don't center the menu titles! }
    fullinput,                        { F: force full line input? }
    nomenuprompt,                     { N: no menu prompt whatsoever? }
    noansiprompt,                     { A: no prompt if user has ansi }
    forcehotkeys,                     { H: force hotkey input }
    dontshowglob                      { G: don't show global cmds }
  );

  menurec=                            { *.MNU - menu records (text) }
  record
    title:array[1..3] of string[100]; { generic menu title }
    menufile:string[12];              { replacement for short generic menu }
    helpfile:string[12];              { replacement for long generic menu }
    prompt:string[160];               { menu prompt }
    acs:acstring;                     { access requirement for this menu }
    password:string[20];              { password for this menu }
    fallback:string[8];               { fallback menu, usually MAIN }
    helplevel:byte;                   { forced help level }
      { 0=none, 1=no menu, 2=short menu, 3=long menu }
    columns:byte;                     { # of columns on generic menus }
    format:string[35];                { generic format: %K=key, %D=desc }
    flags:set of menuflags;           { menu flags }
  end;
 
  cmdflags=
  (
    hidden,                           { H: is command always hidden? }
    visible                           { V: is command always visible? }
  );

  commandrec=                         { *.MNU - command records }
  record
    ldesc:string[70];                 { long command description }
    sdesc:string[35];                 { short command description }
    ckeys:string[15];                 { command-execution keys }
    acs:acstring;                     { access requirements }
    cmdkeys:string[2];                { command keys: type of command }
    options:string[160];              { optional command data }
    commandflags:set of cmdflags;     { command status variables }
  end;

{----------------------------------------------------------------------------}  
  
  databaserec=                        { DATABASE.DAT - database format record }
  record
    name:string[40];                  { name of database area }
    filename:string[8];               { filename of database }
    repeatname:string[4];             { base filename of repeat area }
    anon:byte;                        { anonymous: 0=Off 1=Optional 2=Forced }
    dupemsg:string[127];              { "it's already in there" }
    saveprompt:string[127];           { "save this entry?" }
    res:array[1..10] of byte;         { reserved space }
    field:array[1..9] of record
      desc:string[30];                { description of this field }
      prompt:string[127];             { prompt when adding field }
      mandatory:boolean;              { if field is required to save record }
      format:byte;                    { format }
      maxlen:byte;                    { max length if string }
      dupe:boolean;                   { dupe checking }
      requiredmsg:string[127];        { "this is a required field" }
      invalidmsg:string[127];         { "invalid format" }
      res:array[1..10] of byte;       { reserved }
    end;
  end;

  dbrec=                              { *.DB - database entry }
  record
    field:array[1..9] of string[80];  { database fields }
    anon:boolean;                     { whether this entry is anonymous }
    res:array[1..294] of byte;        { -- RESERVED -- }
  end;

{----------------------------------------------------------------------------}  

  nuvrec=                             { NUV.DAT - main new user voting info }
  record
    name:string[35];                  { name of user being voted on }
    number:word;                      { number of user being voted on }
    note:string[30];                  { user's public note }
    yesvotes:word;                    { number of yes votes }
    novotes:word;                     { number of no votes }
    abstains:word;                    { number of abstaining people }
    fn:string[8];                     { filename for extended info (*.NUV) }
    res:array[1..44] of byte;         { -- RESERVED -- }
  end;

  nuvdatarec=
  record
    name:string[35];                  { name of voting user }
    which:char;                       { their vote (Y/N/A) }
    comment:string[78];               { user's comment ('' for none) }
    res:array[1..12] of byte;         { -- RESERVED -- }
  end;

{----------------------------------------------------------------------------}
  
  archiverec=                         { ETERNITY.DAT - archive configuration }
  record
    active:boolean;                   { whether entry is active }
    ext:string[3];                    { archive extension }
    addcmd:string[40];                { cmdline to add files }
    extractcmd:string[40];            { cmdline to extract files }
    listcmd:string[40];               { cmdline to list files }
    delcmd:string[40];                { cmdline to delete files }
    testcmd:string[40];               { cmdline to test archive }
    commentcmd:string[40];            { cmdline to comment archive }
    prefix:string[3];                 { list prefix (usually '@') }
    errlvl:integer;                   { errorlevel for success, -1=ignore }
    res:array[1..10] of byte;         { -- RESERVED -- }
  end;
  
  securityrec=                        { SECURITY.DAT - security profiles }
  record
    sl:byte;                          { level to which this applies }
    desc:string[40];                  { description of this security level }
    time:word;                        { time limit per day, 0=unlimited }
    calls:word;                       { number of calls allowed per day, 0=.. }
    fileratio:word;                   { # files user can DL per 1 UL, 0=NR }
    kiloratio:word;                   { # K user can DL per 1 UL, 0=No Ratio }
    postratio:word;                   { number of calls per 1 post, 0=exempt }
    maxbatch:word;                    { max # of files to DL at one time, 0=exmpt }
    maxdl:word;                       { max # of files to DL per day }
    maxdlk:word;                      { max # of K allowed per day }
    res:array[1..6] of byte;          { -- RESERVED -- }
  end;
  
  validaterec=                        { VALIDATE.DAT - validation profiles }
  record
    name:string[40];                  { name of this profile }
    id:string[8];                     { 8-char permanent ID }
    sl:byte;                          { security level }
    dsl:byte;                         { download security level }
    ar:set of arflags;                { AR flags }
    ac:set of acflags;                { AC flags }
    fp:integer;                       { file points, positive OR negative }
    softar:boolean;                   { add AR flags or replace AR flags? }
    softac:boolean;                   { add AC flags or replace AC flags? }
    softfp:boolean;                   { increase/decrease FP or replace FP? }
    expto:string[8];                  { level to which this expires }
    expdays:word;                     { days in this profile, 0=unlimited }
    res:array[1..10] of byte;         { -- RESERVED -- }
  end;

  configrec=                          { ETERNITY.DAT - system configuration }
  record
    versionid:word;                   { version id (ie 1.51 = $0151) }
    revision:byte;                    { minor revision }

    name:string[80];                  { site name }
    location:string[40];              { site location }
    phone:string[12];                 { site phone number }
    sysop:string[36];                 { site operator }
  
    datapath:string[60];              { path to data files }
    miscpath:string[60];              { path to misc display files }
    menupath:string[60];              { path to menu files }
    logspath:string[60];              { path to logs }
    msgspath:string[60];              { path to messages }
    temppath:string[60];              { path to temporary files }
    arcspath:string[60];              { path to archivers }
    protpath:string[60];              { path to protocols }
    swappath:string[60];              { location for swap files }
    
    sop:acstring;                     { sysop access }
    csop:acstring;                    { full co-sysop }
    fsop:acstring;                    { file base sysop }
    msop:acstring;                    { message base sysop }
    readallpriv:acstring;             { read all private mail }
    
    address:array[0..25] of fidoaddress; { address (aka's also) }
    origin:string[60];                { default origin line }

    text_color:byte;                  { color for message text }
    quote_color:byte;                 { color for quoted text }
    tear_color:byte;                  { color for tear lines }
    origin_color:byte;                { color for origin lines }
    kludge_color:byte;                { color for kludge lines }

    usefidostds:boolean;              { default to fidonet standards }
    holdallusernetmail:boolean;       { hold all user netmail }
    
    netmail_hold:boolean;             { default netmail to hold }
    netmail_crash:boolean;            { default netmail to crash }
    netmail_kill:boolean;             { default netmail to kill/sent }

    echopath:string[60];              { base echomail path }

    comment:array[1..3] of string[12];{ archive comment files }
    archiver:array[1..maxarcs] of archiverec; { archivers }
    filepointvalue:byte;              { how many K a file point is equal to }
    
    seeunval:acstring;                { see unvalidated files }
    dlunval:acstring;                 { download unvalidated files }
    
    defsec:securityrec;               { default security record }

    usefileratios:boolean;            { use the file ratio system }
    usefilepoints:boolean;            { use the file point system }
    
    startmenu:string[8];              { default start-out menu }
    
    nulogin:array[1..40] of byte;     { newuser login procedure }

    sysoppw:string[20];               { sysop password }
    newuserpw:string[20];             { newuser password }
    matrixpw:string[20];              { matrix password }
    chatpw:string[20];                { emergency chat password }

    asksysoppw:acstring;              { access to ask for sysop password }
    
    usematrix:boolean;                { use login matrix }
    
    validated:acstring;               { access to be considered validated }
    
    allowunval:boolean;               { allow unvalidated users to log on }
    overlaywithems:boolean;           { attempt to load overlay into EMS }
    secureconfs:boolean;              { secure global conference }

    defaultprofile:string[8];         { default validation profile }

    chatbegin:word;                   { chat hours begin }
    chatend:word;                     { chat hours end }

    maxoneliners:byte;                { max # of oneliners to keep }

    login:array[1..40] of byte;       { login procedure }

    seeulname:acstring;               { access to see uploader's name }

    usenuv:boolean;                   { use new user voting? }
    valreq:word;                      { votes required to validate }
    delreq:word;                      { votes required to delete }
    autoval:boolean;                  { auto-validate users that pass? }
    autodel:boolean;                  { auto-delete users that fail? }
    autotrash:boolean;                { auto-trash users that fail? }
    autovalprofile:string[8];         { profile for auto-validating users }
    autovalnote:string[30];           { note to give auto-validated users }
    usenuvlog:boolean;                { use NUV logging }

    qwkname:string[8];                { qwk name }
    welcomefile:string[8];            { welcome screen to include }
    newsfile:string[8];               { news file to include }
    goodbyefile:string[8];            { logoff screen to include }
    qwkpath:string[60];               { path for local QWK downloads }
    reppath:string[60];               { path for local REP uploads }
    maxperbase:word;                  { max msgs per base }
    maxperpacket:word;                { max msgs per packet }

    usebios:boolean;                  { use BIOS for video output }
    allowmsgmci:boolean;              { allow MCI codes in messages }

    kfdrive:char;                     { drive to check for @KF@ mci code }

    newtext:string[35];               { new user logon name }

    bgchar:char;                      { background character }
    pwchar:char;                      { password echo char }

    logonrate:word;                   { minimum logon rate }

    timerefund:byte;                  { upload time refund percentage }
    dizlimit:word;                    { maximum file_id.diz length }

    showlaston:byte;                  { number of last callers to show }

    res:array[1..3825] of byte;       { -- RESERVED -- }
  end;
  
  noderec=                            { NODE*.DAT - node configuration }
  record
    comport:byte;                     { comport number }
    comspeed:longint;                 { serial port speed }
    init:string[80];                  { initialization string }
    answer:string[40];                { answer string }
    hangup:string[40];                { hangup string }
    offhook:string[40];               { phone off-hook string }
    nocallinittime:word;              { reinit modem every x minutes }
    lockport:boolean;                 { whether to lock com port }
    rtscts:boolean;                   { whether CTS checking is on }
    xonxoff:boolean;                  { whether XON/XOFF is on }
    statlinetype:byte;                { statline: 0=None, 1..3=Small..Huge }
    statlinetop:boolean;              { whether statline goes on top }
    acs:acstring;                     { minimum ACS to logon }
    droppath:string[60];              { drop file path for this node }
    res:array[1..39] of byte;         { -- RESERVED -- }
  end;

  eventrec=                           { EVENTS.DAT - automated events }
  record
    active:boolean;                   { is event active }
    description:string[30];           { description of event }
    etype:char;                       { event type: A:CS C:HAT D:OS E:RRLEV }
    data:string[20];                  { event data (ACS, cmdline, etc) }
    busytime:word;                    { go offhook x minutes in advance }
    exectime:word;                    { time to execute event }
    offhookduring:boolean;            { offhook during event }
    duration:word;                    { duration if ACS or CHAT }
    days:byte;                        { bitwise days of week / day of month }
    monthly:boolean;                  { monthly event }
    lastrun:string[8];                { last date run }
    forced:boolean;                   { run as soon as possible }
    priority:boolean;                 { kick user off to do event }
  end;
  
{----------------------------------------------------------------------------}

  zlogrec=                            { ZLOG.DAT - system history }
  record
    date:string[8];                   { date for this entry }
    userbaud:array[1..6] of word;     { # of 300,1200,2400,9600,14400,28800 }
    active:word;                      { minutes active }
    calls:word;                       { number of calls }
    newusers:word;                    { number of new users }
    guestusers:word;                  { number of guest users }
    criterrs:word;                    { number of critical errors }
    pubpost:word;                     { number of public posts }
    privpost:word;                    { number of private posts }
    netpost:word;                     { number of netmail posts }
    uploads:word;                     { number of uploads }
    downloads:word;                   { number of downloads }
    uk:longint;                       { number of K uploaded }
    dk:longint;                       { number of K downloaded }
  end;

  smr=                                { SHORTMSG.DAT - login notices }
  record
    msg:string[80];                   { message to display to user }
    user:word;                        { user to show it to, 0=NONE }
  end;

  votingrec=                          { VOTING.DAT - voting records }
  record
    question:string[65];              { voting question }
    acs:acstring;                     { ACS to vote on this topic }
    addacs:acstring;                  { ACS to add a choice }
    numchoices:byte;                  { number of choices availible }
    numvotes:byte;                    { number of votes on this question }
    createdby:string[36];             { user who created this question }
    choices:array[1..maxvoteanswers] of
    record
      description:string[65];         { description of choice }
      numvoted:word;                  { # of users who picked this choice }
    end;
  end;
  
  lastonrec=                          { LASTON.DAT - last callers records }
  record
    callernum:longint;                { system caller number }
    name:string[36];                  { user name of caller }
    number:word;                      { user number of caller }
    usernote:string[30];              { caller's user note }
    location:string[30];              { location of last caller }
    time:string[5];                   { time in xx:yyz format (5:37p) }
    date:string[8];                   { date in mm-dd-yy format }
    bps:string[6];                    { speed of connection }
    wasnew:boolean;                   { caller was a new user }
  end;
  
  screensetrec=                       { *SET.DAT - menu and stat sets }
  record
    desc:string[40];                  { description of display set }
    path:string[60];                  { path to alternate files }
    acs:acstring;                     { ACS required for this set }
    res:array[1..10] of byte;
  end;

  rumorrec=                           { RUMORS.DAT - rumors data file }
  record
    text:string[78];                  { rumor text }
    author:string[35];                { author name }
    anon:boolean;                     { whether the rumor is anonymous }
    res:array[1..10] of byte;         { -- RESERVED -- }
  end;

  
  onelinerrec=                        { ONELINER.DAT - oneliner data file }
  record
    text:string[78];                  { oneliner text }
    author:string[36];                { author name }
    res:array[1..10] of byte;         { -- RESERVED -- }
  end;
  
  tunerec=                            { *.TUN - tune file format }
  record
    hz:word;                          { frequency in hertz, 0=silent }
    len:word;                         { length in milliseconds }
  end;

  confrec=                            { CONF.DAT - conference configuration }
  record
    name:string[40];                  { name of this conference }
    tag:word;                         { used for Cx and menu cmds (0=global) }
    acs:acstring;                     { access required for this conference }
    password:string[20];              { password required to join conference }
    active:boolean;                   { whether this conference is active }
    res:array[1..10] of byte;         { -- RESERVED -- }
  end;

  systatrec=                          { STATUS.DAT - contains system status }
  record
    zlog:zlogrec;                     { today's zlog entry }
    numcalls:longint;                 { number of calls to system (not KB) }
    numusers:longint;                 { current number of users }
    lastuser:string[24];              { name/number for WFC screen }
    res:array[1..46] of byte;         { -- RESERVED -- }
  end;

  bulletinrec=                        { BULLETIN.DAT - system bulletins }
  record
    filename:string[8];               { filename of bulletin }
    title:string[40];                 { title of bulletin }
    acs:acstring;                     { minimum ACS to see bulletin }
    mandatory:boolean;                { force user to read it when updated }
    ignore:boolean;                   { don't include in newscan }
    res:array[1..10] of byte;         { -- RESERVED -- }
  end;

(*
  PROTOCOL MCI CODES
  
   %A = DCE (14.4)
   %B = DTE (19.2)
   %F = file (if applicable)
   %L = batch list
   %M = main BBS dir (without trailing backslash)
   %N = node #
   %P = port
   %T = temp log
   %U = upload directory

  ARCHIVER MCI CODES

   %C = comment file
   %F = file to be processed
   %I = interior files

  DOOR MCI CODES

   %A = DCE (14.4)
   %B = DTE (19.2)
   %M = main BBS dir (without trailing backslash)
   %N = node #
   %P = port

*)
