#!/bin/bash
##
## EleBBS/Linux installation script
## Copyright 2001 by Maarten Bekers
##
##
#
ELEBASE=/home
SCROUT=/dev/null
#
# yesno gives 1 on no, 0 on yes $1 gives text to display.
# (based on FPCs install script)
#
askyesno ()
{
  while true; do
    echo -n "$1 (Y/n)? "
    read -n1 ansstr

    case X$ansstr in
     X|Xy|XY) return 0;;
     Xn|XN) return 1;;
    esac
    done
}
# create all the necessary directories
# $1 = directory to install beneath
createsubdirs ()
{
 echo
 echo "* Creating installation paths ($1)"
 echo "  +- Creating system path $1/ele"
 mkdir $1/ele 2>>$SCROUT
 echo "  +- Creating textfiles path $1/ele/txtfiles"
 mkdir $1/ele/txtfiles 2>>$SCROUT
 echo "  +- Creating messagebase path $1/ele/msgbase"
 mkdir $1/ele/msgbase 2>>$SCROUT
 echo "  +- Creating menufiles path $1/ele/menus"
 mkdir $1/ele/menus/ 2>>$SCROUT
 echo "  +- Creating filebase path $1/ele/filebase"
 mkdir $1/ele/filebase 2>>$SCROUT
 mkdir $1/ele/filebase/hdr 2>>$SCROUT
 mkdir $1/ele/filebase/idx 2>>$SCROUT
 mkdir $1/ele/filebase/txt 2>>$SCROUT
 echo "  +- Creating questionnaire (script) path $1/ele/question"
 mkdir $1/ele/question 2>>$SCROUT
 echo "  +- Creating documentation path $1/ele/doc"
 mkdir $1/ele/doc 2>>$SCROUT
 echo "  +- Creating samples path $1/ele/sample"
 mkdir $1/ele/sample 2>>$SCROUT
}
# unpack the EleBBS/Linux archives
# $1 = directory to install beneath
# $2 = unzip
# we pass -L as parameter to unzip force lowercase names
unpackelebbs ()
{
  echo "* Unpacking packages (using $2)"
  echo "  +- Unpacking \"doc.zip\" into $1/ele"
  $2 -L -j doc.zip -d $1/ele/doc/ 2>>$SCROUT
  echo "  +- Unpacking \"bin.zip\" into $1/ele"
  $2 -L -j bin.zip -d $1/ele 2>>$SCROUT
  echo "  +- Unpacking \"samples.zip\" into $1/ele/sample"
  $2 -L -j samples.zip -d $1/ele/sample/ 2>>$SCROUT
  echo "* Installing configuration files"
  echo "  +- Unpacking \"sample2.zip\" into $1/ele/menus/"
  $2 -L -j $1/ele/sample/sample2.zip -d $1/ele/menus/ 2>>$SCROUT
  echo "     +- Moving template ANSI to example directory"
  mv $1/ele/menus/template.ans $1/ele/txtfiles 2>>$SCROUT
  echo "     +- Copying \"elebbs.ans\" as \"logo.ans\""
  mv $1/ele/doc/elebbs.ans $1/ele/txtfiles/logo.ans 2>>$SCROUT
  echo "     +- Copying \"read.me\" to $1/ele/doc"
  mv read.me.* $1/ele/doc 2>>$SCROUT
  echo "     +- Copying \"upgrade\" to $1/ele/doc"
  mv upgrade.* $1/ele/doc 2>>$SCROUT
  echo "     +- Copying \"comip.txt\" to $1/ele/doc"
  mv comip.txt $1/ele/doc 2>>$SCROUT
  echo "  +- Unpacking \"excfg.zip\" into $1/ele"
  $2 -L -j $1/ele/sample/excfg.zip -d $1/ele 2>>$SCROUT
  echo "* Copying of files finished, press enter to continue."
  read
}
# unpack, compile and run the script to change the default paths to
# the ones we have defined here
fixpaths ()
{
  # change to the scripts directory
  cd $1/ele/ 2>>$SCROUT

  # write the install directory to a temporary path
  echo $1/ele/ >tmppath.ooo

  # unpack the fixpath.pas script
  $2 -L -j $1/ele/sample/elx_def.zip fixpath.pas 2>>$SCROUT

  # and compile and interpret it
  $1/ele/elexer -c ./fixpath.pas -i ./fixpath 2>>$SCROUT

  # clean up the files we temporarily used
  rm -f fixpath.pas 2>>$SCROUT
  rm -f fixpath.elm 2>>$SCROUT
  rm -f tmppath.ooo 2>>$SCROUT
}

## Start the finaly script with a clear screen
clear

## display a nice header
echo "-------------------------------------------------------------------"
echo "-      INSTALL.BAT - Basic installation routine for EleBBS.       -"
echo "-------------------------------------------------------------------"
echo 

# make sure there was specified a destionation directory
# if [ "$ELEBASE" == "" ]; then
#   echo
#   echo "* You need to specify a destination directory, aborting"
#   exit 2
# fi

echo 
echo "* This installation routine is only meant for people performing a fresh"
echo   install of EleBBS/Linux. If you already have an existing EleBBS/Linux 
echo   installation, please abort this script now. 
echo

# now lets see if we can start the installation
if askyesno "Start installation"; then
  createsubdirs $ELEBASE
  unpackelebbs $ELEBASE unzip
  fixpaths $ELEBASE unzip
fi

echo
echo Installation of EleBBS finished. Please configure an environment variable
echo of ELEBBS set to $1/ele. For help on how to do this consult your operating
echo "system manual. (eg: declare -x ELEBBS=$ELEBASE/ele)"
echo
echo
echo You can now configure your EleBBS by running ELCONFIG, or you can fire
echo up EleBBS into localmode by typing in:
echo $ELEBASE/ele/elebbs
echo
echo Have fun!
echo

cd $ELEBASE
