REM Editcoin v1.2a - utility to edit coins.dat file for Dndbbs v5.0a r2.0a PD

REM  v1.1a - Adds form$ and overflow check. (09/13/2019)
REM  v1.2a - Adds StatusLine and /p to command line. (09/21/2019)
REM          Also adds editcoin.cfg..

Const Filename="coins.dat"
Const Filename2="coins.bkp"
Const Version$="v1.2a"

' declare format functions
Declare Function Form$(X#)
Declare Function Form2$(X#)
Function Form$(Var#)
 Form$=Format$(Var#,"#,##0;;"+Chr$(34)+"zero"+Chr$(34))
End Function
Function Form2$(Var#)
 Form2$=Format$(Var#,"#,##0;;")
End Function

On Error Goto ErrResume0

' get command line
C$ = Command$
If Len(C$) Then
   If C$ = "/P" Then
      Call Pack.Coins(Var1!)
      Color 15
      Print "Coins.dat packed."
      Color 14
      If Var1!=1! Then Print " 1 record packed." Else Print Var1!;"records packed."
      Color 7
      Print "Now exiting Editcoin."
      End
   Endif
   ' boot usage
   Color 15
   Print "Editcoin utility "+Version$
   Print "Usage:"
   Color 14
   Print "  Editcoin [/p]"
   Color 15
   Print "Where:"
   Color 14
   Print "  /p  pack coins."
   Color 7
   End
Endif

' display statusline
Call Read.Rows(Max.Row)
Cls
Locate Max.Row,1,1
Color 15,1
S$ = "Editcoin utility "+Version$+" "+Format$(Now,"mm-dd-yyyy")+" "+Format$(Now,"hh:mm:ss")
S$ = S$ + Space$(80-Len(S$))
Print S$;
Locate Max.Row-1,1,1
Color 15,0

' start editcoin
Open FileName For Random Shared As #1 Len=16
Field #1, 4 As R1$, 8 As G1$, 2 As P1x$, 2 As P2x$
Color 15
Print "Editcoin "+Version$
Color 14

' init coins.dat
If Lof(1)/16!=0! Then
   Lset R1$=Mks$(0) : Lset G1$=Mkd$(0) : Lset P1x$=Mki$(0) : Lset P2x$=Mki$(0)
   Put  #1,1
   Color 14
   Print " Coins.dat initialized."
Endif

' get config setting
AutoPack=0
F$="editcoin.cfg"
If Dir$(F$)<>"" Then
   Close #2
   Open F$ For Input Shared As #2
   Do Until Eof(2)
      Line Input #2,V$
      V$=Lcase$(V$) : V$=Rtrim$(V$)
      If Left$(V$,8)="autopack" Then
         V$=Mid$(V$,9) : V$=Ltrim$(V$)
         If Left$(V$,1)="=" Then
            V$=Mid$(V$,2) : V$=Ltrim$(V$)
            Select Case V$
            Case "-1","true","on"
               AutoPack=-1
            End Select
         Endif
      Endif
   Loop
Endif
If AutoPack Then
   Call Pack.Coins(Var1!)
   ' restart editcoin datafile
   Open FileName For Random Shared As #1 Len=16
   Field #1, 4 As R1$, 8 As G1$, 2 As P1x$, 2 As P2x$
Endif

' begin editcoin loop
Checked=0
ErrExit0:
Do
   Color 15
   Print "Edit coins:";
   Print " (Records:"+Str$(Lof(1)/16!);")"
   If Checked=0 Then
      Gosub Check.Coins
      Checked=-1
   Endif
   Color 14
   Print " [A]dd record"
   Print " [C]hange record"
   Print " [D]elete record"
   Print " [F]ind coins"
   Print " [H]elp list"
   Print " [L]ist coins"
   Print " [P]ack file"
   Print " [S]can file"
   Print " [V]erify file"
   Print " [Z]scan and count"
   Color 15
   Print "Enter option(? = Help, Q to Quit)?";
   C$=""
   Do
      C$=Inkey$
      If Len(C$)=1 Then
         If C$=Chr$(13) Then C$="Q"
         C$=Ucase$(C$)
         If C$>="A" And C$<="Z" Then
            Print Ucase$(C$)
         Else
            Print
         Endif
         Exit Do
      Endif
   Loop
   Color 14
   Select Case Ucase$(C$)
   Case "A"
      Lset R1$=Mks$(0) : Lset G1$=Mkd$(0) : Lset P1x$=Mki$(0) : Lset P2x$=Mki$(0)
      Put  #1,Lof(1)/16!+1!
      Print "Record added."
      Print " Records:"+Str$(Lof(1)/16!)
   Case "C"
      V$=Str$(Lof(1)/16!) : V$=Ltrim$(V$)
      If Lof(1)/16!=0! Then
         Print "No records found." : V!=0!
      Else
         Print "Enter record(1-";V$;")";
         Input V! : V!=Int(V!)
      Endif
      If V!>=1! And V!<=Lof(1)/16! Then
         Get #1,V!
         Print "Room"; : Input R$
         If R$="" Then
            R!=Cvs(R1$)
         Else
            R!=Int(Val(R$))
            If R!<0! Then R!=0!
         Endif
         Print "Gold"; : Input G$
         If G$="" Then
            G#=Cvd(G1$)
         Else
            G#=Int(Val(G$))
            If G#<0# Then G#=0#
         Endif
         Print "Hidden(Y=Yes)"; : Input C$ : C$=Ucase$(C$) : If C$="Y" Then C=-1 Else C=0
         Print "Type(0=gold,1=silver,2=copper)";
         Input X : X=Int(X) : If X>=0 And X<=2 Then T=X Else T=0
         Z=0
         If T>0 Then
            If G#=0# Then
               Strng$ = "Gold must be nonzero."
               Z=-1
            Endif
         Endif
         If T=0 Then ' gold
            If G#=0# Then ' gold divisor
               Strng$ = "Gold must be multiple of 1."
               Z=-1
            Endif
         Endif
         If T=1 Then ' silver
            If G#>0# Then
               If G# Mod 10# Then ' silver divisor
                  Strng$ = "Silver must be multiple of 10."
                  Z=-1
               Endif
            Endif
         Endif
         If T=2 Then ' copper
            If G#>0# Then
               If G# Mod 100# Then ' copper divisor
                  Strng$ = "Copper must be multiple of 100."
                  Z=-1
               Endif
            Endif
         Endif
         If Z=0 Then
            Lset R1$=Mks$(R!) : Lset G1$=Mkd$(G#) : Lset P1x$=Mki$(C) : Lset P2x$=Mki$(T)
            Put #1,V!
            Print "Record";V!;"changed."
         Else
            Print "Record error: "; Strng$
         Endif
      Endif
   Case "D"
      V$=Str$(Lof(1)/16!) : V$=Ltrim$(V$)
      If Lof(1)/16!=0! Then
         Print "No records found." : V!=0!
      Else
         Print "Enter record(1-";V$;")";
         Input V! : V!=Int(V!)
      Endif
      If V!>=1! And V!<=Lof(1)/16! Then
         Lset R1$=Mks$(0) : Lset G1$=Mkd$(0) : Lset P1x$=Mki$(0) : Lset P2x$=Mki$(0)
         Put #1,V!
         Print "Record deleted."
         Checked=0
      Endif
   Case "F"
      Print "Room from"; : Input R1! : R1!=Int(R1!) : If R1!<0! Then R1!=0!
      Print "Room to"; : Input R2! : R2!=Int(R2!) : If R2!<0! Then R2!=0!
      Print "Gold from"; : Input G1# : G1#=Int(G1#) : If G1#<0# Then G1#=0#
      Print "Gold To"; : Input G2# : G2#=Int(G2#) : If G2#<0# Then G2#=0#
      Print "Hidden(Y=Yes)"; : Input C$ : C$=Ucase$(C$) : If C$="Y" Then C=-1 Else C=0
      Print "Type(0=gold,1=silver,2=copper)"; : Input X : X=Int(X) : If X>=1 And X<=2 Then T=X Else T=0
      Q=1
      X=0
      Print "Searching file:"
      For V!=1! To Lof(1)/16!
         Get #1,V!
         Z=0
         If R1!>0! And R2!>0! Then If Cvs(R1$)>=R1! And Cvs(R1$)<=R2! Then Z=-1
         If G1#>0# And G2#>0# Then If Cvd(G1$)>=G1# And Cvd(G1$)<=G2# Then Z=-1
         If C Then If Cvi(P1x$) Then Z=-1
         If T Then If Cvi(P2x$)=T Then Z=-1
         If Z Then
            X=-1
            Color 15
            Print "Match record:";V!;
            Select Case Cvi(P2x$)
            Case 0
               Print "(gold)";
            Case 1
               Print "(silver)";
            Case 2
               Print "(copper)";
            End Select
            If C Then
               If Cvi(P1x$) Then
                  Print " (hidden)"
               Else
                  Print
               Endif
            Else
               Print
            Endif
            Q=Q+1
            If Q=23 Then
               Q=0
               Color 14
               Print "More(y/n)?";
               Do
                  Z$=Inkey$:Z$=Ucase$(Z$)
                  If Z$="N" Then Print:Q=0:Exit For
                  If Z$=CHR$(13) Or Z$="Y" Then Print:Exit Do
               Loop
            Endif
         Endif
      Next
      If X=0 Then
         Color 15
         Print "No matching records found."
         Q=-1
      Endif
      If Q Then
         Color 14
         Print "More(y/n)?";
         While Inkey$="":Wend:Print
      Endif
   Case "L"
      If Lof(1)/16!=0! Then
         Print "No records found." : Z1!=0! : Z2!=0!
      Else
         V$="From 1-"+Mid$(Str$(Lof(1)/16!),2)
         Print V$; : Input Z1! : Z1!=Int(Z1!) : If Z1!=0! Then Z1!=1!
         If Z1!<1! Or Z1!>Lof(1)/16! Then Z1!=0!
         V$="To 1-"+Mid$(Str$(Lof(1)/16!),2)
         Print V$; : Input Z2! : Z2!=Int(Z2!) : If Z2!=0! Then Z2!=Lof(1)/16!
         If Z2!<1! Or Z2!>Lof(1)/16! Then Z2!=0!
         If Z1!>Z2! Then Z1!=0! : Z2!=0!
      Endif
      If Z1!>0! And Z2!>0! Then
         For V!=Z1! To Z2!
            Get #1,V!
            Color 15
            Print "Record:";Str$(V!)
            Get #1,V!
            Color 14
            Print " Room: ";Form2$(Cdbl(Cvs(R1$)))
            Print " Gold:";
            If Instr(Str$(Cvd(G1$)),"D") Then
               Print Str$(Cvd(G1$))
            Else
               Print " ";Form$(Cvd(G1$))
            Endif
            Print " Hidden: ";
            If Cvi(P1x$) Then Print "Yes" Else Print "No"
            Print " Type: "; : X=Cvi(P2x$)
            Select Case X
            Case 0
               Print "Gold"
            Case 1
               Print "Silver"
            Case 2
               Print "Copper"
            Case Else
               Print "<n/a>"
            End Select
            Color 15
            Print "More(y/n)?";
            Do
               C$=Inkey$
               C$=Ucase$(C$)
               If C$="N" Then Print:Exit For
               If C$=CHR$(13) Or C$="Y" Then Print:Exit Do
            Loop
         Next
      Endif
   Case "P"
      Call Pack.Coins(Var1!)
      ' restart editcoin datafile
      Open FileName For Random Shared As #1 Len=16
      Field #1, 4 As R1$, 8 As G1$, 2 As P1x$, 2 As P2x$
      Print "Coins.dat packed."
      If Var1!=1! Then Print " 1 record packed." Else Print Var1!;"records packed."
   Case "S"
      Print "Scanning file.."
      Q=1
      Z!=0!
      For V!=1! To Lof(1)/16!
         Get #1,V!
         R!=Cvs(R1$)
         If R!<0! Or R!<>Int(R!) Then
            Print "Error in record:";V!;"(bad room number)"
            Z!=Z!+1!
            Q=Q+1
         Endif
         G#=Cvd(G1$)
         If G#<0# Or G#<>Int(G#) Then
            Print "Error in record:";V!;"(bad gold amount)"
            Z!=Z!+1!
            Q=Q+1
         Endif
         X=Cvi(P2x$)
         If X<0 Or X>2 Or X<>Int(X) Then
            Print "Error in record:";V!;"(bad cointype)"
            Z!=Z!+1!
            Q=Q+1
         Endif
         If X=1 Then ' silver
            If G#>0# Then
               If G# Mod 10# Then
                  Print "Error in record:";V!;"(bad silver modulo)"
                  Z!=Z!+1!
                  Q=Q+1
               Endif
            Endif
         Endif
         If X=2 Then ' copper
            If G#>0# Then
               If G# Mod 100# Then
                  Print "Error in record:";V!;"(bad copper modulo)"
                  Z!=Z!+1!
                  Q=Q+1
               Endif
            Endif
         Endif
         If Q=23 Then
            Q=0
            Color 14
            Print "More(y/n)?";
            Do
               Z$=Inkey$:Z$=Ucase$(Z$)
               If Z$="N" Then Print:Q=0:Exit For
               If Z$=CHR$(13) Or Z$="Y" Then Print:Exit Do
            Loop
         Endif
      Next
      If Z!=0! Then Print "No errors found."
      If Z!>0! Then
         If Z!=1! Then Print " 1 error found." Else Print Z!;"errors found."
         Print "Verify file suggested."
      Endif
   Case "V"
      Print "Verifying file.."
      Z!=0!
      Z2!=0!
      For V!=1! To Lof(1)/16!
         Get #1,V!
         F=0
         R!=Cvs(R1$)
         If R!<0! Or R!<>Int(R!) Then
            Lset R1$=Mks$(0)
            Z!=Z!+1!
            F=-1
         Endif
         G#=Cvd(G1$)
         If G#<0# Or G#<>Int(G#) Then
            Lset G1$=Mkd$(0#)
            Z!=Z!+1!
            F=-1
         Endif
         X=Cvi(P2x$)
         If X<0 Or X>2 Or X<>Int(X) Then
            Lset P2x$=Mki$(0)
            Z!=Z!+1!
            F=-1
         Endif
         If X=1 Then ' silver
            If G#>0# Then
               If G# Mod 10# Then
                  Lset G1$=Mkd$(0#)
                  F=-1
                  Z!=Z!+1!
               Endif
            Endif
         Endif
         If X=2 Then ' copper
            If G#>0# Then
               If G# Mod 100# Then
                  Lset G1$=Mkd$(0#)
                  Z!=Z!+1!
                  F=-1
               Endif
            Endif
         Endif
         Put #1,V!
         If F Then Z2!=Z2!+1!
      Next
      If Z!=0! Then Print "No errors in any records found."
      If Z!>0! Then
         If Z!=1! Then
            If Z2!=1! Then
               Print Z!;"error in";Z2!;"record corrected."
            Else
               Print Z!;"error in";Z2!;"records corrected."
            Endif
         Else
            If Z2!=1! Then
               Print Z!;"errors in";Z2!;"record corrected."
            Else
               Print Z!;"errors in";Z2!;"records corrected."
            Endif
         Endif
      Endif
   Case "H", "?"
      Color 15
      Print "Editcoin Menu:"
      Print
      Print "   [A]dd record"
      Print
      Print "     Adds a blank record to end of file."
      Print
      Print "   [C]hange record"
      Print
      Print "     Prompt for record number then edits Room, Gold, Hidden, and Cointype."
      Print "       Where cointype is: 0=Gold, 1=Silver, 2=Copper."
      Print
      Print "   [D]elete record"
      Print
      Print "     Prompt for record number then resets all values to nul."
      Print
      Print "   [F]ind coins"
      Print
      Print "     Searchs the datafile for specific Room/Gold/Hidden/Type."
      Print
      Print "   [L]ist coins"
      Print
      Print "     Lists records and values prompting for more."
      Color 14
      Print "-More-";
      Do
         Z$=Inkey$:Z$=Ucase$(Z$)
         If LEN(Z$) Then Print:Exit Do
      Loop
      Color 15
      Print "   [P]ack file"
      Print
      Print "     Copies coins.dat file and rewrites skipping empty records."
      Print
      Print "   [S]can file"
      Print
      Print "     Scans the datafile for invalid records."
      Print
      Print "   [V]erify file"
      Print
      Print "     Scans the datafile and attempts to correct errors."
      Print
      Print "   [Z]scan and count"
      Print
      Print "     Similar to find only displays number of records found."
      Color 14
      Print "-More-";
      Do
         Z$=Inkey$:Z$=Ucase$(Z$)
         If LEN(Z$) Then Print:Exit Do
      Loop
   Case "Z"
      Print "Room from"; : Input R1! : R1!=Int(R1!) : If R1!<0! Then R1!=0!
      Print "Room to"; : Input R2! : R2!=Int(R2!) : If R2!<0! Then R2!=0!
      Print "Gold from"; : Input G1# : G1#=Int(G1#) : If G1#<0# Then G1#=0#
      Print "Gold To"; : Input G2# : G2#=Int(G2#) : If G2#<0# Then G2#=0#
      Print "Hidden(Y=Yes)"; : Input C$ : C$=Ucase$(C$) : If C$="Y" Then C=-1 Else C=0
      Print "Type(0=gold,1=silver,2=copper)"; : Input X : X=Int(X) : If X>=1 And X<=2 Then T=X Else T=0
      X!=0!
      Print "Searching file:"
      For V!=1! To Lof(1)/16!
         Get #1,V!
         Z=0
         If R1!>0! And R2!>0! Then If Cvs(R1$)>=R1! And Cvs(R1$)<=R2! Then Z=-1
         If G1#>0# And G2#>0# Then If Cvd(G1$)>=G1# And Cvd(G1$)<=G2# Then Z=-1
         If C Then If Cvi(P1x$) Then Z=-1
         If T Then If Cvi(P2x$)=T Then Z=-1
         If Z Then
            X!=X!+1!
         Endif
      Next
      If X!=0! Then
         Color 15
         Print "No matching records found."
      Endif
      If X!>0! Then
         If X!=1! Then
            Color 15
            Print X!;"matching record found."
         Else
            Color 15
            Print X!;"matching records found."
         Endif
      Endif
   Case "Q"
      Print "Exit program(y/n)?";
      Do
         C$=Inkey$
         C$=Ucase$(C$)
         If C$="N" Then Print "N" : Exit Do
         If C$="Y" Then Print "Y" : Goto ExitLoop
      Loop
   End Select
Loop

' remove statusline and exit.
ExitLoop:
Color 7, 0
Locate Max.Row,1,1
Print Space$(80);
Print "Now exiting Editcoin."
End

' display any errors and resume.
ErrResume0:
 Error.Num=Err
 Color 10,0
 Select Case Error.Num
 Case 5 ' should not happen
    Print "Syntax error."
 Case 6 ' can happen with gold
    Print "Overflow."
 Case Else
    Print "Error"+Str$(Error.Num)+": Edit.Coins"
 End Select
 Resume ErrExit0
 End

' only display pack required once..
Check.Coins:
 Var1!=0!
 For V!=1! To Lof(1)/16!
    Get #1,V!
    If Cvs(R1$)=0! Then
       Var1!=Var1!+1!
   Endif
 Next
 If Var1! Then
    Color 10
    Print "Pack required! ";
    Var1$=Mid$(Str$(Var1!),2)
    If Var1!=1! Then
       Print "(";Var1$;" empty record found)"
    Else
       Print "(";Var1$;" empty records found)"
    Endif
 Endif
 Return

Sub Pack.Coins(Var1!)
 On Local Error Goto ErrResume1
 Var1!=0!
 Close #1
 Open FileName For Random Shared As #1 Len=16
 Field #1, 4 As R1$, 8 As G1$, 2 As P1x$, 2 As P2x$
 If Lof(1)=0 Then Exit Sub
 Close #2
 If Dir$(FileName2)<>"" Then Kill FileName2
 Open FileName2 For Random Shared As #2 Len=16
 Field #2, 4 As R2$, 8 As G2$, 2 As P1y$, 2 As P2y$
 For V!=1! To Lof(1)/16!
    Get #1,V!
    If Cvs(R1$)>0! Then
       Lset R2$=R1$ : Lset G2$=G1$ : Lset P1y$=P1x$ : Lset P2y$=P2x$
       X!=Lof(2)/16!+1! : Put 2,X!
    Else
       Var1!=Var1!+1!
    Endif
 Next
 Close 1, 2
 ' copy backup file to coins.dat file
 Kill Filename : Name FileName2 As FileName
 Exit Sub
ErrExit1:
 Close 1, 2
 Exit Sub
ErrResume1:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+": Pack.Coins"
 Resume ErrExit1
End Sub

Sub Read.Rows(Var)
 On Local Error Goto Error.Trap62x
 Temp1=50
 Locate 50,1,0
 Var=50
 Exit Sub
Next.Trap1:
 Temp1=43
 Locate 43,1,0
 Var=43
 Exit Sub
Next.Trap2:
 Temp1=25
 Locate 25,1,0
 Var=25
 Exit Sub
Next.Trap3:
 Var=12
Error.Resume62x:
 Exit Sub
Error.Trap62x:
 If Temp1=50 Then
    Resume Next.Trap1
 Endif
 If Temp1=43 Then
    Resume Next.Trap2
 Endif
 If Temp1=25 Then
    Resume Next.Trap3
 Endif
 Resume Error.Resume62x
End Sub
