REM Locate room directions with unmatched return directions. v1.1a.
REM   (writes data to file: Chklist.dat).

DEFINT A-Z
REM $DYNAMIC

TYPE RoomType
 Action AS SINGLE
 Custom1 AS STRING * 12
 Custom2 AS STRING * 12
 Direct(1 TO 14) AS SINGLE
 LongDesc(1 TO 19) AS SINGLE
 MonClass AS SINGLE
 ShortDesc AS STRING * 80
 First AS SINGLE ' inventory
 Last AS SINGLE
 First2 AS SINGLE ' containers
 Last2 AS SINGLE
END TYPE

REM Declare arrays.
DIM Directions(1 TO 12) AS STRING

REM Declare structures.
DIM RoomRecLen AS INTEGER
DIM RoomRecord AS RoomType
RoomRecLen = LEN(RoomRecord)

REM Read directions.
FOR L = 1 TO 12
   READ Directions(L)
NEXT

REM Open data files.
OPEN "rooms.dat" FOR RANDOM SHARED AS #1 LEN = RoomRecLen
OPEN "chklist.dat" FOR OUTPUT AS #2

REM Get directions type.
DO
   COLOR 15, 0
   PRINT "Directions type:"
   COLOR 14, 0
   PRINT " (1)N/S/E/W"
   PRINT " (2)N/E/S/W/NE/SE/SW/NW"
   PRINT " (3)N/E/S/W/NE/SE/SW/NW/U/D/I/O"
   PRINT " (4)Quit"
   COLOR 15, 0
   PRINT "Enter selection(1-4)";
   INPUT X
   COLOR 7, 0
   SELECT CASE X
   CASE 1
      Q = 4
      EXIT DO
   CASE 2
      Q = 8
      EXIT DO
   CASE 3
      Q = 12
      EXIT DO
   CASE 4
      END
   END SELECT
LOOP
PRINT #2, "rooms with unmatched links:"
REM Loop through Rooms.dat data file.
FOR v! = 1! TO LOF(1) / RoomRecLen
   FOR L = 1 TO Q
      GET #1, v!, RoomRecord
      r1! = RoomRecord.Direct(L) ' direction
      IF r1! > 0! THEN
         GET #1, r1!, RoomRecord
         GOSUB FindBackLink
         IF Temp4 THEN
            r2! = RoomRecord.Direct(Temp4) ' return direction
            IF r2! <> v! THEN
               ' room with unmatched direction:
               X$ = "room#" + STR$(v!) + " direction " + Directions(L)
               PRINT #2, X$
            END IF
         END IF
      END IF
   NEXT
NEXT
COLOR 15, 0
PRINT "Data written to 'chklist.dat'"
COLOR 7, 0
END

' find return direction
FindBackLink:
 SELECT CASE L
 CASE 1
    Temp4 = 3
 CASE 2
    Temp4 = 4
 CASE 3
    Temp4 = 1
 CASE 4
    Temp4 = 2
 CASE 5
    Temp4 = 7
 CASE 6
    Temp4 = 8
 CASE 7
    Temp4 = 5
 CASE 8
    Temp4 = 6
 CASE 9
    Temp4 = 10
 CASE 10
    Temp4 = 9
 CASE 11
    Temp4 = 12
 CASE 12
    Temp4 = 11
 CASE ELSE
    Temp4 = 0
 END SELECT
 RETURN

REM List of directions
DATA "north","east","south","west"
DATA "northeast","southeast","southwest","northwest"
DATA "up","down","in","out"

REM -eof-

