'INT 1A - TIME - GET SYSTEM TIME
'        AH = 00h
'Return: CX:DX = number of clock ticks since midnight
'        AL = midnight flag, nonzero if midnight passed since time last read
'Notes:  There are approximately 18.2 clock ticks per second,
'         or 1800B0h per 24 hours.
'
'Notes:  Clock ticks are actually at 18.20648 per second single-precision.

DEFINT A-Z
REM $DYNAMIC

TYPE RegTypeX
 AX AS INTEGER
 BX AS INTEGER
 CX AS INTEGER
 DX AS INTEGER
 BP AS INTEGER
 SI AS INTEGER
 DI AS INTEGER
 Flags AS INTEGER
 DS AS INTEGER
 ES AS INTEGER
END TYPE

DIM InregsX AS RegTypeX
DIM OutregsX AS RegTypeX

DECLARE SUB InterruptX (N AS INTEGER, I AS RegTypeX, O AS RegTypeX)

t2! = CSNG(INT(VAL(MID$(TIME$, 1, 2)))) * 3600! + CSNG(INT(VAL(MID$(TIME$, 4, 2)))) * 60! + CSNG(INT(VAL(MID$(TIME$, 7, 2))))

InregsX.AX = &H0
CALL InterruptX(&H1A, InregsX, OutregsX)

t! = TIMER

Byte1! = CSNG(OutregsX.CX)
Byte2! = CSNG(OutregsX.DX)
IF Byte1! < 0! THEN Byte1! = Byte1! + 65536! ' adjust signed-integer
IF Byte2! < 0! THEN Byte2! = Byte2! + 65536!
Byte! = Byte1! * 65536! + Byte2!
PRINT "-----------------"
PRINT "Ticks per second="
'PRINT CSNG(&H1800B0 / 86400!); " (calculated)" ' per 24 hrs
PRINT &H1800B0 / 86400!; " (calculated)" ' per 24 hrs

PRINT Byte! / t!; " (realtime)"

Byte! = Byte! / 18.2064814814815#

PRINT DATE$;" ";Format$(Now,"mm-dd-yyyy")
PRINT TIME$; "="
PRINT "BIOS:  "; Byte!
PRINT "QB:    "; t!
PRINT "TIME$: "; t2!

t1$ = Format$(Now, "hh:mm:ss")
t1! = CSNG(INT(VAL(MID$(t1$, 1, 2)))) * 3600! + CSNG(INT(VAL(MID$(t1$, 4, 2)))) * 60! + CSNG(INT(VAL(MID$(t1$, 7, 2))))
PRINT "Format$=";t1$;t1!

END

