REM Raisedtr v1.3a: Modem port DTR utility;

 DEFINT A-Z
 REM $DYNAMIC

 TYPE RegTypeX
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
  DS As Integer
  ES As Integer
 END TYPE

 COMMON SHARED InregsX AS RegTypeX
 COMMON SHARED OutregsX AS RegTypeX

 COMMON SHARED PortNumber AS INTEGER

 DECLARE SUB InterruptX (N AS INTEGER, I AS RegTypeX, O AS RegTypeX)

 ON ERROR GOTO Error.Routine

 Var$ = COMMAND$
 IF Var$ = "" THEN
    GOTO BootUsage
 END IF
 Var = INSTR(Var$, " ")
 IF Var THEN
    Var2$ = MID$(COMMAND$, Var + 1)
    Var$ = LEFT$(COMMAND$, Var - 1)
 END IF
 PortNumber = INT(VAL(Var$))
 IF PortNumber < 1 OR PortNumber > 8 THEN
    GOTO BootUsage
 END IF
 PortNumber = PortNumber - 1
 COLOR 15, 0
 PRINT "Raisedtr v1.3: Modem port utility;"
 GOSUB DetectFossil
 IF Fossil.Active THEN
    GOSUB RaiseFossilDTR
 ELSE
    GOSUB RaisePortDTR
 END IF
 COLOR 14, 0
 PRINT "Comm"; PortNumber + 1; "(port "; MID$(STR$(PortNumber), 2); ") DTR raised."
 COLOR 7, 0
 END

BootUsage:
 COLOR 15, 0
 PRINT "Raisedtr v1.3: Modem port utility;"
 COLOR 14, 0
 PRINT "Usage:"
 PRINT "   Raisedtr <comm port> <port address>"
 PRINT "Where:"
 PRINT "   Comm port=1 to 8"
 PRINT "   Optional MCR port address in hex."
 COLOR 7, 0
 END

' raise dtr using port address
RaisePortDTR:
 IF Var2$ = "" THEN
    SELECT CASE PortNumber
    CASE 0
       PortAddress = &H3FC
    CASE 1
       PortAddress = &H2FC
    CASE 2
       PortAddress = &H3EC
    CASE 3
       PortAddress = &H2EC
    CASE 4
       PortAddress = &H3E4
    CASE 5
       PortAddress = &H2E4
    CASE 6
       PortAddress = &H33C
    CASE 7
       PortAddress = &H23C
    END SELECT
 ELSE
    PortAddress = INT(VAL("&H" + Var2$))
 END IF
 ' set modem control register (MCR)
 OUT PortAddress, 3
 RETURN

' determine fossil type
DetectFossil:
 Fossil.Active = 0
 Fossil.Version = 0
 InregsX.AX = &H1C00
 InregsX.DX = PortNumber
 CALL InterruptX(&H14, InregsX, OutregsX)
 IF OutregsX.AX = &H1954 THEN ' x00
    Fossil.Active = -1
    Fossil.Version = 1
 ELSE
    InregsX.AX = &H400
    InregsX.DX = PortNumber
    CALL InterruptX(&H14, InregsX, OutregsX)
    IF OutregsX.AX = &H1954 THEN ' fossil
       Fossil.Active = -1
       Fossil.Version = 2
    END IF
 END IF
 RETURN

' raise dtr using fossil
RaiseFossilDTR:
 IF Fossil.Version = 1 THEN
    InregsX.AX = &H1F01
    InregsX.BX = 1
 ELSE
    InregsX.AX = &H601
 END IF
 InregsX.DX = PortNumber
 CALL InterruptX(&H14, InregsX, OutregsX)
 RETURN

Error.Routine:
 PRINT "Critical error "; ERR
 END
