Modem port utility.

REM Start at DOS command line: Qbx /l qbx.qlb

DEFINT A-Z
REM $DYNAMIC

TYPE RegType
 AX AS INTEGER
 BX AS INTEGER
 CX AS INTEGER
 DX AS INTEGER
 BP AS INTEGER
 SI AS INTEGER
 DI AS INTEGER
 Flags AS INTEGER
END TYPE

 DIM Inregs AS RegType, Outregs AS RegType, Port AS INTEGER

 DECLARE SUB Interrupt (N AS INTEGER, I AS RegType, O AS RegType)

 Port = 1 ' port 0 to 7 is comm 1 to 8.

 PRINT "Commands:"
 PRINT "<enter> get status."
 PRINT "<text> send to modem."
 PRINT "DTR <on/off> toggle modem dtr."
 PRINT "PORT change port number"
 PRINT "QUIT exit port program."
 DO
    LINE INPUT ":", X$
    SELECT CASE UCASE$(X$)
    CASE "QUIT"
       END
    CASE "PORT"
       PRINT "Enter port(0-7)";
       INPUT Z$
       Z = INT(VAL(Z$))
       IF Z >= 0 AND Z <= 7 THEN
          Port = Z
       END IF
    CASE "DTR ON"
       GOSUB Port.Address
       IF VarZ THEN
          VarZ = VarZ + 4
          OUT VarZ, 3
       END IF
    CASE "DTR OFF"
       GOSUB Port.Address
       IF VarZ THEN
          VarZ = VarZ + 4
          OUT VarZ, 0
       END IF
    CASE ""
       Inregs.AX = &H300
       Inregs.DX = Port
       CALL Interrupt(&H14, Inregs, Outregs)
       GOSUB Read.Port
       SELECT CASE Var
       CASE -2
          PRINT "Modem disconnected."
       CASE -1
          PRINT "Modem offline/turned off."
       CASE ELSE
          PRINT "Port status: "; HEX$(Outregs.AX)
          IF (Outregs.AX AND &H40) = &H40 THEN ' check ring bit
             PRINT "Ring indicator bit is set."
          END IF
          IF (Outregs.AX AND &H80) = &H80 THEN ' check carrier bit
             PRINT "Carrier bit is set."
          END IF
          IF (Outregs.AX AND &H100) = &H100 THEN  ' character is available
             PRINT "Character is available for input."
          END IF
          IF (Outregs.AX AND &H4000) = &H4000 THEN
             PRINT "Transmit buffer is empty."
          END IF
       END SELECT
    CASE ELSE
       Var$ = X$ + CHR$(13)
       GOSUB Send.Modem
    END SELECT
 LOOP
 END

Send.Modem:
 GOSUB Get.Port.Status
 IF (OutregsX.AX AND &HFF) = &HFF THEN ' modem offline
    RETURN
 END IF
' DO
'    Gosub Get.Port.Status
'    IF (Outregs.AX AND &H40) = 0 THEN ' check ring bit
'       EXIT DO
'    END IF
' LOOP
 FOR VarX = 1 TO LEN(Var$)
    Var = ASC(MID$(Var$, VarX, 1))
    DO
       GOSUB Get.Port.Status
       IF (Outregs.AX AND &H4000) = &H4000 THEN ' empty buffer
          Inregs.AX = &H100 + Var
          Inregs.DX = Port
          CALL Interrupt(&H14, Inregs, Outregs)
          EXIT DO
       END IF
    LOOP
 NEXT
 T! = TIMER + 3!
 WHILE TIMER < T!
    GOSUB Read.Modem
 WEND
 RETURN

Read.Modem:
 VarX = 0
 GOSUB Get.Port.Status
 IF (Outregs.AX AND &HFF) = &HFF THEN ' modem offline
    RETURN
 END IF
 DO
    IF (Outregs.AX AND &H100) = 0 THEN ' character is available
       EXIT DO
    END IF
    Inregs.AX = &H200
    Inregs.DX = Port
    CALL Interrupt(&H14, Inregs, Outregs)
    VarX = (Outregs.AX AND &HFF)
    IF VarX <> 10 THEN
       PRINT CHR$(VarX);
    END IF
 LOOP
 RETURN

Read.Port:
 GOSUB Get.Port.Status
 Var = False
 IF (Outregs.AX AND &HFF) = &HFF THEN
    Var = -2 ' disconnected
    RETURN
 END IF
 IF (Outregs.AX AND &HFF) = &H8 THEN
    Var = -1 ' offline/turned off
    RETURN
 END IF
 Var = OutregsX.AX
 RETURN

Get.Port.Status:
 Inregs.AX = &H300
 Inregs.DX = Port
 CALL Interrupt(&H14, Inregs, Outregs)
 RETURN

Port.Address:
 ' get port address
 VarZ = 0
 SELECT CASE Port
 CASE 0
    VarZ = &H3F8
 CASE 1
    VarZ = &H2F8
 CASE 2
    VarZ = &H3E8
 CASE 3
    VarZ = &H2E8
 CASE 4
    VarZ = &H3E0
 CASE 5
    VarZ = &H2E0
 CASE 6
    VarZ = &H338
 CASE 7
    VarZ = &H238
 CASE ELSE
    RETURN
 END SELECT
 RETURN

' read MSR
 VarZ = VarZ + 6
 VarX = INP(VarZ)
 PRINT "MSR="; HEX$(VarX)
 IF (VarX AND &HFF) = 0 THEN
    Var = -1
 END IF
 RETURN


' Port Status Register: (fossil function 03h)
'
' AH = (LSR) Line Status Register: (read-only) 3FD
'      Bit 0 = RDA  - input data is available in buffer
'      Bit 1 = OVRN - the input buffer has been overrun
'      Bit 2 = Reserved (Parity error in BIOS INT 14h)
'      Bit 3 = Reserved (Framing error in BIOS INT 14h)
'      Bit 4 = Reserved (Break detect in BIOS INT 14h)
'      Bit 5 = THRE - room is available in output buffer
'      Bit 6 = TSRE - output buffer is empty
'      Bit 7 = Timeout (set by functions 1 and 2 only)
'
' AL = (MSR) Modem Status Register: (read-only) 3FE
'      Bit 0 = Delta clear to send (not reliable)
'      Bit 1 = Delta data set ready (not reliable)
'      Bit 2 = Delta data carrier detect (not reliable)
'      Bit 3 = Always set to 1 upon return (DUMMY DCD)
'      Bit 4 = Clear to send (CTS)
'      Bit 5 = Data set ready (DSR)
'      Bit 6 = Ring indicator (RI)
'      Bit 7 = Data carrier detect (DCD)
'        Note: If MSR is 0ffx then modem is disconnected.
'          If MSR is 00x then modem is offline/turned off. (except bit 3).
'
' (MCR) Modem Control Register: (read/write) 3FC
' (fossil x00 function 1Fx sets/returns in BL)
'      Bits 7-5 = 0 (Reserved)
'      Bit 4    = 1 Loopback mode
'      Bit 3    = 1 OUT2 (interrupts) enabled
'      Bit 2    = 1 OUT1 active
'      Bit 1    = force request-to-send active (RTS)
'      Bit 0    = force data-terminal-ready active (DTR)
'        Note: Lowering the DTR usually lowers the carrier. Lowering the
'          DTR when the modem is turned off still leaves the DTR bit set.
'
' (LCR) Line Control Register: (read/write) 3FB
'      Bit(s)  Description
'      Bit 7 = 1  divisor latch access bit (DLAB) used to set baud.
'            = 0  receiver buffer, transmitter holding, or interrupt enable
'                 register access
'      Bit 6      set break enable. serial ouput is forced to spacing state
'                 and remains there.
'      Bit 5-3    PM2 PM1 PM0
'                   x   x   0 = no parity
'                   0   0   1 = odd parity
'                   0   1   1 = even parity
'                   1   0   1 = high parity (sticky)
'                   1   1   1 = low parity (sticky)
'                   x   x   1 = software parity
'      Bit 2      stop bit length (STB/SBL)
'                   0  one stop bit
'                   1  2 stop bits with (word length 6, 7, 8)
'                   1.5 stop bits with word length 5
'      Bit 1-0    (WLS1-0, CL1-0)
'                   00 word length is 5 bits
'                   01 word length is 6 bits
'                   10 word length is 7 bits
'                   11 word length is 8 bits
'
' -end useful bitfields of modem registers-
