{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'fs_pkg.int'}
{$include: 'datainit.int'}
{$include: 'dlxutil.int'}
{$include: 'dlxinit.int'}

IMPLEMENTATION OF dlxinit;

USES types,globals,utils,fs_pkg,datainit,dlxutil;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}


{***INTERFACE TO THE COM_PAX2 ASYNCHRONOUS COMMUNICATIONS PACKAGE***}
{$include: 'com_pax2.int'}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}

{***Interface to KBD library***}
{$include: 'kbd.int'}

{***Interface to MS Pascal library***}
procedure time(var s : string); EXTERN;
procedure vectin(v : word; procedure i [INTERRUPT]); EXTERN;
function dosxqq(command, parameter: word): byte; EXTERN;
procedure endxqq; EXTERN;

const
  lf = chr(10);
  cr = chr(13);

var
  doseqq [EXTERN]: word;
  com1_port [EXTERN] : word;
  com2_port [EXTERN] : word;
  status_port [EXTERN] : word;
  row0 [EXTERN], col0 [EXTERN], lmc0 [EXTERN] : integer;
  wrap0 [EXTERN] : byte;
  ls_biog,ls_mbx,ls_pbx : lstring(8);
  ls_m1 : lstring(11);
  ls_sdir : lstring(14);
  ls_file : lstring(6);
  ls_req : lstring(9);

value
  ls_biog:='BIOGS';
  ls_mbx:='MAILBOX';
  ls_pbx:='PUB-BOX';
  ls_m1:='MULTIPLE.1';
  ls_sdir:=' subdirectory ';
  ls_file:=' file ';
  ls_req:='required.';

procedure config1;
var
  i : integer;
begin
  fs_init;
  writeln; intl_date;
{NOTE: The following error returns cause an error in a Windows DOS
 box.  They should probably be rewritten to return to the main program
 and do the exit there.  That may save a few bytes too.}
  if jd<2447427 then {IOTTMCO}
    [writeln('Date incorrect.'); doseqq:=4; endxqq];
  if not exist_dir(ls_mbx) then
    [writeln(ls_mbx,ls_sdir,ls_req); doseqq:=4; endxqq];
  if not exist_dir(ls_pbx) then
    [writeln(ls_pbx,ls_sdir,ls_req); doseqq:=4; endxqq];
  if not exist_file(ls_m1) then
    [writeln(ls_m1,ls_file,ls_req); doseqq:=4; endxqq];
  if not exist_dir(ls_biog) then
    [writeln(ls_biog,ls_sdir,ls_req); doseqq:=4; endxqq];
  write('Booting...');
end {config1};

procedure config2;
begin
  mytime.len:=8; time(mytime);
  jt:=      (ord(mytime[1])-ord('0'))*10+(ord(mytime[2])-ord('0'));
  jt:=jt*60+(ord(mytime[4])-ord('0'))*10+(ord(mytime[5])-ord('0'));
  jt:=jt*60+(ord(mytime[7])-ord('0'))*10+(ord(mytime[8])-ord('0'));
  copylst(mytime,oldtime);
  db_open_all;
  if file_dlog<>null then
    mail_delete(file_dlog);
  if file_ulog<>null then
    mail_delete(file_ulog);
  blink:=iattr+128;
  writeln;
end {config2};

procedure send_line_to_modem(vars s : lstring);
var
  i : integer;
begin
  send_ls(s);
  send(cr);
  clock_reset;
  while (clock<50) and (receive<>lf) do allow_break;
end {send_line_to_modem};

procedure receive_line(vars s : lstring);
var
  i : integer;
  ch : char;
begin
  i:=0;
  s[0]:=chr(i);
  clock_reset;
  while true do begin
    while r_count<=0 do 
      if clock>50 then return else allow_break;
    ch:=receive;
    if ch=cr then break;
    i:=i+1;
    s[i]:=ch;
    s[0]:=chr(i);
  end {while};
  while (clock<50) and (receive<>lf) do allow_break;
end {receive_line};

procedure config_comm;
var
  i,j,k : integer;
  str : lstring(long_line);
begin

{make sure sysop is not confused about DigiBoard Com/x card}
  for i:=number_of_lines downto 3 do
    if w^[i].onscreen and then com2_port=16#2f8 and then com1_port=16#3f8 then
      [writeln;
       writeln('PARAMS file not set for DigiBoard Com/x card(s).');
       doseqq:=4; endxqq];

{initialize comm ports}
save_com(1); installc(1);
save_com(2); installc(2);

{initialize each line}
setcp(0,0);
scrollup(gstat*256+0,gstat*256+scm1,gattr,0);
strout(gstat,0,'Initializing serial lines, please wait...');
for i:=number_of_lines downto 0 do begin
  w^[i].active:=w^[i].onscreen;
  w^[i].stat_char:=newpara(null);
  w^[i].stat_attr:=newpara(null);
  w^[i].stat_attr^.msg.len:=screen_cols;
{open full window}
  if w^[i].active then begin
    w^[i].top:=0; w^[i].bot:=screen_rows-3; w^[i].stat:=screen_rows-2;
    w^[i].row:=w^[i].top; w^[i].col:=0; w^[i].lmc:=0;
    if i=0 then [row0:=w^[0].row; col0:=w^[0].col; lmc0:=w^[0].lmc];
    scrollup(w^[i].top*256+0,w^[i].bot*256+scm1,nattr,0);
    scrollup(w^[i].stat*256+0,w^[i].stat*256+scm1,iattr,0);
{initialize variables}
    w^[i].state:=starting;
    w^[i].output:=nill;
    w^[i].node_type:=nt_display;
    w^[i].crud:=false;
    w^[i].connect_sec0:=jt;
    w^[i].chat:=-1;
    w^[i].chatintro:=nill;
    w^[i].bulletin:=nill;
    w^[i].file_locked:=nill; w^[i].rw:=reading;
    w^[i].reset_count:=0;
    w^[i].chat_warned:=false;
    w^[i].more:=0; w^[i].more_crlfs:=0;
    w^[i].pagesize:=defpage-2;
    if w^[i].pagesize<=0 then w^[i].pagesize:=MAXINT;
  end {if};
{initial status line}
  newstat(i,0,iattr,null);
  copylst(ss[36],str); {Line 0:}
  for k:=1 to ord(str.len) do
    if str[k]='0' then
      [str[k]:=chr((i mod 10)+ord('0'));
       if i>9 and then k>1 then str[k-1]:=chr((i div 10)+ord('0'));
       break];
  newstat(i,0,iattr,str);
{initialize modem}
  if w^[i].active then begin
    w^[i].proto:=plain;
    if i>0 then begin {serial line}
      select_port(i);
      for j:=1 to max_retries do begin
        if w^[i].echo then
          case w^[i].baud of
            2400 : w^[i].baud:=1200;
            1200 : w^[i].baud:=300;
             300 : w^[i].baud:=2400;
          end {case};
        open_com(w^[i].baud,'N','1');
        dtr_off;
        clock_reset; while clock<(modem_delay[1] div 2) do allow_break;
        dtr_on;
        clock_reset; while clock<(modem_delay[2] div 2) do allow_break;
        send_line_to_modem(ss[1]); {ATZ}
        if w^[i].row>w^[i].bot then
          [scrollup(w^[i].top*256+0,
	  	    w^[i].bot*256+
		    scm1,
		    nattr,1);
           w^[i].row:=w^[i].bot; w^[i].col:=0];
        strout(w^[i].row,w^[i].col,ss[1]); {ATZ}
        w^[i].row:=w^[i].row+1;
        clock_reset; while clock<(modem_delay[3] div 2) do allow_break;
        receive_line(str);
        if str=null then receive_line(str);
        if w^[i].row>w^[i].bot then
          [scrollup(w^[i].top*256+0,w^[i].bot*256+scm1,nattr,1);
           w^[i].row:=w^[i].bot; w^[i].col:=0];
        strout(w^[i].row,w^[i].col,str);
        w^[i].row:=w^[i].row+1;
        if not eq(str,ss[52]) then cycle; {OK from ATZ}
        w^[i].proto:=hayes;
        if w^[i].baud>w^[i].max_baud then w^[i].max_baud:=w^[i].baud;
        send_line_to_modem(set_modem_cmd);
        if w^[i].row>w^[i].bot then
          [scrollup(w^[i].top*256+0,w^[i].bot*256+scm1,nattr,1);
           w^[i].row:=w^[i].bot; w^[i].col:=0];
        strout(w^[i].row,w^[i].col,set_modem_cmd);
        w^[i].row:=w^[i].row+1;
        clock_reset; while clock<(modem_delay[4] div 2) do allow_break;;
        receive_line(str);
        if str=null then receive_line(str);
        if w^[i].row>w^[i].bot then
          [scrollup(w^[i].top*256+0,w^[i].bot*256+scm1,nattr,1);
           w^[i].row:=w^[i].bot; w^[i].col:=0];
        strout(w^[i].row,w^[i].col,str);
        w^[i].row:=w^[i].row+1;
        if not eq(str,ss[52]) then cycle; {OK}
        dtr_off; {keep callers off until we're ready}
        clock_reset; while clock<(modem_delay[5] div 2) do allow_break;
        scrollup(w^[i].top*256+0,w^[i].bot*256+scm1,nattr,0);
        w^[i].row:=w^[i].top; w^[i].col:=0; w^[i].lmc:=0;
        break;
      end {modem retries};
      if w^[i].proto=plain then
        [if w^[i].echo then
           [w^[i].baud:=9600; w^[i].max_baud:=9600];
         open_com(w^[i].baud,'N','1');
         scrollup(w^[i].top*256+0,w^[i].bot*256+scm1,nattr,0)];
      w^[i].talking_to:=modem; w^[i].dismiss:=false;
      w^[i].strx:=null; w^[i].wrapat:=wrap_column; wrap(w^[i].wrapat-5);
      newstat(i,ord(ss[36].len)+1,iattr,ss[3]); {Waiting}
    end else begin {keyboard}
      row0:=w^[0].row; col0:=w^[0].col; lmc0:=w^[0].lmc;
      w^[0].wrapat:=wrap_column; wrap0:=wrd(w^[0].wrapat);
      installh; setcp(w^[0].row,w^[0].col);
      newstat(0,ord(ss[36].len)+1,iattr,ss[3]); {Waiting}
    end {if};
  end {if active} else
    newstat(i,ord(ss[36].len)+1,iattr,ss[2]); {Inactive}
end {for lines};
scrollup(gstat*256,gstat*256+scm1,nattr,1);

end {config_comm};

END.
