/************************************************************************/
/*                              netitl.c                                */
/*                                                                      */
/*                 Handles ITL layer of C86Net                          */
/************************************************************************/

/************************************************************************/
/*                              history                                 */
/*                                                                      */
/* 88Dec23 <br> remove WXMODEM											*/
/* 88Jul01 HAW  Fix bug from excess EOTs generated by WXMODEM.          */
/* 88Jun22 HAW  WXMODEM as primary transmission medium.                 */
/* 88Apr09 HAW  Created.                                                */
/************************************************************************/

#include "ctdl.h"

/************************************************************************/
/*                              contents                                */
/*                                                                      */
/*      ITL_DeInit()            DeInitialize the ITL layer              */
/*      ITL_InitCall()          Initialize the ITL layer                */
/*      ITL_optimize()          Optimize the ITL layer                  */
/*      ITL_Receive()           Sets up to receive an ITL transmission  */
/*      ITL_Rec_Optimize()      Receive attempt to optimize layer       */
/*      ITL_Send()              Manages ITL transmissions               */
/*      increment()             Handles writing to the internal buf     */
/*      sendITLchar()           Sends a char at the ITL level           */
/************************************************************************/

/************************************************************************/
/*                 External variable declarations in NETITL.C           */
/************************************************************************/
static int ITL_protocol;
static int InternalCounter;

extern AN_UNSIGNED RecBuf[];
extern int         TransProtocol;
extern char        ErrBuf[100];
extern FILE        *netLog;

/************************************************************************/
/*      ITL_DeInit() Deactivate the ITL at end of Net Period            */
/************************************************************************/
void ITL_DeInit()
{
    TransProtocol = ASCII;
}

/************************************************************************/
/*      ITL_InitCall() Initialize for either caller or receiver         */
/************************************************************************/
void ITL_InitCall()
{
	purgeFossilBuffs(); /* a hopefull tweak for highspeed net */
/*  f_purgeo(port);      part of "fix?" for highspeed net   */
    ITL_protocol = XMDM;        /* Init to XMODEM. */
}

/************************************************************************/
/*      ITL_Receive() Sets up to receive an ITL transmission            */
/************************************************************************/
char ITL_Receive(FileName, ReplyFirst)
char *FileName;         /* If this is NULL or length = 0, then ITL data */
                        /* should be placed in an internal buffer       */
char ReplyFirst;        /* Should we do a reply(GOOD) call first?       */
{
    extern char *WRITE_ANY;
    extern FILE *upfd;

/*    while (MIReady()) inp(); ** K2NE TEST ON MAY 25 1993
                                This was part of the old code which I
								re-enabled just to see if it helped our
								problem with one of our high speed net
								nodes - it didn't - you can't fix line
								noise from software! */
	purgeFossilBuffs();
    if (FileName == NULL || strLen(FileName) == 0) {
        if (ReplyFirst) reply(GOOD, "");
        InternalCounter = 0;
                /* This is temporary until we get WXMODEM available */
        if (Reception(ITL_protocol, increment) == TRAN_SUCCESS) {
            return ITL_SUCCESS;
    	    }
        else {
            killConnection();
            return ITL_BAD_TRANS;
        	}
    	}
    if ((upfd = safeopen(FileName, WRITE_ANY)) == NULL) {
/*        Handle an error at this point. */
        if (ReplyFirst) reply(BAD, "System error");
        sPrintf(ErrBuf, "Couldn't open %s!", FileName);
        netResult(ErrBuf);
        return ITL_NO_OPEN;
    	}

    if (ReplyFirst) reply(GOOD, "");

    if (Reception(ITL_protocol, putFLChar) != TRAN_SUCCESS) {
        fclose(upfd);
        unlink(FileName);
        killConnection();

        return ITL_BAD_TRANS;
    	}
    else {
        fclose(upfd);
        return ITL_SUCCESS;
   	 	}
}

/************************************************************************/
/*      ITL_rec_optimize() receive attempt to optimize                  */
/************************************************************************/
void ITL_rec_optimize(cmds)
struct cmd_data *cmds;
{
    int protocol;

    protocol = atoi(cmds->fields[0]);
    if (protocol < 0 || protocol > 2)
        reply(BAD, "unrecognized protocol");
    else {      /* this is probably bad coding, really. */
        reply(GOOD, "");
        ITL_protocol = protocol + 1;    /* translates correctly for now */
    }
}

/************************************************************************/
/*      ITL_Send() Manages ITL transmissions                            */
/************************************************************************/
char ITL_Send(mode)
char mode;
{
    int reason;

    if ((reason = Transmission(ITL_protocol, mode)) != TRAN_SUCCESS) {
/*  splitF(netLog, "Transport:  ITL_send failure: %d\n", reason); */
	splitF(netLog, "Transport: %s\n",
		reason == 2 ? "CANCEL sent by remote node" :
		reason == 3 ? "Protocol initialization failed" :
/*		"Fatal error at network layer"); */
        "Remote node sent disconnect");



        killConnection();
        return FALSE;
    }
    return TRUE;
}

/************************************************************************/
/*      sendITLchar(c) sends a single character via ITL                 */
/************************************************************************/
char sendITLchar(c)
int c;
{
    extern PROTO_TABLE Table[];

    return (*Table[TransProtocol].method)(c);
}

/************************************************************************/
/*      increment()                                                     */
/************************************************************************/
static int increment(c)
int c;
{
    RecBuf[InternalCounter++] = c;
    if (InternalCounter > SECTSIZE+2) {
        killConnection();
        return FALSE;
    }
    return TRUE;
}
