echo OFF
REM Two variables are passed to this batch process from Citadel:K2NE...
REM
REM The first variable is the PROTOCOL TYPE and causes the branch
REM to the proper section of this handler file.
REM
REM The second variable is the BAUDrate for those protocol drivers
REM which require that information.
REM
REM The third variable is the FILENAME.EXT, and this is the variable
REM which is used to either INSERT an incoming file or DOWNLOAD an
REM existing file.  Citadel passes this variable as an ordinary string.
REM Should the user be engaged in a BATCH download, this may actually
REM occupy more than one variable on the BATCHfile command line.
REM For example, if a 1200 baud user is using YMODEM to download
REM FILE1.TXT and FILE2.EXE, then the batchfile command line will be
REM
REM XFERCTL.BAT YMOSEND 1200 FILE1.TXT FILE2.EXE
REM
REM For this reason, all of the BATCH download areas in this file (XFERCTL)
REM will have a total of FIVE additional parameters in place.  If you wish
REM to allow your users to BATCH download more than five unambiguous files
REM at a clip, just add more variable slots.
REM
REM Error handling is ABSOLUTELY ESSENTIAL for incoming
REM files.  The error handling assumes that the external protocol driver
REM returns an exit level greater than one if something went wrong
REM during an upload.  This is the ONLY restriction.  You are free to
REM use WHATEVER external protocol driver you choose but you MUST modify
REM this file to conform with the command line syntax that your protocol
REM drivers are expecting to see.  As we provide this file to you it is
REM set up for use with DSZ.COM and JMODEM.COM however you can change
REM this if you prefer.
goto %1

:xmocrecv
REM xmodem crc receive file section
REM dsz port 2 *** activate this line if on COM2
dsz rc %3
if ERRORLEVEL 1 del %3
goto end

:xmorecv
REM standard checksum xmodem receive file section
REM dsz port 2 *** activate this line if on COM2
dsz rx %3
if ERRORLEVEL 1 del %3
goto end

:ymorecv
REM ymodem single-file receive file section
REM dsz port 2 *** activate this line if on COM2
dsz 2 rx -k %3
if ERRORLEVEL 1 del %3
goto end

:wxmorecv
REM Windowed-Xmodem receive file section
REM superk p2 s%2 tW dR f%3 *** activate this line if on COM2
superk p1 s%2 tW dR f%3
del superk.log
if ERRORLEVEL 1 del %3
goto end

:jmorecv
REM jmodem receive file section
REM syntax is jmodem rYOUR-COMPORT-NUMBER FILENAME.EXT so for
REM com2 it would be jmodem r2 etc
jmodem r1 %3
if ERRORLEVEL 1 del %3
goto end

:zmorecv
REM zmodem receive file section
REM dsz port 2 *** activate this line if on COM2
dsz rz %3
if ERRORLEVEL 1 del %3
goto end

:kermrecv
REM kermit receive file section
REM kermit receive %2
echo Not yet available. >com1
echo Not yet available.
REM if ERRORLEVEL 1 del %2
goto end

:xmosend
REM xmodem transmit file section
REM we assume the handler starts with CRC and flips to CKSUM automatically
REM dsz port 2 *** activate this line if on COM2
dsz sx %3
goto end

:ymosend
REM ymodem transmit file section
REM rather arcane syntax of dsz forces the -k for 1Kbyte packets
REM dsz port 2 *** activate this line if on COM2
dsz sb -k %3 %4 %5 %6 %7
goto end

:wxmosend
REM Windowed-Xmodem transmit file section
REM superk p2 s%3 tW dS f%2 *** activate this line if on COM2
superk p1 s%2 tW dS f%3
del superk.log
goto end

:zmosend
REM zmodem transmit file section
REM if the BBS supports batches it is passed thru in the variable
REM dsz port 2 *** activate this line if on COM2
dsz sz %3 %4 %5 %6 %7
goto end

:jmosend
REM jmodem transmit file section
REM see the 'jmorecv' block for syntax involving your com port number
jmodem s1 %3
goto end

:kermsend
REM kermit transmit file section
REM kermit send %2
echo Not yet available. >com1
echo Not yet available.
goto end

:end
echo .
echo Returning to BBS...
REM And that is all there is to it!  So much for the Midwest chickenshit
REM objections about being 'forced to spend money' for protocol handlers...
