// --------------------------------------------------------------------------
// Citadel: ZipFile.CPP
//
// Archive file handling routines.

#include "ctdl.h"
#pragma hdrstop

#include "filecmd.h"
#include "room.h"
#include "msg.h"
#include "log.h"
#include "aplic.h"

// --------------------------------------------------------------------------
// Contents
//
// readzip()			menu level .rz HIGH level routine


// --------------------------------------------------------------------------
// readArchive(): Menu level .rz HIGH level routine.

void readArchive(OldNewPick which)
	{
	int i;
	int entries = 0;
	label filename;
	archivers *theArc;

	SetDoWhat(READZIP);

	if (!changedir(GetCurrentRoomDirectory()))
		{
		return;
		}

	const int ich = iCharNE();

	for (theArc = arcList; theArc; theArc = (archivers *) getNextLL(theArc))
		{
		if (tolower(ich) == tolower(theArc->name[0]))
			{
			mPrintf(pcts, theArc->name);
			break;
			}
		}

	if (theArc)
		{
		doCR();
		if (!getNormStr(getmsg(1073), filename, LABELSIZE, ECHO))
			{
			return;
			}

		if (!filename[0])
			{
			sprintf(filename, getmsg(1583), theArc->ext);
			}

		if (!strchr(filename, '.'))
			{
			strcat(filename, getmsg(1433));
			strcat(filename, theArc->ext);
			}

		if (which != OldAndNew)
			{
			if (!getNewOldFileDate())
				{
				return;
				}
			}

		directoryinfo *files = filldirectory(filename, TI()MRO.Date ? 2 : 1,
				which, TI()MRO.Reverse);

		if (files)
			{
			for (i = 0; files[i].name[0]; ++i);
			entries = i;

			for (i = 0; i < entries && !TI()UserControl.CheckInput(FALSE) &&
					(TI()UserControl.GetOutFlag() != OUTSKIP); i++)
				{
				RunApplication(theArc->view, files[i].name, TRUE, FALSE);
				changedir(GetCurrentRoomDirectory());

				if (TI()MRO.DotoMessage == REVERSE_READ)
					{
					TI()MRO.DotoMessage = NO_SPECIAL;
					TI()UserControl.SetOutFlag(OUTOK);

					TI()MRO.Reverse = !TI()MRO.Reverse;
					qsort(files, i, sizeof(*files),
						(TI()MRO.Reverse) ? (QSORT_CMP_FNP) revstrcmp
									: (QSORT_CMP_FNP) fwdstrcmp);
					CRmPrintfCR(getmsg(1017), (!TI()MRO.Reverse) ? '+' : '-');
					i = entries - i - 1;
					}
				}

			if (!i)
				{
				CRmPrintfCR(getmsg(1050), filename);
				}

			delete [] files;
			}

		char TrapString[256];
		sprintf(TrapString, getmsg(73), filename, GetRoomName(TI()thisRoom));

		trap(TrapString, T_DOWNLOAD);
		}
	else
		{
		oChar(ich);

		if (ich != '?')
			{
			mPrintf(sqst);
			}

		if (!TI()CurrentUser->IsExpert() || ich == '?')
			{
			doCR(2);

			for (theArc = arcList; theArc; theArc = (archivers *) getNextLL(theArc))
				{
				mPrintfCR(getmsg(74), *(theArc->name), (theArc->name + 1));
				}

			mPrintfCR(getmsg(76));
			}
		}

	changedir(cfg.homepath);
	}
