// --------------------------------------------------------------------------
// Citadel: Window.CPP
//
// Machine-dependent console routines.

#ifndef WINCIT
#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "log.h"
#include "music.h"
#include "account.h"
#include "hall.h"
#include "scrlback.h"
#include "cwindows.h"
#include "miscovl.h"
#include "term.h"


// --------------------------------------------------------------------------
// Contents
//
// scroll() 			scrolls window up
// update25()			updates the 25th line
// bioschar()			BIOS print char with attr
// biosstring() 		BIOS print string w/attr at row
// position()			Set logical cursor position
// readpos()			Read logical cursor position

extern ConsoleLockC ConsoleLock;


void scroll_bios(int row, uchar howmany, uchar attr)
	{
	union REGS regs;
	int rw, col;

	readpos(&rw, &col);

	regs.h.al = howmany;		// scroll how many lines

	regs.h.cl = 0;				// row # of upper left hand corner
	regs.h.ch = 0;				// col # of upper left hand corner
	regs.h.dh = (uchar) row;	// row # of lower left hand corner
	regs.h.dl = (uchar)
				(conCols-1);	// col # of lower left hand corner

	regs.h.ah = 0x06;			// scroll window up interrupt
	regs.h.bh = attr;			// char attribute for blank lines

	int86(0x10, &regs, &regs);

	// put cursor back
	position(rw, col);
	}

static void scroll_fast(int row, uchar howmany, uchar attr)
	{
	fastcpy(TI()logiScreen, TI()logiScreen + howmany * conCols * 2,
			(row - howmany + 1) * conCols * 2);

	fastsetw(TI()logiScreen + ((row - howmany + 1) * conCols << 1),
			attr << 8, howmany * conCols);

	if (CitWindowsVid)
		{
		CitWindowsTTYUpdate(0, scrollpos);
		}
	}

// --------------------------------------------------------------------------
// scroll(): Scrolls window up from specified line.
//
// Input:
//	int row: Where to stop scrolling at (always starts at top of screen)
//	uchar howmany: How many to scroll
//	uchar attr: Attribute to scroll in

void scroll(int row, uchar howmany, uchar attr)
	{
	if (cfg.scrollSize)
		{
		SaveToScrollBackBuffer(howmany);
		}

	if (!cfg.bios || ScreenSaver.IsOn() || StatusLine.IsFullScreen() ||
			allWindows)
		{
		scroll_fast(row, howmany, attr);
		}
	else
		{
		scroll_bios(row, howmany, attr);
		}
	}


// --------------------------------------------------------------------------
// biosstring(): Print a string with attribute.
//
// Input:
//	uint row: Where to print it
//	const char *str: What to print
//	ucahr attr: What attribute to use
//	Bool phys: TRUE to force output to the physical screen; FALSE to send
//		output to the logical screen.

void cdecl biosstring(uint row, const char *str, uchar attr, Bool phys)
	{
	union REGS regs;
	union REGS temp_regs;
	register int i=0;

	if (!ScreenSaver.IsOn() && !StatusLine.IsFullScreen() && !allWindows)
		{
		regs.h.ah = 9;			// service 9, write character & attribute
		regs.h.bl = attr;		// character attribute
		regs.x.cx = 1;			// number of character to write
		regs.h.bh = 0;			// display page

		while (str[i])
			{
			position(row, i);	// Move cursor to the correct position
			regs.h.al = str[i]; // set character to write with 0x09
			int86(0x10, &regs, &temp_regs);
			i++;
			}
		}
	else
		{
		directstring(row, str, attr, phys);
		}
	}


// --------------------------------------------------------------------------
// bioschar(): Print a char with attribute.
//
// Input:
//	char ch: The character to output
//	uchar attr: The attribute to use
//	Bool phys: TRUE to force output to the physical screen; FALSE to send to
//		the logical streen
//
// Return value:
//	TRUE: Ran out of space on the current line
//	FALSE: Still have room on the current line

Bool cdecl bioschar(char ch, uchar attr, Bool phys)
	{
	int row, col;
	union REGS regs;

	if (!ScreenSaver.IsOn() && !StatusLine.IsFullScreen() && !allWindows)
		{
		regs.h.ah = 9;			// service 9, write char & attribute
		regs.h.bl = attr;		// character attribute
		regs.h.al = ch; 		// char to write
		regs.x.cx = 1;			// write 1 character
		regs.h.bh = 0;			// display page
		int86(0x10, &regs, &regs);

		readpos(&row, &col);
		if (++col == conCols)
			{
			return (TRUE);
			}
		else
			{
			return (FALSE);
			}
		}
	else
		{
		return (directchar(ch, attr, phys));
		}
	}


// --------------------------------------------------------------------------
// ansi(): Handle ansi and music escape sequences.
//
// Input:
//	char c: The character we are outputing

void ansi(char c)
	{
	uchar argc, a[5];

	if (c == ESC)
		{
		TI()ANSIargs[0] = 0;
		TI()ANSIfirst = TRUE;
		TI()OC.inANSI = TRUE;
		return;
		}

	if (TI()ANSIfirst)
		{
		TI()ANSIfirst = FALSE;

		if (c == '[')
			{
			TI()OC.inANSI = TRUE;
			return;
			}
		else
			{
			char str[2];

			TI()OC.inANSI = FALSE;

			putCode("");
			str[0] = c;
			str[1] = 0;
			return;
			}
		}

	if (TI()ANSIisSound && c == 14) 	// 14 is end of sound: ''
		{
		TI()ANSIisSound = FALSE;
		TI()OC.inANSI = FALSE;
		playSound(TI()ANSIargs);
		}
	else if (isalpha(c) && !TI()ANSIisSound) // if not sound, alpha ends ANSI
		{
		if (!*TI()term.bold && c != 'M')
			{
			TI()OC.inANSI = FALSE;
			return;
			}

		for (argc = 0; argc < 5; ++argc)
			{
			a[argc] = 0;
			}

		argc = 0;
		char *p = TI()ANSIargs;

		while (*p && (argc < 5))
			{
			if (isdigit(*p))
				{
				a[argc] = (uchar) atoi(p);
				p++;
				if (a[argc] > 9)
					{
					p++;
					if (a[argc] > 99)
						{
						p++;
						}
					}
				argc++;
				}
			else
				{
				p++;
				}
			}

		//							   row, col
		// ANSI:				origin= 1 ,  1
		// position/readpos:	origin= 0 ,  0
		// numLines/CrtColumn:	origin= 0 ,  1

		switch (c)
			{
			case 'M':           // Sound stuff
				{
				TI()ANSIisSound = TRUE;
				TI()OC.inANSI = TRUE;
				return;
				}

			case 'J':           // cls
				{
				TI()numLines = 0;
				TI()OC.CrtColumn = 1;

				cls(SCROLL_SAVE);
				StatusLine.Update();
				break;
				}

			case 'K':           // del to end of line
				{
				ClearToEndOfLine();
				break;
				}

			case 'n':           // auto ansi detect
				{
				if (a[0] == 6)
					{
					outstring("[Z");
					}
				break;
				}

			case 'm':           // color
				{
				for (int i = 0; i < (int)argc; i++)
					{
					switch (a[i])
						{
						case 5: // Blink
							{
							TI()OC.ansiattr = (uchar) (TI()OC.ansiattr | 128);
							TI()ANSIblink = TRUE;
							break;
							}

						case 4: // Underline
							{
							TI()OC.ansiattr = (uchar)(TI()OC.ansiattr | 1);
							break;
							}

						case 7: // Reverse Video
							{
							TI()OC.ansiattr = 0x70;
							if (TI()ANSIhilight)
								{
								TI()OC.ansiattr = (uchar) (TI()OC.ansiattr | 8); // Bold
								}

							if (TI()ANSIblink)
								{
								TI()OC.ansiattr = (uchar) (TI()OC.ansiattr | 128);// Blink
								}

							break;
							}

						case 0: // Default
							{
							TI()OC.ansiattr = 7;
							TI()ANSIblink = FALSE;
							TI()ANSIhilight = FALSE;
							break;
							}

						case 1: // Bold
							{
							TI()OC.ansiattr = (uchar) (TI()OC.ansiattr | 8);
							TI()ANSIhilight = TRUE;
							break;
							}

						default:
							{
							// Set the background
							if (a[i] >= 40 && a[i] <= 47)
								{
								TI()OC.ansiattr = (uchar) ((TI()OC.ansiattr & 0x0F) |
										((iso_clr[a[i]-40]) << 4) |
										(TI()ANSIblink ? 0x80 : 0));
								}

							// Set the foreground
							if (a[i] >= 30 && a[i] <= 37)
								{
								TI()OC.ansiattr = (uchar) ((TI()OC.ansiattr & 0xF0) |
										((iso_clr[a[i]-30]) |
										(TI()ANSIhilight ? 0x08 : 0)));
								}
							break;
							}
						}
					}
				break;
				}

			case 's':           // save cursor
				{
				readpos(&TI()ANSIc_x, &TI()ANSIc_y);
				break;
				}

			case 'u':           // restore cursor
				{
				TI()numLines = TI()ANSIc_x;
				TI()OC.CrtColumn = TI()ANSIc_y + 1;

				position(TI()ANSIc_x, TI()ANSIc_y);
				break;
				}

			case 'A':
				{
				int x, y;

				readpos(&x, &y);

				x -= (argc ? a[0] : 1);

				// if (i >= 0) { x = (uchar) i; }
				if (x < 0)
					{
					x = 0;
					}

				TI()numLines = x;	// don't subtract

				position(x, y);
				break;
				}

			case 'B':
				{
				int x, y;

				readpos(&x, &y);

				x += (argc ? a[0] : 1);

				// if (i < (int) conRows)	{ x = (uchar) i; }
				if (x > conRows - 1)
					{
					x = conRows - 1;
					}

				TI()numLines = x;

				position(x, y);
				break;
				}

			case 'D':
				{
				int x, y;

				readpos(&x, &y);

				y -= (argc ? a[0] : 1);

				// if (i >= 0)	{ y = (uchar) i; }
				if (y < 0)
					{
					y = 0;
					}

				TI()OC.CrtColumn = y + 1;

				position(x, y);
				break;
				}

			case 'C':
				{
				int x, y;

				readpos(&x, &y);

				y += (argc ? a[0] : 1);

				// if (i < (int) conCols) { y = (uchar) i; }
				if (y > conCols - 1)
					{
					y = conCols - 1;
					}

				TI()OC.CrtColumn = y + 1;

				position(x, y);
				break;
				}

			case 'f':
			case 'H':
				{
				if (!argc)
					{
					TI()numLines = 0;
					TI()OC.CrtColumn = 1;
					position(0, 0);
					break;
					}

				if (argc == 1)
					{
					if (TI()ANSIargs[0] == ';')
						{
						a[1] = a[0];
						a[0] = 1;
						}
					else
						{
						a[1] = 1;
						}

					argc = 2;
					}

				if (argc == 2)
					// && a[0] < (uchar) (conRows+1) && a[1] < conCols)
					{
					int x = a[0] - 1, y = a[1] - 1; // match position

					if (x < 0)
						{
						x = 0;
						}
					else if (x > scrollpos - 1) 	// for status line
						{
						x = scrollpos - 1;
						}

					if (y < 0)
						{
						y = 0;
						}
					else if (y > conCols - 1)
						{
						y = conCols - 1;
						}

					TI()numLines = x;
					TI()OC.CrtColumn = y + 1;

					position(x, y);
					break;
					}
				}

			default:
				{
#ifdef GOODBYE
				if (debug)
					{
					sprintf(temp, "%s%c", TI()ANSIargs, c);

					sprintf(str,
							"Ansi Code: [%-15s Args: (%d) [%02d %02d %02d %02d %02d]",
							temp, argc, a[0], a[1], a[2], a[3], a[4]);

					(*stringattr)(0, str, cfg.wattr);
					}
#endif
				break;
				}
			}

#ifdef GOODBYE
		if (debug)
			{
			sprintf(temp, "%s%c", TI()ANSIargs, c);

			sprintf(str,
					"Ansi Code: [%-15s Args: (%d) [%02d %02d %02d %02d %02d]",
					temp, argc, a[0], a[1], a[2], a[3], a[4]);

			(*stringattr)(0, str, cfg.wattr);
			}
#endif

		TI()OC.inANSI = FALSE;

		if (TI()CurrentUser->IsIBMANSI())
			{
			char str[2];

			putCode("[");
			putCode(TI()ANSIargs);

			str[0] = c;
			str[1] = 0;
			putCode(str);
			}
		}
	else if (TI()OC.inANSI)
		{
		int i = strlen(TI()ANSIargs);

		if (i < ANSILEN - 1)
			{
			TI()ANSIargs[i] = c;
			TI()ANSIargs[i+1] = '\0';
			}
		else
			{
			// cPrintf("Ansi code too long\n")
			TI()ANSIargs[i]= '\0';
			}
		}
	}


// --------------------------------------------------------------------------
// StatusLineC::Update: updates status line, lines, or screen
void StatusLineC::Update(void)
	{
	static int tcRow = -1, tcCol = -1, tcClr;
	static long tcLast;

	if (ScreenSaver.IsOn())
		{
		/*				   Ѹ	 ͸
		update the way cool urbo	it clock that is now in
								 ;
				Ŀ					     Ŀ
							Ŀ  	      			  
					   Ŀ	    ÿ  ڴ    		   
					Ŀ 	  ٳ    			  
					  			       			  
				 	  	     		  
		*/

		if (cfg.turboClock)
			{
			label ClockString;
			static int Len;
			long tcurrent = time(NULL);
			Bool j = tcurrent >= tcLast + cfg.turboClock;

			if (tcRow >= 0 && tcCol >= 0)
				{
				if (j && tcLast)
					{
					sprintf(ClockString, getmsg(1541), ns);
					ClockString[Len] = 0;
					statDisp(tcRow, tcCol, cfg.attr & 0x0f, ClockString);
					}
				}
			else
				{
				j = TRUE;
				}

			if (tcurrent > tcLast)
				{
				if (*cfg.SaverMsg)
					{
					strcpy(ClockString, cfg.SaverMsg);
					}
				else
					{
					strftime(ClockString, 30, getmsg(1311), 0l);
					}

				Len = strlen(ClockString);

				if (j)
					{
					tcRow = (int) ((long) conRows * (long) rand()
							/ (long) RAND_MAX);
					tcCol = (int) ((long) (conCols - Len) * (long) rand()
							/ (long) RAND_MAX);

					do
						{
						tcClr = (int) (128l * (long) rand()
								/ (long) RAND_MAX);
						} while ((tcClr & 0x0ff) == (tcClr >> 8));

					time(&tcLast);
					}

				statDisp(tcRow, tcCol, tcClr, ClockString);
				}
			}
		}
	else
		{
		Bool TurnedCursorOff = FALSE;
		tcLast = 0; // so it displays immediately next time blanked

		if (!Visible)
			{
			return;
			}

		int row, col;
		readpos(&row, &col);

		if (cfg.bios && !StatusLine.IsFullScreen() && !allWindows)
			{
			cursoff();
			TurnedCursorOff = TRUE;
			}

		if (HelpTimeout)
			{
			if (HelpTimeout < (time(NULL) - (long) (60 * 2)))
				{
				ToggleHelp();
				}
			else
				{
				char bigline[81];

				strcpy(bigline, getmsg(126));

				(*stringattr)(conRows - 4, bigline, cfg.wattr, TRUE);

				sprintf(bigline, getmsg(128), getmsg(14), getmsg(22),
						getmsg(23),
						StatusLine.IsFullScreen() ? getmsg(25) : getmsg(24),
						onConsole ? getmsg(26) : getmsg(27));

				(*stringattr)(conRows - 3, bigline, cfg.wattr, TRUE);

				sprintf(bigline, getmsg(128), getmsg(28),
						cfg.noBells ?
						(cfg.noBells == 1 ? getmsg(30) : getmsg(963)) :
						getmsg(31), getmsg(32),
						cfg.noChat ? getmsg(33) : getmsg(34), getmsg(35));

				(*stringattr)(conRows - 2, bigline, cfg.wattr, TRUE);

				strcpy(bigline, getmsg(129));

				(*stringattr)(conRows-1, bigline, cfg.wattr, TRUE);

				position(row >= scrollpos ? scrollpos : row, col);
				}
			}

		if (State == SL_FULLSCREEN)
			{
			showStatScreen();
			}

		if (State == SL_TWOLINES)
			{
			label hallname;
			strcpy(hallname,
					deansi(HallData->GetEntry(TI()thisHall)->GetName()));

			label roomname;
			strcpy(roomname, deansi(GetRoomName(TI()thisRoom)));

			char Clock[15];
			strftime(Clock, 14, conCols > 90 ? getmsg(1584) : getmsg(372), 0);

			char str[200];
			sprintf(str, getmsg(518), hallname, roomname, Clock);

			int Max = min((int) conCols, sizeof(str));
			for (int i = strlen(str); i < Max; i++)
				{
				strcat(str, spc);
				}

			(*stringattr)(scrollpos + 1, str, cfg.wattr, TRUE);
			}

		// The first line...

		label name;
		if (TI()loggedIn)
			{
			CopyStringToBuffer(name, deansi(TI()CurrentUser->GetName()),
					LABELSIZE);

			const int Limit = (30 - strlen(name)) / 2;

			for (int i = 0; i < Limit; i++)
				{
				strcat(name, spc);
				}
			}
		else
			{
			strftime(name, 30, getmsg(1312), 0l);
			}

		const char *carr = SerialPort.HaveCarrier() ? getmsg(1649) : getmsg(1650);

		char flags[10];
		CopyStringToBuffer(flags, getmsg(1651), sizeof(flags) - 1);

		if (TI()CurrentUser->IsAide())		flags[0] = getmsg(1652)[0];
		if (TI()CurrentUser->IsProblem())	flags[1] = getmsg(1652)[1];
		if (TI()CurrentUser->IsPermanent()) flags[2] = getmsg(1652)[2];
		if (TI()CurrentUser->IsNetUser())	flags[3] = getmsg(1652)[3];
		if (TI()CurrentUser->IsUnlisted())	flags[4] = getmsg(1652)[4];
		if (TI()CurrentUser->IsSysop()) 	flags[5] = getmsg(1652)[5];
		if (!TI()CurrentUser->IsMail()) 	flags[6] = getmsg(1652)[6];

		char tmleft[5];
		if (!cfg.accounting || !TI()CurrentUser->IsAccounting() ||
				!TI()loggedIn)
			{
			CopyStringToBuffer(tmleft, getmsg(1653), sizeof(tmleft) - 1);
			}
		else
			{
			if (TI()CurrentUserAccount->IsSpecialTime())
				{
				CopyStringToBuffer(tmleft, getmsg(1654), sizeof(tmleft) - 1);
				}
			else
				{
				long Minutes = TI()CurrentUser->GetCredits() / 60;

				if (Minutes > 9999)
					{
					CopyStringToBuffer(tmleft, getmsg(1601),
							sizeof(tmleft) - 1);
					}
				else
					{
					sprintf(tmleft, getmsg(1551), Minutes);
					}
				}
			}

		long rspeed;
		if (SerialPort.HaveCarrier() && TI()DoWhat != DIALOUT)
			{
			rspeed = connectbauds[TI()ModemSpeed];
			}
		else
			{
			rspeed = bauds[TI()SerialPort.GetSpeed()];
			}

		char displaybaud[10];
		if (rspeed == 12000)
			{
			CopyStringToBuffer(displaybaud, getmsg(1655),
					sizeof(displaybaud) - 1);
			}
		else if (rspeed == 14400)
			{
			CopyStringToBuffer(displaybaud, getmsg(1656),
					sizeof(displaybaud) - 1);
			}
		else if (rspeed == 16800)
			{
			CopyStringToBuffer(displaybaud, getmsg(1657), 
					sizeof(displaybaud) - 1);
			}
		else if (rspeed == 19200)
			{
			CopyStringToBuffer(displaybaud, getmsg(1658), 
					sizeof(displaybaud) - 1);
			}
		else if (rspeed == 28800)
			{
			CopyStringToBuffer(displaybaud, getmsg(1659), 
					sizeof(displaybaud) - 1);
			}
		else if (rspeed == 38400l)
			{
			CopyStringToBuffer(displaybaud, getmsg(1660), 
					sizeof(displaybaud) - 1);
			}
		else if (rspeed == 57600l)
			{
			CopyStringToBuffer(displaybaud, getmsg(1661), 
					sizeof(displaybaud) - 1);
			}
		else if (rspeed == 115200l)
			{
			CopyStringToBuffer(displaybaud, getmsg(1662), 
					sizeof(displaybaud) - 1);
			}
		else if (rspeed == 230400l)
			{
			CopyStringToBuffer(displaybaud, getmsg(1663), 
					sizeof(displaybaud) - 1);
			}
		else
			{
			sprintf(displaybaud, getmsg(1552), rspeed);
			}

		char string[200];
		sprintf(string, getmsg(36), name,
				onConsole ? getmsg(934) : getmsg(935),
				carr, displaybaud, tmleft,
				getmsg(1664)[TI()SerialPort.IsDisabled() ? 0 : 1],

				(sysMail)					? '' : ' ',

				(cfg.noBells) ?
						(cfg.noBells == 1 ? '\r' : ' ') : '',

				(TI()OC.Psycho) 			? '' : ' ',
				(debug) 					? '' : ' ',
				(ConsoleLock.IsLocked(TRUE))? '' : ' ',
				(cfg.ignore_uptime) 		? '' : ' ',

				(cfg.noChat) ? (TI()chatReq ? getmsg(1665) : getmsg(1666)) :
								(TI()chatReq ? getmsg(1667) : getmsg(1668)),

				(TI()OC.Printing)			? getmsg(1669) : getmsg(1670),
				(sysReq)					? getmsg(1671) : getmsg(1670),

				flags);

		int Max = min((int) conCols, sizeof(string));
		for (int i = strlen(string); i < Max; i++)
			{
			strcat(string, spc);
			}

		(*stringattr)(conRows, string, cfg.wattr, TRUE);

		// flashy stuff
		if (TI()chatReq)
			{
			char *poo = TI()logiScreen + ((conCols * conRows) << 1) + 121;

			for (i = 0; i < 4; i++, poo += 2)
				{
				*poo = *poo | 0x80;
				}
			}

		position(row, col);

		if (TurnedCursorOff)
			{
			curson();
			}
		}
	}

void position(int row, int column)
	{
	TI()logiRow = row;
	TI()logiCol = column;

	dgLogiRow = row;
	dgLogiCol = column;

	if (!CitWindowsCsr)
		{
		physPosition((char) row, (char) column);
		}
	}

void readpos(int *row, int *column)
	{
	*row = TI()logiRow;
	*column = TI()logiCol;
	}

void ScreenSaverC::Check(void)
	{
	if (
			// It's allowed to turn on and...
			MayTurnOn &&

			// we are configured to turn on and...
			cfg.screensave &&

			// we are not on now and...
			!On &&

			// It is not
			!(
				// configured to stay off while user is on and...
				cfg.really_fucking_stupid &&

				// have carrier or user is on console
				(
				TI()modStat ||
				(onConsole && TI()loggedIn)
				)
			)

			// And we are not in the scroll-back buffer and...
			&& (TI()DoWhat != SCROLLBACK) &&

			// ...
			(
				// the time since last updated
				((time(NULL) - Timer) / (time_t) 60)

				// is greater than or equal to our timeout
				>= (time_t) cfg.screensave
			)
		)
		{
		TurnOn();
		}
	}
#endif
