// --------------------------------------------------------------------------
// Citadel: ViewLog.CPP
//
// View log entries.

#include "ctdl.h"
#pragma hdrstop

#include "viewlog.h"
#include "log.h"
#include "group.h"
#include "hall.h"
#include "net.h"
#include "filecmd.h"
#include "term.h"


// --------------------------------------------------------------------------
// Contents
//
// showconfig() 	displays user configuration
// showuser()		sysop fn to display any user's config.


// --------------------------------------------------------------------------
// showconfig(): Displays user configuration.

#define NUMOPTS 30
static void ShowToggles(LogEntry1 *Log1)
	{
	termCap(TERM_BOLD);
	rmPrintf(getmsg(875));
	termCap(TERM_NORMAL);
	doCR();

	int CurrentOption;
	const char *Options[NUMOPTS], *On[NUMOPTS], *Off[NUMOPTS];
	uint numOn = 0, numOff = 0;

	for (CurrentOption = 0; CurrentOption < 24; CurrentOption++)
		{
		Options[CurrentOption] = getmsg(CurrentOption + 802);
		}

	if (!Log1->IsExpert())
		{
		On[numOn++] = Options[0];
		}
	else
		{
		Off[numOff++] = Options[0];
		}

	if (Log1->IsOldToo())
		{
		On[numOn++] = Options[1];
		}
	else
		{
		Off[numOff++] = Options[1];
		}

	if (Log1->IsAutoNextHall())
		{
		On[numOn++] = Options[2];
		}
	else
		{
		Off[numOff++] = Options[2];
		}

	if (TI()loggedIn || showuser)
		{
		if (Log1->IsViewRoomDesc())
			{
			On[numOn++] = Options[3];
			}
		else
			{
			Off[numOff++] = Options[3];
			}
		}

	if (TI()loggedIn || showuser)
		{
		if (Log1->IsViewHallDescription())
			{
			On[numOn++] = Options[4];
			}
		else
			{
			Off[numOff++] = Options[4];
			}

		if (Log1->IsViewRoomInfoLines())
			{
			On[numOn++] = Options[5];
			}
		else
			{
			Off[numOff++] = Options[5];
			}
		}

	if (cfg.surnames || cfg.netsurname || cfg.titles || cfg.nettitles)
		{
		if (Log1->IsViewTitleSurname())
			{
			On[numOn++] = Options[6];
			}
		else
			{
			Off[numOff++] = Options[6];
			}
		}

	if (Log1->IsViewSubjects())
		{
		On[numOn++] = Options[7];
		}
	else
		{
		Off[numOff++] = Options[7];
		}

	if (Log1->IsViewSignatures())
		{
		On[numOn++] = Options[8];
		}
	else
		{
		Off[numOff++] = Options[8];
		}

	if (Log1->IsAutoVerbose())
		{
		On[numOn++] = Options[9];
		}
	else
		{
		Off[numOff++] = Options[9];
		}

	if (Log1->IsTwirly())
		{
		On[numOn++] = Options[10];
		}
	else
		{
		Off[numOff++] = Options[10];
		}

	if (Log1->IsPauseBetweenMessages())
		{
		On[numOn++] = Options[11];
		}
	else
		{
		Off[numOff++] = Options[11];
		}

	if (Log1->IsIBMANSI())
		{
		if (Log1->IsClearScreenBetweenMessages())
			{
			On[numOn++] = Options[12];
			}
		else
			{
			Off[numOff++] = Options[12];
			}
		}

	if (Log1->IsMinibin())
		{
		On[numOn++] = Options[13];
		}
	else
		{
		Off[numOff++] = Options[13];
		}

	if (Log1->IsVerboseContinue())
		{
		On[numOn++] = Options[14];
		}
	else
		{
		Off[numOff++] = Options[14];
		}

	if (cfg.censor)
		{
		if (Log1->IsViewCensoredMessages())
			{
			On[numOn++] = Options[15];
			}
		else
			{
			Off[numOff++] = Options[15];
			}
		}

	if (cfg.borders)
		{
		if (Log1->IsViewBorders())
			{
			On[numOn++] = Options[16];
			}
		else
			{
			Off[numOff++] = Options[16];
			}
		}

	if (!Log1->IsAutoVerbose())
		{
		if (Log1->IsVerboseLogOut())
			{
			On[numOn++] = Options[17];
			}
		else
			{
			Off[numOff++] = Options[17];
			}
		}

	if (Log1->IsYouAreHere())
		{
		On[numOn++] = Options[18];
		}
	else
		{
		Off[numOff++] = Options[18];
		}

	if (Log1->IsIBMGraph())
		{
		if (Log1->IsIBMRoom())
			{
			On[numOn++] = Options[19];
			}
		else
			{
			Off[numOff++] = Options[19];
			}
		}

	if (Log1->IsWideRoom())
		{
		On[numOn++] = Options[20];
		}
	else
		{
		Off[numOff++] = Options[20];
		}

	if (Log1->IsMusic())
		{
		On[numOn++] = Options[21];
		}
	else
		{
		Off[numOff++] = Options[21];
		}

	if (Log1->IsViewCommas())
		{
		On[numOn++] = Options[22];
		}
	else
		{
		Off[numOff++] = Options[22];
		}

	if (Log1->IsPUnPauses())
		{
		On[numOn++] = Options[23];
		}
	else
		{
		Off[numOff++] = Options[23];
		}

	rmPrintf(getmsg(876));

	prtList(LIST_START);

	for (CurrentOption = 0; CurrentOption < numOn; ++CurrentOption)
		{
		char stupid_stuff[81];

		if (On[CurrentOption] == Options[1])
			{
			sprintf(stupid_stuff, On[CurrentOption], cfg.Lmsg_nym);
			}
		else if (On[CurrentOption] == Options[2])
			{
			sprintf(stupid_stuff, On[CurrentOption], cfg.Lhall_nym);
			}
		else if (On[CurrentOption] == Options[3] ||
				On[CurrentOption] == Options[5])
			{
			sprintf(stupid_stuff, On[CurrentOption], cfg.Uroom_nym);
			}
		else if (On[CurrentOption] == Options[4])
			{
			sprintf(stupid_stuff, On[CurrentOption], cfg.Uhall_nym);
			}
		else if (On[CurrentOption] == Options[19])
			{
			sprintf(stupid_stuff, On[CurrentOption], cfg.Lroom_nym);
			}
		else if (On[CurrentOption] == Options[20])
			{
			sprintf(stupid_stuff, On[CurrentOption], cfg.Lrooms_nym);
			}
		else
			{
			sprintf(stupid_stuff, On[CurrentOption], cfg.Lmsgs_nym);
			}

		prtList(stupid_stuff);
		}

	prtList(LIST_END);

	rmPrintf(getmsg(878));

	prtList(LIST_START);

	for (CurrentOption = 0; CurrentOption < numOff; ++CurrentOption)
		{
		char stupid_stuff[81];

		if (Off[CurrentOption] == Options[1])
			{
			sprintf(stupid_stuff, Off[CurrentOption], cfg.Lmsg_nym);
			}
		else if (Off[CurrentOption] == Options[2])
			{
			sprintf(stupid_stuff, Off[CurrentOption], cfg.Lhall_nym);
			}
		else if (Off[CurrentOption] == Options[3] ||
				Off[CurrentOption] == Options[5])
			{
			sprintf(stupid_stuff, Off[CurrentOption], cfg.Uroom_nym);
			}
		else if (Off[CurrentOption] == Options[4])
			{
			sprintf(stupid_stuff, Off[CurrentOption], cfg.Uhall_nym);
			}
		else if (Off[CurrentOption] == Options[19])
			{
			sprintf(stupid_stuff, Off[CurrentOption], cfg.Lroom_nym);
			}
		else if (Off[CurrentOption] == Options[20])
			{
			sprintf(stupid_stuff, Off[CurrentOption], cfg.Lrooms_nym);
			}
		else
			{
			sprintf(stupid_stuff, Off[CurrentOption], cfg.Lmsgs_nym);
			}

		prtList(stupid_stuff);
		}

	prtList(LIST_END);
	}

void showconfig(l_slot LogSlot, Bool showuser)
	{
	g_slot CurrentGroup;
	label dProtocol;
	Bool in_a_group = FALSE;

	LogEntry1 *Log1 = new LogEntry1;
	LogEntry2 Log2(cfg.maxgroups);

	if (Log1 == NULL || !Log2.IsValid())
		{
		mPrintfCR(getmsg(188), getmsg(1287));

		delete Log1;
		return;
		}

	if (showuser)
		{
		// from .SS: load off disk.
		if (!Log1->Load(LogTab->GetEntry(LogSlot)->GetLogIndex()) ||
				!Log2.Load(LogTab->GetEntry(LogSlot)->GetLogIndex()))
			{
			delete Log1;
			return;
			}
		}
	else
		{
		// from .RC: use our current stuff.
		*Log1 = *TI()CurrentUser;
		Log2 = *TI()CurrentUser;
		doCR();
		}

	SetDoWhat(READCONFIG);

	TI()UserControl.SetOutFlag(OUTOK);

	if (TI()loggedIn || showuser)
		{
		doCR();
		termCap(TERM_BOLD);
		rmPrintf(getmsg(872), cfg.Uuser_nym);
		termCap(TERM_NORMAL);
		doCR();

		if (cfg.titles && *Log1->GetTitle() && Log1->IsViewTitleSurname())
			{
			rmPrintf(getmsg(79), Log1->GetTitle());
			}

		rmPrintf(getmsg(81), Log1->GetName());

		if (cfg.surnames && *Log1->GetSurname() && Log1->IsViewTitleSurname())
			{
			rmPrintf(getmsg(93), Log1->GetSurname());
			}

		if (*Log1->GetPhoneNumber() || *Log1->GetRealName())
			{
			doCR();
			if (*Log1->GetRealName())
				{
				rmPrintf(getmsg(81), Log1->GetRealName());
				}

			if (*Log1->GetPhoneNumber())
				{
				rmPrintf(*Log1->GetRealName() ? getmsg(82) : getmsg(81),
						Log1->GetPhoneNumber());
				}
			}

		if (*Log1->GetMailAddr1() || *Log1->GetMailAddr2() ||
				*Log1->GetMailAddr3())
			{
			if (*Log1->GetMailAddr1())
				{
				doCR();
				rmPrintf(getmsg(81), Log1->GetMailAddr1());
				}

			if (*Log1->GetMailAddr2())
				{
				doCR();
				rmPrintf(getmsg(81), Log1->GetMailAddr2());
				}

			if (*Log1->GetMailAddr3())
				{
				doCR();
				rmPrintf(getmsg(81), Log1->GetMailAddr3());
				}
			}

		doCR();
		}

	TI()UserControl.ResetOutParagraph();

	doCR();
	termCap(TERM_BOLD);
	rmPrintf(getmsg(873));
	termCap(TERM_NORMAL);
	doCR();

	if (	Log1->IsUnlisted()		|| Log1->IsSysop() ||
			Log1->IsAide()			|| Log1->IsNetUser() ||
			Log1->IsNode()			|| Log1->IsDungeoned() ||
			Log1->IsPermanent())
		{
		if (Log1->IsNode()) 		rmPrintf(getmsg(86));
		if (Log1->IsAide()) 		rmPrintf(getmsg(90));
		if (Log1->IsSysop())		rmPrintf(getmsg(91));
		if (Log1->IsDungeoned())	rmPrintf(getmsg(92));
		if (Log1->IsNetUser())		rmPrintf(getmsg(122));
		if (Log1->IsUnlisted()) 	rmPrintf(getmsg(123));
		if (Log1->IsPermanent())	rmPrintf(getmsg(124));
		doCR();
		}

	rmPrintf(getmsg(874), cfg.Ugroups_nym);

	prtList(LIST_START);
	for (CurrentGroup = 0; CurrentGroup < cfg.maxgroups; ++CurrentGroup)
		{
		if (
				GroupData->GetEntry(CurrentGroup)->IsInuse() &&

				(Log2.IsInGroup(CurrentGroup) ||
				Log1->IsMainSysop()))
			{
			prtList(GroupData->GetEntry(CurrentGroup)->GetName());
			in_a_group = TRUE;
			}
		}
	prtList(LIST_END);

	if (!in_a_group)
		{
		doCR();
		}

	doCR();

	ShowToggles(Log1);

	if (*Log1->GetForwardAddr())
		{
		rmPrintf(getmsg(799), cfg.Lmsgs_nym);

		if (!Log1->IsForwardToNode())
			{
			if (FindPersonByName(Log1->GetForwardAddr()) != CERROR)
				{
				rmPrintf(pcts, Log1->GetForwardAddr());
				}
			}
		else
			{
			rmPrintf(getmsg(101), Log1->GetForwardAddr(),
					Log1->GetForwardAddrNode());
			}
		doCR();
		}

	rmPrintf(getmsg(1126), makeaddress(Log1->GetAlias(), Log1->GetLocID()));
	doCR();

	if (*Log1->GetDefaultHall())
		{
		h_slot CurrentHall;

		rmPrintf(getmsg(879), cfg.Lhall_nym);

		for (CurrentHall = 1; CurrentHall < cfg.maxhalls; ++CurrentHall)
			{
			if (HallData->GetEntry(CurrentHall)->IsInuse() &&
					SameString(HallData->GetEntry(CurrentHall)->GetName(),
					Log1->GetDefaultHall()))
				{
				if (TI()CurrentUser->CanAccessHall(CurrentHall))
					{
					rmPrintf(pcts, HallData->GetEntry(CurrentHall)->GetName());
					}
				}
			}
		doCR();
		}

	if (Log1->GetDefaultProtocol())
		{
		const protocols *theProt = GetProtocolByKey(Log1->GetDefaultProtocol());

		if (theProt)
			{
			CopyStringToBuffer(dProtocol, theProt->name, LABELSIZE);
			}
		else
			{
			dProtocol[0] = 0;
			}
		}
	else
		{
		dProtocol[0] = 0;
		}

	if (dProtocol[0])
		{
		rmPrintf(getmsg(880), dProtocol);
		doCR();
		}

	rmPrintf(getmsg(881), (TI()loggedIn || showuser) ?
			Log1->GetNetPrefix() : cfg.netPrefix);
	doCR();

	rmPrintf(getmsg(882), (TI()loggedIn || showuser) ?
			Log1->GetPromptFormat() : cfg.prompt);
	doCR();

	rmPrintf(getmsg(883), (TI()loggedIn || showuser) ?
			Log1->GetDateStamp() : cfg.datestamp);
	doCR();

	rmPrintf(getmsg(884), (TI()loggedIn || showuser) ?
			Log1->GetVerboseDateStamp() : cfg.vdatestamp);
	doCR();

	if ((TI()loggedIn || showuser) && *Log1->GetSignature())
		{
		rmPrintf(getmsg(885), Log1->GetSignature());
		doCR();
		}

	TI()UserControl.ResetOutParagraph();

	doCR();
	termCap(TERM_BOLD);
	rmPrintf(getmsg(886));
	termCap(TERM_NORMAL);
	doCR();

	rmPrintf(getmsg(887), Log1->IsIBMANSI() ? getmsg(317) : getmsg(316),
			Log1->IsIBMColor() ? getmsg(317) : getmsg(316),
			Log1->IsIBMGraph() ? "en" : "dis");
	doCR();

	rmPrintf(getmsg(888));
	doCR();

	rmPrintf(getmsg(800), ltoac(Log1->GetWidth()));

	if (Log1->IsUpperOnly())
		{
		rmPrintf(getmsg(801));
		}

	rmPrintf(getmsg(104), Log1->IsLinefeeds() ? "L" : "No l");

	if (Log1->GetLinesPerScreen())
		{
		rmPrintf(getmsg(891), ltoac(Log1->GetLinesPerScreen()));
		}

	if (Log1->GetNulls())
		{
		rmPrintf(getmsg(892), ltoac(Log1->GetNulls()));
		}

	rmPrintf(getmsg(125), Log1->IsTabs() ? "T" : "No t");
	doCR();

	rmPrintf(getmsg(1288), (TI()loggedIn || showuser) ?
			Log1->GetMorePrompt() : cfg.moreprompt);
	doCR();

	if (cfg.accounting && Log1->IsAccounting())
		{
		long C = Log1->GetCredits() / 60;

		rmPrintf(getmsg(889), ltoac(C),
				(C == 1) ? cfg.Lcredit_nym : cfg.Lcredits_nym);
		doCR();
		}

	if (showuser || (TI()MRO.Verbose && Log1->GetPoopcount()))
		{
		rmPrintf(getmsg(890), ltoac(Log1->GetPoopcount()));
		doCR();
		}

	if (Log1->IsNode())
		{
		NodeCitInfo *nd = NULL;

		TI()UserControl.ResetOutParagraph();

		doCR();

		if (getnode(&nd, Log1->GetName(), NOMODCON, TRUE))
			{
			shownode(nd, TRUE);
			}
		else
			{
			rmPrintf(getmsg(127));
			doCR();
			}

		freeNode(&nd);
		}

	delete Log1;
	}


// --------------------------------------------------------------------------
// showuser(): Sysop fn to display any user's config.

void showuser(void)
	{
	label who;
	int logno;

	SetDoWhat(SYSSHOW);

	do
		{
		getString(getmsg(599), who, LABELSIZE, TRUE, ECHO,
				TI()loggedIn ? TI()CurrentUser->GetName() : ns);

		if (*who == '?')
			{
			ListUsers(TI()CurrentUser->IsAide());
			}
		} while (*who == '?');

	normalizeString(who);

	if (*who)
		{
		if (TI()loggedIn &&
				SameString(who, TI()CurrentUser->GetName()))
			{
			showconfig(TI()ThisSlot, TRUE);
			}
		else
			{
			logno = FindPersonByPartialName(who);

			if (logno == CERROR)
				{
				CRmPrintfCR(getmsg(595), who);
				}
			else
				{
				showconfig(logno, TRUE);
				}
			}
		}
	}
